/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.reflection;

import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.ModelMethod;
import android.databinding.tool.util.L;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SdkUtil {
    static ApiChecker sApiChecker;
    static int sMinSdk;

    public static void initialize(int minSdk, File sdkPath) {
        sMinSdk = minSdk;
        sApiChecker = new ApiChecker(new File(sdkPath.getAbsolutePath() + "/platform-tools/api/api-versions.xml"));
        L.d("SdkUtil init, minSdk: %s", minSdk);
    }

    public static int getMinApi(ModelClass modelClass) {
        return sApiChecker.getMinApi(modelClass.getJniDescription(), null);
    }

    public static int getMinApi(ModelMethod modelMethod) {
        Preconditions.checkNotNull(sApiChecker, "should've initialized api checker");
        for (ModelClass declaringClass = modelMethod.getDeclaringClass(); declaringClass != null; declaringClass = declaringClass.getSuperclass()) {
            String classDesc = declaringClass.getJniDescription();
            String methodDesc = modelMethod.getJniDescription();
            int result = sApiChecker.getMinApi(classDesc, methodDesc);
            L.d("checking method api for %s, class:%s method:%s. result: %d", modelMethod.getName(), classDesc, methodDesc, result);
            if (result <= 1) continue;
            return result;
        }
        return 1;
    }

    static class ApiChecker {
        private Map<String, Integer> mFullLookup = new HashMap<String, Integer>();
        private Document mDoc;
        private XPath mXPath;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ApiChecker(File apiFile) {
            InputStream inputStream = null;
            try {
                inputStream = apiFile == null || !apiFile.exists() ? this.getClass().getClassLoader().getResourceAsStream("api-versions.xml") : FileUtils.openInputStream(apiFile);
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                this.mDoc = builder.parse(inputStream);
                XPathFactory xPathFactory = XPathFactory.newInstance();
                this.mXPath = xPathFactory.newXPath();
                this.buildFullLookup();
            }
            catch (Throwable t) {
                try {
                    L.e(t, "cannot load api descriptions from %s", apiFile);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly(inputStream);
            }
            IOUtils.closeQuietly(inputStream);
        }

        private void buildFullLookup() throws XPathExpressionException {
            NodeList allClasses = this.mDoc.getChildNodes().item(0).getChildNodes();
            for (int j = 0; j < allClasses.getLength(); ++j) {
                Node node = allClasses.item(j);
                if (node.getNodeType() != 1 || !"class".equals(node.getNodeName())) continue;
                int classSince = ApiChecker.getSince(node);
                String classDesc = node.getAttributes().getNamedItem("name").getNodeValue();
                NodeList childNodes = node.getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    int methodSince;
                    int since;
                    Node child = childNodes.item(i);
                    if (child.getNodeType() != 1 || !"method".equals(child.getNodeName()) || (since = Math.max(classSince, methodSince = ApiChecker.getSince(child))) <= sMinSdk) continue;
                    String methodDesc = child.getAttributes().getNamedItem("name").getNodeValue();
                    String key = ApiChecker.cacheKey(classDesc, methodDesc);
                    this.mFullLookup.put(key, since);
                }
            }
        }

        public int getMinApi(String classDesc, String methodOrFieldDesc) {
            if (this.mDoc == null || this.mXPath == null) {
                return 1;
            }
            if (classDesc == null || classDesc.isEmpty()) {
                return 1;
            }
            String key = ApiChecker.cacheKey(classDesc, methodOrFieldDesc);
            Integer since = this.mFullLookup.get(key);
            return since == null ? 1 : since;
        }

        private static String cacheKey(String classDesc, String methodOrFieldDesc) {
            return classDesc + "~" + methodOrFieldDesc;
        }

        private static int getSince(Node node) {
            String nodeValue;
            Node since = node.getAttributes().getNamedItem("since");
            if (since != null && (nodeValue = since.getNodeValue()) != null && !nodeValue.isEmpty()) {
                try {
                    return Integer.parseInt(nodeValue);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return 1;
        }
    }
}

