Contributing to ansible-modules-extras
======================================

The Ansible Extras Modules are written and maintained by the Ansible community, according to the following contribution guidelines. 

If you'd like to contribute code
================================

Please see [this web page](http://docs.ansible.com/community.html) for information about the contribution process. Important license agreement information is also included on that page.

If you'd like to contribute code to an existing module
======================================================
Each module in Extras is maintained by the owner of that module; each module's owner is indicated in the documentation section of the module itself. Any pull request for a module that is given a "shipit" by the owner in the comments will be merged by the Ansible team.

If you'd like to contribute a new module
========================================
Ansible welcomes new modules. Please be certain that you've read the [module maintainer guide and standards](./GUIDELINES.md) thoroughly before submitting your module.

The Ansible community reviews new modules as often as possible, but please be patient; there are a lot of new module submissions in the pipeline, and it takes time to evaluate a new module for its adherence to module standards.

Once your module is accepted, you become responsible for maintenance of that module, which means responding to pull requests and issues in a reasonably timely manner. 

If you'd like to ask a question
===============================

Please see [this web page ](http://docs.ansible.com/community.html) for community information, which includes pointers on how to ask questions on the [mailing lists](http://docs.ansible.com/community.html#mailing-list-information) and IRC.  

The Github issue tracker is not the best place for questions for various reasons, but both IRC and the mailing list are very helpful places for those things, and that page has the pointers to those.

If you'd like to file a bug
===========================

Read the community page above, but in particular, make sure you copy [this issue template](https://github.com/ansible/ansible-modules-extras/blob/devel/.github/ISSUE_TEMPLATE.md) into your ticket description.  We have a friendly neighborhood bot that will remind you if you forget :)  This template helps us organize tickets faster and prevents asking some repeated questions, so it's very helpful to us and we appreciate your help with it.

Also please make sure you are testing on the latest released version of Ansible or the development branch.

Thanks!
