#!/usr/bin/python
from __future__ import absolute_import, division, print_function
# Copyright 2019-2021 Fortinet, Inc.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

__metaclass__ = type

ANSIBLE_METADATA = {'status': ['preview'],
                    'supported_by': 'community',
                    'metadata_version': '1.1'}

DOCUMENTATION = '''
---
module: fmgr_dlp_profile
short_description: no description
description:
    - This module is able to configure a FortiManager device.
    - Examples include all parameters and values which need to be adjusted to data sources before usage.

version_added: "1.0.0"
author:
    - Link Zheng (@chillancezen)
    - Jie Xue (@JieX19)
    - Frank Shen (@fshen01)
    - Hongbin Lu (@fgtdev-hblu)
notes:
    - Running in workspace locking mode is supported in this FortiManager module, the top
      level parameters workspace_locking_adom and workspace_locking_timeout help do the work.
    - To create or update an object, use state present directive.
    - To delete an object, use state absent directive.
    - Normally, running one module can fail when a non-zero rc is returned. you can also override
      the conditions to fail or succeed with parameters rc_failed and rc_succeeded

options:
    enable_log:
        description: Enable/Disable logging for task
        required: false
        type: bool
        default: false
    proposed_method:
        description: The overridden method for the underlying Json RPC request
        required: false
        type: str
        choices:
          - update
          - set
          - add
    bypass_validation:
        description: |
          only set to True when module schema diffs with FortiManager API structure,
           module continues to execute without validating parameters
        required: false
        type: bool
        default: false
    workspace_locking_adom:
        description: |
          the adom to lock for FortiManager running in workspace mode, the value can be global and others including root
        required: false
        type: str
    workspace_locking_timeout:
        description: the maximum time in seconds to wait for other user to release the workspace lock
        required: false
        type: int
        default: 300
    state:
        description: the directive to create, update or delete an object
        type: str
        required: true
        choices:
          - present
          - absent
    rc_succeeded:
        description: the rc codes list with which the conditions to succeed will be overriden
        type: list
        required: false
    rc_failed:
        description: the rc codes list with which the conditions to fail will be overriden
        type: list
        required: false
    adom:
        description: the parameter (adom) in requested url
        type: str
        required: true
    dlp_profile:
        description: the top level parameters set
        required: false
        type: dict
        suboptions:
            comment:
                type: str
                description: no description
            dlp-log:
                type: str
                description: no description
                choices:
                    - 'disable'
                    - 'enable'
            extended-log:
                type: str
                description: no description
                choices:
                    - 'disable'
                    - 'enable'
            feature-set:
                type: str
                description: no description
                choices:
                    - 'flow'
                    - 'proxy'
            full-archive-proto:
                description: description
                type: list
                choices:
                 - smtp
                 - pop3
                 - imap
                 - http-post
                 - http-get
                 - ftp
                 - nntp
                 - mapi
                 - ssh
                 - cifs
            nac-quar-log:
                type: str
                description: no description
                choices:
                    - 'disable'
                    - 'enable'
            name:
                type: str
                description: no description
            replacemsg-group:
                type: str
                description: no description
            rule:
                description: description
                type: list
                suboptions:
                    action:
                        type: str
                        description: no description
                        choices:
                            - 'log-only'
                            - 'block'
                            - 'quarantine-ip'
                            - 'allow'
                    archive:
                        type: str
                        description: no description
                        choices:
                            - 'disable'
                            - 'enable'
                    expiry:
                        type: str
                        description: no description
                    file-size:
                        type: int
                        description: no description
                    file-type:
                        type: str
                        description: no description
                    filter-by:
                        type: str
                        description: no description
                        choices:
                            - 'fingerprint'
                            - 'sensor'
                            - 'encrypted'
                            - 'none'
                            - 'mip'
                    id:
                        type: int
                        description: no description
                    label:
                        type: str
                        description: no description
                    match-percentage:
                        type: int
                        description: no description
                    name:
                        type: str
                        description: no description
                    proto:
                        description: description
                        type: list
                        choices:
                         - smtp
                         - pop3
                         - imap
                         - http-post
                         - http-get
                         - ftp
                         - nntp
                         - mapi
                         - ssh
                         - cifs
                    sensitivity:
                        description: description
                        type: str
                    sensor:
                        description: description
                        type: str
                    severity:
                        type: str
                        description: no description
                        choices:
                            - 'info'
                            - 'low'
                            - 'medium'
                            - 'high'
                            - 'critical'
                    type:
                        type: str
                        description: no description
                        choices:
                            - 'file'
                            - 'message'
            summary-proto:
                description: description
                type: list
                choices:
                 - smtp
                 - pop3
                 - imap
                 - http-post
                 - http-get
                 - ftp
                 - nntp
                 - mapi
                 - ssh
                 - cifs

'''

EXAMPLES = '''
 - hosts: fortimanager-inventory
   collections:
     - fortinet.fortimanager
   connection: httpapi
   vars:
      ansible_httpapi_use_ssl: True
      ansible_httpapi_validate_certs: False
      ansible_httpapi_port: 443
   tasks:
    - name: no description
      fmgr_dlp_profile:
         bypass_validation: False
         workspace_locking_adom: <value in [global, custom adom including root]>
         workspace_locking_timeout: 300
         rc_succeeded: [0, -2, -3, ...]
         rc_failed: [-2, -3, ...]
         adom: <your own value>
         state: <value in [present, absent]>
         dlp_profile:
            comment: <value of string>
            dlp-log: <value in [disable, enable]>
            extended-log: <value in [disable, enable]>
            feature-set: <value in [flow, proxy]>
            full-archive-proto:
              - smtp
              - pop3
              - imap
              - http-post
              - http-get
              - ftp
              - nntp
              - mapi
              - ssh
              - cifs
            nac-quar-log: <value in [disable, enable]>
            name: <value of string>
            replacemsg-group: <value of string>
            rule:
              -
                  action: <value in [log-only, block, quarantine-ip, ...]>
                  archive: <value in [disable, enable]>
                  expiry: <value of string>
                  file-size: <value of integer>
                  file-type: <value of string>
                  filter-by: <value in [fingerprint, sensor, encrypted, ...]>
                  id: <value of integer>
                  label: <value of string>
                  match-percentage: <value of integer>
                  name: <value of string>
                  proto:
                    - smtp
                    - pop3
                    - imap
                    - http-post
                    - http-get
                    - ftp
                    - nntp
                    - mapi
                    - ssh
                    - cifs
                  sensitivity: <value of string>
                  sensor: <value of string>
                  severity: <value in [info, low, medium, ...]>
                  type: <value in [file, message]>
            summary-proto:
              - smtp
              - pop3
              - imap
              - http-post
              - http-get
              - ftp
              - nntp
              - mapi
              - ssh
              - cifs

'''

RETURN = '''
request_url:
    description: The full url requested
    returned: always
    type: str
    sample: /sys/login/user
response_code:
    description: The status of api request
    returned: always
    type: int
    sample: 0
response_message:
    description: The descriptive message of the api response
    type: str
    returned: always
    sample: OK.

'''
from ansible.module_utils.basic import AnsibleModule
from ansible.module_utils.connection import Connection
from ansible_collections.fortinet.fortimanager.plugins.module_utils.napi import NAPIManager
from ansible_collections.fortinet.fortimanager.plugins.module_utils.napi import check_galaxy_version
from ansible_collections.fortinet.fortimanager.plugins.module_utils.napi import check_parameter_bypass


def main():
    jrpc_urls = [
        '/pm/config/global/obj/dlp/profile',
        '/pm/config/adom/{adom}/obj/dlp/profile'
    ]

    perobject_jrpc_urls = [
        '/pm/config/global/obj/dlp/profile/{profile}',
        '/pm/config/adom/{adom}/obj/dlp/profile/{profile}'
    ]

    url_params = ['adom']
    module_primary_key = 'name'
    module_arg_spec = {
        'enable_log': {
            'type': 'bool',
            'required': False,
            'default': False
        },
        'forticloud_access_token': {
            'type': 'str',
            'required': False,
            'no_log': True
        },
        'proposed_method': {
            'type': 'str',
            'required': False,
            'choices': [
                'set',
                'update',
                'add'
            ]
        },
        'bypass_validation': {
            'type': 'bool',
            'required': False,
            'default': False
        },
        'workspace_locking_adom': {
            'type': 'str',
            'required': False
        },
        'workspace_locking_timeout': {
            'type': 'int',
            'required': False,
            'default': 300
        },
        'rc_succeeded': {
            'required': False,
            'type': 'list'
        },
        'rc_failed': {
            'required': False,
            'type': 'list'
        },
        'state': {
            'type': 'str',
            'required': True,
            'choices': [
                'present',
                'absent'
            ]
        },
        'adom': {
            'required': True,
            'type': 'str'
        },
        'dlp_profile': {
            'required': False,
            'type': 'dict',
            'revision': {
                '7.2.0': True
            },
            'options': {
                'comment': {
                    'required': False,
                    'revision': {
                        '7.2.0': True
                    },
                    'type': 'str'
                },
                'dlp-log': {
                    'required': False,
                    'revision': {
                        '7.2.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'extended-log': {
                    'required': False,
                    'revision': {
                        '7.2.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'feature-set': {
                    'required': False,
                    'revision': {
                        '7.2.0': True
                    },
                    'choices': [
                        'flow',
                        'proxy'
                    ],
                    'type': 'str'
                },
                'full-archive-proto': {
                    'required': False,
                    'revision': {
                        '7.2.0': True
                    },
                    'type': 'list',
                    'choices': [
                        'smtp',
                        'pop3',
                        'imap',
                        'http-post',
                        'http-get',
                        'ftp',
                        'nntp',
                        'mapi',
                        'ssh',
                        'cifs'
                    ]
                },
                'nac-quar-log': {
                    'required': False,
                    'revision': {
                        '7.2.0': True
                    },
                    'choices': [
                        'disable',
                        'enable'
                    ],
                    'type': 'str'
                },
                'name': {
                    'required': True,
                    'revision': {
                        '7.2.0': True
                    },
                    'type': 'str'
                },
                'replacemsg-group': {
                    'required': False,
                    'revision': {
                        '7.2.0': True
                    },
                    'type': 'str'
                },
                'rule': {
                    'required': False,
                    'revision': {
                        '7.2.0': True
                    },
                    'type': 'list',
                    'options': {
                        'action': {
                            'required': False,
                            'revision': {
                                '7.2.0': True
                            },
                            'choices': [
                                'log-only',
                                'block',
                                'quarantine-ip',
                                'allow'
                            ],
                            'type': 'str'
                        },
                        'archive': {
                            'required': False,
                            'revision': {
                                '7.2.0': True
                            },
                            'choices': [
                                'disable',
                                'enable'
                            ],
                            'type': 'str'
                        },
                        'expiry': {
                            'required': False,
                            'revision': {
                                '7.2.0': True
                            },
                            'type': 'str'
                        },
                        'file-size': {
                            'required': False,
                            'revision': {
                                '7.2.0': True
                            },
                            'type': 'int'
                        },
                        'file-type': {
                            'required': False,
                            'revision': {
                                '7.2.0': True
                            },
                            'type': 'str'
                        },
                        'filter-by': {
                            'required': False,
                            'revision': {
                                '7.2.0': True
                            },
                            'choices': [
                                'fingerprint',
                                'sensor',
                                'encrypted',
                                'none',
                                'mip'
                            ],
                            'type': 'str'
                        },
                        'id': {
                            'required': False,
                            'revision': {
                                '7.2.0': True
                            },
                            'type': 'int'
                        },
                        'label': {
                            'required': False,
                            'revision': {
                                '7.2.0': True
                            },
                            'type': 'str'
                        },
                        'match-percentage': {
                            'required': False,
                            'revision': {
                                '7.2.0': True
                            },
                            'type': 'int'
                        },
                        'name': {
                            'required': False,
                            'revision': {
                                '7.2.0': True
                            },
                            'type': 'str'
                        },
                        'proto': {
                            'required': False,
                            'revision': {
                                '7.2.0': True
                            },
                            'type': 'list',
                            'choices': [
                                'smtp',
                                'pop3',
                                'imap',
                                'http-post',
                                'http-get',
                                'ftp',
                                'nntp',
                                'mapi',
                                'ssh',
                                'cifs'
                            ]
                        },
                        'sensitivity': {
                            'required': False,
                            'revision': {
                                '7.2.0': True
                            },
                            'type': 'str'
                        },
                        'sensor': {
                            'required': False,
                            'revision': {
                                '7.2.0': True
                            },
                            'type': 'str'
                        },
                        'severity': {
                            'required': False,
                            'revision': {
                                '7.2.0': True
                            },
                            'choices': [
                                'info',
                                'low',
                                'medium',
                                'high',
                                'critical'
                            ],
                            'type': 'str'
                        },
                        'type': {
                            'required': False,
                            'revision': {
                                '7.2.0': True
                            },
                            'choices': [
                                'file',
                                'message'
                            ],
                            'type': 'str'
                        }
                    }
                },
                'summary-proto': {
                    'required': False,
                    'revision': {
                        '7.2.0': True
                    },
                    'type': 'list',
                    'choices': [
                        'smtp',
                        'pop3',
                        'imap',
                        'http-post',
                        'http-get',
                        'ftp',
                        'nntp',
                        'mapi',
                        'ssh',
                        'cifs'
                    ]
                }
            }

        }
    }

    params_validation_blob = []
    check_galaxy_version(module_arg_spec)
    module = AnsibleModule(argument_spec=check_parameter_bypass(module_arg_spec, 'dlp_profile'),
                           supports_check_mode=False)

    fmgr = None
    if module._socket_path:
        connection = Connection(module._socket_path)
        connection.set_option('enable_log', module.params['enable_log'] if 'enable_log' in module.params else False)
        connection.set_option('forticloud_access_token',
                              module.params['forticloud_access_token'] if 'forticloud_access_token' in module.params else None)
        fmgr = NAPIManager(jrpc_urls, perobject_jrpc_urls, module_primary_key, url_params, module, connection, top_level_schema_name='data')
        fmgr.validate_parameters(params_validation_blob)
        fmgr.process_curd(argument_specs=module_arg_spec)
    else:
        module.fail_json(msg='MUST RUN IN HTTPAPI MODE')
    module.exit_json(meta=module.params)


if __name__ == '__main__':
    main()
