/* Copyright (C) 2013-2016, The Regents of The University of Michigan.
All rights reserved.

This software was developed in the APRIL Robotics Lab under the
direction of Edwin Olson, ebolson@umich.edu. This software may be
available under alternative licensing terms; contact the address above.

An unlimited license is granted to use, adapt, modify, or embed the 2D
barcodes into any medium.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of the Regents of The University of Michigan.
*/

#include <stdlib.h>
#include "apriltag.h"

apriltag_family_t *tag36h10_create()
{
   apriltag_family_t *tf = calloc(1, sizeof(apriltag_family_t));
   tf->name = strdup("tag36h10");
   tf->black_border = 1;
   tf->d = 6;
   tf->h = 10;
   tf->ncodes = 2320; //2320;
   tf->codes = calloc(2320, sizeof(uint64_t));
   tf->codes[0] = 0x00000001ca92a687UL;
   tf->codes[1] = 0x000000020521ac4cUL;
   tf->codes[2] = 0x000000027a3fb7d6UL;
   tf->codes[3] = 0x00000002b4cebd9bUL;
   tf->codes[4] = 0x00000003647bceeaUL;
   tf->codes[5] = 0x000000039f0ad4afUL;
   tf->codes[6] = 0x00000003d999da74UL;
   tf->codes[7] = 0x000000044eb7e5feUL;
   tf->codes[8] = 0x0000000538f3fd12UL;
   tf->codes[9] = 0x00000005738302d7UL;
   tf->codes[10] = 0x000000065dbf19ebUL;
   tf->codes[11] = 0x000000070d6c2b3aUL;
   tf->codes[12] = 0x00000007f7a8424eUL;
   tf->codes[13] = 0x0000000832374813UL;
   tf->codes[14] = 0x000000086cc64dd8UL;
   tf->codes[15] = 0x00000008a755539dUL;
   tf->codes[16] = 0x00000009570264ecUL;
   tf->codes[17] = 0x0000000991916ab1UL;
   tf->codes[18] = 0x0000000a06af763bUL;
   tf->codes[19] = 0x0000000ab65c878aUL;
   tf->codes[20] = 0x0000000b2b7a9314UL;
   tf->codes[21] = 0x0000000b660998d9UL;
   tf->codes[22] = 0x0000000bdb27a463UL;
   tf->codes[23] = 0x0000000cc563bb77UL;
   tf->codes[24] = 0x0000000e24bdde15UL;
   tf->codes[25] = 0x0000000ed46aef64UL;
   tf->codes[26] = 0x0000000f4988faeeUL;
   tf->codes[27] = 0x000000006e5417c7UL;
   tf->codes[28] = 0x0000000158902edbUL;
   tf->codes[29] = 0x00000001cdae3a65UL;
   tf->codes[30] = 0x0000000242cc45efUL;
   tf->codes[31] = 0x000000027d5b4bb4UL;
   tf->codes[32] = 0x00000002b7ea5179UL;
   tf->codes[33] = 0x000000032d085d03UL;
   tf->codes[34] = 0x00000003679762c8UL;
   tf->codes[35] = 0x00000003a226688dUL;
   tf->codes[36] = 0x00000003dcb56e52UL;
   tf->codes[37] = 0x000000048c627fa1UL;
   tf->codes[38] = 0x00000005769e96b5UL;
   tf->codes[39] = 0x00000006264ba804UL;
   tf->codes[40] = 0x0000000660daadc9UL;
   tf->codes[41] = 0x00000006d5f8b953UL;
   tf->codes[42] = 0x000000074b16c4ddUL;
   tf->codes[43] = 0x00000007fac3d62cUL;
   tf->codes[44] = 0x000000091f8ef305UL;
   tf->codes[45] = 0x000000095a1df8caUL;
   tf->codes[46] = 0x0000000994acfe8fUL;
   tf->codes[47] = 0x0000000a09cb0a19UL;
   tf->codes[48] = 0x0000000a445a0fdeUL;
   tf->codes[49] = 0x0000000a7ee915a3UL;
   tf->codes[50] = 0x0000000ab9781b68UL;
   tf->codes[51] = 0x0000000af407212dUL;
   tf->codes[52] = 0x0000000b69252cb7UL;
   tf->codes[53] = 0x0000000c8df04990UL;
   tf->codes[54] = 0x0000000d3d9d5adfUL;
   tf->codes[55] = 0x0000000d782c60a4UL;
   tf->codes[56] = 0x0000000f12158907UL;
   tf->codes[57] = 0x00000001d0c9ce43UL;
   tf->codes[58] = 0x000000020b58d408UL;
   tf->codes[59] = 0x00000002f594eb1cUL;
   tf->codes[60] = 0x00000003a541fc6bUL;
   tf->codes[61] = 0x0000000454ef0dbaUL;
   tf->codes[62] = 0x000000053f2b24ceUL;
   tf->codes[63] = 0x0000000629673be2UL;
   tf->codes[64] = 0x000000074e3258bbUL;
   tf->codes[65] = 0x00000008ad8c7b59UL;
   tf->codes[66] = 0x00000009d2579832UL;
   tf->codes[67] = 0x0000000a8204a981UL;
   tf->codes[68] = 0x0000000af722b50bUL;
   tf->codes[69] = 0x0000000b6c40c095UL;
   tf->codes[70] = 0x0000000ba6cfc65aUL;
   tf->codes[71] = 0x0000000f15311ce5UL;
   tf->codes[72] = 0x00000000748b3f83UL;
   tf->codes[73] = 0x00000000af1a4548UL;
   tf->codes[74] = 0x00000000e9a94b0dUL;
   tf->codes[75] = 0x00000002be217935UL;
   tf->codes[76] = 0x00000003e2ec960eUL;
   tf->codes[77] = 0x00000004cd28ad22UL;
   tf->codes[78] = 0x0000000507b7b2e7UL;
   tf->codes[79] = 0x000000054246b8acUL;
   tf->codes[80] = 0x000000057cd5be71UL;
   tf->codes[81] = 0x00000006a1a0db4aUL;
   tf->codes[82] = 0x00000006dc2fe10fUL;
   tf->codes[83] = 0x0000000876190972UL;
   tf->codes[84] = 0x000000099ae4264bUL;
   tf->codes[85] = 0x0000000abfaf4324UL;
   tf->codes[86] = 0x0000000c9427714cUL;
   tf->codes[87] = 0x0000000d09457cd6UL;
   tf->codes[88] = 0x0000000d43d4829bUL;
   tf->codes[89] = 0x0000000ea32ea539UL;
   tf->codes[90] = 0x0000000f52dbb688UL;
   tf->codes[91] = 0x0000000161e2ea75UL;
   tf->codes[92] = 0x0000000286ae074eUL;
   tf->codes[93] = 0x000000066a2d6963UL;
   tf->codes[94] = 0x00000008b3c3a315UL;
   tf->codes[95] = 0x00000008ee52a8daUL;
   tf->codes[96] = 0x0000000a131dc5b3UL;
   tf->codes[97] = 0x0000000e6bbb3352UL;
   tf->codes[98] = 0x0000000f55f74a66UL;
   tf->codes[99] = 0x0000000005a45bb5UL;
   tf->codes[100] = 0x000000007ac2673fUL;
   tf->codes[101] = 0x00000001da1c89ddUL;
   tf->codes[102] = 0x0000000289c99b2cUL;
   tf->codes[103] = 0x00000003ae94b805UL;
   tf->codes[104] = 0x000000050deedaa3UL;
   tf->codes[105] = 0x00000005830ce62dUL;
   tf->codes[106] = 0x00000005bd9bebf2UL;
   tf->codes[107] = 0x0000000632b9f77cUL;
   tf->codes[108] = 0x00000006e26708cbUL;
   tf->codes[109] = 0x0000000841c12b69UL;
   tf->codes[110] = 0x000000092bfd427dUL;
   tf->codes[111] = 0x00000009668c4842UL;
   tf->codes[112] = 0x00000009dbaa53ccUL;
   tf->codes[113] = 0x0000000b007570a5UL;
   tf->codes[114] = 0x0000000b3b04766aUL;
   tf->codes[115] = 0x0000000c25408d7eUL;
   tf->codes[116] = 0x0000000ea965ccf5UL;
   tf->codes[117] = 0x0000000f93a1e409UL;
   tf->codes[118] = 0x00000000434ef558UL;
   tf->codes[119] = 0x00000001681a1231UL;
   tf->codes[120] = 0x00000001dd381dbbUL;
   tf->codes[121] = 0x0000000302033a94UL;
   tf->codes[122] = 0x000000075aa0a833UL;
   tf->codes[123] = 0x000000092f18d65bUL;
   tf->codes[124] = 0x00000009a436e1e5UL;
   tf->codes[125] = 0x0000000a1954ed6fUL;
   tf->codes[126] = 0x0000000b78af100dUL;
   tf->codes[127] = 0x0000000bb33e15d2UL;
   tf->codes[128] = 0x0000000c62eb2721UL;
   tf->codes[129] = 0x00000000466a8936UL;
   tf->codes[130] = 0x00000000f6179a85UL;
   tf->codes[131] = 0x000000016b35a60fUL;
   tf->codes[132] = 0x0000000589440de9UL;
   tf->codes[133] = 0x00000006738024fdUL;
   tf->codes[134] = 0x0000000847f85325UL;
   tf->codes[135] = 0x00000009e1e17b88UL;
   tf->codes[136] = 0x0000000acc1d929cUL;
   tf->codes[137] = 0x0000000b06ac9861UL;
   tf->codes[138] = 0x0000000d5042d213UL;
   tf->codes[139] = 0x0000000fd468118aUL;
   tf->codes[140] = 0x00000000f9332e63UL;
   tf->codes[141] = 0x0000000342c96815UL;
   tf->codes[142] = 0x000000037d586ddaUL;
   tf->codes[143] = 0x0000000551d09c02UL;
   tf->codes[144] = 0x00000005c6eea78cUL;
   tf->codes[145] = 0x00000006017dad51UL;
   tf->codes[146] = 0x00000009354ffe17UL;
   tf->codes[147] = 0x00000009aa6e09a1UL;
   tf->codes[148] = 0x0000000a94aa20b5UL;
   tf->codes[149] = 0x0000000acf39267aUL;
   tf->codes[150] = 0x0000000bb9753d8eUL;
   tf->codes[151] = 0x0000000bf4044353UL;
   tf->codes[152] = 0x000000008730b6b7UL;
   tf->codes[153] = 0x00000001716ccdcbUL;
   tf->codes[154] = 0x000000022119df1aUL;
   tf->codes[155] = 0x00000003f5920d42UL;
   tf->codes[156] = 0x000000058f7b35a5UL;
   tf->codes[157] = 0x00000006b446527eUL;
   tf->codes[158] = 0x0000000972fa97baUL;
   tf->codes[159] = 0x00000009e818a344UL;
   tf->codes[160] = 0x0000000a5d36aeceUL;
   tf->codes[161] = 0x0000000d1beaf40aUL;
   tf->codes[162] = 0x0000000dcb980559UL;
   tf->codes[163] = 0x0000000f65812dbcUL;
   tf->codes[164] = 0x0000000139f95be4UL;
   tf->codes[165] = 0x00000006b761e65cUL;
   tf->codes[166] = 0x00000006f1f0ec21UL;
   tf->codes[167] = 0x0000000a605242acUL;
   tf->codes[168] = 0x0000000e43d1a4c1UL;
   tf->codes[169] = 0x000000029c6f1260UL;
   tf->codes[170] = 0x0000000386ab2974UL;
   tf->codes[171] = 0x00000004e6054c12UL;
   tf->codes[172] = 0x00000008c984ae27UL;
   tf->codes[173] = 0x000000097931bf76UL;
   tf->codes[174] = 0x00000009ee4fcb00UL;
   tf->codes[175] = 0x0000000d22221bc6UL;
   tf->codes[176] = 0x0000000e46ed389fUL;
   tf->codes[177] = 0x0000000ebc0b4429UL;
   tf->codes[178] = 0x00000006f82813ddUL;
   tf->codes[179] = 0x0000000732b719a2UL;
   tf->codes[180] = 0x00000009072f47caUL;
   tf->codes[181] = 0x0000000941be4d8fUL;
   tf->codes[182] = 0x000000097c4d5354UL;
   tf->codes[183] = 0x00000009f16b5edeUL;
   tf->codes[184] = 0x0000000b8b548741UL;
   tf->codes[185] = 0x0000000d253dafa4UL;
   tf->codes[186] = 0x0000000d5fccb569UL;
   tf->codes[187] = 0x0000000d9a5bbb2eUL;
   tf->codes[188] = 0x0000000e4a08cc7dUL;
   tf->codes[189] = 0x00000003c77156f5UL;
   tf->codes[190] = 0x00000007aaf0b90aUL;
   tf->codes[191] = 0x0000000b53e1155aUL;
   tf->codes[192] = 0x0000000b8e701b1fUL;
   tf->codes[193] = 0x000000005c2b9448UL;
   tf->codes[194] = 0x000000014667ab5cUL;
   tf->codes[195] = 0x000000047a39fc22UL;
   tf->codes[196] = 0x00000004ef5807acUL;
   tf->codes[197] = 0x000000064eb22a4aUL;
   tf->codes[198] = 0x0000000982847b10UL;
   tf->codes[199] = 0x0000000aa74f97e9UL;
   tf->codes[200] = 0x0000000ae1de9daeUL;
   tf->codes[201] = 0x0000000b56fca938UL;
   tf->codes[202] = 0x0000000f750b1112UL;
   tf->codes[203] = 0x00000001bea14ac4UL;
   tf->codes[204] = 0x00000001f9305089UL;
   tf->codes[205] = 0x0000000233bf564eUL;
   tf->codes[206] = 0x000000031dfb6d62UL;
   tf->codes[207] = 0x00000003931978ecUL;
   tf->codes[208] = 0x000000052d02a14fUL;
   tf->codes[209] = 0x00000005a220acd9UL;
   tf->codes[210] = 0x0000000b1f893751UL;
   tf->codes[211] = 0x0000000fb2b5aab5UL;
   tf->codes[212] = 0x000000040b531854UL;
   tf->codes[213] = 0x00000005a53c40b7UL;
   tf->codes[214] = 0x00000008d90e917dUL;
   tf->codes[215] = 0x00000009139d9742UL;
   tf->codes[216] = 0x000000094e2c9d07UL;
   tf->codes[217] = 0x0000000d6c3b04e1UL;
   tf->codes[218] = 0x0000000e910621baUL;
   tf->codes[219] = 0x0000000f40b33309UL;
   tf->codes[220] = 0x00000001152b6131UL;
   tf->codes[221] = 0x000000032432951eUL;
   tf->codes[222] = 0x00000003d3dfa66dUL;
   tf->codes[223] = 0x000000065804e5e4UL;
   tf->codes[224] = 0x0000000ab0a25383UL;
   tf->codes[225] = 0x0000000b604f64d2UL;
   tf->codes[226] = 0x0000000de474a449UL;
   tf->codes[227] = 0x000000011846f50fUL;
   tf->codes[228] = 0x00000006d03e854cUL;
   tf->codes[229] = 0x00000007455c90d6UL;
   tf->codes[230] = 0x0000000ab3bde761UL;
   tf->codes[231] = 0x0000000dad013262UL;
   tf->codes[232] = 0x0000000e973d4976UL;
   tf->codes[233] = 0x00000002b54bb150UL;
   tf->codes[234] = 0x00000009577f58a1UL;
   tf->codes[235] = 0x00000009920e5e66UL;
   tf->codes[236] = 0x0000000b66868c8eUL;
   tf->codes[237] = 0x0000000f4a05eea3UL;
   tf->codes[238] = 0x00000003dd326207UL;
   tf->codes[239] = 0x00000005b1aa902fUL;
   tf->codes[240] = 0x000000099529f244UL;
   tf->codes[241] = 0x0000000b2f131aa7UL;
   tf->codes[242] = 0x0000000d038b48cfUL;
   tf->codes[243] = 0x0000000d3e1a4e94UL;
   tf->codes[244] = 0x000000024664cd82UL;
   tf->codes[245] = 0x000000036b2fea5bUL;
   tf->codes[246] = 0x000000095db6805dUL;
   tf->codes[247] = 0x0000000a0d6391acUL;
   tf->codes[248] = 0x0000000abd10a2fbUL;
   tf->codes[249] = 0x000000015f444a4cUL;
   tf->codes[250] = 0x00000002be9e6ceaUL;
   tf->codes[251] = 0x000000057d52b226UL;
   tf->codes[252] = 0x00000005f270bdb0UL;
   tf->codes[253] = 0x0000000b6fd94828UL;
   tf->codes[254] = 0x0000000879b19105UL;
   tf->codes[255] = 0x0000000d476d0a2eUL;
   tf->codes[256] = 0x0000000e6c382707UL;
   tf->codes[257] = 0x0000000dbfa6a996UL;
   tf->codes[258] = 0x00000001689705e6UL;
   tf->codes[259] = 0x00000003b22d3f98UL;
   tf->codes[260] = 0x0000000636527f0fUL;
   tf->codes[261] = 0x00000007d03ba772UL;
   tf->codes[262] = 0x0000000ee78d5a4dUL;
   tf->codes[263] = 0x0000000bf165a32aUL;
   tf->codes[264] = 0x0000000c2bf4a8efUL;
   tf->codes[265] = 0x0000000517be89f2UL;
   tf->codes[266] = 0x000000067718ac90UL;
   tf->codes[267] = 0x00000006b1a7b255UL;
   tf->codes[268] = 0x0000000726c5bddfUL;
   tf->codes[269] = 0x0000000bb9f23143UL;
   tf->codes[270] = 0x00000001375abbbbUL;
   tf->codes[271] = 0x0000000296b4de59UL;
   tf->codes[272] = 0x00000008893b745bUL;
   tf->codes[273] = 0x0000000a9842a848UL;
   tf->codes[274] = 0x0000000b827ebf5cUL;
   tf->codes[275] = 0x00000003840c894bUL;
   tf->codes[276] = 0x00000006b7deda11UL;
   tf->codes[277] = 0x0000000bc02958ffUL;
   tf->codes[278] = 0x000000055ba04b51UL;
   tf->codes[279] = 0x000000076aa77f3eUL;
   tf->codes[280] = 0x00000009b43db8f0UL;
   tf->codes[281] = 0x00000009eeccbeb5UL;
   tf->codes[282] = 0x0000000a295bc47aUL;
   tf->codes[283] = 0x0000000b4e26e153UL;
   tf->codes[284] = 0x0000000e476a2c54UL;
   tf->codes[285] = 0x00000006be1601cdUL;
   tf->codes[286] = 0x00000006f8a50792UL;
   tf->codes[287] = 0x000000097cca4709UL;
   tf->codes[288] = 0x0000000bc66080bbUL;
   tf->codes[289] = 0x00000001093a056eUL;
   tf->codes[290] = 0x00000006fbc09b70UL;
   tf->codes[291] = 0x0000000b8eed0ed4UL;
   tf->codes[292] = 0x0000000cee473172UL;
   tf->codes[293] = 0x000000023120b625UL;
   tf->codes[294] = 0x00000005da111275UL;
   tf->codes[295] = 0x0000000cf162c550UL;
   tf->codes[296] = 0x0000000ec8f68756UL;
   tf->codes[297] = 0x0000000b5db0c4a9UL;
   tf->codes[298] = 0x00000002b2ad1127UL;
   tf->codes[299] = 0x0000000536d2509eUL;
   tf->codes[300] = 0x00000009c9fec402UL;
   tf->codes[301] = 0x0000000c1394fdb4UL;
   tf->codes[302] = 0x000000006c326b53UL;
   tf->codes[303] = 0x00000005e99af5cbUL;
   tf->codes[304] = 0x0000000af1e574b9UL;
   tf->codes[305] = 0x0000000e6046cb44UL;
   tf->codes[306] = 0x0000000661d49533UL;
   tf->codes[307] = 0x00000008e5f9d4aaUL;
   tf->codes[308] = 0x0000000db3b54dd3UL;
   tf->codes[309] = 0x0000000e63625f22UL;
   tf->codes[310] = 0x0000000e9df164e7UL;
   tf->codes[311] = 0x0000000455e8f524UL;
   tf->codes[312] = 0x00000005b54317c2UL;
   tf->codes[313] = 0x0000000be258b389UL;
   tf->codes[314] = 0x000000054340a016UL;
   tf->codes[315] = 0x00000005b85eaba0UL;
   tf->codes[316] = 0x00000001284dcc1aUL;
   tf->codes[317] = 0x000000024d18e8f3UL;
   tf->codes[318] = 0x00000004d13e286aUL;
   tf->codes[319] = 0x00000008b4bd8a7fUL;
   tf->codes[320] = 0x0000000215a5770cUL;
   tf->codes[321] = 0x000000046572d87aUL;
   tf->codes[322] = 0x0000000c2c719ca4UL;
   tf->codes[323] = 0x00000004ddac77e2UL;
   tf->codes[324] = 0x0000000d19c94796UL;
   tf->codes[325] = 0x00000002d1c0d7d3UL;
   tf->codes[326] = 0x00000009ae8384e9UL;
   tf->codes[327] = 0x00000009e9128aaeUL;
   tf->codes[328] = 0x0000000ca7c6cfeaUL;
   tf->codes[329] = 0x0000000016282675UL;
   tf->codes[330] = 0x0000000ad985c97eUL;
   tf->codes[331] = 0x00000004af8bc195UL;
   tf->codes[332] = 0x00000009f580da26UL;
   tf->codes[333] = 0x0000000a6a9ee5b0UL;
   tf->codes[334] = 0x0000000bc9f9084eUL;
   tf->codes[335] = 0x0000000d63e230b1UL;
   tf->codes[336] = 0x0000000c4232a7b6UL;
   tf->codes[337] = 0x0000000d66fdc48fUL;
   tf->codes[338] = 0x0000000ec657e72dUL;
   tf->codes[339] = 0x0000000a364707a7UL;
   tf->codes[340] = 0x0000000f79208c5aUL;
   tf->codes[341] = 0x0000000de88a1f91UL;
   tf->codes[342] = 0x0000000574f9ddf6UL;
   tf->codes[343] = 0x000000065f35f50aUL;
   tf->codes[344] = 0x000000069ce08eadUL;
   tf->codes[345] = 0x0000000490f4ee9eUL;
   tf->codes[346] = 0x0000000c9282b88dUL;
   tf->codes[347] = 0x0000000752c4c7b8UL;
   tf->codes[348] = 0x0000000b364429cdUL;
   tf->codes[349] = 0x00000008b53a7e34UL;
   tf->codes[350] = 0x0000000be90ccefaUL;
   tf->codes[351] = 0x0000000b0507dfa2UL;
   tf->codes[352] = 0x000000000d525e90UL;
   tf->codes[353] = 0x00000005c549eecdUL;
   tf->codes[354] = 0x0000000e3bf5c446UL;
   tf->codes[355] = 0x0000000936c6d936UL;
   tf->codes[356] = 0x00000009747172d9UL;
   tf->codes[357] = 0x0000000ca843c39fUL;
   tf->codes[358] = 0x0000000d57f0d4eeUL;
   tf->codes[359] = 0x00000002d5595f66UL;
   tf->codes[360] = 0x0000000bfbb2462eUL;
   tf->codes[361] = 0x0000000266727b98UL;
   tf->codes[362] = 0x00000007ac679429UL;
   tf->codes[363] = 0x000000026fc53732UL;
   tf->codes[364] = 0x0000000656602d25UL;
   tf->codes[365] = 0x00000002eb1a6a78UL;
   tf->codes[366] = 0x00000004850392dbUL;
   tf->codes[367] = 0x0000000e5b098af2UL;
   tf->codes[368] = 0x0000000ab534c280UL;
   tf->codes[369] = 0x00000009ce143f4aUL;
   tf->codes[370] = 0x0000000f4b7cc9c2UL;
   tf->codes[371] = 0x0000000035b8e0d6UL;
   tf->codes[372] = 0x0000000871d5b08aUL;
   tf->codes[373] = 0x00000005b958930aUL;
   tf->codes[374] = 0x00000000b429a7faUL;
   tf->codes[375] = 0x000000054d8d431aUL;
   tf->codes[376] = 0x00000007d1b28291UL;
   tf->codes[377] = 0x0000000a1e645021UL;
   tf->codes[378] = 0x0000000b80da069dUL;
   tf->codes[379] = 0x0000000eef3b5d28UL;
   tf->codes[380] = 0x0000000263d3db6fUL;
   tf->codes[381] = 0x000000009592d503UL;
   tf->codes[382] = 0x00000004b9d86499UL;
   tf->codes[383] = 0x00000006c8df9886UL;
   tf->codes[384] = 0x0000000a3740ef11UL;
   tf->codes[385] = 0x0000000c4963b6dcUL;
   tf->codes[386] = 0x000000006da94672UL;
   tf->codes[387] = 0x000000053b64bf9bUL;
   tf->codes[388] = 0x0000000b2deb559dUL;
   tf->codes[389] = 0x0000000f116ab7b2UL;
   tf->codes[390] = 0x00000008ace1aa04UL;
   tf->codes[391] = 0x00000008ea8c43a7UL;
   tf->codes[392] = 0x00000006a4119dd3UL;
   tf->codes[393] = 0x000000099d54e8d4UL;
   tf->codes[394] = 0x0000000c969833d5UL;
   tf->codes[395] = 0x0000000f554c7911UL;
   tf->codes[396] = 0x00000003ade9e6b0UL;
   tf->codes[397] = 0x00000006e1bc3776UL;
   tf->codes[398] = 0x00000007916948c5UL;
   tf->codes[399] = 0x0000000dbe7ee48cUL;
   tf->codes[400] = 0x000000079484dca3UL;
   tf->codes[401] = 0x0000000f992e3a70UL;
   tf->codes[402] = 0x0000000884f81b73UL;
   tf->codes[403] = 0x0000000c68777d88UL;
   tf->codes[404] = 0x0000000603ee6fdaUL;
   tf->codes[405] = 0x0000000728b98cb3UL;
   tf->codes[406] = 0x0000000b12701684UL;
   tf->codes[407] = 0x0000000d5f21e414UL;
   tf->codes[408] = 0x0000000058652f15UL;
   tf->codes[409] = 0x00000002dc8a6e8cUL;
   tf->codes[410] = 0x00000004767396efUL;
   tf->codes[411] = 0x0000000b8dc549caUL;
   tf->codes[412] = 0x0000000f36b5a61aUL;
   tf->codes[413] = 0x00000000d09ece7dUL;
   tf->codes[414] = 0x0000000dda77175aUL;
   tf->codes[415] = 0x000000005e9c56d1UL;
   tf->codes[416] = 0x000000073e7a97c5UL;
   tf->codes[417] = 0x0000000b21f9f9daUL;
   tf->codes[418] = 0x0000000de3c9d2f4UL;
   tf->codes[419] = 0x000000069504ae32UL;
   tf->codes[420] = 0x000000077f40c546UL;
   tf->codes[421] = 0x0000000ed1217de6UL;
   tf->codes[422] = 0x00000003a1f88aedUL;
   tf->codes[423] = 0x0000000e623a9a18UL;
   tf->codes[424] = 0x00000000aeec67a8UL;
   tf->codes[425] = 0x0000000bea83aa19UL;
   tf->codes[426] = 0x000000092eeaf8bbUL;
   tf->codes[427] = 0x0000000a5d08d12eUL;
   tf->codes[428] = 0x0000000819a9bf38UL;
   tf->codes[429] = 0x0000000473d4f6c6UL;
   tf->codes[430] = 0x0000000b192431f5UL;
   tf->codes[431] = 0x0000000a6c92b484UL;
   tf->codes[432] = 0x00000007046885b5UL;
   tf->codes[433] = 0x0000000b9ab08cf7UL;
   tf->codes[434] = 0x0000000782d94cd9UL;
   tf->codes[435] = 0x0000000f158032faUL;
   tf->codes[436] = 0x0000000077f5e976UL;
   tf->codes[437] = 0x000000012dda2281UL;
   tf->codes[438] = 0x0000000e72417123UL;
   tf->codes[439] = 0x00000003056de487UL;
   tf->codes[440] = 0x0000000e3de9931aUL;
   tf->codes[441] = 0x0000000eb3079ea4UL;
   tf->codes[442] = 0x0000000e4420bad6UL;
   tf->codes[443] = 0x0000000439c2e4b6UL;
   tf->codes[444] = 0x000000047da4a615UL;
   tf->codes[445] = 0x00000000d7cfdda3UL;
   tf->codes[446] = 0x000000056afc5107UL;
   tf->codes[447] = 0x0000000e978c5f8bUL;
   tf->codes[448] = 0x00000005aede1266UL;
   tf->codes[449] = 0x0000000af1b79719UL;
   tf->codes[450] = 0x0000000f8b1b3239UL;
   tf->codes[451] = 0x000000075e8845dbUL;
   tf->codes[452] = 0x0000000bf1b4b93fUL;
   tf->codes[453] = 0x0000000fd5341b54UL;
   tf->codes[454] = 0x0000000a2373b2d3UL;
   tf->codes[455] = 0x00000005967e672bUL;
   tf->codes[456] = 0x0000000a2cc66e6dUL;
   tf->codes[457] = 0x0000000b17028581UL;
   tf->codes[458] = 0x0000000b54ad1f24UL;
   tf->codes[459] = 0x0000000e91d22b84UL;
   tf->codes[460] = 0x0000000de85c41f1UL;
   tf->codes[461] = 0x000000053d588e6fUL;
   tf->codes[462] = 0x0000000e9e407afcUL;
   tf->codes[463] = 0x0000000fc6272bb3UL;
   tf->codes[464] = 0x0000000a8ca0629aUL;
   tf->codes[465] = 0x0000000b86665d04UL;
   tf->codes[466] = 0x000000005a58fde9UL;
   tf->codes[467] = 0x00000001855b427eUL;
   tf->codes[468] = 0x0000000aabb42946UL;
   tf->codes[469] = 0x0000000e204ca78dUL;
   tf->codes[470] = 0x000000032897267bUL;
   tf->codes[471] = 0x00000000a78d7ae2UL;
   tf->codes[472] = 0x000000096536a598UL;
   tf->codes[473] = 0x0000000bf2aea0a9UL;
   tf->codes[474] = 0x00000000c9bcd56cUL;
   tf->codes[475] = 0x000000081eb921eaUL;
   tf->codes[476] = 0x00000002732fe125UL;
   tf->codes[477] = 0x00000002eb69808dUL;
   tf->codes[478] = 0x000000061f3bd153UL;
   tf->codes[479] = 0x00000008ddf0168fUL;
   tf->codes[480] = 0x0000000921d1d7eeUL;
   tf->codes[481] = 0x00000002bd48ca40UL;
   tf->codes[482] = 0x000000083ab154b8UL;
   tf->codes[483] = 0x00000005f436aee4UL;
   tf->codes[484] = 0x000000093dca0abcUL;
   tf->codes[485] = 0x000000026d75ad1eUL;
   tf->codes[486] = 0x0000000872a1ba54UL;
   tf->codes[487] = 0x0000000373a9f700UL;
   tf->codes[488] = 0x000000050d931f63UL;
   tf->codes[489] = 0x000000012d2f512cUL;
   tf->codes[490] = 0x0000000c6efdbb59UL;
   tf->codes[491] = 0x000000088e99ed22UL;
   tf->codes[492] = 0x0000000903b7f8acUL;
   tf->codes[493] = 0x0000000a9da1210fUL;
   tf->codes[494] = 0x0000000a2eba3d41UL;
   tf->codes[495] = 0x0000000fe9cd615cUL;
   tf->codes[496] = 0x0000000fb8911731UL;
   tf->codes[497] = 0x00000001cab3defcUL;
   tf->codes[498] = 0x0000000e6289b02dUL;
   tf->codes[499] = 0x000000066d6a35b6UL;
   tf->codes[500] = 0x0000000b0096a91aUL;
   tf->codes[501] = 0x0000000c9afcc532UL;
   tf->codes[502] = 0x000000080aebe5acUL;
   tf->codes[503] = 0x0000000d2f2e9768UL;
   tf->codes[504] = 0x0000000cc67edb56UL;
   tf->codes[505] = 0x0000000a51e37f35UL;
   tf->codes[506] = 0x00000006ac0eb6c3UL;
   tf->codes[507] = 0x00000006af2a4aa1UL;
   tf->codes[508] = 0x0000000e76290ecbUL;
   tf->codes[509] = 0x000000037e738db9UL;
   tf->codes[510] = 0x000000072d9b11c5UL;
   tf->codes[511] = 0x000000076e613f46UL;
   tf->codes[512] = 0x00000004f073278bUL;
   tf->codes[513] = 0x00000000e1eea307UL;
   tf->codes[514] = 0x0000000e9e8f9111UL;
   tf->codes[515] = 0x00000000793ee6f5UL;
   tf->codes[516] = 0x000000017304e15fUL;
   tf->codes[517] = 0x00000007a3361104UL;
   tf->codes[518] = 0x0000000731339958UL;
   tf->codes[519] = 0x00000008daa6a511UL;
   tf->codes[520] = 0x0000000a4037ef6bUL;
   tf->codes[521] = 0x0000000210896f2fUL;
   tf->codes[522] = 0x0000000afc535032UL;
   tf->codes[523] = 0x0000000e3025a0f8UL;
   tf->codes[524] = 0x000000063e21ba5fUL;
   tf->codes[525] = 0x00000003ebb5b8c8UL;
   tf->codes[526] = 0x0000000f9c6b06c3UL;
   tf->codes[527] = 0x0000000ca95ee37eUL;
   tf->codes[528] = 0x000000081f852bb4UL;
   tf->codes[529] = 0x0000000d6895d823UL;
   tf->codes[530] = 0x00000007040cca75UL;
   tf->codes[531] = 0x00000004d66ec391UL;
   tf->codes[532] = 0x00000004a216e588UL;
   tf->codes[533] = 0x000000051d6c18ceUL;
   tf->codes[534] = 0x000000047711c319UL;
   tf->codes[535] = 0x00000006ae7f794cUL;
   tf->codes[536] = 0x00000004abe694d7UL;
   tf->codes[537] = 0x0000000bc96f6f6eUL;
   tf->codes[538] = 0x000000057aa76cd2UL;
   tf->codes[539] = 0x0000000f948f2648UL;
   tf->codes[540] = 0x000000031bcd1bc3UL;
   tf->codes[541] = 0x000000094c7b3f1dUL;
   tf->codes[542] = 0x000000032eef86acUL;
   tf->codes[543] = 0x0000000668f8ff2eUL;
   tf->codes[544] = 0x00000006de170ab8UL;
   tf->codes[545] = 0x00000009341b93e2UL;
   tf->codes[546] = 0x0000000974e1c163UL;
   tf->codes[547] = 0x000000073182af6dUL;
   tf->codes[548] = 0x00000005d85fb48bUL;
   tf->codes[549] = 0x000000078b257bdeUL;
   tf->codes[550] = 0x0000000173d0eb29UL;
   tf->codes[551] = 0x00000005add785d1UL;
   tf->codes[552] = 0x0000000af6e83240UL;
   tf->codes[553] = 0x0000000dce79166cUL;
   tf->codes[554] = 0x000000022716840bUL;
   tf->codes[555] = 0x00000007b408f1d9UL;
   tf->codes[556] = 0x0000000de43a217eUL;
   tf->codes[557] = 0x000000036e10fb6eUL;
   tf->codes[558] = 0x0000000ea9a83ddfUL;
   tf->codes[559] = 0x00000004dcf50162UL;
   tf->codes[560] = 0x00000009aab07a8bUL;
   tf->codes[561] = 0x0000000281364431UL;
   tf->codes[562] = 0x00000008392dd46eUL;
   tf->codes[563] = 0x00000000945e6aceUL;
   tf->codes[564] = 0x00000008d07b3a82UL;
   tf->codes[565] = 0x0000000d012f1990UL;
   tf->codes[566] = 0x0000000b7098acc7UL;
   tf->codes[567] = 0x0000000c2fcfa16cUL;
   tf->codes[568] = 0x00000001e7c731a9UL;
   tf->codes[569] = 0x0000000f16ea68eeUL;
   tf->codes[570] = 0x00000002fa69cb03UL;
   tf->codes[571] = 0x00000004cee1f92bUL;
   tf->codes[572] = 0x00000001e20cfda2UL;
   tf->codes[573] = 0x00000009e9d1ef4dUL;
   tf->codes[574] = 0x0000000e83358a6dUL;
   tf->codes[575] = 0x000000059a873d48UL;
   tf->codes[576] = 0x0000000a6842b671UL;
   tf->codes[577] = 0x00000006885bdbefUL;
   tf->codes[578] = 0x000000073e4014faUL;
   tf->codes[579] = 0x00000007b9954840UL;
   tf->codes[580] = 0x0000000548157ffdUL;
   tf->codes[581] = 0x00000008853a8c5dUL;
   tf->codes[582] = 0x0000000eb8874fe0UL;
   tf->codes[583] = 0x0000000b25d4f257UL;
   tf->codes[584] = 0x000000036b447da5UL;
   tf->codes[585] = 0x000000071d87958fUL;
   tf->codes[586] = 0x0000000eedd91553UL;
   tf->codes[587] = 0x00000004af23612aUL;
   tf->codes[588] = 0x0000000278329eacUL;
   tf->codes[589] = 0x0000000191121b76UL;
   tf->codes[590] = 0x00000006e691175dUL;
   tf->codes[591] = 0x00000000bd140329UL;
   tf->codes[592] = 0x00000006ed4532ceUL;
   tf->codes[593] = 0x0000000d5e3c8ff4UL;
   tf->codes[594] = 0x0000000e26c64033UL;
   tf->codes[595] = 0x0000000494a2097bUL;
   tf->codes[596] = 0x0000000f5e36d440UL;
   tf->codes[597] = 0x0000000b7818d202UL;
   tf->codes[598] = 0x0000000a63548c34UL;
   tf->codes[599] = 0x0000000682f0bdfdUL;
   tf->codes[600] = 0x00000003d3c65c17UL;
   tf->codes[601] = 0x00000004c4399ae7UL;
   tf->codes[602] = 0x00000006b18e67ffUL;
   tf->codes[603] = 0x00000004778211a3UL;
   tf->codes[604] = 0x00000004089b2dd5UL;
   tf->codes[605] = 0x000000021edee850UL;
   tf->codes[606] = 0x0000000739cede72UL;
   tf->codes[607] = 0x0000000858dfc744UL;
   tf->codes[608] = 0x00000004bc5dba6cUL;
   tf->codes[609] = 0x000000021cbd3bdcUL;
   tf->codes[610] = 0x0000000ac83de313UL;
   tf->codes[611] = 0x00000006135f08daUL;
   tf->codes[612] = 0x0000000d3a3a9f0bUL;
   tf->codes[613] = 0x0000000eb2716099UL;
   tf->codes[614] = 0x000000040b88e413UL;
   tf->codes[615] = 0x0000000992442a25UL;
   tf->codes[616] = 0x0000000c639de695UL;
   tf->codes[617] = 0x0000000683bcc7c7UL;
   tf->codes[618] = 0x00000006245fc74fUL;
   tf->codes[619] = 0x0000000543766bd5UL;
   tf->codes[620] = 0x0000000375356569UL;
   tf->codes[621] = 0x0000000fa45b7a88UL;
   tf->codes[622] = 0x00000009f29b1207UL;
   tf->codes[623] = 0x0000000ba245457cUL;
   tf->codes[624] = 0x00000005b98e5ec9UL;
   tf->codes[625] = 0x0000000204aca6b6UL;
   tf->codes[626] = 0x0000000d52e9605bUL;
   tf->codes[627] = 0x0000000504a40d28UL;
   tf->codes[628] = 0x0000000ab6e1695eUL;
   tf->codes[629] = 0x0000000a26481ebbUL;
   tf->codes[630] = 0x00000009455ec341UL;
   tf->codes[631] = 0x00000002f05f98e9UL;
   tf->codes[632] = 0x0000000ead83365cUL;
   tf->codes[633] = 0x0000000b928d8486UL;
   tf->codes[634] = 0x00000007b860de0bUL;
   tf->codes[635] = 0x0000000964ef7da2UL;
   tf->codes[636] = 0x00000002422962b9UL;
   tf->codes[637] = 0x000000028f5ddfb2UL;
   tf->codes[638] = 0x00000008c5c63713UL;
   tf->codes[639] = 0x00000009068c6494UL;
   tf->codes[640] = 0x000000050aad5744UL;
   tf->codes[641] = 0x000000093e7cca30UL;
   tf->codes[642] = 0x00000009825e8b8fUL;
   tf->codes[643] = 0x00000003a8b4947dUL;
   tf->codes[644] = 0x0000000fa06737b5UL;
   tf->codes[645] = 0x0000000cb9c963e8UL;
   tf->codes[646] = 0x000000091a2bc332UL;
   tf->codes[647] = 0x0000000284666b59UL;
   tf->codes[648] = 0x0000000ceb82a1c8UL;
   tf->codes[649] = 0x0000000a2fe9f06aUL;
   tf->codes[650] = 0x000000006fa50365UL;
   tf->codes[651] = 0x000000019aa747faUL;
   tf->codes[652] = 0x0000000a6e117dc2UL;
   tf->codes[653] = 0x00000002b3810910UL;
   tf->codes[654] = 0x0000000ff7e857b2UL;
   tf->codes[655] = 0x0000000048b55c3eUL;
   tf->codes[656] = 0x0000000975456ac2UL;
   tf->codes[657] = 0x0000000ad200ed37UL;
   tf->codes[658] = 0x0000000e4d4d86efUL;
   tf->codes[659] = 0x0000000b3ec62491UL;
   tf->codes[660] = 0x00000008cd465c4eUL;
   tf->codes[661] = 0x00000008a2be2d94UL;
   tf->codes[662] = 0x00000005a9f7d648UL;
   tf->codes[663] = 0x000000059e067a85UL;
   tf->codes[664] = 0x0000000b5c35327eUL;
   tf->codes[665] = 0x0000000c4ca8714eUL;
   tf->codes[666] = 0x00000000e927a04cUL;
   tf->codes[667] = 0x0000000f71eac628UL;
   tf->codes[668] = 0x0000000109354e62UL;
   tf->codes[669] = 0x00000001037b1a5bUL;
   tf->codes[670] = 0x000000026c27f893UL;
   tf->codes[671] = 0x00000003597fa385UL;
   tf->codes[672] = 0x0000000ee24b62efUL;
   tf->codes[673] = 0x00000004b31f921cUL;
   tf->codes[674] = 0x0000000650244e5dUL;
   tf->codes[675] = 0x0000000cfec64526UL;
   tf->codes[676] = 0x0000000cd4bb0a21UL;
   tf->codes[677] = 0x0000000648c56197UL;
   tf->codes[678] = 0x0000000bd95056f8UL;
   tf->codes[679] = 0x0000000983c8c183UL;
   tf->codes[680] = 0x0000000ddc662f22UL;
   tf->codes[681] = 0x00000005631bb980UL;
   tf->codes[682] = 0x00000001203f56f3UL;
   tf->codes[683] = 0x00000006a0c37549UL;
   tf->codes[684] = 0x0000000a59baa8a4UL;
   tf->codes[685] = 0x00000006a23a5068UL;
   tf->codes[686] = 0x0000000ad609c354UL;
   tf->codes[687] = 0x0000000f6f6d5e74UL;
   tf->codes[688] = 0x000000036bc95f79UL;
   tf->codes[689] = 0x0000000424c92c62UL;
   tf->codes[690] = 0x00000003692abf50UL;
   tf->codes[691] = 0x00000000a4bc460dUL;
   tf->codes[692] = 0x00000001b4434b89UL;
   tf->codes[693] = 0x00000004eb31302dUL;
   tf->codes[694] = 0x00000009a3a891f9UL;
   tf->codes[695] = 0x000000093af8d5e7UL;
   tf->codes[696] = 0x0000000ef60bfa02UL;
   tf->codes[697] = 0x0000000607a378d6UL;
   tf->codes[698] = 0x00000005a5a7d835UL;
   tf->codes[699] = 0x0000000536c0f467UL;
   tf->codes[700] = 0x000000011f66a7feUL;
   tf->codes[701] = 0x000000074c7c43c5UL;
   tf->codes[702] = 0x000000066eae7c29UL;
   tf->codes[703] = 0x0000000f5a785d2cUL;
   tf->codes[704] = 0x0000000d3948a5c0UL;
   tf->codes[705] = 0x0000000ec1094aa4UL;
   tf->codes[706] = 0x0000000fcad61c19UL;
   tf->codes[707] = 0x000000049ca7108aUL;
   tf->codes[708] = 0x000000077437f4b6UL;
   tf->codes[709] = 0x0000000553083d4aUL;
   tf->codes[710] = 0x00000005c26c14cdUL;
   tf->codes[711] = 0x00000006eb4caceeUL;
   tf->codes[712] = 0x0000000e8aded63cUL;
   tf->codes[713] = 0x0000000132aa4b5cUL;
   tf->codes[714] = 0x000000057603a19eUL;
   tf->codes[715] = 0x0000000ee359dda3UL;
   tf->codes[716] = 0x0000000d0f5ea330UL;
   tf->codes[717] = 0x000000046b0f0b1fUL;
   tf->codes[718] = 0x0000000d47cbfc81UL;
   tf->codes[719] = 0x00000003ed1b37b0UL;
   tf->codes[720] = 0x00000004c8c752d8UL;
   tf->codes[721] = 0x0000000ac202044bUL;
   tf->codes[722] = 0x0000000207f16128UL;
   tf->codes[723] = 0x000000053f5c3981UL;
   tf->codes[724] = 0x000000070e1a33a2UL;
   tf->codes[725] = 0x0000000ed8348baaUL;
   tf->codes[726] = 0x0000000798f94a3eUL;
   tf->codes[727] = 0x00000008896c890eUL;
   tf->codes[728] = 0x0000000521425a3fUL;
   tf->codes[729] = 0x0000000c8329e9eaUL;
   tf->codes[730] = 0x000000041f238ba5UL;
   tf->codes[731] = 0x00000001093d3c81UL;
   tf->codes[732] = 0x0000000cab628e90UL;
   tf->codes[733] = 0x0000000a1b4bf356UL;
   tf->codes[734] = 0x000000092eee2fceUL;
   tf->codes[735] = 0x000000059d35b9afUL;
   tf->codes[736] = 0x00000002176e9f53UL;
   tf->codes[737] = 0x00000007c9abfb89UL;
   tf->codes[738] = 0x0000000b06d107e9UL;
   tf->codes[739] = 0x0000000e94c318d5UL;
   tf->codes[740] = 0x00000002f397ae30UL;
   tf->codes[741] = 0x0000000d7e5a1a48UL;
   tf->codes[742] = 0x000000098c4abc47UL;
   tf->codes[743] = 0x0000000574737c29UL;
   tf->codes[744] = 0x0000000d7f5401b2UL;
   tf->codes[745] = 0x0000000852b87bc6UL;
   tf->codes[746] = 0x00000001180fa957UL;
   tf->codes[747] = 0x0000000501c63328UL;
   tf->codes[748] = 0x0000000fd28c0d13UL;
   tf->codes[749] = 0x0000000f764aa079UL;
   tf->codes[750] = 0x0000000c8a6f8c5aUL;
   tf->codes[751] = 0x0000000975b10240UL;
   tf->codes[752] = 0x00000006bd33e4c0UL;
   tf->codes[753] = 0x0000000a1113e39cUL;
   tf->codes[754] = 0x0000000abcfa8fb8UL;
   tf->codes[755] = 0x0000000149ea1facUL;
   tf->codes[756] = 0x0000000f6443556fUL;
   tf->codes[757] = 0x0000000959da07e7UL;
   tf->codes[758] = 0x00000004721a2ac4UL;
   tf->codes[759] = 0x000000030bde0f15UL;
   tf->codes[760] = 0x0000000c7c4fdef8UL;
   tf->codes[761] = 0x0000000b7feb4465UL;
   tf->codes[762] = 0x000000056675073cUL;
   tf->codes[763] = 0x000000096f3f57b9UL;
   tf->codes[764] = 0x0000000876f0386eUL;
   tf->codes[765] = 0x0000000393f0a7e8UL;
   tf->codes[766] = 0x000000032b40ebd6UL;
   tf->codes[767] = 0x000000010a11346aUL;
   tf->codes[768] = 0x0000000fb81f48aeUL;
   tf->codes[769] = 0x00000000a892877eUL;
   tf->codes[770] = 0x000000086f636e08UL;
   tf->codes[771] = 0x00000004fbc4d72bUL;
   tf->codes[772] = 0x0000000561d5f314UL;
   tf->codes[773] = 0x0000000ca18e2835UL;
   tf->codes[774] = 0x00000007e6f519f5UL;
   tf->codes[775] = 0x00000008b94e7983UL;
   tf->codes[776] = 0x0000000619adfaf3UL;
   tf->codes[777] = 0x00000004c9ddbbabUL;
   tf->codes[778] = 0x0000000cb6a461f2UL;
   tf->codes[779] = 0x00000000f6e22456UL;
   tf->codes[780] = 0x0000000858c9b401UL;
   tf->codes[781] = 0x000000092dc1b3b8UL;
   tf->codes[782] = 0x00000003a783615bUL;
   tf->codes[783] = 0x0000000c74b66f67UL;
   tf->codes[784] = 0x0000000ea90891bcUL;
   tf->codes[785] = 0x000000031a829e4bUL;
   tf->codes[786] = 0x00000007bd38f505UL;
   tf->codes[787] = 0x0000000b4476ea80UL;
   tf->codes[788] = 0x00000001af371feaUL;
   tf->codes[789] = 0x000000084894ff56UL;
   tf->codes[790] = 0x00000000537584dfUL;
   tf->codes[791] = 0x0000000d4ebdd1d0UL;
   tf->codes[792] = 0x0000000b43cc192bUL;
   tf->codes[793] = 0x000000076700d287UL;
   tf->codes[794] = 0x0000000aaad9fa58UL;
   tf->codes[795] = 0x0000000fa511710fUL;
   tf->codes[796] = 0x00000006e54699e5UL;
   tf->codes[797] = 0x00000006d73391aeUL;
   tf->codes[798] = 0x00000003c2f1fb49UL;
   tf->codes[799] = 0x00000004fbd96a75UL;
   tf->codes[800] = 0x0000000252e6304bUL;
   tf->codes[801] = 0x0000000e72826214UL;
   tf->codes[802] = 0x00000008fe6c9336UL;
   tf->codes[803] = 0x0000000326397743UL;
   tf->codes[804] = 0x00000000e03bc524UL;
   tf->codes[805] = 0x0000000dedac9594UL;
   tf->codes[806] = 0x000000004ff19096UL;
   tf->codes[807] = 0x0000000409b4cdbbUL;
   tf->codes[808] = 0x0000000b15921888UL;
   tf->codes[809] = 0x0000000a259bcd6dUL;
   tf->codes[810] = 0x000000043c67f305UL;
   tf->codes[811] = 0x00000001dc65dcecUL;
   tf->codes[812] = 0x00000001730b4f85UL;
   tf->codes[813] = 0x0000000f8a48f16aUL;
   tf->codes[814] = 0x000000057a30e743UL;
   tf->codes[815] = 0x000000005afd9839UL;
   tf->codes[816] = 0x0000000682d5f3aeUL;
   tf->codes[817] = 0x00000000b694337eUL;
   tf->codes[818] = 0x0000000758c7dacfUL;
   tf->codes[819] = 0x000000018fa1ae7dUL;
   tf->codes[820] = 0x00000005ba9b5984UL;
   tf->codes[821] = 0x000000032e1d45ddUL;
   tf->codes[822] = 0x0000000672f05518UL;
   tf->codes[823] = 0x0000000382ffc5b1UL;
   tf->codes[824] = 0x00000008f0b08f33UL;
   tf->codes[825] = 0x0000000b4a4d9ff0UL;
   tf->codes[826] = 0x000000053ba0f980UL;
   tf->codes[827] = 0x00000002ac0751fbUL;
   tf->codes[828] = 0x0000000ab005de73UL;
   tf->codes[829] = 0x000000061ab7be9bUL;
   tf->codes[830] = 0x000000063078c9adUL;
   tf->codes[831] = 0x000000027659d148UL;
   tf->codes[832] = 0x0000000c653c684fUL;
   tf->codes[833] = 0x0000000ecee05017UL;
   tf->codes[834] = 0x000000024378ce5eUL;
   tf->codes[835] = 0x0000000d0f7e5bacUL;
   tf->codes[836] = 0x00000008b4bf4199UL;
   tf->codes[837] = 0x0000000b7aa495fbUL;
   tf->codes[838] = 0x0000000f3d6b78a5UL;
   tf->codes[839] = 0x000000098bab1024UL;
   tf->codes[840] = 0x00000006b4971fadUL;
   tf->codes[841] = 0x00000000723d6c89UL;
   tf->codes[842] = 0x0000000a17071a75UL;
   tf->codes[843] = 0x0000000d55a301f4UL;
   tf->codes[844] = 0x0000000988de925bUL;
   tf->codes[845] = 0x00000007ca276f45UL;
   tf->codes[846] = 0x0000000321b6e484UL;
   tf->codes[847] = 0x0000000316149ed6UL;
   tf->codes[848] = 0x0000000b8dba5bb9UL;
   tf->codes[849] = 0x0000000aad4df3f4UL;
   tf->codes[850] = 0x0000000178e204f5UL;
   tf->codes[851] = 0x000000095cd2e357UL;
   tf->codes[852] = 0x000000073fb8a733UL;
   tf->codes[853] = 0x000000084ca10c86UL;
   tf->codes[854] = 0x000000089498492dUL;
   tf->codes[855] = 0x00000005b9bdf383UL;
   tf->codes[856] = 0x000000066c58bb10UL;
   tf->codes[857] = 0x0000000f153ac21eUL;
   tf->codes[858] = 0x00000007ca5d3b04UL;
   tf->codes[859] = 0x0000000637a521c7UL;
   tf->codes[860] = 0x0000000b5ed589c1UL;
   tf->codes[861] = 0x0000000d0a3c644eUL;
   tf->codes[862] = 0x00000003d5d0754fUL;
   tf->codes[863] = 0x0000000c6b901174UL;
   tf->codes[864] = 0x00000003e96fd3edUL;
   tf->codes[865] = 0x000000079c2fdf8cUL;
   tf->codes[866] = 0x00000006594ae371UL;
   tf->codes[867] = 0x00000003504fd77aUL;
   tf->codes[868] = 0x000000032b81dcc7UL;
   tf->codes[869] = 0x000000057b4f3e35UL;
   tf->codes[870] = 0x00000004c9808072UL;
   tf->codes[871] = 0x0000000a06c10993UL;
   tf->codes[872] = 0x0000000b059666afUL;
   tf->codes[873] = 0x000000072b69c034UL;
   tf->codes[874] = 0x0000000e33ae836eUL;
   tf->codes[875] = 0x0000000ad6cadf0dUL;
   tf->codes[876] = 0x000000019573ace1UL;
   tf->codes[877] = 0x0000000d562fd1e7UL;
   tf->codes[878] = 0x0000000847804d9dUL;
   tf->codes[879] = 0x00000009e32f6734UL;
   tf->codes[880] = 0x00000002355c580fUL;
   tf->codes[881] = 0x00000002f177b8d6UL;
   tf->codes[882] = 0x0000000d689ac650UL;
   tf->codes[883] = 0x0000000071b70abcUL;
   tf->codes[884] = 0x0000000254915730UL;
   tf->codes[885] = 0x0000000c5934f949UL;
   tf->codes[886] = 0x0000000134d59d09UL;
   tf->codes[887] = 0x00000002c731fb06UL;
   tf->codes[888] = 0x0000000d90c6c5cbUL;
   tf->codes[889] = 0x0000000cc3f9bca4UL;
   tf->codes[890] = 0x0000000bf078980cUL;
   tf->codes[891] = 0x000000080838e95aUL;
   tf->codes[892] = 0x00000005ccd6f054UL;
   tf->codes[893] = 0x00000000378bae56UL;
   tf->codes[894] = 0x00000008d1ddb978UL;
   tf->codes[895] = 0x000000093b875cf4UL;
   tf->codes[896] = 0x0000000e2ce90bc6UL;
   tf->codes[897] = 0x0000000ec291b91bUL;
   tf->codes[898] = 0x0000000d0a11bdc1UL;
   tf->codes[899] = 0x0000000751be7244UL;
   tf->codes[900] = 0x0000000579fcd29eUL;
   tf->codes[901] = 0x0000000f76e5ccb1UL;
   tf->codes[902] = 0x0000000eb33da184UL;
   tf->codes[903] = 0x0000000c0ac75b0fUL;
   tf->codes[904] = 0x000000015454fb33UL;
   tf->codes[905] = 0x00000008b92a411cUL;
   tf->codes[906] = 0x00000007da34b476UL;
   tf->codes[907] = 0x00000004f413d45eUL;
   tf->codes[908] = 0x000000010ec1dbeaUL;
   tf->codes[909] = 0x0000000650739b93UL;
   tf->codes[910] = 0x0000000315e08a31UL;
   tf->codes[911] = 0x0000000d4fd5f1bdUL;
   tf->codes[912] = 0x0000000b5058a126UL;
   tf->codes[913] = 0x000000020d5cb63bUL;
   tf->codes[914] = 0x0000000c1598dfe7UL;
   tf->codes[915] = 0x0000000a0a2a338dUL;
   tf->codes[916] = 0x0000000e29af7686UL;
   tf->codes[917] = 0x000000083fd0cac9UL;
   tf->codes[918] = 0x000000014a8094d8UL;
   tf->codes[919] = 0x0000000816e0afa3UL;
   tf->codes[920] = 0x0000000499ef5d2cUL;
   tf->codes[921] = 0x0000000bddbd0d95UL;
   tf->codes[922] = 0x0000000a30839ca9UL;
   tf->codes[923] = 0x00000004fd33fb4cUL;
   tf->codes[924] = 0x0000000ef63557b7UL;
   tf->codes[925] = 0x0000000535f06ab2UL;
   tf->codes[926] = 0x00000000d47d352eUL;
   tf->codes[927] = 0x0000000a371e6dc4UL;
   tf->codes[928] = 0x00000008ac914b17UL;
   tf->codes[929] = 0x00000006ba9d69d7UL;
   tf->codes[930] = 0x0000000096da89aaUL;
   tf->codes[931] = 0x000000065bbd5d14UL;
   tf->codes[932] = 0x0000000d41d2c5c4UL;
   tf->codes[933] = 0x000000052a283583UL;
   tf->codes[934] = 0x00000004c1f56d26UL;
   tf->codes[935] = 0x000000086cd9984aUL;
   tf->codes[936] = 0x000000026cbcedc6UL;
   tf->codes[937] = 0x00000001aa0eaa03UL;
   tf->codes[938] = 0x0000000b95d5ad2cUL;
   tf->codes[939] = 0x0000000e2eb56b20UL;
   tf->codes[940] = 0x0000000ff49d9d5cUL;
   tf->codes[941] = 0x0000000cce338378UL;
   tf->codes[942] = 0x0000000330e9fac7UL;
   tf->codes[943] = 0x0000000e2f53974aUL;
   tf->codes[944] = 0x0000000668d1c6d5UL;
   tf->codes[945] = 0x0000000eca0ba751UL;
   tf->codes[946] = 0x00000008d48ab5e6UL;
   tf->codes[947] = 0x0000000d205e18cdUL;
   tf->codes[948] = 0x00000001c391633cUL;
   tf->codes[949] = 0x0000000ef5d02e5fUL;
   tf->codes[950] = 0x0000000d12bb5f20UL;
   tf->codes[951] = 0x0000000323215199UL;
   tf->codes[952] = 0x000000088f5b3ffcUL;
   tf->codes[953] = 0x0000000931445f29UL;
   tf->codes[954] = 0x0000000b893cb727UL;
   tf->codes[955] = 0x000000032851ecc0UL;
   tf->codes[956] = 0x000000080b44d81bUL;
   tf->codes[957] = 0x00000005aa48da98UL;
   tf->codes[958] = 0x000000046d1e1284UL;
   tf->codes[959] = 0x00000004c837ba14UL;
   tf->codes[960] = 0x0000000eb22c26deUL;
   tf->codes[961] = 0x0000000e51e9d246UL;
   tf->codes[962] = 0x00000008d03deee6UL;
   tf->codes[963] = 0x00000005af8e0909UL;
   tf->codes[964] = 0x0000000bde9773a4UL;
   tf->codes[965] = 0x0000000bf611cabfUL;
   tf->codes[966] = 0x0000000d24ac96e7UL;
   tf->codes[967] = 0x00000009fe919318UL;
   tf->codes[968] = 0x000000050d0206a6UL;
   tf->codes[969] = 0x0000000b43b9741cUL;
   tf->codes[970] = 0x0000000ba48d4fb3UL;
   tf->codes[971] = 0x00000006bccd7290UL;
   tf->codes[972] = 0x00000008bc6bfb9cUL;
   tf->codes[973] = 0x0000000e5a036c9fUL;
   tf->codes[974] = 0x0000000a80a2cfeeUL;
   tf->codes[975] = 0x0000000c193655a7UL;
   tf->codes[976] = 0x00000007c8e5170dUL;
   tf->codes[977] = 0x00000006141edbbbUL;
   tf->codes[978] = 0x00000004d6b990dcUL;
   tf->codes[979] = 0x0000000cc49b5702UL;
   tf->codes[980] = 0x00000002343fef58UL;
   tf->codes[981] = 0x0000000d50cb593cUL;
   tf->codes[982] = 0x00000004248a60cdUL;
   tf->codes[983] = 0x0000000901cfbd4cUL;
   tf->codes[984] = 0x000000064a4c8736UL;
   tf->codes[985] = 0x00000001b2dcbaeaUL;
   tf->codes[986] = 0x0000000d691e5f4cUL;
   tf->codes[987] = 0x0000000df352a493UL;
   tf->codes[988] = 0x00000001991ac7daUL;
   tf->codes[989] = 0x00000004c4879f45UL;
   tf->codes[990] = 0x00000009b34aadeeUL;
   tf->codes[991] = 0x000000052bb3db0dUL;
   tf->codes[992] = 0x00000007b9a8c9d3UL;
   tf->codes[993] = 0x0000000d7ce6e47eUL;
   tf->codes[994] = 0x0000000ec0b922d8UL;
   tf->codes[995] = 0x00000008079cab6bUL;
   tf->codes[996] = 0x0000000abadc8899UL;
   tf->codes[997] = 0x00000000f57b93b7UL;
   tf->codes[998] = 0x000000005c4ef219UL;
   tf->codes[999] = 0x0000000d7a438d49UL;
   tf->codes[1000] = 0x0000000f55ecca97UL;
   tf->codes[1001] = 0x0000000d07899f1dUL;
   tf->codes[1002] = 0x0000000260947d6cUL;
   tf->codes[1003] = 0x0000000ffbd21ab6UL;
   tf->codes[1004] = 0x0000000d04ff923eUL;
   tf->codes[1005] = 0x0000000964b72033UL;
   tf->codes[1006] = 0x000000031ac3fd7eUL;
   tf->codes[1007] = 0x0000000d2c52e2c4UL;
   tf->codes[1008] = 0x0000000799a640efUL;
   tf->codes[1009] = 0x000000098dd061edUL;
   tf->codes[1010] = 0x00000005cb2ab7b8UL;
   tf->codes[1011] = 0x000000072f3881c8UL;
   tf->codes[1012] = 0x0000000e65ed1164UL;
   tf->codes[1013] = 0x000000034fa0bd5bUL;
   tf->codes[1014] = 0x000000064f9823cdUL;
   tf->codes[1015] = 0x00000003797e1ac0UL;
   tf->codes[1016] = 0x00000002fb8a4751UL;
   tf->codes[1017] = 0x00000006f347342eUL;
   tf->codes[1018] = 0x000000022dd7ea0aUL;
   tf->codes[1019] = 0x0000000b19b65e57UL;
   tf->codes[1020] = 0x000000044fe83e8aUL;
   tf->codes[1021] = 0x000000007732732eUL;
   tf->codes[1022] = 0x000000064de20ed7UL;
   tf->codes[1023] = 0x000000006c9ea834UL;
   tf->codes[1024] = 0x00000008ce066650UL;
   tf->codes[1025] = 0x0000000c2a685ff0UL;
   tf->codes[1026] = 0x000000064f19b01fUL;
   tf->codes[1027] = 0x0000000491ab8a88UL;
   tf->codes[1028] = 0x000000041212fe5aUL;
   tf->codes[1029] = 0x00000006f9916f3bUL;
   tf->codes[1030] = 0x0000000694f72e71UL;
   tf->codes[1031] = 0x0000000ad7a5b35eUL;
   tf->codes[1032] = 0x0000000f62795292UL;
   tf->codes[1033] = 0x0000000c8cdc3d3aUL;
   tf->codes[1034] = 0x0000000fbc6b3518UL;
   tf->codes[1035] = 0x000000067b631901UL;
   tf->codes[1036] = 0x00000005b5ba79d5UL;
   tf->codes[1037] = 0x0000000f4fadebddUL;
   tf->codes[1038] = 0x0000000ac7c802e7UL;
   tf->codes[1039] = 0x0000000385712d9dUL;
   tf->codes[1040] = 0x000000064bd375b4UL;
   tf->codes[1041] = 0x0000000c9a11df70UL;
   tf->codes[1042] = 0x000000088355bf31UL;
   tf->codes[1043] = 0x0000000606ffbb0aUL;
   tf->codes[1044] = 0x0000000bda93c2d5UL;
   tf->codes[1045] = 0x00000007c5f94f0aUL;
   tf->codes[1046] = 0x000000076fe26501UL;
   tf->codes[1047] = 0x00000005d8b9153cUL;
   tf->codes[1048] = 0x0000000886bbb218UL;
   tf->codes[1049] = 0x0000000acee2fecaUL;
   tf->codes[1050] = 0x00000002ad19a925UL;
   tf->codes[1051] = 0x000000083b97855cUL;
   tf->codes[1052] = 0x0000000d36608312UL;
   tf->codes[1053] = 0x00000008ac60dbc7UL;
   tf->codes[1054] = 0x00000000885c8f58UL;
   tf->codes[1055] = 0x00000008abbdf891UL;
   tf->codes[1056] = 0x0000000ea1602271UL;
   tf->codes[1057] = 0x0000000ad654fee1UL;
   tf->codes[1058] = 0x00000006c461195eUL;
   tf->codes[1059] = 0x00000005eeb1a327UL;
   tf->codes[1060] = 0x000000018d743962UL;
   tf->codes[1061] = 0x00000001fc7c55a5UL;
   tf->codes[1062] = 0x0000000aba749670UL;
   tf->codes[1063] = 0x00000009c9a59c60UL;
   tf->codes[1064] = 0x00000006e5bafc06UL;
   tf->codes[1065] = 0x000000096977db12UL;
   tf->codes[1066] = 0x0000000a97b6ebfaUL;
   tf->codes[1067] = 0x000000063d2d9da6UL;
   tf->codes[1068] = 0x0000000fab00cd60UL;
   tf->codes[1069] = 0x0000000d7bdf4632UL;
   tf->codes[1070] = 0x0000000f83878d59UL;
   tf->codes[1071] = 0x0000000b1c2c462eUL;
   tf->codes[1072] = 0x000000014e5144a7UL;
   tf->codes[1073] = 0x0000000f4a909b28UL;
   tf->codes[1074] = 0x0000000e979a185bUL;
   tf->codes[1075] = 0x0000000908090a64UL;
   tf->codes[1076] = 0x000000099eccd798UL;
   tf->codes[1077] = 0x0000000348780a96UL;
   tf->codes[1078] = 0x0000000fdc7ad169UL;
   tf->codes[1079] = 0x0000000a600c2e5bUL;
   tf->codes[1080] = 0x0000000b0968cd98UL;
   tf->codes[1081] = 0x00000001a45ec098UL;
   tf->codes[1082] = 0x000000099118c1b4UL;
   tf->codes[1083] = 0x00000008afa5cd5aUL;
   tf->codes[1084] = 0x00000001db7e655eUL;
   tf->codes[1085] = 0x00000009f637e452UL;
   tf->codes[1086] = 0x00000009568504e3UL;
   tf->codes[1087] = 0x0000000045b2a662UL;
   tf->codes[1088] = 0x0000000f2a1455a2UL;
   tf->codes[1089] = 0x00000006c1ca9e75UL;
   tf->codes[1090] = 0x000000030a4a4639UL;
   tf->codes[1091] = 0x0000000c6c2c1a30UL;
   tf->codes[1092] = 0x000000087500b452UL;
   tf->codes[1093] = 0x00000005e338bb2eUL;
   tf->codes[1094] = 0x0000000d9dd11dffUL;
   tf->codes[1095] = 0x00000008c4b5d012UL;
   tf->codes[1096] = 0x00000008191194e0UL;
   tf->codes[1097] = 0x0000000dd11db867UL;
   tf->codes[1098] = 0x0000000c67c151ceUL;
   tf->codes[1099] = 0x00000005cb1a00e4UL;
   tf->codes[1100] = 0x0000000098b7a1c6UL;
   tf->codes[1101] = 0x0000000369f35cd4UL;
   tf->codes[1102] = 0x0000000ca2190bdbUL;
   tf->codes[1103] = 0x00000006e14bb3b9UL;
   tf->codes[1104] = 0x00000008d5692f8cUL;
   tf->codes[1105] = 0x0000000ca4b2f4f8UL;
   tf->codes[1106] = 0x0000000787f06877UL;
   tf->codes[1107] = 0x00000008acbb8550UL;
   tf->codes[1108] = 0x0000000535f4b56aUL;
   tf->codes[1109] = 0x0000000f4caf7ecbUL;
   tf->codes[1110] = 0x0000000d4615b258UL;
   tf->codes[1111] = 0x0000000347ca7070UL;
   tf->codes[1112] = 0x00000003c798c85dUL;
   tf->codes[1113] = 0x0000000460506465UL;
   tf->codes[1114] = 0x0000000870d0a5dcUL;
   tf->codes[1115] = 0x00000006510b2464UL;
   tf->codes[1116] = 0x0000000d1dba5544UL;
   tf->codes[1117] = 0x0000000d57789a33UL;
   tf->codes[1118] = 0x0000000e2417c5baUL;
   tf->codes[1119] = 0x0000000b5ff8628cUL;
   tf->codes[1120] = 0x0000000a3bb22787UL;
   tf->codes[1121] = 0x0000000a16b64f34UL;
   tf->codes[1122] = 0x0000000421e81d3dUL;
   tf->codes[1123] = 0x000000035b4596a7UL;
   tf->codes[1124] = 0x00000008d7a2dd7eUL;
   tf->codes[1125] = 0x000000050b2d83faUL;
   tf->codes[1126] = 0x00000009ea87e7c2UL;
   tf->codes[1127] = 0x0000000d5055e752UL;
   tf->codes[1128] = 0x0000000f96aa9da5UL;
   tf->codes[1129] = 0x0000000b096e2a07UL;
   tf->codes[1130] = 0x000000049970b44bUL;
   tf->codes[1131] = 0x0000000867fb1518UL;
   tf->codes[1132] = 0x00000005d0f5dba2UL;
   tf->codes[1133] = 0x00000001b191d11eUL;
   tf->codes[1134] = 0x00000008e839bb8fUL;
   tf->codes[1135] = 0x00000001cd4aca15UL;
   tf->codes[1136] = 0x0000000971ec5615UL;
   tf->codes[1137] = 0x00000007d72a7ebdUL;
   tf->codes[1138] = 0x00000008b1253bfbUL;
   tf->codes[1139] = 0x0000000e11de1d25UL;
   tf->codes[1140] = 0x00000000a7566839UL;
   tf->codes[1141] = 0x0000000f4f3542e0UL;
   tf->codes[1142] = 0x00000001ea791e32UL;
   tf->codes[1143] = 0x000000032a84f759UL;
   tf->codes[1144] = 0x0000000646f1844eUL;
   tf->codes[1145] = 0x000000042af26809UL;
   tf->codes[1146] = 0x00000001f4b464ffUL;
   tf->codes[1147] = 0x0000000da684d2d9UL;
   tf->codes[1148] = 0x0000000d854f5fb9UL;
   tf->codes[1149] = 0x00000004d4d3e91aUL;
   tf->codes[1150] = 0x00000005af3ef4e2UL;
   tf->codes[1151] = 0x00000008a1ef5ce7UL;
   tf->codes[1152] = 0x00000002354febf3UL;
   tf->codes[1153] = 0x0000000b3c5a8944UL;
   tf->codes[1154] = 0x000000098b62a144UL;
   tf->codes[1155] = 0x00000009bdba0b4eUL;
   tf->codes[1156] = 0x000000004aa99b42UL;
   tf->codes[1157] = 0x00000008099ea151UL;
   tf->codes[1158] = 0x00000002185463a3UL;
   tf->codes[1159] = 0x0000000b0a1ae997UL;
   tf->codes[1160] = 0x0000000e628d5770UL;
   tf->codes[1161] = 0x0000000b40b5ac89UL;
   tf->codes[1162] = 0x000000027213b17dUL;
   tf->codes[1163] = 0x00000004d21db5b5UL;
   tf->codes[1164] = 0x000000010d0748f7UL;
   tf->codes[1165] = 0x00000002276c7876UL;
   tf->codes[1166] = 0x0000000b98bee56dUL;
   tf->codes[1167] = 0x0000000bd1ca6ae8UL;
   tf->codes[1168] = 0x0000000824ab48faUL;
   tf->codes[1169] = 0x0000000c6f35ae62UL;
   tf->codes[1170] = 0x00000003547a563cUL;
   tf->codes[1171] = 0x0000000f1fc0d824UL;
   tf->codes[1172] = 0x000000058f55ed75UL;
   tf->codes[1173] = 0x0000000aa9d0de01UL;
   tf->codes[1174] = 0x00000004719dde60UL;
   tf->codes[1175] = 0x0000000d5386b3ddUL;
   tf->codes[1176] = 0x00000004d8d9f666UL;
   tf->codes[1177] = 0x0000000aee36013bUL;
   tf->codes[1178] = 0x0000000ba4ee322fUL;
   tf->codes[1179] = 0x0000000898d2db4eUL;
   tf->codes[1180] = 0x00000009fe364808UL;
   tf->codes[1181] = 0x0000000bb13e8045UL;
   tf->codes[1182] = 0x0000000be346d43aUL;
   tf->codes[1183] = 0x0000000b4c9f886fUL;
   tf->codes[1184] = 0x0000000c9a6f53b8UL;
   tf->codes[1185] = 0x00000000ed5a7b6fUL;
   tf->codes[1186] = 0x00000002a1fac740UL;
   tf->codes[1187] = 0x0000000b8c134a59UL;
   tf->codes[1188] = 0x0000000b1f773993UL;
   tf->codes[1189] = 0x0000000c4d9d0025UL;
   tf->codes[1190] = 0x0000000ca905bdcaUL;
   tf->codes[1191] = 0x00000003150a39a7UL;
   tf->codes[1192] = 0x0000000e8329fad5UL;
   tf->codes[1193] = 0x0000000bd4f98059UL;
   tf->codes[1194] = 0x00000003bc5cf6cdUL;
   tf->codes[1195] = 0x0000000c982fdd03UL;
   tf->codes[1196] = 0x00000000a372de28UL;
   tf->codes[1197] = 0x000000073fe2e35aUL;
   tf->codes[1198] = 0x00000000b9f684ecUL;
   tf->codes[1199] = 0x0000000c543ff680UL;
   tf->codes[1200] = 0x00000001bcf5f09aUL;
   tf->codes[1201] = 0x000000051b2a8099UL;
   tf->codes[1202] = 0x0000000ee53277c2UL;
   tf->codes[1203] = 0x00000000b3835a6cUL;
   tf->codes[1204] = 0x0000000aed6765c1UL;
   tf->codes[1205] = 0x000000092cfd64c8UL;
   tf->codes[1206] = 0x0000000d20c60ed2UL;
   tf->codes[1207] = 0x000000059dbd9f51UL;
   tf->codes[1208] = 0x0000000b6acb694bUL;
   tf->codes[1209] = 0x0000000427dcd5fdUL;
   tf->codes[1210] = 0x0000000646336a75UL;
   tf->codes[1211] = 0x00000008008dea4dUL;
   tf->codes[1212] = 0x00000000af2bdc7cUL;
   tf->codes[1213] = 0x0000000b8a46478aUL;
   tf->codes[1214] = 0x0000000b02c535b6UL;
   tf->codes[1215] = 0x0000000c645d8631UL;
   tf->codes[1216] = 0x0000000044b4af3dUL;
   tf->codes[1217] = 0x0000000c9edfe6cbUL;
   tf->codes[1218] = 0x000000032ac8ea2aUL;
   tf->codes[1219] = 0x000000079266a23fUL;
   tf->codes[1220] = 0x0000000c2d902e93UL;
   tf->codes[1221] = 0x00000006ae5cfbdbUL;
   tf->codes[1222] = 0x00000002c66c633eUL;
   tf->codes[1223] = 0x0000000eb7a8a4e3UL;
   tf->codes[1224] = 0x0000000cb17281cfUL;
   tf->codes[1225] = 0x00000007ca378680UL;
   tf->codes[1226] = 0x00000007ac81509dUL;
   tf->codes[1227] = 0x0000000a59a05073UL;
   tf->codes[1228] = 0x0000000c9cb9f18dUL;
   tf->codes[1229] = 0x0000000b78100d29UL;
   tf->codes[1230] = 0x0000000fab49420aUL;
   tf->codes[1231] = 0x0000000d0a4e69c4UL;
   tf->codes[1232] = 0x0000000d6c33f722UL;
   tf->codes[1233] = 0x000000068d21bff8UL;
   tf->codes[1234] = 0x00000001fdad8ca3UL;
   tf->codes[1235] = 0x00000002884d6968UL;
   tf->codes[1236] = 0x0000000b091ff264UL;
   tf->codes[1237] = 0x0000000eb5fb236fUL;
   tf->codes[1238] = 0x0000000a3d2a1839UL;
   tf->codes[1239] = 0x0000000527db0bc8UL;
   tf->codes[1240] = 0x00000002dc68cd9fUL;
   tf->codes[1241] = 0x0000000e3f4ea98aUL;
   tf->codes[1242] = 0x0000000a629fe44fUL;
   tf->codes[1243] = 0x0000000b73bd7d66UL;
   tf->codes[1244] = 0x00000002abfd7b6bUL;
   tf->codes[1245] = 0x00000001b4056054UL;
   tf->codes[1246] = 0x0000000d6efaac28UL;
   tf->codes[1247] = 0x00000000d13cc950UL;
   tf->codes[1248] = 0x0000000ef84ead94UL;
   tf->codes[1249] = 0x00000005b6ee0d50UL;
   tf->codes[1250] = 0x00000000f4bec692UL;
   tf->codes[1251] = 0x0000000de1b98881UL;
   tf->codes[1252] = 0x000000055ccccd31UL;
   tf->codes[1253] = 0x0000000086d9b84dUL;
   tf->codes[1254] = 0x00000005ab736e3dUL;
   tf->codes[1255] = 0x0000000167d2f005UL;
   tf->codes[1256] = 0x0000000118ed1522UL;
   tf->codes[1257] = 0x000000038bbdc903UL;
   tf->codes[1258] = 0x000000039cd31ac2UL;
   tf->codes[1259] = 0x000000031091bc51UL;
   tf->codes[1260] = 0x0000000d66a87d3fUL;
   tf->codes[1261] = 0x0000000afdade6d3UL;
   tf->codes[1262] = 0x00000002bd1fe097UL;
   tf->codes[1263] = 0x00000005cf545dd2UL;
   tf->codes[1264] = 0x00000005e0af578eUL;
   tf->codes[1265] = 0x00000006fe6dd4c9UL;
   tf->codes[1266] = 0x0000000862bc8fcaUL;
   tf->codes[1267] = 0x0000000cbce0b4c6UL;
   tf->codes[1268] = 0x000000008b7fa8ddUL;
   tf->codes[1269] = 0x00000003d108ae9fUL;
   tf->codes[1270] = 0x0000000fed2d914aUL;
   tf->codes[1271] = 0x0000000bab304bd8UL;
   tf->codes[1272] = 0x0000000debe74f8dUL;
   tf->codes[1273] = 0x00000001e857e3dcUL;
   tf->codes[1274] = 0x0000000570340581UL;
   tf->codes[1275] = 0x0000000114bbf4f5UL;
   tf->codes[1276] = 0x0000000a3cfc0566UL;
   tf->codes[1277] = 0x00000004026cd686UL;
   tf->codes[1278] = 0x0000000266fb76cdUL;
   tf->codes[1279] = 0x0000000b715773bbUL;
   tf->codes[1280] = 0x00000002fd2785fdUL;
   tf->codes[1281] = 0x0000000481b34cadUL;
   tf->codes[1282] = 0x000000011c58d2baUL;
   tf->codes[1283] = 0x00000003a5186f4dUL;
   tf->codes[1284] = 0x0000000da55ab71cUL;
   tf->codes[1285] = 0x0000000ac887db92UL;
   tf->codes[1286] = 0x00000009bd6d5592UL;
   tf->codes[1287] = 0x000000045857d12aUL;
   tf->codes[1288] = 0x00000008c862f0b9UL;
   tf->codes[1289] = 0x0000000870c88666UL;
   tf->codes[1290] = 0x00000004a4f4901fUL;
   tf->codes[1291] = 0x0000000774a993d0UL;
   tf->codes[1292] = 0x0000000c9f16c81dUL;
   tf->codes[1293] = 0x0000000eb415e9efUL;
   tf->codes[1294] = 0x0000000307aa6302UL;
   tf->codes[1295] = 0x0000000a246f21eeUL;
   tf->codes[1296] = 0x00000001a4f8a9c2UL;
   tf->codes[1297] = 0x00000000cf09f9b4UL;
   tf->codes[1298] = 0x0000000db30dbb49UL;
   tf->codes[1299] = 0x00000003581be36fUL;
   tf->codes[1300] = 0x00000006919a4318UL;
   tf->codes[1301] = 0x00000008ee677afdUL;
   tf->codes[1302] = 0x00000005944b9d59UL;
   tf->codes[1303] = 0x00000008d5fe61aaUL;
   tf->codes[1304] = 0x000000077c174b1dUL;
   tf->codes[1305] = 0x00000005cff8fa10UL;
   tf->codes[1306] = 0x0000000c1ce82f48UL;
   tf->codes[1307] = 0x00000007fbb18e65UL;
   tf->codes[1308] = 0x00000000b6737103UL;
   tf->codes[1309] = 0x0000000e2d30a9b6UL;
   tf->codes[1310] = 0x00000006481ff469UL;
   tf->codes[1311] = 0x00000005834b4d26UL;
   tf->codes[1312] = 0x00000003bba517d5UL;
   tf->codes[1313] = 0x0000000eee6e8080UL;
   tf->codes[1314] = 0x00000005fe4fea5eUL;
   tf->codes[1315] = 0x0000000e84e94c8cUL;
   tf->codes[1316] = 0x0000000ba2ad0a2aUL;
   tf->codes[1317] = 0x0000000a7f2aead0UL;
   tf->codes[1318] = 0x000000063cecb46dUL;
   tf->codes[1319] = 0x00000008943d7229UL;
   tf->codes[1320] = 0x00000001d3878b2bUL;
   tf->codes[1321] = 0x0000000f2b4efe94UL;
   tf->codes[1322] = 0x0000000d9af1949dUL;
   tf->codes[1323] = 0x0000000bb5824d39UL;
   tf->codes[1324] = 0x0000000b8d8f5090UL;
   tf->codes[1325] = 0x0000000ed5e19d08UL;
   tf->codes[1326] = 0x000000060287437eUL;
   tf->codes[1327] = 0x00000008fe6ae5c2UL;
   tf->codes[1328] = 0x00000006c85ac058UL;
   tf->codes[1329] = 0x0000000b906be1b8UL;
   tf->codes[1330] = 0x0000000f9d423f65UL;
   tf->codes[1331] = 0x00000006efed81d6UL;
   tf->codes[1332] = 0x0000000781b67fa2UL;
   tf->codes[1333] = 0x0000000e1dd437acUL;
   tf->codes[1334] = 0x00000007a9201a8cUL;
   tf->codes[1335] = 0x0000000fb444c819UL;
   tf->codes[1336] = 0x0000000ce75af959UL;
   tf->codes[1337] = 0x000000086df6e72bUL;
   tf->codes[1338] = 0x0000000756695aa7UL;
   tf->codes[1339] = 0x0000000b7b2bddf2UL;
   tf->codes[1340] = 0x0000000f19a1b99eUL;
   tf->codes[1341] = 0x00000009a5790e90UL;
   tf->codes[1342] = 0x00000001d3b3eac0UL;
   tf->codes[1343] = 0x0000000a5c5d9d2bUL;
   tf->codes[1344] = 0x0000000152850218UL;
   tf->codes[1345] = 0x0000000025c4ba6eUL;
   tf->codes[1346] = 0x0000000d4a5f4bebUL;
   tf->codes[1347] = 0x0000000709cec10eUL;
   tf->codes[1348] = 0x000000094ddbdb6cUL;
   tf->codes[1349] = 0x00000009d1218277UL;
   tf->codes[1350] = 0x00000006190ca34aUL;
   tf->codes[1351] = 0x0000000468ed6a3fUL;
   tf->codes[1352] = 0x0000000801bda52eUL;
   tf->codes[1353] = 0x0000000261b3f1a9UL;
   tf->codes[1354] = 0x00000000b3494d9bUL;
   tf->codes[1355] = 0x0000000583e2d7e5UL;
   tf->codes[1356] = 0x00000009407a80f2UL;
   tf->codes[1357] = 0x000000058e902456UL;
   tf->codes[1358] = 0x00000009108c2273UL;
   tf->codes[1359] = 0x000000059778ff8cUL;
   tf->codes[1360] = 0x0000000d6ce05028UL;
   tf->codes[1361] = 0x00000000286adc62UL;
   tf->codes[1362] = 0x00000007ed3060dcUL;
   tf->codes[1363] = 0x000000057b7e03edUL;
   tf->codes[1364] = 0x00000003e3dce5c1UL;
   tf->codes[1365] = 0x00000001bebc2295UL;
   tf->codes[1366] = 0x0000000014a17c9aUL;
   tf->codes[1367] = 0x0000000c7d90fbdaUL;
   tf->codes[1368] = 0x00000008158ae35aUL;
   tf->codes[1369] = 0x000000069d70a335UL;
   tf->codes[1370] = 0x0000000d3ef97931UL;
   tf->codes[1371] = 0x00000005793efb7aUL;
   tf->codes[1372] = 0x0000000e6989ef43UL;
   tf->codes[1373] = 0x0000000cd15f0116UL;
   tf->codes[1374] = 0x0000000f9dbc6e25UL;
   tf->codes[1375] = 0x0000000da4a91117UL;
   tf->codes[1376] = 0x0000000054d0917aUL;
   tf->codes[1377] = 0x000000060f2c3f15UL;
   tf->codes[1378] = 0x00000007393b0a66UL;
   tf->codes[1379] = 0x00000006630ed79bUL;
   tf->codes[1380] = 0x0000000ed8589c60UL;
   tf->codes[1381] = 0x00000007db37ab26UL;
   tf->codes[1382] = 0x0000000c4631e80aUL;
   tf->codes[1383] = 0x00000001badaf501UL;
   tf->codes[1384] = 0x00000009bdef764dUL;
   tf->codes[1385] = 0x0000000dd0949b4bUL;
   tf->codes[1386] = 0x000000086f116771UL;
   tf->codes[1387] = 0x0000000acd7ea109UL;
   tf->codes[1388] = 0x00000007cc9d2f6bUL;
   tf->codes[1389] = 0x00000003f5598822UL;
   tf->codes[1390] = 0x00000004ba5a8d0cUL;
   tf->codes[1391] = 0x000000066e7f9c42UL;
   tf->codes[1392] = 0x000000033127fb36UL;
   tf->codes[1393] = 0x00000000c85ff976UL;
   tf->codes[1394] = 0x00000009dbb32ddfUL;
   tf->codes[1395] = 0x00000003d06c7a56UL;
   tf->codes[1396] = 0x0000000ac07601ddUL;
   tf->codes[1397] = 0x00000005fda3d7e9UL;
   tf->codes[1398] = 0x000000040a47aef0UL;
   tf->codes[1399] = 0x0000000139928cd0UL;
   tf->codes[1400] = 0x0000000183ab75ebUL;
   tf->codes[1401] = 0x00000009dd6d1f4bUL;
   tf->codes[1402] = 0x0000000954afec44UL;
   tf->codes[1403] = 0x000000029953fe22UL;
   tf->codes[1404] = 0x0000000f947e49b1UL;
   tf->codes[1405] = 0x0000000a74266cb0UL;
   tf->codes[1406] = 0x00000003bbb7fdabUL;
   tf->codes[1407] = 0x00000008a72b63d1UL;
   tf->codes[1408] = 0x00000008763e2fbbUL;
   tf->codes[1409] = 0x00000008c9b4f9a2UL;
   tf->codes[1410] = 0x0000000a35f5a861UL;
   tf->codes[1411] = 0x000000099e54752cUL;
   tf->codes[1412] = 0x00000002fdb8e16fUL;
   tf->codes[1413] = 0x00000002d083ed68UL;
   tf->codes[1414] = 0x0000000a05d36c5eUL;
   tf->codes[1415] = 0x00000005460842feUL;
   tf->codes[1416] = 0x0000000173ae0ee6UL;
   tf->codes[1417] = 0x000000038b3c62e5UL;
   tf->codes[1418] = 0x0000000476c1ae99UL;
   tf->codes[1419] = 0x00000009a8cb898aUL;
   tf->codes[1420] = 0x000000019d4032acUL;
   tf->codes[1421] = 0x0000000a9c01d80bUL;
   tf->codes[1422] = 0x0000000ca7d5e4deUL;
   tf->codes[1423] = 0x0000000295d53115UL;
   tf->codes[1424] = 0x0000000b26740e51UL;
   tf->codes[1425] = 0x0000000bf21b0988UL;
   tf->codes[1426] = 0x0000000167391c15UL;
   tf->codes[1427] = 0x0000000d10af35c6UL;
   tf->codes[1428] = 0x0000000d94750799UL;
   tf->codes[1429] = 0x0000000cb986d117UL;
   tf->codes[1430] = 0x000000001dddf588UL;
   tf->codes[1431] = 0x000000071ed85f46UL;
   tf->codes[1432] = 0x0000000a5437d58fUL;
   tf->codes[1433] = 0x00000004029d1e25UL;
   tf->codes[1434] = 0x0000000c580ec972UL;
   tf->codes[1435] = 0x00000006847df8baUL;
   tf->codes[1436] = 0x0000000e294d997bUL;
   tf->codes[1437] = 0x0000000e2e8b10eeUL;
   tf->codes[1438] = 0x00000001593103ddUL;
   tf->codes[1439] = 0x0000000222103857UL;
   tf->codes[1440] = 0x00000001e035591dUL;
   tf->codes[1441] = 0x0000000b5c9ef2e9UL;
   tf->codes[1442] = 0x00000009f815ec3eUL;
   tf->codes[1443] = 0x0000000d1da2a021UL;
   tf->codes[1444] = 0x000000054f171191UL;
   tf->codes[1445] = 0x0000000e51f4a05eUL;
   tf->codes[1446] = 0x0000000c15e7d603UL;
   tf->codes[1447] = 0x0000000ba7f16b87UL;
   tf->codes[1448] = 0x000000080b7a83e1UL;
   tf->codes[1449] = 0x0000000720e2b18dUL;
   tf->codes[1450] = 0x00000005ec0c069dUL;
   tf->codes[1451] = 0x0000000a4f9f689cUL;
   tf->codes[1452] = 0x00000005871cafdaUL;
   tf->codes[1453] = 0x0000000c913140a2UL;
   tf->codes[1454] = 0x00000007a8f2efd1UL;
   tf->codes[1455] = 0x000000077064952cUL;
   tf->codes[1456] = 0x00000004ea2d857fUL;
   tf->codes[1457] = 0x0000000484523555UL;
   tf->codes[1458] = 0x000000054971a9e3UL;
   tf->codes[1459] = 0x0000000eb0694eb2UL;
   tf->codes[1460] = 0x0000000b513c8e63UL;
   tf->codes[1461] = 0x00000005c910db58UL;
   tf->codes[1462] = 0x0000000ca87a4dd7UL;
   tf->codes[1463] = 0x0000000b8ca63158UL;
   tf->codes[1464] = 0x0000000b4b09431dUL;
   tf->codes[1465] = 0x00000003dc9d50b7UL;
   tf->codes[1466] = 0x00000007d57f02acUL;
   tf->codes[1467] = 0x00000005c595b1b2UL;
   tf->codes[1468] = 0x00000009e0caf698UL;
   tf->codes[1469] = 0x0000000136b48555UL;
   tf->codes[1470] = 0x0000000687dbcc2bUL;
   tf->codes[1471] = 0x000000054bae2294UL;
   tf->codes[1472] = 0x00000006899bbd7bUL;
   tf->codes[1473] = 0x00000008108f46deUL;
   tf->codes[1474] = 0x00000001dbe8cf08UL;
   tf->codes[1475] = 0x0000000a02e1ae1dUL;
   tf->codes[1476] = 0x00000000f5f26d59UL;
   tf->codes[1477] = 0x0000000805cf202bUL;
   tf->codes[1478] = 0x0000000afede5687UL;
   tf->codes[1479] = 0x00000001583d5b30UL;
   tf->codes[1480] = 0x0000000da9ed0620UL;
   tf->codes[1481] = 0x0000000cf1237338UL;
   tf->codes[1482] = 0x00000003a5a77bc4UL;
   tf->codes[1483] = 0x0000000a17ffa0c6UL;
   tf->codes[1484] = 0x000000029de4c387UL;
   tf->codes[1485] = 0x000000007825d431UL;
   tf->codes[1486] = 0x000000002d7b9b38UL;
   tf->codes[1487] = 0x00000008ed0f26aaUL;
   tf->codes[1488] = 0x000000056e54e30dUL;
   tf->codes[1489] = 0x00000009620ab0e7UL;
   tf->codes[1490] = 0x0000000c7e3ea94cUL;
   tf->codes[1491] = 0x0000000d288a41e2UL;
   tf->codes[1492] = 0x0000000f68884f1eUL;
   tf->codes[1493] = 0x00000005ee02df09UL;
   tf->codes[1494] = 0x0000000c02dbf645UL;
   tf->codes[1495] = 0x0000000eac4c2424UL;
   tf->codes[1496] = 0x0000000cab2d51e1UL;
   tf->codes[1497] = 0x0000000037439577UL;
   tf->codes[1498] = 0x00000005618ada43UL;
   tf->codes[1499] = 0x00000002683b5859UL;
   tf->codes[1500] = 0x00000008a607c1ceUL;
   tf->codes[1501] = 0x0000000795fd9198UL;
   tf->codes[1502] = 0x0000000b3edb11b8UL;
   tf->codes[1503] = 0x0000000846939c5cUL;
   tf->codes[1504] = 0x00000008b1f6fa23UL;
   tf->codes[1505] = 0x0000000b1a2f2bfeUL;
   tf->codes[1506] = 0x0000000b63a07ad7UL;
   tf->codes[1507] = 0x00000005f8ea7b00UL;
   tf->codes[1508] = 0x00000004ee9c6d0cUL;
   tf->codes[1509] = 0x0000000990f2889bUL;
   tf->codes[1510] = 0x0000000b7f7251d0UL;
   tf->codes[1511] = 0x0000000ac3291369UL;
   tf->codes[1512] = 0x00000009d8f36a7bUL;
   tf->codes[1513] = 0x0000000d57342897UL;
   tf->codes[1514] = 0x0000000efca98365UL;
   tf->codes[1515] = 0x0000000dacc69f0eUL;
   tf->codes[1516] = 0x00000003a70e4b3cUL;
   tf->codes[1517] = 0x00000001e95c34c2UL;
   tf->codes[1518] = 0x00000004caab6c06UL;
   tf->codes[1519] = 0x00000007231f6ee1UL;
   tf->codes[1520] = 0x000000037909aa04UL;
   tf->codes[1521] = 0x0000000048c9a9ccUL;
   tf->codes[1522] = 0x000000059cd081bcUL;
   tf->codes[1523] = 0x00000004dd78c2e4UL;
   tf->codes[1524] = 0x00000004979da10fUL;
   tf->codes[1525] = 0x000000004749d0c5UL;
   tf->codes[1526] = 0x0000000a17a4283bUL;
   tf->codes[1527] = 0x0000000de7e1d52dUL;
   tf->codes[1528] = 0x00000000e47cedf1UL;
   tf->codes[1529] = 0x00000004fa48cbffUL;
   tf->codes[1530] = 0x0000000545a932a0UL;
   tf->codes[1531] = 0x00000006c2bd9eb8UL;
   tf->codes[1532] = 0x0000000dd9bd3b8cUL;
   tf->codes[1533] = 0x000000043332c1baUL;
   tf->codes[1534] = 0x0000000501fa761dUL;
   tf->codes[1535] = 0x00000007ec40adbbUL;
   tf->codes[1536] = 0x00000004049f2b33UL;
   tf->codes[1537] = 0x0000000cde28f57bUL;
   tf->codes[1538] = 0x0000000f68c804b9UL;
   tf->codes[1539] = 0x00000008f50fbd3eUL;
   tf->codes[1540] = 0x000000054e1bc344UL;
   tf->codes[1541] = 0x000000036b26e3a2UL;
   tf->codes[1542] = 0x000000002e5ac9b1UL;
   tf->codes[1543] = 0x000000010837858dUL;
   tf->codes[1544] = 0x00000006ccac9e0bUL;
   tf->codes[1545] = 0x0000000625ba8a52UL;
   tf->codes[1546] = 0x0000000ac4c8b45cUL;
   tf->codes[1547] = 0x0000000868678237UL;
   tf->codes[1548] = 0x00000004187235feUL;
   tf->codes[1549] = 0x0000000bd62663ceUL;
   tf->codes[1550] = 0x0000000ea832dfb2UL;
   tf->codes[1551] = 0x0000000d5a72f0a7UL;
   tf->codes[1552] = 0x00000000659c855eUL;
   tf->codes[1553] = 0x0000000bea7f5e48UL;
   tf->codes[1554] = 0x0000000ff9566715UL;
   tf->codes[1555] = 0x00000001bd06d99aUL;
   tf->codes[1556] = 0x00000009666c578cUL;
   tf->codes[1557] = 0x0000000c6527d3ecUL;
   tf->codes[1558] = 0x0000000b541f3c61UL;
   tf->codes[1559] = 0x0000000678a9ad70UL;
   tf->codes[1560] = 0x000000036eaadfa3UL;
   tf->codes[1561] = 0x0000000af74b01deUL;
   tf->codes[1562] = 0x000000054cc3cdc3UL;
   tf->codes[1563] = 0x0000000d2e587ce6UL;
   tf->codes[1564] = 0x00000008694b9349UL;
   tf->codes[1565] = 0x0000000d309898feUL;
   tf->codes[1566] = 0x00000005c3250e09UL;
   tf->codes[1567] = 0x000000084dcac28eUL;
   tf->codes[1568] = 0x0000000f72add2dfUL;
   tf->codes[1569] = 0x00000001901681a3UL;
   tf->codes[1570] = 0x000000009e6a8fd4UL;
   tf->codes[1571] = 0x000000012f614cd1UL;
   tf->codes[1572] = 0x00000006d7801ac4UL;
   tf->codes[1573] = 0x000000014cf1ca54UL;
   tf->codes[1574] = 0x000000012a7eb608UL;
   tf->codes[1575] = 0x00000005e7a3bf62UL;
   tf->codes[1576] = 0x00000000ba5056a2UL;
   tf->codes[1577] = 0x00000005bee44c9bUL;
   tf->codes[1578] = 0x0000000819d7dc86UL;
   tf->codes[1579] = 0x0000000062adc8fdUL;
   tf->codes[1580] = 0x0000000bd3155d41UL;
   tf->codes[1581] = 0x0000000cd8c6b38aUL;
   tf->codes[1582] = 0x0000000e320fd50eUL;
   tf->codes[1583] = 0x0000000e189d6655UL;
   tf->codes[1584] = 0x00000006863c2831UL;
   tf->codes[1585] = 0x00000000d2b9058fUL;
   tf->codes[1586] = 0x000000023bfad8faUL;
   tf->codes[1587] = 0x0000000199bd1216UL;
   tf->codes[1588] = 0x000000056138afd7UL;
   tf->codes[1589] = 0x0000000face83a93UL;
   tf->codes[1590] = 0x00000009554da725UL;
   tf->codes[1591] = 0x00000009b614dd91UL;
   tf->codes[1592] = 0x000000098acbca3fUL;
   tf->codes[1593] = 0x0000000d5f0d5f21UL;
   tf->codes[1594] = 0x0000000eb59039e1UL;
   tf->codes[1595] = 0x000000051d1ec82aUL;
   tf->codes[1596] = 0x0000000a366ef3baUL;
   tf->codes[1597] = 0x00000001ad0e01f0UL;
   tf->codes[1598] = 0x00000007f038ad0bUL;
   tf->codes[1599] = 0x00000003ee055321UL;
   tf->codes[1600] = 0x00000003bf2dcbb7UL;
   tf->codes[1601] = 0x0000000210e9856cUL;
   tf->codes[1602] = 0x0000000e4fea8231UL;
   tf->codes[1603] = 0x0000000b89444937UL;
   tf->codes[1604] = 0x000000058852cc34UL;
   tf->codes[1605] = 0x00000001ee29eea9UL;
   tf->codes[1606] = 0x0000000b919c79f2UL;
   tf->codes[1607] = 0x0000000ddc44d3adUL;
   tf->codes[1608] = 0x0000000ddcbd4777UL;
   tf->codes[1609] = 0x00000003c3982ba1UL;
   tf->codes[1610] = 0x0000000dc8ebc45dUL;
   tf->codes[1611] = 0x00000008b97712b1UL;
   tf->codes[1612] = 0x00000009702ea21eUL;
   tf->codes[1613] = 0x00000001f457e726UL;
   tf->codes[1614] = 0x000000027c6f6e26UL;
   tf->codes[1615] = 0x00000000a9797770UL;
   tf->codes[1616] = 0x0000000d7615f53bUL;
   tf->codes[1617] = 0x000000074f1cb6e1UL;
   tf->codes[1618] = 0x0000000a32e4d7dcUL;
   tf->codes[1619] = 0x00000002e89afd1dUL;
   tf->codes[1620] = 0x00000000b03704d5UL;
   tf->codes[1621] = 0x0000000cca58aab0UL;
   tf->codes[1622] = 0x00000001e5749225UL;
   tf->codes[1623] = 0x00000006e63a36baUL;
   tf->codes[1624] = 0x0000000562992099UL;
   tf->codes[1625] = 0x000000064701b950UL;
   tf->codes[1626] = 0x0000000f94ed6196UL;
   tf->codes[1627] = 0x0000000b3441b5f1UL;
   tf->codes[1628] = 0x0000000c64fac247UL;
   tf->codes[1629] = 0x0000000d72ebd98bUL;
   tf->codes[1630] = 0x0000000fa1985b23UL;
   tf->codes[1631] = 0x00000002df788358UL;
   tf->codes[1632] = 0x000000088838b488UL;
   tf->codes[1633] = 0x00000006091032b4UL;
   tf->codes[1634] = 0x000000025ff2d736UL;
   tf->codes[1635] = 0x0000000dce63d3d5UL;
   tf->codes[1636] = 0x0000000bb5970414UL;
   tf->codes[1637] = 0x000000044d8b5ffeUL;
   tf->codes[1638] = 0x0000000e1a5666d8UL;
   tf->codes[1639] = 0x0000000e34129125UL;
   tf->codes[1640] = 0x00000000e23854b1UL;
   tf->codes[1641] = 0x000000001b2a6dbeUL;
   tf->codes[1642] = 0x0000000d11507bcdUL;
   tf->codes[1643] = 0x0000000844531e6bUL;
   tf->codes[1644] = 0x0000000d864a8611UL;
   tf->codes[1645] = 0x0000000e2a5a7700UL;
   tf->codes[1646] = 0x00000002d178962aUL;
   tf->codes[1647] = 0x0000000156b07f01UL;
   tf->codes[1648] = 0x000000048b59fec3UL;
   tf->codes[1649] = 0x00000003d3d9d79cUL;
   tf->codes[1650] = 0x00000001846fb339UL;
   tf->codes[1651] = 0x0000000ddf1d03caUL;
   tf->codes[1652] = 0x00000000998abaf9UL;
   tf->codes[1653] = 0x0000000c9d76190bUL;
   tf->codes[1654] = 0x000000067354a1a8UL;
   tf->codes[1655] = 0x0000000cc89e2b09UL;
   tf->codes[1656] = 0x0000000353356834UL;
   tf->codes[1657] = 0x00000007ad97470eUL;
   tf->codes[1658] = 0x0000000f4d560524UL;
   tf->codes[1659] = 0x0000000534b7804eUL;
   tf->codes[1660] = 0x000000014290c632UL;
   tf->codes[1661] = 0x0000000b67d39d60UL;
   tf->codes[1662] = 0x000000035b166febUL;
   tf->codes[1663] = 0x000000088e6fb681UL;
   tf->codes[1664] = 0x0000000a0f82ae1aUL;
   tf->codes[1665] = 0x000000008460ce52UL;
   tf->codes[1666] = 0x00000008b06a9012UL;
   tf->codes[1667] = 0x0000000daf1299dcUL;
   tf->codes[1668] = 0x0000000629ab696cUL;
   tf->codes[1669] = 0x00000003113b448aUL;
   tf->codes[1670] = 0x00000000db5ca215UL;
   tf->codes[1671] = 0x00000003e00b1e2dUL;
   tf->codes[1672] = 0x000000085a87f5abUL;
   tf->codes[1673] = 0x0000000b3995ff20UL;
   tf->codes[1674] = 0x000000085661554dUL;
   tf->codes[1675] = 0x0000000e709c5384UL;
   tf->codes[1676] = 0x00000000111ca99bUL;
   tf->codes[1677] = 0x000000049e614279UL;
   tf->codes[1678] = 0x0000000f14677ec4UL;
   tf->codes[1679] = 0x00000008f6439bfbUL;
   tf->codes[1680] = 0x0000000749faa461UL;
   tf->codes[1681] = 0x00000001c4f9189aUL;
   tf->codes[1682] = 0x0000000e8e9015caUL;
   tf->codes[1683] = 0x0000000f6e68d510UL;
   tf->codes[1684] = 0x0000000b3819319fUL;
   tf->codes[1685] = 0x0000000da9f7119fUL;
   tf->codes[1686] = 0x00000007787f40f8UL;
   tf->codes[1687] = 0x0000000bc57f5716UL;
   tf->codes[1688] = 0x000000060ff2897eUL;
   tf->codes[1689] = 0x0000000b3a28a934UL;
   tf->codes[1690] = 0x000000010b34c97cUL;
   tf->codes[1691] = 0x0000000c14f53aedUL;
   tf->codes[1692] = 0x0000000d3c4eaf5dUL;
   tf->codes[1693] = 0x0000000b3148d39eUL;
   tf->codes[1694] = 0x000000007874ea02UL;
   tf->codes[1695] = 0x0000000f86692b4aUL;
   tf->codes[1696] = 0x00000005b03a0e8dUL;
   tf->codes[1697] = 0x0000000ce6db8cc6UL;
   tf->codes[1698] = 0x00000008233d5908UL;
   tf->codes[1699] = 0x0000000f163e3c06UL;
   tf->codes[1700] = 0x0000000dff854cceUL;
   tf->codes[1701] = 0x000000026706f1bcUL;
   tf->codes[1702] = 0x000000094c358653UL;
   tf->codes[1703] = 0x00000007384c9821UL;
   tf->codes[1704] = 0x0000000e51b8e5d5UL;
   tf->codes[1705] = 0x0000000eda32963bUL;
   tf->codes[1706] = 0x0000000a073f392fUL;
   tf->codes[1707] = 0x0000000c3ccfa213UL;
   tf->codes[1708] = 0x000000034adf5216UL;
   tf->codes[1709] = 0x0000000cb8da286bUL;
   tf->codes[1710] = 0x00000003b5fbbf08UL;
   tf->codes[1711] = 0x000000012812d1f8UL;
   tf->codes[1712] = 0x0000000c97c54c39UL;
   tf->codes[1713] = 0x0000000e1c3e36b9UL;
   tf->codes[1714] = 0x0000000abb8dc0edUL;
   tf->codes[1715] = 0x0000000019dcbbf6UL;
   tf->codes[1716] = 0x000000025b0d7c4dUL;
   tf->codes[1717] = 0x0000000045e6b5ceUL;
   tf->codes[1718] = 0x000000017dc086caUL;
   tf->codes[1719] = 0x0000000c3f425e6bUL;
   tf->codes[1720] = 0x00000006fdee14f8UL;
   tf->codes[1721] = 0x000000039155e6b4UL;
   tf->codes[1722] = 0x00000000a191ec15UL;
   tf->codes[1723] = 0x0000000398fcd7f4UL;
   tf->codes[1724] = 0x0000000a6e2b0594UL;
   tf->codes[1725] = 0x0000000fe5678d82UL;
   tf->codes[1726] = 0x0000000e317eba1fUL;
   tf->codes[1727] = 0x00000002c4f10ca1UL;
   tf->codes[1728] = 0x0000000ae239c19eUL;
   tf->codes[1729] = 0x000000018e663ed2UL;
   tf->codes[1730] = 0x00000004a040b7e7UL;
   tf->codes[1731] = 0x0000000bbca0849cUL;
   tf->codes[1732] = 0x0000000ce05b3a74UL;
   tf->codes[1733] = 0x00000007cee982fdUL;
   tf->codes[1734] = 0x000000078ee54fa7UL;
   tf->codes[1735] = 0x00000007b47bb0bdUL;
   tf->codes[1736] = 0x00000007e8f19216UL;
   tf->codes[1737] = 0x0000000d67d91cedUL;
   tf->codes[1738] = 0x0000000ef5effe94UL;
   tf->codes[1739] = 0x0000000ec1d1938dUL;
   tf->codes[1740] = 0x00000004c05ef70eUL;
   tf->codes[1741] = 0x00000000324442d9UL;
   tf->codes[1742] = 0x0000000fb0183bb4UL;
   tf->codes[1743] = 0x0000000fb7a0bd50UL;
   tf->codes[1744] = 0x000000089aa17d87UL;
   tf->codes[1745] = 0x0000000e4e6aed89UL;
   tf->codes[1746] = 0x0000000dbecf68b4UL;
   tf->codes[1747] = 0x0000000683770de4UL;
   tf->codes[1748] = 0x0000000b9f41a136UL;
   tf->codes[1749] = 0x0000000c7614caceUL;
   tf->codes[1750] = 0x000000089c298386UL;
   tf->codes[1751] = 0x0000000959cf09deUL;
   tf->codes[1752] = 0x0000000ab30b19e3UL;
   tf->codes[1753] = 0x0000000db2e4b614UL;
   tf->codes[1754] = 0x000000026d30d39bUL;
   tf->codes[1755] = 0x00000006ccefe452UL;
   tf->codes[1756] = 0x0000000587c5035cUL;
   tf->codes[1757] = 0x0000000ea73bbbe0UL;
   tf->codes[1758] = 0x0000000dd9d91a11UL;
   tf->codes[1759] = 0x0000000dd8c5e851UL;
   tf->codes[1760] = 0x0000000e8b4aa077UL;
   tf->codes[1761] = 0x00000008ccf8faddUL;
   tf->codes[1762] = 0x000000047ddd3c0bUL;
   tf->codes[1763] = 0x0000000635a92f19UL;
   tf->codes[1764] = 0x0000000f0edfd1a3UL;
   tf->codes[1765] = 0x00000001f760bf5eUL;
   tf->codes[1766] = 0x0000000a83feb68aUL;
   tf->codes[1767] = 0x00000004f74da9ddUL;
   tf->codes[1768] = 0x000000052f759252UL;
   tf->codes[1769] = 0x000000098bee689eUL;
   tf->codes[1770] = 0x0000000c5fc8c3d5UL;
   tf->codes[1771] = 0x00000008373d1286UL;
   tf->codes[1772] = 0x0000000f5f1cdabdUL;
   tf->codes[1773] = 0x0000000ada68d3e5UL;
   tf->codes[1774] = 0x00000003bbb9eb5eUL;
   tf->codes[1775] = 0x000000050cde8478UL;
   tf->codes[1776] = 0x0000000f01f956e0UL;
   tf->codes[1777] = 0x0000000a922f2842UL;
   tf->codes[1778] = 0x0000000233a8b25aUL;
   tf->codes[1779] = 0x000000071118b754UL;
   tf->codes[1780] = 0x0000000b7f874552UL;
   tf->codes[1781] = 0x000000044d757121UL;
   tf->codes[1782] = 0x0000000b873b14ccUL;
   tf->codes[1783] = 0x00000005bcc1db5cUL;
   tf->codes[1784] = 0x0000000bf9b895ceUL;
   tf->codes[1785] = 0x00000005e65bb620UL;
   tf->codes[1786] = 0x0000000bbd1ed35cUL;
   tf->codes[1787] = 0x0000000358e79973UL;
   tf->codes[1788] = 0x000000062aa5a4a5UL;
   tf->codes[1789] = 0x000000081715fc0fUL;
   tf->codes[1790] = 0x00000008df03a76eUL;
   tf->codes[1791] = 0x0000000376b7c6c7UL;
   tf->codes[1792] = 0x0000000a07a49f2eUL;
   tf->codes[1793] = 0x000000045e159b63UL;
   tf->codes[1794] = 0x0000000dae5706b0UL;
   tf->codes[1795] = 0x0000000b5e52c7ccUL;
   tf->codes[1796] = 0x0000000206935e8eUL;
   tf->codes[1797] = 0x000000039f0c5119UL;
   tf->codes[1798] = 0x00000003cd58c574UL;
   tf->codes[1799] = 0x0000000571986d35UL;
   tf->codes[1800] = 0x0000000ad66da60fUL;
   tf->codes[1801] = 0x000000002b1a6315UL;
   tf->codes[1802] = 0x0000000d0131b533UL;
   tf->codes[1803] = 0x0000000741a195c5UL;
   tf->codes[1804] = 0x00000000b8663437UL;
   tf->codes[1805] = 0x00000001cde52798UL;
   tf->codes[1806] = 0x00000006b8e658b1UL;
   tf->codes[1807] = 0x0000000b43c0d44dUL;
   tf->codes[1808] = 0x000000045481d697UL;
   tf->codes[1809] = 0x000000029de93df5UL;
   tf->codes[1810] = 0x000000010549b874UL;
   tf->codes[1811] = 0x0000000c056b5828UL;
   tf->codes[1812] = 0x000000003fa830adUL;
   tf->codes[1813] = 0x00000009496d14faUL;
   tf->codes[1814] = 0x0000000f540592a0UL;
   tf->codes[1815] = 0x0000000f31c8b855UL;
   tf->codes[1816] = 0x000000064f2ba36bUL;
   tf->codes[1817] = 0x0000000fe7c6e4f5UL;
   tf->codes[1818] = 0x00000005e42a78b0UL;
   tf->codes[1819] = 0x00000009c2b8b096UL;
   tf->codes[1820] = 0x0000000dcb4a6e71UL;
   tf->codes[1821] = 0x0000000d63b0e7edUL;
   tf->codes[1822] = 0x0000000de1bcbcdaUL;
   tf->codes[1823] = 0x000000068e7161f2UL;
   tf->codes[1824] = 0x00000003e5ddf88dUL;
   tf->codes[1825] = 0x0000000419a37501UL;
   tf->codes[1826] = 0x0000000fad63e7abUL;
   tf->codes[1827] = 0x0000000c6e81b4baUL;
   tf->codes[1828] = 0x00000008329315d3UL;
   tf->codes[1829] = 0x0000000c88d267e6UL;
   tf->codes[1830] = 0x000000073a0ac25fUL;
   tf->codes[1831] = 0x0000000e7b75690fUL;
   tf->codes[1832] = 0x0000000dcbb95be2UL;
   tf->codes[1833] = 0x00000007a1d2a059UL;
   tf->codes[1834] = 0x0000000d8fac361eUL;
   tf->codes[1835] = 0x00000006312ff5c9UL;
   tf->codes[1836] = 0x0000000d2cf50d54UL;
   tf->codes[1837] = 0x00000008c65fd00fUL;
   tf->codes[1838] = 0x0000000aa1636532UL;
   tf->codes[1839] = 0x0000000870c7285dUL;
   tf->codes[1840] = 0x00000001894f0b84UL;
   tf->codes[1841] = 0x00000004260cc5c3UL;
   tf->codes[1842] = 0x0000000e9997b9ecUL;
   tf->codes[1843] = 0x000000087a052144UL;
   tf->codes[1844] = 0x00000008706babf6UL;
   tf->codes[1845] = 0x0000000bd5f62ad3UL;
   tf->codes[1846] = 0x00000001a7895439UL;
   tf->codes[1847] = 0x0000000f7e294bbcUL;
   tf->codes[1848] = 0x0000000bcc27ca26UL;
   tf->codes[1849] = 0x00000003186a63d4UL;
   tf->codes[1850] = 0x00000007f3ede4a4UL;
   tf->codes[1851] = 0x0000000b64e32468UL;
   tf->codes[1852] = 0x000000071f250d53UL;
   tf->codes[1853] = 0x00000007c6513783UL;
   tf->codes[1854] = 0x0000000b1778714aUL;
   tf->codes[1855] = 0x000000094bf2c57fUL;
   tf->codes[1856] = 0x000000064a9f893aUL;
   tf->codes[1857] = 0x00000001305be654UL;
   tf->codes[1858] = 0x0000000493e0c9f6UL;
   tf->codes[1859] = 0x000000005ba6fed8UL;
   tf->codes[1860] = 0x0000000c4a0c7a06UL;
   tf->codes[1861] = 0x00000000cc2ec0ddUL;
   tf->codes[1862] = 0x0000000d9a6769afUL;
   tf->codes[1863] = 0x0000000724c78a49UL;
   tf->codes[1864] = 0x0000000c85c981a4UL;
   tf->codes[1865] = 0x000000012553c4cdUL;
   tf->codes[1866] = 0x000000083cb892b1UL;
   tf->codes[1867] = 0x0000000bc324ccc7UL;
   tf->codes[1868] = 0x0000000ef43f6c1dUL;
   tf->codes[1869] = 0x00000002d6748bb7UL;
   tf->codes[1870] = 0x00000005efdce2d7UL;
   tf->codes[1871] = 0x000000094af64f28UL;
   tf->codes[1872] = 0x0000000f9d58feb3UL;
   tf->codes[1873] = 0x0000000cf547ac63UL;
   tf->codes[1874] = 0x0000000ceb309febUL;
   tf->codes[1875] = 0x000000030beba8caUL;
   tf->codes[1876] = 0x00000008ab2e486aUL;
   tf->codes[1877] = 0x00000004a95d58adUL;
   tf->codes[1878] = 0x000000025ce07c46UL;
   tf->codes[1879] = 0x0000000712b93fd7UL;
   tf->codes[1880] = 0x00000007f46acc81UL;
   tf->codes[1881] = 0x000000064049d4beUL;
   tf->codes[1882] = 0x000000065303aa09UL;
   tf->codes[1883] = 0x0000000f3aad21b3UL;
   tf->codes[1884] = 0x00000002903a6cd0UL;
   tf->codes[1885] = 0x00000005a0e0467dUL;
   tf->codes[1886] = 0x00000003c4fa64e4UL;
   tf->codes[1887] = 0x00000005c6655126UL;
   tf->codes[1888] = 0x0000000b40a2a67fUL;
   tf->codes[1889] = 0x0000000b0c22c6e5UL;
   tf->codes[1890] = 0x00000001507e039bUL;
   tf->codes[1891] = 0x0000000b282b16b8UL;
   tf->codes[1892] = 0x0000000c0e14a3d3UL;
   tf->codes[1893] = 0x000000093d381427UL;
   tf->codes[1894] = 0x00000006bb55bb87UL;
   tf->codes[1895] = 0x0000000b675af72fUL;
   tf->codes[1896] = 0x0000000fceb4f95eUL;
   tf->codes[1897] = 0x000000066af6ebbdUL;
   tf->codes[1898] = 0x000000020a44d1f2UL;
   tf->codes[1899] = 0x00000006bc873916UL;
   tf->codes[1900] = 0x0000000b8947bee8UL;
   tf->codes[1901] = 0x00000004b6bed8a6UL;
   tf->codes[1902] = 0x00000007012f7867UL;
   tf->codes[1903] = 0x00000007eda3c150UL;
   tf->codes[1904] = 0x0000000ab3ef1b8eUL;
   tf->codes[1905] = 0x00000006d71466eeUL;
   tf->codes[1906] = 0x0000000408c4e225UL;
   tf->codes[1907] = 0x0000000e117838b1UL;
   tf->codes[1908] = 0x00000000aef3a075UL;
   tf->codes[1909] = 0x00000005a0779d4fUL;
   tf->codes[1910] = 0x000000070a3b1d69UL;
   tf->codes[1911] = 0x000000026ccd31fdUL;
   tf->codes[1912] = 0x0000000ed64dd1b2UL;
   tf->codes[1913] = 0x0000000981d4f60cUL;
   tf->codes[1914] = 0x00000006a6e4fb61UL;
   tf->codes[1915] = 0x000000052f15fc93UL;
   tf->codes[1916] = 0x0000000032b3a64dUL;
   tf->codes[1917] = 0x0000000ecb17d667UL;
   tf->codes[1918] = 0x0000000a983fb935UL;
   tf->codes[1919] = 0x000000037d23c88dUL;
   tf->codes[1920] = 0x0000000b8590fbcbUL;
   tf->codes[1921] = 0x0000000ec2f1a277UL;
   tf->codes[1922] = 0x000000090d3053e6UL;
   tf->codes[1923] = 0x0000000a36fa8ccdUL;
   tf->codes[1924] = 0x000000044bd08eccUL;
   tf->codes[1925] = 0x000000061dd197d9UL;
   tf->codes[1926] = 0x0000000a307cfd82UL;
   tf->codes[1927] = 0x00000001d09c2de4UL;
   tf->codes[1928] = 0x00000005f6d74368UL;
   tf->codes[1929] = 0x00000001327d1b2dUL;
   tf->codes[1930] = 0x0000000594cc36b9UL;
   tf->codes[1931] = 0x0000000fea1cba7cUL;
   tf->codes[1932] = 0x000000050c31262dUL;
   tf->codes[1933] = 0x0000000d99b1a6baUL;
   tf->codes[1934] = 0x00000001bf789cd2UL;
   tf->codes[1935] = 0x0000000e2f6f66f9UL;
   tf->codes[1936] = 0x000000013d5edfc6UL;
   tf->codes[1937] = 0x0000000bc3a9ab0cUL;
   tf->codes[1938] = 0x00000001da5b2734UL;
   tf->codes[1939] = 0x000000025ef4f2deUL;
   tf->codes[1940] = 0x0000000dcb55a50aUL;
   tf->codes[1941] = 0x00000009c6dbc6acUL;
   tf->codes[1942] = 0x000000089a838853UL;
   tf->codes[1943] = 0x0000000168f099eeUL;
   tf->codes[1944] = 0x0000000d51601760UL;
   tf->codes[1945] = 0x000000089f324f1aUL;
   tf->codes[1946] = 0x00000002cb1ec1eaUL;
   tf->codes[1947] = 0x00000006306de366UL;
   tf->codes[1948] = 0x0000000012a2f11eUL;
   tf->codes[1949] = 0x0000000b5c0bf797UL;
   tf->codes[1950] = 0x00000005c5f02be4UL;
   tf->codes[1951] = 0x00000005019f54beUL;
   tf->codes[1952] = 0x00000006ae4a096aUL;
   tf->codes[1953] = 0x00000004bce78778UL;
   tf->codes[1954] = 0x000000094b65b97fUL;
   tf->codes[1955] = 0x0000000d3f6e7bd2UL;
   tf->codes[1956] = 0x00000001fbd2a84cUL;
   tf->codes[1957] = 0x00000006d0127ab1UL;
   tf->codes[1958] = 0x00000003e82799aaUL;
   tf->codes[1959] = 0x00000004c1264dfeUL;
   tf->codes[1960] = 0x0000000cf69c9360UL;
   tf->codes[1961] = 0x00000004b43e5342UL;
   tf->codes[1962] = 0x000000035d1f0372UL;
   tf->codes[1963] = 0x0000000d78c18eb4UL;
   tf->codes[1964] = 0x0000000262574101UL;
   tf->codes[1965] = 0x0000000c2c5c7335UL;
   tf->codes[1966] = 0x0000000bad04051aUL;
   tf->codes[1967] = 0x00000001c481f94eUL;
   tf->codes[1968] = 0x00000003285aa0deUL;
   tf->codes[1969] = 0x00000008973e1f69UL;
   tf->codes[1970] = 0x00000005d238c694UL;
   tf->codes[1971] = 0x00000007b71847b9UL;
   tf->codes[1972] = 0x0000000242f5675cUL;
   tf->codes[1973] = 0x0000000cc5751c2dUL;
   tf->codes[1974] = 0x0000000e09bc620bUL;
   tf->codes[1975] = 0x00000000e4e904ddUL;
   tf->codes[1976] = 0x000000007ca4f1a7UL;
   tf->codes[1977] = 0x00000002ac79ae43UL;
   tf->codes[1978] = 0x0000000e213d4250UL;
   tf->codes[1979] = 0x0000000d4137c2b5UL;
   tf->codes[1980] = 0x0000000ddfce11bcUL;
   tf->codes[1981] = 0x0000000d1d658566UL;
   tf->codes[1982] = 0x0000000213f5b1bbUL;
   tf->codes[1983] = 0x0000000cd35be0a8UL;
   tf->codes[1984] = 0x0000000cc67d7f91UL;
   tf->codes[1985] = 0x0000000509bde098UL;
   tf->codes[1986] = 0x000000074d3d8f46UL;
   tf->codes[1987] = 0x000000051309c970UL;
   tf->codes[1988] = 0x000000053e2bdf66UL;
   tf->codes[1989] = 0x0000000a5dd3fed3UL;
   tf->codes[1990] = 0x0000000a4e69b212UL;
   tf->codes[1991] = 0x0000000b1d39936dUL;
   tf->codes[1992] = 0x00000006b6c8926bUL;
   tf->codes[1993] = 0x000000046540a7b0UL;
   tf->codes[1994] = 0x00000002eebc599fUL;
   tf->codes[1995] = 0x00000002e54a283eUL;
   tf->codes[1996] = 0x0000000f9a328a9cUL;
   tf->codes[1997] = 0x00000007ea9cfc53UL;
   tf->codes[1998] = 0x00000005cffa2bdbUL;
   tf->codes[1999] = 0x0000000464d16f8eUL;
   tf->codes[2000] = 0x0000000eb09444bcUL;
   tf->codes[2001] = 0x00000003f341b259UL;
   tf->codes[2002] = 0x00000004d112b108UL;
   tf->codes[2003] = 0x000000070cb94242UL;
   tf->codes[2004] = 0x0000000974ed4ffdUL;
   tf->codes[2005] = 0x00000001084da291UL;
   tf->codes[2006] = 0x000000085673ca39UL;
   tf->codes[2007] = 0x0000000d4d74766fUL;
   tf->codes[2008] = 0x000000064a68e1deUL;
   tf->codes[2009] = 0x0000000e35630caeUL;
   tf->codes[2010] = 0x00000002073229dbUL;
   tf->codes[2011] = 0x000000063d3a3902UL;
   tf->codes[2012] = 0x000000031598ee06UL;
   tf->codes[2013] = 0x0000000808d61126UL;
   tf->codes[2014] = 0x0000000029957984UL;
   tf->codes[2015] = 0x0000000d4f5f2649UL;
   tf->codes[2016] = 0x00000009ec8a706bUL;
   tf->codes[2017] = 0x0000000349981760UL;
   tf->codes[2018] = 0x0000000c93ab23a6UL;
   tf->codes[2019] = 0x00000002c7aa80daUL;
   tf->codes[2020] = 0x0000000866f102baUL;
   tf->codes[2021] = 0x0000000b15cff7bcUL;
   tf->codes[2022] = 0x000000066a13a4caUL;
   tf->codes[2023] = 0x000000054a755048UL;
   tf->codes[2024] = 0x0000000d13fdb8d9UL;
   tf->codes[2025] = 0x000000016ad5edf3UL;
   tf->codes[2026] = 0x0000000e043bb154UL;
   tf->codes[2027] = 0x0000000cc8755671UL;
   tf->codes[2028] = 0x0000000cf9b2bfd5UL;
   tf->codes[2029] = 0x00000003608890b4UL;
   tf->codes[2030] = 0x0000000330fef315UL;
   tf->codes[2031] = 0x0000000e3299ca65UL;
   tf->codes[2032] = 0x00000000b60765e1UL;
   tf->codes[2033] = 0x00000000e9bb17dcUL;
   tf->codes[2034] = 0x000000095f474d8bUL;
   tf->codes[2035] = 0x0000000e721d3d00UL;
   tf->codes[2036] = 0x0000000d4679e565UL;
   tf->codes[2037] = 0x0000000c80da6113UL;
   tf->codes[2038] = 0x000000098deeff30UL;
   tf->codes[2039] = 0x0000000c293bb871UL;
   tf->codes[2040] = 0x0000000e79132f48UL;
   tf->codes[2041] = 0x0000000b152dafbbUL;
   tf->codes[2042] = 0x000000055f6a4386UL;
   tf->codes[2043] = 0x0000000a1b8a4044UL;
   tf->codes[2044] = 0x00000004f4187b05UL;
   tf->codes[2045] = 0x00000000b17c2ed3UL;
   tf->codes[2046] = 0x000000095d75ba04UL;
   tf->codes[2047] = 0x0000000bbf12e96dUL;
   tf->codes[2048] = 0x00000006abd1a52fUL;
   tf->codes[2049] = 0x0000000f300bc991UL;
   tf->codes[2050] = 0x0000000f0a7385d4UL;
   tf->codes[2051] = 0x000000052964f82aUL;
   tf->codes[2052] = 0x0000000a9962925fUL;
   tf->codes[2053] = 0x0000000613b2eef1UL;
   tf->codes[2054] = 0x00000005fd2c92a8UL;
   tf->codes[2055] = 0x000000009ebecd05UL;
   tf->codes[2056] = 0x000000036002b87aUL;
   tf->codes[2057] = 0x0000000902c79eefUL;
   tf->codes[2058] = 0x0000000394e63c7eUL;
   tf->codes[2059] = 0x0000000133285064UL;
   tf->codes[2060] = 0x0000000f7cfe2d4bUL;
   tf->codes[2061] = 0x00000004f068522cUL;
   tf->codes[2062] = 0x000000096fea1a0fUL;
   tf->codes[2063] = 0x0000000c5a927b13UL;
   tf->codes[2064] = 0x0000000e9a2c1994UL;
   tf->codes[2065] = 0x00000005c53b3803UL;
   tf->codes[2066] = 0x0000000f636b6188UL;
   tf->codes[2067] = 0x0000000007c656e3UL;
   tf->codes[2068] = 0x000000026af1fc5fUL;
   tf->codes[2069] = 0x0000000ec2f40b78UL;
   tf->codes[2070] = 0x0000000faa1921e5UL;
   tf->codes[2071] = 0x00000006137a8b30UL;
   tf->codes[2072] = 0x0000000028674f7bUL;
   tf->codes[2073] = 0x00000003de184e35UL;
   tf->codes[2074] = 0x0000000eeef093e6UL;
   tf->codes[2075] = 0x0000000d44b3dae0UL;
   tf->codes[2076] = 0x0000000bb7ab7d93UL;
   tf->codes[2077] = 0x00000002ae18c956UL;
   tf->codes[2078] = 0x0000000cde492bd6UL;
   tf->codes[2079] = 0x00000001cee0216eUL;
   tf->codes[2080] = 0x0000000f1e5830adUL;
   tf->codes[2081] = 0x000000076f6c3299UL;
   tf->codes[2082] = 0x0000000dea24af84UL;
   tf->codes[2083] = 0x0000000277e75586UL;
   tf->codes[2084] = 0x0000000a17318024UL;
   tf->codes[2085] = 0x00000005c4739486UL;
   tf->codes[2086] = 0x00000005e3de4725UL;
   tf->codes[2087] = 0x00000006f67c9f6dUL;
   tf->codes[2088] = 0x000000025f42791dUL;
   tf->codes[2089] = 0x00000003c54d15b3UL;
   tf->codes[2090] = 0x0000000ef98d9c32UL;
   tf->codes[2091] = 0x000000042f64819dUL;
   tf->codes[2092] = 0x000000016d5fd070UL;
   tf->codes[2093] = 0x000000063cb98d4fUL;
   tf->codes[2094] = 0x000000045a3ad27cUL;
   tf->codes[2095] = 0x00000001b496b0acUL;
   tf->codes[2096] = 0x0000000aa471c42dUL;
   tf->codes[2097] = 0x00000000599346a2UL;
   tf->codes[2098] = 0x00000000dc8d1c2dUL;
   tf->codes[2099] = 0x00000007498928c1UL;
   tf->codes[2100] = 0x0000000ea06e90ffUL;
   tf->codes[2101] = 0x0000000b683baa32UL;
   tf->codes[2102] = 0x0000000f93014e16UL;
   tf->codes[2103] = 0x000000020575d56eUL;
   tf->codes[2104] = 0x0000000794325589UL;
   tf->codes[2105] = 0x00000001533e9935UL;
   tf->codes[2106] = 0x000000086b8bcb70UL;
   tf->codes[2107] = 0x0000000ce11faf5dUL;
   tf->codes[2108] = 0x000000036c0bd318UL;
   tf->codes[2109] = 0x0000000e5e8c1167UL;
   tf->codes[2110] = 0x0000000e1831ba64UL;
   tf->codes[2111] = 0x0000000e088dbfa4UL;
   tf->codes[2112] = 0x0000000984479674UL;
   tf->codes[2113] = 0x0000000afef02b29UL;
   tf->codes[2114] = 0x000000048518c716UL;
   tf->codes[2115] = 0x00000004301564ceUL;
   tf->codes[2116] = 0x000000021cc88710UL;
   tf->codes[2117] = 0x0000000d5c995278UL;
   tf->codes[2118] = 0x0000000d8367de1cUL;
   tf->codes[2119] = 0x00000004a51125e8UL;
   tf->codes[2120] = 0x0000000113e1c226UL;
   tf->codes[2121] = 0x0000000ef141e076UL;
   tf->codes[2122] = 0x000000044097011dUL;
   tf->codes[2123] = 0x00000004ca9d707cUL;
   tf->codes[2124] = 0x000000040d8831f1UL;
   tf->codes[2125] = 0x0000000bd9c3b1d8UL;
   tf->codes[2126] = 0x0000000978364177UL;
   tf->codes[2127] = 0x000000010f7606a9UL;
   tf->codes[2128] = 0x000000046a64270aUL;
   tf->codes[2129] = 0x000000042df1b22bUL;
   tf->codes[2130] = 0x0000000e906cf2a0UL;
   tf->codes[2131] = 0x0000000997da6fa5UL;
   tf->codes[2132] = 0x0000000a5722c26fUL;
   tf->codes[2133] = 0x0000000b14f58aaaUL;
   tf->codes[2134] = 0x0000000afc167ad8UL;
   tf->codes[2135] = 0x000000037be56e60UL;
   tf->codes[2136] = 0x0000000de7f80d62UL;
   tf->codes[2137] = 0x00000000c3fb0a64UL;
   tf->codes[2138] = 0x0000000ce8ca802cUL;
   tf->codes[2139] = 0x000000035032ed9dUL;
   tf->codes[2140] = 0x0000000aa8ba3ee6UL;
   tf->codes[2141] = 0x000000094b2e707cUL;
   tf->codes[2142] = 0x00000002debbdae1UL;
   tf->codes[2143] = 0x0000000f53e25fcfUL;
   tf->codes[2144] = 0x0000000e935543ebUL;
   tf->codes[2145] = 0x00000001462f0e90UL;
   tf->codes[2146] = 0x000000054ce7d18cUL;
   tf->codes[2147] = 0x00000002ddafdc5fUL;
   tf->codes[2148] = 0x0000000700565deeUL;
   tf->codes[2149] = 0x0000000fd408e0afUL;
   tf->codes[2150] = 0x000000017d089decUL;
   tf->codes[2151] = 0x0000000833ea2459UL;
   tf->codes[2152] = 0x00000003c8d3776aUL;
   tf->codes[2153] = 0x00000002e5eebac8UL;
   tf->codes[2154] = 0x000000020cbf49b0UL;
   tf->codes[2155] = 0x0000000c44675eb7UL;
   tf->codes[2156] = 0x00000003a4b6beb1UL;
   tf->codes[2157] = 0x0000000ce6f37c1eUL;
   tf->codes[2158] = 0x000000063fba2e7cUL;
   tf->codes[2159] = 0x00000005a05b553dUL;
   tf->codes[2160] = 0x00000001286445b0UL;
   tf->codes[2161] = 0x00000005e07a9b61UL;
   tf->codes[2162] = 0x00000007d8397ea4UL;
   tf->codes[2163] = 0x00000008084b7bbbUL;
   tf->codes[2164] = 0x0000000b05b38097UL;
   tf->codes[2165] = 0x000000029c3019eeUL;
   tf->codes[2166] = 0x0000000ed1d2708bUL;
   tf->codes[2167] = 0x00000009df8a4d47UL;
   tf->codes[2168] = 0x0000000e4891e436UL;
   tf->codes[2169] = 0x00000002a762ab72UL;
   tf->codes[2170] = 0x000000092f70600fUL;
   tf->codes[2171] = 0x000000092329a2cdUL;
   tf->codes[2172] = 0x00000003e200c6edUL;
   tf->codes[2173] = 0x00000008c0a7233eUL;
   tf->codes[2174] = 0x000000060866806aUL;
   tf->codes[2175] = 0x0000000f4fddd24aUL;
   tf->codes[2176] = 0x0000000f78464c71UL;
   tf->codes[2177] = 0x00000009c3d22242UL;
   tf->codes[2178] = 0x00000003877ea6d1UL;
   tf->codes[2179] = 0x0000000e2a6d54acUL;
   tf->codes[2180] = 0x0000000497d2a5e7UL;
   tf->codes[2181] = 0x0000000ca82f781eUL;
   tf->codes[2182] = 0x0000000481524f4cUL;
   tf->codes[2183] = 0x0000000dee088814UL;
   tf->codes[2184] = 0x0000000b2a82d3a4UL;
   tf->codes[2185] = 0x00000008e6afe6e5UL;
   tf->codes[2186] = 0x0000000d6279a5daUL;
   tf->codes[2187] = 0x00000004567cbc1aUL;
   tf->codes[2188] = 0x00000005bec2b2fdUL;
   tf->codes[2189] = 0x00000004ef452505UL;
   tf->codes[2190] = 0x000000061d992cbaUL;
   tf->codes[2191] = 0x0000000ab96be0cbUL;
   tf->codes[2192] = 0x0000000708ef35d9UL;
   tf->codes[2193] = 0x0000000b3f6f3623UL;
   tf->codes[2194] = 0x000000036eb1801dUL;
   tf->codes[2195] = 0x0000000badfee917UL;
   tf->codes[2196] = 0x0000000a3db13cd0UL;
   tf->codes[2197] = 0x00000001d1a12828UL;
   tf->codes[2198] = 0x00000002500816ceUL;
   tf->codes[2199] = 0x0000000cf7612148UL;
   tf->codes[2200] = 0x00000000be6a3f4bUL;
   tf->codes[2201] = 0x000000074142f3daUL;
   tf->codes[2202] = 0x0000000ce5deed92UL;
   tf->codes[2203] = 0x0000000f9530a786UL;
   tf->codes[2204] = 0x0000000047c8bb38UL;
   tf->codes[2205] = 0x0000000fcabfe88fUL;
   tf->codes[2206] = 0x0000000bc83accb1UL;
   tf->codes[2207] = 0x000000020cd9fb1fUL;
   tf->codes[2208] = 0x0000000023dcceb3UL;
   tf->codes[2209] = 0x00000009e969b8c4UL;
   tf->codes[2210] = 0x00000006e28de934UL;
   tf->codes[2211] = 0x000000080a399667UL;
   tf->codes[2212] = 0x000000076a0b85adUL;
   tf->codes[2213] = 0x000000021a84be3cUL;
   tf->codes[2214] = 0x0000000a28d028b5UL;
   tf->codes[2215] = 0x0000000c4e7690dfUL;
   tf->codes[2216] = 0x0000000bfd9621e8UL;
   tf->codes[2217] = 0x00000006f4bc0c24UL;
   tf->codes[2218] = 0x0000000aa8e76bd7UL;
   tf->codes[2219] = 0x0000000deb55dac9UL;
   tf->codes[2220] = 0x0000000bb344fa8bUL;
   tf->codes[2221] = 0x0000000fcaab4decUL;
   tf->codes[2222] = 0x0000000146aba6cbUL;
   tf->codes[2223] = 0x0000000f49ed6eb8UL;
   tf->codes[2224] = 0x0000000dd57e9deaUL;
   tf->codes[2225] = 0x0000000225d5d090UL;
   tf->codes[2226] = 0x0000000d6e86c1c5UL;
   tf->codes[2227] = 0x0000000639be5f39UL;
   tf->codes[2228] = 0x0000000f5e7a6132UL;
   tf->codes[2229] = 0x0000000d2968b09fUL;
   tf->codes[2230] = 0x000000082b30ba1eUL;
   tf->codes[2231] = 0x0000000803fa46ccUL;
   tf->codes[2232] = 0x0000000c290fab00UL;
   tf->codes[2233] = 0x000000010df59de5UL;
   tf->codes[2234] = 0x000000051ae9dcfbUL;
   tf->codes[2235] = 0x000000049af8516dUL;
   tf->codes[2236] = 0x000000002b564ce6UL;
   tf->codes[2237] = 0x0000000c615a1de0UL;
   tf->codes[2238] = 0x0000000fef9864a4UL;
   tf->codes[2239] = 0x0000000c16e27341UL;
   tf->codes[2240] = 0x000000039e846736UL;
   tf->codes[2241] = 0x00000001ecbb6746UL;
   tf->codes[2242] = 0x0000000588d03a7cUL;
   tf->codes[2243] = 0x000000010a0eaf9cUL;
   tf->codes[2244] = 0x0000000671ccea6bUL;
   tf->codes[2245] = 0x000000033a154603UL;
   tf->codes[2246] = 0x0000000a7b003bc1UL;
   tf->codes[2247] = 0x0000000c5fc3848dUL;
   tf->codes[2248] = 0x000000078e50a9c7UL;
   tf->codes[2249] = 0x000000017dbfb88eUL;
   tf->codes[2250] = 0x00000004fd0ed541UL;
   tf->codes[2251] = 0x000000084221debaUL;
   tf->codes[2252] = 0x00000003132cf7e6UL;
   tf->codes[2253] = 0x0000000b67e7ac53UL;
   tf->codes[2254] = 0x0000000df6b28024UL;
   tf->codes[2255] = 0x0000000785b9f7edUL;
   tf->codes[2256] = 0x0000000e3d35320dUL;
   tf->codes[2257] = 0x0000000159c06583UL;
   tf->codes[2258] = 0x00000005c54a80a3UL;
   tf->codes[2259] = 0x0000000ed4d4533bUL;
   tf->codes[2260] = 0x0000000cf16c601aUL;
   tf->codes[2261] = 0x00000005e94efbd1UL;
   tf->codes[2262] = 0x00000005d587126eUL;
   tf->codes[2263] = 0x0000000eef2f2807UL;
   tf->codes[2264] = 0x000000009f3c558eUL;
   tf->codes[2265] = 0x0000000736cfd539UL;
   tf->codes[2266] = 0x0000000f5a922ae1UL;
   tf->codes[2267] = 0x00000004e2ab9959UL;
   tf->codes[2268] = 0x00000006a2dd34e7UL;
   tf->codes[2269] = 0x00000008c9d30d23UL;
   tf->codes[2270] = 0x0000000eba20b791UL;
   tf->codes[2271] = 0x0000000d5c5095e3UL;
   tf->codes[2272] = 0x0000000423d75a82UL;
   tf->codes[2273] = 0x000000040cebaafeUL;
   tf->codes[2274] = 0x000000065e08d288UL;
   tf->codes[2275] = 0x00000002e4f6d767UL;
   tf->codes[2276] = 0x0000000fe10d2f21UL;
   tf->codes[2277] = 0x0000000110347bdaUL;
   tf->codes[2278] = 0x0000000e43a9bfb3UL;
   tf->codes[2279] = 0x0000000cdea483ccUL;
   tf->codes[2280] = 0x0000000fb1e2d8c6UL;
   tf->codes[2281] = 0x0000000d8a0af7a7UL;
   tf->codes[2282] = 0x000000037d05b182UL;
   tf->codes[2283] = 0x00000008d1241d83UL;
   tf->codes[2284] = 0x0000000da1ea7b6eUL;
   tf->codes[2285] = 0x000000065bea93dbUL;
   tf->codes[2286] = 0x00000002a02f8753UL;
   tf->codes[2287] = 0x0000000454243289UL;
   tf->codes[2288] = 0x00000004150bc5a2UL;
   tf->codes[2289] = 0x0000000bbabe5911UL;
   tf->codes[2290] = 0x00000004cbcdbc59UL;
   tf->codes[2291] = 0x0000000f0e61340bUL;
   tf->codes[2292] = 0x000000030a2cdea8UL;
   tf->codes[2293] = 0x00000005daecb091UL;
   tf->codes[2294] = 0x00000005dc93d891UL;
   tf->codes[2295] = 0x0000000c501b4051UL;
   tf->codes[2296] = 0x0000000782cfba78UL;
   tf->codes[2297] = 0x00000004c191b61eUL;
   tf->codes[2298] = 0x0000000b7e27ef35UL;
   tf->codes[2299] = 0x000000005a476838UL;
   tf->codes[2300] = 0x00000009b0209574UL;
   tf->codes[2301] = 0x0000000a775164cfUL;
   tf->codes[2302] = 0x0000000d33d21701UL;
   tf->codes[2303] = 0x00000003afcb7d45UL;
   tf->codes[2304] = 0x00000004df2035cdUL;
   tf->codes[2305] = 0x0000000498819a21UL;
   tf->codes[2306] = 0x0000000293f9e506UL;
   tf->codes[2307] = 0x00000009a35ff1c8UL;
   tf->codes[2308] = 0x0000000c090ebe6bUL;
   tf->codes[2309] = 0x0000000a4f0551d4UL;
   tf->codes[2310] = 0x00000005dc0dc194UL;
   tf->codes[2311] = 0x00000001388aeb31UL;
   tf->codes[2312] = 0x0000000340b27bf4UL;
   tf->codes[2313] = 0x00000003a0f320abUL;
   tf->codes[2314] = 0x00000000996be75dUL;
   tf->codes[2315] = 0x0000000b257ecf39UL;
   tf->codes[2316] = 0x000000078d86f2f1UL;
   tf->codes[2317] = 0x0000000673f5ff91UL;
   tf->codes[2318] = 0x00000004538d7e3eUL;
   tf->codes[2319] = 0x0000000de5bc4369UL;
   return tf;
}

void tag36h10_destroy(apriltag_family_t *tf)
{
   free(tf->name);
   free(tf->codes);
   free(tf);
}
