#!/usr/bin/perl

use strict;
use warnings;

use lib '/usr/src/apt-cacher/src/lib';

require('apt-cacher.pl');

my $cfg = read_config('/dev/null'); # Get defaults with no config file


print <<"EOF"
#################################################################################
# This is the config file for apt-cacher. On most Debian systems you can safely #
# leave the defaults alone.                                                     #
#                                                                               #
# Commented defaults or examples are given. They can be changed here, or        #
# overridden using a fragment placed in ./conf.d/                               #
#################################################################################

### GENERAL ###

# The location of the local cache/working directory. This can become quite
# large, so make sure it is somewhere with plenty of space.
#
#cache_dir = $cfg->{cache_dir}

# The directory to use for apt-cacher access and error logs.
# The access log records every request in the format:
#
#  date-time|PID|client IP address|HIT/HEAD/MISS/EXPIRED/NOTMOD|object size|object name
#
# The error log is slightly more free-form, and is also used for debug messages
# if debug mode is turned on.
#
#log_dir = $cfg->{log_dir}

# The email address of the administrator is displayed in the info page and
# traffic reports.
#
#admin_email = $cfg->{admin_email}

# Daemon port setting, only useful in stand-alone mode. You need to run the
# daemon as root to use privileged ports (<1024).
#
# For standalone daemon auto startup settings please edit the file
# /etc/default/apt-cacher.
#
#daemon_port = $cfg->{daemon_port}

# Optional settings, user and group to run the daemon as. Make sure they have
# sufficient permissions within the cache and log directories. Comment the
# settings to run apt-cacher as the invoking user.
#
group = www-data
user = www-data

# optional setting, binds the listening daemon to specified IP(s).
#
#daemon_addr = localhost

# Apt-cacher can be used in offline mode which just uses files already cached,
# but doesn't make any new outgoing connections by setting this to 1.
#
#offline_mode = 1

# To enable data checksumming, install libberkeleydb-perl and set this option to
# 1. Then wait until the Packages/Sources files have been refreshed once (and so
# the database has been built up). You can also delete them from the cache to
# trigger the database update.
#
#checksum = 1

# Importing checksums from new index files into the checksum database can cause
# high CPU usage on slower systems. This option sets a limit to the number of
# index files that are imported simultaneously, thereby limiting CPU load
# average, but, possibly, taking longer. Set to 0 for no limit.
#
#concurrent_import_limit = 1

# CGI mode is deprecated.
#
# Send a 410 (Gone) HTTP message with the specified text when accessed via
# CGI. Useful to tell users to adapt their sources.list files when the
# apt-cacher server is being relocated (via apt-get's error messages while
# running "update")
#
#cgi_advise_to_use = Please use http://cacheserver:3142/ as apt-cacher access URL
#cgi_advise_to_use = Server relocated. To change sources.list, run \
# perl -pe "s,/apt-cacher\??,:3142," -i /etc/apt/sources.list
#
# To further facilitate migration from CGI to daemon mode this setting will
# automatically redirect incoming CGI requests to the specified daemon URL.
#
#cgi_redirect = http://localhost:3142/

### UPSTREAM PROXY ###

# Apt-cacher can pass all its requests to an external HTTP proxy like Squid,
# which could be very useful if you are using an ISP that blocks port 80 and
# requires all web traffic to go through its proxy. The format is
# 'http://[user[:password]@]hostname:port', eg: 'http://proxy.example.com:8080'.
#
#http_proxy = proxy.example.com:8080

# This sets the interface to use for the upstream connection.
# Specify an interface name, an IP address or a host name.
# If unset, the default route is used.
#
#interface = eth0

# Rate limiting sets the maximum bandwidth in bytes per second to use for
# fetching packages.  Use 0 value for no rate limiting.
#
#limit = $cfg->{limit}

### ACCESS and SECURITY ###

# Server mapping - this allows mapping virtual paths that appear in the access
# URL to real server names. The syntax is the part of the beginning of the URL
# to replace (the key), followed by a list of mirror URLs, all space
# separated. Multiple mappings are separated by semicolons or commas, as
# usual. Note that you need to specify all keys (or use the '%PATH_MAP%'
# shorthand) in the allowed_locations option, if you make use of it. Also note
# that the paths should not overlap each other.
#
# The keys are also used to separate the caching of multiple distributions
# within a single apt-cacher instance if distinct_namespaces is also set.
#
#path_map = debian ftp.uni-kl.de/pub/linux/debian ftp2.de.debian.org/debian ; \
# ubuntu archive.ubuntu.com/ubuntu ; \
# security security.debian.org/debian-security ftp2.de.debian.org/debian-security
#
# There are 2 default internal path_map settings for the Debian and Ubuntu
# changelog servers which will be merged with this option.
#
#   debian-changelogs packages.debian.org metadata.ftp-master.debian.org
#   ubuntu-changelogs changelogs.ubuntu.com
#
# These can be overridden by specifying an alternative mirror for that key, or
# deleted by just specifying the key with no mirror.
#
#path_map = debian-changelogs

# From version 1.7.0 there is support for caching multiple distibutions (eg
# Debian and Ubuntu) within the same apt-cacher instance. Enable this by setting
# distinct_namespaces to 1. Distribution package files are cached in separate
# directories whose names are derived from the relevant path_map key. So
# generally there will be a path_map key => server(s) setting for each
# distribution that is cached. Having enabled distinct_namespaces, existing
# packages can be imported into the correct directory by running (as root)
#
#  /usr/share/apt-cacher/apt-cacher-import.pl -u {cache_dir}/packages
#
#distinct_namespaces = $cfg->{distinct_namespaces}

# If the apt-cacher machine is directly exposed to the Internet and you are
# worried about unauthorised machines fetching packages through it, you can
# specify a list of IP addresses which are allowed to use it and another list of
# IP addresses which are prohibited.
#
# Localhost (127.0.0.1/8, ::ffff:127.0.0.1/8 and ::1) are always allowed. Other
# addresses must be matched by allowed_hosts and not by denied_hosts to be
# permitted to use the cache.  Setting allowed_hosts to "*" means "allow all"
# (which was the default before version 1.7.0). The default is now ''.
#
# The format is a comma-separated list containing addresses, optionally with
# masks (like 10.0.0.0/24 or 10.0.0.0/255.255.255.0), or ranges of addresses
# (two addresses separated by a hyphen with no masks, specifying a valid subnet,
# like '192.168.0.0-63' or '192.168.0.0 - 192.168.0.63') or a DNS resolvable
# hostname.  The corresponding IPv6 options allowed_hosts_6 and denied_hosts_6
# are deprecated (but will still be honoured, if set). IPv6 addresses can now be
# added directly to allowed_hosts and denied_hosts along with IPv4 addresses.
#
#allowed_hosts = *
#denied_hosts = $cfg->{denied_hosts}

# Only allow HTTPS/SSL proxy CONNECT to hosts or IPs which match an item in this
# list.
#
#allowed_ssl_locations =

# Only allow HTTPS/SSL proxy CONNECT to ports which match an item in this list.
# Adding further items to this option can pose a significant security risk.  DO
# NOT do it unless you understand the full implications.
#
#allowed_ssl_ports = $cfg->{allowed_ssl_ports}

# Optional setting to limit access to upstream mirrors based on server names in
# the URLs. This is matched before any path_map settings are expanded. If
# '%PATH_MAP%' in included in this option, it will be expanded to the keys of
# the path_map setting. Note these items are strings, not regexps.
#
#allowed_locations = ftp.uni-kl.de, ftp.nerim.net, debian.tu-bs.de/debian
#allowed_locations = ftp.debian.org, %PATH_MAP%
#allowed_locations = %PATH_MAP%

# List of Architectures that is used to expand %VALID_ARCHS% in *_files_regexps
# (see below).
#
#supported_archs = i386, amd64
#supported_archs = $cfg->{supported_archs}

# List of Ubuntu release names used to expand %VALID_UBUNTU_RELEASE_NAMES% in
# *_files_regexp (see below). This is required to allow the Ubuntu installer to
# fetch upgrade information. By default this is generated at runtime from the
# data shipped by the distro-info-data package, but it can be statically
# configured here.
#
#ubuntu_release_names = $cfg->{ubuntu_release_names}

### HOUSEKEEPING ###

# Apt-cacher can generate usage reports every 24 hours if you set this directive
# to 1. You can view the reports in a web browser by pointing to your cache
# machine with 'report' on the end, like this:
#
#      http://yourcache.example.com:3142/report
#
# Generating reports is very fast even with many thousands of logfile lines, so
# you can safely turn this on without creating much additional system load.
#
#generate_reports = $cfg->{generate_reports}

# Apt-cacher can clean up its cache directory every 24 hours if you set this
# directive to 1. Cleaning the cache can take some time to run (generally in the
# order of a few minutes) and removes all package files that are not mentioned
# in any existing 'Packages' lists. This has the effect of deleting packages
# that have been superseded by an updated 'Packages' list.
#
#clean_cache = $cfg->{clean_cache}

### INTERNALS ###

# Debug mode makes apt-cacher write a lot of extra debug information to the
# error log (whose location is defined with the 'log_dir' directive).  Leave
# this off unless you need it, or your error log will get very big. Acceptable
# values are 0 or an integer up to 7. See man apt-cacher (1) for further
# details.
#
#debug = $cfg->{debug}

# You shouldn't need to change anything below here. If you do, ensure you
# understand the full implications of doing so.

# As a convenience the following strings are expanded within the *_files_regexp
# settings at runtime:
#  %VALID_UBUNTU_RELEASE_NAMES% --> A regexp derived from ubuntu_release_names
#  %VALID_ARCHS% --> A regexp derived from supported_archs
#  %VALID_PACKAGE_NAME% --> A regexp matching valid package names
#  %VALID_VERSION% --> A regexp matching valid package versions

# Permitted package files -- this is a perl regular expression which matches all
# package-type files (files that are uniquely identified by their filename).
#
#package_files_regexp = $cfg->{package_files_regexp}

# Permitted APT pdiff files -- this is a perl regular expression which matches
# APT pdiff files which are ed(1) scripts used to patch index files rather than
# redownloading the whole file afresh.
#
#pdiff_files_regexp = $cfg->{pdiff_files_regexp}

# Permitted Index files -- this is the perl regular expression which matches all
# index-type files (files that are uniquely identified by their full path and
# need to be checked for freshness).
#
#index_files_regexp = $cfg->{index_files_regexp}

# Permitted installer files -- this is the perl regular expression which matches
# all installer-type files (files that are uniquely identified by their full
# path but don’t need to be checked for freshness). These are typically files
# used by Debian/Ubuntu Installer, Debian Live and apt.
#
#installer_files_regexp = $cfg->{installer_files_regexp}

# Perl regular expression which matches Index files from which to read checksums
# if checksum is enabled.
#
#checksum_files_regexp = $cfg->{checksum_files_regexp}

# Perl regular expression which matches files for which checksum validation is
# not performed. NB files matched by installer_files_regexp are skipped
# automatically and do not need to be added here as well.
#
#skip_checksum_files_regexp = $cfg->{skip_checksum_files_regexp}

# Perl regular expression which matches URLs to be permitted for Debian bugs
# SOAP requests as made by apt-listbugs(1).
#
#soap_url_regexp = $cfg->{soap_url_regexp}
EOF
