/*
 * Copyright (c) 2019 ARM Limited.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#include "arm.hpp"
#include "input.hpp"

namespace winograd
{

#ifdef __aarch64__

template <>
void InputTransform<6, 6, float, float, WinogradRoots::Integers>::transform_tile(
  int n_channels,
  const float* input_base,
  const int input_row_stride,
  const int input_col_stride,
  float* matrix_base,
  const int matrix_stride
)
{
  const float pcoeffs[4] = {1.0f, 2.0f, 4.0f, 5.0f};
  __asm__ __volatile__(
    "ldr q0, [%[pcoeffs]]\n"
    "add x25, %[inptr0], %[input_row_stride]\n"
    "add x18, %[input_col_stride1], %[input_col_stride1]\n"
    "add x16, x25, %[input_row_stride]\n"
    "add x19, x18, %[input_col_stride1]\n"
    "add x26, x16, %[input_row_stride]\n"
    "add x20, x19, %[input_col_stride1]\n"
    "add x17, x26, %[input_row_stride]\n"
    "add x21, x20, %[input_col_stride1]\n"
    "add x27, x17, %[input_row_stride]\n"
    "add x28, %[outptr0], %[output_row_stride]\n"
    "add x11, %[output_col_stride1], %[output_col_stride1]\n"
    "add x22, x28, %[output_row_stride]\n"
    "add x13, x11, %[output_col_stride1]\n"
    "add x12, x22, %[output_row_stride]\n"
    "add x23, x13, %[output_col_stride1]\n"
    "add x14, x12, %[output_row_stride]\n"
    "add x15, x23, %[output_col_stride1]\n"
    "add x24, x14, %[output_row_stride]\n"
    "cmp %w[n_channels], #4\n"
    "blt 2f\n"
    "1:\n"
    "ldr q8, [%[inptr0], x20]\n"
    "ldr q2, [%[inptr0], x18]\n"
    "mov v14.16b, v8.16b\n"
    "ldr q9, [%[inptr0]]\n"
    "mov v10.16b, v8.16b\n"
    "ldr q1, [%[inptr0], x21]\n"
    "fmla v14.4s, v9.4s, v0.s[2]\n"
    "ldr q4, [%[inptr0], x19]\n"
    "mov v9.16b, v8.16b\n"
    "ldr q12, [%[inptr0], %[input_col_stride1]]\n"
    "fmls v10.4s, v12.4s, v0.s[2]\n"
    "ldr q5, [x16, x20]\n"
    "fmls v14.4s, v2.4s, v0.s[3]\n"
    "ldr q20, [x16, x18]\n"
    "fmla v9.4s, v12.4s, v0.s[2]\n"
    "ldr q3, [x16]\n"
    "fmls v10.4s, v2.4s, v0.s[2]\n"
    "ldr q6, [x16, x21]\n"
    "mov v7.16b, v8.16b\n"
    "ldr q16, [x16, x19]\n"
    "fmls v9.4s, v2.4s, v0.s[2]\n"
    "ldr q22, [x16, %[input_col_stride1]]\n"
    "fadd v10.4s, v10.4s, v4.4s\n"
    "ldr q17, [x17, x20]\n"
    "fmls v7.4s, v12.4s, v0.s[1]\n"
    "ldr q15, [x17, x18]\n"
    "fsub v9.4s, v9.4s, v4.4s\n"
    "ldr q19, [x17]\n"
    "mov v8.16b, v8.16b\n"
    "ldr q18, [x17, x21]\n"
    "fsub v7.4s, v7.4s, v2.4s\n"
    "ldr q13, [x17, x19]\n"
    "fmla v7.4s, v4.4s, v0.s[1]\n"
    "ldr q21, [x17, %[input_col_stride1]]\n"
    "fmla v8.4s, v12.4s, v0.s[1]\n"
    "add %[inptr0], %[inptr0], #16\n"
    "mov v11.16b, v1.16b\n"
    "add x16, x16, #16\n"
    "mov v1.16b, v5.16b\n"
    "add x17, x17, #16\n"
    "fsub v8.4s, v8.4s, v2.4s\n"
    "fmla v11.4s, v12.4s, v0.s[2]\n"
    "fmls v8.4s, v4.4s, v0.s[1]\n"
    "fmla v1.4s, v3.4s, v0.s[2]\n"
    "mov v2.16b, v5.16b\n"
    "mov v3.16b, v5.16b\n"
    "fmls v11.4s, v4.4s, v0.s[3]\n"
    "mov v4.16b, v5.16b\n"
    "fmls v1.4s, v20.4s, v0.s[3]\n"
    "fmls v2.4s, v22.4s, v0.s[2]\n"
    "fmla v3.4s, v22.4s, v0.s[2]\n"
    "fmls v4.4s, v22.4s, v0.s[1]\n"
    "mov v5.16b, v5.16b\n"
    "mov v6.16b, v6.16b\n"
    "fmls v2.4s, v20.4s, v0.s[2]\n"
    "mov v12.16b, v17.16b\n"
    "fmls v3.4s, v20.4s, v0.s[2]\n"
    "fsub v4.4s, v4.4s, v20.4s\n"
    "fmla v4.4s, v16.4s, v0.s[1]\n"
    "fmla v5.4s, v22.4s, v0.s[1]\n"
    "fadd v2.4s, v2.4s, v16.4s\n"
    "fmla v6.4s, v22.4s, v0.s[2]\n"
    "fsub v3.4s, v3.4s, v16.4s\n"
    "fmla v12.4s, v19.4s, v0.s[2]\n"
    "fsub v5.4s, v5.4s, v20.4s\n"
    "mov v19.16b, v17.16b\n"
    "fmls v5.4s, v16.4s, v0.s[1]\n"
    "fmls v6.4s, v16.4s, v0.s[3]\n"
    "fmls v12.4s, v15.4s, v0.s[3]\n"
    "fmls v19.4s, v21.4s, v0.s[2]\n"
    "mov v20.16b, v17.16b\n"
    "mov v16.16b, v17.16b\n"
    "mov v17.16b, v17.16b\n"
    "mov v18.16b, v18.16b\n"
    "fmls v19.4s, v15.4s, v0.s[2]\n"
    "fmla v20.4s, v21.4s, v0.s[2]\n"
    "fmls v16.4s, v21.4s, v0.s[1]\n"
    "fmla v17.4s, v21.4s, v0.s[1]\n"
    "fmla v18.4s, v21.4s, v0.s[2]\n"
    "mov v23.16b, v12.16b\n"
    "fadd v19.4s, v19.4s, v13.4s\n"
    "fmls v20.4s, v15.4s, v0.s[2]\n"
    "fsub v16.4s, v16.4s, v15.4s\n"
    "fsub v17.4s, v17.4s, v15.4s\n"
    "fmla v16.4s, v13.4s, v0.s[1]\n"
    "fmls v17.4s, v13.4s, v0.s[1]\n"
    "fsub v20.4s, v20.4s, v13.4s\n"
    "fmls v18.4s, v13.4s, v0.s[3]\n"
    "fmla v23.4s, v14.4s, v0.s[2]\n"
    "mov v15.16b, v19.16b\n"
    "mov v14.16b, v20.16b\n"
    "mov v24.16b, v16.16b\n"
    "fmla v15.4s, v10.4s, v0.s[2]\n"
    "mov v10.16b, v17.16b\n"
    "fmls v23.4s, v1.4s, v0.s[3]\n"
    "fmla v14.4s, v9.4s, v0.s[2]\n"
    "fmla v24.4s, v7.4s, v0.s[2]\n"
    "fmla v10.4s, v8.4s, v0.s[2]\n"
    "fmls v15.4s, v2.4s, v0.s[3]\n"
    "mov v7.16b, v18.16b\n"
    "str q23, [%[outptr0]]\n"
    "fmls v14.4s, v3.4s, v0.s[3]\n"
    "fmls v24.4s, v4.4s, v0.s[3]\n"
    "fmls v10.4s, v5.4s, v0.s[3]\n"
    "str q15, [%[outptr0], %[output_col_stride1]]\n"
    "fmla v7.4s, v11.4s, v0.s[2]\n"
    "str q14, [%[outptr0], x11]\n"
    "str q24, [%[outptr0], x13]\n"
    "str q10, [%[outptr0], x23]\n"
    "fmls v7.4s, v6.4s, v0.s[3]\n"
    "str q7, [%[outptr0], x15]\n"
    "add %[outptr0], %[outptr0], #16\n"
    "mov v26.16b, v12.16b\n"
    "mov v25.16b, v19.16b\n"
    "ldr q11, [x25, x20]\n"
    "mov v10.16b, v11.16b\n"
    "ldr q23, [x25, x18]\n"
    "mov v9.16b, v11.16b\n"
    "ldr q7, [x25]\n"
    "fmla v10.4s, v7.4s, v0.s[2]\n"
    "ldr q13, [x25, x21]\n"
    "mov v7.16b, v11.16b\n"
    "ldr q31, [x25, x19]\n"
    "mov v8.16b, v11.16b\n"
    "ldr q21, [x25, %[input_col_stride1]]\n"
    "fmls v10.4s, v23.4s, v0.s[3]\n"
    "ldr q30, [x26, x20]\n"
    "fmls v9.4s, v21.4s, v0.s[2]\n"
    "ldr q29, [x26, x18]\n"
    "fmla v7.4s, v21.4s, v0.s[2]\n"
    "ldr q22, [x26]\n"
    "fmls v8.4s, v21.4s, v0.s[1]\n"
    "ldr q24, [x26, x21]\n"
    "fmls v9.4s, v23.4s, v0.s[2]\n"
    "ldr q27, [x26, x19]\n"
    "fmls v7.4s, v23.4s, v0.s[2]\n"
    "ldr q28, [x26, %[input_col_stride1]]\n"
    "fsub v8.4s, v8.4s, v23.4s\n"
    "add x25, x25, #16\n"
    "fadd v9.4s, v9.4s, v31.4s\n"
    "add x26, x26, #16\n"
    "fsub v7.4s, v7.4s, v31.4s\n"
    "fmla v8.4s, v31.4s, v0.s[1]\n"
    "mov v11.16b, v11.16b\n"
    "mov v15.16b, v13.16b\n"
    "mov v14.16b, v30.16b\n"
    "mov v13.16b, v30.16b\n"
    "fmla v11.4s, v21.4s, v0.s[1]\n"
    "fmla v15.4s, v21.4s, v0.s[2]\n"
    "fmla v14.4s, v22.4s, v0.s[2]\n"
    "fmls v13.4s, v28.4s, v0.s[2]\n"
    "mov v21.16b, v30.16b\n"
    "mov v22.16b, v30.16b\n"
    "fsub v11.4s, v11.4s, v23.4s\n"
    "fmls v15.4s, v31.4s, v0.s[3]\n"
    "fmls v11.4s, v31.4s, v0.s[1]\n"
    "fmls v14.4s, v29.4s, v0.s[3]\n"
    "fmls v13.4s, v29.4s, v0.s[2]\n"
    "fmla v21.4s, v28.4s, v0.s[2]\n"
    "fmls v22.4s, v28.4s, v0.s[1]\n"
    "mov v23.16b, v30.16b\n"
    "mov v24.16b, v24.16b\n"
    "fmls v26.4s, v10.4s, v0.s[2]\n"
    "fadd v13.4s, v13.4s, v27.4s\n"
    "fmls v21.4s, v29.4s, v0.s[2]\n"
    "fsub v22.4s, v22.4s, v29.4s\n"
    "fmla v23.4s, v28.4s, v0.s[1]\n"
    "fmla v22.4s, v27.4s, v0.s[1]\n"
    "fmla v24.4s, v28.4s, v0.s[2]\n"
    "fsub v21.4s, v21.4s, v27.4s\n"
    "fmls v26.4s, v1.4s, v0.s[2]\n"
    "fsub v23.4s, v23.4s, v29.4s\n"
    "fmls v25.4s, v9.4s, v0.s[2]\n"
    "fmls v23.4s, v27.4s, v0.s[1]\n"
    "fmls v24.4s, v27.4s, v0.s[3]\n"
    "fadd v26.4s, v26.4s, v14.4s\n"
    "mov v27.16b, v20.16b\n"
    "str q26, [x28]\n"
    "fmls v25.4s, v2.4s, v0.s[2]\n"
    "fmls v27.4s, v7.4s, v0.s[2]\n"
    "mov v31.16b, v16.16b\n"
    "mov v30.16b, v17.16b\n"
    "mov v29.16b, v18.16b\n"
    "fadd v25.4s, v25.4s, v13.4s\n"
    "fmls v31.4s, v8.4s, v0.s[2]\n"
    "str q25, [x28, %[output_col_stride1]]\n"
    "fmls v27.4s, v3.4s, v0.s[2]\n"
    "fmls v30.4s, v11.4s, v0.s[2]\n"
    "fmls v29.4s, v15.4s, v0.s[2]\n"
    "fmls v31.4s, v4.4s, v0.s[2]\n"
    "mov v26.16b, v12.16b\n"
    "fadd v27.4s, v27.4s, v21.4s\n"
    "mov v25.16b, v19.16b\n"
    "str q27, [x28, x11]\n"
    "fmls v30.4s, v5.4s, v0.s[2]\n"
    "fadd v31.4s, v31.4s, v22.4s\n"
    "fmls v29.4s, v6.4s, v0.s[2]\n"
    "str q31, [x28, x13]\n"
    "fmla v26.4s, v10.4s, v0.s[2]\n"
    "fadd v30.4s, v30.4s, v23.4s\n"
    "fmla v25.4s, v9.4s, v0.s[2]\n"
    "str q30, [x28, x23]\n"
    "fadd v29.4s, v29.4s, v24.4s\n"
    "str q29, [x28, x15]\n"
    "fmls v26.4s, v1.4s, v0.s[2]\n"
    "fmls v25.4s, v2.4s, v0.s[2]\n"
    "add x28, x28, #16\n"
    "mov v30.16b, v20.16b\n"
    "mov v29.16b, v16.16b\n"
    "fsub v26.4s, v26.4s, v14.4s\n"
    "mov v28.16b, v17.16b\n"
    "str q26, [x22]\n"
    "fsub v25.4s, v25.4s, v13.4s\n"
    "str q25, [x22, %[output_col_stride1]]\n"
    "fmla v30.4s, v7.4s, v0.s[2]\n"
    "fmla v29.4s, v8.4s, v0.s[2]\n"
    "fmla v28.4s, v11.4s, v0.s[2]\n"
    "mov v26.16b, v18.16b\n"
    "mov v25.16b, v12.16b\n"
    "fmls v30.4s, v3.4s, v0.s[2]\n"
    "mov v31.16b, v19.16b\n"
    "fmls v29.4s, v4.4s, v0.s[2]\n"
    "fmls v28.4s, v5.4s, v0.s[2]\n"
    "fmla v26.4s, v15.4s, v0.s[2]\n"
    "fmls v25.4s, v10.4s, v0.s[1]\n"
    "fsub v30.4s, v30.4s, v21.4s\n"
    "fmls v31.4s, v9.4s, v0.s[1]\n"
    "str q30, [x22, x11]\n"
    "fsub v29.4s, v29.4s, v22.4s\n"
    "str q29, [x22, x13]\n"
    "fsub v28.4s, v28.4s, v23.4s\n"
    "str q28, [x22, x23]\n"
    "fmls v26.4s, v6.4s, v0.s[2]\n"
    "fsub v25.4s, v25.4s, v1.4s\n"
    "fsub v31.4s, v31.4s, v2.4s\n"
    "fmla v25.4s, v14.4s, v0.s[1]\n"
    "fmla v31.4s, v13.4s, v0.s[1]\n"
    "fsub v26.4s, v26.4s, v24.4s\n"
    "mov v27.16b, v20.16b\n"
    "str q26, [x22, x15]\n"
    "mov v26.16b, v16.16b\n"
    "str q25, [x12]\n"
    "fmls v27.4s, v7.4s, v0.s[1]\n"
    "str q31, [x12, %[output_col_stride1]]\n"
    "fmls v26.4s, v8.4s, v0.s[1]\n"
    "mov v25.16b, v17.16b\n"
    "add x22, x22, #16\n"
    "fsub v27.4s, v27.4s, v3.4s\n"
    "mov v28.16b, v18.16b\n"
    "fmla v27.4s, v21.4s, v0.s[1]\n"
    "fsub v26.4s, v26.4s, v4.4s\n"
    "fmla v26.4s, v22.4s, v0.s[1]\n"
    "fmls v25.4s, v11.4s, v0.s[1]\n"
    "fmls v28.4s, v15.4s, v0.s[1]\n"
    "mov v12.16b, v12.16b\n"
    "str q27, [x12, x11]\n"
    "mov v19.16b, v19.16b\n"
    "str q26, [x12, x13]\n"
    "fsub v25.4s, v25.4s, v5.4s\n"
    "fmla v25.4s, v23.4s, v0.s[1]\n"
    "fsub v28.4s, v28.4s, v6.4s\n"
    "fmla v28.4s, v24.4s, v0.s[1]\n"
    "fmla v12.4s, v10.4s, v0.s[1]\n"
    "fmla v19.4s, v9.4s, v0.s[1]\n"
    "mov v20.16b, v20.16b\n"
    "str q25, [x12, x23]\n"
    "mov v16.16b, v16.16b\n"
    "str q28, [x12, x15]\n"
    "fsub v12.4s, v12.4s, v1.4s\n"
    "fmls v12.4s, v14.4s, v0.s[1]\n"
    "add x12, x12, #16\n"
    "fsub v19.4s, v19.4s, v2.4s\n"
    "fmla v20.4s, v7.4s, v0.s[1]\n"
    "fmls v19.4s, v13.4s, v0.s[1]\n"
    "fmla v16.4s, v8.4s, v0.s[1]\n"
    "str q12, [x14]\n"
    "mov v1.16b, v17.16b\n"
    "fsub v20.4s, v20.4s, v3.4s\n"
    "mov v17.16b, v18.16b\n"
    "str q19, [x14, %[output_col_stride1]]\n"
    "fmls v20.4s, v21.4s, v0.s[1]\n"
    "fsub v16.4s, v16.4s, v4.4s\n"
    "fmla v1.4s, v11.4s, v0.s[1]\n"
    "fmls v16.4s, v22.4s, v0.s[1]\n"
    "fmla v17.4s, v15.4s, v0.s[1]\n"
    "str q20, [x14, x11]\n"
    "fsub v1.4s, v1.4s, v5.4s\n"
    "str q16, [x14, x13]\n"
    "fmls v1.4s, v23.4s, v0.s[1]\n"
    "fsub v17.4s, v17.4s, v6.4s\n"
    "fmls v17.4s, v24.4s, v0.s[1]\n"
    "str q1, [x14, x23]\n"
    "str q17, [x14, x15]\n"
    "add x14, x14, #16\n"
    "ldr q2, [x27, x20]\n"
    "mov v4.16b, v2.16b\n"
    "ldr q17, [x27, x18]\n"
    "mov v12.16b, v2.16b\n"
    "ldr q18, [x27]\n"
    "fmla v4.4s, v18.4s, v0.s[2]\n"
    "ldr q3, [x27, x21]\n"
    "mov v6.16b, v2.16b\n"
    "ldr q5, [x27, x19]\n"
    "mov v1.16b, v2.16b\n"
    "ldr q18, [x27, %[input_col_stride1]]\n"
    "fmls v4.4s, v17.4s, v0.s[3]\n"
    "add x27, x27, #16\n"
    "fmls v12.4s, v18.4s, v0.s[2]\n"
    "sub %w[n_channels], %w[n_channels], #4\n"
    "fmla v6.4s, v18.4s, v0.s[2]\n"
    "cmp %w[n_channels], #4\n"
    "fmls v1.4s, v18.4s, v0.s[1]\n"
    "mov v2.16b, v2.16b\n"
    "fmls v12.4s, v17.4s, v0.s[2]\n"
    "mov v3.16b, v3.16b\n"
    "fmls v6.4s, v17.4s, v0.s[2]\n"
    "fmla v2.4s, v18.4s, v0.s[1]\n"
    "fsub v1.4s, v1.4s, v17.4s\n"
    "fmla v3.4s, v18.4s, v0.s[2]\n"
    "fadd v12.4s, v12.4s, v5.4s\n"
    "fmla v1.4s, v5.4s, v0.s[1]\n"
    "fsub v6.4s, v6.4s, v5.4s\n"
    "fsub v2.4s, v2.4s, v17.4s\n"
    "fmls v2.4s, v5.4s, v0.s[1]\n"
    "fmls v3.4s, v5.4s, v0.s[3]\n"
    "mov v4.16b, v4.16b\n"
    "mov v16.16b, v12.16b\n"
    "mov v5.16b, v6.16b\n"
    "mov v6.16b, v1.16b\n"
    "fmla v4.4s, v10.4s, v0.s[2]\n"
    "fmla v16.4s, v9.4s, v0.s[2]\n"
    "fmla v5.4s, v7.4s, v0.s[2]\n"
    "fmla v6.4s, v8.4s, v0.s[2]\n"
    "mov v9.16b, v2.16b\n"
    "mov v10.16b, v3.16b\n"
    "fmls v4.4s, v14.4s, v0.s[3]\n"
    "fmls v16.4s, v13.4s, v0.s[3]\n"
    "fmls v5.4s, v21.4s, v0.s[3]\n"
    "fmls v6.4s, v22.4s, v0.s[3]\n"
    "fmla v9.4s, v11.4s, v0.s[2]\n"
    "fmla v10.4s, v15.4s, v0.s[2]\n"
    "str q4, [x24]\n"
    "str q16, [x24, %[output_col_stride1]]\n"
    "str q5, [x24, x11]\n"
    "str q6, [x24, x13]\n"
    "fmls v9.4s, v23.4s, v0.s[3]\n"
    "fmls v10.4s, v24.4s, v0.s[3]\n"
    "str q9, [x24, x23]\n"
    "str q10, [x24, x15]\n"
    "add x24, x24, #16\n"
    "bge 1b\n"
    "2:\n"
    "cmp %w[n_channels], #2\n"
    "blt 3f\n"
    "ldr d8, [%[inptr0], x20]\n"
    "mov v14.16b, v8.16b\n"
    "ldr d2, [%[inptr0], x18]\n"
    "mov v10.16b, v8.16b\n"
    "ldr d9, [%[inptr0]]\n"
    "fmla v14.4s, v9.4s, v0.s[2]\n"
    "ldr d1, [%[inptr0], x21]\n"
    "mov v9.16b, v8.16b\n"
    "ldr d4, [%[inptr0], x19]\n"
    "mov v7.16b, v8.16b\n"
    "ldr d12, [%[inptr0], %[input_col_stride1]]\n"
    "fmls v14.4s, v2.4s, v0.s[3]\n"
    "ldr d5, [x16, x20]\n"
    "fmls v10.4s, v12.4s, v0.s[2]\n"
    "ldr d20, [x16, x18]\n"
    "fmla v9.4s, v12.4s, v0.s[2]\n"
    "ldr d3, [x16]\n"
    "fmls v7.4s, v12.4s, v0.s[1]\n"
    "ldr d6, [x16, x21]\n"
    "fmls v10.4s, v2.4s, v0.s[2]\n"
    "ldr d16, [x16, x19]\n"
    "fmls v9.4s, v2.4s, v0.s[2]\n"
    "ldr d22, [x16, %[input_col_stride1]]\n"
    "fsub v7.4s, v7.4s, v2.4s\n"
    "ldr d17, [x17, x20]\n"
    "fadd v10.4s, v10.4s, v4.4s\n"
    "ldr d15, [x17, x18]\n"
    "fsub v9.4s, v9.4s, v4.4s\n"
    "ldr d19, [x17]\n"
    "fmla v7.4s, v4.4s, v0.s[1]\n"
    "ldr d18, [x17, x21]\n"
    "mov v8.16b, v8.16b\n"
    "ldr d13, [x17, x19]\n"
    "mov v11.16b, v1.16b\n"
    "ldr d21, [x17, %[input_col_stride1]]\n"
    "fmla v8.4s, v12.4s, v0.s[1]\n"
    "add %[inptr0], %[inptr0], #8\n"
    "fmla v11.4s, v12.4s, v0.s[2]\n"
    "add x16, x16, #8\n"
    "mov v1.16b, v5.16b\n"
    "add x17, x17, #8\n"
    "fsub v8.4s, v8.4s, v2.4s\n"
    "mov v2.16b, v5.16b\n"
    "fmls v8.4s, v4.4s, v0.s[1]\n"
    "fmls v11.4s, v4.4s, v0.s[3]\n"
    "fmla v1.4s, v3.4s, v0.s[2]\n"
    "fmls v2.4s, v22.4s, v0.s[2]\n"
    "mov v3.16b, v5.16b\n"
    "mov v4.16b, v5.16b\n"
    "mov v5.16b, v5.16b\n"
    "mov v6.16b, v6.16b\n"
    "fmls v1.4s, v20.4s, v0.s[3]\n"
    "fmls v2.4s, v20.4s, v0.s[2]\n"
    "fmla v3.4s, v22.4s, v0.s[2]\n"
    "fmls v4.4s, v22.4s, v0.s[1]\n"
    "fmla v5.4s, v22.4s, v0.s[1]\n"
    "fmla v6.4s, v22.4s, v0.s[2]\n"
    "fadd v2.4s, v2.4s, v16.4s\n"
    "mov v12.16b, v17.16b\n"
    "fmls v3.4s, v20.4s, v0.s[2]\n"
    "fsub v4.4s, v4.4s, v20.4s\n"
    "fmla v4.4s, v16.4s, v0.s[1]\n"
    "fsub v5.4s, v5.4s, v20.4s\n"
    "fmls v5.4s, v16.4s, v0.s[1]\n"
    "fmls v6.4s, v16.4s, v0.s[3]\n"
    "fsub v3.4s, v3.4s, v16.4s\n"
    "fmla v12.4s, v19.4s, v0.s[2]\n"
    "mov v19.16b, v17.16b\n"
    "mov v20.16b, v17.16b\n"
    "mov v16.16b, v17.16b\n"
    "mov v17.16b, v17.16b\n"
    "fmls v12.4s, v15.4s, v0.s[3]\n"
    "fmls v19.4s, v21.4s, v0.s[2]\n"
    "fmla v20.4s, v21.4s, v0.s[2]\n"
    "fmls v16.4s, v21.4s, v0.s[1]\n"
    "fmla v17.4s, v21.4s, v0.s[1]\n"
    "mov v18.16b, v18.16b\n"
    "fmls v19.4s, v15.4s, v0.s[2]\n"
    "mov v23.16b, v12.16b\n"
    "fmls v20.4s, v15.4s, v0.s[2]\n"
    "fsub v16.4s, v16.4s, v15.4s\n"
    "fmla v16.4s, v13.4s, v0.s[1]\n"
    "fsub v17.4s, v17.4s, v15.4s\n"
    "fadd v19.4s, v19.4s, v13.4s\n"
    "fmls v17.4s, v13.4s, v0.s[1]\n"
    "fsub v20.4s, v20.4s, v13.4s\n"
    "fmla v18.4s, v21.4s, v0.s[2]\n"
    "fmla v23.4s, v14.4s, v0.s[2]\n"
    "mov v15.16b, v19.16b\n"
    "mov v14.16b, v20.16b\n"
    "mov v24.16b, v16.16b\n"
    "fmls v18.4s, v13.4s, v0.s[3]\n"
    "fmla v15.4s, v10.4s, v0.s[2]\n"
    "fmls v23.4s, v1.4s, v0.s[3]\n"
    "fmla v14.4s, v9.4s, v0.s[2]\n"
    "fmla v24.4s, v7.4s, v0.s[2]\n"
    "mov v10.16b, v17.16b\n"
    "fmls v15.4s, v2.4s, v0.s[3]\n"
    "mov v7.16b, v18.16b\n"
    "str d23, [%[outptr0]]\n"
    "fmls v14.4s, v3.4s, v0.s[3]\n"
    "fmls v24.4s, v4.4s, v0.s[3]\n"
    "fmla v10.4s, v8.4s, v0.s[2]\n"
    "str d15, [%[outptr0], %[output_col_stride1]]\n"
    "fmla v7.4s, v11.4s, v0.s[2]\n"
    "str d14, [%[outptr0], x11]\n"
    "fmls v10.4s, v5.4s, v0.s[3]\n"
    "str d24, [%[outptr0], x13]\n"
    "fmls v7.4s, v6.4s, v0.s[3]\n"
    "str d10, [%[outptr0], x23]\n"
    "str d7, [%[outptr0], x15]\n"
    "add %[outptr0], %[outptr0], #8\n"
    "mov v26.16b, v12.16b\n"
    "mov v25.16b, v19.16b\n"
    "ldr d11, [x25, x20]\n"
    "mov v10.16b, v11.16b\n"
    "ldr d23, [x25, x18]\n"
    "mov v9.16b, v11.16b\n"
    "ldr d7, [x25]\n"
    "fmla v10.4s, v7.4s, v0.s[2]\n"
    "ldr d13, [x25, x21]\n"
    "mov v7.16b, v11.16b\n"
    "ldr d31, [x25, x19]\n"
    "mov v8.16b, v11.16b\n"
    "ldr d21, [x25, %[input_col_stride1]]\n"
    "fmls v10.4s, v23.4s, v0.s[3]\n"
    "ldr d30, [x26, x20]\n"
    "fmls v9.4s, v21.4s, v0.s[2]\n"
    "ldr d29, [x26, x18]\n"
    "fmla v7.4s, v21.4s, v0.s[2]\n"
    "ldr d22, [x26]\n"
    "fmls v8.4s, v21.4s, v0.s[1]\n"
    "ldr d24, [x26, x21]\n"
    "fmls v9.4s, v23.4s, v0.s[2]\n"
    "ldr d27, [x26, x19]\n"
    "fmls v7.4s, v23.4s, v0.s[2]\n"
    "ldr d28, [x26, %[input_col_stride1]]\n"
    "fsub v8.4s, v8.4s, v23.4s\n"
    "add x25, x25, #8\n"
    "fadd v9.4s, v9.4s, v31.4s\n"
    "add x26, x26, #8\n"
    "fsub v7.4s, v7.4s, v31.4s\n"
    "fmla v8.4s, v31.4s, v0.s[1]\n"
    "mov v11.16b, v11.16b\n"
    "mov v15.16b, v13.16b\n"
    "mov v14.16b, v30.16b\n"
    "mov v13.16b, v30.16b\n"
    "fmla v11.4s, v21.4s, v0.s[1]\n"
    "fmla v15.4s, v21.4s, v0.s[2]\n"
    "fmla v14.4s, v22.4s, v0.s[2]\n"
    "fmls v13.4s, v28.4s, v0.s[2]\n"
    "mov v21.16b, v30.16b\n"
    "mov v22.16b, v30.16b\n"
    "fsub v11.4s, v11.4s, v23.4s\n"
    "fmls v15.4s, v31.4s, v0.s[3]\n"
    "fmls v11.4s, v31.4s, v0.s[1]\n"
    "fmls v14.4s, v29.4s, v0.s[3]\n"
    "fmls v13.4s, v29.4s, v0.s[2]\n"
    "fmla v21.4s, v28.4s, v0.s[2]\n"
    "fmls v22.4s, v28.4s, v0.s[1]\n"
    "mov v23.16b, v30.16b\n"
    "mov v24.16b, v24.16b\n"
    "fmls v26.4s, v10.4s, v0.s[2]\n"
    "fadd v13.4s, v13.4s, v27.4s\n"
    "fmls v21.4s, v29.4s, v0.s[2]\n"
    "fsub v22.4s, v22.4s, v29.4s\n"
    "fmla v23.4s, v28.4s, v0.s[1]\n"
    "fmla v22.4s, v27.4s, v0.s[1]\n"
    "fmla v24.4s, v28.4s, v0.s[2]\n"
    "fsub v21.4s, v21.4s, v27.4s\n"
    "fmls v26.4s, v1.4s, v0.s[2]\n"
    "fsub v23.4s, v23.4s, v29.4s\n"
    "fmls v25.4s, v9.4s, v0.s[2]\n"
    "fmls v23.4s, v27.4s, v0.s[1]\n"
    "fmls v24.4s, v27.4s, v0.s[3]\n"
    "fadd v26.4s, v26.4s, v14.4s\n"
    "mov v27.16b, v20.16b\n"
    "str d26, [x28]\n"
    "fmls v25.4s, v2.4s, v0.s[2]\n"
    "fmls v27.4s, v7.4s, v0.s[2]\n"
    "mov v31.16b, v16.16b\n"
    "mov v30.16b, v17.16b\n"
    "mov v29.16b, v18.16b\n"
    "fadd v25.4s, v25.4s, v13.4s\n"
    "fmls v31.4s, v8.4s, v0.s[2]\n"
    "str d25, [x28, %[output_col_stride1]]\n"
    "fmls v27.4s, v3.4s, v0.s[2]\n"
    "fmls v30.4s, v11.4s, v0.s[2]\n"
    "fmls v29.4s, v15.4s, v0.s[2]\n"
    "fmls v31.4s, v4.4s, v0.s[2]\n"
    "mov v26.16b, v12.16b\n"
    "fadd v27.4s, v27.4s, v21.4s\n"
    "mov v25.16b, v19.16b\n"
    "str d27, [x28, x11]\n"
    "fmls v30.4s, v5.4s, v0.s[2]\n"
    "fadd v31.4s, v31.4s, v22.4s\n"
    "fmls v29.4s, v6.4s, v0.s[2]\n"
    "str d31, [x28, x13]\n"
    "fmla v26.4s, v10.4s, v0.s[2]\n"
    "fadd v30.4s, v30.4s, v23.4s\n"
    "fmla v25.4s, v9.4s, v0.s[2]\n"
    "str d30, [x28, x23]\n"
    "fadd v29.4s, v29.4s, v24.4s\n"
    "str d29, [x28, x15]\n"
    "fmls v26.4s, v1.4s, v0.s[2]\n"
    "fmls v25.4s, v2.4s, v0.s[2]\n"
    "add x28, x28, #8\n"
    "mov v30.16b, v20.16b\n"
    "mov v29.16b, v16.16b\n"
    "fsub v26.4s, v26.4s, v14.4s\n"
    "mov v28.16b, v17.16b\n"
    "str d26, [x22]\n"
    "fsub v25.4s, v25.4s, v13.4s\n"
    "str d25, [x22, %[output_col_stride1]]\n"
    "fmla v30.4s, v7.4s, v0.s[2]\n"
    "fmla v29.4s, v8.4s, v0.s[2]\n"
    "fmla v28.4s, v11.4s, v0.s[2]\n"
    "mov v26.16b, v18.16b\n"
    "mov v25.16b, v12.16b\n"
    "fmls v30.4s, v3.4s, v0.s[2]\n"
    "mov v31.16b, v19.16b\n"
    "fmls v29.4s, v4.4s, v0.s[2]\n"
    "fmls v28.4s, v5.4s, v0.s[2]\n"
    "fmla v26.4s, v15.4s, v0.s[2]\n"
    "fmls v25.4s, v10.4s, v0.s[1]\n"
    "fsub v30.4s, v30.4s, v21.4s\n"
    "fmls v31.4s, v9.4s, v0.s[1]\n"
    "str d30, [x22, x11]\n"
    "fsub v29.4s, v29.4s, v22.4s\n"
    "str d29, [x22, x13]\n"
    "fsub v28.4s, v28.4s, v23.4s\n"
    "str d28, [x22, x23]\n"
    "fmls v26.4s, v6.4s, v0.s[2]\n"
    "fsub v25.4s, v25.4s, v1.4s\n"
    "fsub v31.4s, v31.4s, v2.4s\n"
    "fmla v25.4s, v14.4s, v0.s[1]\n"
    "fmla v31.4s, v13.4s, v0.s[1]\n"
    "fsub v26.4s, v26.4s, v24.4s\n"
    "mov v27.16b, v20.16b\n"
    "str d26, [x22, x15]\n"
    "mov v26.16b, v16.16b\n"
    "str d25, [x12]\n"
    "fmls v27.4s, v7.4s, v0.s[1]\n"
    "str d31, [x12, %[output_col_stride1]]\n"
    "fmls v26.4s, v8.4s, v0.s[1]\n"
    "mov v25.16b, v17.16b\n"
    "add x22, x22, #8\n"
    "fsub v27.4s, v27.4s, v3.4s\n"
    "mov v28.16b, v18.16b\n"
    "fmla v27.4s, v21.4s, v0.s[1]\n"
    "fsub v26.4s, v26.4s, v4.4s\n"
    "fmla v26.4s, v22.4s, v0.s[1]\n"
    "fmls v25.4s, v11.4s, v0.s[1]\n"
    "fmls v28.4s, v15.4s, v0.s[1]\n"
    "mov v12.16b, v12.16b\n"
    "str d27, [x12, x11]\n"
    "mov v19.16b, v19.16b\n"
    "str d26, [x12, x13]\n"
    "fsub v25.4s, v25.4s, v5.4s\n"
    "fmla v25.4s, v23.4s, v0.s[1]\n"
    "fsub v28.4s, v28.4s, v6.4s\n"
    "fmla v28.4s, v24.4s, v0.s[1]\n"
    "fmla v12.4s, v10.4s, v0.s[1]\n"
    "fmla v19.4s, v9.4s, v0.s[1]\n"
    "mov v20.16b, v20.16b\n"
    "str d25, [x12, x23]\n"
    "mov v16.16b, v16.16b\n"
    "str d28, [x12, x15]\n"
    "fsub v12.4s, v12.4s, v1.4s\n"
    "fmls v12.4s, v14.4s, v0.s[1]\n"
    "add x12, x12, #8\n"
    "fsub v19.4s, v19.4s, v2.4s\n"
    "fmla v20.4s, v7.4s, v0.s[1]\n"
    "fmls v19.4s, v13.4s, v0.s[1]\n"
    "fmla v16.4s, v8.4s, v0.s[1]\n"
    "str d12, [x14]\n"
    "mov v1.16b, v17.16b\n"
    "fsub v20.4s, v20.4s, v3.4s\n"
    "mov v17.16b, v18.16b\n"
    "str d19, [x14, %[output_col_stride1]]\n"
    "fmls v20.4s, v21.4s, v0.s[1]\n"
    "fsub v16.4s, v16.4s, v4.4s\n"
    "fmla v1.4s, v11.4s, v0.s[1]\n"
    "fmls v16.4s, v22.4s, v0.s[1]\n"
    "fmla v17.4s, v15.4s, v0.s[1]\n"
    "str d20, [x14, x11]\n"
    "fsub v1.4s, v1.4s, v5.4s\n"
    "str d16, [x14, x13]\n"
    "fmls v1.4s, v23.4s, v0.s[1]\n"
    "fsub v17.4s, v17.4s, v6.4s\n"
    "fmls v17.4s, v24.4s, v0.s[1]\n"
    "str d1, [x14, x23]\n"
    "str d17, [x14, x15]\n"
    "add x14, x14, #8\n"
    "ldr d2, [x27, x20]\n"
    "mov v4.16b, v2.16b\n"
    "ldr d17, [x27, x18]\n"
    "mov v12.16b, v2.16b\n"
    "ldr d18, [x27]\n"
    "fmla v4.4s, v18.4s, v0.s[2]\n"
    "ldr d3, [x27, x21]\n"
    "mov v6.16b, v2.16b\n"
    "ldr d5, [x27, x19]\n"
    "mov v1.16b, v2.16b\n"
    "ldr d18, [x27, %[input_col_stride1]]\n"
    "fmls v4.4s, v17.4s, v0.s[3]\n"
    "add x27, x27, #8\n"
    "fmls v12.4s, v18.4s, v0.s[2]\n"
    "sub %w[n_channels], %w[n_channels], #2\n"
    "fmla v6.4s, v18.4s, v0.s[2]\n"
    "fmls v1.4s, v18.4s, v0.s[1]\n"
    "mov v2.16b, v2.16b\n"
    "mov v3.16b, v3.16b\n"
    "fmls v12.4s, v17.4s, v0.s[2]\n"
    "mov v4.16b, v4.16b\n"
    "fmls v6.4s, v17.4s, v0.s[2]\n"
    "fsub v1.4s, v1.4s, v17.4s\n"
    "fmla v1.4s, v5.4s, v0.s[1]\n"
    "fmla v2.4s, v18.4s, v0.s[1]\n"
    "fadd v12.4s, v12.4s, v5.4s\n"
    "fmla v3.4s, v18.4s, v0.s[2]\n"
    "fsub v6.4s, v6.4s, v5.4s\n"
    "fmla v4.4s, v10.4s, v0.s[2]\n"
    "fsub v2.4s, v2.4s, v17.4s\n"
    "mov v16.16b, v12.16b\n"
    "fmls v2.4s, v5.4s, v0.s[1]\n"
    "fmls v3.4s, v5.4s, v0.s[3]\n"
    "fmls v4.4s, v14.4s, v0.s[3]\n"
    "fmla v16.4s, v9.4s, v0.s[2]\n"
    "mov v5.16b, v6.16b\n"
    "mov v6.16b, v1.16b\n"
    "mov v9.16b, v2.16b\n"
    "mov v10.16b, v3.16b\n"
    "str d4, [x24]\n"
    "fmls v16.4s, v13.4s, v0.s[3]\n"
    "fmla v5.4s, v7.4s, v0.s[2]\n"
    "fmla v6.4s, v8.4s, v0.s[2]\n"
    "fmla v9.4s, v11.4s, v0.s[2]\n"
    "fmla v10.4s, v15.4s, v0.s[2]\n"
    "str d16, [x24, %[output_col_stride1]]\n"
    "fmls v5.4s, v21.4s, v0.s[3]\n"
    "fmls v6.4s, v22.4s, v0.s[3]\n"
    "fmls v9.4s, v23.4s, v0.s[3]\n"
    "fmls v10.4s, v24.4s, v0.s[3]\n"
    "str d5, [x24, x11]\n"
    "str d6, [x24, x13]\n"
    "str d9, [x24, x23]\n"
    "str d10, [x24, x15]\n"
    "add x24, x24, #8\n"
    "3:\n"
    "cbz %w[n_channels], 4f\n"
    "ldr s8, [%[inptr0], x20]\n"
    "mov v14.16b, v8.16b\n"
    "ldr s2, [%[inptr0], x18]\n"
    "mov v10.16b, v8.16b\n"
    "ldr s9, [%[inptr0]]\n"
    "fmla v14.4s, v9.4s, v0.s[2]\n"
    "ldr s1, [%[inptr0], x21]\n"
    "mov v9.16b, v8.16b\n"
    "ldr s4, [%[inptr0], x19]\n"
    "mov v7.16b, v8.16b\n"
    "ldr s12, [%[inptr0], %[input_col_stride1]]\n"
    "fmls v14.4s, v2.4s, v0.s[3]\n"
    "ldr s5, [x16, x20]\n"
    "fmls v10.4s, v12.4s, v0.s[2]\n"
    "ldr s20, [x16, x18]\n"
    "fmla v9.4s, v12.4s, v0.s[2]\n"
    "ldr s3, [x16]\n"
    "fmls v7.4s, v12.4s, v0.s[1]\n"
    "ldr s6, [x16, x21]\n"
    "fmls v10.4s, v2.4s, v0.s[2]\n"
    "ldr s16, [x16, x19]\n"
    "fmls v9.4s, v2.4s, v0.s[2]\n"
    "ldr s22, [x16, %[input_col_stride1]]\n"
    "fsub v7.4s, v7.4s, v2.4s\n"
    "ldr s17, [x17, x20]\n"
    "fadd v10.4s, v10.4s, v4.4s\n"
    "ldr s15, [x17, x18]\n"
    "fsub v9.4s, v9.4s, v4.4s\n"
    "ldr s19, [x17]\n"
    "fmla v7.4s, v4.4s, v0.s[1]\n"
    "ldr s18, [x17, x21]\n"
    "mov v8.16b, v8.16b\n"
    "ldr s13, [x17, x19]\n"
    "mov v11.16b, v1.16b\n"
    "ldr s21, [x17, %[input_col_stride1]]\n"
    "fmla v8.4s, v12.4s, v0.s[1]\n"
    "add %[inptr0], %[inptr0], #4\n"
    "fmla v11.4s, v12.4s, v0.s[2]\n"
    "add x16, x16, #4\n"
    "mov v1.16b, v5.16b\n"
    "add x17, x17, #4\n"
    "fsub v8.4s, v8.4s, v2.4s\n"
    "mov v2.16b, v5.16b\n"
    "fmls v8.4s, v4.4s, v0.s[1]\n"
    "fmls v11.4s, v4.4s, v0.s[3]\n"
    "fmla v1.4s, v3.4s, v0.s[2]\n"
    "fmls v2.4s, v22.4s, v0.s[2]\n"
    "mov v3.16b, v5.16b\n"
    "mov v4.16b, v5.16b\n"
    "mov v5.16b, v5.16b\n"
    "mov v6.16b, v6.16b\n"
    "fmls v1.4s, v20.4s, v0.s[3]\n"
    "fmls v2.4s, v20.4s, v0.s[2]\n"
    "fmla v3.4s, v22.4s, v0.s[2]\n"
    "fmls v4.4s, v22.4s, v0.s[1]\n"
    "fmla v5.4s, v22.4s, v0.s[1]\n"
    "fmla v6.4s, v22.4s, v0.s[2]\n"
    "fadd v2.4s, v2.4s, v16.4s\n"
    "mov v12.16b, v17.16b\n"
    "fmls v3.4s, v20.4s, v0.s[2]\n"
    "fsub v4.4s, v4.4s, v20.4s\n"
    "fmla v4.4s, v16.4s, v0.s[1]\n"
    "fsub v5.4s, v5.4s, v20.4s\n"
    "fmls v5.4s, v16.4s, v0.s[1]\n"
    "fmls v6.4s, v16.4s, v0.s[3]\n"
    "fsub v3.4s, v3.4s, v16.4s\n"
    "fmla v12.4s, v19.4s, v0.s[2]\n"
    "mov v19.16b, v17.16b\n"
    "mov v20.16b, v17.16b\n"
    "mov v16.16b, v17.16b\n"
    "mov v17.16b, v17.16b\n"
    "fmls v12.4s, v15.4s, v0.s[3]\n"
    "fmls v19.4s, v21.4s, v0.s[2]\n"
    "fmla v20.4s, v21.4s, v0.s[2]\n"
    "fmls v16.4s, v21.4s, v0.s[1]\n"
    "fmla v17.4s, v21.4s, v0.s[1]\n"
    "mov v18.16b, v18.16b\n"
    "fmls v19.4s, v15.4s, v0.s[2]\n"
    "mov v23.16b, v12.16b\n"
    "fmls v20.4s, v15.4s, v0.s[2]\n"
    "fsub v16.4s, v16.4s, v15.4s\n"
    "fmla v16.4s, v13.4s, v0.s[1]\n"
    "fsub v17.4s, v17.4s, v15.4s\n"
    "fadd v19.4s, v19.4s, v13.4s\n"
    "fmls v17.4s, v13.4s, v0.s[1]\n"
    "fsub v20.4s, v20.4s, v13.4s\n"
    "fmla v18.4s, v21.4s, v0.s[2]\n"
    "fmla v23.4s, v14.4s, v0.s[2]\n"
    "mov v15.16b, v19.16b\n"
    "mov v14.16b, v20.16b\n"
    "mov v24.16b, v16.16b\n"
    "fmls v18.4s, v13.4s, v0.s[3]\n"
    "fmla v15.4s, v10.4s, v0.s[2]\n"
    "fmls v23.4s, v1.4s, v0.s[3]\n"
    "fmla v14.4s, v9.4s, v0.s[2]\n"
    "fmla v24.4s, v7.4s, v0.s[2]\n"
    "mov v10.16b, v17.16b\n"
    "fmls v15.4s, v2.4s, v0.s[3]\n"
    "mov v7.16b, v18.16b\n"
    "str s23, [%[outptr0]]\n"
    "fmls v14.4s, v3.4s, v0.s[3]\n"
    "fmls v24.4s, v4.4s, v0.s[3]\n"
    "fmla v10.4s, v8.4s, v0.s[2]\n"
    "str s15, [%[outptr0], %[output_col_stride1]]\n"
    "fmla v7.4s, v11.4s, v0.s[2]\n"
    "str s14, [%[outptr0], x11]\n"
    "fmls v10.4s, v5.4s, v0.s[3]\n"
    "str s24, [%[outptr0], x13]\n"
    "fmls v7.4s, v6.4s, v0.s[3]\n"
    "str s10, [%[outptr0], x23]\n"
    "str s7, [%[outptr0], x15]\n"
    "add %[outptr0], %[outptr0], #4\n"
    "mov v26.16b, v12.16b\n"
    "mov v25.16b, v19.16b\n"
    "ldr s11, [x25, x20]\n"
    "mov v10.16b, v11.16b\n"
    "ldr s23, [x25, x18]\n"
    "mov v9.16b, v11.16b\n"
    "ldr s7, [x25]\n"
    "fmla v10.4s, v7.4s, v0.s[2]\n"
    "ldr s13, [x25, x21]\n"
    "mov v7.16b, v11.16b\n"
    "ldr s31, [x25, x19]\n"
    "mov v8.16b, v11.16b\n"
    "ldr s21, [x25, %[input_col_stride1]]\n"
    "fmls v10.4s, v23.4s, v0.s[3]\n"
    "ldr s30, [x26, x20]\n"
    "fmls v9.4s, v21.4s, v0.s[2]\n"
    "ldr s29, [x26, x18]\n"
    "fmla v7.4s, v21.4s, v0.s[2]\n"
    "ldr s22, [x26]\n"
    "fmls v8.4s, v21.4s, v0.s[1]\n"
    "ldr s24, [x26, x21]\n"
    "fmls v9.4s, v23.4s, v0.s[2]\n"
    "ldr s27, [x26, x19]\n"
    "fmls v7.4s, v23.4s, v0.s[2]\n"
    "ldr s28, [x26, %[input_col_stride1]]\n"
    "fsub v8.4s, v8.4s, v23.4s\n"
    "add x25, x25, #4\n"
    "fadd v9.4s, v9.4s, v31.4s\n"
    "add x26, x26, #4\n"
    "fsub v7.4s, v7.4s, v31.4s\n"
    "fmla v8.4s, v31.4s, v0.s[1]\n"
    "mov v11.16b, v11.16b\n"
    "mov v15.16b, v13.16b\n"
    "mov v14.16b, v30.16b\n"
    "mov v13.16b, v30.16b\n"
    "fmla v11.4s, v21.4s, v0.s[1]\n"
    "fmla v15.4s, v21.4s, v0.s[2]\n"
    "fmla v14.4s, v22.4s, v0.s[2]\n"
    "fmls v13.4s, v28.4s, v0.s[2]\n"
    "mov v21.16b, v30.16b\n"
    "mov v22.16b, v30.16b\n"
    "fsub v11.4s, v11.4s, v23.4s\n"
    "fmls v15.4s, v31.4s, v0.s[3]\n"
    "fmls v11.4s, v31.4s, v0.s[1]\n"
    "fmls v14.4s, v29.4s, v0.s[3]\n"
    "fmls v13.4s, v29.4s, v0.s[2]\n"
    "fmla v21.4s, v28.4s, v0.s[2]\n"
    "fmls v22.4s, v28.4s, v0.s[1]\n"
    "mov v23.16b, v30.16b\n"
    "mov v24.16b, v24.16b\n"
    "fmls v26.4s, v10.4s, v0.s[2]\n"
    "fadd v13.4s, v13.4s, v27.4s\n"
    "fmls v21.4s, v29.4s, v0.s[2]\n"
    "fsub v22.4s, v22.4s, v29.4s\n"
    "fmla v23.4s, v28.4s, v0.s[1]\n"
    "fmla v22.4s, v27.4s, v0.s[1]\n"
    "fmla v24.4s, v28.4s, v0.s[2]\n"
    "fsub v21.4s, v21.4s, v27.4s\n"
    "fmls v26.4s, v1.4s, v0.s[2]\n"
    "fsub v23.4s, v23.4s, v29.4s\n"
    "fmls v25.4s, v9.4s, v0.s[2]\n"
    "fmls v23.4s, v27.4s, v0.s[1]\n"
    "fmls v24.4s, v27.4s, v0.s[3]\n"
    "fadd v26.4s, v26.4s, v14.4s\n"
    "mov v27.16b, v20.16b\n"
    "str s26, [x28]\n"
    "fmls v25.4s, v2.4s, v0.s[2]\n"
    "fmls v27.4s, v7.4s, v0.s[2]\n"
    "mov v31.16b, v16.16b\n"
    "mov v30.16b, v17.16b\n"
    "mov v29.16b, v18.16b\n"
    "fadd v25.4s, v25.4s, v13.4s\n"
    "fmls v31.4s, v8.4s, v0.s[2]\n"
    "str s25, [x28, %[output_col_stride1]]\n"
    "fmls v27.4s, v3.4s, v0.s[2]\n"
    "fmls v30.4s, v11.4s, v0.s[2]\n"
    "fmls v29.4s, v15.4s, v0.s[2]\n"
    "fmls v31.4s, v4.4s, v0.s[2]\n"
    "mov v26.16b, v12.16b\n"
    "fadd v27.4s, v27.4s, v21.4s\n"
    "mov v25.16b, v19.16b\n"
    "str s27, [x28, x11]\n"
    "fmls v30.4s, v5.4s, v0.s[2]\n"
    "fadd v31.4s, v31.4s, v22.4s\n"
    "fmls v29.4s, v6.4s, v0.s[2]\n"
    "str s31, [x28, x13]\n"
    "fmla v26.4s, v10.4s, v0.s[2]\n"
    "fadd v30.4s, v30.4s, v23.4s\n"
    "fmla v25.4s, v9.4s, v0.s[2]\n"
    "str s30, [x28, x23]\n"
    "fadd v29.4s, v29.4s, v24.4s\n"
    "str s29, [x28, x15]\n"
    "fmls v26.4s, v1.4s, v0.s[2]\n"
    "fmls v25.4s, v2.4s, v0.s[2]\n"
    "add x28, x28, #4\n"
    "mov v30.16b, v20.16b\n"
    "mov v29.16b, v16.16b\n"
    "fsub v26.4s, v26.4s, v14.4s\n"
    "mov v28.16b, v17.16b\n"
    "str s26, [x22]\n"
    "fsub v25.4s, v25.4s, v13.4s\n"
    "str s25, [x22, %[output_col_stride1]]\n"
    "fmla v30.4s, v7.4s, v0.s[2]\n"
    "fmla v29.4s, v8.4s, v0.s[2]\n"
    "fmla v28.4s, v11.4s, v0.s[2]\n"
    "mov v26.16b, v18.16b\n"
    "mov v25.16b, v12.16b\n"
    "fmls v30.4s, v3.4s, v0.s[2]\n"
    "mov v31.16b, v19.16b\n"
    "fmls v29.4s, v4.4s, v0.s[2]\n"
    "fmls v28.4s, v5.4s, v0.s[2]\n"
    "fmla v26.4s, v15.4s, v0.s[2]\n"
    "fmls v25.4s, v10.4s, v0.s[1]\n"
    "fsub v30.4s, v30.4s, v21.4s\n"
    "fmls v31.4s, v9.4s, v0.s[1]\n"
    "str s30, [x22, x11]\n"
    "fsub v29.4s, v29.4s, v22.4s\n"
    "str s29, [x22, x13]\n"
    "fsub v28.4s, v28.4s, v23.4s\n"
    "str s28, [x22, x23]\n"
    "fmls v26.4s, v6.4s, v0.s[2]\n"
    "fsub v25.4s, v25.4s, v1.4s\n"
    "fsub v31.4s, v31.4s, v2.4s\n"
    "fmla v25.4s, v14.4s, v0.s[1]\n"
    "fmla v31.4s, v13.4s, v0.s[1]\n"
    "fsub v26.4s, v26.4s, v24.4s\n"
    "mov v27.16b, v20.16b\n"
    "str s26, [x22, x15]\n"
    "mov v26.16b, v16.16b\n"
    "str s25, [x12]\n"
    "fmls v27.4s, v7.4s, v0.s[1]\n"
    "str s31, [x12, %[output_col_stride1]]\n"
    "fmls v26.4s, v8.4s, v0.s[1]\n"
    "mov v25.16b, v17.16b\n"
    "add x22, x22, #4\n"
    "fsub v27.4s, v27.4s, v3.4s\n"
    "mov v28.16b, v18.16b\n"
    "fmla v27.4s, v21.4s, v0.s[1]\n"
    "fsub v26.4s, v26.4s, v4.4s\n"
    "fmla v26.4s, v22.4s, v0.s[1]\n"
    "fmls v25.4s, v11.4s, v0.s[1]\n"
    "fmls v28.4s, v15.4s, v0.s[1]\n"
    "mov v12.16b, v12.16b\n"
    "str s27, [x12, x11]\n"
    "mov v19.16b, v19.16b\n"
    "str s26, [x12, x13]\n"
    "fsub v25.4s, v25.4s, v5.4s\n"
    "fmla v25.4s, v23.4s, v0.s[1]\n"
    "fsub v28.4s, v28.4s, v6.4s\n"
    "fmla v28.4s, v24.4s, v0.s[1]\n"
    "fmla v12.4s, v10.4s, v0.s[1]\n"
    "fmla v19.4s, v9.4s, v0.s[1]\n"
    "mov v20.16b, v20.16b\n"
    "str s25, [x12, x23]\n"
    "mov v16.16b, v16.16b\n"
    "str s28, [x12, x15]\n"
    "fsub v12.4s, v12.4s, v1.4s\n"
    "fmls v12.4s, v14.4s, v0.s[1]\n"
    "add x12, x12, #4\n"
    "fsub v19.4s, v19.4s, v2.4s\n"
    "fmla v20.4s, v7.4s, v0.s[1]\n"
    "fmls v19.4s, v13.4s, v0.s[1]\n"
    "fmla v16.4s, v8.4s, v0.s[1]\n"
    "str s12, [x14]\n"
    "mov v1.16b, v17.16b\n"
    "fsub v20.4s, v20.4s, v3.4s\n"
    "mov v17.16b, v18.16b\n"
    "str s19, [x14, %[output_col_stride1]]\n"
    "fmls v20.4s, v21.4s, v0.s[1]\n"
    "fsub v16.4s, v16.4s, v4.4s\n"
    "fmla v1.4s, v11.4s, v0.s[1]\n"
    "fmls v16.4s, v22.4s, v0.s[1]\n"
    "fmla v17.4s, v15.4s, v0.s[1]\n"
    "str s20, [x14, x11]\n"
    "fsub v1.4s, v1.4s, v5.4s\n"
    "str s16, [x14, x13]\n"
    "fmls v1.4s, v23.4s, v0.s[1]\n"
    "fsub v17.4s, v17.4s, v6.4s\n"
    "fmls v17.4s, v24.4s, v0.s[1]\n"
    "str s1, [x14, x23]\n"
    "str s17, [x14, x15]\n"
    "add x14, x14, #4\n"
    "ldr s2, [x27, x20]\n"
    "mov v4.16b, v2.16b\n"
    "ldr s17, [x27, x18]\n"
    "mov v12.16b, v2.16b\n"
    "ldr s18, [x27]\n"
    "fmla v4.4s, v18.4s, v0.s[2]\n"
    "ldr s3, [x27, x21]\n"
    "mov v6.16b, v2.16b\n"
    "ldr s5, [x27, x19]\n"
    "mov v1.16b, v2.16b\n"
    "ldr s18, [x27, %[input_col_stride1]]\n"
    "fmls v4.4s, v17.4s, v0.s[3]\n"
    "add x27, x27, #4\n"
    "fmls v12.4s, v18.4s, v0.s[2]\n"
    "fmla v6.4s, v18.4s, v0.s[2]\n"
    "fmls v1.4s, v18.4s, v0.s[1]\n"
    "mov v2.16b, v2.16b\n"
    "mov v3.16b, v3.16b\n"
    "mov v4.16b, v4.16b\n"
    "fmls v12.4s, v17.4s, v0.s[2]\n"
    "fmls v6.4s, v17.4s, v0.s[2]\n"
    "fsub v1.4s, v1.4s, v17.4s\n"
    "fmla v2.4s, v18.4s, v0.s[1]\n"
    "fmla v1.4s, v5.4s, v0.s[1]\n"
    "fmla v3.4s, v18.4s, v0.s[2]\n"
    "fadd v12.4s, v12.4s, v5.4s\n"
    "fsub v6.4s, v6.4s, v5.4s\n"
    "fsub v2.4s, v2.4s, v17.4s\n"
    "fmla v4.4s, v10.4s, v0.s[2]\n"
    "fmls v2.4s, v5.4s, v0.s[1]\n"
    "fmls v3.4s, v5.4s, v0.s[3]\n"
    "mov v16.16b, v12.16b\n"
    "mov v5.16b, v6.16b\n"
    "fmls v4.4s, v14.4s, v0.s[3]\n"
    "mov v6.16b, v1.16b\n"
    "fmla v16.4s, v9.4s, v0.s[2]\n"
    "fmla v5.4s, v7.4s, v0.s[2]\n"
    "fmla v6.4s, v8.4s, v0.s[2]\n"
    "mov v9.16b, v2.16b\n"
    "str s4, [x24]\n"
    "mov v10.16b, v3.16b\n"
    "fmls v16.4s, v13.4s, v0.s[3]\n"
    "fmls v5.4s, v21.4s, v0.s[3]\n"
    "fmls v6.4s, v22.4s, v0.s[3]\n"
    "fmla v9.4s, v11.4s, v0.s[2]\n"
    "fmla v10.4s, v15.4s, v0.s[2]\n"
    "str s16, [x24, %[output_col_stride1]]\n"
    "str s5, [x24, x11]\n"
    "fmls v9.4s, v23.4s, v0.s[3]\n"
    "str s6, [x24, x13]\n"
    "fmls v10.4s, v24.4s, v0.s[3]\n"
    "str s9, [x24, x23]\n"
    "str s10, [x24, x15]\n"
    "add x24, x24, #4\n"
    "4:\n"
    : [outptr0] "+r" (matrix_base),
      [n_channels] "+r" (n_channels),
      [inptr0] "+r" (input_base)
    : [pcoeffs] "r" (pcoeffs),
      [output_row_stride] "r" (6 * matrix_stride * sizeof(float)),
      [output_col_stride1] "r" (matrix_stride * sizeof(float)),
      [input_row_stride] "r" (input_row_stride * sizeof(float)),
      [input_col_stride1] "r" (input_col_stride * sizeof(float))
    : "cc", "v0", "v1", "v10", "v11", "v12", "v13", "v14", "v15", "v16", "v17",
      "v18", "v19", "v2", "v20", "v21", "v22", "v23", "v24", "v25", "v26",
      "v27", "v28", "v29", "v3", "v30", "v31", "v4", "v5", "v6", "v7", "v8",
      "v9", "x11", "x12", "x13", "x14", "x15", "x16", "x17", "x18", "x19",
      "x20", "x21", "x22", "x23", "x24", "x25", "x26", "x27", "x28", "memory"
  );
}

#else  // __arm__ not __aarch64__

template <>
void InputTransform<6, 6, float, float, WinogradRoots::Integers>::transform_tile(
  const int n_channels,
  const float* const input_base,
  const int input_row_stride,
  const int input_col_stride,
  float* outptr,
  const int matrix_stride
)
{
  constexpr int inner_tile_rows = 6;
  constexpr int inner_tile_cols = 6;

  // Get pointers into the input tile
  const float *x_ptrs[inner_tile_rows][inner_tile_cols];
  for (int i = 0, xi = 0; i < inner_tile_rows; i++, xi++)
  {
    // Get a pointer into the row
    const float* const row_ptr = input_base + xi*input_row_stride;

    for (int j = 0, xj = 0; j < inner_tile_cols; j++, xj++)
    {
      x_ptrs[i][j] = row_ptr + xj*input_col_stride;
    }
  }

  // Matrices used/computed in this kernel.
  float x[inner_tile_rows][inner_tile_cols];
  float XTx[inner_tile_rows][inner_tile_cols];
  float U[inner_tile_rows][inner_tile_cols];
  for (int i = 0; i < inner_tile_rows; i++)
  {
    for (int j = 0; j < inner_tile_cols; j++)
    {
      x[i][j] = XTx[i][j] = 0.0f;
    }
  }

  // Perform the Winograd input transformation for each channel in the input
  // tensor.
  int channels_remaining = n_channels;
  for (; channels_remaining >= 2; channels_remaining -= 2)
  {
    // Matrices used/computed in this kernel
    float32x2_t x[inner_tile_rows][inner_tile_cols];
    float32x2_t XTx[inner_tile_rows][inner_tile_cols];
    float32x2_t U[inner_tile_rows][inner_tile_cols];
    for (int i = 0; i < inner_tile_rows; i++)
    {
      for (int j = 0; j < inner_tile_cols; j++)
      {
        x[i][j] = vdup_n_f32(0.0f);
        XTx[i][j] = vdup_n_f32(0.0f);
      }
    }

    // Read a 6x6 tile in the Winograd domain
    for (int i = 0; i < inner_tile_rows; i++)
    {
      for (int j = 0; j < inner_tile_cols; j++)
      {
        x[i][j] = vld1_f32(x_ptrs[i][j]);
        x_ptrs[i][j] += 2;
      }
    }

    // Compute XT . x
    for (int j = 0; j < inner_tile_cols; j++)
    {
      // XTx[0][j] =  4*x[0][j] + -5*x[2][j] +  1*x[4][j];
      XTx[0][j] = vmls_n_f32(vmla_n_f32(x[4][j], x[0][j], 4.0f), x[2][j], 5.0f);

      // XTx[1][j] = -4*x[1][j] + -4*x[2][j] +  1*x[3][j] +  1*x[4][j];
      XTx[1][j] = vmls_n_f32(vadd_f32(x[3][j], x[4][j]), vadd_f32(x[1][j], x[2][j]), 4.0f);

      // XTx[2][j] =  4*x[1][j] + -4*x[2][j] + -1*x[3][j] +  1*x[4][j];
      XTx[2][j] = vmla_n_f32(vsub_f32(x[4][j], x[3][j]), vsub_f32(x[1][j], x[2][j]), 4.0f);

      // XTx[3][j] = -2*x[1][j] + -1*x[2][j] +  2*x[3][j] +  1*x[4][j];
      XTx[3][j] = vmla_n_f32(vsub_f32(x[4][j], x[2][j]), vsub_f32(x[3][j], x[1][j]), 2.0f);

      // XTx[4][j] =  2*x[1][j] + -1*x[2][j] + -2*x[3][j] +  1*x[4][j];
      XTx[4][j] = vmla_n_f32(vsub_f32(x[4][j], x[2][j]), vsub_f32(x[1][j], x[3][j]), 2.0f);

      // XTx[5][j] =  4*x[1][j] + -5*x[3][j] +  1*x[5][j];
      XTx[5][j] = vmls_n_f32(vmla_n_f32(x[5][j], x[1][j], 4.0f), x[3][j], 5.0f);
    }

    // Compute U = XT . x . X
    for (int i = 0; i < inner_tile_rows; i++)
    {
      // U[i][0] =  4*XTx[i][0] + -5*XTx[i][2] +  1*XTx[i][4];
      U[i][0] = vmls_n_f32(vmla_n_f32(XTx[i][4], XTx[i][0], 4.0f), XTx[i][2], 5.0f);

      // U[i][1] = -4*XTx[i][1] + -4*XTx[i][2] +  1*XTx[i][3] +  1*XTx[i][4];
      U[i][1] = vmls_n_f32(vadd_f32(XTx[i][3], XTx[i][4]), vadd_f32(XTx[i][1], XTx[i][2]), 4.0f);

      // U[i][2] =  4*XTx[i][1] + -4*XTx[i][2] + -1*XTx[i][3] +  1*XTx[i][4];
      U[i][2] = vmla_n_f32(vsub_f32(XTx[i][4], XTx[i][3]), vsub_f32(XTx[i][1], XTx[i][2]), 4.0f);

      // U[i][3] = -2*XTx[i][1] + -1*XTx[i][2] +  2*XTx[i][3] +  1*XTx[i][4];
      U[i][3] = vmla_n_f32(vsub_f32(XTx[i][4], XTx[i][2]), vsub_f32(XTx[i][3], XTx[i][1]), 2.0f);

      // U[i][4] =  2*XTx[i][1] + -1*XTx[i][2] + -2*XTx[i][3] +  1*XTx[i][4];
      U[i][4] = vmla_n_f32(vsub_f32(XTx[i][4], XTx[i][2]), vsub_f32(XTx[i][1], XTx[i][3]), 2.0f);

      // U[i][5] =  4*XTx[i][1] + -5*XTx[i][3] +  1*XTx[i][5];
      U[i][5] = vmls_n_f32(vmla_n_f32(XTx[i][5], XTx[i][1], 4.0f), XTx[i][3], 5.0f);
    }

    // Store the transformed matrix
    for (int i = 0, m = 0; i < inner_tile_rows; i++)
    {
      for (int j = 0; j < inner_tile_cols; j++, m++)
      {
        vst1_f32(outptr + m*matrix_stride, U[i][j]);
      }
    }
    outptr += 2;
  }
  for (; channels_remaining; channels_remaining--)
  {
    // Load x
    for (int i = 0; i < inner_tile_rows; i++)
    {
      for (int j = 0; j < inner_tile_cols; j++)
      {
        x[i][j] = *(x_ptrs[i][j]++);
      }
    }

    // Compute XT . x
    for (int j = 0; j < inner_tile_cols; j++)
    {
      XTx[0][j] =  4*x[0][j] + -5*x[2][j] +  1*x[4][j];
      XTx[1][j] = -4*x[1][j] + -4*x[2][j] +  1*x[3][j] +  1*x[4][j];
      XTx[2][j] =  4*x[1][j] + -4*x[2][j] + -1*x[3][j] +  1*x[4][j];
      XTx[3][j] = -2*x[1][j] + -1*x[2][j] +  2*x[3][j] +  1*x[4][j];
      XTx[4][j] =  2*x[1][j] + -1*x[2][j] + -2*x[3][j] +  1*x[4][j];
      XTx[5][j] =  4*x[1][j] + -5*x[3][j] +  1*x[5][j];
    }

    // Compute U = XT . x . X
    for (int i = 0; i < inner_tile_rows; i++)
    {
      U[i][0] =  4*XTx[i][0] + -5*XTx[i][2] +  1*XTx[i][4];
      U[i][1] = -4*XTx[i][1] + -4*XTx[i][2] +  1*XTx[i][3] +  1*XTx[i][4];
      U[i][2] =  4*XTx[i][1] + -4*XTx[i][2] + -1*XTx[i][3] +  1*XTx[i][4];
      U[i][3] = -2*XTx[i][1] + -1*XTx[i][2] +  2*XTx[i][3] +  1*XTx[i][4];
      U[i][4] =  2*XTx[i][1] + -1*XTx[i][2] + -2*XTx[i][3] +  1*XTx[i][4];
      U[i][5] =  4*XTx[i][1] + -5*XTx[i][3] +  1*XTx[i][5];
    }

    // Store the transformed matrix
    for (int i = 0, m = 0; i < inner_tile_rows; i++)
    {
      for (int j = 0; j < inner_tile_cols; j++, m++)
      {
        *(outptr + m*matrix_stride) = U[i][j];
      }
    }
    outptr++;
  }
}

#endif

template class InputTransform<6, 6, float, float, WinogradRoots::Integers>;

}  // namespace winograd
