/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 13:25:33 GMT 2018
 */

package uk.ac.sanger.artemis.components.variant;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import com.sshtools.j2ssh.io.ByteArrayReader;
import htsjdk.samtools.seekablestream.ByteArraySeekableStream;
import htsjdk.samtools.seekablestream.SeekableBufferedStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PushbackInputStream;
import java.util.HashMap;
import java.util.Hashtable;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.components.variant.AbstractVCFReader;
import uk.ac.sanger.artemis.components.variant.BCFReader;
import uk.ac.sanger.artemis.components.variant.VCFview;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class AbstractVCFReader_ESTest extends AbstractVCFReader_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      byte[] byteArray0 = new byte[7];
      byteArray0[2] = (byte)94;
      ByteArrayInputStream byteArrayInputStream0 = new ByteArrayInputStream(byteArray0, (byte)0, (byte)51);
      long long0 = AbstractVCFReader.readLong(byteArrayInputStream0);
      assertEquals(6160384L, long0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      byte[] byteArray0 = new byte[8];
      byteArray0[7] = (byte) (-92);
      ByteArrayReader byteArrayReader0 = new ByteArrayReader(byteArray0);
      PushbackInputStream pushbackInputStream0 = new PushbackInputStream(byteArrayReader0);
      long long0 = AbstractVCFReader.readLong(pushbackInputStream0);
      assertEquals((-6629298651489370112L), long0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      byte[] byteArray0 = new byte[2];
      byteArray0[1] = (byte) (-72);
      ByteArraySeekableStream byteArraySeekableStream0 = new ByteArraySeekableStream(byteArray0);
      SeekableBufferedStream seekableBufferedStream0 = new SeekableBufferedStream(byteArraySeekableStream0);
      int int0 = AbstractVCFReader.readInt(seekableBufferedStream0);
      assertEquals(47104, int0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      byte[] byteArray0 = new byte[2];
      byteArray0[0] = (byte) (-74);
      ByteArrayInputStream byteArrayInputStream0 = new ByteArrayInputStream(byteArray0);
      float float0 = AbstractVCFReader.readFloat(byteArrayInputStream0);
      assertEquals(2.55E-43F, float0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      HashMap<String, Boolean> hashMap0 = new HashMap<String, Boolean>();
      CharArrayWriter charArrayWriter0 = new CharArrayWriter();
      FeatureVector featureVector0 = new FeatureVector();
      try { 
        AbstractVCFReader.write(hashMap0, "A", 8, charArrayWriter0, (VCFview) null, featureVector0);
        fail("Expecting exception: FileNotFoundException");
      
      } catch(FileNotFoundException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      // Undeclared exception!
      try { 
        AbstractVCFReader.readLong((InputStream) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.AbstractVCFReader", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      // Undeclared exception!
      try { 
        AbstractVCFReader.readInt((InputStream) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.AbstractVCFReader", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      SeekableBufferedStream seekableBufferedStream0 = new SeekableBufferedStream((SeekableStream) null);
      try { 
        AbstractVCFReader.readInt(seekableBufferedStream0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Stream closed
         //
         verifyException("java.io.BufferedInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      // Undeclared exception!
      try { 
        AbstractVCFReader.readFloat((InputStream) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.AbstractVCFReader", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      byte[] byteArray0 = new byte[7];
      ByteArrayInputStream byteArrayInputStream0 = new ByteArrayInputStream(byteArray0, (-1932923024), (byte)51);
      // Undeclared exception!
      try { 
        AbstractVCFReader.readFloat(byteArrayInputStream0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.io.ByteArrayInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      PipedInputStream pipedInputStream0 = new PipedInputStream();
      try { 
        AbstractVCFReader.readFloat(pipedInputStream0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Pipe not connected
         //
         verifyException("java.io.PipedInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      // Undeclared exception!
      try { 
        AbstractVCFReader.getLineHash("Discordant field size detected for field ", "ei1wW+A");
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      // Undeclared exception!
      try { 
        AbstractVCFReader.getLineHash((String) null, (String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.Hashtable", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      Hashtable<String, String> hashtable0 = AbstractVCFReader.getLineHash("=", "iNjq%4PNN5=ZIjfA?eT");
      assertEquals(2, hashtable0.size());
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      Hashtable<String, String> hashtable0 = AbstractVCFReader.getLineHash("8", "DescriLpptionG^u* 8");
      assertFalse(hashtable0.isEmpty());
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      byte[] byteArray0 = new byte[7];
      ByteArrayInputStream byteArrayInputStream0 = new ByteArrayInputStream(byteArray0, (byte)0, (byte)51);
      long long0 = AbstractVCFReader.readLong(byteArrayInputStream0);
      assertEquals(0L, long0);
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      byte[] byteArray0 = new byte[2];
      ByteArraySeekableStream byteArraySeekableStream0 = new ByteArraySeekableStream(byteArray0);
      SeekableBufferedStream seekableBufferedStream0 = new SeekableBufferedStream(byteArraySeekableStream0);
      int int0 = AbstractVCFReader.readInt(seekableBufferedStream0);
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      BCFReader bCFReader0 = null;
      try {
        bCFReader0 = new BCFReader((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.BCFReader", e);
      }
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      byte[] byteArray0 = new byte[7];
      ByteArrayInputStream byteArrayInputStream0 = new ByteArrayInputStream(byteArray0, (byte)0, (byte)51);
      AbstractVCFReader.readFloat(byteArrayInputStream0);
      assertEquals(3, byteArrayInputStream0.available());
  }
}
