# set makefile variables according to the installed Clang version

# check whether llvm-config is available
ifeq ($(shell which $(LLVMCONF)),)
  $(error FRONTEND is 'Clang', but LLVMCONF ($(LLVMCONF)) is not found)
endif

LLVM_VERSION := $(shell $(LLVMCONF) --version)

# check if the config file for this version exists
ifeq ($(wildcard config/clang-$(LLVM_VERSION).mk),)
  $(error UNSUPPORTED Clang version '$(LLVM_VERSION)' used -- try 'make -C config clang LLVMCONF=<llvm-config-path>')
endif

include config/clang-$(LLVM_VERSION).mk

# determine relevant interface variants
LLVM_INTERFACE := 38 # latest is default
ifneq ($(filter 3.5%, $(LLVM_VERSION))$(filter 3.6%, $(LLVM_VERSION)),)
  LLVM_INTERFACE := 35
else
ifneq ($(filter 3.7%, $(LLVM_VERSION)),)
  LLVM_INTERFACE := 37
else
ifneq ($(filter 3.8%, $(LLVM_VERSION))$(filter 3.9%, $(LLVM_VERSION))$(filter 4.0%, $(LLVM_VERSION)),)
  LLVM_INTERFACE := 38
endif
ifneq ($(filter 5.0%, $(LLVM_VERSION)),)
  LLVM_INTERFACE := 50
endif
endif
endif

ifeq ($(_TARGET),macosx_x86_64) # on macOS the symbols have an additional '_'
  LLVM_SYMBOLS      := $(patsubst %, _%, $(LLVM_SYMBOLS))
  LLVM_SYMBOLS_SEMA := $(filter-out __ZN5clang12Preprocessor3LexERNS_5TokenE __ZN5clang12Preprocessor9PeekAheadEj, $(LLVM_SYMBOLS))
  LLVM_SYMBOLS_LEX  := $(filter __ZN5clang12Preprocessor3LexERNS_5TokenE __ZN5clang12Preprocessor9PeekAheadEj, $(LLVM_SYMBOLS))
endif
