# CPack
# http://www.cmake.org/Wiki/CMake:CPackConfiguration

SET(FILENAME ${PROJECT_NAME}-${PROJECT_VERSION})

IF(ANDROID_BUILD_AAR)
	STRING(TOLOWER "${FILENAME}" FILENAME)
	STRING(REGEX REPLACE "[0-9]*-" "-" FILENAME "${FILENAME}")
ELSEIF(ANDROID)
	SET(FILENAME ${FILENAME}-${CMAKE_ANDROID_ARCH_ABI})
ENDIF()

IF(DEFINED dvcs_distance)
	SET(FILENAME ${FILENAME}+${dvcs_distance})
ENDIF()

IF(DEFINED dvcs_branch)
	SET(FILENAME ${FILENAME}-${dvcs_branch})
ENDIF()

IF(DEFINED dvcs_phase)
	SET(FILENAME ${FILENAME}-${dvcs_phase})
ENDIF()

IF(DEFINED dvcs_revision)
	SET(FILENAME ${FILENAME}-${dvcs_revision})
ENDIF()


SET(CPACK_PACKAGE_NAME ${PROJECT_NAME})
SET(CPACK_PACKAGE_VERSION ${PROJECT_VERSION})
SET(CPACK_PACKAGE_VERSION_MAJOR ${PROJECT_VERSION_MAJOR})
SET(CPACK_PACKAGE_VERSION_MINOR ${PROJECT_VERSION_MINOR})
SET(CPACK_PACKAGE_VERSION_PATCH ${PROJECT_VERSION_PATCH})
SET(CPACK_PACKAGE_VERSION_TWEAK ${PROJECT_VERSION_TWEAK})
SET(CPACK_PACKAGE_VENDOR "Governikus GmbH & Co. KG")
SET(CPACK_PACKAGE_CONTACT "info@governikus.com")
SET(CPACK_PACKAGE_DESCRIPTION_SUMMARY "Governikus AusweisApp2")
SET(CPACK_PACKAGE_DESCRIPTION_FILE "${PROJECT_SOURCE_DIR}/README.rst")
SET(CPACK_PACKAGE_FILE_NAME ${FILENAME})
SET(CPACK_PACKAGE_INSTALL_DIRECTORY ${PROJECT_NAME})

IF(VENDOR_GOVERNIKUS)
	SET(CPACK_RESOURCE_FILE_LICENSE "${PROJECT_SOURCE_DIR}/LICENSE.officially.txt")
ELSE()
	SET(CPACK_RESOURCE_FILE_LICENSE "${PROJECT_SOURCE_DIR}/LICENSE.txt")
ENDIF()

IF(APPLE AND NOT IOS)
	FIND_PROGRAM(ICONV iconv)
	IF(NOT ICONV)
		MESSAGE(FATAL_ERROR "Cannot find 'iconv' to convert LICENSE.txt")
	ENDIF()

	EXECUTE_PROCESS(COMMAND ${ICONV} -f UTF-8 -t MAC ${CPACK_RESOURCE_FILE_LICENSE} OUTPUT_FILE "${PROJECT_BINARY_DIR}/LICENSE.txt")
	SET(CPACK_RESOURCE_FILE_LICENSE "${PROJECT_BINARY_DIR}/LICENSE.txt")
ENDIF()

IF(${CMAKE_BUILD_TYPE} STREQUAL "RELEASE" OR ${CMAKE_BUILD_TYPE} STREQUAL "MINSIZEREL")
	SET(CPACK_STRIP_FILES TRUE)
ENDIF()

SET(CPACK_SOURCE_GENERATOR TGZ)
SET(CPACK_SOURCE_PACKAGE_FILE_NAME ${FILENAME} CACHE INTERNAL "tarball basename")

SET(CPACK_SOURCE_IGNORE_FILES "\\\\.hgignore" "\\\\.hgtags" "/\\\\.hg/")
LIST(APPEND CPACK_SOURCE_IGNORE_FILES "\\\\.gitignore" "/\\\\.git/")
LIST(APPEND CPACK_SOURCE_IGNORE_FILES "vendor.txt")
LIST(APPEND CPACK_SOURCE_IGNORE_FILES "${CMAKE_CURRENT_BINARY_DIR}")
LIST(APPEND CPACK_SOURCE_IGNORE_FILES "CMakeCache.txt")
LIST(APPEND CPACK_SOURCE_IGNORE_FILES "CMakeFiles")
LIST(APPEND CPACK_SOURCE_IGNORE_FILES "CMakeLists\\\\.txt\\\\.user")
LIST(APPEND CPACK_SOURCE_IGNORE_FILES "\\\\.project")
LIST(APPEND CPACK_SOURCE_IGNORE_FILES "\\\\.cproject")
LIST(APPEND CPACK_SOURCE_IGNORE_FILES "\\\\.reviewboardrc")
LIST(APPEND CPACK_SOURCE_IGNORE_FILES "utils")

SET(CPACK_MONOLITHIC_INSTALL true)


IF(WIN32)
	SET(CPACK_GENERATOR WIX)
	SET(CPACK_WIX_UPGRADE_GUID 4EE0E467-EAB7-483E-AB45-87BD1DB6B037)
	SET(CPACK_WIX_PRODUCT_ICON ${RESOURCES_DIR}/images/npa.ico)
	SET(CPACK_WIX_CULTURES de-DE en-US)
	# disable above line, enable beneath line to build MSI for english
	# SET(CPACK_WIX_CULTURES en-US)
	SET(CPACK_WIX_TEMPLATE ${PACKAGING_DIR}/win/WIX.template.in)
	SET(CPACK_WIX_EXTRA_SOURCES ${PACKAGING_DIR}/win/install_settings.wxs ${PACKAGING_DIR}/win/runtime_settings.wxs)
	SET(CPACK_WIX_UI_BANNER ${RESOURCES_DIR}/images/wix_banner.jpg)
	SET(CPACK_WIX_UI_DIALOG ${RESOURCES_DIR}/images/wix_dialog.jpg)
	SET(CPACK_WIX_EXTENSIONS WixUtilExtension)
	SET(CPACK_WIX_LIGHT_EXTRA_FLAGS -loc ${PACKAGING_DIR}/win/WIX.Texts.de-DE.wxl -loc ${PACKAGING_DIR}/win/WIX.Texts.en-US.wxl)
	# suppress warning LGHT1076/ICE61 caused by AllowSameVersionUpgrades
	SET(CPACK_WIX_LIGHT_EXTRA_FLAGS -sw1076 ${CPACK_WIX_LIGHT_EXTRA_FLAGS})

	IF(SIGNTOOL_CMD)
		MESSAGE(STATUS "MSI can be signed with 'make package.sign'")
		SET(MSI ${PROJECT_BINARY_DIR}/${CPACK_PACKAGE_FILE_NAME}.msi)
		ADD_CUSTOM_TARGET(package.sign COMMAND ${SIGNTOOL_CMD} ${SIGNTOOL_PARAMS} ${MSI}
										COMMAND ${SIGNTOOL_CMD} verify /v /pa ${MSI})
	ENDIF()

ELSEIF(IOS)
	FILE(WRITE ${PROJECT_BINARY_DIR}/ipa.cmake "
		FUNCTION(FIND_BUNDLE _name _out_bundle _out_parent_dir)
			SET(BUNDLE_DIRS \"\${CONFIG}-iphoneos;\${CONFIG};UninstalledProducts;UninstalledProducts/iphoneos\")

			FOREACH(dir \${BUNDLE_DIRS})
				SET(tmpDir ${PROJECT_BINARY_DIR}/src/\${dir})
				SET(tmpBundleDir \${tmpDir}/\${_name})
				IF(EXISTS \"\${tmpBundleDir}\")
					SET(\${_out_bundle} \"\${tmpBundleDir}\" PARENT_SCOPE)
					SET(\${_out_parent_dir} \"\${tmpDir}\" PARENT_SCOPE)
					BREAK()
				ENDIF()
			ENDFOREACH()
		ENDFUNCTION()

		FIND_BUNDLE(${PROJECT_NAME}.app BundleDir ParentDir)

		IF(BundleDir)
			MESSAGE(STATUS \"Use bundle: \${BundleDir}\")
		ELSE()
			MESSAGE(FATAL_ERROR \"Bundle directory does not exist\")
		ENDIF()

		EXECUTE_PROCESS(COMMAND ${CMAKE_COMMAND} -E copy_directory \${BundleDir} Payload/${PROJECT_NAME}.app)
		EXECUTE_PROCESS(COMMAND ${CMAKE_COMMAND} -E tar cf \"${CPACK_PACKAGE_FILE_NAME}.ipa\" --format=zip Payload)
		EXECUTE_PROCESS(COMMAND ${CMAKE_COMMAND} -E remove_directory Payload)

		FIND_BUNDLE(${PROJECT_NAME}.app.dSYM dSYM ParentDir)
		IF(dSYM)
			MESSAGE(STATUS \"Use dSYM: \${dSYM}\")
			EXECUTE_PROCESS(COMMAND ${CMAKE_COMMAND} -E tar cf \"\${CMAKE_BINARY_DIR}/${CPACK_PACKAGE_FILE_NAME}.dSYM.zip\" --format=zip ${PROJECT_NAME}.app.dSYM WORKING_DIRECTORY \${ParentDir})
		ENDIF()
	")

	ADD_CUSTOM_TARGET(ipa COMMAND ${CMAKE_COMMAND} -DCONFIG=$<CONFIGURATION> -P ${CMAKE_BINARY_DIR}/ipa.cmake)

ELSEIF(APPLE)
	SET(MACOS_PACKAGING_DIR ${PACKAGING_DIR}/macos)
	SET(CPACK_GENERATOR Bundle)
	SET(CPACK_INSTALL_CMAKE_PROJECTS ${CMAKE_BINARY_DIR};${PROJECT_NAME};ALL;/)
	SET(CPACK_BUNDLE_NAME ${PROJECT_NAME})
	SET(CPACK_BUNDLE_COPYRIGHT ${COPYRIGHT_TEXT})
	SET(CPACK_BUNDLE_ICON ${RESOURCES_DIR}/images/bundle_icons.icns)
	SET(CPACK_BUNDLE_APPLE_CERT_APP "Developer ID Application: Governikus GmbH & Co. KG (G7EQCJU4BR)")

	SET(CPACK_BUNDLE_APPLE_CODESIGN_FILES ${ADDITIONAL_BUNDLE_FILES_TO_SIGN})
	SET(CPACK_APPLE_BUNDLE_ID "com.governikus.AusweisApp2")
	SET(CPACK_BUNDLE_APPLE_CODESIGN_PARAMETER "--force")
	OPTION(OSX_TIMESTAMP "Timestamp the application bundle" ON)
	IF(OSX_TIMESTAMP)
		SET(CPACK_BUNDLE_APPLE_CODESIGN_PARAMETER "${CPACK_BUNDLE_APPLE_CODESIGN_PARAMETER} --timestamp")
	ELSE()
		SET(CPACK_BUNDLE_APPLE_CODESIGN_PARAMETER "${CPACK_BUNDLE_APPLE_CODESIGN_PARAMETER} --timestamp=none")
	ENDIF()
	SET(CPACK_PACKAGE_ICON ${RESOURCES_DIR}/images/dmg_icons.icns)
	SET(CPACK_DMG_VOLUME_NAME ${CPACK_PACKAGE_NAME})
	SET(CPACK_DMG_FORMAT UDBZ)
	SET(CPACK_DMG_BACKGROUND_IMAGE ${RESOURCES_DIR}/images/dmg_background.png)
	SET(CPACK_DMG_SLA_DIR ${MACOS_PACKAGING_DIR}/sla)
	SET(CPACK_DMG_SLA_LANGUAGES English German)

	# We can not generate the DS_STORE on each build since jenkins runs headless
	#SET(CPACK_DMG_DS_STORE_SETUP_SCRIPT ${MACOS_PACKAGING_DIR}/prepare-ds_store.applescript)
	SET(CPACK_DMG_DS_STORE ${MACOS_PACKAGING_DIR}/DS_STORE)

	SET(INFO_PLIST_FILE_NAME Info.plist)
	CONFIGURE_FILE(${MACOS_PACKAGING_DIR}/${INFO_PLIST_FILE_NAME} ${INFO_PLIST_FILE_NAME} @ONLY)
	SET(CPACK_BUNDLE_PLIST ${INFO_PLIST_FILE_NAME})

ELSEIF(ANDROID)
	FIND_PROGRAM(androiddeployqt androiddeployqt CMAKE_FIND_ROOT_PATH_BOTH)
	IF(NOT androiddeployqt)
		MESSAGE(FATAL_ERROR "Cannot find androiddeployqt to create APKs")
	ENDIF()
	MESSAGE(STATUS "Using androiddeployqt: ${androiddeployqt}")

	FILE(READ "${QT_HOST_PREFIX}/src/android/templates/build.gradle" BUILD_GRADLE)

	IF(ANDROID_BUILD_AAR)
		STRING(REPLACE "apply plugin: 'com.android.application'" "apply plugin: 'com.android.library'" BUILD_GRADLE "${BUILD_GRADLE}")
	ENDIF()

	FILE(WRITE "${CMAKE_INSTALL_PREFIX}/build.gradle" "${BUILD_GRADLE}")
	FILE(READ "${PACKAGING_DIR}/android/build.gradle.append" BUILD_GRADLE)
	FILE(APPEND "${CMAKE_INSTALL_PREFIX}/build.gradle" "${BUILD_GRADLE}")
	OPTION(ANDROID_LINT "Lint Android package" ON)
	IF(NOT ANDROID_LINT)
		FILE(APPEND "${CMAKE_INSTALL_PREFIX}/build.gradle" "tasks.lint.enabled = false")
	ENDIF()

	IF(ANDROID_BUILD_AAR)
		SET(ANDROID_FILE_EXT aar)
		CONFIGURE_FILE(${PACKAGING_DIR}/android/pom.xml.in ${CMAKE_INSTALL_PREFIX}/${CPACK_PACKAGE_FILE_NAME}.pom @ONLY)
		CONFIGURE_FILE("${PACKAGING_DIR}/android/lint.aar.xml" "${CMAKE_INSTALL_PREFIX}/lint.xml" COPYONLY)
	ELSE()
		SET(ANDROID_FILE_EXT apk)
		CONFIGURE_FILE("${PACKAGING_DIR}/android/lint.apk.xml" "${CMAKE_INSTALL_PREFIX}/lint.xml" COPYONLY)
	ENDIF()
	MESSAGE(STATUS "Prepare ${ANDROID_FILE_EXT} file generation")

	IF(${CMAKE_BUILD_TYPE} STREQUAL "RELEASE" OR ${CMAKE_BUILD_TYPE} STREQUAL "RELWITHDEBINFO" OR ${CMAKE_BUILD_TYPE} STREQUAL "MINSIZEREL")
		SET(DEPLOY_CMD_SIGN --release)

		IF(ANDROID_BUILD_AAR)
			SET(ANDROID_FILE dist-release.aar)
		ELSEIF(APK_SIGN_KEYSTORE AND APK_SIGN_KEYSTORE_ALIAS AND APK_SIGN_KEYSTORE_PSW)
			MESSAGE(STATUS "Release build will be signed using: ${APK_SIGN_KEYSTORE} | Alias: ${APK_SIGN_KEYSTORE_ALIAS}")
			SET(DEPLOY_CMD_SIGN --sign ${APK_SIGN_KEYSTORE} ${APK_SIGN_KEYSTORE_ALIAS} --storepass ${APK_SIGN_KEYSTORE_PSW} --digestalg SHA-256 --sigalg SHA256WithRSA)
			SET(ANDROID_FILE dist-release-signed.apk)
		ELSE()
			SET(ANDROID_FILE dist-release-unsigned.apk)
			MESSAGE(WARNING "Cannot sign release build! Set APK_SIGN_KEYSTORE, APK_SIGN_KEYSTORE_ALIAS and APK_SIGN_KEYSTORE_PSW!")
		ENDIF()

	ELSE()
		SET(ANDROID_FILE dist-debug.${ANDROID_FILE_EXT})
	ENDIF()

	SET(DEPLOY_CMD ${androiddeployqt} --verbose --gradle --input ${ANDROID_DEPLOYMENT_SETTINGS} --output ${CMAKE_INSTALL_PREFIX} ${DEPLOY_CMD_SIGN})
	SET(SOURCE_ANDROID_FILE ${CMAKE_INSTALL_PREFIX}/build/outputs/${ANDROID_FILE_EXT})

	IF("${Qt5Core_VERSION}" VERSION_GREATER_EQUAL "5.12.0" AND NOT ANDROID_BUILD_AAR)
		IF(${CMAKE_BUILD_TYPE} STREQUAL "DEBUG")
			SET(SOURCE_ANDROID_FILE ${SOURCE_ANDROID_FILE}/debug)
		ELSE()
			SET(SOURCE_ANDROID_FILE ${SOURCE_ANDROID_FILE}/release)
		ENDIF()
	ENDIF()

	SET(SOURCE_ANDROID_FILE ${SOURCE_ANDROID_FILE}/${ANDROID_FILE})

	SET(DESTINATION_ANDROID_FILE ${CMAKE_INSTALL_PREFIX}/${CPACK_PACKAGE_FILE_NAME}.${ANDROID_FILE_EXT})
	# Add DEPENDS install someday
	# https://gitlab.kitware.com/cmake/cmake/issues/8438
	ADD_CUSTOM_TARGET(${ANDROID_FILE_EXT}
				COMMAND ${DEPLOY_CMD}
				COMMAND ${CMAKE_COMMAND} -E copy ${SOURCE_ANDROID_FILE} ${DESTINATION_ANDROID_FILE})

	ADD_CUSTOM_COMMAND(TARGET ${ANDROID_FILE_EXT} POST_BUILD
				COMMAND ${CMAKE_INSTALL_PREFIX}/gradlew sourcesJar lint
				COMMAND ${CMAKE_COMMAND} -E copy build/libs/dist-sources.jar ${CPACK_PACKAGE_FILE_NAME}-sources.jar
				WORKING_DIRECTORY ${CMAKE_INSTALL_PREFIX})

	IF(NOT ANDROID_BUILD_AAR)
		FIND_PROGRAM(apksigner apksigner HINTS ${ANDROID_SDK}/build-tools/${ANDROID_BUILD_TOOLS_REVISION} CMAKE_FIND_ROOT_PATH_BOTH)
		IF(apksigner)
			ADD_CUSTOM_TARGET(verify.signature COMMAND ${apksigner} verify --verbose --print-certs -Werr ${DESTINATION_ANDROID_FILE})
		ENDIF()
	ENDIF()

ELSEIF(UNIX)
	SET(CPACK_GENERATOR STGZ)
ENDIF()


INCLUDE(CPack)
