/*!
 * \copyright Copyright (c) 2018-2019 Governikus GmbH & Co. KG, Germany
 */

#include "WifiInfo.h"

#include <QLoggingCategory>
#include <QTimerEvent>

#import <Foundation/Foundation.h>
#import <SystemConfiguration/CaptiveNetwork.h>
#import <UIKit/UIKit.h>

Q_DECLARE_LOGGING_CATEGORY(qml)


using namespace governikus;


WifiInfo::WifiInfo()
	: QObject()
	, mWifiEnabled(getCurrentWifiEnabled())
	, mWifiEnableWaitCounter(0)
{
	const int timeoutMs = 1000;
	mWifiCheckTimerId = startTimer(timeoutMs);
}


bool WifiInfo::getCurrentWifiEnabled()
{
	// https://stackoverflow.com/a/25963050
	Boolean networkInterfaceAvailable = false;
	NSArray* interfaces = CFBridgingRelease(CNCopySupportedInterfaces());
	for (NSString* interface in interfaces)
	{
		NSDictionary* networkInfo = CFBridgingRelease(CNCopyCurrentNetworkInfo(reinterpret_cast<CFStringRef>(interface)));
		if (networkInfo != nullptr)
		{
			networkInterfaceAvailable = true;
			break;
		}
	}
	return networkInterfaceAvailable;
}


void WifiInfo::enableWifi()
{
	// While it is possible to do this programmatically using private APIs, Apple will reject apps that do this.
	qCWarning(qml) << "NOT IMPLEMENTED";
}


void WifiInfo::timerEvent(QTimerEvent* pEvent)
{
	if (pEvent->timerId() == mWifiCheckTimerId)
	{
		pEvent->accept();

		const bool currentEnabled = getCurrentWifiEnabled() || hasPrivateIpAddress();
		if (mWifiEnabled != currentEnabled)
		{
			mWifiEnabled = currentEnabled;
			Q_EMIT fireWifiEnabledChanged(mWifiEnabled);
		}
	}

	QObject::timerEvent(pEvent);
}


bool WifiInfo::isWifiEnabled()
{
	return mWifiEnabled;
}


#include "moc_WifiInfo.cpp"
