# coding=utf-8
# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# --------------------------------------------------------------------------------------------

from knack.help_files import helps  # pylint: disable=import-error
# pylint: disable=line-too-long, too-many-lines

helps['acs'] = """
type: group
short-summary: Manage Azure Container Services.
long-summary: |
    ACS will be retired as a standalone service on January 31, 2020.

    If you use the Kubernetes orchestrator, please migrate to AKS by January 31, 2020.
"""

helps['acs browse'] = """
type: command
short-summary: Show the dashboard for a service container's orchestrator in a web browser.
examples:
  - name: Show the dashboard for a service container's orchestrator in a web browser. (autogenerated)
    text: az acs browse --name MyContainerService --resource-group MyResourceGroup
    crafted: true
"""

helps['acs create'] = """
type: command
short-summary: Create a new container service.
parameters:
  - name: --service-principal
    type: string
    short-summary: Service principal used for authentication to Azure APIs.
    long-summary: If not specified, a new service principal with the contributor role is created and cached at $HOME/.azure/acsServicePrincipal.json to be used by subsequent `az acs` commands.
  - name: --client-secret
    type: string
    short-summary: Secret associated with the service principal. This argument is required if `--service-principal` is specified.
  - name: --agent-count
    short-summary: Set the default number of agents for the agent pools.
    long-summary: Note that DC/OS clusters will have 1 or 2 additional public agents.
examples:
  - name: Create a DCOS cluster with an existing SSH key.
    text: |-
        az acs create --orchestrator-type DCOS -g MyResourceGroup -n MyContainerService \\
          --ssh-key-value /path/to/publickey
  - name: Create a DCOS cluster with two agent pools.
    text: |-
        az acs create -g MyResourceGroup -n MyContainerService --agent-profiles '[ \\
          { \\
            "name": "agentpool1" \\
          }, \\
          { \\
            "name": "agentpool2" \\
          }]'
  - name: Create a DCOS cluster where the second agent pool has a vmSize specified.
    text: |-
        az acs create -g MyResourceGroup -n MyContainerService --agent-profiles '[ \\
          { \\
            "name": "agentpool1" \\
          }, \\
          { \\
            "name": "agentpool2", \\
            "vmSize": "Standard_D2" \\
          }]'
  - name: Create a DCOS cluster with agent-profiles specified from a file.
    text: az acs create -g MyResourceGroup -n MyContainerService --agent-profiles MyAgentProfiles.json
"""

helps['acs dcos'] = """
type: group
short-summary: Commands to manage a DC/OS-orchestrated Azure Container Service.
"""

helps['acs dcos install-cli'] = """
type: command
short-summary: Download and install the DC/OS command-line tool for a cluster.
"""

helps['acs delete'] = """
type: command
short-summary: Delete a container service.
examples:
  - name: Delete a container service. (autogenerated)
    text: az acs delete --name MyContainerService --resource-group MyResourceGroup
    crafted: true
"""

helps['acs kubernetes'] = """
type: group
short-summary: Commands to manage a Kubernetes-orchestrated Azure Container Service.
"""

helps['acs kubernetes get-credentials'] = """
type: command
short-summary: Download and install credentials to access a cluster.  This command requires the same private-key used to create the cluster.
parameters:
  - name: --output -o
    type: string
    long-summary: Credentials are always in YAML format, so this argument is effectively ignored.
examples:
  - name: Download and install credentials to access a cluster.  This command requires the same private-key used to create the cluster. (autogenerated)
    text: az acs kubernetes get-credentials --name MyContainerService --resource-group MyResourceGroup
    crafted: true
"""

helps['acs kubernetes install-cli'] = """
type: command
short-summary: Download and install the Kubernetes command-line tool for a cluster.
"""

helps['acs list'] = """
type: command
short-summary: List container services.
"""

helps['acs list-locations'] = """
type: command
short-summary: List locations where Azure Container Service is in preview and in production.
"""

helps['acs scale'] = """
type: command
short-summary: Change the private agent count of a container service.
parameters:
  - name: --new-agent-count
    type: int
    short-summary: The number of agents for the container service.
examples:
  - name: Change the private agent count of a container service. (autogenerated)
    text: az acs scale --name MyContainerService --new-agent-count 10 --resource-group MyResourceGroup
    crafted: true
"""

helps['acs show'] = """
type: command
short-summary: Show the details for a container service.
examples:
  - name: Show the details for a container service. (autogenerated)
    text: az acs show --name MyContainerService --resource-group MyResourceGroup
    crafted: true
"""

helps['acs wait'] = """
type: command
short-summary: Wait for a container service to reach a desired state.
long-summary: If an operation on a container service was interrupted or was started with `--no-wait`, use this command to wait for it to complete.
"""

helps['aks'] = """
type: group
short-summary: Manage Azure Kubernetes Services.
"""

helps["aks check-acr"] = """
type: command
short-summary: Validate an ACR is accessible from an AKS cluster.
parameters:
  - name: --acr
    short-summary: The FQDN of the ACR.
examples:
  - name: Validate the ACR is accessible from the AKS cluster.
    text: az aks check-acr --name MyManagedCluster --resource-group MyResourceGroup --acr myacr.azurecr.io
    crafted: true
"""

helps['aks browse'] = """
type: command
short-summary: Show the dashboard for a Kubernetes cluster in a web browser.
parameters:
  - name: --disable-browser
    type: bool
    short-summary: Don't launch a web browser after establishing port-forwarding.
    long-summary: Add this argument when launching a web browser manually, or for automated testing.
  - name: --listen-port
    short-summary: The listening port for the dashboard.
    long-summary: Add this argument when the default listening port is used by another process or unavailable.
  - name: --listen-address
    short-summary: The listening address for the dashboard.
    long-summary: Add this argument to listen on a specific IP address.
examples:
  - name: Show the dashboard for a Kubernetes cluster in a web browser. (autogenerated)
    text: az aks browse --name MyManagedCluster --resource-group MyResourceGroup
    crafted: true
"""

helps['aks create'] = """
type: command
short-summary: Create a new managed Kubernetes cluster.
parameters:
  - name: --generate-ssh-keys
    type: string
    short-summary: Generate SSH public and private key files if missing. The keys will be stored in the ~/.ssh directory.
  - name: --service-principal
    type: string
    short-summary: Service principal used for authentication to Azure APIs.
    long-summary: If not specified, a new service principal is created and cached at $HOME/.azure/aksServicePrincipal.json to be used by subsequent `az aks` commands.
  - name: --skip-subnet-role-assignment
    type: bool
    short-summary: Skip role assignment for subnet (advanced networking).
    long-summary: If specified, please make sure your service principal has the access to your subnet.
  - name: --client-secret
    type: string
    short-summary: Secret associated with the service principal. This argument is required if `--service-principal` is specified.
  - name: --node-vm-size -s
    type: string
    short-summary: Size of Virtual Machines to create as Kubernetes nodes.
  - name: --dns-name-prefix -p
    type: string
    short-summary: Prefix for hostnames that are created. If not specified, generate a hostname using the managed cluster and resource group names.
  - name: --node-count -c
    type: int
    short-summary: Number of nodes in the Kubernetes node pool. After creating a cluster, you can change the size of its node pool with `az aks scale`.
  - name: --zones -z
    type: string array
    short-summary: Availability zones where agent nodes will be placed.
  - name: --node-osdisk-size
    type: int
    short-summary: Size in GB of the OS disk for each node in the node pool. Minimum 30 GB.
  - name: --node-osdisk-type
    type: string
    short-summary: "OS disk type to be used for machines in a given agent pool: Ephemeral or Managed. Defaults to 'Ephemeral' when possible in conjunction with VM size and OS disk size. May not be changed for this pool after creation."
  - name: --kubernetes-version -k
    type: string
    short-summary: Version of Kubernetes to use for creating the cluster, such as "1.16.9".
    populator-commands:
      - "`az aks get-versions`"
  - name: --os-sku
    type: string
    short-summary: The OS SKU of the agent node pool. Ubuntu or CBLMariner.
  - name: --ssh-key-value
    type: string
    short-summary: Public key path or key contents to install on node VMs for SSH access. For example, 'ssh-rsa AAAAB...snip...UcyupgH azureuser@linuxvm'.
  - name: --admin-username -u
    type: string
    short-summary: User account to create on node VMs for SSH access.
  - name: --windows-admin-username
    type: string
    short-summary: User account to create on windows node VMs.
    long-summary: |-
      Rules for windows-admin-username:
          - restriction: Cannot end in "."
          - Disallowed values: "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5".
          - Minimum-length: 1 character
          - Max-length: 20 characters
      Reference: https://docs.microsoft.com/dotnet/api/microsoft.azure.management.compute.models.virtualmachinescalesetosprofile.adminusername?view=azure-dotnet
  - name: --windows-admin-password
    type: string
    short-summary: User account password to use on windows node VMs.
    long-summary: |-
      Rules for windows-admin-password:
          - Minimum-length: 14 characters
          - Max-length: 123 characters
          - Complexity requirements: 3 out of 4 conditions below need to be fulfilled
            * Has lower characters
            * Has upper characters
            * Has a digit
            * Has a special character (Regex match [\\W_])
          - Disallowed values:  "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!"
      Reference: https://docs.microsoft.com/dotnet/api/microsoft.azure.management.compute.models.virtualmachinescalesetosprofile.adminpassword?view=azure-dotnet
  - name: --enable-ahub
    type: bool
    short-summary: Enable Azure Hybrid User Benefits (AHUB) for Windows VMs.
  - name: --enable-aad
    type: bool
    short-summary: Enable managed AAD feature for cluster.
  - name: --aad-admin-group-object-ids
    type: string
    short-summary: Comma seperated list of aad group object IDs that will be set as cluster admin.
  - name: --aad-client-app-id
    type: string
    short-summary: The ID of an Azure Active Directory client application of type "Native". This application is for user login via kubectl.
  - name: --aad-server-app-id
    type: string
    short-summary: The ID of an Azure Active Directory server application of type "Web app/API". This application represents the managed cluster's apiserver (Server application).
  - name: --aad-server-app-secret
    type: string
    short-summary: The secret of an Azure Active Directory server application.
  - name: --aad-tenant-id
    type: string
    short-summary: The ID of an Azure Active Directory tenant.
  - name: --dns-service-ip
    type: string
    short-summary: An IP address assigned to the Kubernetes DNS service.
    long-summary: This address must be within the Kubernetes service address range specified by "--service-cidr". For example, 10.0.0.10.
  - name: --docker-bridge-address
    type: string
    short-summary: A specific IP address and netmask for the Docker bridge, using standard CIDR notation.
    long-summary: This address must not be in any Subnet IP ranges, or the Kubernetes service address range. For example, 172.17.0.1/16.
  - name: --load-balancer-sku
    type: string
    short-summary: Azure Load Balancer SKU selection for your cluster. basic or standard.
    long-summary: Select between Basic or Standard Azure Load Balancer SKU for your AKS cluster.
  - name: --load-balancer-managed-outbound-ip-count
    type: int
    short-summary: Load balancer managed outbound IP count.
    long-summary: Desired number of managed outbound IPs for load balancer outbound connection. Valid for Standard SKU load balancer cluster only.
  - name: --load-balancer-outbound-ips
    type: string
    short-summary: Load balancer outbound IP resource IDs.
    long-summary: Comma-separated public IP resource IDs for load balancer outbound connection. Valid for Standard SKU load balancer cluster only.
  - name: --load-balancer-outbound-ip-prefixes
    type: string
    short-summary: Load balancer outbound IP prefix resource IDs.
    long-summary: Comma-separated public IP prefix resource IDs for load balancer outbound connection. Valid for Standard SKU load balancer cluster only.
  - name: --load-balancer-outbound-ports
    type: int
    short-summary: Load balancer outbound allocated ports.
    long-summary: Desired static number of outbound ports per VM in the load balancer backend pool. By default, set to 0 which uses the default allocation based on the number of VMs.
  - name: --load-balancer-idle-timeout
    type: int
    short-summary: Load balancer idle timeout in minutes.
    long-summary: Desired idle timeout for load balancer outbound flows, default is 30 minutes. Please specify a value in the range of [4, 100].
  - name: --outbound-type
    type: string
    short-summary: How outbound traffic will be configured for a cluster.
    long-summary: Select between loadBalancer and userDefinedRouting. If not set, defaults to type loadBalancer. Requires --vnet-subnet-id to be provided with a preconfigured route table and --load-balancer-sku to be Standard.
  - name: --auto-upgrade-channel
    type: string
    short-summary: Specify the upgrade channel for autoupgrade.
  - name: --enable-cluster-autoscaler
    type: bool
    short-summary: Enable cluster autoscaler, default value is false.
    long-summary: If specified, please make sure the kubernetes version is larger than 1.10.6.
  - name: --min-count
    type: int
    short-summary: Minimum nodes count used for autoscaler, when "--enable-cluster-autoscaler" specified. Please specify the value in the range of [1, 1000].
  - name: --max-count
    type: int
    short-summary: Maximum nodes count used for autoscaler, when "--enable-cluster-autoscaler" specified. Please specify the value in the range of [1, 1000].
  - name: --vm-set-type
    type: string
    short-summary: Agent pool vm set type. VirtualMachineScaleSets or AvailabilitySet.
  - name: --enable-addons -a
    type: string
    short-summary: Enable the Kubernetes addons in a comma-separated list.
    long-summary: |-
        These addons are available:
            - http_application_routing : configure ingress with automatic public DNS name creation.
            - monitoring               : turn on Log Analytics monitoring. Uses the Log Analytics Default Workspace if it exists, else creates one.
                                         Specify "--workspace-resource-id" to use an existing workspace.
                                         Specify "--enable-msi-auth-for-monitoring" to use Managed Identity Auth.
                                         If monitoring addon is enabled --no-wait argument will have no effect
            - azure-policy             : enable Azure policy. The Azure Policy add-on for AKS enables at-scale enforcements and safeguards on your clusters in a centralized, consistent manner.
                                         Learn more at aka.ms/aks/policy.
            - virtual-node             : enable AKS Virtual Node.
                                         Requires --aci-subnet-name to provide the name of an existing subnet for the Virtual Node to use.
                                         aci-subnet-name must be in the same vnet which is specified by --vnet-subnet-id (required as well).
            - confcom                  : enable confcom addon, this will enable SGX device plugin by default.
            - open-service-mesh        : enable Open Service Mesh addon.
            - azure-keyvault-secrets-provider : enable Azure Keyvault Secrets Provider addon.
  - name: --disable-rbac
    type: bool
    short-summary: Disable Kubernetes Role-Based Access Control.
  - name: --enable-rbac -r
    type: bool
    short-summary: "Enable Kubernetes Role-Based Access Control. Default: enabled."
  - name: --max-pods -m
    type: int
    short-summary: The maximum number of pods deployable to a node.
    long-summary: If not specified, defaults to 110, or 30 for advanced networking configurations.
  - name: --network-plugin
    type: string
    short-summary: The Kubernetes network plugin to use.
    long-summary: Specify "azure" for advanced networking configurations. Defaults to "kubenet".
  - name: --network-policy
    type: string
    short-summary: The Kubernetes network policy to use.
    long-summary: |
        Using together with "azure" network plugin.
        Specify "azure" for Azure network policy manager and "calico" for calico network policy controller.
        Defaults to "" (network policy disabled).
  - name: --no-ssh-key -x
    type: string
    short-summary: Do not use or create a local SSH key.
    long-summary: To access nodes after creating a cluster with this option, use the Azure Portal.
  - name: --pod-cidr
    type: string
    short-summary: A CIDR notation IP range from which to assign pod IPs when kubenet is used.
    long-summary: This range must not overlap with any Subnet IP ranges. For example, 172.244.0.0/16.
  - name: --service-cidr
    type: string
    short-summary: A CIDR notation IP range from which to assign service cluster IPs.
    long-summary: This range must not overlap with any Subnet IP ranges. For example, 10.0.0.0/16.
  - name: --vnet-subnet-id
    type: string
    short-summary: The ID of a subnet in an existing VNet into which to deploy the cluster.
  - name: --pod-subnet-id
    type: string
    short-summary: The ID of a subnet in an existing VNet into which to assign pods in the cluster (requires azure network-plugin).
  - name: --ppg
    type: string
    short-summary: The ID of a PPG.
  - name: --enable-node-public-ip
    type: bool
    short-summary: Enable VMSS node public IP.
  - name: --node-public-ip-prefix-id
    type: string
    short-summary: Public IP prefix ID used to assign public IPs to VMSS nodes.
  - name: --workspace-resource-id
    type: string
    short-summary: The resource ID of an existing Log Analytics Workspace to use for storing monitoring data. If not specified, uses the default Log Analytics Workspace if it exists, otherwise creates one.
  - name: --enable-msi-auth-for-monitoring
    type: bool
    short-summary: Enable Managed Identity Auth for Monitoring addon.
  - name: --uptime-sla
    type: bool
    short-summary: Enable a paid managed cluster service with a financially backed SLA.
  - name: --attach-acr
    type: string
    short-summary: Grant the 'acrpull' role assignment to the ACR specified by name or resource ID.
  - name: --enable-private-cluster
    type: string
    short-summary: Enable private cluster.
  - name: --private-dns-zone
    type: string
    short-summary: Private dns zone mode for private cluster.
    long-summary: Allowed values are "system", "none" or custom private dns zone resource id. If not set, defaults to type system. Requires --enable-private-cluster to be used.
  - name: --fqdn-subdomain
    type: string
    short-summary: Prefix for FQDN that is created for private cluster with custom private dns zone scenario.
  - name: --disable-public-fqdn
    type: bool
    short-summary: Disable public fqdn feature for private cluster.
  - name: --api-server-authorized-ip-ranges
    type: string
    short-summary: Comma seperated list of authorized apiserver IP ranges. Set to 0.0.0.0/32 to restrict apiserver traffic to node pools.
  - name: --enable-managed-identity
    type: bool
    short-summary: Using a system assigned managed identity to manage cluster resource group.
  - name: --assign-identity
    type: string
    short-summary: Specify an existing user assigned identity for control plane's usage in order to manage cluster resource group.
  - name: --assign-kubelet-identity
    type: string
    short-summary: Specify an existing user assigned identity for kubelet's usage, which is typically used to pull image from ACR.
  - name: --node-osdisk-diskencryptionset-id -d
    type: string
    short-summary: ResourceId of the disk encryption set to use for enabling encryption at rest on agent node os disk.
  - name: --aci-subnet-name
    type: string
    short-summary: The name of a subnet in an existing VNet into which to deploy the virtual nodes.
  - name: --appgw-name
    type: string
    short-summary: Name of the application gateway to create/use in the node resource group. Use with ingress-azure addon.
  - name: --appgw-subnet-cidr
    type: string
    short-summary: Subnet CIDR to use for a new subnet created to deploy the Application Gateway. Use with ingress-azure addon.
  - name: --appgw-id
    type: string
    short-summary: Resource Id of an existing Application Gateway to use with AGIC. Use with ingress-azure addon.
  - name: --appgw-subnet-id
    type: string
    short-summary: Resource Id of an existing Subnet used to deploy the Application Gateway. Use with ingress-azure addon.
  - name: --appgw-watch-namespace
    type: string
    short-summary: Specify the namespace, which AGIC should watch. This could be a single string value, or a comma-separated list of namespaces.
  - name: --enable-sgxquotehelper
    type: bool
    short-summary: Enable SGX quote helper for confcom addon.
  - name: --enable-encryption-at-host
    type: bool
    short-summary: Enable EncryptionAtHost, default value is false.
  - name: --enable-ultra-ssd
    type: bool
    short-summary: Enable UltraSSD, default value is false.
  - name: --enable-azure-rbac
    type: bool
    short-summary: Enable Azure RBAC to control authorization checks on cluster.
  - name: --edge-zone
    type: string
    short-summary: The name of the Edge Zone.
  - name: --disable-local-accounts
    type: bool
    short-summary: If set to true, getting static credential will be disabled for this cluster.
  - name: --tags
    type: string
    short-summary: The tags of the managed cluster. The managed cluster instance and all resources managed by the cloud provider will be tagged.
  - name: --aks-custom-headers
    type: string
    short-summary: Comma-separated key-value pairs to specify custom headers.
  - name: --enable-secret-rotation
    type: bool
    short-summary: Enable secret rotation. Use with azure-keyvault-secrets-provider addon.
  - name: --rotation-poll-interval
    type: string
    short-summary: Set interval of rotation poll. Use with azure-keyvault-secrets-provider addon.
  - name: --enable-fips-image
    type: bool
    short-summary: Use FIPS-enabled OS on agent nodes.
  - name: --enable-windows-gmsa
    type: bool
    short-summary: Enable Windows gmsa.
  - name: --gmsa-dns-server
    type: string
    short-summary: Specify DNS server for Windows gmsa for this cluster.
    long-summary: |-
        You do not need to set this if you have set DNS server in the VNET used by the cluster.
        You must set or not set --gmsa-dns-server and --gmsa-root-domain-name at the same time when setting --enable-windows-gmsa.
  - name: --gmsa-root-domain-name
    type: string
    short-summary: Specify root domain name for Windows gmsa for this cluster.
    long-summary: |-
        You do not need to set this if you have set DNS server in the VNET used by the cluster.
        You must set or not set --gmsa-dns-server and --gmsa-root-domain-name at the same time when setting --enable-windows-gmsa.
  - name: --snapshot-id
    type: string
    short-summary: The source snapshot id used to create this cluster.
  - name: --kubelet-config
    type: string
    short-summary: Path to JSON file containing Kubelet configurations for agent nodes. https://aka.ms/aks/custom-node-config
  - name: --linux-os-config
    type: string
    short-summary: Path to JSON file containing OS configurations for Linux agent nodes. https://aka.ms/aks/custom-node-config
examples:
  - name: Create a Kubernetes cluster with an existing SSH public key.
    text: az aks create -g MyResourceGroup -n MyManagedCluster --ssh-key-value /path/to/publickey
  - name: Create a Kubernetes cluster with a specific version.
    text: az aks create -g MyResourceGroup -n MyManagedCluster --kubernetes-version 1.16.9
  - name: Create a Kubernetes cluster with a larger node pool.
    text: az aks create -g MyResourceGroup -n MyManagedCluster --node-count 7
  - name: Create a kubernetes cluster with k8s 1.13.9 but use vmas.
    text: az aks create -g MyResourceGroup -n MyManagedCluster --kubernetes-version 1.16.9 --vm-set-type AvailabilitySet
  - name: Create a kubernetes cluster with default kubernetes version, default SKU load balancer (Standard) and default vm set type (VirtualMachineScaleSets).
    text: az aks create -g MyResourceGroup -n MyManagedCluster
  - name: Create a kubernetes cluster with standard SKU load balancer and two AKS created IPs for the load balancer outbound connection usage.
    text: az aks create -g MyResourceGroup -n MyManagedCluster --load-balancer-managed-outbound-ip-count 2
  - name: Create a kubernetes cluster with a standard SKU load balancer, with two outbound AKS managed IPs an idle flow timeout of 5 minutes and 8000 allocated ports per machine
    text: az aks create -g MyResourceGroup -n MyManagedCluster --load-balancer-managed-outbound-ip-count 2 --load-balancer-idle-timeout 5 --load-balancer-outbound-ports 8000
  - name: Create a kubernetes cluster with standard SKU load balancer and use the provided public IPs for the load balancer outbound connection usage.
    text: az aks create -g MyResourceGroup -n MyManagedCluster --load-balancer-outbound-ips <ip-resource-id-1,ip-resource-id-2>
  - name: Create a kubernetes cluster with standard SKU load balancer and use the provided public IP prefixes for the load balancer outbound connection usage.
    text: az aks create -g MyResourceGroup -n MyManagedCluster --load-balancer-outbound-ip-prefixes <ip-prefix-resource-id-1,ip-prefix-resource-id-2>
  - name: Create a kubernetes cluster with basic SKU load balancer and AvailabilitySet vm set type.
    text: az aks create -g MyResourceGroup -n MyManagedCluster --load-balancer-sku basic --vm-set-type AvailabilitySet
  - name: Create a kubernetes cluster with authorized apiserver IP ranges.
    text: az aks create -g MyResourceGroup -n MyManagedCluster --api-server-authorized-ip-ranges 193.168.1.0/24,194.168.1.0/24,195.168.1.0
  - name: Create a kubernetes cluster which enables managed identity.
    text: az aks create -g MyResourceGroup -n MyManagedCluster --enable-managed-identity
  - name: Create a kubernetes cluster with userDefinedRouting, standard load balancer SKU and a custom subnet preconfigured with a route table
    text: az aks create -g MyResourceGroup -n MyManagedCluster --outbound-type userDefinedRouting --load-balancer-sku standard --vnet-subnet-id customUserSubnetVnetID
  - name: Create a kubernetes cluster with supporting Windows agent pools.
    text: az aks create -g MyResourceGroup -n MyManagedCluster --load-balancer-sku Standard --network-plugin azure --windows-admin-username azure --windows-admin-password 'replacePassword1234$'
  - name: Create a kubernetes cluster with supporting Windows agent pools with AHUB enabled.
    text: az aks create -g MyResourceGroup -n MyManagedCluster --load-balancer-sku Standard --network-plugin azure --windows-admin-username azure --windows-admin-password 'replacePassword1234$' --enable-ahub
  - name: Create a kubernetes cluster with managed AAD enabled.
    text: az aks create -g MyResourceGroup -n MyManagedCluster --enable-aad --aad-admin-group-object-ids <id-1,id-2> --aad-tenant-id <id>
  - name: Create a kubernetes cluster with server side encryption using your owned key.
    text: az aks create -g MyResourceGroup -n MyManagedCluster --node-osdisk-diskencryptionset-id <disk-encryption-set-resource-id>
  - name: Create a kubernetes cluster with ephemeral OS enabled.
    text: az aks create -g MyResourceGroup -n MyManagedCluster --node-osdisk-type Ephemeral --node-osdisk-size 48
  - name: Create a kubernetes cluster with EncryptionAtHost enabled.
    text: az aks create -g MyResourceGroup -n MyManagedCluster --enable-encryption-at-host
  - name: Create a kubernetes cluster with UltraSSD enabled.
    text: az aks create -g MyResourceGroup -n MyManagedCluster --enable-ultra-ssd
  - name: Create a kubernetes cluster with Azure RBAC enabled.
    text: az aks create -g MyResourceGroup -n MyManagedCluster --enable-aad --enable-azure-rbac
  - name: Create a kubernetes cluster with custom control plane identity and kubelet identity.
    text: az aks create -g MyResourceGroup -n MyManagedCluster --assign-identity <control-plane-identity-resource-id> --assign-kubelet-identity <kubelet-identity-resource-id>
  - name: Create a kubernetes cluster in the Edge Zone.
    text: az aks create -g MyResourceGroup -n MyManagedCluster --location <location> --kubernetes-version 1.20.7 --edge-zone <edge-zone-name>
  - name: Create a kubernetes cluster with a specific OS SKU
    text: az aks create -g MyResourceGroup -n MyManagedCluster --os-sku Ubuntu
  - name: Create a kubernetes cluster with custom tags
    text: az aks create -g MyResourceGroup -n MyManagedCluster --tags "foo=bar" "baz=qux"
  - name: Create a kubernetes cluster with custom headers
    text: az aks create -g MyResourceGroup -n MyManagedCluster --aks-custom-headers WindowsContainerRuntime=containerd,AKSHTTPCustomFeatures=Microsoft.ContainerService/CustomNodeConfigPreview
  - name: Create a kubernetes cluster with FIPS-enabled OS
    text: az aks create -g MyResourceGroup -n MyManagedCluster --enable-fips-image
  - name: Create a kubernetes cluster with enabling Windows gmsa and with setting DNS server in the vnet used by the cluster.
    text: az aks create -g MyResourceGroup -n MyManagedCluster --load-balancer-sku Standard --network-plugin azure --windows-admin-username azure --windows-admin-password 'replacePassword1234$' --enable-windows-gmsa
  - name: Create a kubernetes cluster with enabling Windows gmsa but without setting DNS server in the vnet used by the cluster.
    text: az aks create -g MyResourceGroup -n MyManagedCluster --load-balancer-sku Standard --network-plugin azure --windows-admin-username azure --windows-admin-password 'replacePassword1234$' --enable-windows-gmsa --gmsa-dns-server "10.240.0.4" --gmsa-root-domain-name "contoso.com"
  - name: create a kubernetes cluster with a snapshot id.
    text: az aks create -g MyResourceGroup -n MyManagedCluster --kubernetes-version 1.20.9 --snapshot-id "/subscriptions/00000/resourceGroups/AnotherResourceGroup/providers/Microsoft.ContainerService/snapshots/mysnapshot1"
"""

helps['aks update'] = """
type: command
short-summary: Update a managed Kubernetes cluster.
parameters:
  - name: --enable-cluster-autoscaler -e
    type: bool
    short-summary: Enable cluster autoscaler.
  - name: --disable-cluster-autoscaler -d
    type: bool
    short-summary: Disable cluster autoscaler.
  - name: --update-cluster-autoscaler -u
    type: bool
    short-summary: Update min-count or max-count for cluster autoscaler.
  - name: --min-count
    type: int
    short-summary: Minimum nodes count used for autoscaler, when "--enable-cluster-autoscaler" specified. Please specify the value in the range of [1, 1000]
  - name: --max-count
    type: int
    short-summary: Maximum nodes count used for autoscaler, when "--enable-cluster-autoscaler" specified. Please specify the value in the range of [1, 1000]
  - name: --uptime-sla
    type: bool
    short-summary: Enable a paid managed cluster service with a financially backed SLA.
  - name: --no-uptime-sla
    type: bool
    short-summary: Change a paid managed cluster to a free one.
  - name: --load-balancer-managed-outbound-ip-count
    type: int
    short-summary: Load balancer managed outbound IP count.
    long-summary: Desired number of managed outbound IPs for load balancer outbound connection. Valid for Standard SKU load balancer cluster only. If updated, it will wipe off the existing setting on Load balancer managed outbound IP count; Load balancer outbound IP resource IDs and Load balancer outbound IP prefix resource IDs.
  - name: --load-balancer-outbound-ips
    type: string
    short-summary: Load balancer outbound IP resource IDs.
    long-summary: Comma-separated public IP resource IDs for load balancer outbound connection. Valid for Standard SKU load balancer cluster only. If updated, it will wipe off the existing setting on Load balancer managed outbound IP count; Load balancer outbound IP resource IDs and Load balancer outbound IP prefix resource IDs.
  - name: --load-balancer-outbound-ip-prefixes
    type: string
    short-summary: Load balancer outbound IP prefix resource IDs.
    long-summary: Comma-separated public IP prefix resource IDs for load balancer outbound connection. Valid for Standard SKU load balancer cluster only. If updated, it will wipe off the existing setting on Load balancer managed outbound IP count; Load balancer outbound IP resource IDs and Load balancer outbound IP prefix resource IDs.
  - name: --load-balancer-outbound-ports
    type: int
    short-summary: Load balancer outbound allocated ports.
    long-summary: Desired static number of outbound ports per VM in the load balancer backend pool. By default, set to 0 which uses the default allocation based on the number of VMs.
  - name: --load-balancer-idle-timeout
    type: int
    short-summary: Load balancer idle timeout in minutes.
    long-summary: Desired idle timeout for load balancer outbound flows, default is 30 minutes. Please specify a value in the range of [4, 100].
  - name: --auto-upgrade-channel
    type: string
    short-summary: Specify the upgrade channel for autoupgrade.
  - name: --attach-acr
    type: string
    short-summary: Grant the 'acrpull' role assignment to the ACR specified by name or resource ID.
  - name: --detach-acr
    type: string
    short-summary: Disable the 'acrpull' role assignment to the ACR specified by name or resource ID.
  - name: --api-server-authorized-ip-ranges
    type: string
    short-summary: Comma seperated list of authorized apiserver IP ranges. Set to "" to allow all traffic on a previously restricted cluster. Set to 0.0.0.0/32 to restrict apiserver traffic to node pools.
  - name: --enable-aad
    type: bool
    short-summary: Enable managed AAD feature for cluster.
  - name: --aad-admin-group-object-ids
    type: string
    short-summary: Comma seperated list of aad group object IDs that will be set as cluster admin.
  - name: --aad-tenant-id
    type: string
    short-summary: The ID of an Azure Active Directory tenant.
  - name: --enable-ahub
    type: bool
    short-summary: Enable Azure Hybrid User Benefits (AHUB) feature for cluster.
  - name: --disable-ahub
    type: bool
    short-summary: Disable Azure Hybrid User Benefits (AHUB) feature for cluster.
  - name: --windows-admin-password
    type: string
    short-summary: User account password to use on windows node VMs.
    long-summary: |-
      Rules for windows-admin-password:
          - Minimum-length: 14 characters
          - Max-length: 123 characters
          - Complexity requirements: 3 out of 4 conditions below need to be fulfilled
            * Has lower characters
            * Has upper characters
            * Has a digit
            * Has a special character (Regex match [\\W_])
          - Disallowed values:  "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!"
      Reference: https://docs.microsoft.com/dotnet/api/microsoft.azure.management.compute.models.virtualmachinescalesetosprofile.adminpassword?view=azure-dotnet
  - name: --enable-managed-identity
    type: bool
    short-summary: Update current cluster to use managed identity to manage cluster resource group.
  - name: --assign-identity
    type: string
    short-summary: Specify an existing user assigned identity to manage cluster resource group.
  - name: --enable-azure-rbac
    type: bool
    short-summary: Enable Azure RBAC to control authorization checks on cluster.
  - name: --disable-azure-rbac
    type: bool
    short-summary: Disable Azure RBAC to control authorization checks on cluster.
  - name: --enable-public-fqdn
    type: bool
    short-summary: Enable public fqdn feature for private cluster.
  - name: --disable-public-fqdn
    type: bool
    short-summary: Disable public fqdn feature for private cluster.
  - name: --disable-local-accounts
    type: bool
    short-summary: If set to true, getting static credential will be disabled for this cluster.
  - name: --enable-local-accounts
    type: bool
    short-summary: If set to true, will enable getting static credential for this cluster.
  - name: --tags
    type: string
    short-summary: The tags of the managed cluster. The managed cluster instance and all resources managed by the cloud provider will be tagged.
  - name: --aks-custom-headers
    type: string
    short-summary: Comma-separated key-value pairs to specify custom headers.
  - name: --enable-secret-rotation
    type: bool
    short-summary: Enable secret rotation. Use with azure-keyvault-secrets-provider addon.
  - name: --disable-secret-rotation
    type: bool
    short-summary: Disable secret rotation. Use with azure-keyvault-secrets-provider addon.
  - name: --rotation-poll-interval
    type: string
    short-summary: Set interval of rotation poll. Use with azure-keyvault-secrets-provider addon.
  - name: --enable-windows-gmsa
    type: bool
    short-summary: Enable Windows gmsa on cluster.
  - name: --gmsa-dns-server
    type: string
    short-summary: Specify DNS server for Windows gmsa on cluster.
    long-summary: |-
        You do not need to set this if you have set DNS server in the VNET used by the cluster.
        You must set or not set --gmsa-dns-server and --gmsa-root-domain-name at the same time when setting --enable-windows-gmsa.
  - name: --gmsa-root-domain-name
    type: string
    short-summary: Specify root domain name for Windows gmsa on cluster.
    long-summary: |-
        You do not need to set this if you have set DNS server in the VNET used by the cluster.
        You must set or not set --gmsa-dns-server and --gmsa-root-domain-name at the same time when setting --enable-windows-gmsa.
examples:
  - name: Update a kubernetes cluster with standard SKU load balancer to use two AKS created IPs for the load balancer outbound connection usage.
    text: az aks update -g MyResourceGroup -n MyManagedCluster --load-balancer-managed-outbound-ip-count 2
  - name: Update a kubernetes cluster with standard SKU load balancer to use the provided public IPs for the load balancer outbound connection usage.
    text: az aks update -g MyResourceGroup -n MyManagedCluster --load-balancer-outbound-ips <ip-resource-id-1,ip-resource-id-2>
  - name: Create a kubernetes cluster with a standard SKU load balancer, with two outbound AKS managed IPs an idle flow timeout of 5 minutes and 8000 allocated ports per machine
    text: az aks update -g MyResourceGroup -n MyManagedCluster --load-balancer-managed-outbound-ip-count 2 --load-balancer-idle-timeout 5 --load-balancer-outbound-ports 8000
  - name: Update a kubernetes cluster with standard SKU load balancer to use the provided public IP prefixes for the load balancer outbound connection usage.
    text: az aks update -g MyResourceGroup -n MyManagedCluster --load-balancer-outbound-ip-prefixes <ip-prefix-resource-id-1,ip-prefix-resource-id-2>
  - name: Attach AKS cluster to ACR by name "acrName"
    text: az aks update -g MyResourceGroup -n MyManagedCluster --attach-acr acrName
  - name: Update a kubernetes cluster with authorized apiserver ip ranges.
    text: az aks update -g MyResourceGroup -n MyManagedCluster --api-server-authorized-ip-ranges 193.168.1.0/24,194.168.1.0/24
  - name: Disable authorized apiserver ip ranges feature for a kubernetes cluster.
    text: az aks update -g MyResourceGroup -n MyManagedCluster --api-server-authorized-ip-ranges ""
  - name: Restrict apiserver traffic in a kubernetes cluster to agentpool nodes.
    text: az aks update -g MyResourceGroup -n MyManagedCluster --api-server-authorized-ip-ranges 0.0.0.0/32
  - name: Update a AKS-managed AAD cluster with tenant ID or admin group object IDs.
    text: az aks update -g MyResourceGroup -n MyManagedCluster --aad-admin-group-object-ids <id-1,id-2> --aad-tenant-id <id>
  - name: Migrate a AKS AAD-Integrated cluster or a non-AAD cluster to a AKS-managed AAD cluster.
    text: az aks update -g MyResourceGroup -n MyManagedCluster --enable-aad --aad-admin-group-object-ids <id-1,id-2> --aad-tenant-id <id>
  - name: Enable Azure Hybrid User Benefits featture for a kubernetes cluster.
    text: az aks update -g MyResourceGroup -n MyManagedCluster --enable-ahub
  - name: Disable Azure Hybrid User Benefits featture for a kubernetes cluster.
    text: az aks update -g MyResourceGroup -n MyManagedCluster --disable-ahub
  - name: Update Windows password of a kubernetes cluster
    text: az aks update -g MyResourceGroup -n MyManagedCLuster --windows-admin-password "Repl@cePassw0rd12345678"
  - name: Update the cluster to use system assigned managed identity in control plane.
    text: az aks update -g MyResourceGroup -n MyManagedCluster --enable-managed-identity
  - name: Update the cluster to use user assigned managed identity in control plane.
    text: az aks update -g MyResourceGroup -n MyManagedCluster --enable-managed-identity --assign-identity <user_assigned_identity_resource_id>
  - name: Update a non managed AAD AKS cluster to use Azure RBAC
    text: az aks update -g MyResourceGroup -n MyManagedCluster --enable-aad --enable-azure-rbac
  - name: Update a managed AAD AKS cluster to use Azure RBAC
    text: az aks update -g MyResourceGroup -n MyManagedCluster --enable-azure-rbac
  - name: Disable Azure RBAC in a managed AAD AKS cluster
    text: az aks update -g MyResourceGroup -n MyManagedCluster --disable-azure-rbac
  - name: Update the tags of a kubernetes cluster
    text: az aks update -g MyResourceGroup -n MyManagedCLuster --tags "foo=bar" "baz=qux"
  - name: Update a kubernetes cluster with custom headers
    text: az aks update -g MyResourceGroup -n MyManagedCluster --aks-custom-headers WindowsContainerRuntime=containerd,AKSHTTPCustomFeatures=Microsoft.ContainerService/CustomNodeConfigPreview
  - name: Enable Windows gmsa for a kubernetes cluster with setting DNS server in the vnet used by the cluster.
    text: az aks update -g MyResourceGroup -n MyManagedCluster --enable-windows-gmsa
  - name: Enable Windows gmsa for a kubernetes cluster without setting DNS server in the vnet used by the cluster.
    text: az aks update -g MyResourceGroup -n MyManagedCluster --enable-windows-gmsa --gmsa-dns-server "10.240.0.4" --gmsa-root-domain-name "contoso.com"
"""

helps['aks delete'] = """
type: command
short-summary: Delete a managed Kubernetes cluster.
examples:
  - name: Delete a managed Kubernetes cluster. (autogenerated)
    text: az aks delete --name MyManagedCluster --resource-group MyResourceGroup
    crafted: true
"""

helps['aks disable-addons'] = """
type: command
short-summary: Disable Kubernetes addons.
parameters:
  - name: --addons -a
    type: string
    short-summary: Disable the Kubernetes addons in a comma-separated list.
examples:
  - name: Disable Kubernetes addons. (autogenerated)
    text: az aks disable-addons --addons virtual-node --name MyManagedCluster --resource-group MyResourceGroup
    crafted: true
"""

helps['aks enable-addons'] = """
type: command
short-summary: Enable Kubernetes addons.
long-summary: |-
    These addons are available:
        - http_application_routing : configure ingress with automatic public DNS name creation.
        - monitoring               : turn on Log Analytics monitoring. Requires "--workspace-resource-id".
                                     Requires "--enable_msi_auth_for_monitoring" for managed identity auth.
                                     If monitoring addon is enabled --no-wait argument will have no effect
        - virtual-node             : enable AKS Virtual Node. Requires --subnet-name to provide the name of an existing subnet for the Virtual Node to use.
        - azure-policy             : enable Azure policy. The Azure Policy add-on for AKS enables at-scale enforcements and safeguards on your clusters in a centralized, consistent manner.
                                     Learn more at aka.ms/aks/policy.
        - ingress-appgw            : enable Application Gateway Ingress Controller addon.
        - open-service-mesh        : enable Open Service Mesh addon.
        - azure-keyvault-secrets-provider : enable Azure Keyvault Secrets Provider addon.
parameters:
  - name: --addons -a
    type: string
    short-summary: Enable the Kubernetes addons in a comma-separated list.
  - name: --workspace-resource-id
    type: string
    short-summary: The resource ID of an existing Log Analytics Workspace to use for storing monitoring data.
  - name: --enable-msi-auth-for-monitoring
    type: bool
    short-summary: Enable Managed Identity Auth for Monitoring addon.
  - name: --appgw-name
    type: string
    short-summary: Name of the application gateway to create/use in the node resource group. Use with ingress-azure addon.
  - name: --appgw-subnet-cidr
    type: string
    short-summary: Subnet CIDR to use for a new subnet created to deploy the Application Gateway. Use with ingress-azure addon.
  - name: --appgw-id
    type: string
    short-summary: Resource Id of an existing Application Gateway to use with AGIC. Use with ingress-azure addon.
  - name: --appgw-subnet-id
    type: string
    short-summary: Resource Id of an existing Subnet used to deploy the Application Gateway. Use with ingress-azure addon.
  - name: --appgw-watch-namespace
    type: string
    short-summary: Specify the namespace, which AGIC should watch. This could be a single string value, or a comma-separated list of namespaces.
  - name: --enable-sgxquotehelper
    type: bool
    short-summary: Enable SGX quote helper for confcom addon.
  - name: --enable-secret-rotation
    type: bool
    short-summary: Enable secret rotation. Use with azure-keyvault-secrets-provider addon.
  - name: --rotation-poll-interval
    type: string
    short-summary: Set interval of rotation poll. Use with azure-keyvault-secrets-provider addon.
examples:
  - name: Enable Kubernetes addons. (autogenerated)
    text: az aks enable-addons --addons virtual-node --name MyManagedCluster --resource-group MyResourceGroup --subnet MySubnetName
    crafted: true
  - name: Enable ingress-appgw addon with subnet prefix.
    text: az aks enable-addons --name MyManagedCluster --resource-group MyResourceGroup --addons ingress-appgw --appgw-subnet-cidr 10.2.0.0/16 --appgw-name gateway
    crafted: true
  - name: Enable open-service-mesh addon.
    text: az aks enable-addons --name MyManagedCluster --resource-group MyResourceGroup --addons open-service-mesh
    crafted: true
"""

helps['aks get-credentials'] = """
type: command
short-summary: Get access credentials for a managed Kubernetes cluster.
long-summary: By default, the credentials are merged into the .kube/config file so kubectl can use them.  See -f parameter for details.
parameters:
  - name: --admin -a
    type: bool
    short-summary: "Get cluster administrator credentials.  Default: cluster user credentials."
    long-summary: "On clusters with Azure Active Directory integration, this bypasses normal Azure AD authentication and can be used if you're permanently blocked by not having access to a valid Azure AD group with access to your cluster. Requires 'Azure Kubernetes Service Cluster Admin' role."
  - name: --file -f
    type: string
    short-summary: Kubernetes configuration file to update. Use "-" to print YAML to stdout instead.
  - name: --overwrite-existing
    type: bool
    short-summary: Overwrite any existing cluster entry with the same name.
  - name: --output -o
    type: string
    long-summary: Credentials are always in YAML format, so this argument is effectively ignored.
  - name: --public-fqdn
    type: bool
    short-summary: Get private cluster credential with server address to be public fqdn.
  - name: --format
    type: string
    short-summary: Specify the format of the returned credential. Available values are ["exec", "azure"].
                  Only take effect when requesting clusterUser credential of AAD clusters.
examples:
  - name: Get access credentials for a managed Kubernetes cluster. (autogenerated)
    text: az aks get-credentials --name MyManagedCluster --resource-group MyResourceGroup
    crafted: true
"""

helps['aks get-upgrades'] = """
type: command
short-summary: Get the upgrade versions available for a managed Kubernetes cluster.
examples:
  - name: Get the upgrade versions available for a managed Kubernetes cluster
    text: az aks get-upgrades --name MyManagedCluster --resource-group MyResourceGroup
    crafted: true
"""

helps['aks get-versions'] = """
type: command
short-summary: Get the versions available for creating a managed Kubernetes cluster.
examples:
  - name: Get the versions available for creating a managed Kubernetes cluster
    text: az aks get-versions --location westus2
    crafted: true
"""

helps['aks install-cli'] = """
type: command
short-summary: Download and install kubectl, the Kubernetes command-line tool. Download and install kubelogin, a client-go credential (exec) plugin implementing azure authentication.
"""

helps['aks list'] = """
type: command
short-summary: List managed Kubernetes clusters.
"""

helps['aks nodepool'] = """
type: group
short-summary: Commands to manage node pools in Kubernetes kubernetes cluster.
"""

helps['aks nodepool add'] = """
type: command
short-summary: Add a node pool to the managed Kubernetes cluster.
parameters:
  - name: --node-vm-size -s
    type: string
    short-summary: Size of Virtual Machines to create as Kubernetes nodes.
  - name: --node-count -c
    type: int
    short-summary: Number of nodes in the Kubernetes agent pool. After creating a cluster, you can change the size of its node pool with `az aks scale`.
  - name: --kubernetes-version -k
    type: string
    short-summary: Version of Kubernetes to use for creating the cluster, such as "1.16.9".
    populator-commands:
      - "`az aks get-versions`"
  - name: --node-osdisk-size
    type: int
    short-summary: Size in GB of the OS disk for each node in the agent pool. Minimum 30 GB.
  - name: --node-osdisk-type
    type: string
    short-summary: OS disk type to be used for machines in a given agent pool. Defaults to 'Ephemeral' when possible in conjunction with VM size and OS disk size. May not be changed for this pool after creation. ('Ephemeral' or 'Managed')
  - name: --max-pods -m
    type: int
    short-summary: The maximum number of pods deployable to a node.
    long-summary: If not specified, defaults to 110, or 30 for advanced networking configurations.
  - name: --zones -z
    type: string array
    short-summary: Availability zones where agent nodes will be placed.
  - name: --enable-node-public-ip
    type: bool
    short-summary: Enable VMSS node public IP.
  - name: --node-public-ip-prefix-id
    type: string
    short-summary: Public IP prefix ID used to assign public IPs to VMSS nodes.
  - name: --vnet-subnet-id
    type: string
    short-summary: The ID of a subnet in an existing VNet into which to deploy the cluster.
  - name: --pod-subnet-id
    type: string
    short-summary: The ID of a subnet in an existing VNet into which to assign pods in the cluster (requires azure network-plugin).
  - name: --ppg
    type: string
    short-summary: The ID of a PPG.
  - name: --os-type
    type: string
    short-summary: The OS Type. Linux or Windows.
  - name: --os-sku
    type: string
    short-summary: The OS SKU of the agent node pool. Ubuntu or CBLMariner.
  - name: --enable-cluster-autoscaler -e
    type: bool
    short-summary: Enable cluster autoscaler.
  - name: --min-count
    type: int
    short-summary: Minimum nodes count used for autoscaler, when "--enable-cluster-autoscaler" specified. Please specify the value in the range of [1, 1000]
  - name: --max-count
    type: int
    short-summary: Maximum nodes count used for autoscaler, when "--enable-cluster-autoscaler" specified. Please specify the value in the range of [1, 1000]
  - name: --scale-down-mode
    type: string
    short-summary: "Describe how VMs are added to or removed from nodepools."
  - name: --node-taints
    type: string
    short-summary: The node taints for the node pool.
  - name: --labels
    type: string
    short-summary: The node labels for the node pool. See https://aka.ms/node-labels for syntax of labels.
  - name: --mode
    type: string
    short-summary: The mode for a node pool which defines a node pool's primary function. If set as "System", AKS prefers system pods scheduling to node pools with mode `System`. Learn more at https://aka.ms/aks/nodepool/mode.
  - name: --priority
    type: string
    short-summary: The priority of the node pool.
  - name: --eviction-policy
    type: string
    short-summary: The eviction policy of the Spot node pool. It can only be set when --priority is Spot.
  - name: --spot-max-price
    type: float
    short-summary: It can only be set when --priority is Spot. Specify the maximum price you are willing to pay in US Dollars. Possible values are any decimal value greater than zero or -1 which indicates default price to be up-to on-demand. It can only include up to 5 decimal places.
  - name: --max-surge
    type: string
    short-summary: Extra nodes used to speed upgrade. When specified, it represents the number or percent used, eg. 5 or 33%
  - name: --enable-encryption-at-host
    type: bool
    short-summary: Enable EncryptionAtHost, default value is false.
  - name: --enable-ultra-ssd
    type: bool
    short-summary: Enable UltraSSD, default value is false.
  - name: --enable-fips-image
    type: bool
    short-summary: Use FIPS-enabled OS on agent nodes.
  - name: --snapshot-id
    type: string
    short-summary: The source snapshot id used to create this nodepool.
  - name: --aks-custom-headers
    type: string
    short-summary: Comma-separated key-value pairs to specify custom headers.
  - name: --kubelet-config
    type: string
    short-summary: Path to JSON file containing Kubelet configurations for agent nodes. https://aka.ms/aks/custom-node-config
  - name: --linux-os-config
    type: string
    short-summary: Path to JSON file containing OS configurations for Linux agent nodes. https://aka.ms/aks/custom-node-config
examples:
  - name: Create a nodepool in an existing AKS cluster with ephemeral os enabled.
    text: az aks nodepool add -g MyResourceGroup -n nodepool1 --cluster-name MyManagedCluster --node-osdisk-type Ephemeral --node-osdisk-size 48
  - name: Create a nodepool with EncryptionAtHost enabled.
    text: az aks nodepool add -g MyResourceGroup -n nodepool1 --cluster-name MyManagedCluster --enable-encryption-at-host
  - name: Create a nodepool with UltraSSD enabled.
    text: az aks nodepool add -g MyResourceGroup -n nodepool1 --cluster-name MyManagedCluster --enable-ultra-ssd
  - name: Create a nodepool cluster with a specific OS SKU
    text: az aks nodepool add -g MyResourceGroup -n nodepool1 --cluster-name MyManagedCluster --os-sku Ubuntu
  - name: Create a nodepool with FIPS-enabled OS
    text: az aks nodepool add -g MyResourceGroup -n nodepool1 --cluster-name MyManagedCluster --enable-fips-image
  - name: create a kubernetes cluster with a snapshot id.
    text: az aks nodepool add -g MyResourceGroup -n nodepool1 --cluster-name MyManagedCluster --kubernetes-version 1.20.9 --snapshot-id "/subscriptions/00000/resourceGroups/AnotherResourceGroup/providers/Microsoft.ContainerService/snapshots/mysnapshot1"
"""

helps['aks nodepool delete'] = """
type: command
short-summary: Delete the agent pool in the managed Kubernetes cluster.
"""

helps['aks nodepool get-upgrades'] = """
type: command
short-summary: Get the available upgrade versions for an agent pool of the managed Kubernetes cluster.
examples:
  - name: Get the available upgrade versions for an agent pool of the managed Kubernetes cluster.
    text: az aks nodepool get-upgrades --resource-group MyResourceGroup --cluster-name MyManagedCluster --nodepool-name MyNodePool
    crafted: true
parameters:
  - name: --nodepool-name
    type: string
    short-summary: name of the node pool.
"""

helps['aks nodepool list'] = """
type: command
short-summary: List node pools in the managed Kubernetes cluster. To get list of nodes in the cluster run `kubectl get nodes` command.
"""

helps['aks nodepool scale'] = """
type: command
short-summary: Scale the node pool in a managed Kubernetes cluster.
parameters:
  - name: --node-count -c
    type: int
    short-summary: Number of nodes in the Kubernetes node pool.
"""

helps['aks nodepool show'] = """
type: command
short-summary: Show the details for a node pool in the managed Kubernetes cluster.
"""

helps['aks nodepool update'] = """
type: command
short-summary: Update a node pool to enable/disable cluster-autoscaler or change min-count or max-count
parameters:
  - name: --enable-cluster-autoscaler -e
    type: bool
    short-summary: Enable cluster autoscaler.
  - name: --disable-cluster-autoscaler -d
    type: bool
    short-summary: Disable cluster autoscaler.
  - name: --update-cluster-autoscaler -u
    type: bool
    short-summary: Update min-count or max-count for cluster autoscaler.
  - name: --min-count
    type: int
    short-summary: Minimum nodes count used for autoscaler, when "--enable-cluster-autoscaler" specified. Please specify the value in the range of [1, 1000]
  - name: --max-count
    type: int
    short-summary: Maximum nodes count used for autoscaler, when "--enable-cluster-autoscaler" specified. Please specify the value in the range of [1, 1000]
  - name: --scale-down-mode
    type: string
    short-summary: "Describe how VMs are added to or removed from nodepools."
  - name: --mode
    type: string
    short-summary: The mode for a node pool which defines a node pool's primary function. If set as "System", AKS prefers system pods scheduling to node pools with mode `System`. Learn more at https://aka.ms/aks/nodepool/mode.
  - name: --max-surge
    type: string
    short-summary: Extra nodes used to speed upgrade. When specified, it represents the number or percent used, eg. 5 or 33%
  - name: --node-taints
    type: string
    short-summary: The node taints for the node pool.
  - name: --labels
    type: string
    short-summary: The node labels for the node pool. See https://aka.ms/node-labels for syntax of labels.
  - name: --aks-custom-headers
    type: string
    short-summary: Comma-separated key-value pairs to specify custom headers.
examples:
  - name: Enable cluster-autoscaler within node count range [1,5]
    text: az aks nodepool update --enable-cluster-autoscaler --min-count 1 --max-count 5 -g MyResourceGroup -n nodepool1 --cluster-name MyManagedCluster
  - name: Disable cluster-autoscaler for an existing cluster
    text: az aks nodepool update --disable-cluster-autoscaler -g MyResourceGroup -n nodepool1 --cluster-name MyManagedCluster
  - name: Update min-count or max-count for cluster autoscaler.
    text: az aks nodepool update --update-cluster-autoscaler --min-count 1 --max-count 10 -g MyResourceGroup -n nodepool1 --cluster-name MyManagedCluster
"""

helps['aks nodepool upgrade'] = """
type: command
short-summary: Upgrade the node pool in a managed Kubernetes cluster.
parameters:
  - name: --kubernetes-version -k
    type: string
    short-summary: Version of Kubernetes to upgrade the node pool to, such as "1.16.9".
  - name: --node-image-only
    type: bool
    short-summary: Only upgrade agent pool's node image.
  - name: --max-surge
    type: string
    short-summary: Extra nodes used to speed upgrade. When specified, it represents the number or percent used, eg. 5 or 33% (mutually exclusive with "--node-image-only". See "az aks nodepool update --max-surge" to update max surge before upgrading with "--node-image-only")
  - name: --snapshot-id
    type: string
    short-summary: The source snapshot id used to upgrade this nodepool.
  - name: --aks-custom-headers
    type: string
    short-summary: Comma-separated key-value pairs to specify custom headers.
"""

helps['aks remove-dev-spaces'] = """
type: command
short-summary: Remove Azure Dev Spaces from a managed Kubernetes cluster.
examples:
  - name: Remove Azure Dev Spaces from a managed Kubernetes cluster.
    text: |-
        az aks remove-dev-spaces -g my-aks-group -n my-aks
  - name: Remove Azure Dev Spaces from a managed Kubernetes cluster without prompting.
    text: |-
        az aks remove-dev-spaces -g my-aks-group -n my-aks --yes
"""

helps['aks scale'] = """
type: command
short-summary: Scale the node pool in a managed Kubernetes cluster.
parameters:
  - name: --node-count -c
    type: int
    short-summary: Number of nodes in the Kubernetes node pool.
examples:
  - name: Scale the node pool in a managed Kubernetes cluster. (autogenerated)
    text: az aks scale --name MyManagedCluster --node-count 3 --resource-group MyResourceGroup
    crafted: true
"""

helps['aks show'] = """
type: command
short-summary: Show the details for a managed Kubernetes cluster.
examples:
  - name: Show the details for a managed Kubernetes cluster
    text: az aks show --name MyManagedCluster --resource-group MyResourceGroup
    crafted: true
"""

helps['aks update-credentials'] = """
type: command
short-summary: Update credentials for a managed Kubernetes cluster, like service principal.
parameters:
  - name: --reset-service-principal
    type: bool
    short-summary: Reset service principal for a managed cluster.
  - name: --service-principal
    type: string
    short-summary: Service principal used for authentication to Azure APIs. This argument is required if `--reset-service-principal` is specified.
  - name: --client-secret
    type: string
    short-summary: Secret associated with the service principal. This argument is required if `--service-principal` is specified.
  - name: --reset-aad
    type: string
    short-summary: Reset Azure Active Directory configuration for a managed cluster.
  - name: --aad-server-app-id
    type: string
    short-summary: The ID of an Azure Active Directory server application. This argument is required if `--reset-aad` is specified.
  - name: --aad-server-app-secret
    type: string
    short-summary: The secret of an Azure Active Directory server application. This argument is required if `--reset-aad` is specified.
  - name: --aad-client-app-id
    type: string
    short-summary: The ID of an Azure Active Directory client application. This argument is required if `--reset-aad` is specified.
  - name: --aad-tenant-id
    type: string
    short-summary: Tenant ID associated with Azure Active Directory.

examples:
  - name: Update an existing Kubernetes cluster with new service principal.
    text: az aks update-credentials -g MyResourceGroup -n MyManagedCluster --reset-service-principal --service-principal MyNewServicePrincipalID --client-secret MyNewServicePrincipalSecret
  - name: Update an existing Azure Active Directory Kubernetes cluster with new server app secret key.
    text: az aks update-credentials -g MyResourceGroup -n MyManagedCluster --reset-aad --aad-server-app-id MyExistingAADServerAppID --aad-server-app-secret MyNewAADServerAppSecret --aad-client-app-id MyExistingAADClientAppID --aad-tenant-id MyAADTenantID
"""

helps['aks upgrade'] = """
type: command
short-summary: Upgrade a managed Kubernetes cluster to a newer version.
long-summary: "Kubernetes will be unavailable during cluster upgrades."
parameters:
  - name: --kubernetes-version -k
    type: string
    short-summary: Version of Kubernetes to upgrade the cluster to, such as "1.16.9".
    populator-commands:
      - "`az aks get-upgrades`"
  - name: --control-plane-only
    type: bool
    short-summary: Upgrade the cluster control plane only. If not specified, both control plane AND all node pools will be upgraded.
  - name: --node-image-only
    type: bool
    short-summary: Only upgrade node image for agent pools.
examples:
  - name: Upgrade a managed Kubernetes cluster to a newer version. (autogenerated)
    text: az aks upgrade --kubernetes-version 1.12.6 --name MyManagedCluster --resource-group MyResourceGroup
    crafted: true
"""

helps['aks use-dev-spaces'] = """
type: command
short-summary: Use Azure Dev Spaces with a managed Kubernetes cluster.
parameters:
  - name: --update
    type: bool
    short-summary: Update to the latest Azure Dev Spaces client components.
  - name: --space -s
    type: string
    short-summary: Name of the new or existing dev space to select. Defaults to an interactive selection experience.
  - name: --endpoint -e
    type: string
    short-summary: The endpoint type to be used for a Azure Dev Spaces controller. See https://aka.ms/azds-networking for more information.
examples:
  - name: Use Azure Dev Spaces with a managed Kubernetes cluster, interactively selecting a dev space.
    text: |-
        az aks use-dev-spaces -g my-aks-group -n my-aks
  - name: Use Azure Dev Spaces with a managed Kubernetes cluster, updating to the latest Azure Dev Spaces \
            client components and selecting a new or existing dev space 'my-space'.
    text: |-
        az aks use-dev-spaces -g my-aks-group -n my-aks --update --space my-space
  - name: Use Azure Dev Spaces with a managed Kubernetes cluster, selecting a new or existing dev space \
            'develop/my-space' without prompting for confirmation.
    text: |-
        az aks use-dev-spaces -g my-aks-group -n my-aks -s develop/my-space -y
  - name: Use Azure Dev Spaces with a managed Kubernetes cluster with a private endpoint.
    text: |-
        az aks use-dev-spaces -g my-aks-group -n my-aks -e private
"""

helps['aks wait'] = """
type: command
short-summary: Wait for a managed Kubernetes cluster to reach a desired state.
long-summary: If an operation on a cluster was interrupted or was started with `--no-wait`, use this command to wait for it to complete.
examples:
  - name: Wait for a cluster to be upgraded, polling every minute for up to thirty minutes.
    text: |-
        az aks wait -g MyResourceGroup -n MyManagedCluster --updated --interval 60 --timeout 1800
  - name: Wait for a managed Kubernetes cluster to reach a desired state (autogenerated)
    text: az aks wait --created --interval 60 --name MyManagedCluster --resource-group MyResourceGroup --timeout 1800
    crafted: true
"""

helps['aks nodepool wait'] = """
type: command
short-summary: Wait for a node pool to reach a desired state.
long-summary: If an operation on a node pool was interrupted or was started with `--no-wait`, use this command to wait for it to complete.
examples:
  - name: Wait for a node pool to reach a desired state, polling every minute for up to thirty minutes.
    text: |-
        az aks nodepool wait --created --interval 60 --name MyManagedCluster --resource-group MyResourceGroup --nodepool-name MyNodePool --timeout 1800
"""

helps['aks nodepool snapshot wait'] = """
type: command
short-summary: Wait for a nodepool snapshot to reach a desired state.
long-summary: If an operation on a nodepool snapshot was interrupted or was started with `--no-wait`, use this command to wait for it to complete.
examples:
  - name: Wait for a node pool to reach a desired state, polling every minute for up to thirty minutes.
    text: |-
        az aks nodepool snapshot wait --created --interval 60 --name MySnapshot --resource-group MyResourceGroup --timeout 1800
"""

helps['aks rotate-certs'] = """
    type: command
    short-summary: Rotate certificates and keys on a managed Kubernetes cluster
    long-summary: Kubernetes will be unavailable during cluster certificate rotation.
"""

helps['aks command'] = """
    type: group
    short-summary: See detail usage in 'az aks command invoke', 'az aks command result'.
"""

helps['aks command invoke'] = """
    type: command
    short-summary: Run a shell command (with kubectl, helm) on your aks cluster, support attaching files as well.
    parameters:
        - name: --command -c
          type: string
          short-summary: Command or shell script you want to run.
        - name: --file -f
          type: string
          short-summary: Files to be used by the command, use '.' to attach the current folder.
"""

helps['aks command result'] = """
    type: command
    short-summary: Fetch result from previously triggered 'aks command invoke'.
    parameters:
        - name: --command-id -i
          type: string
          short-summary: commandId returned from 'aks command invoke'.
"""

helps['aks snapshot'] = """
    type: group
    short-summary: Commands to manage nodepool snapshots.
"""

helps['aks snapshot show'] = """
    type: command
    short-summary: Show the details of a nodepool snapshot.
"""

helps['aks snapshot list'] = """
    type: command
    short-summary: List nodepool snapshots.
"""

helps['aks snapshot create'] = """
    type: command
    short-summary: Create a nodepool snapshot.
    parameters:
        - name: --nodepool-id
          type: string
          short-summary: The source nodepool id from which to create this snapshot.
        - name: --tags
          type: string
          short-summary: The tags of the snapshot.
        - name: --aks-custom-headers
          type: string
          short-summary: Send custom headers. When specified, format should be Key1=Value1,Key2=Value2
"""

helps['aks snapshot delete'] = """
    type: command
    short-summary: Delete a nodepool snapshot.
"""

helps['aks snapshot wait'] = """
type: command
short-summary: Wait for a nodepool snapshot to reach a desired state.
long-summary: If an operation on a nodepool snapshot was interrupted or was started with `--no-wait`, use this command to wait for it to complete.
"""

helps['aks nodepool snapshot'] = """
    type: group
    short-summary: Commands to manage nodepool snapshots.
"""

helps['aks nodepool snapshot show'] = """
    type: command
    short-summary: Show the details of a nodepool snapshot.
"""

helps['aks nodepool snapshot list'] = """
    type: command
    short-summary: List nodepool snapshots.
"""

helps['aks nodepool snapshot create'] = """
    type: command
    short-summary: Create a nodepool snapshot.
    parameters:
        - name: --nodepool-id
          type: string
          short-summary: The source nodepool id from which to create this snapshot.
        - name: --tags
          type: string
          short-summary: The tags of the snapshot.
        - name: --aks-custom-headers
          type: string
          short-summary: Send custom headers. When specified, format should be Key1=Value1,Key2=Value2
    examples:
        - name: Create a nodepool snapshot.
          text: az aks nodepool snapshot create -g MyResourceGroup -n snapshot1 --nodepool-id "/subscriptions/00000/resourceGroups/AnotherResourceGroup/providers/Microsoft.ContainerService/managedClusters/akscluster1/agentPools/nodepool1"
        - name: Create a nodepool snapshot with custom tags.
          text: az aks nodepool snapshot create -g MyResourceGroup -n snapshot1 --nodepool-id "/subscriptions/00000/resourceGroups/AnotherResourceGroup/providers/Microsoft.ContainerService/managedClusters/akscluster1/agentPools/nodepool1" --tags "foo=bar" "key1=val1"
"""

helps['aks nodepool snapshot delete'] = """
    type: command
    short-summary: Delete a nodepool snapshot.
"""

helps['openshift'] = """
type: group
short-summary: Manage Azure Red Hat OpenShift 3.11 clusters.
long-summary: The az openshift command is deprecated and has been replaced by az aro for ARO 4 clusters. See http://aka.ms/aro/4 for information on switching to ARO 4.
"""

helps['openshift create'] = """
type: command
short-summary: Create a new Azure Red Hat OpenShift 3.11 cluster.
long-summary: Support for the creation of ARO 3.11 clusters ends 30 Nov 2020. Please see aka.ms/aro/4 for information on switching to ARO 4.
parameters:
  - name: --compute-vm-size -s
    type: string
    short-summary: Size of Virtual Machines to create as OpenShift nodes.
  - name: --compute-count -c
    type: int
    short-summary: Number of nodes in the OpenShift node pool.
  - name: --aad-client-app-id
    type: string
    short-summary: The ID of an Azure Active Directory client application. If not specified, a new Azure Active Directory client is created.
  - name: --aad-client-app-secret
    type: string
    short-summary: The secret of an Azure Active Directory client application.
  - name: --aad-tenant-id
    type: string
    short-summary: The ID of an Azure Active Directory tenant.
  - name: --vnet-peer
    type: string
    short-summary: The ID or the name of a subnet in an existing VNet into which to peer the cluster.
  - name: --vnet-prefix
    type: string
    short-summary: The CIDR used on the VNet into which to deploy the cluster.
  - name: --subnet-prefix
    type: string
    short-summary: The CIDR used on the Subnet into which to deploy the cluster.
  - name: --customer-admin-group-id
    type: string
    short-summary: The Object ID of an Azure Active Directory Group that memberships will get synced into the OpenShift group "osa-customer-admins". If not specified, no cluster admin access will be granted.
  - name: --workspace-id
    type: string
    short-summary: The resource id of an existing Log Analytics Workspace to use for storing monitoring data.


examples:
  - name: Create an OpenShift cluster and auto create an AAD Client
    text: az openshift create -g MyResourceGroup -n MyManagedCluster
  - name: Create an OpenShift cluster and auto create an AAD Client and setup cluster admin group
    text: az openshift create -g MyResourceGroup -n MyManagedCluster --customer-admin-group-id {GROUP_ID}
  - name: Create an OpenShift cluster with 5 compute nodes and a custom AAD Client.
    text: az openshift create -g MyResourceGroup -n MyManagedCluster --aad-client-app-id {APP_ID} --aad-client-app-secret {APP_SECRET} --aad-tenant-id {TENANT_ID} --compute-count 5
  - name: Create an Openshift cluster using a custom vnet
    text: az openshift create -g MyResourceGroup -n MyManagedCluster --vnet-peer "/subscriptions/0000000-0000-0000-0000-000000000000/resourceGroups/openshift-vnet/providers/Microsoft.Network/virtualNetworks/test"
  - name: Create an Openshift cluster with Log Analytics monitoring enabled
    text: az openshift create -g MyResourceGroup -n MyManagedCluster --workspace-id "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MyResourceGroup/providers/Microsoft.OperationalInsights/workspaces/{workspace-id}"
"""

helps['openshift delete'] = """
type: command
short-summary: Delete an Azure Red Hat OpenShift 3.11 cluster.
long-summary: The az openshift command is deprecated and has been replaced by az aro for ARO 4 clusters. See http://aka.ms/aro/4 for information on switching to ARO 4.
examples:
  - name: Delete an Azure Red Hat OpenShift 3.11 cluster.
    text: az openshift delete --name MyManagedOpenShiftCluster --resource-group MyResourceGroup
    crafted: true
"""

helps['openshift list'] = """
type: command
short-summary: List Azure Red Hat OpenShift 3.11 clusters.
long-summary: The az openshift command is deprecated and has been replaced by az aro for ARO 4 clusters. See http://aka.ms/aro/4 for information on switching to ARO 4.
"""

helps['openshift scale'] = """
type: command
short-summary: Scale the compute pool in an Azure Red Hat OpenShift 3.11 cluster.
long-summary: The az openshift command is deprecated and has been replaced by az aro for ARO 4 clusters. See http://aka.ms/aro/4 for information on switching to ARO 4.
parameters:
  - name: --compute-count -c
    type: int
    short-summary: Number of nodes in the OpenShift compute pool.
examples:
  - name: Scale the compute pool in an Azure Red Hat OpenShift 3.11 cluster.
    text: az openshift scale --compute-count 5 --name MyManagedOpenShiftCluster --resource-group MyResourceGroup
    crafted: true
"""

helps['openshift show'] = """
type: command
short-summary: Show the details for an Azure Red Hat OpenShift 3.11 cluster.
long-summary: Support for existing ARO 3.11 clusters ends June 2022. Please see aka.ms/aro/4 for information on switching to ARO 4.
examples:
  - name: Show the details for an Azure Red Hat OpenShift 3.11 cluster.
    text: az openshift show --name MyManagedOpenShiftCluster --resource-group MyResourceGroup
    crafted: true
"""

helps['openshift wait'] = """
type: command
short-summary: Wait for an Azure Red Hat OpenShift 3.11 cluster to reach a desired state.
long-summary: The az openshift command is deprecated and has been replaced by az aro for ARO 4 clusters. See http://aka.ms/aro/4 for information on switching to ARO 4.
examples:
  - name: Wait for a cluster to be upgraded, polling every minute for up to thirty minutes.
    text: |-
        az openshift wait -g MyResourceGroup -n MyManagedCluster --updated --interval 60 --timeout 1800
"""

helps['openshift monitor'] = """
type: group
short-summary: Commands to manage Log Analytics monitoring in an ARO 3.11 cluster.
long-summary: The az openshift command is deprecated and has been replaced by az aro for ARO 4 clusters. See http://aka.ms/aro/4 for information on switching to ARO 4.
"""

helps['openshift monitor enable'] = """
type: command
short-summary: Enable Log Analytics monitoring in an ARO 3.11 cluster.
long-summary: The az openshift command is deprecated and has been replaced by az aro for ARO 4 clusters. See http://aka.ms/aro/4 for information on switching to ARO 4.
examples:
  - name: Enable Log Analytics monitoring.
    text: |-
        az openshift monitor enable -g MyResourceGroup -n MyManagedCluster --workspace-id "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MyResourceGroup/providers/Microsoft.OperationalInsights/workspaces/{workspace-id}"
"""

helps['openshift monitor disable'] = """
type: command
short-summary: Disable Log Analytics monitoring in an ARO 3.11 cluster.
long-summary: The az openshift command is deprecated and has been replaced by az aro for ARO 4 clusters. See http://aka.ms/aro/4 for information on switching to ARO 4.
examples:
  - name: Disable Log Analytics monitoring.
    text: |-
        az openshift monitor disable -g MyResourceGroup -n MyManagedCluster
"""
