# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "network traffic-manager endpoint show-geographic-hierarchy",
)
class ShowGeographicHierarchy(AAZCommand):
    """Get the default geographic hierarchy used by the geographic traffic routing method.

    :example: Get the default geographic hierarchy used by the geographic traffic routing method.
        az network traffic-manager endpoint show-geographic-hierarchy
    """

    _aaz_info = {
        "version": "2018-08-01",
        "resources": [
            ["mgmt-plane", "/providers/microsoft.network/trafficmanagergeographichierarchies/default", "2018-08-01"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    def _execute_operations(self):
        self.GeographicHierarchiesGetDefault(ctx=self.ctx)()

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class GeographicHierarchiesGetDefault(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/providers/Microsoft.Network/trafficManagerGeographicHierarchies/default",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2018-08-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.id = AAZStrType()
            _schema_on_200.name = AAZStrType()
            _schema_on_200.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _schema_on_200.type = AAZStrType()

            properties = cls._schema_on_200.properties
            properties.geographic_hierarchy = AAZObjectType(
                serialized_name="geographicHierarchy",
            )
            _build_schema_region_read(properties.geographic_hierarchy)

            return cls._schema_on_200


_schema_region_read = None


def _build_schema_region_read(_schema):
    global _schema_region_read
    if _schema_region_read is not None:
        _schema.code = _schema_region_read.code
        _schema.name = _schema_region_read.name
        _schema.regions = _schema_region_read.regions
        return

    _schema_region_read = AAZObjectType()

    region_read = _schema_region_read
    region_read.code = AAZStrType()
    region_read.name = AAZStrType()
    region_read.regions = AAZListType()

    regions = _schema_region_read.regions
    regions.Element = AAZObjectType()
    _build_schema_region_read(regions.Element)

    _schema.code = _schema_region_read.code
    _schema.name = _schema_region_read.name
    _schema.regions = _schema_region_read.regions


__all__ = ["ShowGeographicHierarchy"]
