# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "compute-fleet create",
    is_preview=True,
)
class Create(AAZCommand):
    """Create an Azure Compute Fleet

    Create an Azure Compute Fleet

    :example: Fleets_CreateOrUpdate
        az azure-fleet create --resource-group rgazurefleet --fleet-name testFleet --spot-priority-profile "{capacity:20,min-capacity:10,max-price-per-vm:0.00865,eviction-policy:Delete,allocation-strategy:PriceCapacityOptimized,maintain:True}" --regular-priority-profile "{capacity:20,min-capacity:10,allocation-strategy:LowestPrice}" --vm-sizes-profile "[{name:Standard_d1_v2,rank:19225}]" --compute-profile "{base-virtual-machine-profile:{osProfile:{computerNamePrefix:o,adminUsername:nrgzqciiaaxjrqldbmjbqkyhntp,adminPassword:adfbrdxpv,customData:xjjib,windowsConfiguration:{provisionVMAgent:True,enableAutomaticUpdates:True,timeZone:hlyjiqcfksgrpjrct,additionalUnattendContent:[{passName:OobeSystem,componentName:Microsoft-Windows-Shell-Setup,settingName:AutoLogon,content:bubmqbxjkj}],patchSettings:{patchMode:Manual,enableHotpatching:True,assessmentMode:ImageDefault,automaticByPlatformSettings:{rebootSetting:Unknown,bypassPlatformSafetyChecksOnUserSchedule:True}},winRM:{listeners:[{protocol:Https,certificateUrl:'https://myVaultName.vault.azure.net/secrets/myCertName'}]},enableVMAgentPlatformUpdates:True},linuxConfiguration:{disablePasswordAuthentication:True,ssh:{publicKeys:[{path:kmqz,keyData:kivgsubusvpprwqaqpjcmhsv}]},provisionVMAgent:True,patchSettings:{patchMode:ImageDefault,assessmentMode:ImageDefault,automaticByPlatformSettings:{rebootSetting:Unknown,bypassPlatformSafetyChecksOnUserSchedule:True}},enableVMAgentPlatformUpdates:True},secrets:[{sourceVault:{id:'/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}'},vaultCertificates:[{certificateUrl:'https://myVaultName.vault.azure.net/secrets/myCertName',certificateStore:nlxrwavpzhueffxsshlun}]}],allowExtensionOperations:True,requireGuestProvisionSignal:True},storageProfile:{imageReference:{publisher:mqxgwbiyjzmxavhbkd,offer:isxgumkarlkomp,sku:eojmppqcrnpmxirtp,version:wvpcqefgtmqdgltiuz,sharedGalleryImageId:kmkgihoxwlawuuhcinfirktdwkmx,communityGalleryImageId:vlqe,id:'/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageName}/versions/{versionName}'},osDisk:{name:wfttw,caching:None,writeAcceleratorEnabled:True,createOption:FromImage,diffDiskSettings:{option:Local,placement:CacheDisk},diskSizeGB:14,osType:Windows,image:{uri:'https://myStorageAccountName.blob.core.windows.net/myContainerName/myVhdName.vhd'},vhdContainers:[tkzcwddtinkfpnfklatw],managedDisk:{storageAccountType:Standard_LRS,diskEncryptionSet:{id:'/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{diskEncryptionSetName}'},securityProfile:{securityEncryptionType:VMGuestStateOnly,diskEncryptionSet:{id:'/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{diskEncryptionSetName}'}}},deleteOption:Delete},dataDisks:[{name:eogiykmdmeikswxmigjws,lun:14,caching:None,writeAcceleratorEnabled:True,createOption:FromImage,diskSizeGB:6,managedDisk:{storageAccountType:Standard_LRS,diskEncryptionSet:{id:'/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{diskEncryptionSetName}'},securityProfile:{securityEncryptionType:VMGuestStateOnly,diskEncryptionSet:{id:'/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{diskEncryptionSetName}'}}},diskIOPSReadWrite:27,diskMBpsReadWrite:2,deleteOption:Delete}],diskControllerType:uzb},networkProfile:{healthProbe:{id:'/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}'},networkInterfaceConfigurations:[{name:i,properties:{primary:True,enableAcceleratedNetworking:True,disableTcpStateTracking:True,enableFpga:True,networkSecurityGroup:{id:'/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityGroups/{networkSecurityGroupName}'},dnsSettings:{dnsServers:[nxmmfolhclsesu]},ipConfigurations:[{name:oezqhkidfhyywlfzwuotilrpbqnjg,properties:{subnet:{id:'/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}'},primary:True,publicIPAddressConfiguration:{name:fvpqf,properties:{idleTimeoutInMinutes:9,dnsSettings:{domainNameLabel:ukrddzvmorpmfsczjwtbvp,domainNameLabelScope:TenantReuse},ipTags:[{ipTagType:sddgsoemnzgqizale,tag:wufmhrjsakbiaetyara}],publicIPPrefix:{id:'/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}'},publicIPAddressVersion:IPv4,deleteOption:Delete},sku:{name:Basic,tier:Regional}},privateIPAddressVersion:IPv4,applicationGatewayBackendAddressPools:[{id:'/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}/backendAddressPools/{backendAddressPoolName}'}],applicationSecurityGroups:[{id:'/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationSecurityGroups/{applicationSecurityGroupName}'}],loadBalancerBackendAddressPools:[{id:'/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/backendAddressPools/{backendAddressPoolName}'}],loadBalancerInboundNatPools:[{id:'/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/inboundNatPools/{inboundNatPoolName}'}]}}],enableIPForwarding:True,deleteOption:Delete,auxiliaryMode:None,auxiliarySku:None}}],networkApiVersion:2020-11-01},securityProfile:{uefiSettings:{secureBootEnabled:True,vTpmEnabled:True},encryptionAtHost:True,securityType:TrustedLaunch,encryptionIdentity:{userAssignedIdentityResourceId:'/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{userAssignedIdentityName}'},proxyAgentSettings:{enabled:True,mode:Audit,keyIncarnationId:20}},diagnosticsProfile:{bootDiagnostics:{enabled:True,storageUri:'http://myStorageAccountName.blob.core.windows.net'}},extensionProfile:{extensions:[{name:bndxuxx,properties:{forceUpdateTag:yhgxw,publisher:kpxtirxjfprhs,type:pgjilctjjwaa,typeHandlerVersion:zevivcoilxmbwlrihhhibq,autoUpgradeMinorVersion:True,enableAutomaticUpgrade:True,settings:{},protectedSettings:{},provisionAfterExtensions:[nftzosroolbcwmpupujzqwqe],suppressFailures:True,protectedSettingsFromKeyVault:{secretUrl:'https://myvaultName.vault.azure.net/secrets/secret/mySecretName',sourceVault:{id:'/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}'}}}}],extensionsTimeBudget:mbhjahtdygwgyszdwjtvlvtgchdwil},licenseType:v,scheduledEventsProfile:{terminateNotificationProfile:{notBeforeTimeout:iljppmmw,enable:True},osImageNotificationProfile:{notBeforeTimeout:olbpadmevekyczfokodtfprxti,enable:True}},userData:s,capacityReservation:{capacityReservationGroup:{id:'/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/capacityReservationGroups/{capacityReservationGroupName}'}},applicationProfile:{galleryApplications:[{tags:eyrqjbib,order:5,packageReferenceId:'/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{applicationName}/versions/{versionName}',configurationReference:ulztmiavpojpbpbddgnuuiimxcpau,treatFailureAsDeploymentFailure:True,enableAutomaticUpgrade:True}]},hardwareProfile:{vmSizeProperties:{vCPUsAvailable:16,vCPUsPerCore:23}},serviceArtifactReference:{id:'/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/serviceArtifacts/{serviceArtifactsName}/vmArtifactsProfiles/{vmArtifactsProfileName}'},securityPostureReference:{id:'/CommunityGalleries/{communityGalleryName}/securityPostures/{securityPostureName}/versions/{major.minor.patch}|{major.*}|latest',excludeExtensions:['{securityPostureVMExtensionName}'],isOverridable:True}},compute-api-version:2023-07-01,platform-fault-domain-count:1}" --zones "[zone1,zone2]" --identity "{type:UserAssigned,user-assigned-identities:{key9851:{}}}" --tags "{key3518:luvrnuvsgdpbuofdskkcoqhfh}" --location westus --plan "{name:jwgrcrnrtfoxn,publisher:iozjbiqqckqm,product:cgopbyvdyqikahwyxfpzwaqk,promotion-code:naglezezplcaruqogtxnuizslqnnbr,version:wa}"
    """

    _aaz_info = {
        "version": "2024-11-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.azurefleet/fleets/{}", "2024-11-01"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.fleet_name = AAZStrArg(
            options=["-n", "--name", "--fleet-name"],
            help="The name of the Compute Fleet",
            required=True,
            fmt=AAZStrArgFormat(
                pattern="^[^_\\W][\\w\\-._]{0,79}(?<![-.])$",
            ),
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )

        # define Arg Group "Properties"

        _args_schema = cls._args_schema
        _args_schema.additional_locations_profile = AAZObjectArg(
            options=["--alp", "--additional-locations-profile"],
            arg_group="Properties",
            help="Represents the configuration for additional locations where Fleet resources may be deployed.",
        )
        _args_schema.compute_profile = AAZObjectArg(
            options=["--cp", "--compute-profile"],
            arg_group="Properties",
            help="Compute Profile to use for running user's workloads.",
        )
        _args_schema.regular_priority_profile = AAZObjectArg(
            options=["--rpp", "--regular-priority-profile"],
            arg_group="Properties",
            help="Configuration Options for Regular instances in Compute Fleet.",
        )
        _args_schema.spot_priority_profile = AAZObjectArg(
            options=["--spp", "--spot-priority-profile"],
            arg_group="Properties",
            help="Configuration Options for Spot instances in Compute Fleet.",
        )
        _args_schema.vm_attributes = AAZObjectArg(
            options=["--vma", "--vm-attributes"],
            arg_group="Properties",
            help="Attribute based Fleet.",
        )
        _args_schema.vm_sizes_profile = AAZListArg(
            options=["--vmsizeprof", "--vm-sizes-profile"],
            arg_group="Properties",
            help="List of VM sizes supported for Compute Fleet",
        )

        additional_locations_profile = cls._args_schema.additional_locations_profile
        additional_locations_profile.location_profiles = AAZListArg(
            options=["location-profiles"],
            help="The list of location profiles.",
            required=True,
        )

        location_profiles = cls._args_schema.additional_locations_profile.location_profiles
        location_profiles.Element = AAZObjectArg()

        _element = cls._args_schema.additional_locations_profile.location_profiles.Element
        _element.location = AAZStrArg(
            options=["location"],
            help="The ARM location name of the additional region. If LocationProfile is specified, then location is required.",
            required=True,
        )
        _element.virtual_machine_profile_override = AAZObjectArg(
            options=["virtual-machine-profile-override"],
            help="An override for computeProfile.baseVirtualMachineProfile specific to this region.  This override is merged with the base virtual machine profile to define the final virtual machine profile for the resources deployed in this location.",
        )
        cls._build_args_base_virtual_machine_profile_create(_element.virtual_machine_profile_override)

        compute_profile = cls._args_schema.compute_profile
        compute_profile.additional_virtual_machine_capabilities = AAZObjectArg(
            options=["additional-virtual-machine-capabilities"],
            help="Specifies VMSS and VM API entity models support two additional capabilities as of today: ultraSSDEnabled and hibernationEnabled. ultraSSDEnabled: Enables UltraSSD_LRS storage account type on the VMSS VMs. hibernationEnabled: Enables the hibernation capability on the VMSS VMs. Default value is null if not specified. This property cannot be updated once set.",
        )
        compute_profile.base_virtual_machine_profile = AAZObjectArg(
            options=["base-virtual-machine-profile"],
            help="Base Virtual Machine Profile Properties to be specified according to \"specification/compute/resource-manager/Microsoft.Compute/ComputeRP/stable/{computeApiVersion}/virtualMachineScaleSet.json#/definitions/VirtualMachineScaleSetVMProfile\"",
            required=True,
        )
        cls._build_args_base_virtual_machine_profile_create(compute_profile.base_virtual_machine_profile)
        compute_profile.compute_api_version = AAZStrArg(
            options=["compute-api-version"],
            help="Specifies the Microsoft.Compute API version to use when creating underlying Virtual Machine scale sets and Virtual Machines. The default value will be the latest supported computeApiVersion by Compute Fleet.",
        )
        compute_profile.platform_fault_domain_count = AAZIntArg(
            options=["platform-fault-domain-count"],
            help="Specifies the number of fault domains to use when creating the underlying VMSS. A fault domain is a logical group of hardware within an Azure datacenter. VMs in the same fault domain share a common power source and network switch. If not specified, defaults to 1, which represents \"Max Spreading\" (using as many fault domains as possible). This property cannot be updated.",
        )

        additional_virtual_machine_capabilities = cls._args_schema.compute_profile.additional_virtual_machine_capabilities
        additional_virtual_machine_capabilities.hibernation_enabled = AAZBoolArg(
            options=["hibernation-enabled"],
            help="The flag that enables or disables hibernation capability on the VM.",
        )
        additional_virtual_machine_capabilities.ultra_ssd_enabled = AAZBoolArg(
            options=["ultra-ssd-enabled"],
            help="The flag that enables or disables a capability to have one or more managed data disks with UltraSSD_LRS storage account type on the VM or VMSS. Managed disks with storage account type UltraSSD_LRS can be added to a virtual machine or virtual machine scale set only if this property is enabled.",
        )

        regular_priority_profile = cls._args_schema.regular_priority_profile
        regular_priority_profile.allocation_strategy = AAZStrArg(
            options=["allocation-strategy"],
            help="Allocation strategy to follow when determining the VM sizes distribution for Regular VMs.",
            enum={"LowestPrice": "LowestPrice", "Prioritized": "Prioritized"},
        )
        regular_priority_profile.capacity = AAZIntArg(
            options=["capacity"],
            help="Total capacity to achieve. It is currently in terms of number of VMs.",
            fmt=AAZIntArgFormat(
                minimum=0,
            ),
        )
        regular_priority_profile.min_capacity = AAZIntArg(
            options=["min-capacity"],
            help="Minimum capacity to achieve which cannot be updated. If we will not be able to \"guarantee\" minimum capacity, we will reject the request in the sync path itself.",
            fmt=AAZIntArgFormat(
                minimum=0,
            ),
        )

        spot_priority_profile = cls._args_schema.spot_priority_profile
        spot_priority_profile.allocation_strategy = AAZStrArg(
            options=["allocation-strategy"],
            help="Allocation strategy to follow when determining the VM sizes distribution for Spot VMs.",
            enum={"CapacityOptimized": "CapacityOptimized", "LowestPrice": "LowestPrice", "PriceCapacityOptimized": "PriceCapacityOptimized"},
        )
        spot_priority_profile.capacity = AAZIntArg(
            options=["capacity"],
            help="Total capacity to achieve. It is currently in terms of number of VMs.",
            fmt=AAZIntArgFormat(
                minimum=0,
            ),
        )
        spot_priority_profile.eviction_policy = AAZStrArg(
            options=["eviction-policy"],
            help="Eviction Policy to follow when evicting Spot VMs.",
            enum={"Deallocate": "Deallocate", "Delete": "Delete"},
        )
        spot_priority_profile.maintain = AAZBoolArg(
            options=["maintain"],
            help="Flag to enable/disable continuous goal seeking for the desired capacity and restoration of evicted Spot VMs. If maintain is enabled, AzureFleetRP will use all VM sizes in vmSizesProfile to create new VMs (if VMs are evicted deleted) or update existing VMs with new VM sizes (if VMs are evicted deallocated or failed to allocate due to capacity constraint) in order to achieve the desired capacity. Maintain is enabled by default.",
        )
        spot_priority_profile.max_price_per_vm = AAZFloatArg(
            options=["max-price-per-vm"],
            help="Price per hour of each Spot VM will never exceed this.",
        )
        spot_priority_profile.min_capacity = AAZIntArg(
            options=["min-capacity"],
            help="Minimum capacity to achieve which cannot be updated. If we will not be able to \"guarantee\" minimum capacity, we will reject the request in the sync path itself.",
            fmt=AAZIntArgFormat(
                minimum=0,
            ),
        )

        vm_attributes = cls._args_schema.vm_attributes
        vm_attributes.accelerator_count = AAZObjectArg(
            options=["accelerator-count"],
            help="The range of accelerator count specified from min to max. Optional parameter. Either Min or Max is required if specified. acceleratorSupport should be set to \"Included\" or \"Required\" to use this VMAttribute.  If acceleratorSupport is \"Excluded\", this VMAttribute can not be used.",
        )
        cls._build_args_vm_attribute_min_max_integer_create(vm_attributes.accelerator_count)
        vm_attributes.accelerator_manufacturers = AAZListArg(
            options=["accelerator-manufacturers"],
            help="The accelerator manufacturers specified as a list.  acceleratorSupport should be set to \"Included\" or \"Required\" to use this VMAttribute.  If acceleratorSupport is \"Excluded\", this VMAttribute can not be used.",
        )
        vm_attributes.accelerator_support = AAZStrArg(
            options=["accelerator-support"],
            help="Specifies whether the VMSize supporting accelerator should be used to build Fleet or not. acceleratorSupport should be set to \"Included\" or \"Required\" to use this VMAttribute.  If acceleratorSupport is \"Excluded\", this VMAttribute can not be used.",
            enum={"Excluded": "Excluded", "Included": "Included", "Required": "Required"},
        )
        vm_attributes.accelerator_types = AAZListArg(
            options=["accelerator-types"],
            help="The accelerator types specified as a list. acceleratorSupport should be set to \"Included\" or \"Required\" to use this VMAttribute.  If acceleratorSupport is \"Excluded\", this VMAttribute can not be used.",
        )
        vm_attributes.architecture_types = AAZListArg(
            options=["architecture-types"],
            help="The VM architecture types specified as a list. Optional parameter.",
        )
        vm_attributes.burstable_support = AAZStrArg(
            options=["burstable-support"],
            help="Specifies whether the VMSize supporting burstable capability should be used to build Fleet or not.",
            enum={"Excluded": "Excluded", "Included": "Included", "Required": "Required"},
        )
        vm_attributes.cpu_manufacturers = AAZListArg(
            options=["cpu-manufacturers"],
            help="The VM CPU manufacturers specified as a list. Optional parameter.",
        )
        vm_attributes.data_disk_count = AAZObjectArg(
            options=["data-disk-count"],
            help="The range of data disk count specified from Min to Max. Optional parameter. Either Min or Max is required if specified.",
        )
        cls._build_args_vm_attribute_min_max_integer_create(vm_attributes.data_disk_count)
        vm_attributes.excluded_vm_sizes = AAZListArg(
            options=["excluded-vm-sizes"],
            help="Specifies which VMSizes should be excluded while building Fleet. Optional parameter.",
        )
        vm_attributes.local_storage_disk_types = AAZListArg(
            options=["local-storage-disk-types"],
            help="The local storage disk types specified as a list. LocalStorageSupport should be set to \"Included\" or \"Required\" to use this VMAttribute.  If localStorageSupport is \"Excluded\", this VMAttribute can not be used.",
        )
        vm_attributes.local_storage_in_gi_b = AAZObjectArg(
            options=["local-storage-in-gi-b"],
            help="LocalStorageSupport should be set to \"Included\" or \"Required\" to use this VMAttribute.  If localStorageSupport is \"Excluded\", this VMAttribute can not be used.",
        )
        cls._build_args_vm_attribute_min_max_double_create(vm_attributes.local_storage_in_gi_b)
        vm_attributes.local_storage_support = AAZStrArg(
            options=["local-storage-support"],
            help="Specifies whether the VMSize supporting local storage should be used to build Fleet or not. Included - Default if not specified as most Azure VMs support local storage.",
            enum={"Excluded": "Excluded", "Included": "Included", "Required": "Required"},
        )
        vm_attributes.memory_in_gi_b = AAZObjectArg(
            options=["memory-in-gi-b"],
            help="The range of memory specified from Min to Max. Must be specified if VMAttributes are specified, either Min or Max is required if specified.",
            required=True,
        )
        cls._build_args_vm_attribute_min_max_double_create(vm_attributes.memory_in_gi_b)
        vm_attributes.memory_in_gi_b_per_v_cpu = AAZObjectArg(
            options=["memory-in-gi-b-per-v-cpu"],
            help="The range of memory in GiB per vCPU specified from min to max. Optional parameter. Either Min or Max is required if specified.",
        )
        cls._build_args_vm_attribute_min_max_double_create(vm_attributes.memory_in_gi_b_per_v_cpu)
        vm_attributes.network_bandwidth_in_mbps = AAZObjectArg(
            options=["network-bandwidth-in-mbps"],
            help="The range of network bandwidth in Mbps specified from Min to Max. Optional parameter. Either Min or Max is required if specified.",
        )
        cls._build_args_vm_attribute_min_max_double_create(vm_attributes.network_bandwidth_in_mbps)
        vm_attributes.network_interface_count = AAZObjectArg(
            options=["network-interface-count"],
            help="The range of network interface count specified from Min to Max. Optional parameter. Either Min or Max is required if specified.",
        )
        cls._build_args_vm_attribute_min_max_integer_create(vm_attributes.network_interface_count)
        vm_attributes.rdma_network_interface_count = AAZObjectArg(
            options=["rdma-network-interface-count"],
            help="The range of RDMA (Remote Direct Memory Access) network interface count specified from Min to Max. Optional parameter. Either Min or Max is required if specified. rdmaSupport should be set to \"Included\" or \"Required\" to use this VMAttribute.  If rdmaSupport is \"Excluded\", this VMAttribute can not be used.",
        )
        cls._build_args_vm_attribute_min_max_integer_create(vm_attributes.rdma_network_interface_count)
        vm_attributes.rdma_support = AAZStrArg(
            options=["rdma-support"],
            help="Specifies whether the VMSize supporting RDMA (Remote Direct Memory Access) should be used to build Fleet or not.",
            enum={"Excluded": "Excluded", "Included": "Included", "Required": "Required"},
        )
        vm_attributes.v_cpu_count = AAZObjectArg(
            options=["v-cpu-count"],
            help="The range of vCpuCount specified from Min to Max. Must be specified if VMAttributes are specified, either Min or Max is required if specified.",
            required=True,
        )
        cls._build_args_vm_attribute_min_max_integer_create(vm_attributes.v_cpu_count)
        vm_attributes.vm_categories = AAZListArg(
            options=["vm-categories"],
            help="The VM category specified as a list. Optional parameter.",
        )

        accelerator_manufacturers = cls._args_schema.vm_attributes.accelerator_manufacturers
        accelerator_manufacturers.Element = AAZStrArg(
            enum={"AMD": "AMD", "Nvidia": "Nvidia", "Xilinx": "Xilinx"},
        )

        accelerator_types = cls._args_schema.vm_attributes.accelerator_types
        accelerator_types.Element = AAZStrArg(
            enum={"FPGA": "FPGA", "GPU": "GPU"},
        )

        architecture_types = cls._args_schema.vm_attributes.architecture_types
        architecture_types.Element = AAZStrArg(
            enum={"ARM64": "ARM64", "X64": "X64"},
        )

        cpu_manufacturers = cls._args_schema.vm_attributes.cpu_manufacturers
        cpu_manufacturers.Element = AAZStrArg(
            enum={"AMD": "AMD", "Ampere": "Ampere", "Intel": "Intel", "Microsoft": "Microsoft"},
        )

        excluded_vm_sizes = cls._args_schema.vm_attributes.excluded_vm_sizes
        excluded_vm_sizes.Element = AAZStrArg()

        local_storage_disk_types = cls._args_schema.vm_attributes.local_storage_disk_types
        local_storage_disk_types.Element = AAZStrArg(
            enum={"HDD": "HDD", "SSD": "SSD"},
        )

        vm_categories = cls._args_schema.vm_attributes.vm_categories
        vm_categories.Element = AAZStrArg(
            enum={"ComputeOptimized": "ComputeOptimized", "FpgaAccelerated": "FpgaAccelerated", "GeneralPurpose": "GeneralPurpose", "GpuAccelerated": "GpuAccelerated", "HighPerformanceCompute": "HighPerformanceCompute", "MemoryOptimized": "MemoryOptimized", "StorageOptimized": "StorageOptimized"},
        )

        vm_sizes_profile = cls._args_schema.vm_sizes_profile
        vm_sizes_profile.Element = AAZObjectArg()

        _element = cls._args_schema.vm_sizes_profile.Element
        _element.name = AAZStrArg(
            options=["name"],
            help="The Sku name (e.g. 'Standard_DS1_v2')",
            required=True,
        )
        _element.rank = AAZIntArg(
            options=["rank"],
            help="The rank of the VM size. This is used with 'RegularPriorityAllocationStrategy.Prioritized' The lower the number, the higher the priority. Starting with 0.",
            fmt=AAZIntArgFormat(
                maximum=65535,
                minimum=0,
            ),
        )

        # define Arg Group "Resource"

        _args_schema = cls._args_schema
        _args_schema.identity = AAZObjectArg(
            options=["-i", "--identity"],
            arg_group="Resource",
            help="The managed service identities assigned to this resource.",
        )
        _args_schema.location = AAZResourceLocationArg(
            arg_group="Resource",
            help="The geo-location where the resource lives",
            required=True,
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        _args_schema.plan = AAZObjectArg(
            options=["-p", "--plan"],
            arg_group="Resource",
            help="Details of the resource plan.",
        )
        _args_schema.tags = AAZDictArg(
            options=["-t", "--tags"],
            arg_group="Resource",
            help="Resource tags.",
        )
        _args_schema.zones = AAZListArg(
            options=["-z", "--zones"],
            arg_group="Resource",
            help="Zones in which the Compute Fleet is available",
        )

        identity = cls._args_schema.identity
        identity.type = AAZStrArg(
            options=["type"],
            help="Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).",
            required=True,
            enum={"None": "None", "SystemAssigned": "SystemAssigned", "SystemAssigned,UserAssigned": "SystemAssigned,UserAssigned", "UserAssigned": "UserAssigned"},
        )
        identity.user_assigned_identities = AAZDictArg(
            options=["user-assigned-identities"],
            help="The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.",
        )

        user_assigned_identities = cls._args_schema.identity.user_assigned_identities
        user_assigned_identities.Element = AAZObjectArg(
            nullable=True,
            blank={},
        )

        plan = cls._args_schema.plan
        plan.name = AAZStrArg(
            options=["name"],
            help="A user defined name of the 3rd Party Artifact that is being procured.",
            required=True,
        )
        plan.product = AAZStrArg(
            options=["product"],
            help="The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to the OfferID specified for the artifact at the time of Data Market onboarding. ",
            required=True,
        )
        plan.promotion_code = AAZStrArg(
            options=["promotion-code"],
            help="A publisher provided promotion code as provisioned in Data Market for the said product/artifact.",
        )
        plan.publisher = AAZStrArg(
            options=["publisher"],
            help="The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic",
            required=True,
        )
        plan.version = AAZStrArg(
            options=["version"],
            help="The version of the desired product/artifact.",
        )

        tags = cls._args_schema.tags
        tags.Element = AAZStrArg()

        zones = cls._args_schema.zones
        zones.Element = AAZStrArg()
        return cls._args_schema

    _args_api_entity_reference_create = None

    @classmethod
    def _build_args_api_entity_reference_create(cls, _schema):
        if cls._args_api_entity_reference_create is not None:
            _schema.id = cls._args_api_entity_reference_create.id
            return

        cls._args_api_entity_reference_create = AAZObjectArg()

        api_entity_reference_create = cls._args_api_entity_reference_create
        api_entity_reference_create.id = AAZResourceIdArg(
            options=["id"],
            help="The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...",
        )

        _schema.id = cls._args_api_entity_reference_create.id

    _args_base_virtual_machine_profile_create = None

    @classmethod
    def _build_args_base_virtual_machine_profile_create(cls, _schema):
        if cls._args_base_virtual_machine_profile_create is not None:
            _schema.application_profile = cls._args_base_virtual_machine_profile_create.application_profile
            _schema.capacity_reservation = cls._args_base_virtual_machine_profile_create.capacity_reservation
            _schema.diagnostics_profile = cls._args_base_virtual_machine_profile_create.diagnostics_profile
            _schema.extension_profile = cls._args_base_virtual_machine_profile_create.extension_profile
            _schema.hardware_profile = cls._args_base_virtual_machine_profile_create.hardware_profile
            _schema.license_type = cls._args_base_virtual_machine_profile_create.license_type
            _schema.network_profile = cls._args_base_virtual_machine_profile_create.network_profile
            _schema.os_profile = cls._args_base_virtual_machine_profile_create.os_profile
            _schema.scheduled_events_profile = cls._args_base_virtual_machine_profile_create.scheduled_events_profile
            _schema.security_posture_reference = cls._args_base_virtual_machine_profile_create.security_posture_reference
            _schema.security_profile = cls._args_base_virtual_machine_profile_create.security_profile
            _schema.service_artifact_reference = cls._args_base_virtual_machine_profile_create.service_artifact_reference
            _schema.storage_profile = cls._args_base_virtual_machine_profile_create.storage_profile
            _schema.user_data = cls._args_base_virtual_machine_profile_create.user_data
            return

        cls._args_base_virtual_machine_profile_create = AAZObjectArg()

        base_virtual_machine_profile_create = cls._args_base_virtual_machine_profile_create
        base_virtual_machine_profile_create.application_profile = AAZObjectArg(
            options=["application-profile"],
            help="Specifies the gallery applications that should be made available to the VM/VMSS",
        )
        base_virtual_machine_profile_create.capacity_reservation = AAZObjectArg(
            options=["capacity-reservation"],
            help="Specifies the capacity reservation related details of a scale set. Minimum api-version: 2021-04-01.",
        )
        base_virtual_machine_profile_create.diagnostics_profile = AAZObjectArg(
            options=["diagnostics-profile"],
            help="Specifies the boot diagnostic settings state.",
        )
        base_virtual_machine_profile_create.extension_profile = AAZObjectArg(
            options=["extension-profile"],
            help="Specifies a collection of settings for extensions installed on virtual machines in the scale set.",
        )
        base_virtual_machine_profile_create.hardware_profile = AAZObjectArg(
            options=["hardware-profile"],
            help="Specifies the hardware profile related details of a scale set. Minimum api-version: 2021-11-01.",
        )
        base_virtual_machine_profile_create.license_type = AAZStrArg(
            options=["license-type"],
            help="Specifies that the image or disk that is being used was licensed on-premises. <br><br> Possible values for Windows Server operating system are: <br><br> Windows_Client <br><br> Windows_Server <br><br> Possible values for Linux Server operating system are: <br><br> RHEL_BYOS (for RHEL) <br><br> SLES_BYOS (for SUSE) <br><br> For more information, see [Azure Hybrid Use Benefit for Windows Server](https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing) <br><br> [Azure Hybrid Use Benefit for Linux Server](https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux) <br><br> Minimum api-version: 2015-06-15",
        )
        base_virtual_machine_profile_create.network_profile = AAZObjectArg(
            options=["network-profile"],
            help="Specifies properties of the network interfaces of the virtual machines in the scale set.",
        )
        base_virtual_machine_profile_create.os_profile = AAZObjectArg(
            options=["os-profile"],
            help="Specifies the operating system settings for the virtual machines in the scale set.",
        )
        base_virtual_machine_profile_create.scheduled_events_profile = AAZObjectArg(
            options=["scheduled-events-profile"],
            help="Specifies Scheduled Event related configurations.",
        )
        base_virtual_machine_profile_create.security_posture_reference = AAZObjectArg(
            options=["security-posture-reference"],
            help="Specifies the security posture to be used for all virtual machines in the scale set. Minimum api-version: 2023-03-01",
        )
        base_virtual_machine_profile_create.security_profile = AAZObjectArg(
            options=["security-profile"],
            help="Specifies the Security related profile settings for the virtual machines in the scale set.",
        )
        base_virtual_machine_profile_create.service_artifact_reference = AAZObjectArg(
            options=["service-artifact-reference"],
            help="Specifies the service artifact reference id used to set same image version for all virtual machines in the scale set when using 'latest' image version. Minimum api-version: 2022-11-01",
        )
        base_virtual_machine_profile_create.storage_profile = AAZObjectArg(
            options=["storage-profile"],
            help="Specifies the storage settings for the virtual machine disks.",
        )
        base_virtual_machine_profile_create.user_data = AAZStrArg(
            options=["user-data"],
            help="UserData for the virtual machines in the scale set, which must be base-64 encoded. Customer should not pass any secrets in here. Minimum api-version: 2021-03-01.",
        )

        application_profile = cls._args_base_virtual_machine_profile_create.application_profile
        application_profile.gallery_applications = AAZListArg(
            options=["gallery-applications"],
            help="Specifies the gallery applications that should be made available to the VM/VMSS",
        )

        gallery_applications = cls._args_base_virtual_machine_profile_create.application_profile.gallery_applications
        gallery_applications.Element = AAZObjectArg()

        _element = cls._args_base_virtual_machine_profile_create.application_profile.gallery_applications.Element
        _element.configuration_reference = AAZStrArg(
            options=["configuration-reference"],
            help="Optional, Specifies the uri to an azure blob that will replace the default configuration for the package if provided",
        )
        _element.enable_automatic_upgrade = AAZBoolArg(
            options=["enable-automatic-upgrade"],
            help="If set to true, when a new Gallery Application version is available in PIR/SIG, it will be automatically updated for the VM/VMSS",
        )
        _element.order = AAZIntArg(
            options=["order"],
            help="Optional, Specifies the order in which the packages have to be installed",
        )
        _element.package_reference_id = AAZResourceIdArg(
            options=["package-reference-id"],
            help="Specifies the GalleryApplicationVersion resource id on the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{application}/versions/{version}",
            required=True,
        )
        _element.tags = AAZStrArg(
            options=["tags"],
            help="Optional, Specifies a passthrough value for more generic context.",
        )
        _element.treat_failure_as_deployment_failure = AAZBoolArg(
            options=["treat-failure-as-deployment-failure"],
            help="Optional, If true, any failure for any operation in the VmApplication will fail the deployment",
        )

        capacity_reservation = cls._args_base_virtual_machine_profile_create.capacity_reservation
        capacity_reservation.capacity_reservation_group = AAZObjectArg(
            options=["capacity-reservation-group"],
            help="Specifies the capacity reservation group resource id that should be used for allocating the virtual machine or scaleset vm instances provided enough capacity has been reserved. Please refer to https://aka.ms/CapacityReservation for more details.",
        )
        cls._build_args_sub_resource_create(capacity_reservation.capacity_reservation_group)

        diagnostics_profile = cls._args_base_virtual_machine_profile_create.diagnostics_profile
        diagnostics_profile.boot_diagnostics = AAZObjectArg(
            options=["boot-diagnostics"],
            help="Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. **NOTE**: If storageUri is being specified then ensure that the storage account is in the same region and subscription as the VM. You can easily view the output of your console log. Azure also enables you to see a screenshot of the VM from the hypervisor.",
        )

        boot_diagnostics = cls._args_base_virtual_machine_profile_create.diagnostics_profile.boot_diagnostics
        boot_diagnostics.enabled = AAZBoolArg(
            options=["enabled"],
            help="Whether boot diagnostics should be enabled on the Virtual Machine.",
        )
        boot_diagnostics.storage_uri = AAZStrArg(
            options=["storage-uri"],
            help="Uri of the storage account to use for placing the console output and screenshot. If storageUri is not specified while enabling boot diagnostics, managed storage will be used.",
        )

        extension_profile = cls._args_base_virtual_machine_profile_create.extension_profile
        extension_profile.extensions = AAZListArg(
            options=["extensions"],
            help="The virtual machine scale set child extension resources.",
        )
        extension_profile.extensions_time_budget = AAZStrArg(
            options=["extensions-time-budget"],
            help="Specifies the time alloted for all extensions to start. The time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in ISO 8601 format. The default value is 90 minutes (PT1H30M). Minimum api-version: 2020-06-01.",
        )

        extensions = cls._args_base_virtual_machine_profile_create.extension_profile.extensions
        extensions.Element = AAZObjectArg()

        _element = cls._args_base_virtual_machine_profile_create.extension_profile.extensions.Element
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the extension.",
        )
        _element.auto_upgrade_minor_version = AAZBoolArg(
            options=["auto-upgrade-minor-version"],
            help="Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.",
        )
        _element.enable_automatic_upgrade = AAZBoolArg(
            options=["enable-automatic-upgrade"],
            help="Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension available.",
        )
        _element.force_update_tag = AAZStrArg(
            options=["force-update-tag"],
            help="If a value is provided and is different from the previous value, the extension handler will be forced to update even if the extension configuration has not changed.",
        )
        _element.protected_settings = AAZFreeFormDictArg(
            options=["protected-settings"],
            help="The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.",
        )
        _element.protected_settings_from_key_vault = AAZObjectArg(
            options=["protected-settings-from-key-vault"],
            help="The extensions protected settings that are passed by reference, and consumed from key vault",
        )
        _element.provision_after_extensions = AAZListArg(
            options=["provision-after-extensions"],
            help="Collection of extension names after which this extension needs to be provisioned.",
        )
        _element.publisher = AAZStrArg(
            options=["publisher"],
            help="The name of the extension handler publisher.",
        )
        _element.settings = AAZFreeFormDictArg(
            options=["settings"],
            help="Json formatted public settings for the extension.",
        )
        _element.suppress_failures = AAZBoolArg(
            options=["suppress-failures"],
            help="Indicates whether failures stemming from the extension will be suppressed (Operational failures such as not connecting to the VM will not be suppressed regardless of this value). The default is false.",
        )
        _element.type = AAZStrArg(
            options=["type"],
            help="Specifies the type of the extension; an example is \"CustomScriptExtension\".",
        )
        _element.type_handler_version = AAZStrArg(
            options=["type-handler-version"],
            help="Specifies the version of the script handler.",
        )

        protected_settings_from_key_vault = cls._args_base_virtual_machine_profile_create.extension_profile.extensions.Element.protected_settings_from_key_vault
        protected_settings_from_key_vault.secret_url = AAZStrArg(
            options=["secret-url"],
            help="The URL referencing a secret in a Key Vault.",
            required=True,
        )
        protected_settings_from_key_vault.source_vault = AAZObjectArg(
            options=["source-vault"],
            help="The relative URL of the Key Vault containing the secret.",
            required=True,
        )
        cls._build_args_sub_resource_create(protected_settings_from_key_vault.source_vault)

        provision_after_extensions = cls._args_base_virtual_machine_profile_create.extension_profile.extensions.Element.provision_after_extensions
        provision_after_extensions.Element = AAZStrArg()

        hardware_profile = cls._args_base_virtual_machine_profile_create.hardware_profile
        hardware_profile.vm_size_properties = AAZObjectArg(
            options=["vm-size-properties"],
            help="Specifies the properties for customizing the size of the virtual machine. Minimum api-version: 2021-11-01. Please follow the instructions in [VM Customization](https://aka.ms/vmcustomization) for more details.",
        )

        vm_size_properties = cls._args_base_virtual_machine_profile_create.hardware_profile.vm_size_properties
        vm_size_properties.v_cp_us_available = AAZIntArg(
            options=["v-cp-us-available"],
            help="Specifies the number of vCPUs available for the VM. When this property is not specified in the request body the default behavior is to set it to the value of vCPUs available for that VM size exposed in api response of [List all available virtual machine sizes in a region](https://docs.microsoft.com/en-us/rest/api/compute/resource-skus/list).",
        )
        vm_size_properties.v_cp_us_per_core = AAZIntArg(
            options=["v-cp-us-per-core"],
            help="Specifies the vCPU to physical core ratio. When this property is not specified in the request body the default behavior is set to the value of vCPUsPerCore for the VM Size exposed in api response of [List all available virtual machine sizes in a region](https://docs.microsoft.com/en-us/rest/api/compute/resource-skus/list). **Setting this property to 1 also means that hyper-threading is disabled.**",
        )

        network_profile = cls._args_base_virtual_machine_profile_create.network_profile
        network_profile.health_probe = AAZObjectArg(
            options=["health-probe"],
            help="A reference to a load balancer probe used to determine the health of an instance in the virtual machine scale set. The reference will be in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}'.",
        )
        cls._build_args_api_entity_reference_create(network_profile.health_probe)
        network_profile.network_api_version = AAZStrArg(
            options=["network-api-version"],
            help="specifies the Microsoft.Network API version used when creating networking resources in the Network Interface Configurations for Virtual Machine Scale Set with orchestration mode 'Flexible'",
            enum={"2020-11-01": "2020-11-01"},
        )
        network_profile.network_interface_configurations = AAZListArg(
            options=["network-interface-configurations"],
            help="The list of network configurations.",
        )

        network_interface_configurations = cls._args_base_virtual_machine_profile_create.network_profile.network_interface_configurations
        network_interface_configurations.Element = AAZObjectArg()

        _element = cls._args_base_virtual_machine_profile_create.network_profile.network_interface_configurations.Element
        _element.name = AAZStrArg(
            options=["name"],
            help="The network configuration name.",
            required=True,
        )
        _element.auxiliary_mode = AAZStrArg(
            options=["auxiliary-mode"],
            help="Specifies whether the Auxiliary mode is enabled for the Network Interface resource.",
            enum={"AcceleratedConnections": "AcceleratedConnections", "Floating": "Floating", "None": "None"},
        )
        _element.auxiliary_sku = AAZStrArg(
            options=["auxiliary-sku"],
            help="Specifies whether the Auxiliary sku is enabled for the Network Interface resource.",
            enum={"A1": "A1", "A2": "A2", "A4": "A4", "A8": "A8", "None": "None"},
        )
        _element.delete_option = AAZStrArg(
            options=["delete-option"],
            help="Specify what happens to the network interface when the VM is deleted",
            enum={"Delete": "Delete", "Detach": "Detach"},
        )
        _element.disable_tcp_state_tracking = AAZBoolArg(
            options=["disable-tcp-state-tracking"],
            help="Specifies whether the network interface is disabled for tcp state tracking.",
        )
        _element.dns_settings = AAZObjectArg(
            options=["dns-settings"],
            help="The dns settings to be applied on the network interfaces.",
        )
        _element.enable_accelerated_networking = AAZBoolArg(
            options=["enable-accelerated-networking"],
            help="Specifies whether the network interface is accelerated networking-enabled.",
        )
        _element.enable_fpga = AAZBoolArg(
            options=["enable-fpga"],
            help="Specifies whether the network interface is FPGA networking-enabled.",
        )
        _element.enable_ip_forwarding = AAZBoolArg(
            options=["enable-ip-forwarding"],
            help="Whether IP forwarding enabled on this NIC.",
        )
        _element.ip_configurations = AAZListArg(
            options=["ip-configurations"],
            help="Specifies the IP configurations of the network interface.",
        )
        _element.network_security_group = AAZObjectArg(
            options=["network-security-group"],
            help="The network security group.",
        )
        cls._build_args_sub_resource_create(_element.network_security_group)
        _element.primary = AAZBoolArg(
            options=["primary"],
            help="Specifies the primary network interface in case the virtual machine has more than 1 network interface.",
        )

        dns_settings = cls._args_base_virtual_machine_profile_create.network_profile.network_interface_configurations.Element.dns_settings
        dns_settings.dns_servers = AAZListArg(
            options=["dns-servers"],
            help="List of DNS servers IP addresses",
        )

        dns_servers = cls._args_base_virtual_machine_profile_create.network_profile.network_interface_configurations.Element.dns_settings.dns_servers
        dns_servers.Element = AAZStrArg()

        ip_configurations = cls._args_base_virtual_machine_profile_create.network_profile.network_interface_configurations.Element.ip_configurations
        ip_configurations.Element = AAZObjectArg()

        _element = cls._args_base_virtual_machine_profile_create.network_profile.network_interface_configurations.Element.ip_configurations.Element
        _element.name = AAZStrArg(
            options=["name"],
            help="The IP configuration name.",
            required=True,
        )
        _element.application_gateway_backend_address_pools = AAZListArg(
            options=["application-gateway-backend-address-pools"],
            help="Specifies an array of references to backend address pools of application gateways. A scale set can reference backend address pools of multiple application gateways. Multiple scale sets cannot use the same application gateway.",
        )
        _element.application_security_groups = AAZListArg(
            options=["application-security-groups"],
            help="Specifies an array of references to application security group.",
        )
        _element.load_balancer_backend_address_pools = AAZListArg(
            options=["load-balancer-backend-address-pools"],
            help="Specifies an array of references to backend address pools of load balancers. A scale set can reference backend address pools of one public and one internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.",
        )
        _element.load_balancer_inbound_nat_pools = AAZListArg(
            options=["load-balancer-inbound-nat-pools"],
            help="Specifies an array of references to inbound Nat pools of the load balancers. A scale set can reference inbound nat pools of one public and one internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.",
        )
        _element.primary = AAZBoolArg(
            options=["primary"],
            help="Specifies the primary network interface in case the virtual machine has more than 1 network interface.",
        )
        _element.private_ip_address_version = AAZStrArg(
            options=["private-ip-address-version"],
            help="Available from Api-Version 2017-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and 'IPv6'.",
            enum={"IPv4": "IPv4", "IPv6": "IPv6"},
        )
        _element.public_ip_address_configuration = AAZObjectArg(
            options=["public-ip-address-configuration"],
            help="The publicIPAddressConfiguration.",
        )
        _element.subnet = AAZObjectArg(
            options=["subnet"],
            help="Specifies the identifier of the subnet.",
        )
        cls._build_args_api_entity_reference_create(_element.subnet)

        application_gateway_backend_address_pools = cls._args_base_virtual_machine_profile_create.network_profile.network_interface_configurations.Element.ip_configurations.Element.application_gateway_backend_address_pools
        application_gateway_backend_address_pools.Element = AAZObjectArg()
        cls._build_args_sub_resource_create(application_gateway_backend_address_pools.Element)

        application_security_groups = cls._args_base_virtual_machine_profile_create.network_profile.network_interface_configurations.Element.ip_configurations.Element.application_security_groups
        application_security_groups.Element = AAZObjectArg()
        cls._build_args_sub_resource_create(application_security_groups.Element)

        load_balancer_backend_address_pools = cls._args_base_virtual_machine_profile_create.network_profile.network_interface_configurations.Element.ip_configurations.Element.load_balancer_backend_address_pools
        load_balancer_backend_address_pools.Element = AAZObjectArg()
        cls._build_args_sub_resource_create(load_balancer_backend_address_pools.Element)

        load_balancer_inbound_nat_pools = cls._args_base_virtual_machine_profile_create.network_profile.network_interface_configurations.Element.ip_configurations.Element.load_balancer_inbound_nat_pools
        load_balancer_inbound_nat_pools.Element = AAZObjectArg()
        cls._build_args_sub_resource_create(load_balancer_inbound_nat_pools.Element)

        public_ip_address_configuration = cls._args_base_virtual_machine_profile_create.network_profile.network_interface_configurations.Element.ip_configurations.Element.public_ip_address_configuration
        public_ip_address_configuration.name = AAZStrArg(
            options=["name"],
            help="The publicIP address configuration name.",
            required=True,
        )
        public_ip_address_configuration.delete_option = AAZStrArg(
            options=["delete-option"],
            help="Specify what happens to the public IP when the VM is deleted",
            enum={"Delete": "Delete", "Detach": "Detach"},
        )
        public_ip_address_configuration.dns_settings = AAZObjectArg(
            options=["dns-settings"],
            help="The dns settings to be applied on the publicIP addresses .",
        )
        public_ip_address_configuration.idle_timeout_in_minutes = AAZIntArg(
            options=["idle-timeout-in-minutes"],
            help="The idle timeout of the public IP address.",
        )
        public_ip_address_configuration.ip_tags = AAZListArg(
            options=["ip-tags"],
            help="The list of IP tags associated with the public IP address.",
        )
        public_ip_address_configuration.public_ip_address_version = AAZStrArg(
            options=["public-ip-address-version"],
            help="Available from Api-Version 2019-07-01 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible values are: 'IPv4' and 'IPv6'.",
            enum={"IPv4": "IPv4", "IPv6": "IPv6"},
        )
        public_ip_address_configuration.public_ip_prefix = AAZObjectArg(
            options=["public-ip-prefix"],
            help="The PublicIPPrefix from which to allocate publicIP addresses.",
        )
        cls._build_args_sub_resource_create(public_ip_address_configuration.public_ip_prefix)
        public_ip_address_configuration.sku = AAZObjectArg(
            options=["sku"],
            help="Describes the public IP Sku. It can only be set with OrchestrationMode as Flexible.",
        )

        dns_settings = cls._args_base_virtual_machine_profile_create.network_profile.network_interface_configurations.Element.ip_configurations.Element.public_ip_address_configuration.dns_settings
        dns_settings.domain_name_label = AAZStrArg(
            options=["domain-name-label"],
            help="The Domain name label.The concatenation of the domain name label and vm index will be the domain name labels of the PublicIPAddress resources that will be created",
            required=True,
        )
        dns_settings.domain_name_label_scope = AAZStrArg(
            options=["domain-name-label-scope"],
            help="The Domain name label scope.The concatenation of the hashed domain name label that generated according to the policy from domain name label scope and vm index will be the domain name labels of the PublicIPAddress resources that will be created",
            enum={"NoReuse": "NoReuse", "ResourceGroupReuse": "ResourceGroupReuse", "SubscriptionReuse": "SubscriptionReuse", "TenantReuse": "TenantReuse"},
        )

        ip_tags = cls._args_base_virtual_machine_profile_create.network_profile.network_interface_configurations.Element.ip_configurations.Element.public_ip_address_configuration.ip_tags
        ip_tags.Element = AAZObjectArg()

        _element = cls._args_base_virtual_machine_profile_create.network_profile.network_interface_configurations.Element.ip_configurations.Element.public_ip_address_configuration.ip_tags.Element
        _element.ip_tag_type = AAZStrArg(
            options=["ip-tag-type"],
            help="IP tag type. Example: FirstPartyUsage.",
        )
        _element.tag = AAZStrArg(
            options=["tag"],
            help="IP tag associated with the public IP. Example: SQL, Storage etc.",
        )

        sku = cls._args_base_virtual_machine_profile_create.network_profile.network_interface_configurations.Element.ip_configurations.Element.public_ip_address_configuration.sku
        sku.name = AAZStrArg(
            options=["name"],
            help="Specify public IP sku name",
            enum={"Basic": "Basic", "Standard": "Standard"},
        )
        sku.tier = AAZStrArg(
            options=["tier"],
            help="Specify public IP sku tier",
            enum={"Global": "Global", "Regional": "Regional"},
        )

        os_profile = cls._args_base_virtual_machine_profile_create.os_profile
        os_profile.admin_password = AAZPasswordArg(
            options=["admin-password"],
            help="Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\\W_]) <br><br> **Disallowed values:** \"abc@123\", \"P@$$w0rd\", \"P@ssw0rd\", \"P@ssword123\", \"Pa$$word\", \"pass@word1\", \"Password!\", \"Password1\", \"Password22\", \"iloveyou!\" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection)",
            blank=AAZPromptPasswordInput(
               msg="VM Admin Password",
               confirm=True),
        )
        os_profile.admin_username = AAZStrArg(
            options=["admin-username"],
            help="Specifies the name of the administrator account. <br><br> **Windows-only restriction:** Cannot end in \".\" <br><br> **Disallowed values:** \"administrator\", \"admin\", \"user\", \"user1\", \"test\", \"user2\", \"test1\", \"user3\", \"admin1\", \"1\", \"123\", \"a\", \"actuser\", \"adm\", \"admin2\", \"aspnet\", \"backup\", \"console\", \"david\", \"guest\", \"john\", \"owner\", \"root\", \"server\", \"sql\", \"support\", \"support_388945a0\", \"sys\", \"test2\", \"test3\", \"user4\", \"user5\". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters",
        )
        os_profile.allow_extension_operations = AAZBoolArg(
            options=["allow-extension-operations"],
            help="Specifies whether extension operations should be allowed on the virtual machine scale set. This may only be set to False when no extensions are present on the virtual machine scale set.",
        )
        os_profile.computer_name_prefix = AAZStrArg(
            options=["computer-name-prefix"],
            help="Specifies the computer name prefix for all of the virtual machines in the scale set. Computer name prefixes must be 1 to 15 characters long.",
        )
        os_profile.custom_data = AAZPasswordArg(
            options=["custom-data"],
            help="Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum length of the binary array is 65535 bytes. For using cloud-init for your VM, see [Using cloud-init to customize a Linux VM during creation](https://docs.microsoft.com/azure/virtual-machines/linux/using-cloud-init)",
            blank=AAZPromptPasswordInput(
               msg="VM Admin Password",
               confirm=True),
        )
        os_profile.linux_configuration = AAZObjectArg(
            options=["linux-configuration"],
            help="Specifies the Linux operating system settings on the virtual machine. For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros).",
        )
        os_profile.require_guest_provision_signal = AAZBoolArg(
            options=["require-guest-provision-signal"],
            help="Optional property which must either be set to True or omitted.",
        )
        os_profile.secrets = AAZListArg(
            options=["secrets"],
            help="Specifies set of certificates that should be installed onto the virtual machines in the scale set. To install certificates on a virtual machine it is recommended to use the [Azure Key Vault virtual machine extension for Linux](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux) or the [Azure Key Vault virtual machine extension for Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).",
        )
        os_profile.windows_configuration = AAZObjectArg(
            options=["windows-configuration"],
            help="Specifies Windows operating system settings on the virtual machine.",
        )

        linux_configuration = cls._args_base_virtual_machine_profile_create.os_profile.linux_configuration
        linux_configuration.disable_password_authentication = AAZBoolArg(
            options=["disable-password-authentication"],
            help="Specifies whether password authentication should be disabled.",
        )
        linux_configuration.enable_vm_agent_platform_updates = AAZBoolArg(
            options=["enable-vm-agent-platform-updates"],
            help="Indicates whether VMAgent Platform Updates is enabled for the Linux virtual machine. Default value is false.",
        )
        linux_configuration.patch_settings = AAZObjectArg(
            options=["patch-settings"],
            help="[Preview Feature] Specifies settings related to VM Guest Patching on Linux.",
        )
        linux_configuration.provision_vm_agent = AAZBoolArg(
            options=["provision-vm-agent"],
            help="Indicates whether virtual machine agent should be provisioned on the virtual machine. When this property is not specified in the request body, default behavior is to set it to true. This will ensure that VM Agent is installed on the VM so that extensions can be added to the VM later.",
        )
        linux_configuration.ssh = AAZObjectArg(
            options=["ssh"],
            help="Specifies the ssh key configuration for a Linux OS.",
        )

        patch_settings = cls._args_base_virtual_machine_profile_create.os_profile.linux_configuration.patch_settings
        patch_settings.assessment_mode = AAZStrArg(
            options=["assessment-mode"],
            help="Specifies the mode of VM Guest Patch Assessment for the IaaS virtual machine.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - You control the timing of patch assessments on a virtual machine. <br /><br /> **AutomaticByPlatform** - The platform will trigger periodic patch assessments. The property provisionVMAgent must be true.",
            enum={"AutomaticByPlatform": "AutomaticByPlatform", "ImageDefault": "ImageDefault"},
        )
        patch_settings.automatic_by_platform_settings = AAZObjectArg(
            options=["automatic-by-platform-settings"],
            help="Specifies additional settings for patch mode AutomaticByPlatform in VM Guest Patching on Linux.",
        )
        patch_settings.patch_mode = AAZStrArg(
            options=["patch-mode"],
            help="Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual machines associated to virtual machine scale set with OrchestrationMode as Flexible.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - The virtual machine's default patching configuration is used. <br /><br /> **AutomaticByPlatform** - The virtual machine will be automatically updated by the platform. The property provisionVMAgent must be true",
            enum={"AutomaticByPlatform": "AutomaticByPlatform", "ImageDefault": "ImageDefault"},
        )

        automatic_by_platform_settings = cls._args_base_virtual_machine_profile_create.os_profile.linux_configuration.patch_settings.automatic_by_platform_settings
        automatic_by_platform_settings.bypass_platform_safety_checks_on_user_schedule = AAZBoolArg(
            options=["bypass-platform-safety-checks-on-user-schedule"],
            help="Enables customer to schedule patching without accidental upgrades",
        )
        automatic_by_platform_settings.reboot_setting = AAZStrArg(
            options=["reboot-setting"],
            help="Specifies the reboot setting for all AutomaticByPlatform patch installation operations.",
            enum={"Always": "Always", "IfRequired": "IfRequired", "Never": "Never", "Unknown": "Unknown"},
        )

        ssh = cls._args_base_virtual_machine_profile_create.os_profile.linux_configuration.ssh
        ssh.public_keys = AAZListArg(
            options=["public-keys"],
            help="The list of SSH public keys used to authenticate with linux based VMs.",
        )

        public_keys = cls._args_base_virtual_machine_profile_create.os_profile.linux_configuration.ssh.public_keys
        public_keys.Element = AAZObjectArg()

        _element = cls._args_base_virtual_machine_profile_create.os_profile.linux_configuration.ssh.public_keys.Element
        _element.key_data = AAZStrArg(
            options=["key-data"],
            help="SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure]https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).",
        )
        _element.path = AAZStrArg(
            options=["path"],
            help="Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys",
        )

        secrets = cls._args_base_virtual_machine_profile_create.os_profile.secrets
        secrets.Element = AAZObjectArg()

        _element = cls._args_base_virtual_machine_profile_create.os_profile.secrets.Element
        _element.source_vault = AAZObjectArg(
            options=["source-vault"],
            help="The relative URL of the Key Vault containing all of the certificates in VaultCertificates.",
        )
        cls._build_args_sub_resource_create(_element.source_vault)
        _element.vault_certificates = AAZListArg(
            options=["vault-certificates"],
            help="The list of key vault references in SourceVault which contain certificates.",
        )

        vault_certificates = cls._args_base_virtual_machine_profile_create.os_profile.secrets.Element.vault_certificates
        vault_certificates.Element = AAZObjectArg()

        _element = cls._args_base_virtual_machine_profile_create.os_profile.secrets.Element.vault_certificates.Element
        _element.certificate_store = AAZStrArg(
            options=["certificate-store"],
            help="For Windows VMs, specifies the certificate store on the Virtual Machine to which the certificate should be added. The specified certificate store is implicitly in the LocalMachine account. For Linux VMs, the certificate file is placed under the /var/lib/waagent directory, with the file name &lt;UppercaseThumbprint&gt;.crt for the X509 certificate file and &lt;UppercaseThumbprint&gt;.prv for private key. Both of these files are .pem formatted.",
        )
        _element.certificate_url = AAZStrArg(
            options=["certificate-url"],
            help="This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add). In this case, your certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br> \"data\":\"<Base64-encoded-certificate>\",<br>  \"dataType\":\"pfx\",<br> \"password\":\"<pfx-file-password>\"<br>} <br> To install certificates on a virtual machine it is recommended to use the [Azure Key Vault virtual machine extension for Linux](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux) or the [Azure Key Vault virtual machine extension for Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).",
        )

        windows_configuration = cls._args_base_virtual_machine_profile_create.os_profile.windows_configuration
        windows_configuration.additional_unattend_content = AAZListArg(
            options=["additional-unattend-content"],
            help="Specifies additional base-64 encoded XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup.",
        )
        windows_configuration.enable_automatic_updates = AAZBoolArg(
            options=["enable-automatic-updates"],
            help="Indicates whether Automatic Updates is enabled for the Windows virtual machine. Default value is true. For virtual machine scale sets, this property can be updated and updates will take effect on OS reprovisioning.",
        )
        windows_configuration.enable_vm_agent_platform_updates = AAZBoolArg(
            options=["enable-vm-agent-platform-updates"],
            help="Indicates whether VMAgent Platform Updates is enabled for the Windows virtual machine. Default value is false.",
        )
        windows_configuration.patch_settings = AAZObjectArg(
            options=["patch-settings"],
            help="[Preview Feature] Specifies settings related to VM Guest Patching on Windows.",
        )
        windows_configuration.provision_vm_agent = AAZBoolArg(
            options=["provision-vm-agent"],
            help="Indicates whether virtual machine agent should be provisioned on the virtual machine. When this property is not specified in the request body, it is set to true by default. This will ensure that VM Agent is installed on the VM so that extensions can be added to the VM later.",
        )
        windows_configuration.time_zone = AAZStrArg(
            options=["time-zone"],
            help="Specifies the time zone of the virtual machine. e.g. \"Pacific Standard Time\". Possible values can be [TimeZoneInfo.Id](https://docs.microsoft.com/dotnet/api/system.timezoneinfo.id?#System_TimeZoneInfo_Id) value from time zones returned by [TimeZoneInfo.GetSystemTimeZones](https://docs.microsoft.com/dotnet/api/system.timezoneinfo.getsystemtimezones).",
        )
        windows_configuration.win_rm = AAZObjectArg(
            options=["win-rm"],
            help="Specifies the Windows Remote Management listeners. This enables remote Windows PowerShell.",
        )

        additional_unattend_content = cls._args_base_virtual_machine_profile_create.os_profile.windows_configuration.additional_unattend_content
        additional_unattend_content.Element = AAZObjectArg()

        _element = cls._args_base_virtual_machine_profile_create.os_profile.windows_configuration.additional_unattend_content.Element
        _element.component_name = AAZStrArg(
            options=["component-name"],
            help="The component name. Currently, the only allowable value is Microsoft-Windows-Shell-Setup.",
            enum={"Microsoft-Windows-Shell-Setup": "Microsoft-Windows-Shell-Setup"},
        )
        _element.content = AAZPasswordArg(
            options=["content"],
            help="Specifies the XML formatted content that is added to the unattend.xml file for the specified path and component. The XML must be less than 4KB and must include the root element for the setting or feature that is being inserted.",
             blank=AAZPromptPasswordInput(
               msg="VM Admin Password",
               confirm=True),
        )
        _element.pass_name = AAZStrArg(
            options=["pass-name"],
            help="The pass name. Currently, the only allowable value is OobeSystem.",
            enum={"OobeSystem": "OobeSystem"},
        )
        _element.setting_name = AAZStrArg(
            options=["setting-name"],
            help="Specifies the name of the setting to which the content applies. Possible values are: FirstLogonCommands and AutoLogon.",
            enum={"AutoLogon": "AutoLogon", "FirstLogonCommands": "FirstLogonCommands"},
        )

        patch_settings = cls._args_base_virtual_machine_profile_create.os_profile.windows_configuration.patch_settings
        patch_settings.assessment_mode = AAZStrArg(
            options=["assessment-mode"],
            help="Specifies the mode of VM Guest patch assessment for the IaaS virtual machine.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - You control the timing of patch assessments on a virtual machine.<br /><br /> **AutomaticByPlatform** - The platform will trigger periodic patch assessments. The property provisionVMAgent must be true.",
            enum={"AutomaticByPlatform": "AutomaticByPlatform", "ImageDefault": "ImageDefault"},
        )
        patch_settings.automatic_by_platform_settings = AAZObjectArg(
            options=["automatic-by-platform-settings"],
            help="Specifies additional settings for patch mode AutomaticByPlatform in VM Guest Patching on Windows.",
        )
        patch_settings.enable_hotpatching = AAZBoolArg(
            options=["enable-hotpatching"],
            help="Enables customers to patch their Azure VMs without requiring a reboot. For enableHotpatching, the 'provisionVMAgent' must be set to true and 'patchMode' must be set to 'AutomaticByPlatform'.",
        )
        patch_settings.patch_mode = AAZStrArg(
            options=["patch-mode"],
            help="Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual machines associated to virtual machine scale set with OrchestrationMode as Flexible.<br /><br /> Possible values are:<br /><br /> **Manual** - You control the application of patches to a virtual machine. You do this by applying patches manually inside the VM. In this mode, automatic updates are disabled; the property WindowsConfiguration.enableAutomaticUpdates must be false<br /><br /> **AutomaticByOS** - The virtual machine will automatically be updated by the OS. The property WindowsConfiguration.enableAutomaticUpdates must be true. <br /><br /> **AutomaticByPlatform** - the virtual machine will automatically updated by the platform. The properties provisionVMAgent and WindowsConfiguration.enableAutomaticUpdates must be true",
            enum={"AutomaticByOS": "AutomaticByOS", "AutomaticByPlatform": "AutomaticByPlatform", "Manual": "Manual"},
        )

        automatic_by_platform_settings = cls._args_base_virtual_machine_profile_create.os_profile.windows_configuration.patch_settings.automatic_by_platform_settings
        automatic_by_platform_settings.bypass_platform_safety_checks_on_user_schedule = AAZBoolArg(
            options=["bypass-platform-safety-checks-on-user-schedule"],
            help="Enables customer to schedule patching without accidental upgrades",
        )
        automatic_by_platform_settings.reboot_setting = AAZStrArg(
            options=["reboot-setting"],
            help="Specifies the reboot setting for all AutomaticByPlatform patch installation operations.",
            enum={"Always": "Always", "IfRequired": "IfRequired", "Never": "Never", "Unknown": "Unknown"},
        )

        win_rm = cls._args_base_virtual_machine_profile_create.os_profile.windows_configuration.win_rm
        win_rm.listeners = AAZListArg(
            options=["listeners"],
            help="The list of Windows Remote Management listeners",
        )

        listeners = cls._args_base_virtual_machine_profile_create.os_profile.windows_configuration.win_rm.listeners
        listeners.Element = AAZObjectArg()

        _element = cls._args_base_virtual_machine_profile_create.os_profile.windows_configuration.win_rm.listeners.Element
        _element.certificate_url = AAZStrArg(
            options=["certificate-url"],
            help="This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add). In this case, your certificate needs to be the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br> \"data\":\"<Base64-encoded-certificate>\",<br>  \"dataType\":\"pfx\",<br> \"password\":\"<pfx-file-password>\"<br>} <br> To install certificates on a virtual machine it is recommended to use the [Azure Key Vault virtual machine extension for Linux](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux) or the [Azure Key Vault virtual machine extension for Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).",
        )
        _element.protocol = AAZStrArg(
            options=["protocol"],
            help="Specifies the protocol of WinRM listener. Possible values are: **http,** **https.**",
            enum={"Http": "Http", "Https": "Https"},
        )

        scheduled_events_profile = cls._args_base_virtual_machine_profile_create.scheduled_events_profile
        scheduled_events_profile.os_image_notification_profile = AAZObjectArg(
            options=["os-image-notification-profile"],
            help="Specifies OS Image Scheduled Event related configurations.",
        )
        scheduled_events_profile.terminate_notification_profile = AAZObjectArg(
            options=["terminate-notification-profile"],
            help="Specifies Terminate Scheduled Event related configurations.",
        )

        os_image_notification_profile = cls._args_base_virtual_machine_profile_create.scheduled_events_profile.os_image_notification_profile
        os_image_notification_profile.enable = AAZBoolArg(
            options=["enable"],
            help="Specifies whether the OS Image Scheduled event is enabled or disabled.",
        )
        os_image_notification_profile.not_before_timeout = AAZStrArg(
            options=["not-before-timeout"],
            help="Length of time a Virtual Machine being reimaged or having its OS upgraded will have to potentially approve the OS Image Scheduled Event before the event is auto approved (timed out). The configuration is specified in ISO 8601 format, and the value must not exceed 15 minutes (PT15M)",
        )

        terminate_notification_profile = cls._args_base_virtual_machine_profile_create.scheduled_events_profile.terminate_notification_profile
        terminate_notification_profile.enable = AAZBoolArg(
            options=["enable"],
            help="Specifies whether the Terminate Scheduled event is enabled or disabled.",
        )
        terminate_notification_profile.not_before_timeout = AAZStrArg(
            options=["not-before-timeout"],
            help="Configurable length of time a Virtual Machine being deleted will have to potentially approve the Terminate Scheduled Event before the event is auto approved (timed out). The configuration must be specified in ISO 8601 format, the default value is 5 minutes (PT5M)",
        )

        security_posture_reference = cls._args_base_virtual_machine_profile_create.security_posture_reference
        security_posture_reference.exclude_extensions = AAZListArg(
            options=["exclude-extensions"],
            help="List of virtual machine extension names to exclude when applying the security posture.",
        )
        security_posture_reference.id = AAZStrArg(
            options=["id"],
            help="The security posture reference id in the form of /CommunityGalleries/{communityGalleryName}/securityPostures/{securityPostureName}/versions/{major.minor.patch}|{major.*}|latest",
        )
        security_posture_reference.is_overridable = AAZBoolArg(
            options=["is-overridable"],
            help="Whether the security posture can be overridden by the user.",
        )

        exclude_extensions = cls._args_base_virtual_machine_profile_create.security_posture_reference.exclude_extensions
        exclude_extensions.Element = AAZStrArg()

        security_profile = cls._args_base_virtual_machine_profile_create.security_profile
        security_profile.encryption_at_host = AAZBoolArg(
            options=["encryption-at-host"],
            help="This property can be used by user in the request to enable or disable the Host Encryption for the virtual machine or virtual machine scale set. This will enable the encryption for all the disks including Resource/Temp disk at host itself. The default behavior is: The Encryption at host will be disabled unless this property is set to true for the resource.",
        )
        security_profile.encryption_identity = AAZObjectArg(
            options=["encryption-identity"],
            help="Specifies the Managed Identity used by ADE to get access token for keyvault operations.",
        )
        security_profile.proxy_agent_settings = AAZObjectArg(
            options=["proxy-agent-settings"],
            help="Specifies ProxyAgent settings while creating the virtual machine. Minimum api-version: 2023-09-01.",
        )
        security_profile.security_type = AAZStrArg(
            options=["security-type"],
            help="Specifies the SecurityType of the virtual machine. It has to be set to any specified value to enable UefiSettings. The default behavior is: UefiSettings will not be enabled unless this property is set.",
            enum={"ConfidentialVM": "ConfidentialVM", "TrustedLaunch": "TrustedLaunch"},
        )
        security_profile.uefi_settings = AAZObjectArg(
            options=["uefi-settings"],
            help="Specifies the security settings like secure boot and vTPM used while creating the virtual machine. Minimum api-version: 2020-12-01.",
        )

        encryption_identity = cls._args_base_virtual_machine_profile_create.security_profile.encryption_identity
        encryption_identity.user_assigned_identity_resource_id = AAZResourceIdArg(
            options=["user-assigned-identity-resource-id"],
            help="Specifies ARM Resource ID of one of the user identities associated with the VM.",
        )

        proxy_agent_settings = cls._args_base_virtual_machine_profile_create.security_profile.proxy_agent_settings
        proxy_agent_settings.enabled = AAZBoolArg(
            options=["enabled"],
            help="Specifies whether ProxyAgent feature should be enabled on the virtual machine or virtual machine scale set.",
        )
        proxy_agent_settings.key_incarnation_id = AAZIntArg(
            options=["key-incarnation-id"],
            help="Increase the value of this property allows user to reset the key used for securing communication channel between guest and host.",
        )
        proxy_agent_settings.mode = AAZStrArg(
            options=["mode"],
            help="Specifies the mode that ProxyAgent will execute on if the feature is enabled. ProxyAgent will start to audit or monitor but not enforce access control over requests to host endpoints in Audit mode, while in Enforce mode it will enforce access control. The default value is Enforce mode.",
            enum={"Audit": "Audit", "Enforce": "Enforce"},
        )

        uefi_settings = cls._args_base_virtual_machine_profile_create.security_profile.uefi_settings
        uefi_settings.secure_boot_enabled = AAZBoolArg(
            options=["secure-boot-enabled"],
            help="Specifies whether secure boot should be enabled on the virtual machine. Minimum api-version: 2020-12-01.",
        )
        uefi_settings.v_tpm_enabled = AAZBoolArg(
            options=["v-tpm-enabled"],
            help="Specifies whether vTPM should be enabled on the virtual machine. Minimum api-version: 2020-12-01.",
        )

        service_artifact_reference = cls._args_base_virtual_machine_profile_create.service_artifact_reference
        service_artifact_reference.id = AAZResourceIdArg(
            options=["id"],
            help="The service artifact reference id in the form of /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/serviceArtifacts/{serviceArtifactName}/vmArtifactsProfiles/{vmArtifactsProfilesName}",
        )

        storage_profile = cls._args_base_virtual_machine_profile_create.storage_profile
        storage_profile.data_disks = AAZListArg(
            options=["data-disks"],
            help="Specifies the parameters that are used to add data disks to the virtual machines in the scale set. For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).",
        )
        storage_profile.disk_controller_type = AAZStrArg(
            options=["disk-controller-type"],
            help="Specifies the disk controller type configured for the virtual machines in the scale set. Minimum api-version: 2022-08-01",
            enum={"NVMe": "NVMe", "SCSI": "SCSI"},
        )
        storage_profile.image_reference = AAZObjectArg(
            options=["image-reference"],
            help="Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations.",
        )
        storage_profile.os_disk = AAZObjectArg(
            options=["os-disk"],
            help="Specifies information about the operating system disk used by the virtual machines in the scale set. For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).",
        )

        data_disks = cls._args_base_virtual_machine_profile_create.storage_profile.data_disks
        data_disks.Element = AAZObjectArg()

        _element = cls._args_base_virtual_machine_profile_create.storage_profile.data_disks.Element
        _element.caching = AAZStrArg(
            options=["caching"],
            help="Specifies the caching requirements. Possible values are: **None,** **ReadOnly,** **ReadWrite.** The default values are: **None for Standard storage. ReadOnly for Premium storage.**",
            enum={"None": "None", "ReadOnly": "ReadOnly", "ReadWrite": "ReadWrite"},
        )
        _element.create_option = AAZStrArg(
            options=["create-option"],
            help="The create option.",
            required=True,
            enum={"Attach": "Attach", "Copy": "Copy", "Empty": "Empty", "FromImage": "FromImage", "Restore": "Restore"},
        )
        _element.delete_option = AAZStrArg(
            options=["delete-option"],
            help="Specifies whether data disk should be deleted or detached upon VMSS Flex deletion (This feature is available for VMSS with Flexible OrchestrationMode only).<br><br> Possible values: <br><br> **Delete** If this value is used, the data disk is deleted when the VMSS Flex VM is deleted.<br><br> **Detach** If this value is used, the data disk is retained after VMSS Flex VM is deleted.<br><br> The default value is set to **Delete**.",
            enum={"Delete": "Delete", "Detach": "Detach"},
        )
        _element.disk_iops_read_write = AAZIntArg(
            options=["disk-iops-read-write"],
            help="Specifies the Read-Write IOPS for the managed disk. Should be used only when StorageAccountType is UltraSSD_LRS. If not specified, a default value would be assigned based on diskSizeGB.",
        )
        _element.disk_m_bps_read_write = AAZIntArg(
            options=["disk-m-bps-read-write"],
            help="Specifies the bandwidth in MB per second for the managed disk. Should be used only when StorageAccountType is UltraSSD_LRS. If not specified, a default value would be assigned based on diskSizeGB.",
        )
        _element.disk_size_gb = AAZIntArg(
            options=["disk-size-gb"],
            help="Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. The property diskSizeGB is the number of bytes x 1024^3 for the disk and the value cannot be larger than 1023.",
        )
        _element.lun = AAZIntArg(
            options=["lun"],
            help="Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.",
            required=True,
        )
        _element.managed_disk = AAZObjectArg(
            options=["managed-disk"],
            help="The managed disk parameters.",
        )
        cls._build_args_virtual_machine_scale_set_managed_disk_parameters_create(_element.managed_disk)
        _element.name = AAZStrArg(
            options=["name"],
            help="The disk name.",
        )
        _element.write_accelerator_enabled = AAZBoolArg(
            options=["write-accelerator-enabled"],
            help="Specifies whether writeAccelerator should be enabled or disabled on the disk.",
        )

        image_reference = cls._args_base_virtual_machine_profile_create.storage_profile.image_reference
        image_reference.community_gallery_image_id = AAZStrArg(
            options=["community-gallery-image-id"],
            help="Specified the community gallery image unique id for vm deployment. This can be fetched from community gallery image GET call.",
        )
        image_reference.id = AAZResourceIdArg(
            options=["id"],
            help="Resource Id",
        )
        image_reference.offer = AAZStrArg(
            options=["offer"],
            help="Specifies the offer of the platform image or marketplace image used to create the virtual machine.",
        )
        image_reference.publisher = AAZStrArg(
            options=["publisher"],
            help="The image publisher.",
        )
        image_reference.shared_gallery_image_id = AAZStrArg(
            options=["shared-gallery-image-id"],
            help="Specified the shared gallery image unique id for vm deployment. This can be fetched from shared gallery image GET call.",
        )
        image_reference.sku = AAZStrArg(
            options=["sku"],
            help="The image SKU.",
        )
        image_reference.version = AAZStrArg(
            options=["version"],
            help="Specifies the version of the platform image or marketplace image used to create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and Build are decimal numbers. Specify 'latest' to use the latest version of an image available at deploy time. Even if you use 'latest', the VM image will not automatically update after deploy time even if a new version becomes available. Please do not use field 'version' for gallery image deployment, gallery image should always use 'id' field for deployment, to use 'latest' version of gallery image, just set '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageName}' in the 'id' field without version input.",
        )

        os_disk = cls._args_base_virtual_machine_profile_create.storage_profile.os_disk
        os_disk.caching = AAZStrArg(
            options=["caching"],
            help="Specifies the caching requirements. Possible values are: **None,** **ReadOnly,** **ReadWrite.** The default values are: **None for Standard storage. ReadOnly for Premium storage.**",
            enum={"None": "None", "ReadOnly": "ReadOnly", "ReadWrite": "ReadWrite"},
        )
        os_disk.create_option = AAZStrArg(
            options=["create-option"],
            help="Specifies how the virtual machines in the scale set should be created. The only allowed value is: **FromImage.** This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described.",
            required=True,
            enum={"Attach": "Attach", "Copy": "Copy", "Empty": "Empty", "FromImage": "FromImage", "Restore": "Restore"},
        )
        os_disk.delete_option = AAZStrArg(
            options=["delete-option"],
            help="Specifies whether OS Disk should be deleted or detached upon VMSS Flex deletion (This feature is available for VMSS with Flexible OrchestrationMode only). <br><br> Possible values: <br><br> **Delete** If this value is used, the OS disk is deleted when VMSS Flex VM is deleted.<br><br> **Detach** If this value is used, the OS disk is retained after VMSS Flex VM is deleted. <br><br> The default value is set to **Delete**. For an Ephemeral OS Disk, the default value is set to **Delete**. User cannot change the delete option for Ephemeral OS Disk.",
            enum={"Delete": "Delete", "Detach": "Detach"},
        )
        os_disk.diff_disk_settings = AAZObjectArg(
            options=["diff-disk-settings"],
            help="Specifies the ephemeral disk Settings for the operating system disk used by the virtual machine scale set.",
        )
        os_disk.disk_size_gb = AAZIntArg(
            options=["disk-size-gb"],
            help="Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. The property 'diskSizeGB' is the number of bytes x 1024^3 for the disk and the value cannot be larger than 1023.",
        )
        os_disk.image = AAZObjectArg(
            options=["image"],
            help="Specifies information about the unmanaged user image to base the scale set on.",
        )
        os_disk.managed_disk = AAZObjectArg(
            options=["managed-disk"],
            help="The managed disk parameters.",
        )
        cls._build_args_virtual_machine_scale_set_managed_disk_parameters_create(os_disk.managed_disk)
        os_disk.name = AAZStrArg(
            options=["name"],
            help="The disk name.",
        )
        os_disk.os_type = AAZStrArg(
            options=["os-type"],
            help="This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. Possible values are: **Windows,** **Linux.**",
            enum={"Linux": "Linux", "Windows": "Windows"},
        )
        os_disk.vhd_containers = AAZListArg(
            options=["vhd-containers"],
            help="Specifies the container urls that are used to store operating system disks for the scale set.",
        )
        os_disk.write_accelerator_enabled = AAZBoolArg(
            options=["write-accelerator-enabled"],
            help="Specifies whether writeAccelerator should be enabled or disabled on the disk.",
        )

        diff_disk_settings = cls._args_base_virtual_machine_profile_create.storage_profile.os_disk.diff_disk_settings
        diff_disk_settings.option = AAZStrArg(
            options=["option"],
            help="Specifies the ephemeral disk settings for operating system disk.",
            enum={"Local": "Local"},
        )
        diff_disk_settings.placement = AAZStrArg(
            options=["placement"],
            help="Specifies the ephemeral disk placement for operating system disk. Possible values are: **CacheDisk,** **ResourceDisk.** The defaulting behavior is: **CacheDisk** if one is configured for the VM size otherwise **ResourceDisk** is used. Refer to the VM size documentation for Windows VM at https://docs.microsoft.com/azure/virtual-machines/windows/sizes and Linux VM at https://docs.microsoft.com/azure/virtual-machines/linux/sizes to check which VM sizes exposes a cache disk.",
            enum={"CacheDisk": "CacheDisk", "NvmeDisk": "NvmeDisk", "ResourceDisk": "ResourceDisk"},
        )

        image = cls._args_base_virtual_machine_profile_create.storage_profile.os_disk.image
        image.uri = AAZStrArg(
            options=["uri"],
            help="Specifies the virtual hard disk's uri.",
        )

        vhd_containers = cls._args_base_virtual_machine_profile_create.storage_profile.os_disk.vhd_containers
        vhd_containers.Element = AAZStrArg()

        _schema.application_profile = cls._args_base_virtual_machine_profile_create.application_profile
        _schema.capacity_reservation = cls._args_base_virtual_machine_profile_create.capacity_reservation
        _schema.diagnostics_profile = cls._args_base_virtual_machine_profile_create.diagnostics_profile
        _schema.extension_profile = cls._args_base_virtual_machine_profile_create.extension_profile
        _schema.hardware_profile = cls._args_base_virtual_machine_profile_create.hardware_profile
        _schema.license_type = cls._args_base_virtual_machine_profile_create.license_type
        _schema.network_profile = cls._args_base_virtual_machine_profile_create.network_profile
        _schema.os_profile = cls._args_base_virtual_machine_profile_create.os_profile
        _schema.scheduled_events_profile = cls._args_base_virtual_machine_profile_create.scheduled_events_profile
        _schema.security_posture_reference = cls._args_base_virtual_machine_profile_create.security_posture_reference
        _schema.security_profile = cls._args_base_virtual_machine_profile_create.security_profile
        _schema.service_artifact_reference = cls._args_base_virtual_machine_profile_create.service_artifact_reference
        _schema.storage_profile = cls._args_base_virtual_machine_profile_create.storage_profile
        _schema.user_data = cls._args_base_virtual_machine_profile_create.user_data

    _args_disk_encryption_set_parameters_create = None

    @classmethod
    def _build_args_disk_encryption_set_parameters_create(cls, _schema):
        if cls._args_disk_encryption_set_parameters_create is not None:
            _schema.id = cls._args_disk_encryption_set_parameters_create.id
            return

        cls._args_disk_encryption_set_parameters_create = AAZObjectArg()

        disk_encryption_set_parameters_create = cls._args_disk_encryption_set_parameters_create
        disk_encryption_set_parameters_create.id = AAZResourceIdArg(
            options=["id"],
            help="Resource Id",
        )

        _schema.id = cls._args_disk_encryption_set_parameters_create.id

    _args_sub_resource_create = None

    @classmethod
    def _build_args_sub_resource_create(cls, _schema):
        if cls._args_sub_resource_create is not None:
            _schema.id = cls._args_sub_resource_create.id
            return

        cls._args_sub_resource_create = AAZObjectArg()

        sub_resource_create = cls._args_sub_resource_create
        sub_resource_create.id = AAZResourceIdArg(
            options=["id"],
            help="Resource Id",
        )

        _schema.id = cls._args_sub_resource_create.id

    _args_vm_attribute_min_max_double_create = None

    @classmethod
    def _build_args_vm_attribute_min_max_double_create(cls, _schema):
        if cls._args_vm_attribute_min_max_double_create is not None:
            _schema.max = cls._args_vm_attribute_min_max_double_create.max
            _schema.min = cls._args_vm_attribute_min_max_double_create.min
            return

        cls._args_vm_attribute_min_max_double_create = AAZObjectArg()

        vm_attribute_min_max_double_create = cls._args_vm_attribute_min_max_double_create
        vm_attribute_min_max_double_create.max = AAZFloatArg(
            options=["max"],
            help="Maximum value. Double.MaxValue(1.7976931348623157E+308)",
            fmt=AAZFloatArgFormat(
                minimum=0.0,
            ),
        )
        vm_attribute_min_max_double_create.min = AAZFloatArg(
            options=["min"],
            help="Minimum value. default 0. Double.MinValue()",
            fmt=AAZFloatArgFormat(
                minimum=0.0,
            ),
        )

        _schema.max = cls._args_vm_attribute_min_max_double_create.max
        _schema.min = cls._args_vm_attribute_min_max_double_create.min

    _args_vm_attribute_min_max_integer_create = None

    @classmethod
    def _build_args_vm_attribute_min_max_integer_create(cls, _schema):
        if cls._args_vm_attribute_min_max_integer_create is not None:
            _schema.max = cls._args_vm_attribute_min_max_integer_create.max
            _schema.min = cls._args_vm_attribute_min_max_integer_create.min
            return

        cls._args_vm_attribute_min_max_integer_create = AAZObjectArg()

        vm_attribute_min_max_integer_create = cls._args_vm_attribute_min_max_integer_create
        vm_attribute_min_max_integer_create.max = AAZIntArg(
            options=["max"],
            help="Max VMSize from CRS, Max = 4294967295 (uint.MaxValue) if not specified.",
            fmt=AAZIntArgFormat(
                minimum=0,
            ),
        )
        vm_attribute_min_max_integer_create.min = AAZIntArg(
            options=["min"],
            help="Min VMSize from CRS, Min = 0 (uint.MinValue) if not specified.",
            fmt=AAZIntArgFormat(
                minimum=0,
            ),
        )

        _schema.max = cls._args_vm_attribute_min_max_integer_create.max
        _schema.min = cls._args_vm_attribute_min_max_integer_create.min

    _args_virtual_machine_scale_set_managed_disk_parameters_create = None

    @classmethod
    def _build_args_virtual_machine_scale_set_managed_disk_parameters_create(cls, _schema):
        if cls._args_virtual_machine_scale_set_managed_disk_parameters_create is not None:
            _schema.disk_encryption_set = cls._args_virtual_machine_scale_set_managed_disk_parameters_create.disk_encryption_set
            _schema.security_profile = cls._args_virtual_machine_scale_set_managed_disk_parameters_create.security_profile
            _schema.storage_account_type = cls._args_virtual_machine_scale_set_managed_disk_parameters_create.storage_account_type
            return

        cls._args_virtual_machine_scale_set_managed_disk_parameters_create = AAZObjectArg()

        virtual_machine_scale_set_managed_disk_parameters_create = cls._args_virtual_machine_scale_set_managed_disk_parameters_create
        virtual_machine_scale_set_managed_disk_parameters_create.disk_encryption_set = AAZObjectArg(
            options=["disk-encryption-set"],
            help="Specifies the customer managed disk encryption set resource id for the managed disk.",
        )
        cls._build_args_disk_encryption_set_parameters_create(virtual_machine_scale_set_managed_disk_parameters_create.disk_encryption_set)
        virtual_machine_scale_set_managed_disk_parameters_create.security_profile = AAZObjectArg(
            options=["security-profile"],
            help="Specifies the security profile for the managed disk.",
        )
        virtual_machine_scale_set_managed_disk_parameters_create.storage_account_type = AAZStrArg(
            options=["storage-account-type"],
            help="Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk.",
            enum={"PremiumV2_LRS": "PremiumV2_LRS", "Premium_LRS": "Premium_LRS", "Premium_ZRS": "Premium_ZRS", "StandardSSD_LRS": "StandardSSD_LRS", "StandardSSD_ZRS": "StandardSSD_ZRS", "Standard_LRS": "Standard_LRS", "UltraSSD_LRS": "UltraSSD_LRS"},
        )

        security_profile = cls._args_virtual_machine_scale_set_managed_disk_parameters_create.security_profile
        security_profile.disk_encryption_set = AAZObjectArg(
            options=["disk-encryption-set"],
            help="Specifies the customer managed disk encryption set resource id for the managed disk that is used for Customer Managed Key encrypted ConfidentialVM OS Disk and VMGuest blob.",
        )
        cls._build_args_disk_encryption_set_parameters_create(security_profile.disk_encryption_set)
        security_profile.security_encryption_type = AAZStrArg(
            options=["security-encryption-type"],
            help="Specifies the EncryptionType of the managed disk. It is set to DiskWithVMGuestState for encryption of the managed disk along with VMGuestState blob, VMGuestStateOnly for encryption of just the VMGuestState blob, and NonPersistedTPM for not persisting firmware state in the VMGuestState blob.. **Note:** It can be set for only Confidential VMs.",
            enum={"DiskWithVMGuestState": "DiskWithVMGuestState", "NonPersistedTPM": "NonPersistedTPM", "VMGuestStateOnly": "VMGuestStateOnly"},
        )

        _schema.disk_encryption_set = cls._args_virtual_machine_scale_set_managed_disk_parameters_create.disk_encryption_set
        _schema.security_profile = cls._args_virtual_machine_scale_set_managed_disk_parameters_create.security_profile
        _schema.storage_account_type = cls._args_virtual_machine_scale_set_managed_disk_parameters_create.storage_account_type

    def _execute_operations(self):
        self.pre_operations()
        yield self.FleetsCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class FleetsCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200, 201]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureFleet/fleets/{fleetName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "fleetName", self.ctx.args.fleet_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2024-11-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("identity", AAZIdentityObjectType, ".identity")
            _builder.set_prop("location", AAZStrType, ".location", typ_kwargs={"flags": {"required": True}})
            _builder.set_prop("plan", AAZObjectType, ".plan")
            _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
            _builder.set_prop("tags", AAZDictType, ".tags")
            _builder.set_prop("zones", AAZListType, ".zones")

            identity = _builder.get(".identity")
            if identity is not None:
                identity.set_prop("type", AAZStrType, ".type", typ_kwargs={"flags": {"required": True}})
                identity.set_prop("userAssignedIdentities", AAZDictType, ".user_assigned_identities")

            user_assigned_identities = _builder.get(".identity.userAssignedIdentities")
            if user_assigned_identities is not None:
                user_assigned_identities.set_elements(AAZObjectType, ".", typ_kwargs={"nullable": True})

            plan = _builder.get(".plan")
            if plan is not None:
                plan.set_prop("name", AAZStrType, ".name", typ_kwargs={"flags": {"required": True}})
                plan.set_prop("product", AAZStrType, ".product", typ_kwargs={"flags": {"required": True}})
                plan.set_prop("promotionCode", AAZStrType, ".promotion_code")
                plan.set_prop("publisher", AAZStrType, ".publisher", typ_kwargs={"flags": {"required": True}})
                plan.set_prop("version", AAZStrType, ".version")

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("additionalLocationsProfile", AAZObjectType, ".additional_locations_profile")
                properties.set_prop("computeProfile", AAZObjectType, ".compute_profile", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("regularPriorityProfile", AAZObjectType, ".regular_priority_profile")
                properties.set_prop("spotPriorityProfile", AAZObjectType, ".spot_priority_profile")
                properties.set_prop("vmAttributes", AAZObjectType, ".vm_attributes")
                properties.set_prop("vmSizesProfile", AAZListType, ".vm_sizes_profile", typ_kwargs={"flags": {"required": True}})

            additional_locations_profile = _builder.get(".properties.additionalLocationsProfile")
            if additional_locations_profile is not None:
                additional_locations_profile.set_prop("locationProfiles", AAZListType, ".location_profiles", typ_kwargs={"flags": {"required": True}})

            location_profiles = _builder.get(".properties.additionalLocationsProfile.locationProfiles")
            if location_profiles is not None:
                location_profiles.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.additionalLocationsProfile.locationProfiles[]")
            if _elements is not None:
                _elements.set_prop("location", AAZStrType, ".location", typ_kwargs={"flags": {"required": True}})
                _CreateHelper._build_schema_base_virtual_machine_profile_create(_elements.set_prop("virtualMachineProfileOverride", AAZObjectType, ".virtual_machine_profile_override"))

            compute_profile = _builder.get(".properties.computeProfile")
            if compute_profile is not None:
                compute_profile.set_prop("additionalVirtualMachineCapabilities", AAZObjectType, ".additional_virtual_machine_capabilities")
                _CreateHelper._build_schema_base_virtual_machine_profile_create(compute_profile.set_prop("baseVirtualMachineProfile", AAZObjectType, ".base_virtual_machine_profile", typ_kwargs={"flags": {"required": True}}))
                compute_profile.set_prop("computeApiVersion", AAZStrType, ".compute_api_version")
                compute_profile.set_prop("platformFaultDomainCount", AAZIntType, ".platform_fault_domain_count")

            additional_virtual_machine_capabilities = _builder.get(".properties.computeProfile.additionalVirtualMachineCapabilities")
            if additional_virtual_machine_capabilities is not None:
                additional_virtual_machine_capabilities.set_prop("hibernationEnabled", AAZBoolType, ".hibernation_enabled")
                additional_virtual_machine_capabilities.set_prop("ultraSSDEnabled", AAZBoolType, ".ultra_ssd_enabled")

            regular_priority_profile = _builder.get(".properties.regularPriorityProfile")
            if regular_priority_profile is not None:
                regular_priority_profile.set_prop("allocationStrategy", AAZStrType, ".allocation_strategy")
                regular_priority_profile.set_prop("capacity", AAZIntType, ".capacity")
                regular_priority_profile.set_prop("minCapacity", AAZIntType, ".min_capacity")

            spot_priority_profile = _builder.get(".properties.spotPriorityProfile")
            if spot_priority_profile is not None:
                spot_priority_profile.set_prop("allocationStrategy", AAZStrType, ".allocation_strategy")
                spot_priority_profile.set_prop("capacity", AAZIntType, ".capacity")
                spot_priority_profile.set_prop("evictionPolicy", AAZStrType, ".eviction_policy")
                spot_priority_profile.set_prop("maintain", AAZBoolType, ".maintain")
                spot_priority_profile.set_prop("maxPricePerVM", AAZFloatType, ".max_price_per_vm")
                spot_priority_profile.set_prop("minCapacity", AAZIntType, ".min_capacity")

            vm_attributes = _builder.get(".properties.vmAttributes")
            if vm_attributes is not None:
                _CreateHelper._build_schema_vm_attribute_min_max_integer_create(vm_attributes.set_prop("acceleratorCount", AAZObjectType, ".accelerator_count"))
                vm_attributes.set_prop("acceleratorManufacturers", AAZListType, ".accelerator_manufacturers")
                vm_attributes.set_prop("acceleratorSupport", AAZStrType, ".accelerator_support")
                vm_attributes.set_prop("acceleratorTypes", AAZListType, ".accelerator_types")
                vm_attributes.set_prop("architectureTypes", AAZListType, ".architecture_types")
                vm_attributes.set_prop("burstableSupport", AAZStrType, ".burstable_support")
                vm_attributes.set_prop("cpuManufacturers", AAZListType, ".cpu_manufacturers")
                _CreateHelper._build_schema_vm_attribute_min_max_integer_create(vm_attributes.set_prop("dataDiskCount", AAZObjectType, ".data_disk_count"))
                vm_attributes.set_prop("excludedVMSizes", AAZListType, ".excluded_vm_sizes")
                vm_attributes.set_prop("localStorageDiskTypes", AAZListType, ".local_storage_disk_types")
                _CreateHelper._build_schema_vm_attribute_min_max_double_create(vm_attributes.set_prop("localStorageInGiB", AAZObjectType, ".local_storage_in_gi_b"))
                vm_attributes.set_prop("localStorageSupport", AAZStrType, ".local_storage_support")
                _CreateHelper._build_schema_vm_attribute_min_max_double_create(vm_attributes.set_prop("memoryInGiB", AAZObjectType, ".memory_in_gi_b", typ_kwargs={"flags": {"required": True}}))
                _CreateHelper._build_schema_vm_attribute_min_max_double_create(vm_attributes.set_prop("memoryInGiBPerVCpu", AAZObjectType, ".memory_in_gi_b_per_v_cpu"))
                _CreateHelper._build_schema_vm_attribute_min_max_double_create(vm_attributes.set_prop("networkBandwidthInMbps", AAZObjectType, ".network_bandwidth_in_mbps"))
                _CreateHelper._build_schema_vm_attribute_min_max_integer_create(vm_attributes.set_prop("networkInterfaceCount", AAZObjectType, ".network_interface_count"))
                _CreateHelper._build_schema_vm_attribute_min_max_integer_create(vm_attributes.set_prop("rdmaNetworkInterfaceCount", AAZObjectType, ".rdma_network_interface_count"))
                vm_attributes.set_prop("rdmaSupport", AAZStrType, ".rdma_support")
                _CreateHelper._build_schema_vm_attribute_min_max_integer_create(vm_attributes.set_prop("vCpuCount", AAZObjectType, ".v_cpu_count", typ_kwargs={"flags": {"required": True}}))
                vm_attributes.set_prop("vmCategories", AAZListType, ".vm_categories")

            accelerator_manufacturers = _builder.get(".properties.vmAttributes.acceleratorManufacturers")
            if accelerator_manufacturers is not None:
                accelerator_manufacturers.set_elements(AAZStrType, ".")

            accelerator_types = _builder.get(".properties.vmAttributes.acceleratorTypes")
            if accelerator_types is not None:
                accelerator_types.set_elements(AAZStrType, ".")

            architecture_types = _builder.get(".properties.vmAttributes.architectureTypes")
            if architecture_types is not None:
                architecture_types.set_elements(AAZStrType, ".")

            cpu_manufacturers = _builder.get(".properties.vmAttributes.cpuManufacturers")
            if cpu_manufacturers is not None:
                cpu_manufacturers.set_elements(AAZStrType, ".")

            excluded_vm_sizes = _builder.get(".properties.vmAttributes.excludedVMSizes")
            if excluded_vm_sizes is not None:
                excluded_vm_sizes.set_elements(AAZStrType, ".")

            local_storage_disk_types = _builder.get(".properties.vmAttributes.localStorageDiskTypes")
            if local_storage_disk_types is not None:
                local_storage_disk_types.set_elements(AAZStrType, ".")

            vm_categories = _builder.get(".properties.vmAttributes.vmCategories")
            if vm_categories is not None:
                vm_categories.set_elements(AAZStrType, ".")

            vm_sizes_profile = _builder.get(".properties.vmSizesProfile")
            if vm_sizes_profile is not None:
                vm_sizes_profile.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.vmSizesProfile[]")
            if _elements is not None:
                _elements.set_prop("name", AAZStrType, ".name", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("rank", AAZIntType, ".rank")

            tags = _builder.get(".tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            zones = _builder.get(".zones")
            if zones is not None:
                zones.set_elements(AAZStrType, ".")

            return self.serialize_content(_content_value)

        def on_200_201(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200_201
            )

        _schema_on_200_201 = None

        @classmethod
        def _build_schema_on_200_201(cls):
            if cls._schema_on_200_201 is not None:
                return cls._schema_on_200_201

            cls._schema_on_200_201 = AAZObjectType()

            _schema_on_200_201 = cls._schema_on_200_201
            _schema_on_200_201.id = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200_201.identity = AAZIdentityObjectType()
            _schema_on_200_201.location = AAZStrType(
                flags={"required": True},
            )
            _schema_on_200_201.name = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200_201.plan = AAZObjectType()
            _schema_on_200_201.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _schema_on_200_201.system_data = AAZObjectType(
                serialized_name="systemData",
                flags={"read_only": True},
            )
            _schema_on_200_201.tags = AAZDictType()
            _schema_on_200_201.type = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200_201.zones = AAZListType()

            identity = cls._schema_on_200_201.identity
            identity.principal_id = AAZStrType(
                serialized_name="principalId",
                flags={"read_only": True},
            )
            identity.tenant_id = AAZStrType(
                serialized_name="tenantId",
                flags={"read_only": True},
            )
            identity.type = AAZStrType(
                flags={"required": True},
            )
            identity.user_assigned_identities = AAZDictType(
                serialized_name="userAssignedIdentities",
            )

            user_assigned_identities = cls._schema_on_200_201.identity.user_assigned_identities
            user_assigned_identities.Element = AAZObjectType(
                nullable=True,
            )

            _element = cls._schema_on_200_201.identity.user_assigned_identities.Element
            _element.client_id = AAZStrType(
                serialized_name="clientId",
                flags={"read_only": True},
            )
            _element.principal_id = AAZStrType(
                serialized_name="principalId",
                flags={"read_only": True},
            )

            plan = cls._schema_on_200_201.plan
            plan.name = AAZStrType(
                flags={"required": True},
            )
            plan.product = AAZStrType(
                flags={"required": True},
            )
            plan.promotion_code = AAZStrType(
                serialized_name="promotionCode",
            )
            plan.publisher = AAZStrType(
                flags={"required": True},
            )
            plan.version = AAZStrType()

            properties = cls._schema_on_200_201.properties
            properties.additional_locations_profile = AAZObjectType(
                serialized_name="additionalLocationsProfile",
            )
            properties.compute_profile = AAZObjectType(
                serialized_name="computeProfile",
                flags={"required": True},
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.regular_priority_profile = AAZObjectType(
                serialized_name="regularPriorityProfile",
            )
            properties.spot_priority_profile = AAZObjectType(
                serialized_name="spotPriorityProfile",
            )
            properties.time_created = AAZStrType(
                serialized_name="timeCreated",
                flags={"read_only": True},
            )
            properties.unique_id = AAZStrType(
                serialized_name="uniqueId",
                flags={"read_only": True},
            )
            properties.vm_attributes = AAZObjectType(
                serialized_name="vmAttributes",
            )
            properties.vm_sizes_profile = AAZListType(
                serialized_name="vmSizesProfile",
                flags={"required": True},
            )

            additional_locations_profile = cls._schema_on_200_201.properties.additional_locations_profile
            additional_locations_profile.location_profiles = AAZListType(
                serialized_name="locationProfiles",
                flags={"required": True},
            )

            location_profiles = cls._schema_on_200_201.properties.additional_locations_profile.location_profiles
            location_profiles.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.additional_locations_profile.location_profiles.Element
            _element.location = AAZStrType(
                flags={"required": True},
            )
            _element.virtual_machine_profile_override = AAZObjectType(
                serialized_name="virtualMachineProfileOverride",
            )
            _CreateHelper._build_schema_base_virtual_machine_profile_read(_element.virtual_machine_profile_override)

            compute_profile = cls._schema_on_200_201.properties.compute_profile
            compute_profile.additional_virtual_machine_capabilities = AAZObjectType(
                serialized_name="additionalVirtualMachineCapabilities",
            )
            compute_profile.base_virtual_machine_profile = AAZObjectType(
                serialized_name="baseVirtualMachineProfile",
                flags={"required": True},
            )
            _CreateHelper._build_schema_base_virtual_machine_profile_read(compute_profile.base_virtual_machine_profile)
            compute_profile.compute_api_version = AAZStrType(
                serialized_name="computeApiVersion",
            )
            compute_profile.platform_fault_domain_count = AAZIntType(
                serialized_name="platformFaultDomainCount",
            )

            additional_virtual_machine_capabilities = cls._schema_on_200_201.properties.compute_profile.additional_virtual_machine_capabilities
            additional_virtual_machine_capabilities.hibernation_enabled = AAZBoolType(
                serialized_name="hibernationEnabled",
            )
            additional_virtual_machine_capabilities.ultra_ssd_enabled = AAZBoolType(
                serialized_name="ultraSSDEnabled",
            )

            regular_priority_profile = cls._schema_on_200_201.properties.regular_priority_profile
            regular_priority_profile.allocation_strategy = AAZStrType(
                serialized_name="allocationStrategy",
            )
            regular_priority_profile.capacity = AAZIntType()
            regular_priority_profile.min_capacity = AAZIntType(
                serialized_name="minCapacity",
            )

            spot_priority_profile = cls._schema_on_200_201.properties.spot_priority_profile
            spot_priority_profile.allocation_strategy = AAZStrType(
                serialized_name="allocationStrategy",
            )
            spot_priority_profile.capacity = AAZIntType()
            spot_priority_profile.eviction_policy = AAZStrType(
                serialized_name="evictionPolicy",
            )
            spot_priority_profile.maintain = AAZBoolType()
            spot_priority_profile.max_price_per_vm = AAZFloatType(
                serialized_name="maxPricePerVM",
            )
            spot_priority_profile.min_capacity = AAZIntType(
                serialized_name="minCapacity",
            )

            vm_attributes = cls._schema_on_200_201.properties.vm_attributes
            vm_attributes.accelerator_count = AAZObjectType(
                serialized_name="acceleratorCount",
            )
            _CreateHelper._build_schema_vm_attribute_min_max_integer_read(vm_attributes.accelerator_count)
            vm_attributes.accelerator_manufacturers = AAZListType(
                serialized_name="acceleratorManufacturers",
            )
            vm_attributes.accelerator_support = AAZStrType(
                serialized_name="acceleratorSupport",
            )
            vm_attributes.accelerator_types = AAZListType(
                serialized_name="acceleratorTypes",
            )
            vm_attributes.architecture_types = AAZListType(
                serialized_name="architectureTypes",
            )
            vm_attributes.burstable_support = AAZStrType(
                serialized_name="burstableSupport",
            )
            vm_attributes.cpu_manufacturers = AAZListType(
                serialized_name="cpuManufacturers",
            )
            vm_attributes.data_disk_count = AAZObjectType(
                serialized_name="dataDiskCount",
            )
            _CreateHelper._build_schema_vm_attribute_min_max_integer_read(vm_attributes.data_disk_count)
            vm_attributes.excluded_vm_sizes = AAZListType(
                serialized_name="excludedVMSizes",
            )
            vm_attributes.local_storage_disk_types = AAZListType(
                serialized_name="localStorageDiskTypes",
            )
            vm_attributes.local_storage_in_gi_b = AAZObjectType(
                serialized_name="localStorageInGiB",
            )
            _CreateHelper._build_schema_vm_attribute_min_max_double_read(vm_attributes.local_storage_in_gi_b)
            vm_attributes.local_storage_support = AAZStrType(
                serialized_name="localStorageSupport",
            )
            vm_attributes.memory_in_gi_b = AAZObjectType(
                serialized_name="memoryInGiB",
                flags={"required": True},
            )
            _CreateHelper._build_schema_vm_attribute_min_max_double_read(vm_attributes.memory_in_gi_b)
            vm_attributes.memory_in_gi_b_per_v_cpu = AAZObjectType(
                serialized_name="memoryInGiBPerVCpu",
            )
            _CreateHelper._build_schema_vm_attribute_min_max_double_read(vm_attributes.memory_in_gi_b_per_v_cpu)
            vm_attributes.network_bandwidth_in_mbps = AAZObjectType(
                serialized_name="networkBandwidthInMbps",
            )
            _CreateHelper._build_schema_vm_attribute_min_max_double_read(vm_attributes.network_bandwidth_in_mbps)
            vm_attributes.network_interface_count = AAZObjectType(
                serialized_name="networkInterfaceCount",
            )
            _CreateHelper._build_schema_vm_attribute_min_max_integer_read(vm_attributes.network_interface_count)
            vm_attributes.rdma_network_interface_count = AAZObjectType(
                serialized_name="rdmaNetworkInterfaceCount",
            )
            _CreateHelper._build_schema_vm_attribute_min_max_integer_read(vm_attributes.rdma_network_interface_count)
            vm_attributes.rdma_support = AAZStrType(
                serialized_name="rdmaSupport",
            )
            vm_attributes.v_cpu_count = AAZObjectType(
                serialized_name="vCpuCount",
                flags={"required": True},
            )
            _CreateHelper._build_schema_vm_attribute_min_max_integer_read(vm_attributes.v_cpu_count)
            vm_attributes.vm_categories = AAZListType(
                serialized_name="vmCategories",
            )

            accelerator_manufacturers = cls._schema_on_200_201.properties.vm_attributes.accelerator_manufacturers
            accelerator_manufacturers.Element = AAZStrType()

            accelerator_types = cls._schema_on_200_201.properties.vm_attributes.accelerator_types
            accelerator_types.Element = AAZStrType()

            architecture_types = cls._schema_on_200_201.properties.vm_attributes.architecture_types
            architecture_types.Element = AAZStrType()

            cpu_manufacturers = cls._schema_on_200_201.properties.vm_attributes.cpu_manufacturers
            cpu_manufacturers.Element = AAZStrType()

            excluded_vm_sizes = cls._schema_on_200_201.properties.vm_attributes.excluded_vm_sizes
            excluded_vm_sizes.Element = AAZStrType()

            local_storage_disk_types = cls._schema_on_200_201.properties.vm_attributes.local_storage_disk_types
            local_storage_disk_types.Element = AAZStrType()

            vm_categories = cls._schema_on_200_201.properties.vm_attributes.vm_categories
            vm_categories.Element = AAZStrType()

            vm_sizes_profile = cls._schema_on_200_201.properties.vm_sizes_profile
            vm_sizes_profile.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.vm_sizes_profile.Element
            _element.name = AAZStrType(
                flags={"required": True},
            )
            _element.rank = AAZIntType()

            system_data = cls._schema_on_200_201.system_data
            system_data.created_at = AAZStrType(
                serialized_name="createdAt",
            )
            system_data.created_by = AAZStrType(
                serialized_name="createdBy",
            )
            system_data.created_by_type = AAZStrType(
                serialized_name="createdByType",
            )
            system_data.last_modified_at = AAZStrType(
                serialized_name="lastModifiedAt",
            )
            system_data.last_modified_by = AAZStrType(
                serialized_name="lastModifiedBy",
            )
            system_data.last_modified_by_type = AAZStrType(
                serialized_name="lastModifiedByType",
            )

            tags = cls._schema_on_200_201.tags
            tags.Element = AAZStrType()

            zones = cls._schema_on_200_201.zones
            zones.Element = AAZStrType()

            return cls._schema_on_200_201


class _CreateHelper:
    """Helper class for Create"""

    @classmethod
    def _build_schema_api_entity_reference_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("id", AAZStrType, ".id")

    @classmethod
    def _build_schema_base_virtual_machine_profile_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("applicationProfile", AAZObjectType, ".application_profile")
        _builder.set_prop("capacityReservation", AAZObjectType, ".capacity_reservation")
        _builder.set_prop("diagnosticsProfile", AAZObjectType, ".diagnostics_profile")
        _builder.set_prop("extensionProfile", AAZObjectType, ".extension_profile")
        _builder.set_prop("hardwareProfile", AAZObjectType, ".hardware_profile")
        _builder.set_prop("licenseType", AAZStrType, ".license_type")
        _builder.set_prop("networkProfile", AAZObjectType, ".network_profile")
        _builder.set_prop("osProfile", AAZObjectType, ".os_profile")
        _builder.set_prop("scheduledEventsProfile", AAZObjectType, ".scheduled_events_profile")
        _builder.set_prop("securityPostureReference", AAZObjectType, ".security_posture_reference")
        _builder.set_prop("securityProfile", AAZObjectType, ".security_profile")
        _builder.set_prop("serviceArtifactReference", AAZObjectType, ".service_artifact_reference")
        _builder.set_prop("storageProfile", AAZObjectType, ".storage_profile")
        _builder.set_prop("userData", AAZStrType, ".user_data")

        application_profile = _builder.get(".applicationProfile")
        if application_profile is not None:
            application_profile.set_prop("galleryApplications", AAZListType, ".gallery_applications")

        gallery_applications = _builder.get(".applicationProfile.galleryApplications")
        if gallery_applications is not None:
            gallery_applications.set_elements(AAZObjectType, ".")

        _elements = _builder.get(".applicationProfile.galleryApplications[]")
        if _elements is not None:
            _elements.set_prop("configurationReference", AAZStrType, ".configuration_reference")
            _elements.set_prop("enableAutomaticUpgrade", AAZBoolType, ".enable_automatic_upgrade")
            _elements.set_prop("order", AAZIntType, ".order")
            _elements.set_prop("packageReferenceId", AAZStrType, ".package_reference_id", typ_kwargs={"flags": {"required": True}})
            _elements.set_prop("tags", AAZStrType, ".tags")
            _elements.set_prop("treatFailureAsDeploymentFailure", AAZBoolType, ".treat_failure_as_deployment_failure")

        capacity_reservation = _builder.get(".capacityReservation")
        if capacity_reservation is not None:
            cls._build_schema_sub_resource_create(capacity_reservation.set_prop("capacityReservationGroup", AAZObjectType, ".capacity_reservation_group"))

        diagnostics_profile = _builder.get(".diagnosticsProfile")
        if diagnostics_profile is not None:
            diagnostics_profile.set_prop("bootDiagnostics", AAZObjectType, ".boot_diagnostics")

        boot_diagnostics = _builder.get(".diagnosticsProfile.bootDiagnostics")
        if boot_diagnostics is not None:
            boot_diagnostics.set_prop("enabled", AAZBoolType, ".enabled")
            boot_diagnostics.set_prop("storageUri", AAZStrType, ".storage_uri")

        extension_profile = _builder.get(".extensionProfile")
        if extension_profile is not None:
            extension_profile.set_prop("extensions", AAZListType, ".extensions")
            extension_profile.set_prop("extensionsTimeBudget", AAZStrType, ".extensions_time_budget")

        extensions = _builder.get(".extensionProfile.extensions")
        if extensions is not None:
            extensions.set_elements(AAZObjectType, ".")

        _elements = _builder.get(".extensionProfile.extensions[]")
        if _elements is not None:
            _elements.set_prop("name", AAZStrType, ".name")
            _elements.set_prop("properties", AAZObjectType)

        properties = _builder.get(".extensionProfile.extensions[].properties")
        if properties is not None:
            properties.set_prop("autoUpgradeMinorVersion", AAZBoolType, ".auto_upgrade_minor_version")
            properties.set_prop("enableAutomaticUpgrade", AAZBoolType, ".enable_automatic_upgrade")
            properties.set_prop("forceUpdateTag", AAZStrType, ".force_update_tag")
            properties.set_prop("protectedSettings", AAZFreeFormDictType, ".protected_settings", typ_kwargs={"flags": {"secret": True}})
            properties.set_prop("protectedSettingsFromKeyVault", AAZObjectType, ".protected_settings_from_key_vault")
            properties.set_prop("provisionAfterExtensions", AAZListType, ".provision_after_extensions")
            properties.set_prop("publisher", AAZStrType, ".publisher")
            properties.set_prop("settings", AAZFreeFormDictType, ".settings")
            properties.set_prop("suppressFailures", AAZBoolType, ".suppress_failures")
            properties.set_prop("type", AAZStrType, ".type")
            properties.set_prop("typeHandlerVersion", AAZStrType, ".type_handler_version")

        protected_settings = _builder.get(".extensionProfile.extensions[].properties.protectedSettings")
        if protected_settings is not None:
            protected_settings.set_anytype_elements(".")

        protected_settings_from_key_vault = _builder.get(".extensionProfile.extensions[].properties.protectedSettingsFromKeyVault")
        if protected_settings_from_key_vault is not None:
            protected_settings_from_key_vault.set_prop("secretUrl", AAZStrType, ".secret_url", typ_kwargs={"flags": {"required": True}})
            cls._build_schema_sub_resource_create(protected_settings_from_key_vault.set_prop("sourceVault", AAZObjectType, ".source_vault", typ_kwargs={"flags": {"required": True}}))

        provision_after_extensions = _builder.get(".extensionProfile.extensions[].properties.provisionAfterExtensions")
        if provision_after_extensions is not None:
            provision_after_extensions.set_elements(AAZStrType, ".")

        settings = _builder.get(".extensionProfile.extensions[].properties.settings")
        if settings is not None:
            settings.set_anytype_elements(".")

        hardware_profile = _builder.get(".hardwareProfile")
        if hardware_profile is not None:
            hardware_profile.set_prop("vmSizeProperties", AAZObjectType, ".vm_size_properties")

        vm_size_properties = _builder.get(".hardwareProfile.vmSizeProperties")
        if vm_size_properties is not None:
            vm_size_properties.set_prop("vCPUsAvailable", AAZIntType, ".v_cp_us_available")
            vm_size_properties.set_prop("vCPUsPerCore", AAZIntType, ".v_cp_us_per_core")

        network_profile = _builder.get(".networkProfile")
        if network_profile is not None:
            cls._build_schema_api_entity_reference_create(network_profile.set_prop("healthProbe", AAZObjectType, ".health_probe"))
            network_profile.set_prop("networkApiVersion", AAZStrType, ".network_api_version")
            network_profile.set_prop("networkInterfaceConfigurations", AAZListType, ".network_interface_configurations")

        network_interface_configurations = _builder.get(".networkProfile.networkInterfaceConfigurations")
        if network_interface_configurations is not None:
            network_interface_configurations.set_elements(AAZObjectType, ".")

        _elements = _builder.get(".networkProfile.networkInterfaceConfigurations[]")
        if _elements is not None:
            _elements.set_prop("name", AAZStrType, ".name", typ_kwargs={"flags": {"required": True}})
            _elements.set_prop("properties", AAZObjectType)

        properties = _builder.get(".networkProfile.networkInterfaceConfigurations[].properties")
        if properties is not None:
            properties.set_prop("auxiliaryMode", AAZStrType, ".auxiliary_mode")
            properties.set_prop("auxiliarySku", AAZStrType, ".auxiliary_sku")
            properties.set_prop("deleteOption", AAZStrType, ".delete_option")
            properties.set_prop("disableTcpStateTracking", AAZBoolType, ".disable_tcp_state_tracking")
            properties.set_prop("dnsSettings", AAZObjectType, ".dns_settings")
            properties.set_prop("enableAcceleratedNetworking", AAZBoolType, ".enable_accelerated_networking")
            properties.set_prop("enableFpga", AAZBoolType, ".enable_fpga")
            properties.set_prop("enableIPForwarding", AAZBoolType, ".enable_ip_forwarding")
            properties.set_prop("ipConfigurations", AAZListType, ".ip_configurations", typ_kwargs={"flags": {"required": True}})
            cls._build_schema_sub_resource_create(properties.set_prop("networkSecurityGroup", AAZObjectType, ".network_security_group"))
            properties.set_prop("primary", AAZBoolType, ".primary")

        dns_settings = _builder.get(".networkProfile.networkInterfaceConfigurations[].properties.dnsSettings")
        if dns_settings is not None:
            dns_settings.set_prop("dnsServers", AAZListType, ".dns_servers")

        dns_servers = _builder.get(".networkProfile.networkInterfaceConfigurations[].properties.dnsSettings.dnsServers")
        if dns_servers is not None:
            dns_servers.set_elements(AAZStrType, ".")

        ip_configurations = _builder.get(".networkProfile.networkInterfaceConfigurations[].properties.ipConfigurations")
        if ip_configurations is not None:
            ip_configurations.set_elements(AAZObjectType, ".")

        _elements = _builder.get(".networkProfile.networkInterfaceConfigurations[].properties.ipConfigurations[]")
        if _elements is not None:
            _elements.set_prop("name", AAZStrType, ".name", typ_kwargs={"flags": {"required": True}})
            _elements.set_prop("properties", AAZObjectType)

        properties = _builder.get(".networkProfile.networkInterfaceConfigurations[].properties.ipConfigurations[].properties")
        if properties is not None:
            properties.set_prop("applicationGatewayBackendAddressPools", AAZListType, ".application_gateway_backend_address_pools")
            properties.set_prop("applicationSecurityGroups", AAZListType, ".application_security_groups")
            properties.set_prop("loadBalancerBackendAddressPools", AAZListType, ".load_balancer_backend_address_pools")
            properties.set_prop("loadBalancerInboundNatPools", AAZListType, ".load_balancer_inbound_nat_pools")
            properties.set_prop("primary", AAZBoolType, ".primary")
            properties.set_prop("privateIPAddressVersion", AAZStrType, ".private_ip_address_version")
            properties.set_prop("publicIPAddressConfiguration", AAZObjectType, ".public_ip_address_configuration")
            cls._build_schema_api_entity_reference_create(properties.set_prop("subnet", AAZObjectType, ".subnet"))

        application_gateway_backend_address_pools = _builder.get(".networkProfile.networkInterfaceConfigurations[].properties.ipConfigurations[].properties.applicationGatewayBackendAddressPools")
        if application_gateway_backend_address_pools is not None:
            cls._build_schema_sub_resource_create(application_gateway_backend_address_pools.set_elements(AAZObjectType, "."))

        application_security_groups = _builder.get(".networkProfile.networkInterfaceConfigurations[].properties.ipConfigurations[].properties.applicationSecurityGroups")
        if application_security_groups is not None:
            cls._build_schema_sub_resource_create(application_security_groups.set_elements(AAZObjectType, "."))

        load_balancer_backend_address_pools = _builder.get(".networkProfile.networkInterfaceConfigurations[].properties.ipConfigurations[].properties.loadBalancerBackendAddressPools")
        if load_balancer_backend_address_pools is not None:
            cls._build_schema_sub_resource_create(load_balancer_backend_address_pools.set_elements(AAZObjectType, "."))

        load_balancer_inbound_nat_pools = _builder.get(".networkProfile.networkInterfaceConfigurations[].properties.ipConfigurations[].properties.loadBalancerInboundNatPools")
        if load_balancer_inbound_nat_pools is not None:
            cls._build_schema_sub_resource_create(load_balancer_inbound_nat_pools.set_elements(AAZObjectType, "."))

        public_ip_address_configuration = _builder.get(".networkProfile.networkInterfaceConfigurations[].properties.ipConfigurations[].properties.publicIPAddressConfiguration")
        if public_ip_address_configuration is not None:
            public_ip_address_configuration.set_prop("name", AAZStrType, ".name", typ_kwargs={"flags": {"required": True}})
            public_ip_address_configuration.set_prop("properties", AAZObjectType)
            public_ip_address_configuration.set_prop("sku", AAZObjectType, ".sku")

        properties = _builder.get(".networkProfile.networkInterfaceConfigurations[].properties.ipConfigurations[].properties.publicIPAddressConfiguration.properties")
        if properties is not None:
            properties.set_prop("deleteOption", AAZStrType, ".delete_option")
            properties.set_prop("dnsSettings", AAZObjectType, ".dns_settings")
            properties.set_prop("idleTimeoutInMinutes", AAZIntType, ".idle_timeout_in_minutes")
            properties.set_prop("ipTags", AAZListType, ".ip_tags")
            properties.set_prop("publicIPAddressVersion", AAZStrType, ".public_ip_address_version")
            cls._build_schema_sub_resource_create(properties.set_prop("publicIPPrefix", AAZObjectType, ".public_ip_prefix"))

        dns_settings = _builder.get(".networkProfile.networkInterfaceConfigurations[].properties.ipConfigurations[].properties.publicIPAddressConfiguration.properties.dnsSettings")
        if dns_settings is not None:
            dns_settings.set_prop("domainNameLabel", AAZStrType, ".domain_name_label", typ_kwargs={"flags": {"required": True}})
            dns_settings.set_prop("domainNameLabelScope", AAZStrType, ".domain_name_label_scope")

        ip_tags = _builder.get(".networkProfile.networkInterfaceConfigurations[].properties.ipConfigurations[].properties.publicIPAddressConfiguration.properties.ipTags")
        if ip_tags is not None:
            ip_tags.set_elements(AAZObjectType, ".")

        _elements = _builder.get(".networkProfile.networkInterfaceConfigurations[].properties.ipConfigurations[].properties.publicIPAddressConfiguration.properties.ipTags[]")
        if _elements is not None:
            _elements.set_prop("ipTagType", AAZStrType, ".ip_tag_type")
            _elements.set_prop("tag", AAZStrType, ".tag")

        sku = _builder.get(".networkProfile.networkInterfaceConfigurations[].properties.ipConfigurations[].properties.publicIPAddressConfiguration.sku")
        if sku is not None:
            sku.set_prop("name", AAZStrType, ".name")
            sku.set_prop("tier", AAZStrType, ".tier")

        os_profile = _builder.get(".osProfile")
        if os_profile is not None:
            os_profile.set_prop("adminPassword", AAZStrType, ".admin_password", typ_kwargs={"flags": {"secret": True}})
            os_profile.set_prop("adminUsername", AAZStrType, ".admin_username")
            os_profile.set_prop("allowExtensionOperations", AAZBoolType, ".allow_extension_operations")
            os_profile.set_prop("computerNamePrefix", AAZStrType, ".computer_name_prefix")
            os_profile.set_prop("customData", AAZStrType, ".custom_data", typ_kwargs={"flags": {"secret": True}})
            os_profile.set_prop("linuxConfiguration", AAZObjectType, ".linux_configuration")
            os_profile.set_prop("requireGuestProvisionSignal", AAZBoolType, ".require_guest_provision_signal")
            os_profile.set_prop("secrets", AAZListType, ".secrets")
            os_profile.set_prop("windowsConfiguration", AAZObjectType, ".windows_configuration")

        linux_configuration = _builder.get(".osProfile.linuxConfiguration")
        if linux_configuration is not None:
            linux_configuration.set_prop("disablePasswordAuthentication", AAZBoolType, ".disable_password_authentication")
            linux_configuration.set_prop("enableVMAgentPlatformUpdates", AAZBoolType, ".enable_vm_agent_platform_updates")
            linux_configuration.set_prop("patchSettings", AAZObjectType, ".patch_settings")
            linux_configuration.set_prop("provisionVMAgent", AAZBoolType, ".provision_vm_agent")
            linux_configuration.set_prop("ssh", AAZObjectType, ".ssh")

        patch_settings = _builder.get(".osProfile.linuxConfiguration.patchSettings")
        if patch_settings is not None:
            patch_settings.set_prop("assessmentMode", AAZStrType, ".assessment_mode")
            patch_settings.set_prop("automaticByPlatformSettings", AAZObjectType, ".automatic_by_platform_settings")
            patch_settings.set_prop("patchMode", AAZStrType, ".patch_mode")

        automatic_by_platform_settings = _builder.get(".osProfile.linuxConfiguration.patchSettings.automaticByPlatformSettings")
        if automatic_by_platform_settings is not None:
            automatic_by_platform_settings.set_prop("bypassPlatformSafetyChecksOnUserSchedule", AAZBoolType, ".bypass_platform_safety_checks_on_user_schedule")
            automatic_by_platform_settings.set_prop("rebootSetting", AAZStrType, ".reboot_setting")

        ssh = _builder.get(".osProfile.linuxConfiguration.ssh")
        if ssh is not None:
            ssh.set_prop("publicKeys", AAZListType, ".public_keys")

        public_keys = _builder.get(".osProfile.linuxConfiguration.ssh.publicKeys")
        if public_keys is not None:
            public_keys.set_elements(AAZObjectType, ".")

        _elements = _builder.get(".osProfile.linuxConfiguration.ssh.publicKeys[]")
        if _elements is not None:
            _elements.set_prop("keyData", AAZStrType, ".key_data")
            _elements.set_prop("path", AAZStrType, ".path")

        secrets = _builder.get(".osProfile.secrets")
        if secrets is not None:
            secrets.set_elements(AAZObjectType, ".")

        _elements = _builder.get(".osProfile.secrets[]")
        if _elements is not None:
            cls._build_schema_sub_resource_create(_elements.set_prop("sourceVault", AAZObjectType, ".source_vault"))
            _elements.set_prop("vaultCertificates", AAZListType, ".vault_certificates")

        vault_certificates = _builder.get(".osProfile.secrets[].vaultCertificates")
        if vault_certificates is not None:
            vault_certificates.set_elements(AAZObjectType, ".")

        _elements = _builder.get(".osProfile.secrets[].vaultCertificates[]")
        if _elements is not None:
            _elements.set_prop("certificateStore", AAZStrType, ".certificate_store")
            _elements.set_prop("certificateUrl", AAZStrType, ".certificate_url")

        windows_configuration = _builder.get(".osProfile.windowsConfiguration")
        if windows_configuration is not None:
            windows_configuration.set_prop("additionalUnattendContent", AAZListType, ".additional_unattend_content")
            windows_configuration.set_prop("enableAutomaticUpdates", AAZBoolType, ".enable_automatic_updates")
            windows_configuration.set_prop("enableVMAgentPlatformUpdates", AAZBoolType, ".enable_vm_agent_platform_updates")
            windows_configuration.set_prop("patchSettings", AAZObjectType, ".patch_settings")
            windows_configuration.set_prop("provisionVMAgent", AAZBoolType, ".provision_vm_agent")
            windows_configuration.set_prop("timeZone", AAZStrType, ".time_zone")
            windows_configuration.set_prop("winRM", AAZObjectType, ".win_rm")

        additional_unattend_content = _builder.get(".osProfile.windowsConfiguration.additionalUnattendContent")
        if additional_unattend_content is not None:
            additional_unattend_content.set_elements(AAZObjectType, ".")

        _elements = _builder.get(".osProfile.windowsConfiguration.additionalUnattendContent[]")
        if _elements is not None:
            _elements.set_prop("componentName", AAZStrType, ".component_name")
            _elements.set_prop("content", AAZStrType, ".content", typ_kwargs={"flags": {"secret": True}})
            _elements.set_prop("passName", AAZStrType, ".pass_name")
            _elements.set_prop("settingName", AAZStrType, ".setting_name")

        patch_settings = _builder.get(".osProfile.windowsConfiguration.patchSettings")
        if patch_settings is not None:
            patch_settings.set_prop("assessmentMode", AAZStrType, ".assessment_mode")
            patch_settings.set_prop("automaticByPlatformSettings", AAZObjectType, ".automatic_by_platform_settings")
            patch_settings.set_prop("enableHotpatching", AAZBoolType, ".enable_hotpatching")
            patch_settings.set_prop("patchMode", AAZStrType, ".patch_mode")

        automatic_by_platform_settings = _builder.get(".osProfile.windowsConfiguration.patchSettings.automaticByPlatformSettings")
        if automatic_by_platform_settings is not None:
            automatic_by_platform_settings.set_prop("bypassPlatformSafetyChecksOnUserSchedule", AAZBoolType, ".bypass_platform_safety_checks_on_user_schedule")
            automatic_by_platform_settings.set_prop("rebootSetting", AAZStrType, ".reboot_setting")

        win_rm = _builder.get(".osProfile.windowsConfiguration.winRM")
        if win_rm is not None:
            win_rm.set_prop("listeners", AAZListType, ".listeners")

        listeners = _builder.get(".osProfile.windowsConfiguration.winRM.listeners")
        if listeners is not None:
            listeners.set_elements(AAZObjectType, ".")

        _elements = _builder.get(".osProfile.windowsConfiguration.winRM.listeners[]")
        if _elements is not None:
            _elements.set_prop("certificateUrl", AAZStrType, ".certificate_url")
            _elements.set_prop("protocol", AAZStrType, ".protocol")

        scheduled_events_profile = _builder.get(".scheduledEventsProfile")
        if scheduled_events_profile is not None:
            scheduled_events_profile.set_prop("osImageNotificationProfile", AAZObjectType, ".os_image_notification_profile")
            scheduled_events_profile.set_prop("terminateNotificationProfile", AAZObjectType, ".terminate_notification_profile")

        os_image_notification_profile = _builder.get(".scheduledEventsProfile.osImageNotificationProfile")
        if os_image_notification_profile is not None:
            os_image_notification_profile.set_prop("enable", AAZBoolType, ".enable")
            os_image_notification_profile.set_prop("notBeforeTimeout", AAZStrType, ".not_before_timeout")

        terminate_notification_profile = _builder.get(".scheduledEventsProfile.terminateNotificationProfile")
        if terminate_notification_profile is not None:
            terminate_notification_profile.set_prop("enable", AAZBoolType, ".enable")
            terminate_notification_profile.set_prop("notBeforeTimeout", AAZStrType, ".not_before_timeout")

        security_posture_reference = _builder.get(".securityPostureReference")
        if security_posture_reference is not None:
            security_posture_reference.set_prop("excludeExtensions", AAZListType, ".exclude_extensions")
            security_posture_reference.set_prop("id", AAZStrType, ".id")
            security_posture_reference.set_prop("isOverridable", AAZBoolType, ".is_overridable")

        exclude_extensions = _builder.get(".securityPostureReference.excludeExtensions")
        if exclude_extensions is not None:
            exclude_extensions.set_elements(AAZStrType, ".")

        security_profile = _builder.get(".securityProfile")
        if security_profile is not None:
            security_profile.set_prop("encryptionAtHost", AAZBoolType, ".encryption_at_host")
            security_profile.set_prop("encryptionIdentity", AAZObjectType, ".encryption_identity")
            security_profile.set_prop("proxyAgentSettings", AAZObjectType, ".proxy_agent_settings")
            security_profile.set_prop("securityType", AAZStrType, ".security_type")
            security_profile.set_prop("uefiSettings", AAZObjectType, ".uefi_settings")

        encryption_identity = _builder.get(".securityProfile.encryptionIdentity")
        if encryption_identity is not None:
            encryption_identity.set_prop("userAssignedIdentityResourceId", AAZStrType, ".user_assigned_identity_resource_id")

        proxy_agent_settings = _builder.get(".securityProfile.proxyAgentSettings")
        if proxy_agent_settings is not None:
            proxy_agent_settings.set_prop("enabled", AAZBoolType, ".enabled")
            proxy_agent_settings.set_prop("keyIncarnationId", AAZIntType, ".key_incarnation_id")
            proxy_agent_settings.set_prop("mode", AAZStrType, ".mode")

        uefi_settings = _builder.get(".securityProfile.uefiSettings")
        if uefi_settings is not None:
            uefi_settings.set_prop("secureBootEnabled", AAZBoolType, ".secure_boot_enabled")
            uefi_settings.set_prop("vTpmEnabled", AAZBoolType, ".v_tpm_enabled")

        service_artifact_reference = _builder.get(".serviceArtifactReference")
        if service_artifact_reference is not None:
            service_artifact_reference.set_prop("id", AAZStrType, ".id")

        storage_profile = _builder.get(".storageProfile")
        if storage_profile is not None:
            storage_profile.set_prop("dataDisks", AAZListType, ".data_disks")
            storage_profile.set_prop("diskControllerType", AAZStrType, ".disk_controller_type")
            storage_profile.set_prop("imageReference", AAZObjectType, ".image_reference")
            storage_profile.set_prop("osDisk", AAZObjectType, ".os_disk")

        data_disks = _builder.get(".storageProfile.dataDisks")
        if data_disks is not None:
            data_disks.set_elements(AAZObjectType, ".")

        _elements = _builder.get(".storageProfile.dataDisks[]")
        if _elements is not None:
            _elements.set_prop("caching", AAZStrType, ".caching")
            _elements.set_prop("createOption", AAZStrType, ".create_option", typ_kwargs={"flags": {"required": True}})
            _elements.set_prop("deleteOption", AAZStrType, ".delete_option")
            _elements.set_prop("diskIOPSReadWrite", AAZIntType, ".disk_iops_read_write")
            _elements.set_prop("diskMBpsReadWrite", AAZIntType, ".disk_m_bps_read_write")
            _elements.set_prop("diskSizeGB", AAZIntType, ".disk_size_gb")
            _elements.set_prop("lun", AAZIntType, ".lun", typ_kwargs={"flags": {"required": True}})
            cls._build_schema_virtual_machine_scale_set_managed_disk_parameters_create(_elements.set_prop("managedDisk", AAZObjectType, ".managed_disk"))
            _elements.set_prop("name", AAZStrType, ".name")
            _elements.set_prop("writeAcceleratorEnabled", AAZBoolType, ".write_accelerator_enabled")

        image_reference = _builder.get(".storageProfile.imageReference")
        if image_reference is not None:
            image_reference.set_prop("communityGalleryImageId", AAZStrType, ".community_gallery_image_id")
            image_reference.set_prop("id", AAZStrType, ".id")
            image_reference.set_prop("offer", AAZStrType, ".offer")
            image_reference.set_prop("publisher", AAZStrType, ".publisher")
            image_reference.set_prop("sharedGalleryImageId", AAZStrType, ".shared_gallery_image_id")
            image_reference.set_prop("sku", AAZStrType, ".sku")
            image_reference.set_prop("version", AAZStrType, ".version")

        os_disk = _builder.get(".storageProfile.osDisk")
        if os_disk is not None:
            os_disk.set_prop("caching", AAZStrType, ".caching")
            os_disk.set_prop("createOption", AAZStrType, ".create_option", typ_kwargs={"flags": {"required": True}})
            os_disk.set_prop("deleteOption", AAZStrType, ".delete_option")
            os_disk.set_prop("diffDiskSettings", AAZObjectType, ".diff_disk_settings")
            os_disk.set_prop("diskSizeGB", AAZIntType, ".disk_size_gb")
            os_disk.set_prop("image", AAZObjectType, ".image")
            cls._build_schema_virtual_machine_scale_set_managed_disk_parameters_create(os_disk.set_prop("managedDisk", AAZObjectType, ".managed_disk"))
            os_disk.set_prop("name", AAZStrType, ".name")
            os_disk.set_prop("osType", AAZStrType, ".os_type")
            os_disk.set_prop("vhdContainers", AAZListType, ".vhd_containers")
            os_disk.set_prop("writeAcceleratorEnabled", AAZBoolType, ".write_accelerator_enabled")

        diff_disk_settings = _builder.get(".storageProfile.osDisk.diffDiskSettings")
        if diff_disk_settings is not None:
            diff_disk_settings.set_prop("option", AAZStrType, ".option")
            diff_disk_settings.set_prop("placement", AAZStrType, ".placement")

        image = _builder.get(".storageProfile.osDisk.image")
        if image is not None:
            image.set_prop("uri", AAZStrType, ".uri")

        vhd_containers = _builder.get(".storageProfile.osDisk.vhdContainers")
        if vhd_containers is not None:
            vhd_containers.set_elements(AAZStrType, ".")

    @classmethod
    def _build_schema_disk_encryption_set_parameters_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("id", AAZStrType, ".id")

    @classmethod
    def _build_schema_sub_resource_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("id", AAZStrType, ".id")

    @classmethod
    def _build_schema_vm_attribute_min_max_double_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("max", AAZFloatType, ".max")
        _builder.set_prop("min", AAZFloatType, ".min")

    @classmethod
    def _build_schema_vm_attribute_min_max_integer_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("max", AAZIntType, ".max")
        _builder.set_prop("min", AAZIntType, ".min")

    @classmethod
    def _build_schema_virtual_machine_scale_set_managed_disk_parameters_create(cls, _builder):
        if _builder is None:
            return
        cls._build_schema_disk_encryption_set_parameters_create(_builder.set_prop("diskEncryptionSet", AAZObjectType, ".disk_encryption_set"))
        _builder.set_prop("securityProfile", AAZObjectType, ".security_profile")
        _builder.set_prop("storageAccountType", AAZStrType, ".storage_account_type")

        security_profile = _builder.get(".securityProfile")
        if security_profile is not None:
            cls._build_schema_disk_encryption_set_parameters_create(security_profile.set_prop("diskEncryptionSet", AAZObjectType, ".disk_encryption_set"))
            security_profile.set_prop("securityEncryptionType", AAZStrType, ".security_encryption_type")

    _schema_api_entity_reference_read = None

    @classmethod
    def _build_schema_api_entity_reference_read(cls, _schema):
        if cls._schema_api_entity_reference_read is not None:
            _schema.id = cls._schema_api_entity_reference_read.id
            return

        cls._schema_api_entity_reference_read = _schema_api_entity_reference_read = AAZObjectType()

        api_entity_reference_read = _schema_api_entity_reference_read
        api_entity_reference_read.id = AAZStrType()

        _schema.id = cls._schema_api_entity_reference_read.id

    _schema_base_virtual_machine_profile_read = None

    @classmethod
    def _build_schema_base_virtual_machine_profile_read(cls, _schema):
        if cls._schema_base_virtual_machine_profile_read is not None:
            _schema.application_profile = cls._schema_base_virtual_machine_profile_read.application_profile
            _schema.capacity_reservation = cls._schema_base_virtual_machine_profile_read.capacity_reservation
            _schema.diagnostics_profile = cls._schema_base_virtual_machine_profile_read.diagnostics_profile
            _schema.extension_profile = cls._schema_base_virtual_machine_profile_read.extension_profile
            _schema.hardware_profile = cls._schema_base_virtual_machine_profile_read.hardware_profile
            _schema.license_type = cls._schema_base_virtual_machine_profile_read.license_type
            _schema.network_profile = cls._schema_base_virtual_machine_profile_read.network_profile
            _schema.os_profile = cls._schema_base_virtual_machine_profile_read.os_profile
            _schema.scheduled_events_profile = cls._schema_base_virtual_machine_profile_read.scheduled_events_profile
            _schema.security_posture_reference = cls._schema_base_virtual_machine_profile_read.security_posture_reference
            _schema.security_profile = cls._schema_base_virtual_machine_profile_read.security_profile
            _schema.service_artifact_reference = cls._schema_base_virtual_machine_profile_read.service_artifact_reference
            _schema.storage_profile = cls._schema_base_virtual_machine_profile_read.storage_profile
            _schema.time_created = cls._schema_base_virtual_machine_profile_read.time_created
            _schema.user_data = cls._schema_base_virtual_machine_profile_read.user_data
            return

        cls._schema_base_virtual_machine_profile_read = _schema_base_virtual_machine_profile_read = AAZObjectType()

        base_virtual_machine_profile_read = _schema_base_virtual_machine_profile_read
        base_virtual_machine_profile_read.application_profile = AAZObjectType(
            serialized_name="applicationProfile",
        )
        base_virtual_machine_profile_read.capacity_reservation = AAZObjectType(
            serialized_name="capacityReservation",
        )
        base_virtual_machine_profile_read.diagnostics_profile = AAZObjectType(
            serialized_name="diagnosticsProfile",
        )
        base_virtual_machine_profile_read.extension_profile = AAZObjectType(
            serialized_name="extensionProfile",
        )
        base_virtual_machine_profile_read.hardware_profile = AAZObjectType(
            serialized_name="hardwareProfile",
        )
        base_virtual_machine_profile_read.license_type = AAZStrType(
            serialized_name="licenseType",
        )
        base_virtual_machine_profile_read.network_profile = AAZObjectType(
            serialized_name="networkProfile",
        )
        base_virtual_machine_profile_read.os_profile = AAZObjectType(
            serialized_name="osProfile",
        )
        base_virtual_machine_profile_read.scheduled_events_profile = AAZObjectType(
            serialized_name="scheduledEventsProfile",
        )
        base_virtual_machine_profile_read.security_posture_reference = AAZObjectType(
            serialized_name="securityPostureReference",
        )
        base_virtual_machine_profile_read.security_profile = AAZObjectType(
            serialized_name="securityProfile",
        )
        base_virtual_machine_profile_read.service_artifact_reference = AAZObjectType(
            serialized_name="serviceArtifactReference",
        )
        base_virtual_machine_profile_read.storage_profile = AAZObjectType(
            serialized_name="storageProfile",
        )
        base_virtual_machine_profile_read.time_created = AAZStrType(
            serialized_name="timeCreated",
            flags={"read_only": True},
        )
        base_virtual_machine_profile_read.user_data = AAZStrType(
            serialized_name="userData",
        )

        application_profile = _schema_base_virtual_machine_profile_read.application_profile
        application_profile.gallery_applications = AAZListType(
            serialized_name="galleryApplications",
        )

        gallery_applications = _schema_base_virtual_machine_profile_read.application_profile.gallery_applications
        gallery_applications.Element = AAZObjectType()

        _element = _schema_base_virtual_machine_profile_read.application_profile.gallery_applications.Element
        _element.configuration_reference = AAZStrType(
            serialized_name="configurationReference",
        )
        _element.enable_automatic_upgrade = AAZBoolType(
            serialized_name="enableAutomaticUpgrade",
        )
        _element.order = AAZIntType()
        _element.package_reference_id = AAZStrType(
            serialized_name="packageReferenceId",
            flags={"required": True},
        )
        _element.tags = AAZStrType()
        _element.treat_failure_as_deployment_failure = AAZBoolType(
            serialized_name="treatFailureAsDeploymentFailure",
        )

        capacity_reservation = _schema_base_virtual_machine_profile_read.capacity_reservation
        capacity_reservation.capacity_reservation_group = AAZObjectType(
            serialized_name="capacityReservationGroup",
        )
        cls._build_schema_sub_resource_read(capacity_reservation.capacity_reservation_group)

        diagnostics_profile = _schema_base_virtual_machine_profile_read.diagnostics_profile
        diagnostics_profile.boot_diagnostics = AAZObjectType(
            serialized_name="bootDiagnostics",
        )

        boot_diagnostics = _schema_base_virtual_machine_profile_read.diagnostics_profile.boot_diagnostics
        boot_diagnostics.enabled = AAZBoolType()
        boot_diagnostics.storage_uri = AAZStrType(
            serialized_name="storageUri",
        )

        extension_profile = _schema_base_virtual_machine_profile_read.extension_profile
        extension_profile.extensions = AAZListType()
        extension_profile.extensions_time_budget = AAZStrType(
            serialized_name="extensionsTimeBudget",
        )

        extensions = _schema_base_virtual_machine_profile_read.extension_profile.extensions
        extensions.Element = AAZObjectType()

        _element = _schema_base_virtual_machine_profile_read.extension_profile.extensions.Element
        _element.id = AAZStrType(
            flags={"read_only": True},
        )
        _element.name = AAZStrType()
        _element.properties = AAZObjectType()
        _element.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_base_virtual_machine_profile_read.extension_profile.extensions.Element.properties
        properties.auto_upgrade_minor_version = AAZBoolType(
            serialized_name="autoUpgradeMinorVersion",
        )
        properties.enable_automatic_upgrade = AAZBoolType(
            serialized_name="enableAutomaticUpgrade",
        )
        properties.force_update_tag = AAZStrType(
            serialized_name="forceUpdateTag",
        )
        properties.protected_settings_from_key_vault = AAZObjectType(
            serialized_name="protectedSettingsFromKeyVault",
        )
        properties.provision_after_extensions = AAZListType(
            serialized_name="provisionAfterExtensions",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.publisher = AAZStrType()
        properties.settings = AAZFreeFormDictType()
        properties.suppress_failures = AAZBoolType(
            serialized_name="suppressFailures",
        )
        properties.type = AAZStrType()
        properties.type_handler_version = AAZStrType(
            serialized_name="typeHandlerVersion",
        )

        protected_settings_from_key_vault = _schema_base_virtual_machine_profile_read.extension_profile.extensions.Element.properties.protected_settings_from_key_vault
        protected_settings_from_key_vault.secret_url = AAZStrType(
            serialized_name="secretUrl",
            flags={"required": True},
        )
        protected_settings_from_key_vault.source_vault = AAZObjectType(
            serialized_name="sourceVault",
            flags={"required": True},
        )
        cls._build_schema_sub_resource_read(protected_settings_from_key_vault.source_vault)

        provision_after_extensions = _schema_base_virtual_machine_profile_read.extension_profile.extensions.Element.properties.provision_after_extensions
        provision_after_extensions.Element = AAZStrType()

        hardware_profile = _schema_base_virtual_machine_profile_read.hardware_profile
        hardware_profile.vm_size_properties = AAZObjectType(
            serialized_name="vmSizeProperties",
        )

        vm_size_properties = _schema_base_virtual_machine_profile_read.hardware_profile.vm_size_properties
        vm_size_properties.v_cp_us_available = AAZIntType(
            serialized_name="vCPUsAvailable",
        )
        vm_size_properties.v_cp_us_per_core = AAZIntType(
            serialized_name="vCPUsPerCore",
        )

        network_profile = _schema_base_virtual_machine_profile_read.network_profile
        network_profile.health_probe = AAZObjectType(
            serialized_name="healthProbe",
        )
        cls._build_schema_api_entity_reference_read(network_profile.health_probe)
        network_profile.network_api_version = AAZStrType(
            serialized_name="networkApiVersion",
        )
        network_profile.network_interface_configurations = AAZListType(
            serialized_name="networkInterfaceConfigurations",
        )

        network_interface_configurations = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations
        network_interface_configurations.Element = AAZObjectType()

        _element = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations.Element
        _element.name = AAZStrType(
            flags={"required": True},
        )
        _element.properties = AAZObjectType()

        properties = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations.Element.properties
        properties.auxiliary_mode = AAZStrType(
            serialized_name="auxiliaryMode",
        )
        properties.auxiliary_sku = AAZStrType(
            serialized_name="auxiliarySku",
        )
        properties.delete_option = AAZStrType(
            serialized_name="deleteOption",
        )
        properties.disable_tcp_state_tracking = AAZBoolType(
            serialized_name="disableTcpStateTracking",
        )
        properties.dns_settings = AAZObjectType(
            serialized_name="dnsSettings",
        )
        properties.enable_accelerated_networking = AAZBoolType(
            serialized_name="enableAcceleratedNetworking",
        )
        properties.enable_fpga = AAZBoolType(
            serialized_name="enableFpga",
        )
        properties.enable_ip_forwarding = AAZBoolType(
            serialized_name="enableIPForwarding",
        )
        properties.ip_configurations = AAZListType(
            serialized_name="ipConfigurations",
            flags={"required": True},
        )
        properties.network_security_group = AAZObjectType(
            serialized_name="networkSecurityGroup",
        )
        cls._build_schema_sub_resource_read(properties.network_security_group)
        properties.primary = AAZBoolType()

        dns_settings = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations.Element.properties.dns_settings
        dns_settings.dns_servers = AAZListType(
            serialized_name="dnsServers",
        )

        dns_servers = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations.Element.properties.dns_settings.dns_servers
        dns_servers.Element = AAZStrType()

        ip_configurations = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations.Element.properties.ip_configurations
        ip_configurations.Element = AAZObjectType()

        _element = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element
        _element.name = AAZStrType(
            flags={"required": True},
        )
        _element.properties = AAZObjectType()

        properties = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties
        properties.application_gateway_backend_address_pools = AAZListType(
            serialized_name="applicationGatewayBackendAddressPools",
        )
        properties.application_security_groups = AAZListType(
            serialized_name="applicationSecurityGroups",
        )
        properties.load_balancer_backend_address_pools = AAZListType(
            serialized_name="loadBalancerBackendAddressPools",
        )
        properties.load_balancer_inbound_nat_pools = AAZListType(
            serialized_name="loadBalancerInboundNatPools",
        )
        properties.primary = AAZBoolType()
        properties.private_ip_address_version = AAZStrType(
            serialized_name="privateIPAddressVersion",
        )
        properties.public_ip_address_configuration = AAZObjectType(
            serialized_name="publicIPAddressConfiguration",
        )
        properties.subnet = AAZObjectType()
        cls._build_schema_api_entity_reference_read(properties.subnet)

        application_gateway_backend_address_pools = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.application_gateway_backend_address_pools
        application_gateway_backend_address_pools.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(application_gateway_backend_address_pools.Element)

        application_security_groups = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.application_security_groups
        application_security_groups.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(application_security_groups.Element)

        load_balancer_backend_address_pools = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.load_balancer_backend_address_pools
        load_balancer_backend_address_pools.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(load_balancer_backend_address_pools.Element)

        load_balancer_inbound_nat_pools = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.load_balancer_inbound_nat_pools
        load_balancer_inbound_nat_pools.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(load_balancer_inbound_nat_pools.Element)

        public_ip_address_configuration = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.public_ip_address_configuration
        public_ip_address_configuration.name = AAZStrType(
            flags={"required": True},
        )
        public_ip_address_configuration.properties = AAZObjectType()
        public_ip_address_configuration.sku = AAZObjectType()

        properties = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.public_ip_address_configuration.properties
        properties.delete_option = AAZStrType(
            serialized_name="deleteOption",
        )
        properties.dns_settings = AAZObjectType(
            serialized_name="dnsSettings",
        )
        properties.idle_timeout_in_minutes = AAZIntType(
            serialized_name="idleTimeoutInMinutes",
        )
        properties.ip_tags = AAZListType(
            serialized_name="ipTags",
        )
        properties.public_ip_address_version = AAZStrType(
            serialized_name="publicIPAddressVersion",
        )
        properties.public_ip_prefix = AAZObjectType(
            serialized_name="publicIPPrefix",
        )
        cls._build_schema_sub_resource_read(properties.public_ip_prefix)

        dns_settings = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.public_ip_address_configuration.properties.dns_settings
        dns_settings.domain_name_label = AAZStrType(
            serialized_name="domainNameLabel",
            flags={"required": True},
        )
        dns_settings.domain_name_label_scope = AAZStrType(
            serialized_name="domainNameLabelScope",
        )

        ip_tags = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.public_ip_address_configuration.properties.ip_tags
        ip_tags.Element = AAZObjectType()

        _element = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.public_ip_address_configuration.properties.ip_tags.Element
        _element.ip_tag_type = AAZStrType(
            serialized_name="ipTagType",
        )
        _element.tag = AAZStrType()

        sku = _schema_base_virtual_machine_profile_read.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.public_ip_address_configuration.sku
        sku.name = AAZStrType()
        sku.tier = AAZStrType()

        os_profile = _schema_base_virtual_machine_profile_read.os_profile
        os_profile.admin_username = AAZStrType(
            serialized_name="adminUsername",
        )
        os_profile.allow_extension_operations = AAZBoolType(
            serialized_name="allowExtensionOperations",
        )
        os_profile.computer_name_prefix = AAZStrType(
            serialized_name="computerNamePrefix",
        )
        os_profile.linux_configuration = AAZObjectType(
            serialized_name="linuxConfiguration",
        )
        os_profile.require_guest_provision_signal = AAZBoolType(
            serialized_name="requireGuestProvisionSignal",
        )
        os_profile.secrets = AAZListType()
        os_profile.windows_configuration = AAZObjectType(
            serialized_name="windowsConfiguration",
        )

        linux_configuration = _schema_base_virtual_machine_profile_read.os_profile.linux_configuration
        linux_configuration.disable_password_authentication = AAZBoolType(
            serialized_name="disablePasswordAuthentication",
        )
        linux_configuration.enable_vm_agent_platform_updates = AAZBoolType(
            serialized_name="enableVMAgentPlatformUpdates",
        )
        linux_configuration.patch_settings = AAZObjectType(
            serialized_name="patchSettings",
        )
        linux_configuration.provision_vm_agent = AAZBoolType(
            serialized_name="provisionVMAgent",
        )
        linux_configuration.ssh = AAZObjectType()

        patch_settings = _schema_base_virtual_machine_profile_read.os_profile.linux_configuration.patch_settings
        patch_settings.assessment_mode = AAZStrType(
            serialized_name="assessmentMode",
        )
        patch_settings.automatic_by_platform_settings = AAZObjectType(
            serialized_name="automaticByPlatformSettings",
        )
        patch_settings.patch_mode = AAZStrType(
            serialized_name="patchMode",
        )

        automatic_by_platform_settings = _schema_base_virtual_machine_profile_read.os_profile.linux_configuration.patch_settings.automatic_by_platform_settings
        automatic_by_platform_settings.bypass_platform_safety_checks_on_user_schedule = AAZBoolType(
            serialized_name="bypassPlatformSafetyChecksOnUserSchedule",
        )
        automatic_by_platform_settings.reboot_setting = AAZStrType(
            serialized_name="rebootSetting",
        )

        ssh = _schema_base_virtual_machine_profile_read.os_profile.linux_configuration.ssh
        ssh.public_keys = AAZListType(
            serialized_name="publicKeys",
        )

        public_keys = _schema_base_virtual_machine_profile_read.os_profile.linux_configuration.ssh.public_keys
        public_keys.Element = AAZObjectType()

        _element = _schema_base_virtual_machine_profile_read.os_profile.linux_configuration.ssh.public_keys.Element
        _element.key_data = AAZStrType(
            serialized_name="keyData",
        )
        _element.path = AAZStrType()

        secrets = _schema_base_virtual_machine_profile_read.os_profile.secrets
        secrets.Element = AAZObjectType()

        _element = _schema_base_virtual_machine_profile_read.os_profile.secrets.Element
        _element.source_vault = AAZObjectType(
            serialized_name="sourceVault",
        )
        cls._build_schema_sub_resource_read(_element.source_vault)
        _element.vault_certificates = AAZListType(
            serialized_name="vaultCertificates",
        )

        vault_certificates = _schema_base_virtual_machine_profile_read.os_profile.secrets.Element.vault_certificates
        vault_certificates.Element = AAZObjectType()

        _element = _schema_base_virtual_machine_profile_read.os_profile.secrets.Element.vault_certificates.Element
        _element.certificate_store = AAZStrType(
            serialized_name="certificateStore",
        )
        _element.certificate_url = AAZStrType(
            serialized_name="certificateUrl",
        )

        windows_configuration = _schema_base_virtual_machine_profile_read.os_profile.windows_configuration
        windows_configuration.additional_unattend_content = AAZListType(
            serialized_name="additionalUnattendContent",
        )
        windows_configuration.enable_automatic_updates = AAZBoolType(
            serialized_name="enableAutomaticUpdates",
        )
        windows_configuration.enable_vm_agent_platform_updates = AAZBoolType(
            serialized_name="enableVMAgentPlatformUpdates",
        )
        windows_configuration.patch_settings = AAZObjectType(
            serialized_name="patchSettings",
        )
        windows_configuration.provision_vm_agent = AAZBoolType(
            serialized_name="provisionVMAgent",
        )
        windows_configuration.time_zone = AAZStrType(
            serialized_name="timeZone",
        )
        windows_configuration.win_rm = AAZObjectType(
            serialized_name="winRM",
        )

        additional_unattend_content = _schema_base_virtual_machine_profile_read.os_profile.windows_configuration.additional_unattend_content
        additional_unattend_content.Element = AAZObjectType()

        _element = _schema_base_virtual_machine_profile_read.os_profile.windows_configuration.additional_unattend_content.Element
        _element.component_name = AAZStrType(
            serialized_name="componentName",
        )
        _element.pass_name = AAZStrType(
            serialized_name="passName",
        )
        _element.setting_name = AAZStrType(
            serialized_name="settingName",
        )

        patch_settings = _schema_base_virtual_machine_profile_read.os_profile.windows_configuration.patch_settings
        patch_settings.assessment_mode = AAZStrType(
            serialized_name="assessmentMode",
        )
        patch_settings.automatic_by_platform_settings = AAZObjectType(
            serialized_name="automaticByPlatformSettings",
        )
        patch_settings.enable_hotpatching = AAZBoolType(
            serialized_name="enableHotpatching",
        )
        patch_settings.patch_mode = AAZStrType(
            serialized_name="patchMode",
        )

        automatic_by_platform_settings = _schema_base_virtual_machine_profile_read.os_profile.windows_configuration.patch_settings.automatic_by_platform_settings
        automatic_by_platform_settings.bypass_platform_safety_checks_on_user_schedule = AAZBoolType(
            serialized_name="bypassPlatformSafetyChecksOnUserSchedule",
        )
        automatic_by_platform_settings.reboot_setting = AAZStrType(
            serialized_name="rebootSetting",
        )

        win_rm = _schema_base_virtual_machine_profile_read.os_profile.windows_configuration.win_rm
        win_rm.listeners = AAZListType()

        listeners = _schema_base_virtual_machine_profile_read.os_profile.windows_configuration.win_rm.listeners
        listeners.Element = AAZObjectType()

        _element = _schema_base_virtual_machine_profile_read.os_profile.windows_configuration.win_rm.listeners.Element
        _element.certificate_url = AAZStrType(
            serialized_name="certificateUrl",
        )
        _element.protocol = AAZStrType()

        scheduled_events_profile = _schema_base_virtual_machine_profile_read.scheduled_events_profile
        scheduled_events_profile.os_image_notification_profile = AAZObjectType(
            serialized_name="osImageNotificationProfile",
        )
        scheduled_events_profile.terminate_notification_profile = AAZObjectType(
            serialized_name="terminateNotificationProfile",
        )

        os_image_notification_profile = _schema_base_virtual_machine_profile_read.scheduled_events_profile.os_image_notification_profile
        os_image_notification_profile.enable = AAZBoolType()
        os_image_notification_profile.not_before_timeout = AAZStrType(
            serialized_name="notBeforeTimeout",
        )

        terminate_notification_profile = _schema_base_virtual_machine_profile_read.scheduled_events_profile.terminate_notification_profile
        terminate_notification_profile.enable = AAZBoolType()
        terminate_notification_profile.not_before_timeout = AAZStrType(
            serialized_name="notBeforeTimeout",
        )

        security_posture_reference = _schema_base_virtual_machine_profile_read.security_posture_reference
        security_posture_reference.exclude_extensions = AAZListType(
            serialized_name="excludeExtensions",
        )
        security_posture_reference.id = AAZStrType()
        security_posture_reference.is_overridable = AAZBoolType(
            serialized_name="isOverridable",
        )

        exclude_extensions = _schema_base_virtual_machine_profile_read.security_posture_reference.exclude_extensions
        exclude_extensions.Element = AAZStrType()

        security_profile = _schema_base_virtual_machine_profile_read.security_profile
        security_profile.encryption_at_host = AAZBoolType(
            serialized_name="encryptionAtHost",
        )
        security_profile.encryption_identity = AAZObjectType(
            serialized_name="encryptionIdentity",
        )
        security_profile.proxy_agent_settings = AAZObjectType(
            serialized_name="proxyAgentSettings",
        )
        security_profile.security_type = AAZStrType(
            serialized_name="securityType",
        )
        security_profile.uefi_settings = AAZObjectType(
            serialized_name="uefiSettings",
        )

        encryption_identity = _schema_base_virtual_machine_profile_read.security_profile.encryption_identity
        encryption_identity.user_assigned_identity_resource_id = AAZStrType(
            serialized_name="userAssignedIdentityResourceId",
        )

        proxy_agent_settings = _schema_base_virtual_machine_profile_read.security_profile.proxy_agent_settings
        proxy_agent_settings.enabled = AAZBoolType()
        proxy_agent_settings.key_incarnation_id = AAZIntType(
            serialized_name="keyIncarnationId",
        )
        proxy_agent_settings.mode = AAZStrType()

        uefi_settings = _schema_base_virtual_machine_profile_read.security_profile.uefi_settings
        uefi_settings.secure_boot_enabled = AAZBoolType(
            serialized_name="secureBootEnabled",
        )
        uefi_settings.v_tpm_enabled = AAZBoolType(
            serialized_name="vTpmEnabled",
        )

        service_artifact_reference = _schema_base_virtual_machine_profile_read.service_artifact_reference
        service_artifact_reference.id = AAZStrType()

        storage_profile = _schema_base_virtual_machine_profile_read.storage_profile
        storage_profile.data_disks = AAZListType(
            serialized_name="dataDisks",
        )
        storage_profile.disk_controller_type = AAZStrType(
            serialized_name="diskControllerType",
        )
        storage_profile.image_reference = AAZObjectType(
            serialized_name="imageReference",
        )
        storage_profile.os_disk = AAZObjectType(
            serialized_name="osDisk",
        )

        data_disks = _schema_base_virtual_machine_profile_read.storage_profile.data_disks
        data_disks.Element = AAZObjectType()

        _element = _schema_base_virtual_machine_profile_read.storage_profile.data_disks.Element
        _element.caching = AAZStrType()
        _element.create_option = AAZStrType(
            serialized_name="createOption",
            flags={"required": True},
        )
        _element.delete_option = AAZStrType(
            serialized_name="deleteOption",
        )
        _element.disk_iops_read_write = AAZIntType(
            serialized_name="diskIOPSReadWrite",
        )
        _element.disk_m_bps_read_write = AAZIntType(
            serialized_name="diskMBpsReadWrite",
        )
        _element.disk_size_gb = AAZIntType(
            serialized_name="diskSizeGB",
        )
        _element.lun = AAZIntType(
            flags={"required": True},
        )
        _element.managed_disk = AAZObjectType(
            serialized_name="managedDisk",
        )
        cls._build_schema_virtual_machine_scale_set_managed_disk_parameters_read(_element.managed_disk)
        _element.name = AAZStrType()
        _element.write_accelerator_enabled = AAZBoolType(
            serialized_name="writeAcceleratorEnabled",
        )

        image_reference = _schema_base_virtual_machine_profile_read.storage_profile.image_reference
        image_reference.community_gallery_image_id = AAZStrType(
            serialized_name="communityGalleryImageId",
        )
        image_reference.exact_version = AAZStrType(
            serialized_name="exactVersion",
            flags={"read_only": True},
        )
        image_reference.id = AAZStrType()
        image_reference.offer = AAZStrType()
        image_reference.publisher = AAZStrType()
        image_reference.shared_gallery_image_id = AAZStrType(
            serialized_name="sharedGalleryImageId",
        )
        image_reference.sku = AAZStrType()
        image_reference.version = AAZStrType()

        os_disk = _schema_base_virtual_machine_profile_read.storage_profile.os_disk
        os_disk.caching = AAZStrType()
        os_disk.create_option = AAZStrType(
            serialized_name="createOption",
            flags={"required": True},
        )
        os_disk.delete_option = AAZStrType(
            serialized_name="deleteOption",
        )
        os_disk.diff_disk_settings = AAZObjectType(
            serialized_name="diffDiskSettings",
        )
        os_disk.disk_size_gb = AAZIntType(
            serialized_name="diskSizeGB",
        )
        os_disk.image = AAZObjectType()
        os_disk.managed_disk = AAZObjectType(
            serialized_name="managedDisk",
        )
        cls._build_schema_virtual_machine_scale_set_managed_disk_parameters_read(os_disk.managed_disk)
        os_disk.name = AAZStrType()
        os_disk.os_type = AAZStrType(
            serialized_name="osType",
        )
        os_disk.vhd_containers = AAZListType(
            serialized_name="vhdContainers",
        )
        os_disk.write_accelerator_enabled = AAZBoolType(
            serialized_name="writeAcceleratorEnabled",
        )

        diff_disk_settings = _schema_base_virtual_machine_profile_read.storage_profile.os_disk.diff_disk_settings
        diff_disk_settings.option = AAZStrType()
        diff_disk_settings.placement = AAZStrType()

        image = _schema_base_virtual_machine_profile_read.storage_profile.os_disk.image
        image.uri = AAZStrType()

        vhd_containers = _schema_base_virtual_machine_profile_read.storage_profile.os_disk.vhd_containers
        vhd_containers.Element = AAZStrType()

        _schema.application_profile = cls._schema_base_virtual_machine_profile_read.application_profile
        _schema.capacity_reservation = cls._schema_base_virtual_machine_profile_read.capacity_reservation
        _schema.diagnostics_profile = cls._schema_base_virtual_machine_profile_read.diagnostics_profile
        _schema.extension_profile = cls._schema_base_virtual_machine_profile_read.extension_profile
        _schema.hardware_profile = cls._schema_base_virtual_machine_profile_read.hardware_profile
        _schema.license_type = cls._schema_base_virtual_machine_profile_read.license_type
        _schema.network_profile = cls._schema_base_virtual_machine_profile_read.network_profile
        _schema.os_profile = cls._schema_base_virtual_machine_profile_read.os_profile
        _schema.scheduled_events_profile = cls._schema_base_virtual_machine_profile_read.scheduled_events_profile
        _schema.security_posture_reference = cls._schema_base_virtual_machine_profile_read.security_posture_reference
        _schema.security_profile = cls._schema_base_virtual_machine_profile_read.security_profile
        _schema.service_artifact_reference = cls._schema_base_virtual_machine_profile_read.service_artifact_reference
        _schema.storage_profile = cls._schema_base_virtual_machine_profile_read.storage_profile
        _schema.time_created = cls._schema_base_virtual_machine_profile_read.time_created
        _schema.user_data = cls._schema_base_virtual_machine_profile_read.user_data

    _schema_disk_encryption_set_parameters_read = None

    @classmethod
    def _build_schema_disk_encryption_set_parameters_read(cls, _schema):
        if cls._schema_disk_encryption_set_parameters_read is not None:
            _schema.id = cls._schema_disk_encryption_set_parameters_read.id
            return

        cls._schema_disk_encryption_set_parameters_read = _schema_disk_encryption_set_parameters_read = AAZObjectType()

        disk_encryption_set_parameters_read = _schema_disk_encryption_set_parameters_read
        disk_encryption_set_parameters_read.id = AAZStrType()

        _schema.id = cls._schema_disk_encryption_set_parameters_read.id

    _schema_sub_resource_read = None

    @classmethod
    def _build_schema_sub_resource_read(cls, _schema):
        if cls._schema_sub_resource_read is not None:
            _schema.id = cls._schema_sub_resource_read.id
            return

        cls._schema_sub_resource_read = _schema_sub_resource_read = AAZObjectType()

        sub_resource_read = _schema_sub_resource_read
        sub_resource_read.id = AAZStrType()

        _schema.id = cls._schema_sub_resource_read.id

    _schema_vm_attribute_min_max_double_read = None

    @classmethod
    def _build_schema_vm_attribute_min_max_double_read(cls, _schema):
        if cls._schema_vm_attribute_min_max_double_read is not None:
            _schema.max = cls._schema_vm_attribute_min_max_double_read.max
            _schema.min = cls._schema_vm_attribute_min_max_double_read.min
            return

        cls._schema_vm_attribute_min_max_double_read = _schema_vm_attribute_min_max_double_read = AAZObjectType()

        vm_attribute_min_max_double_read = _schema_vm_attribute_min_max_double_read
        vm_attribute_min_max_double_read.max = AAZFloatType()
        vm_attribute_min_max_double_read.min = AAZFloatType()

        _schema.max = cls._schema_vm_attribute_min_max_double_read.max
        _schema.min = cls._schema_vm_attribute_min_max_double_read.min

    _schema_vm_attribute_min_max_integer_read = None

    @classmethod
    def _build_schema_vm_attribute_min_max_integer_read(cls, _schema):
        if cls._schema_vm_attribute_min_max_integer_read is not None:
            _schema.max = cls._schema_vm_attribute_min_max_integer_read.max
            _schema.min = cls._schema_vm_attribute_min_max_integer_read.min
            return

        cls._schema_vm_attribute_min_max_integer_read = _schema_vm_attribute_min_max_integer_read = AAZObjectType()

        vm_attribute_min_max_integer_read = _schema_vm_attribute_min_max_integer_read
        vm_attribute_min_max_integer_read.max = AAZIntType()
        vm_attribute_min_max_integer_read.min = AAZIntType()

        _schema.max = cls._schema_vm_attribute_min_max_integer_read.max
        _schema.min = cls._schema_vm_attribute_min_max_integer_read.min

    _schema_virtual_machine_scale_set_managed_disk_parameters_read = None

    @classmethod
    def _build_schema_virtual_machine_scale_set_managed_disk_parameters_read(cls, _schema):
        if cls._schema_virtual_machine_scale_set_managed_disk_parameters_read is not None:
            _schema.disk_encryption_set = cls._schema_virtual_machine_scale_set_managed_disk_parameters_read.disk_encryption_set
            _schema.security_profile = cls._schema_virtual_machine_scale_set_managed_disk_parameters_read.security_profile
            _schema.storage_account_type = cls._schema_virtual_machine_scale_set_managed_disk_parameters_read.storage_account_type
            return

        cls._schema_virtual_machine_scale_set_managed_disk_parameters_read = _schema_virtual_machine_scale_set_managed_disk_parameters_read = AAZObjectType()

        virtual_machine_scale_set_managed_disk_parameters_read = _schema_virtual_machine_scale_set_managed_disk_parameters_read
        virtual_machine_scale_set_managed_disk_parameters_read.disk_encryption_set = AAZObjectType(
            serialized_name="diskEncryptionSet",
        )
        cls._build_schema_disk_encryption_set_parameters_read(virtual_machine_scale_set_managed_disk_parameters_read.disk_encryption_set)
        virtual_machine_scale_set_managed_disk_parameters_read.security_profile = AAZObjectType(
            serialized_name="securityProfile",
        )
        virtual_machine_scale_set_managed_disk_parameters_read.storage_account_type = AAZStrType(
            serialized_name="storageAccountType",
        )

        security_profile = _schema_virtual_machine_scale_set_managed_disk_parameters_read.security_profile
        security_profile.disk_encryption_set = AAZObjectType(
            serialized_name="diskEncryptionSet",
        )
        cls._build_schema_disk_encryption_set_parameters_read(security_profile.disk_encryption_set)
        security_profile.security_encryption_type = AAZStrType(
            serialized_name="securityEncryptionType",
        )

        _schema.disk_encryption_set = cls._schema_virtual_machine_scale_set_managed_disk_parameters_read.disk_encryption_set
        _schema.security_profile = cls._schema_virtual_machine_scale_set_managed_disk_parameters_read.security_profile
        _schema.storage_account_type = cls._schema_virtual_machine_scale_set_managed_disk_parameters_read.storage_account_type


__all__ = ["Create"]
