/*
 *  Copyright 1994-2018 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __BINIOU_SEQUENCE_H
#define __BINIOU_SEQUENCE_H

#include "layer.h"


typedef struct Sequence_s {
  uint32_t id;              /* sequence id */
  u_char   changed;
  u_char   broken;          /* sequence is broken (eg, no pictures available) */
  char     *name;

  GList    *layers;         /* list of plugins to run */
  Plugin_t *lens;           /* lens, NULL if none */

  /* TODO ShufflerMode_e */
  u_char   auto_colormaps;    /* Auto-change colormaps at random interval */
  uint32_t cmap_id;           /* colormap to use, -1 if default */

  /* TODO ShufflerMode_e */
  u_char   auto_pictures;     /* Auto-change pictures  at random interval */
  uint32_t  picture_id;        /* picture to use, 0 if default */
} Sequence_t;


/*
 * TODO events callbacks:
 * F5/F6: shuffler mode = NONE
 * Shift+: SHUFFLE
 * Ctrl+: CYCLE
 * Alt+: RANDOM
 */

Sequence_t *Sequence_new(const uint32_t);
void Sequence_delete(Sequence_t *);

void Sequence_display(const Sequence_t *);
void Sequence_copy(const Sequence_t *, Sequence_t *);
void Sequence_clear(Sequence_t *, const uint32_t);
void Sequence_changed(Sequence_t *);

void Sequence_insert(Sequence_t *, Plugin_t *);
void Sequence_insert_at_position(Sequence_t *, const u_short, Plugin_t *);
void Sequence_remove(Sequence_t *, const Plugin_t *);

GList *Sequence_find(const Sequence_t *, const Plugin_t *);
short Sequence_find_position(const Sequence_t *, const Plugin_t *);

void Sequence_save(Sequence_t *, int, const int);
Sequence_t *Sequence_load(const char *);

gint Sequence_sort_func(gconstpointer, gconstpointer);

uint8_t Sequence_size(const Sequence_t *);

#endif /* __BINIOU_SEQUENCE_H */
