/*
 *  Copyright 1994-2020 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#include "commands_key.h"

/*
 * Automagically generated from commands.c.in
 * DO NOT EDIT !!!
 */

void
on_key(Context_t *ctx, const BKey_t *k)
{

  /* =============== Application =============== */

  /* [Alt-Shift-r] - Random 3D rotations */
  if (BALTSHIFT(k, SDLK_r)) {
    json_t *res = Context_process_command(ctx, CMD_APP_RANDOMIZE_3D_ROTATIONS, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-b] - Next 3D boundary */
  if (BALT(k, SDLK_b)) {
    json_t *res = Context_process_command(ctx, CMD_APP_NEXT_3D_BOUNDARY, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-r] - Toggle 3D rotations */
  if (BALT(k, SDLK_r)) {
    json_t *res = Context_process_command(ctx, CMD_APP_TOGGLE_3D_ROTATIONS, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-c] - Display current colormap */
  if (BALT(k, SDLK_c)) {
    json_t *res = Context_process_command(ctx, CMD_APP_DISPLAY_COLORMAP, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-f] - Toggle full-screen on/off */
  if (BCTRL(k, SDLK_f)) {
    json_t *res = Context_process_command(ctx, CMD_APP_SWITCH_FULLSCREEN, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-m] - Show/hide mouse cursor */
  if (BALT(k, SDLK_m)) {
    json_t *res = Context_process_command(ctx, CMD_APP_SWITCH_CURSOR, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-q] - Quit */
  if (BSHIFT(k, SDLK_q)) {
    json_t *res = Context_process_command(ctx, CMD_APP_QUIT, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-x] - Save the current sequence then quit */
  if (BSHIFT(k, SDLK_x)) {
    json_t *res = Context_process_command(ctx, CMD_APP_SAVE_QUIT, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-n] - Fill current frame with random pixels */
  if (BSHIFT(k, SDLK_n)) {
    json_t *res = Context_process_command(ctx, CMD_APP_RANDOMIZE_SCREEN, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [n] - Clear the current frame */
  if (BKEY(k, SDLK_n)) {
    json_t *res = Context_process_command(ctx, CMD_APP_CLEAR_SCREEN, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [ESCAPE] - Turn off all auto changes */
  if (BKEY(k, SDLK_ESCAPE)) {
    json_t *res = Context_process_command(ctx, CMD_APP_STOP_AUTO_MODES, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [RETURN] - Toggle selected plugin on/off */
  if (BKEY(k, SDLK_RETURN)) {
    json_t *res = Context_process_command(ctx, CMD_APP_TOGGLE_SELECTED_PLUGIN, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-LEFT] - Use previous sequence */
  if (BSHIFT(k, SDLK_LEFT)) {
    json_t *res = Context_process_command(ctx, CMD_APP_PREVIOUS_SEQUENCE, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-RIGHT] - Use next sequence */
  if (BSHIFT(k, SDLK_RIGHT)) {
    json_t *res = Context_process_command(ctx, CMD_APP_NEXT_SEQUENCE, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-PRINTSCREEN] - Take a screenshot */
  if (BSHIFT(k, SDLK_PRINTSCREEN)) {
    json_t *res = Context_process_command(ctx, CMD_APP_SCREENSHOT, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-BACKSPACE] - Make a sequence from system schemes */
  if (BCTRL(k, SDLK_BACKSPACE)) {
    json_t *res = Context_process_command(ctx, CMD_APP_RANDOM_SCHEME, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [BACKSPACE] - Select a random user sequence */
  if (BKEY(k, SDLK_BACKSPACE)) {
    json_t *res = Context_process_command(ctx, CMD_APP_RANDOM_SEQUENCE, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [m] - Next random mode */
  if (BKEY(k, SDLK_m)) {
    json_t *res = Context_process_command(ctx, CMD_APP_NEXT_RANDOM_MODE, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-m] - Previous random mode */
  if (BSHIFT(k, SDLK_m)) {
    json_t *res = Context_process_command(ctx, CMD_APP_PREVIOUS_RANDOM_MODE, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-t] - Auto colormaps on/off */
  if (BCTRL(k, SDLK_t)) {
    json_t *res = Context_process_command(ctx, CMD_APP_TOGGLE_AUTO_COLORMAPS, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-i] - Auto images on/off */
  if (BCTRL(k, SDLK_i)) {
    json_t *res = Context_process_command(ctx, CMD_APP_TOGGLE_AUTO_IMAGES, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [SPACE] - Bypass webcams on/off */
  if (BKEY(k, SDLK_SPACE)) {
    json_t *res = Context_process_command(ctx, CMD_APP_SWITCH_BYPASS, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-SPACE] - Set webcam reference image */
  if (BCTRL(k, SDLK_SPACE)) {
    json_t *res = Context_process_command(ctx, CMD_APP_SET_WEBCAM_REFERENCE, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [TAB] - Select next webcam */
  if (BKEY(k, SDLK_TAB)) {
    json_t *res = Context_process_command(ctx, CMD_APP_NEXT_WEBCAM, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-l] - Lock selected plugin */
  if (BCTRL(k, SDLK_l)) {
    json_t *res = Context_process_command(ctx, CMD_APP_LOCK_SELECTED_PLUGIN, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-TAB] - Freeze input on/off */
  if (BCTRL(k, SDLK_TAB)) {
    json_t *res = Context_process_command(ctx, CMD_APP_FREEZE_INPUT, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-v] - Scale volume up */
  if (BSHIFT(k, SDLK_v)) {
    json_t *res = Context_process_command(ctx, CMD_APP_VOLUME_SCALE_UP, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-v] - Scale volume down */
  if (BALT(k, SDLK_v)) {
    json_t *res = Context_process_command(ctx, CMD_APP_VOLUME_SCALE_DOWN, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-LEFT] - Use first sequence */
  if (BCTRLSHIFT(k, SDLK_LEFT)) {
    json_t *res = Context_process_command(ctx, CMD_APP_FIRST_SEQUENCE, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-RIGHT] - Use last sequence */
  if (BCTRLSHIFT(k, SDLK_RIGHT)) {
    json_t *res = Context_process_command(ctx, CMD_APP_LAST_SEQUENCE, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-PAGEUP] - Increase 3D zoom */
  if (BSHIFT(k, SDLK_PAGEUP)) {
    json_t *res = Context_process_command(ctx, CMD_APP_DEC_3D_SCALE, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-PAGEDOWN] - Decrease 3D zoom */
  if (BSHIFT(k, SDLK_PAGEDOWN)) {
    json_t *res = Context_process_command(ctx, CMD_APP_INC_3D_SCALE, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* =============== Plugins =============== */

  /* [UP] - Select previous plugin */
  if (BKEY(k, SDLK_UP)) {
    json_t *res = Context_process_command(ctx, CMD_PLG_PREVIOUS, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [DOWN] - Select next plugin */
  if (BKEY(k, SDLK_DOWN)) {
    json_t *res = Context_process_command(ctx, CMD_PLG_NEXT, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [PAGEUP] - Scroll up in the plugins list */
  if (BKEY(k, SDLK_PAGEUP)) {
    json_t *res = Context_process_command(ctx, CMD_PLG_SCROLL_UP, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [PAGEDOWN] - Scroll down in the plugins list */
  if (BKEY(k, SDLK_PAGEDOWN)) {
    json_t *res = Context_process_command(ctx, CMD_PLG_SCROLL_DOWN, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* =============== Sequences =============== */

  /* [Shift-z] - Reset the current sequence */
  if (BSHIFT(k, SDLK_z)) {
    json_t *res = Context_process_command(ctx, CMD_SEQ_RESET, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-l] - Toggle selected plugin as a lens on/off */
  if (BSHIFT(k, SDLK_l)) {
    json_t *res = Context_process_command(ctx, CMD_SEQ_TOGGLE_LENS, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-UP] - Select previous plugin in the sequence */
  if (BSHIFT(k, SDLK_UP)) {
    json_t *res = Context_process_command(ctx, CMD_SEQ_SELECT_PREVIOUS, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-DOWN] - Select next plugin in the sequence */
  if (BSHIFT(k, SDLK_DOWN)) {
    json_t *res = Context_process_command(ctx, CMD_SEQ_SELECT_NEXT, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-UP] - Move selected plugin up in the sequence */
  if (BCTRL(k, SDLK_UP)) {
    json_t *res = Context_process_command(ctx, CMD_SEQ_MOVE_UP, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-DOWN] - Move selected plugin down in the sequence */
  if (BCTRL(k, SDLK_DOWN)) {
    json_t *res = Context_process_command(ctx, CMD_SEQ_MOVE_DOWN, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-y] - Select default layer mode for the current plugin */
  if (BALT(k, SDLK_y)) {
    json_t *res = Context_process_command(ctx, CMD_SEQ_LAYER_DEFAULT, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-y] - Select next layer mode */
  if (BSHIFT(k, SDLK_y)) {
    json_t *res = Context_process_command(ctx, CMD_SEQ_LAYER_NEXT, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-s] - Save current sequence as new (full) */
  if (BCTRL(k, SDLK_s)) {
    json_t *res = Context_process_command(ctx, CMD_SEQ_SAVE_FULL, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-u] - Update current full sequence */
  if (BCTRL(k, SDLK_u)) {
    json_t *res = Context_process_command(ctx, CMD_SEQ_UPDATE_FULL, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-s] - Save current sequence as new (bare) */
  if (BCTRLSHIFT(k, SDLK_s)) {
    json_t *res = Context_process_command(ctx, CMD_SEQ_SAVE_BARE, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-u] - Update current bare sequence */
  if (BCTRLSHIFT(k, SDLK_u)) {
    json_t *res = Context_process_command(ctx, CMD_SEQ_UPDATE_BARE, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-UP] - Select previous plugin parameter */
  if (BALT(k, SDLK_UP)) {
    json_t *res = Context_process_command(ctx, CMD_SEQ_PARAM_PREVIOUS, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-DOWN] - Select next plugin parameter */
  if (BALT(k, SDLK_DOWN)) {
    json_t *res = Context_process_command(ctx, CMD_SEQ_PARAM_NEXT, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-LEFT] - Decrease plugin parameter value */
  if (BALT(k, SDLK_LEFT)) {
    json_t *res = Context_process_command(ctx, CMD_SEQ_PARAM_DEC, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-RIGHT] - Increase plugin parameter value */
  if (BALT(k, SDLK_RIGHT)) {
    json_t *res = Context_process_command(ctx, CMD_SEQ_PARAM_INC, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-Shift-LEFT] - Decrease plugin parameter value quickly */
  if (BALTSHIFT(k, SDLK_LEFT)) {
    json_t *res = Context_process_command(ctx, CMD_SEQ_PARAM_DEC_FAST, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-Shift-RIGHT] - Increase plugin parameter value quickly */
  if (BALTSHIFT(k, SDLK_RIGHT)) {
    json_t *res = Context_process_command(ctx, CMD_SEQ_PARAM_INC_FAST, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* =============== Colormaps =============== */

  /* [e] - Select previous colormap */
  if (BKEY(k, SDLK_e)) {
    json_t *res = Context_process_command(ctx, CMD_COL_PREVIOUS, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [r] - Select next colormap */
  if (BKEY(k, SDLK_r)) {
    json_t *res = Context_process_command(ctx, CMD_COL_NEXT, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [t] - Select random colormap */
  if (BKEY(k, SDLK_t)) {
    json_t *res = Context_process_command(ctx, CMD_COL_RANDOM, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* =============== Colormap =============== */

  /* [Shift-1] - Use colormap in shortcut 1 */
  if (BSHIFT(k, SDLK_1)) {
    json_t *res = Context_process_command(ctx, CMD_COL_USE_SHORTCUT_1, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-2] - Use colormap in shortcut 2 */
  if (BSHIFT(k, SDLK_2)) {
    json_t *res = Context_process_command(ctx, CMD_COL_USE_SHORTCUT_2, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-3] - Use colormap in shortcut 3 */
  if (BSHIFT(k, SDLK_3)) {
    json_t *res = Context_process_command(ctx, CMD_COL_USE_SHORTCUT_3, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-4] - Use colormap in shortcut 4 */
  if (BSHIFT(k, SDLK_4)) {
    json_t *res = Context_process_command(ctx, CMD_COL_USE_SHORTCUT_4, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-5] - Use colormap in shortcut 5 */
  if (BSHIFT(k, SDLK_5)) {
    json_t *res = Context_process_command(ctx, CMD_COL_USE_SHORTCUT_5, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-6] - Use colormap in shortcut 6 */
  if (BSHIFT(k, SDLK_6)) {
    json_t *res = Context_process_command(ctx, CMD_COL_USE_SHORTCUT_6, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-7] - Use colormap in shortcut 7 */
  if (BSHIFT(k, SDLK_7)) {
    json_t *res = Context_process_command(ctx, CMD_COL_USE_SHORTCUT_7, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-8] - Use colormap in shortcut 8 */
  if (BSHIFT(k, SDLK_8)) {
    json_t *res = Context_process_command(ctx, CMD_COL_USE_SHORTCUT_8, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-9] - Use colormap in shortcut 9 */
  if (BSHIFT(k, SDLK_9)) {
    json_t *res = Context_process_command(ctx, CMD_COL_USE_SHORTCUT_9, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-0] - Use colormap in shortcut 10 */
  if (BSHIFT(k, SDLK_0)) {
    json_t *res = Context_process_command(ctx, CMD_COL_USE_SHORTCUT_10, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-1] - Assign current colormap to shortcut 1 */
  if (BCTRLSHIFT(k, SDLK_1)) {
    json_t *res = Context_process_command(ctx, CMD_COL_STORE_SHORTCUT_1, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-2] - Assign current colormap to shortcut 2 */
  if (BCTRLSHIFT(k, SDLK_2)) {
    json_t *res = Context_process_command(ctx, CMD_COL_STORE_SHORTCUT_2, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-3] - Assign current colormap to shortcut 3 */
  if (BCTRLSHIFT(k, SDLK_3)) {
    json_t *res = Context_process_command(ctx, CMD_COL_STORE_SHORTCUT_3, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-4] - Assign current colormap to shortcut 4 */
  if (BCTRLSHIFT(k, SDLK_4)) {
    json_t *res = Context_process_command(ctx, CMD_COL_STORE_SHORTCUT_4, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-5] - Assign current colormap to shortcut 5 */
  if (BCTRLSHIFT(k, SDLK_5)) {
    json_t *res = Context_process_command(ctx, CMD_COL_STORE_SHORTCUT_5, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-6] - Assign current colormap to shortcut 6 */
  if (BCTRLSHIFT(k, SDLK_6)) {
    json_t *res = Context_process_command(ctx, CMD_COL_STORE_SHORTCUT_6, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-7] - Assign current colormap to shortcut 7 */
  if (BCTRLSHIFT(k, SDLK_7)) {
    json_t *res = Context_process_command(ctx, CMD_COL_STORE_SHORTCUT_7, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-8] - Assign current colormap to shortcut 8 */
  if (BCTRLSHIFT(k, SDLK_8)) {
    json_t *res = Context_process_command(ctx, CMD_COL_STORE_SHORTCUT_8, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-9] - Assign current colormap to shortcut 9 */
  if (BCTRLSHIFT(k, SDLK_9)) {
    json_t *res = Context_process_command(ctx, CMD_COL_STORE_SHORTCUT_9, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-0] - Assign current colormap to shortcut 10 */
  if (BCTRLSHIFT(k, SDLK_0)) {
    json_t *res = Context_process_command(ctx, CMD_COL_STORE_SHORTCUT_10, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* =============== Images =============== */

  /* [y] - Select previous image */
  if (BKEY(k, SDLK_y)) {
    json_t *res = Context_process_command(ctx, CMD_IMG_PREVIOUS, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [u] - Select next image */
  if (BKEY(k, SDLK_u)) {
    json_t *res = Context_process_command(ctx, CMD_IMG_NEXT, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [i] - Select random image */
  if (BKEY(k, SDLK_i)) {
    json_t *res = Context_process_command(ctx, CMD_IMG_RANDOM, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* =============== Image =============== */

  /* [Alt-1] - Use image in shortcut 1 */
  if (BALT(k, SDLK_1)) {
    json_t *res = Context_process_command(ctx, CMD_IMG_USE_SHORTCUT_1, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-2] - Use image in shortcut 2 */
  if (BALT(k, SDLK_2)) {
    json_t *res = Context_process_command(ctx, CMD_IMG_USE_SHORTCUT_2, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-3] - Use image in shortcut 3 */
  if (BALT(k, SDLK_3)) {
    json_t *res = Context_process_command(ctx, CMD_IMG_USE_SHORTCUT_3, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-4] - Use image in shortcut 4 */
  if (BALT(k, SDLK_4)) {
    json_t *res = Context_process_command(ctx, CMD_IMG_USE_SHORTCUT_4, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-5] - Use image in shortcut 5 */
  if (BALT(k, SDLK_5)) {
    json_t *res = Context_process_command(ctx, CMD_IMG_USE_SHORTCUT_5, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-6] - Use image in shortcut 6 */
  if (BALT(k, SDLK_6)) {
    json_t *res = Context_process_command(ctx, CMD_IMG_USE_SHORTCUT_6, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-7] - Use image in shortcut 7 */
  if (BALT(k, SDLK_7)) {
    json_t *res = Context_process_command(ctx, CMD_IMG_USE_SHORTCUT_7, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-8] - Use image in shortcut 8 */
  if (BALT(k, SDLK_8)) {
    json_t *res = Context_process_command(ctx, CMD_IMG_USE_SHORTCUT_8, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-9] - Use image in shortcut 9 */
  if (BALT(k, SDLK_9)) {
    json_t *res = Context_process_command(ctx, CMD_IMG_USE_SHORTCUT_9, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-0] - Use image in shortcut 10 */
  if (BALT(k, SDLK_0)) {
    json_t *res = Context_process_command(ctx, CMD_IMG_USE_SHORTCUT_10, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Alt-1] - Assign current image to shortcut 1 */
  if (BCTRLALT(k, SDLK_1)) {
    json_t *res = Context_process_command(ctx, CMD_IMG_STORE_SHORTCUT_1, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Alt-2] - Assign current image to shortcut 2 */
  if (BCTRLALT(k, SDLK_2)) {
    json_t *res = Context_process_command(ctx, CMD_IMG_STORE_SHORTCUT_2, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Alt-3] - Assign current image to shortcut 3 */
  if (BCTRLALT(k, SDLK_3)) {
    json_t *res = Context_process_command(ctx, CMD_IMG_STORE_SHORTCUT_3, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Alt-4] - Assign current image to shortcut 4 */
  if (BCTRLALT(k, SDLK_4)) {
    json_t *res = Context_process_command(ctx, CMD_IMG_STORE_SHORTCUT_4, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Alt-5] - Assign current image to shortcut 5 */
  if (BCTRLALT(k, SDLK_5)) {
    json_t *res = Context_process_command(ctx, CMD_IMG_STORE_SHORTCUT_5, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Alt-6] - Assign current image to shortcut 6 */
  if (BCTRLALT(k, SDLK_6)) {
    json_t *res = Context_process_command(ctx, CMD_IMG_STORE_SHORTCUT_6, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Alt-7] - Assign current image to shortcut 7 */
  if (BCTRLALT(k, SDLK_7)) {
    json_t *res = Context_process_command(ctx, CMD_IMG_STORE_SHORTCUT_7, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Alt-8] - Assign current image to shortcut 8 */
  if (BCTRLALT(k, SDLK_8)) {
    json_t *res = Context_process_command(ctx, CMD_IMG_STORE_SHORTCUT_8, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Alt-9] - Assign current image to shortcut 9 */
  if (BCTRLALT(k, SDLK_9)) {
    json_t *res = Context_process_command(ctx, CMD_IMG_STORE_SHORTCUT_9, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Alt-0] - Assign current image to shortcut 10 */
  if (BCTRLALT(k, SDLK_0)) {
    json_t *res = Context_process_command(ctx, CMD_IMG_STORE_SHORTCUT_10, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* =============== Banks =============== */

  /* [Ctrl-Shift-F1] - Clear bank 1 */
  if (BCTRLSHIFT(k, SDLK_F1)) {
    json_t *res = Context_process_command(ctx, CMD_APP_CLEAR_BANK_1, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-F2] - Clear bank 2 */
  if (BCTRLSHIFT(k, SDLK_F2)) {
    json_t *res = Context_process_command(ctx, CMD_APP_CLEAR_BANK_2, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-F3] - Clear bank 3 */
  if (BCTRLSHIFT(k, SDLK_F3)) {
    json_t *res = Context_process_command(ctx, CMD_APP_CLEAR_BANK_3, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-F4] - Clear bank 4 */
  if (BCTRLSHIFT(k, SDLK_F4)) {
    json_t *res = Context_process_command(ctx, CMD_APP_CLEAR_BANK_4, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-F5] - Clear bank 5 */
  if (BCTRLSHIFT(k, SDLK_F5)) {
    json_t *res = Context_process_command(ctx, CMD_APP_CLEAR_BANK_5, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-F6] - Clear bank 6 */
  if (BCTRLSHIFT(k, SDLK_F6)) {
    json_t *res = Context_process_command(ctx, CMD_APP_CLEAR_BANK_6, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-F7] - Clear bank 7 */
  if (BCTRLSHIFT(k, SDLK_F7)) {
    json_t *res = Context_process_command(ctx, CMD_APP_CLEAR_BANK_7, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-F8] - Clear bank 8 */
  if (BCTRLSHIFT(k, SDLK_F8)) {
    json_t *res = Context_process_command(ctx, CMD_APP_CLEAR_BANK_8, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-F9] - Clear bank 9 */
  if (BCTRLSHIFT(k, SDLK_F9)) {
    json_t *res = Context_process_command(ctx, CMD_APP_CLEAR_BANK_9, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-F10] - Clear bank 10 */
  if (BCTRLSHIFT(k, SDLK_F10)) {
    json_t *res = Context_process_command(ctx, CMD_APP_CLEAR_BANK_10, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-F11] - Clear bank 11 */
  if (BCTRLSHIFT(k, SDLK_F11)) {
    json_t *res = Context_process_command(ctx, CMD_APP_CLEAR_BANK_11, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-F12] - Clear bank 12 */
  if (BCTRLSHIFT(k, SDLK_F12)) {
    json_t *res = Context_process_command(ctx, CMD_APP_CLEAR_BANK_12, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-F13] - Clear bank 13 */
  if (BCTRLSHIFT(k, SDLK_F13)) {
    json_t *res = Context_process_command(ctx, CMD_APP_CLEAR_BANK_13, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-F14] - Clear bank 14 */
  if (BCTRLSHIFT(k, SDLK_F14)) {
    json_t *res = Context_process_command(ctx, CMD_APP_CLEAR_BANK_14, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-F15] - Clear bank 15 */
  if (BCTRLSHIFT(k, SDLK_F15)) {
    json_t *res = Context_process_command(ctx, CMD_APP_CLEAR_BANK_15, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-F16] - Clear bank 16 */
  if (BCTRLSHIFT(k, SDLK_F16)) {
    json_t *res = Context_process_command(ctx, CMD_APP_CLEAR_BANK_16, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-F17] - Clear bank 17 */
  if (BCTRLSHIFT(k, SDLK_F17)) {
    json_t *res = Context_process_command(ctx, CMD_APP_CLEAR_BANK_17, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-F18] - Clear bank 18 */
  if (BCTRLSHIFT(k, SDLK_F18)) {
    json_t *res = Context_process_command(ctx, CMD_APP_CLEAR_BANK_18, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-F19] - Clear bank 19 */
  if (BCTRLSHIFT(k, SDLK_F19)) {
    json_t *res = Context_process_command(ctx, CMD_APP_CLEAR_BANK_19, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-F20] - Clear bank 20 */
  if (BCTRLSHIFT(k, SDLK_F20)) {
    json_t *res = Context_process_command(ctx, CMD_APP_CLEAR_BANK_20, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-F21] - Clear bank 21 */
  if (BCTRLSHIFT(k, SDLK_F21)) {
    json_t *res = Context_process_command(ctx, CMD_APP_CLEAR_BANK_21, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-F22] - Clear bank 22 */
  if (BCTRLSHIFT(k, SDLK_F22)) {
    json_t *res = Context_process_command(ctx, CMD_APP_CLEAR_BANK_22, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-F23] - Clear bank 23 */
  if (BCTRLSHIFT(k, SDLK_F23)) {
    json_t *res = Context_process_command(ctx, CMD_APP_CLEAR_BANK_23, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Shift-F24] - Clear bank 24 */
  if (BCTRLSHIFT(k, SDLK_F24)) {
    json_t *res = Context_process_command(ctx, CMD_APP_CLEAR_BANK_24, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-F1] - Assign current sequence to bank 1 */
  if (BSHIFT(k, SDLK_F1)) {
    json_t *res = Context_process_command(ctx, CMD_APP_STORE_BANK_1, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-F2] - Assign current sequence to bank 2 */
  if (BSHIFT(k, SDLK_F2)) {
    json_t *res = Context_process_command(ctx, CMD_APP_STORE_BANK_2, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-F3] - Assign current sequence to bank 3 */
  if (BSHIFT(k, SDLK_F3)) {
    json_t *res = Context_process_command(ctx, CMD_APP_STORE_BANK_3, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-F4] - Assign current sequence to bank 4 */
  if (BSHIFT(k, SDLK_F4)) {
    json_t *res = Context_process_command(ctx, CMD_APP_STORE_BANK_4, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-F5] - Assign current sequence to bank 5 */
  if (BSHIFT(k, SDLK_F5)) {
    json_t *res = Context_process_command(ctx, CMD_APP_STORE_BANK_5, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-F6] - Assign current sequence to bank 6 */
  if (BSHIFT(k, SDLK_F6)) {
    json_t *res = Context_process_command(ctx, CMD_APP_STORE_BANK_6, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-F7] - Assign current sequence to bank 7 */
  if (BSHIFT(k, SDLK_F7)) {
    json_t *res = Context_process_command(ctx, CMD_APP_STORE_BANK_7, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-F8] - Assign current sequence to bank 8 */
  if (BSHIFT(k, SDLK_F8)) {
    json_t *res = Context_process_command(ctx, CMD_APP_STORE_BANK_8, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-F9] - Assign current sequence to bank 9 */
  if (BSHIFT(k, SDLK_F9)) {
    json_t *res = Context_process_command(ctx, CMD_APP_STORE_BANK_9, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-F10] - Assign current sequence to bank 10 */
  if (BSHIFT(k, SDLK_F10)) {
    json_t *res = Context_process_command(ctx, CMD_APP_STORE_BANK_10, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-F11] - Assign current sequence to bank 11 */
  if (BSHIFT(k, SDLK_F11)) {
    json_t *res = Context_process_command(ctx, CMD_APP_STORE_BANK_11, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Shift-F12] - Assign current sequence to bank 12 */
  if (BSHIFT(k, SDLK_F12)) {
    json_t *res = Context_process_command(ctx, CMD_APP_STORE_BANK_12, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-Shift-F1] - Use sequence in bank 1 */
  if (BALTSHIFT(k, SDLK_F1)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_1, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-Shift-F2] - Use sequence in bank 2 */
  if (BALTSHIFT(k, SDLK_F2)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_2, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-Shift-F3] - Use sequence in bank 3 */
  if (BALTSHIFT(k, SDLK_F3)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_3, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-Shift-F4] - Use sequence in bank 4 */
  if (BALTSHIFT(k, SDLK_F4)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_4, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-Shift-F5] - Use sequence in bank 5 */
  if (BALTSHIFT(k, SDLK_F5)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_5, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-Shift-F6] - Use sequence in bank 6 */
  if (BALTSHIFT(k, SDLK_F6)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_6, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-Shift-F7] - Use sequence in bank 7 */
  if (BALTSHIFT(k, SDLK_F7)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_7, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-Shift-F8] - Use sequence in bank 8 */
  if (BALTSHIFT(k, SDLK_F8)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_8, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-Shift-F9] - Use sequence in bank 9 */
  if (BALTSHIFT(k, SDLK_F9)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_9, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-Shift-F10] - Use sequence in bank 10 */
  if (BALTSHIFT(k, SDLK_F10)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_10, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-Shift-F11] - Use sequence in bank 11 */
  if (BALTSHIFT(k, SDLK_F11)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_11, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-Shift-F12] - Use sequence in bank 12 */
  if (BALTSHIFT(k, SDLK_F12)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_12, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-Shift-F13] - Use sequence in bank 13 */
  if (BALTSHIFT(k, SDLK_F13)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_13, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-Shift-F14] - Use sequence in bank 14 */
  if (BALTSHIFT(k, SDLK_F14)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_14, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-Shift-F15] - Use sequence in bank 15 */
  if (BALTSHIFT(k, SDLK_F15)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_15, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-Shift-F16] - Use sequence in bank 16 */
  if (BALTSHIFT(k, SDLK_F16)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_16, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-Shift-F17] - Use sequence in bank 17 */
  if (BALTSHIFT(k, SDLK_F17)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_17, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-Shift-F18] - Use sequence in bank 18 */
  if (BALTSHIFT(k, SDLK_F18)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_18, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-Shift-F19] - Use sequence in bank 19 */
  if (BALTSHIFT(k, SDLK_F19)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_19, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-Shift-F20] - Use sequence in bank 20 */
  if (BALTSHIFT(k, SDLK_F20)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_20, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-Shift-F21] - Use sequence in bank 21 */
  if (BALTSHIFT(k, SDLK_F21)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_21, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-Shift-F22] - Use sequence in bank 22 */
  if (BALTSHIFT(k, SDLK_F22)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_22, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-Shift-F23] - Use sequence in bank 23 */
  if (BALTSHIFT(k, SDLK_F23)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_23, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Alt-Shift-F24] - Use sequence in bank 24 */
  if (BALTSHIFT(k, SDLK_F24)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_24, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Alt-Shift-F1] - Use bank set 1 */
  if (BCTRLALTSHIFT(k, SDLK_F1)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_SET_1, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Alt-Shift-F2] - Use bank set 2 */
  if (BCTRLALTSHIFT(k, SDLK_F2)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_SET_2, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Alt-Shift-F3] - Use bank set 3 */
  if (BCTRLALTSHIFT(k, SDLK_F3)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_SET_3, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Alt-Shift-F4] - Use bank set 4 */
  if (BCTRLALTSHIFT(k, SDLK_F4)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_SET_4, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Alt-Shift-F5] - Use bank set 5 */
  if (BCTRLALTSHIFT(k, SDLK_F5)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_SET_5, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Alt-Shift-F6] - Use bank set 6 */
  if (BCTRLALTSHIFT(k, SDLK_F6)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_SET_6, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Alt-Shift-F7] - Use bank set 7 */
  if (BCTRLALTSHIFT(k, SDLK_F7)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_SET_7, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Alt-Shift-F8] - Use bank set 8 */
  if (BCTRLALTSHIFT(k, SDLK_F8)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_SET_8, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Alt-Shift-F9] - Use bank set 9 */
  if (BCTRLALTSHIFT(k, SDLK_F9)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_SET_9, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Alt-Shift-F10] - Use bank set 10 */
  if (BCTRLALTSHIFT(k, SDLK_F10)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_SET_10, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Alt-Shift-F11] - Use bank set 11 */
  if (BCTRLALTSHIFT(k, SDLK_F11)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_SET_11, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Alt-Shift-F12] - Use bank set 12 */
  if (BCTRLALTSHIFT(k, SDLK_F12)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_SET_12, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Alt-Shift-F13] - Use bank set 13 */
  if (BCTRLALTSHIFT(k, SDLK_F13)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_SET_13, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Alt-Shift-F14] - Use bank set 14 */
  if (BCTRLALTSHIFT(k, SDLK_F14)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_SET_14, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Alt-Shift-F15] - Use bank set 15 */
  if (BCTRLALTSHIFT(k, SDLK_F15)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_SET_15, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Alt-Shift-F16] - Use bank set 16 */
  if (BCTRLALTSHIFT(k, SDLK_F16)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_SET_16, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Alt-Shift-F17] - Use bank set 17 */
  if (BCTRLALTSHIFT(k, SDLK_F17)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_SET_17, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Alt-Shift-F18] - Use bank set 18 */
  if (BCTRLALTSHIFT(k, SDLK_F18)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_SET_18, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Alt-Shift-F19] - Use bank set 19 */
  if (BCTRLALTSHIFT(k, SDLK_F19)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_SET_19, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Alt-Shift-F20] - Use bank set 20 */
  if (BCTRLALTSHIFT(k, SDLK_F20)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_SET_20, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Alt-Shift-F21] - Use bank set 21 */
  if (BCTRLALTSHIFT(k, SDLK_F21)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_SET_21, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Alt-Shift-F22] - Use bank set 22 */
  if (BCTRLALTSHIFT(k, SDLK_F22)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_SET_22, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Alt-Shift-F23] - Use bank set 23 */
  if (BCTRLALTSHIFT(k, SDLK_F23)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_SET_23, NULL, BC_SDL2);
    json_decref(res);
    return;
  }

  /* [Ctrl-Alt-Shift-F24] - Use bank set 24 */
  if (BCTRLALTSHIFT(k, SDLK_F24)) {
    json_t *res = Context_process_command(ctx, CMD_APP_USE_BANK_SET_24, NULL, BC_SDL2);
    json_decref(res);
    return;
  }
}
