/***********************************************************************************

    Copyright (C) 2010 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#include "dialog_preferences.hpp"
#include "app_window.hpp"

namespace LIFEO
{

// STATIC MEMBERS
DialogPreferences *DialogPreferences::ptr;


DialogPreferences::DialogPreferences( BaseObjectType* cobject,
                                      const Glib::RefPtr< Gtk::Builder > &refbuilder )
:    DialogEvent( cobject, refbuilder )
{
    auto builder{ Lifeograph::get_builder2() };
    builder->get_widget( "Bx_max_idle_time", m_Bx_max_idle_time );
    builder->get_widget( "Ch_autologout", m_ChB_autologout );
    builder->get_widget( "SB_max_idle_time", m_SpB_max_idle_time );
    builder->get_widget( "Ch_formatting_toolbar", m_ChB_formatting_toolbar );
    builder->get_widget( "CB_prefs_date_order", m_CB_date_order );
    builder->get_widget( "CB_prefs_date_separator", m_CB_date_separator );

    m_ChB_autologout->set_active( Lifeograph::settings.autologout );
    m_Bx_max_idle_time->set_sensitive( Lifeograph::settings.autologout );
    m_SpB_max_idle_time->set_value( Lifeograph::settings.idletime );
    m_CB_date_order->set_active( Lifeograph::settings.date_format_order );
    m_CB_date_separator->set_active( Lifeograph::settings.date_format_separator );

    m_ChB_formatting_toolbar->set_active( Lifeograph::settings.show_formatting_toolbar );

    m_ChB_autologout->signal_toggled().connect(
            sigc::mem_fun( *this, &DialogPreferences::handle_ChB_autologout_toggled ) );

    m_ChB_formatting_toolbar->signal_toggled().connect(
            sigc::mem_fun( *this, &DialogPreferences::handle_ChB_ftoolbar_toggled ) );

    m_CB_date_order->signal_changed().connect(
            sigc::mem_fun( *this, &DialogPreferences::update_date_format ) );
    m_CB_date_separator->signal_changed().connect(
            sigc::mem_fun( *this, &DialogPreferences::update_date_format ) );

    signal_response().connect(
            sigc::mem_fun( *this, &DialogPreferences::handle_response ) );
}

void
DialogPreferences::handle_ChB_autologout_toggled()
{
    m_Bx_max_idle_time->set_sensitive( m_ChB_autologout->get_active() );
}

void
DialogPreferences::handle_ChB_ftoolbar_toggled()
{
    Lifeograph::settings.show_formatting_toolbar = m_ChB_formatting_toolbar->get_active();
    if( Lifeograph::loginstatus == Lifeograph::LOGGED_IN )
        AppWindow::p->m_entry_view->update_formatting_toolbar();
}

void
DialogPreferences::update_date_format()
{
    Lifeograph::settings.date_format_order = m_CB_date_order->get_active_row_number();
    Lifeograph::settings.date_format_separator = m_CB_date_separator->get_active_row_number();
    Lifeograph::settings.update_date_format();

    if( Lifeograph::loginstatus == Lifeograph::LOGGED_IN )
    {
        AppWindow::p->panel_diary->update_entry_list();
        AppWindow::p->panel_main->refresh_title();
    }
}

void
DialogPreferences::handle_response( int )
{
    // APPLY CHANGES
    Lifeograph::settings.autologout = m_ChB_autologout->get_active();
    Lifeograph::settings.idletime = m_SpB_max_idle_time->get_value_as_int();
    AppWindow::p->update_toggle_auto_logout_gui( true );
}

void
DialogPreferences::create()
{
    // FIXME: for some reason subsequent usages of get_widget_derived causes an...
    // ...empty dialog to be shown
    if( ptr  == nullptr )
        Lifeograph::get_builder2()->get_widget_derived( "D_preferences", ptr );
    ptr->run();
    ptr->hide();
}

}
