/*
 * Copyright (c) 2010-2019 Belledonne Communications SARL.
 *
 * This file is part of Liblinphone.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "logger/logger.h"

#include "core-accessor.h"

// =============================================================================

using namespace std;

LINPHONE_BEGIN_NAMESPACE

class CoreAccessorPrivate {
public:
	weak_ptr<Core> core;
};

// -----------------------------------------------------------------------------

CoreAccessor::CoreAccessor (const shared_ptr<Core> &core) {
	L_ASSERT(core);
	mPrivate = new CoreAccessorPrivate();
	mPrivate->core = core;
}

CoreAccessor::~CoreAccessor () {
	delete mPrivate;
}

shared_ptr<Core> CoreAccessor::getCore () const {
	L_D();

	shared_ptr<Core> core = d->core.lock();
	if (!core) {
		lWarning() << "Unable to get valid core instance.";
		throw bad_weak_ptr();
	}

	return core;
}

LINPHONE_END_NAMESPACE
