# games -- lintian check script -*- perl -*-

# Copyright (C) 1998 Christian Schwarz and Richard Braakman
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, you can find it on the World Wide
# Web at http://www.gnu.org/copyleft/gpl.html, or write to the Free
# Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
# MA 02110-1301, USA.

package Lintian::games;

use strict;
use warnings;
use autodie;

use constant EMPTY => q{};

use Moo;
use namespace::clean;

with 'Lintian::Check';

sub files {
    my ($self, $file) = @_;

    # non-games-specific data in games subdirectory
    if ($file->name=~ m,^usr/share/games/(?:applications|mime|icons|pixmaps)/,
        and not $file->is_dir) {

        $self->tag('global-data-in-games-directory', $file->name);
    }

    return;
}

sub dir_counts {
    my ($self, $filename) = @_;

    my $file = $self->processable->installed->lookup($filename);

    return 0
      unless $file;

    return scalar $file->children;
}

sub always {
    my ($self) = @_;

    my $section = $self->processable->field('section', EMPTY);

    # section games but nothing in /usr/games
    # any binary counts to avoid game-data false positives:
    my $games = $self->dir_counts('usr/games/');
    my $other = $self->dir_counts('bin/') + $self->dir_counts('usr/bin/');

    if ($other) {
        if ($section =~ m,games$,) {

            if ($games) {
                $self->tag('package-section-games-but-has-usr-bin');

            } else {
                $self->tag('package-section-games-but-contains-no-game');
            }
        }

    } elsif ($games > 0 and $section !~ m,games$,) {
        $self->tag('games-package-should-be-section-games');
    }

    return;
}

1;

# Local Variables:
# indent-tabs-mode: nil
# cperl-indent-level: 4
# End:
# vim: syntax=perl sw=4 sts=4 sr et
