/********************************************************************
* Description: emc.cc
*
*   An auto-generated file to handle the update functions and
*   routing of messages to the correct buffer/processes.
*
*   NOTICE:  this file has been manually edited for LinuxCNC, the
*   Java CodeGen utility should _NOT_ be used for LinuxCNC, it will
*   overwrite this file!!
*
* Author:
* License: GPL Version 2
* System: Linux
*
* Copyright (c) 2004 All rights reserved.
*
* Last change:
********************************************************************/

// Include all NML, CMS, and RCS classes and functions
#include "rcs.hh"

// Include command and status message definitions
#include "canon.hh"
#include "canon_position.hh"
#include "emc.hh"
#include "emc_nml.hh"
#include "emcglb.h"
#include "emcpos.h"
#include "cms.hh"

// Forward Function Prototypes
void EmcPose_update(CMS * cms, EmcPose * x);
void CANON_TOOL_TABLE_update(CMS * cms, CANON_TOOL_TABLE * x);
void PmCartesian_update(CMS * cms, PmCartesian * x);
void initialize_PmCartesian(PmCartesian * x);
void CANON_VECTOR_update(CMS * cms, CANON_VECTOR * x);
void initialize_CANON_TOOL_TABLE(CANON_TOOL_TABLE * x);
void initialize_EmcPose(EmcPose * x);
void CANON_POSITION_update(CMS * cms, CANON_POSITION * x);
void initialize_CANON_POSITION(CANON_POSITION * x);

/*
*	NML/CMS Format function : emcFormat
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
int emcFormat(NMLTYPE type, void *buffer, CMS * cms)
{
    switch (type) {
    case EMC_ABORT_TYPE:
	((EMC_ABORT *) buffer)->update(cms);
	break;
    case EMC_AUX_ESTOP_RESET_TYPE:
	((EMC_AUX_ESTOP_RESET *) buffer)->update(cms);
	break;
    case EMC_AUX_ESTOP_OFF_TYPE:
	((EMC_AUX_ESTOP_OFF *) buffer)->update(cms);
	break;
    case EMC_AUX_ESTOP_ON_TYPE:
	((EMC_AUX_ESTOP_ON *) buffer)->update(cms);
	break;
    case EMC_AUX_STAT_TYPE:
	((EMC_AUX_STAT *) buffer)->update(cms);
	break;
    case EMC_JOINT_ABORT_TYPE:
	((EMC_JOINT_ABORT *) buffer)->update(cms);
	break;
    case EMC_JOINT_ACTIVATE_TYPE:
	((EMC_JOINT_ACTIVATE *) buffer)->update(cms);
	break;
    case EMC_JOINT_DEACTIVATE_TYPE:
	((EMC_JOINT_DEACTIVATE *) buffer)->update(cms);
	break;
    case EMC_JOINT_DISABLE_TYPE:
	((EMC_JOINT_DISABLE *) buffer)->update(cms);
	break;
    case EMC_JOINT_ENABLE_TYPE:
	((EMC_JOINT_ENABLE *) buffer)->update(cms);
	break;
    case EMC_JOINT_HALT_TYPE:
	((EMC_JOINT_HALT *) buffer)->update(cms);
	break;
    case EMC_JOINT_HOME_TYPE:
	((EMC_JOINT_HOME *) buffer)->update(cms);
	break;
    case EMC_JOINT_UNHOME_TYPE:
	((EMC_JOINT_UNHOME *) buffer)->update(cms);
	break;
    case EMC_JOINT_INIT_TYPE:
	((EMC_JOINT_INIT *) buffer)->update(cms);
	break;
    case EMC_JOG_CONT_TYPE:
	((EMC_JOG_CONT *) buffer)->update(cms);
	break;
    case EMC_JOG_INCR_TYPE:
	((EMC_JOG_INCR *) buffer)->update(cms);
	break;
    case EMC_JOG_ABS_TYPE:
	((EMC_JOG_ABS *) buffer)->update(cms);
	break;
    case EMC_JOG_STOP_TYPE:
	((EMC_JOG_STOP *) buffer)->update(cms);
	break;
    case EMC_JOINT_LOAD_COMP_TYPE:
	((EMC_JOINT_LOAD_COMP *) buffer)->update(cms);
	break;
    case EMC_JOINT_OVERRIDE_LIMITS_TYPE:
	((EMC_JOINT_OVERRIDE_LIMITS *) buffer)->update(cms);
	break;
    case EMC_JOINT_SET_JOINT_TYPE:
	((EMC_JOINT_SET_JOINT *) buffer)->update(cms);
	break;
    case EMC_JOINT_SET_FERROR_TYPE:
	((EMC_JOINT_SET_FERROR *) buffer)->update(cms);
	break;
    case EMC_JOINT_SET_BACKLASH_TYPE:
	((EMC_JOINT_SET_BACKLASH *) buffer)->update(cms);
	break;
    case EMC_JOINT_SET_HOMING_PARAMS_TYPE:
	((EMC_JOINT_SET_HOMING_PARAMS *) buffer)->update(cms);
	break;
    case EMC_JOINT_SET_MAX_POSITION_LIMIT_TYPE:
	((EMC_JOINT_SET_MAX_POSITION_LIMIT *) buffer)->update(cms);
	break;
    case EMC_JOINT_SET_MAX_VELOCITY_TYPE:
	((EMC_JOINT_SET_MAX_VELOCITY *) buffer)->update(cms);
	break;
    case EMC_JOINT_SET_MIN_FERROR_TYPE:
	((EMC_JOINT_SET_MIN_FERROR *) buffer)->update(cms);
	break;
    case EMC_JOINT_SET_MIN_POSITION_LIMIT_TYPE:
	((EMC_JOINT_SET_MIN_POSITION_LIMIT *) buffer)->update(cms);
	break;
    case EMC_JOINT_SET_UNITS_TYPE:
	((EMC_JOINT_SET_UNITS *) buffer)->update(cms);
	break;
    case EMC_JOINT_STAT_TYPE:
	((EMC_JOINT_STAT *) buffer)->update(cms);
	break;
    case EMC_COOLANT_FLOOD_OFF_TYPE:
	((EMC_COOLANT_FLOOD_OFF *) buffer)->update(cms);
	break;
    case EMC_COOLANT_FLOOD_ON_TYPE:
	((EMC_COOLANT_FLOOD_ON *) buffer)->update(cms);
	break;
    case EMC_COOLANT_MIST_OFF_TYPE:
	((EMC_COOLANT_MIST_OFF *) buffer)->update(cms);
	break;
    case EMC_COOLANT_MIST_ON_TYPE:
	((EMC_COOLANT_MIST_ON *) buffer)->update(cms);
	break;
    case EMC_COOLANT_STAT_TYPE:
	((EMC_COOLANT_STAT *) buffer)->update(cms);
	break;
    case EMC_HALT_TYPE:
	((EMC_HALT *) buffer)->update(cms);
	break;
    case EMC_INIT_TYPE:
	((EMC_INIT *) buffer)->update(cms);
	break;
    case EMC_IO_ABORT_TYPE:
	((EMC_IO_ABORT *) buffer)->update(cms);
	break;
    case EMC_IO_HALT_TYPE:
	((EMC_IO_HALT *) buffer)->update(cms);
	break;
    case EMC_IO_INIT_TYPE:
	((EMC_IO_INIT *) buffer)->update(cms);
	break;
    case EMC_IO_SET_CYCLE_TIME_TYPE:
	((EMC_IO_SET_CYCLE_TIME *) buffer)->update(cms);
	break;
    case EMC_IO_STAT_TYPE:
	((EMC_IO_STAT *) buffer)->update(cms);
	break;
    case EMC_LUBE_OFF_TYPE:
	((EMC_LUBE_OFF *) buffer)->update(cms);
	break;
    case EMC_LUBE_ON_TYPE:
	((EMC_LUBE_ON *) buffer)->update(cms);
	break;
    case EMC_LUBE_STAT_TYPE:
	((EMC_LUBE_STAT *) buffer)->update(cms);
	break;
    case EMC_MOTION_ABORT_TYPE:
	((EMC_MOTION_ABORT *) buffer)->update(cms);
	break;
    case EMC_MOTION_HALT_TYPE:
	((EMC_MOTION_HALT *) buffer)->update(cms);
	break;
    case EMC_MOTION_INIT_TYPE:
	((EMC_MOTION_INIT *) buffer)->update(cms);
	break;
    case EMC_MOTION_SET_AOUT_TYPE:
	((EMC_MOTION_SET_AOUT *) buffer)->update(cms);
	break;
    case EMC_MOTION_SET_DOUT_TYPE:
	((EMC_MOTION_SET_DOUT *) buffer)->update(cms);
	break;
    case EMC_MOTION_ADAPTIVE_TYPE:
	((EMC_MOTION_ADAPTIVE *) buffer)->update(cms);
	break;
    case EMC_MOTION_STAT_TYPE:
	((EMC_MOTION_STAT *) buffer)->update(cms);
	break;
    case EMC_NULL_TYPE:
	((EMC_NULL *) buffer)->update(cms);
	break;
    case EMC_OPERATOR_DISPLAY_TYPE:
	((EMC_OPERATOR_DISPLAY *) buffer)->update(cms);
	break;
    case EMC_OPERATOR_ERROR_TYPE:
	((EMC_OPERATOR_ERROR *) buffer)->update(cms);
	break;
    case EMC_OPERATOR_TEXT_TYPE:
	((EMC_OPERATOR_TEXT *) buffer)->update(cms);
	break;
    case EMC_SYSTEM_CMD_TYPE:
	((EMC_SYSTEM_CMD *) buffer)->update(cms);
	break;
    case EMC_SET_DEBUG_TYPE:
	((EMC_SET_DEBUG *) buffer)->update(cms);
	break;
    case EMC_SPINDLE_BRAKE_ENGAGE_TYPE:
	((EMC_SPINDLE_BRAKE_ENGAGE *) buffer)->update(cms);
	break;
    case EMC_SPINDLE_BRAKE_RELEASE_TYPE:
	((EMC_SPINDLE_BRAKE_RELEASE *) buffer)->update(cms);
	break;
    case EMC_SPINDLE_CONSTANT_TYPE:
	((EMC_SPINDLE_CONSTANT *) buffer)->update(cms);
	break;
    case EMC_SPINDLE_DECREASE_TYPE:
	((EMC_SPINDLE_DECREASE *) buffer)->update(cms);
	break;
    case EMC_SPINDLE_INCREASE_TYPE:
	((EMC_SPINDLE_INCREASE *) buffer)->update(cms);
	break;
    case EMC_SPINDLE_OFF_TYPE:
	((EMC_SPINDLE_OFF *) buffer)->update(cms);
	break;
    case EMC_SPINDLE_ON_TYPE:
	((EMC_SPINDLE_ON *) buffer)->update(cms);
	break;
    case EMC_SPINDLE_SPEED_TYPE:
	((EMC_SPINDLE_SPEED *) buffer)->update(cms);
	break;
    case EMC_SPINDLE_ORIENT_TYPE:
	((EMC_SPINDLE_ORIENT *) buffer)->update(cms);
	break;
    case EMC_SPINDLE_WAIT_ORIENT_COMPLETE_TYPE:
	((EMC_SPINDLE_WAIT_ORIENT_COMPLETE *) buffer)->update(cms);
	break;
    case EMC_SPINDLE_STAT_TYPE:
	((EMC_SPINDLE_STAT *) buffer)->update(cms);
	break;
    case EMC_STAT_TYPE:
	((EMC_STAT *) buffer)->update(cms);
	break;
    case EMC_TASK_ABORT_TYPE:
	((EMC_TASK_ABORT *) buffer)->update(cms);
	break;
    case EMC_TASK_HALT_TYPE:
	((EMC_TASK_HALT *) buffer)->update(cms);
	break;
    case EMC_TASK_INIT_TYPE:
	((EMC_TASK_INIT *) buffer)->update(cms);
	break;
    case EMC_TASK_PLAN_CLOSE_TYPE:
	((EMC_TASK_PLAN_CLOSE *) buffer)->update(cms);
	break;
    case EMC_TASK_PLAN_END_TYPE:
	((EMC_TASK_PLAN_END *) buffer)->update(cms);
	break;
    case EMC_TASK_PLAN_EXECUTE_TYPE:
	((EMC_TASK_PLAN_EXECUTE *) buffer)->update(cms);
	break;
    case EMC_TASK_PLAN_INIT_TYPE:
	((EMC_TASK_PLAN_INIT *) buffer)->update(cms);
	break;
    case EMC_TASK_PLAN_OPEN_TYPE:
	((EMC_TASK_PLAN_OPEN *) buffer)->update(cms);
	break;
    case EMC_TASK_PLAN_PAUSE_TYPE:
	((EMC_TASK_PLAN_PAUSE *) buffer)->update(cms);
	break;
    case EMC_TASK_PLAN_READ_TYPE:
	((EMC_TASK_PLAN_READ *) buffer)->update(cms);
	break;
    case EMC_TASK_PLAN_RESUME_TYPE:
	((EMC_TASK_PLAN_RESUME *) buffer)->update(cms);
	break;
    case EMC_TASK_PLAN_RUN_TYPE:
	((EMC_TASK_PLAN_RUN *) buffer)->update(cms);
	break;
    case EMC_TASK_PLAN_STEP_TYPE:
	((EMC_TASK_PLAN_STEP *) buffer)->update(cms);
	break;
    case EMC_TASK_PLAN_SYNCH_TYPE:
	((EMC_TASK_PLAN_SYNCH *) buffer)->update(cms);
	break;
    case EMC_TASK_PLAN_SET_OPTIONAL_STOP_TYPE:
	((EMC_TASK_PLAN_SET_OPTIONAL_STOP *) buffer)->update(cms);
	break;
    case EMC_TASK_PLAN_SET_BLOCK_DELETE_TYPE:
	((EMC_TASK_PLAN_SET_BLOCK_DELETE *) buffer)->update(cms);
	break;
    case EMC_TASK_PLAN_OPTIONAL_STOP_TYPE:
	((EMC_TASK_PLAN_OPTIONAL_STOP *) buffer)->update(cms);
	break;
    case EMC_TASK_SET_MODE_TYPE:
	((EMC_TASK_SET_MODE *) buffer)->update(cms);
	break;
    case EMC_TASK_SET_STATE_TYPE:
	((EMC_TASK_SET_STATE *) buffer)->update(cms);
	break;
    case EMC_TASK_STAT_TYPE:
	((EMC_TASK_STAT *) buffer)->update(cms);
	break;
    case EMC_TOOL_ABORT_TYPE:
	((EMC_TOOL_ABORT *) buffer)->update(cms);
	break;
    case EMC_TOOL_HALT_TYPE:
	((EMC_TOOL_HALT *) buffer)->update(cms);
	break;
    case EMC_TOOL_INIT_TYPE:
	((EMC_TOOL_INIT *) buffer)->update(cms);
	break;
    case EMC_TOOL_LOAD_TYPE:
	((EMC_TOOL_LOAD *) buffer)->update(cms);
	break;
    case EMC_TOOL_LOAD_TOOL_TABLE_TYPE:
	((EMC_TOOL_LOAD_TOOL_TABLE *) buffer)->update(cms);
	break;
    case EMC_TOOL_PREPARE_TYPE:
	((EMC_TOOL_PREPARE *) buffer)->update(cms);
	break;
    case EMC_TOOL_SET_OFFSET_TYPE:
	((EMC_TOOL_SET_OFFSET *) buffer)->update(cms);
	break;
    case EMC_TOOL_SET_NUMBER_TYPE:
	((EMC_TOOL_SET_NUMBER *) buffer)->update(cms);
	break;
    case EMC_TOOL_START_CHANGE_TYPE:
	((EMC_TOOL_START_CHANGE *) buffer)->update(cms);
	break;
    case EMC_TOOL_STAT_TYPE:
	((EMC_TOOL_STAT *) buffer)->update(cms);
	break;
    case EMC_TOOL_UNLOAD_TYPE:
	((EMC_TOOL_UNLOAD *) buffer)->update(cms);
	break;
    case EMC_TRAJ_ABORT_TYPE:
	((EMC_TRAJ_ABORT *) buffer)->update(cms);
	break;
    case EMC_TRAJ_CLEAR_PROBE_TRIPPED_FLAG_TYPE:
	((EMC_TRAJ_CLEAR_PROBE_TRIPPED_FLAG *) buffer)->update(cms);
	break;
    case EMC_TRAJ_DELAY_TYPE:
	((EMC_TRAJ_DELAY *) buffer)->update(cms);
	break;
    case EMC_TRAJ_DISABLE_TYPE:
	((EMC_TRAJ_DISABLE *) buffer)->update(cms);
	break;
    case EMC_TRAJ_ENABLE_TYPE:
	((EMC_TRAJ_ENABLE *) buffer)->update(cms);
	break;
    case EMC_TRAJ_HALT_TYPE:
	((EMC_TRAJ_HALT *) buffer)->update(cms);
	break;
    case EMC_TRAJ_INIT_TYPE:
	((EMC_TRAJ_INIT *) buffer)->update(cms);
	break;
    case EMC_TRAJ_LINEAR_MOVE_TYPE:
	((EMC_TRAJ_LINEAR_MOVE *) buffer)->update(cms);
	break;
    case EMC_TRAJ_CIRCULAR_MOVE_TYPE:
	((EMC_TRAJ_CIRCULAR_MOVE *) buffer)->update(cms);
	break;
    case EMC_TRAJ_RIGID_TAP_TYPE:
	((EMC_TRAJ_RIGID_TAP *) buffer)->update(cms);
        break;
    case EMC_TRAJ_PAUSE_TYPE:
	((EMC_TRAJ_PAUSE *) buffer)->update(cms);
	break;
    case EMC_TRAJ_PROBE_TYPE:
	((EMC_TRAJ_PROBE *) buffer)->update(cms);
	break;
    case EMC_AUX_INPUT_WAIT_TYPE:
	((EMC_AUX_INPUT_WAIT *) buffer)->update(cms);
	break;
    case EMC_TRAJ_RESUME_TYPE:
	((EMC_TRAJ_RESUME *) buffer)->update(cms);
	break;
    case EMC_TRAJ_SET_ACCELERATION_TYPE:
	((EMC_TRAJ_SET_ACCELERATION *) buffer)->update(cms);
	break;
    case EMC_TRAJ_SET_AXES_TYPE:
	((EMC_TRAJ_SET_AXES *) buffer)->update(cms);
	break;
    case EMC_TRAJ_SET_CYCLE_TIME_TYPE:
	((EMC_TRAJ_SET_CYCLE_TIME *) buffer)->update(cms);
	break;
    case EMC_TRAJ_SET_HOME_TYPE:
	((EMC_TRAJ_SET_HOME *) buffer)->update(cms);
	break;
    case EMC_TRAJ_SET_MAX_ACCELERATION_TYPE:
	((EMC_TRAJ_SET_MAX_ACCELERATION *) buffer)->update(cms);
	break;
    case EMC_TRAJ_SET_MAX_VELOCITY_TYPE:
	((EMC_TRAJ_SET_MAX_VELOCITY *) buffer)->update(cms);
	break;
    case EMC_TRAJ_SET_MODE_TYPE:
	((EMC_TRAJ_SET_MODE *) buffer)->update(cms);
	break;
    case EMC_TRAJ_SET_MOTION_ID_TYPE:
	((EMC_TRAJ_SET_MOTION_ID *) buffer)->update(cms);
	break;
    case EMC_TRAJ_SET_OFFSET_TYPE:
	((EMC_TRAJ_SET_OFFSET *) buffer)->update(cms);
	break;
    case EMC_TRAJ_SET_G5X_TYPE:
	((EMC_TRAJ_SET_G5X *) buffer)->update(cms);
	break;
    case EMC_TRAJ_SET_G92_TYPE:
	((EMC_TRAJ_SET_G92 *) buffer)->update(cms);
	break;
    case EMC_TRAJ_SET_ROTATION_TYPE:
	((EMC_TRAJ_SET_ROTATION *) buffer)->update(cms);
	break;
    case EMC_TRAJ_SET_SCALE_TYPE:
	((EMC_TRAJ_SET_SCALE *) buffer)->update(cms);
	break;
    case EMC_TRAJ_SET_RAPID_SCALE_TYPE:
	((EMC_TRAJ_SET_RAPID_SCALE *) buffer)->update(cms);
	break;
    case EMC_TRAJ_SET_SPINDLE_SCALE_TYPE:
	((EMC_TRAJ_SET_SPINDLE_SCALE *) buffer)->update(cms);
	break;
    case EMC_TRAJ_SET_FO_ENABLE_TYPE:
	((EMC_TRAJ_SET_FO_ENABLE *) buffer)->update(cms);
	break;
    case EMC_TRAJ_SET_SO_ENABLE_TYPE:
	((EMC_TRAJ_SET_SO_ENABLE *) buffer)->update(cms);
	break;
    case EMC_TRAJ_SET_FH_ENABLE_TYPE:
	((EMC_TRAJ_SET_FH_ENABLE *) buffer)->update(cms);
	break;
    case EMC_TRAJ_SET_TELEOP_ENABLE_TYPE:
	((EMC_TRAJ_SET_TELEOP_ENABLE *) buffer)->update(cms);
	break;
    case EMC_TRAJ_SET_TERM_COND_TYPE:
	((EMC_TRAJ_SET_TERM_COND *) buffer)->update(cms);
	break;
    case EMC_TRAJ_SET_SPINDLESYNC_TYPE:
        ((EMC_TRAJ_SET_SPINDLESYNC *) buffer)->update(cms);
        break;
    case EMC_TRAJ_SET_UNITS_TYPE:
	((EMC_TRAJ_SET_UNITS *) buffer)->update(cms);
	break;
    case EMC_TRAJ_SET_VELOCITY_TYPE:
	((EMC_TRAJ_SET_VELOCITY *) buffer)->update(cms);
	break;
    case EMC_TRAJ_STAT_TYPE:
	((EMC_TRAJ_STAT *) buffer)->update(cms);
	break;
    case EMC_TRAJ_STEP_TYPE:
	((EMC_TRAJ_STEP *) buffer)->update(cms);
	break;

    default:
	return (0);
    }
    return 1;
}

// NML Symbol Lookup Function
const char *emc_symbol_lookup(uint32_t type)
{
    switch (type) {
    case EMC_ABORT_TYPE:
	return "EMC_ABORT";
    case EMC_EXEC_PLUGIN_CALL_TYPE:
	return "EMC_EXEC_PLUGIN_CALL";
    case EMC_AUX_ESTOP_RESET_TYPE:
	return "EMC_AUX_ESTOP_RESET";
    case EMC_AUX_ESTOP_OFF_TYPE:
	return "EMC_AUX_ESTOP_OFF";
    case EMC_AUX_ESTOP_ON_TYPE:
	return "EMC_AUX_ESTOP_ON";
    case EMC_AUX_STAT_TYPE:
	return "EMC_AUX_STAT";
    case EMC_JOINT_ABORT_TYPE:
	return "EMC_JOINT_ABORT";
    case EMC_JOINT_ACTIVATE_TYPE:
	return "EMC_JOINT_ACTIVATE";
    case EMC_JOINT_DEACTIVATE_TYPE:
	return "EMC_JOINT_DEACTIVATE";
    case EMC_JOINT_DISABLE_TYPE:
	return "EMC_JOINT_DISABLE";
    case EMC_JOINT_ENABLE_TYPE:
	return "EMC_JOINT_ENABLE";
    case EMC_JOINT_HALT_TYPE:
	return "EMC_JOINT_HALT";
    case EMC_JOINT_HOME_TYPE:
	return "EMC_JOINT_HOME";
    case EMC_JOINT_UNHOME_TYPE:
	return "EMC_JOINT_UNHOME";
    case EMC_JOG_CONT_TYPE:
	return "EMC_JOG_CONT";
    case EMC_JOG_INCR_TYPE:
	return "EMC_JOG_INCR";
    case EMC_JOG_ABS_TYPE:
	return "EMC_JOG_ABS";
    case EMC_JOG_STOP_TYPE:
	return "EMC_JOG_STOP";
    case EMC_JOINT_INIT_TYPE:
	return "EMC_JOINT_INIT";
    case EMC_JOINT_LOAD_COMP_TYPE:
	return "EMC_JOINT_LOAD_COMP";
    case EMC_JOINT_OVERRIDE_LIMITS_TYPE:
	return "EMC_JOINT_OVERRIDE_LIMITS";
    case EMC_JOINT_SET_JOINT_TYPE:
	return "EMC_JOINT_SET_AXIS";
    case EMC_JOINT_SET_FERROR_TYPE:
	return "EMC_JOINT_SET_FERROR";
    case EMC_JOINT_SET_BACKLASH_TYPE:
	return "EMC_JOINT_SET_BACKLASH";
    case EMC_JOINT_SET_HOMING_PARAMS_TYPE:
	return "EMC_JOINT_SET_HOMING_PARAMS";
    case EMC_JOINT_SET_MAX_POSITION_LIMIT_TYPE:
	return "EMC_JOINT_SET_MAX_POSITION_LIMIT";
    case EMC_JOINT_SET_MAX_VELOCITY_TYPE:
	return "EMC_JOINT_SET_MAX_VELOCITY";
    case EMC_JOINT_SET_MIN_FERROR_TYPE:
	return "EMC_JOINT_SET_MIN_FERROR";
    case EMC_JOINT_SET_MIN_POSITION_LIMIT_TYPE:
	return "EMC_JOINT_SET_MIN_POSITION_LIMIT";
    case EMC_JOINT_SET_UNITS_TYPE:
	return "EMC_JOINT_SET_UNITS";
    case EMC_JOINT_STAT_TYPE:
	return "EMC_JOINT_STAT";
    case EMC_COOLANT_FLOOD_OFF_TYPE:
	return "EMC_COOLANT_FLOOD_OFF";
    case EMC_COOLANT_FLOOD_ON_TYPE:
	return "EMC_COOLANT_FLOOD_ON";
    case EMC_COOLANT_MIST_OFF_TYPE:
	return "EMC_COOLANT_MIST_OFF";
    case EMC_COOLANT_MIST_ON_TYPE:
	return "EMC_COOLANT_MIST_ON";
    case EMC_COOLANT_STAT_TYPE:
	return "EMC_COOLANT_STAT";
    case EMC_HALT_TYPE:
	return "EMC_HALT";
    case EMC_INIT_TYPE:
	return "EMC_INIT";
    case EMC_IO_ABORT_TYPE:
	return "EMC_IO_ABORT";
    case EMC_IO_HALT_TYPE:
	return "EMC_IO_HALT";
    case EMC_IO_INIT_TYPE:
	return "EMC_IO_INIT";
    case EMC_IO_SET_CYCLE_TIME_TYPE:
	return "EMC_IO_SET_CYCLE_TIME";
    case EMC_IO_STAT_TYPE:
	return "EMC_IO_STAT";
    case EMC_LUBE_OFF_TYPE:
	return "EMC_LUBE_OFF";
    case EMC_LUBE_ON_TYPE:
	return "EMC_LUBE_ON";
    case EMC_LUBE_STAT_TYPE:
	return "EMC_LUBE_STAT";
    case EMC_MOTION_ABORT_TYPE:
	return "EMC_MOTION_ABORT";
    case EMC_MOTION_HALT_TYPE:
	return "EMC_MOTION_HALT";
    case EMC_MOTION_INIT_TYPE:
	return "EMC_MOTION_INIT";
    case EMC_MOTION_SET_AOUT_TYPE:
	return "EMC_MOTION_SET_AOUT";
    case EMC_MOTION_SET_DOUT_TYPE:
	return "EMC_MOTION_SET_DOUT";
    case EMC_MOTION_ADAPTIVE_TYPE:
	return "EMC_MOTION_ADAPTIVE";
    case EMC_MOTION_STAT_TYPE:
	return "EMC_MOTION_STAT";
    case EMC_NULL_TYPE:
	return "EMC_NULL";
    case EMC_OPERATOR_DISPLAY_TYPE:
	return "EMC_OPERATOR_DISPLAY";
    case EMC_OPERATOR_ERROR_TYPE:
	return "EMC_OPERATOR_ERROR";
    case EMC_OPERATOR_TEXT_TYPE:
	return "EMC_OPERATOR_TEXT";
    case EMC_SYSTEM_CMD_TYPE:
	return "EMC_SYSTEM_CMD";
    case EMC_SET_DEBUG_TYPE:
	return "EMC_SET_DEBUG";
    case EMC_SPINDLE_BRAKE_ENGAGE_TYPE:
	return "EMC_SPINDLE_BRAKE_ENGAGE";
    case EMC_SPINDLE_BRAKE_RELEASE_TYPE:
	return "EMC_SPINDLE_BRAKE_RELEASE";
    case EMC_SPINDLE_CONSTANT_TYPE:
	return "EMC_SPINDLE_CONSTANT";
    case EMC_SPINDLE_DECREASE_TYPE:
	return "EMC_SPINDLE_DECREASE";
    case EMC_SPINDLE_INCREASE_TYPE:
	return "EMC_SPINDLE_INCREASE";
    case EMC_SPINDLE_OFF_TYPE:
	return "EMC_SPINDLE_OFF";
    case EMC_SPINDLE_ON_TYPE:
	return "EMC_SPINDLE_ON";
    case EMC_SPINDLE_SPEED_TYPE:
	return "EMC_SPINDLE_SPEED";
    case EMC_SPINDLE_ORIENT_TYPE:
	return "EMC_SPINDLE_ORIENT";
    case EMC_SPINDLE_WAIT_ORIENT_COMPLETE_TYPE:
	return "EMC_SPINDLE_WAIT_ORIENT_COMPLETE";
    case EMC_SPINDLE_STAT_TYPE:
	return "EMC_SPINDLE_STAT";
    case EMC_STAT_TYPE:
	return "EMC_STAT";
    case EMC_TASK_ABORT_TYPE:
	return "EMC_TASK_ABORT";
    case EMC_TASK_HALT_TYPE:
	return "EMC_TASK_HALT";
    case EMC_TASK_INIT_TYPE:
	return "EMC_TASK_INIT";
    case EMC_TASK_PLAN_CLOSE_TYPE:
	return "EMC_TASK_PLAN_CLOSE";
    case EMC_TASK_PLAN_END_TYPE:
	return "EMC_TASK_PLAN_END";
    case EMC_TASK_PLAN_EXECUTE_TYPE:
	return "EMC_TASK_PLAN_EXECUTE";
    case EMC_TASK_PLAN_INIT_TYPE:
	return "EMC_TASK_PLAN_INIT";
    case EMC_TASK_PLAN_OPEN_TYPE:
	return "EMC_TASK_PLAN_OPEN";
    case EMC_TASK_PLAN_PAUSE_TYPE:
	return "EMC_TASK_PLAN_PAUSE";
    case EMC_TASK_PLAN_READ_TYPE:
	return "EMC_TASK_PLAN_READ";
    case EMC_TASK_PLAN_RESUME_TYPE:
	return "EMC_TASK_PLAN_RESUME";
    case EMC_TASK_PLAN_RUN_TYPE:
	return "EMC_TASK_PLAN_RUN";
    case EMC_TASK_PLAN_STEP_TYPE:
	return "EMC_TASK_PLAN_STEP";
    case EMC_TASK_PLAN_SYNCH_TYPE:
	return "EMC_TASK_PLAN_SYNCH";
    case EMC_TASK_PLAN_SET_OPTIONAL_STOP_TYPE:
	return "EMC_TASK_PLAN_SET_OPTIONAL_STOP";
    case EMC_TASK_PLAN_SET_BLOCK_DELETE_TYPE:
	return "EMC_TASK_PLAN_SET_BLOCK_DELETE";
    case EMC_TASK_PLAN_OPTIONAL_STOP_TYPE:
	return "EMC_TASK_PLAN_OPTIONAL_STOP";
    case EMC_TASK_SET_MODE_TYPE:
	return "EMC_TASK_SET_MODE";
    case EMC_TASK_SET_STATE_TYPE:
	return "EMC_TASK_SET_STATE";
    case EMC_TASK_STAT_TYPE:
	return "EMC_TASK_STAT";
    case EMC_TOOL_ABORT_TYPE:
	return "EMC_TOOL_ABORT";
    case EMC_TOOL_HALT_TYPE:
	return "EMC_TOOL_HALT";
    case EMC_TOOL_INIT_TYPE:
	return "EMC_TOOL_INIT";
    case EMC_TOOL_LOAD_TYPE:
	return "EMC_TOOL_LOAD";
    case EMC_TOOL_LOAD_TOOL_TABLE_TYPE:
	return "EMC_TOOL_LOAD_TOOL_TABLE";
    case EMC_TOOL_PREPARE_TYPE:
	return "EMC_TOOL_PREPARE";
    case EMC_TOOL_SET_OFFSET_TYPE:
	return "EMC_TOOL_SET_OFFSET";
    case EMC_TOOL_SET_NUMBER_TYPE:
	return "EMC_TOOL_SET_NUMBER";
    case EMC_TOOL_START_CHANGE_TYPE:
        return "EMC_TOOL_START_CHANGE";
    case EMC_TOOL_STAT_TYPE:
	return "EMC_TOOL_STAT";
    case EMC_TOOL_UNLOAD_TYPE:
	return "EMC_TOOL_UNLOAD";
    case EMC_TRAJ_ABORT_TYPE:
	return "EMC_TRAJ_ABORT";
    case EMC_TRAJ_CIRCULAR_MOVE_TYPE:
	return "EMC_TRAJ_CIRCULAR_MOVE";
    case EMC_TRAJ_CLEAR_PROBE_TRIPPED_FLAG_TYPE:
	return "EMC_TRAJ_CLEAR_PROBE_TRIPPED_FLAG";
    case EMC_TRAJ_DELAY_TYPE:
	return "EMC_TRAJ_DELAY";
    case EMC_TRAJ_DISABLE_TYPE:
	return "EMC_TRAJ_DISABLE";
    case EMC_TRAJ_ENABLE_TYPE:
	return "EMC_TRAJ_ENABLE";
    case EMC_TRAJ_HALT_TYPE:
	return "EMC_TRAJ_HALT";
    case EMC_TRAJ_INIT_TYPE:
	return "EMC_TRAJ_INIT";
    case EMC_TRAJ_LINEAR_MOVE_TYPE:
	return "EMC_TRAJ_LINEAR_MOVE";
    case EMC_TRAJ_PAUSE_TYPE:
	return "EMC_TRAJ_PAUSE";
    case EMC_TRAJ_PROBE_TYPE:
	return "EMC_TRAJ_PROBE";
    case EMC_AUX_INPUT_WAIT_TYPE:
	return "EMC_AUX_INPUT_WAIT";
    case EMC_TRAJ_RIGID_TAP_TYPE:
	return "EMC_TRAJ_RIGID_TAP";
    case EMC_TRAJ_RESUME_TYPE:
	return "EMC_TRAJ_RESUME";
    case EMC_TRAJ_SET_ACCELERATION_TYPE:
	return "EMC_TRAJ_SET_ACCELERATION";
    case EMC_TRAJ_SET_AXES_TYPE:
	return "EMC_TRAJ_SET_AXES";
    case EMC_TRAJ_SET_CYCLE_TIME_TYPE:
	return "EMC_TRAJ_SET_CYCLE_TIME";
    case EMC_TRAJ_SET_HOME_TYPE:
	return "EMC_TRAJ_SET_HOME";
    case EMC_TRAJ_SET_MAX_ACCELERATION_TYPE:
	return "EMC_TRAJ_SET_MAX_ACCELERATION";
    case EMC_TRAJ_SET_MAX_VELOCITY_TYPE:
	return "EMC_TRAJ_SET_MAX_VELOCITY";
    case EMC_TRAJ_SET_MODE_TYPE:
	return "EMC_TRAJ_SET_MODE";
    case EMC_TRAJ_SET_MOTION_ID_TYPE:
	return "EMC_TRAJ_SET_MOTION_ID";
    case EMC_TRAJ_SET_OFFSET_TYPE:
	return "EMC_TRAJ_SET_OFFSET";
    case EMC_TRAJ_SET_G5X_TYPE:
	return "EMC_TRAJ_SET_G5X";
    case EMC_TRAJ_SET_G92_TYPE:
	return "EMC_TRAJ_SET_G92";
    case EMC_TRAJ_SET_ROTATION_TYPE:
	return "EMC_TRAJ_SET_ROTATION";
    case EMC_TRAJ_SET_SCALE_TYPE:
	return "EMC_TRAJ_SET_SCALE";
    case EMC_TRAJ_SET_RAPID_SCALE_TYPE:
	return "EMC_TRAJ_SET_RAPID_SCALE";
    case EMC_TRAJ_SET_SPINDLE_SCALE_TYPE:
	return "EMC_TRAJ_SET_SPINDLE_SCALE";
    case EMC_TRAJ_SET_FO_ENABLE_TYPE:
	return "EMC_TRAJ_SET_FO_ENABLE";
    case EMC_TRAJ_SET_SO_ENABLE_TYPE:
	return "EMC_TRAJ_SET_SO_ENABLE";
    case EMC_TRAJ_SET_FH_ENABLE_TYPE:
	return "EMC_TRAJ_SET_FH_ENABLE";
    case EMC_TRAJ_SET_TELEOP_ENABLE_TYPE:
	return "EMC_TRAJ_SET_TELEOP_ENABLE";
    case EMC_TRAJ_SET_TERM_COND_TYPE:
	return "EMC_TRAJ_SET_TERM_COND";
    case EMC_TRAJ_SET_SPINDLESYNC_TYPE:
	return "EMC_TRAJ_SET_SPINDLESYNC";
    case EMC_TRAJ_SET_UNITS_TYPE:
	return "EMC_TRAJ_SET_UNITS";
    case EMC_TRAJ_SET_VELOCITY_TYPE:
	return "EMC_TRAJ_SET_VELOCITY";
    case EMC_TRAJ_STAT_TYPE:
	return "EMC_TRAJ_STAT";
    case EMC_TRAJ_STEP_TYPE:
	return "EMC_TRAJ_STEP";
    default:
	return "UNKNOWN";
	break;
    }
    return (NULL);
}

/*
*	NML/CMS Update function for EMC_TASK_PLAN_CLOSE
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TASK_PLAN_CLOSE::update(CMS * cms)
{

    EMC_TASK_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_IO_STAT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_IO_STAT::update(CMS * cms)
{

    EMC_IO_STAT_MSG::update(cms);
    cms->update(cycleTime);
    cms->update(debug);
    tool.update(cms);
    coolant.update(cms);
    aux.update(cms);
    lube.update(cms);

}

/*
*	NML/CMS Update function for EMC_SPINDLE_STAT_MSG
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_SPINDLE_STAT_MSG::update(CMS * cms)
{

}

/*
*	NML/CMS Update function for EMC_TRAJ_SET_HOME
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TRAJ_SET_HOME::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);
    EmcPose_update(cms, &home);

}

/*
*	NML/CMS Update function for EMC_CMD_MSG
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_CMD_MSG::update(CMS * cms)
{

}

/*
*	NML/CMS Update function for EMC_AUX_ESTOP_RESET
*	Automatically generated by AJ.
*	on Sun Oct 13 23:46:26 GMT+2 2005
*/
void EMC_AUX_ESTOP_RESET::update(CMS * cms)
{

    EMC_AUX_CMD_MSG::update(cms);

}


/*
*	NML/CMS Update function for EMC_AUX_ESTOP_OFF
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_AUX_ESTOP_OFF::update(CMS * cms)
{

    EMC_AUX_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_OPERATOR_DISPLAY
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_OPERATOR_DISPLAY::update(CMS * cms)
{
    cms->update(id);
    cms->update(display, 256);

}

/*
*	NML/CMS Update function for EMC_SYSTEM_CMD
*	Manually stuck in here by FMP
*	on 27-Apr-2005 at the EMC Codefest
*/
void EMC_SYSTEM_CMD::update(CMS * cms)
{
    cms->update(string, 256);
}

/*
*	NML/CMS Update function for EMC_TRAJ_CLEAR_PROBE_TRIPPED_FLAG
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TRAJ_CLEAR_PROBE_TRIPPED_FLAG::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_TOOL_STAT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TOOL_STAT::update(CMS * cms)
{

    EMC_TOOL_STAT_MSG::update(cms);
    cms->update(pocketPrepped); // idx
    cms->update(toolInSpindle);
    cms->update(toolFromPocket);
#ifdef TOOL_NML //{
    for (int i_toolTable = 0; i_toolTable < CANON_POCKETS_MAX; i_toolTable++)
	CANON_TOOL_TABLE_update(cms, &(toolTable[i_toolTable]));
#else //}{
    // noop
#endif //}
}

/*
*	NML/CMS Update function for EMC_MOTION_INIT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_MOTION_INIT::update(CMS * cms)
{

    EMC_MOTION_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_JOINT_SET_UNITS
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_JOINT_SET_UNITS::update(CMS * cms)
{

    EMC_JOINT_CMD_MSG::update(cms);
    cms->update(units);

}

/*
*	NML/CMS Update function for EMC_SPINDLE_CONSTANT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_SPINDLE_CONSTANT::update(CMS * cms)
{

    EMC_SPINDLE_CMD_MSG::update(cms);
    cms->update(speed);

}

/*
*	NML/CMS Update function for EMC_SPINDLE_CMD_MSG
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_SPINDLE_CMD_MSG::update(CMS * cms)
{

}

/*
*	NML/CMS Update function for EMC_TRAJ_DELAY
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TRAJ_DELAY::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);
    cms->update(delay);

}

/*
*	NML/CMS Update function for EMC_JOG_ABS
*/
void EMC_JOG_ABS::update(CMS * cms)
{

    EMC_JOG_CMD_MSG::update(cms);
    cms->update(pos);
    cms->update(vel);

}

/*
*	NML/CMS Update function for EMC_JOG_STOP
*/
void EMC_JOG_STOP::update(CMS * cms)
{

    EMC_JOG_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_LUBE_CMD_MSG
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_LUBE_CMD_MSG::update(CMS * cms)
{

}

/*
*	NML/CMS Update function for EMC_TOOL_PREPARE
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TOOL_PREPARE::update(CMS * cms)
{

    EMC_TOOL_CMD_MSG::update(cms);
    cms->update(tool);

}

/*
*	NML/CMS Update function for EMC_SPINDLE_OFF
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_SPINDLE_OFF::update(CMS * cms)
{

    EMC_SPINDLE_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_TASK_PLAN_SYNCH
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TASK_PLAN_SYNCH::update(CMS * cms)
{

    EMC_TASK_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_COOLANT_CMD_MSG
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_COOLANT_CMD_MSG::update(CMS * cms)
{

}

/*
*	NML/CMS Update function for EMC_TRAJ_HALT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TRAJ_HALT::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_TOOL_LOAD
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TOOL_LOAD::update(CMS * cms)
{

    EMC_TOOL_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_JOINT_OVERRIDE_LIMITS
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_JOINT_OVERRIDE_LIMITS::update(CMS * cms)
{

    EMC_JOINT_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for PmCartesian
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void PmCartesian_update(CMS * cms, PmCartesian * x)
{
    cms->update(x->x);
    cms->update(x->y);
    cms->update(x->z);

}

/*
*	NML/CMS Update function for EMC_JOINT_SET_FERROR
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_JOINT_SET_FERROR::update(CMS * cms)
{

    EMC_JOINT_CMD_MSG::update(cms);
    cms->update(ferror);

}

/*
*	NML/CMS Update function for EMC_JOINT_SET_MIN_POSITION_LIMIT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_JOINT_SET_MIN_POSITION_LIMIT::update(CMS * cms)
{

    EMC_JOINT_CMD_MSG::update(cms);
    cms->update(limit);

}

/*
*	NML/CMS Update function for EMC_JOINT_DEACTIVATE
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_JOINT_DEACTIVATE::update(CMS * cms)
{

    EMC_JOINT_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_TRAJ_SET_VELOCITY
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TRAJ_SET_VELOCITY::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);
    cms->update(velocity);
    cms->update(ini_maxvel);

}

/*
*	NML/CMS Update function for EMC_TASK_ABORT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TASK_ABORT::update(CMS * cms)
{

    EMC_TASK_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_TRAJ_SET_MOTION_ID
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TRAJ_SET_MOTION_ID::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);
    cms->update(id);

}

/*
*	NML/CMS Update function for EMC_MOTION_HALT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_MOTION_HALT::update(CMS * cms)
{

    EMC_MOTION_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_TASK_PLAN_INIT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TASK_PLAN_INIT::update(CMS * cms)
{

    EMC_TASK_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_TRAJ_SET_ACCELERATION
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TRAJ_SET_ACCELERATION::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);
    cms->update(acceleration);

}

/*
*	NML/CMS Update function for EMC_AUX_STAT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_AUX_STAT::update(CMS * cms)
{

    EMC_AUX_STAT_MSG::update(cms);
    cms->update(estop);

}

/*
*	NML/CMS Update function for EMC_TASK_STAT_MSG
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TASK_STAT_MSG::update(CMS * cms)
{
    cms->update(heartbeat);

}

/*
*	NML/CMS Update function for EMC_TRAJ_SET_CYCLE_TIME
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TRAJ_SET_CYCLE_TIME::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);
    cms->update(cycleTime);

}

/*
*	NML/CMS Update function for EMC_IO_CMD_MSG
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_IO_CMD_MSG::update(CMS * cms)
{

}

/*
*	NML/CMS Update function for EMC_JOINT_CMD_MSG
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_JOINT_CMD_MSG::update(CMS * cms)
{
    cms->update(joint);

}


void EMC_JOG_CMD_MSG::update(CMS * cms)
{
    cms->update(joint_or_axis);

}

/*
*	NML/CMS Update function for EMC_IO_INIT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_IO_INIT::update(CMS * cms)
{

    EMC_IO_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_STAT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_STAT::update(CMS * cms)
{

    EMC_STAT_MSG::update(cms);
    task.update(cms);
    motion.update(cms);
    io.update(cms);
    cms->update(debug);

}

/*
*	NML/CMS Update function for EMC_JOG_CONT
*/
void EMC_JOG_CONT::update(CMS * cms)
{

    EMC_JOG_CMD_MSG::update(cms);
    cms->update(vel);

}

/*
*	NML/CMS Update function for CANON_VECTOR
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void CANON_VECTOR_update(CMS * cms, CANON_VECTOR * x)
{
    cms->update(x->x);
    cms->update(x->y);
    cms->update(x->z);

}

/*
*	NML/CMS Update function for EMC_TOOL_INIT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TOOL_INIT::update(CMS * cms)
{

    EMC_TOOL_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_TRAJ_ENABLE
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TRAJ_ENABLE::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_MOTION_SET_AOUT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_MOTION_SET_AOUT::update(CMS * cms)
{

    EMC_MOTION_CMD_MSG::update(cms);
    cms->update(index);
    cms->update(start);
    cms->update(end);
    cms->update(now);

}

/*
*	NML/CMS Update function for EMC_COOLANT_STAT_MSG
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_COOLANT_STAT_MSG::update(CMS * cms)
{

}

/*
*	NML/CMS Update function for EMC_MOTION_ABORT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_MOTION_ABORT::update(CMS * cms)
{

    EMC_MOTION_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_TRAJ_RESUME
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TRAJ_RESUME::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_JOINT_SET_JOINT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_JOINT_SET_JOINT::update(CMS * cms)
{

    EMC_JOINT_CMD_MSG::update(cms);
    cms->update(jointType);

}

/*
*	NML/CMS Update function for EMC_TRAJ_ABORT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TRAJ_ABORT::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_TOOL_SET_OFFSET
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TOOL_SET_OFFSET::update(CMS * cms)
{

    EMC_TOOL_CMD_MSG::update(cms);
    cms->update(pocket);
    cms->update(toolno);
    EmcPose_update(cms, &offset);
    cms->update(diameter);
    cms->update(frontangle);
    cms->update(backangle);
    cms->update(orientation);
}


/*
*	NML/CMS Update function for EMC_TOOL_SET_NUMBER
*	Manually generated by Alex Joni
*	on Thu Jan 29 18:55:19 UTC 2009
*/
void EMC_TOOL_SET_NUMBER::update(CMS * cms)
{

    EMC_TOOL_CMD_MSG::update(cms);
    cms->update(tool);
}

/*
*	NML/CMS Update function for EMC_TOOL_START_CHANGE_TYPE
*	Manually generated by Michael Haberler
*	on Wed Jan  5 16:29:43 CET 2011
*/
void EMC_TOOL_START_CHANGE::update(CMS * cms)
{

    EMC_TOOL_CMD_MSG::update(cms);
}

/*
*	NML/CMS Update function for EMC_SPINDLE_STAT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_SPINDLE_STAT::update(CMS * cms)
{

    EMC_SPINDLE_STAT_MSG::update(cms);
    cms->update(speed);
    cms->update(direction);
    cms->update(brake);
    cms->update(increasing);
    cms->update(enabled);
    cms->update(orient_state);
    cms->update(orient_fault);
}

/*
*	NML/CMS Update function for EMC_JOINT_SET_MAX_POSITION_LIMIT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_JOINT_SET_MAX_POSITION_LIMIT::update(CMS * cms)
{

    EMC_JOINT_CMD_MSG::update(cms);
    cms->update(limit);

}

/*
*	NML/CMS Update function for EMC_COOLANT_MIST_ON
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_COOLANT_MIST_ON::update(CMS * cms)
{

    EMC_COOLANT_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_TRAJ_LINEAR_MOVE
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*
*	Manually revised 2004/05/24
*/
void EMC_TRAJ_LINEAR_MOVE::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);
    EmcPose_update(cms, &end);
    cms->update(type);
    cms->update(vel);
    cms->update(ini_maxvel);
    cms->update(acc);
    cms->update(feed_mode);
    cms->update(indexer_jnum);
}

/*
*	NML/CMS Update function for EMC_TRAJ_CIRCULAR_MOVE
*	Automatically generated by NML CodeGen Java Applet.
*	on Wed Dec 24 18:04:58 UTC 2003
*
*	Manually revised 2004/05/24
*/
void EMC_TRAJ_CIRCULAR_MOVE::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);
    EmcPose_update(cms, &end);
    cms->update(center);
    cms->update(normal);
    cms->update(turn);
    cms->update(type);
    cms->update(vel);
    cms->update(ini_maxvel);
    cms->update(acc);
    cms->update(feed_mode);

}

/*
*	NML/CMS Update function for EMC_TRAJ_SET_TERM_COND
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TRAJ_SET_TERM_COND::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);
    cms->update(cond);
    cms->update(tolerance);

}

void EMC_TRAJ_SET_SPINDLESYNC::update(CMS * cms)
{
    EMC_TRAJ_CMD_MSG::update(cms);
    cms->update(feed_per_revolution);
    cms->update(velocity_mode);
}

/*
*	NML/CMS Update function for EMC_TASK_PLAN_RUN
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TASK_PLAN_RUN::update(CMS * cms)
{

    EMC_TASK_CMD_MSG::update(cms);
    cms->update(line);

}

/*
*	NML/CMS Update function for EMC_TOOL_CMD_MSG
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TOOL_CMD_MSG::update(CMS * cms)
{

}

/*
*	NML/CMS Update function for EMC_TRAJ_STEP
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TRAJ_STEP::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_TASK_PLAN_RESUME
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TASK_PLAN_RESUME::update(CMS * cms)
{

    EMC_TASK_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_TASK_CMD_MSG
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TASK_CMD_MSG::update(CMS * cms)
{

}

/*
*	NML/CMS Update function for EMC_TRAJ_STAT_MSG
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TRAJ_STAT_MSG::update(CMS * cms)
{

}

/*
*	NML/CMS Update function for EMC_IO_HALT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_IO_HALT::update(CMS * cms)
{

    EMC_IO_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_OPERATOR_TEXT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_OPERATOR_TEXT::update(CMS * cms)
{
    cms->update(id);
    cms->update(text, 256);

}

/*
*	NML/CMS Update function for EMC_COOLANT_MIST_OFF
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_COOLANT_MIST_OFF::update(CMS * cms)
{

    EMC_COOLANT_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_TASK_PLAN_READ
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TASK_PLAN_READ::update(CMS * cms)
{

    EMC_TASK_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_TOOL_HALT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TOOL_HALT::update(CMS * cms)
{

    EMC_TOOL_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_SPINDLE_DECREASE
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_SPINDLE_DECREASE::update(CMS * cms)
{

    EMC_SPINDLE_CMD_MSG::update(cms);
    cms->update(speed);

}

/*
*	NML/CMS Update function for CANON_TOOL_TABLE
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void CANON_TOOL_TABLE_update(CMS * cms, CANON_TOOL_TABLE * x)
{
    cms->update(x->toolno);
    EmcPose_update(cms, &x->offset);
    cms->update(x->diameter);
    cms->update(x->frontangle);
    cms->update(x->backangle);

}

/*
*	NML/CMS Update function for EMC_IO_STAT_MSG
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_IO_STAT_MSG::update(CMS * cms)
{
    cms->update(heartbeat);

}

/*
*	NML/CMS Update function for EMC_ABORT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_ABORT::update(CMS * cms)
{

    EMC_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_EXEC_PLUGIN_CALL
*	Manually added by Michael Haberler
*	on Wed Jun 29 20:00:36 CEST 2011
*/
void EMC_EXEC_PLUGIN_CALL::update(CMS * cms)
{

    EMC_CMD_MSG::update(cms);
    cms->update(len);
    cms->update(call,sizeof(call));
}

/*
*	NML/CMS Update function for EMC_IO_PLUGIN_CALL
*	Manually added by Michael Haberler
*	on Sun Aug  7 13:59:51 CEST 201
*/
void EMC_IO_PLUGIN_CALL::update(CMS * cms)
{

    EMC_CMD_MSG::update(cms);
    cms->update(len);
    cms->update(call,sizeof(call));
}


/*
*	NML/CMS Update function for EMC_TOOL_STAT_MSG
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TOOL_STAT_MSG::update(CMS * cms)
{

}

/*
*	NML/CMS Update function for EMC_JOINT_STAT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_JOINT_STAT::update(CMS * cms)
{

    EMC_JOINT_STAT_MSG::update(cms);
    cms->update(jointType);
    cms->update(units);
    cms->update(backlash);
    cms->update(minPositionLimit);
    cms->update(maxPositionLimit);
    cms->update(maxFerror);
    cms->update(minFerror);
    /*! \todo FIXME - homingVel has been superceded */
    cms->update(ferrorCurrent);
    cms->update(ferrorHighMark);
    cms->update(output);
    cms->update(input);
    cms->update(velocity);
    cms->update(inpos);
    cms->update(homing);
    cms->update(homed);
    cms->update(fault);
    cms->update(enabled);
    cms->update(minSoftLimit);
    cms->update(maxSoftLimit);
    cms->update(minHardLimit);
    cms->update(maxHardLimit);
    cms->update(overrideLimits);
}

/*
*	NML/CMS Update function for EMC_AXIS_STAT
*	Automatically generated by micges
*	on 13.08.2009 23:43:26
*/
void EMC_AXIS_STAT::update(CMS * cms)
{

    EMC_AXIS_STAT_MSG::update(cms);
    cms->update(minPositionLimit);
    cms->update(maxPositionLimit);

}

/*
*	NML/CMS Update function for EMC_JOINT_STAT_MSG
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_AXIS_STAT_MSG::update(CMS * cms)
{
    cms->update(axis);
}

/*
*	NML/CMS Update function for EMC_INIT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_INIT::update(CMS * cms)
{

    EMC_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_TRAJ_SET_SCALE
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TRAJ_SET_SCALE::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);
    cms->update(scale);

}

void EMC_TRAJ_SET_RAPID_SCALE::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);
    cms->update(scale);

}

/*
*	NML/CMS Update function for EMC_TRAJ_SET_SPINDLE_SCALE
*	Automatically generated by Alex Joni :)
*	on Mon Aug 07 22:39:16 GMT+3 2006
*/
void EMC_TRAJ_SET_SPINDLE_SCALE::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);
    cms->update(scale);

}

/*
*	NML/CMS Update function for EMC_TRAJ_SET_FO_ENABLE
*	Automatically generated by Alex Joni :)
*	on Tue Oct 17 00:14:16 GMT+3 2006
*/
void EMC_TRAJ_SET_FO_ENABLE::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);
    cms->update(mode);

}

/*
*	NML/CMS Update function for EMC_TRAJ_SET_FEED_SPINDLE
*	Automatically generated by Alex Joni :)
*	on Tue Oct 17 00:14:16 GMT+3 2006
*/
void EMC_TRAJ_SET_SO_ENABLE::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);
    cms->update(mode);

}

/*
*	NML/CMS Update function for EMC_TRAJ_SET_FH_ENABLE
*	Automatically generated by Alex Joni :)
*	on Sat Nov 04 11:42:16 GMT+2 2006
*/
void EMC_TRAJ_SET_FH_ENABLE::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);
    cms->update(mode);

}


/*
*	NML/CMS Update function for EMC_IO_ABORT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_IO_ABORT::update(CMS * cms)
{

    EMC_IO_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_TASK_STAT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TASK_STAT::update(CMS * cms)
{

    EMC_TASK_STAT_MSG::update(cms);
    cms->update((int *) &mode, 1);
    cms->update((int *) &state, 1);
    cms->update((int *) &execState, 1);
    cms->update((int *) &interpState, 1);
    cms->update(callLevel);
    cms->update(motionLine);
    cms->update(currentLine);
    cms->update(readLine);
    cms->update(file, 256);
    cms->update(command, 256);
    cms->update(ini_filename, 256);
    EmcPose_update(cms, &g5x_offset);
    EmcPose_update(cms, &g92_offset);
    EmcPose_update(cms, &toolOffset);
    cms->update(g5x_index);
    cms->update(activeGCodes, ACTIVE_G_CODES);
    cms->update(activeMCodes, ACTIVE_M_CODES);
    cms->update(activeSettings, ACTIVE_SETTINGS);
    cms->update((int *) &programUnits, 1);
    cms->update(interpreter_errcode);
    cms->update(input_timeout);
    cms->update(rotation_xy);

}

/*
*	NML/CMS Update function for EMC_TOOL_ABORT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TOOL_ABORT::update(CMS * cms)
{

    EMC_TOOL_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_TRAJ_SET_AXES
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TRAJ_SET_AXES::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);
    cms->update(axes);

}

/*
*	NML/CMS Update function for EMC_TOOL_LOAD_TOOL_TABLE
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TOOL_LOAD_TOOL_TABLE::update(CMS * cms)
{

    EMC_TOOL_CMD_MSG::update(cms);
    cms->update(file, 256);

}

/*
*	NML/CMS Update function for EMC_TASK_SET_STATE
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TASK_SET_STATE::update(CMS * cms)
{

    EMC_TASK_CMD_MSG::update(cms);
    cms->update((int *) &state, 1);

}

/*
*	NML/CMS Update function for EMC_SPINDLE_BRAKE_RELEASE
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_SPINDLE_BRAKE_RELEASE::update(CMS * cms)
{

    EMC_SPINDLE_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_JOINT_STAT_MSG
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_JOINT_STAT_MSG::update(CMS * cms)
{
    cms->update(joint);

}

/*
*	NML/CMS Update function for EMC_JOINT_LOAD_COMP
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_JOINT_LOAD_COMP::update(CMS * cms)
{

    EMC_JOINT_CMD_MSG::update(cms);
    cms->update(file, 256);
    cms->update(type);

}

/*
*	NML/CMS Update function for EMC_TRAJ_SET_UNITS
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TRAJ_SET_UNITS::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);
    cms->update(linearUnits);
    cms->update(angularUnits);

}

/*
*	NML/CMS Update function for EMC_STAT_MSG
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_STAT_MSG::update(CMS * cms)
{

}

/*
*	NML/CMS Update function for EMC_TASK_SET_MODE
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TASK_SET_MODE::update(CMS * cms)
{

    EMC_TASK_CMD_MSG::update(cms);
    cms->update((int *) &mode, 1);

}

/*
*	NML/CMS Update function for EMC_JOG_INCR
*/
void EMC_JOG_INCR::update(CMS * cms)
{

    EMC_JOG_CMD_MSG::update(cms);
    cms->update(incr);
    cms->update(vel);

}

/*
*	NML/CMS Update function for EMC_JOINT_ACTIVATE
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_JOINT_ACTIVATE::update(CMS * cms)
{

    EMC_JOINT_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_SPINDLE_ON
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_SPINDLE_ON::update(CMS * cms)
{

    EMC_SPINDLE_CMD_MSG::update(cms);
    cms->update(speed);
    cms->update(factor);
    cms->update(xoffset);
    cms->update(wait_for_spindle_at_speed);
}

/*
*	NML/CMS Update function for EMC_SPINDLE_SPEED
*	Automatically generated by Alex Joni.
*	on Fri Sep 12 01:39:16 UTC+3 2008
*/
void EMC_SPINDLE_SPEED::update(CMS * cms)
{

    EMC_SPINDLE_CMD_MSG::update(cms);
    cms->update(speed);
    cms->update(factor);
    cms->update(xoffset);

}

/*
*	NML/CMS Update function for EMC_SPINDLE_ORIENT
*	Manually generated by Michael Haberler.
*	on Tue Oct 18 18:36:21 CEST 2011
*/
void EMC_SPINDLE_ORIENT::update(CMS * cms)
{

    EMC_SPINDLE_CMD_MSG::update(cms);
    cms->update(orientation);
    cms->update(mode);
}

/*
*	NML/CMS Update function for EMC_SPINDLE_WAIT_ORIENT_COMPLETE
*	Manually generated by Michael Haberler.
*	on Wed Nov  2 18:29:15 CET 2011
*/
void EMC_SPINDLE_WAIT_ORIENT_COMPLETE::update(CMS * cms)
{

    EMC_SPINDLE_CMD_MSG::update(cms);
    cms->update(timeout);
}

/*
*	NML/CMS Update function for EMC_TASK_PLAN_END
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TASK_PLAN_END::update(CMS * cms)
{

    EMC_TASK_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_TRAJ_SET_OFFSET
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_TRAJ_SET_OFFSET::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);
    EmcPose_update(cms, &offset);

}

/*
*	NML/CMS Update function for EMC_JOINT_ABORT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:16 UTC 2003
*/
void EMC_JOINT_ABORT::update(CMS * cms)
{

    EMC_JOINT_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_TRAJ_CMD_MSG
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_TRAJ_CMD_MSG::update(CMS * cms)
{

}

/*
*	NML/CMS Update function for EMC_OPERATOR_ERROR
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_OPERATOR_ERROR::update(CMS * cms)
{
    cms->update(id);
    cms->update(error, 256);

}

/*
*	NML/CMS Update function for EMC_JOINT_SET_MAX_VELOCITY
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_JOINT_SET_MAX_VELOCITY::update(CMS * cms)
{

    EMC_JOINT_CMD_MSG::update(cms);
    cms->update(vel);

}

/*
*	NML/CMS Update function for EMC_SET_DEBUG
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_SET_DEBUG::update(CMS * cms)
{
    cms->update(debug);

}

/*
*	NML/CMS Update function for EMC_HALT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_HALT::update(CMS * cms)
{

    EMC_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_TASK_PLAN_STEP
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_TASK_PLAN_STEP::update(CMS * cms)
{

    EMC_TASK_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_JOINT_DISABLE
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_JOINT_DISABLE::update(CMS * cms)
{

    EMC_JOINT_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_JOINT_SET_BACKLASH
*	Manually generated  - don't use NML CodeGen Java Applet.
*/
void EMC_JOINT_SET_BACKLASH::update(CMS * cms)
{

    EMC_JOINT_CMD_MSG::update(cms);
    cms->update(backlash);

}

/*
*	NML/CMS Update function for EMC_TRAJ_SET_ORIGIN
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_TRAJ_SET_G5X::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);
    cms->update(g5x_index);
    EmcPose_update(cms, &origin);

}

void EMC_TRAJ_SET_G92::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);
    EmcPose_update(cms, &origin);

}

void EMC_TRAJ_SET_ROTATION::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);
    cms->update(rotation);

}

/*
*	NML/CMS Update function for EMC_SPINDLE_BRAKE_ENGAGE
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_SPINDLE_BRAKE_ENGAGE::update(CMS * cms)
{

    EMC_SPINDLE_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_TRAJ_STAT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_TRAJ_STAT::update(CMS * cms)
{

    EMC_TRAJ_STAT_MSG::update(cms);
    cms->update(linearUnits);
    cms->update(angularUnits);
    cms->update(cycleTime);
    cms->update(axis_mask);
    cms->update((int *) &mode, 1);
    cms->update(enabled);
    cms->update(inpos);
    cms->update(queue);
    cms->update(activeQueue);
    cms->update(queueFull);
    cms->update(id);
    cms->update(paused);
    cms->update(scale);
    EmcPose_update(cms, &position);
    EmcPose_update(cms, &actualPosition);
    cms->update(velocity);
    cms->update(acceleration);
    cms->update(maxVelocity);
    cms->update(maxAcceleration);
    EmcPose_update(cms, &probedPosition);
    cms->update(probe_tripped);
    cms->update(probing);
    cms->update(probeval);
    cms->update(kinematics_type);
    cms->update(motion_type);

}

/*
*	NML/CMS Update function for EMC_JOINT_HOME
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_JOINT_HOME::update(CMS * cms)
{

    EMC_JOINT_CMD_MSG::update(cms);

}

void EMC_JOINT_UNHOME::update(CMS * cms)
{

    EMC_JOINT_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_JOINT_INIT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_JOINT_INIT::update(CMS * cms)
{

    EMC_JOINT_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_JOINT_ENABLE
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_JOINT_ENABLE::update(CMS * cms)
{

    EMC_JOINT_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_TRAJ_SET_MAX_ACCELERATION
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_TRAJ_SET_MAX_ACCELERATION::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);
    cms->update(acceleration);

}

/*
*	NML/CMS Update function for EMC_LUBE_STAT_MSG
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_LUBE_STAT_MSG::update(CMS * cms)
{

}

/*
*	NML/CMS Update function for EMC_LUBE_STAT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_LUBE_STAT::update(CMS * cms)
{

    EMC_LUBE_STAT_MSG::update(cms);
    cms->update(on);
    cms->update(level);

}

/*
*	NML/CMS Update function for EMC_SPINDLE_INCREASE
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_SPINDLE_INCREASE::update(CMS * cms)
{

    EMC_SPINDLE_CMD_MSG::update(cms);
    cms->update(speed);

}

/*
*	NML/CMS Update function for EMC_TASK_INIT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_TASK_INIT::update(CMS * cms)
{

    EMC_TASK_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_AUX_CMD_MSG
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_AUX_CMD_MSG::update(CMS * cms)
{

}

/*
*	NML/CMS Update function for EMC_JOINT_SET_MIN_FERROR
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_JOINT_SET_MIN_FERROR::update(CMS * cms)
{

    EMC_JOINT_CMD_MSG::update(cms);
    cms->update(ferror);

}

/*
*	NML/CMS Update function for EMC_AUX_ESTOP_ON
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_AUX_ESTOP_ON::update(CMS * cms)
{

    EMC_AUX_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_NULL
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_NULL::update(CMS * cms)
{

}

/*
*	NML/CMS Update function for EMC_COOLANT_FLOOD_OFF
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_COOLANT_FLOOD_OFF::update(CMS * cms)
{

    EMC_COOLANT_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EmcPose
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EmcPose_update(CMS * cms, EmcPose * x)
{
    PmCartesian_update(cms, &(x->tran));
    cms->update(x->a);
    cms->update(x->b);
    cms->update(x->c);
    cms->update(x->u);
    cms->update(x->v);
    cms->update(x->w);
}

/*
*	NML/CMS Update function for EMC_MOTION_STAT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_MOTION_STAT::update(CMS * cms)
{

    EMC_MOTION_STAT_MSG::update(cms);
    traj.update(cms);
    for (int i_joint = 0; i_joint < EMCMOT_MAX_JOINTS; i_joint++)
	joint[i_joint].update(cms);
    cms->update(debug);

    // spindle.update(cms); //FIXME - is this needed ? Let's see. andypugh 13/6/16

}

/*
*	NML/CMS Update function for EMC_TRAJ_PAUSE
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_TRAJ_PAUSE::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_AUX_STAT_MSG
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_AUX_STAT_MSG::update(CMS * cms)
{

}

/*
*	NML/CMS Update function for EMC_TRAJ_SET_MAX_VELOCITY
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_TRAJ_SET_MAX_VELOCITY::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);
    cms->update(velocity);

}

/*
*	NML/CMS Update function for EMC_TASK_PLAN_OPEN
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_TASK_PLAN_OPEN::update(CMS * cms)
{

    EMC_TASK_CMD_MSG::update(cms);
    cms->update(file, 256);

}

/*
*	NML/CMS Update function for EMC_JOINT_SET_HOMING_PARAMS
*	Manually generated - do not use NML CodeGen Java Applet.
*/
void EMC_JOINT_SET_HOMING_PARAMS::update(CMS * cms)
{

    EMC_JOINT_CMD_MSG::update(cms);
    cms->update(home);
    cms->update(offset);
    cms->update(home_final_vel);
    cms->update(search_vel);
    cms->update(latch_vel);
    cms->update(use_index);
    cms->update(ignore_limits);
    cms->update(volatile_home);
    cms->update(locking_indexer);

}

/*
*	NML/CMS Update function for EMC_TRAJ_SET_MODE
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_TRAJ_SET_MODE::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);
    cms->update((int *) &mode, 1);

}

/*
*	NML/CMS Update function for EMC_TASK_PLAN_EXECUTE
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_TASK_PLAN_EXECUTE::update(CMS * cms)
{

    EMC_TASK_CMD_MSG::update(cms);
    cms->update(command, 256);

}

/*
*	NML/CMS Update function for EMC_COOLANT_FLOOD_ON
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_COOLANT_FLOOD_ON::update(CMS * cms)
{

    EMC_COOLANT_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_COOLANT_STAT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_COOLANT_STAT::update(CMS * cms)
{

    EMC_COOLANT_STAT_MSG::update(cms);
    cms->update(mist);
    cms->update(flood);

}

/*
*	NML/CMS Update function for EMC_TRAJ_SET_TELEOP_ENABLE
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_TRAJ_SET_TELEOP_ENABLE::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);
    cms->update(enable);

}

/*
*	NML/CMS Update function for CANON_POSITION
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void CANON_POSITION_update(CMS * cms, CANON_POSITION * x)
{
    cms->update(x->x);
    cms->update(x->y);
    cms->update(x->z);
    cms->update(x->a);
    cms->update(x->b);
    cms->update(x->c);

}

/*
*	NML/CMS Update function for EMC_JOINT_HALT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_JOINT_HALT::update(CMS * cms)
{

    EMC_JOINT_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_TASK_PLAN_PAUSE
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_TASK_PLAN_PAUSE::update(CMS * cms)
{

    EMC_TASK_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_TASK_PLAN_SET_OPTIONAL_STOP
*	Automanually generated by Alex Joni.
*	on Sat Sep 09 00:18:17 GMT+3 2006
*/
void EMC_TASK_PLAN_SET_OPTIONAL_STOP::update(CMS * cms)
{

    EMC_TASK_CMD_MSG::update(cms);

    cms->update(state);
    
}

/*
*	NML/CMS Update function for EMC_TASK_PLAN_SET_BLOCK_DELETE
*	Automanually generated by Alex Joni.
*	on Sun Oct 22 17:30:00 GMT+3 2006
*/
void EMC_TASK_PLAN_SET_BLOCK_DELETE::update(CMS * cms)
{

    EMC_TASK_CMD_MSG::update(cms);

    cms->update(state);
    
}

/*
*	NML/CMS Update function for EMC_TASK_PLAN_OPTIONAL_STOP
*	Automanually generated by Alex Joni.
*	on Sat Sep 24 20:25:27 GMT+3 2006
*/
void EMC_TASK_PLAN_OPTIONAL_STOP::update(CMS * cms)
{

    EMC_TASK_CMD_MSG::update(cms);

}


/*
*	NML/CMS Update function for EMC_MOTION_STAT_MSG
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_MOTION_STAT_MSG::update(CMS * cms)
{
    cms->update(heartbeat);

}

/*
*	NML/CMS Update function for EMC_TASK_HALT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_TASK_HALT::update(CMS * cms)
{

    EMC_TASK_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_TRAJ_PROBE
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_TRAJ_PROBE::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);
    EmcPose_update(cms, &pos);
    cms->update(type);
    cms->update(vel);
    cms->update(ini_maxvel);
    cms->update(acc);
    cms->update(probe_type);
}

/*
*	NML/CMS Update function for EMC_AUX_INPUT_WAIT
*	Automatically generated by Alex Joni.
*	on Sun Aug 19 1:36:17 GMT+3 2007
*/
void EMC_AUX_INPUT_WAIT::update(CMS * cms)
{

    EMC_AUX_CMD_MSG::update(cms);
    cms->update(index);
    cms->update(input_type);
    cms->update(wait_type);
    cms->update(timeout);

}


/*
*	NML/CMS Update function for EMC_TRAJ_RIGID_TAP
*	Manually generated by Alex Joni.
*	on Sun Mar 04 18:15:17 EET 2007
*/
void EMC_TRAJ_RIGID_TAP::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);
    EmcPose_update(cms, &pos);
    cms->update(vel);
    cms->update(ini_maxvel);
    cms->update(acc);

}


/*
*	NML/CMS Update function for EMC_LUBE_OFF
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_LUBE_OFF::update(CMS * cms)
{

    EMC_LUBE_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_LUBE_ON
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_LUBE_ON::update(CMS * cms)
{

    EMC_LUBE_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_TRAJ_INIT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_TRAJ_INIT::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_TRAJ_DISABLE
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_TRAJ_DISABLE::update(CMS * cms)
{

    EMC_TRAJ_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_TOOL_UNLOAD
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_TOOL_UNLOAD::update(CMS * cms)
{

    EMC_TOOL_CMD_MSG::update(cms);

}

/*
*	NML/CMS Update function for EMC_MOTION_SET_DOUT
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_MOTION_SET_DOUT::update(CMS * cms)
{

    EMC_MOTION_CMD_MSG::update(cms);
    cms->update(index);
    cms->update(start);
    cms->update(end);
    cms->update(now);

}


/*
*	NML/CMS Update function for EMC_MOTION_ADAPTIVE
*	'Automatically' generated by Alex Joni.
*	on Wed May 17 17:34:17 GMT+2+DST 2006
*/
void EMC_MOTION_ADAPTIVE::update(CMS * cms)
{

    EMC_MOTION_CMD_MSG::update(cms);
    cms->update(status);

}


/*
*	NML/CMS Update function for EMC_MOTION_CMD_MSG
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_MOTION_CMD_MSG::update(CMS * cms)
{

}


/*
*	NML/CMS Update function for EMC_IO_SET_CYCLE_TIME
*	Automatically generated by NML CodeGen Java Applet.
*	on Sat Oct 11 13:45:17 UTC 2003
*/
void EMC_IO_SET_CYCLE_TIME::update(CMS * cms)
{

    EMC_IO_CMD_MSG::update(cms);
    cms->update(cycleTime);

}
