/*
 * Copyright 2014 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 3 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef FAKE_NETWORK_SESSION_H
#define FAKE_NETWORK_SESSION_H

#include <QObject>
#include <lomiri/transfers/system/network_session.h>
#include <gmock/gmock.h>

namespace Lomiri {

namespace Transfers {

using namespace System;

namespace Tests {

class MockNetworkSession : public NetworkSession {
 public:
    explicit MockNetworkSession(QObject* parent = 0) :
        NetworkSession(parent) {}

#if QT_VERSION >= QT_VERSION_CHECK(6, 0, 0)
    MOCK_METHOD0(sessionType, QNetworkInformation::TransportMedium());
#else
    MOCK_METHOD0(sessionType, QNetworkConfiguration::BearerType());
#endif
    MOCK_METHOD0(isOnline, bool());

    bool isError() override {
        return false;
    }

};

}  // Lomiri

}  // Transfers

}  // Tests

#endif
