# Version history

## 2.0.0 (08/23/2018)
### Breaking changes
* library functions now accept iterators prototyped as `f(v, k, ...)` instead of `f(k, v, ...)`.
It improves the benefits of chaning and helps writting a clear functional-style code.
Library functions affected with this breaking change are : 
`each`, `eachi`,`countf`, `map`, `reduceby`, `select`, `reject`, `all`, `groupBy`, `countBy`, 
`selectWhile`, `dropWhile`, `findIndex`, `findLastIndex`, `chunk`.
* `reduceby` is now prototyped as `reduceby(t, f, pred, state)` instead of `reduceby(t, f, state, pred)`.
* `times` is now prototyped as `times(iter, n, ...)` instead of `times(iter, n, ...)`.
* `bindAll` was renamed to `bindall`
* `functions` no longer accept optional `sort` third arguments
* `sliding` was renamed to `overlapping`
* Improved `range` to handle negative progressions and start the count from 1.
* `memoize` no longer takes a `hash` function.

### Other changes
* Made `shift` a default library function, and `pop` its alias.
* Moved `shuffle` from table function to array functions
* Made `iterator` to accept an extra optional arg `n`

### Additions

#### Added support for operators
* Arithmetic operators : `add`, `sub`, `mul`, `div`, `mod`, `exp`, `pow` (alias to `exp`), `unm`, `neg` (alias to `unm`), `floordiv`, `intdiv`
* Relational operators : `eq`, `neq`, `lt`, `gt`, `le`, `ge`
* Logical operators : `land`, `lor`, `lnot`
* Concatenation operator : `concat`
* Length operator : `length`, `len` (alias to `length`)

#### Added functions
* Added `adjust` in table functions
* Added `xprod` in array functions
* Added `prepend` in array functions
* Added `zeros` in array functions
* Added `ones` in array functions
* Added `vector` in array functions
* Added `aperture` in array functions
* Added `sum` in array functions
* Added `product` in array functions
* Added `mean` in array functions
* Added `median` in array functions
* Added `powerset` in array functions
* Added `zipWith` in array functions
* Added `pairwise` in array functions
* Added `applySpec` in utility functions
* Added `nthArg` in utility functions
* Added `cond` in utility functions
* Added `castArray` in utility functions
* Added `unary` in utility functions
* Added `ary` in utility functions
* Added `rearg` in utility functions
* Added `unfold` in utility functions
* Added `converge` in utility functions
* Added `path` in object functions

#### Added function aliases
* Added `update` as alias to `adjust`
* Added `always` as alias to `constant`
* Added `intersperse` as alias to `interpose`
* Added `sliding` as alias to `aperture`
* Added `tabulate` as alias to `array`
* Added `matches` as alias to `isEqual`
* Added `average` as alias to `mean`
* Added `nAry` as alias to `ary`
* Added `transposeWith` as alias to `zipWith`

## 1.6.1 (04/27/17)

* Added `_.array`
* Added `_.clear`
* Added `_.time`
* Added `_.before`

## 1.6.0 (14/04/17)

* Added `_.toObj`
* Added `_.noop`
* Added `_.partialRight`
* Added `_.flip`
* Added `_.overArgs`
* Added `_.over`
* Added `_.overEvery`
* Added `_.overSome`

## 1.5.1 (04/13/17)

* Added `_.curry`
* Added `_.fill`
* Added `.transpose` as an alias to `_.zip`

## 1.5.0 (04/10/17)

#### Additions
* Added `_.bind2`
* Added `_.reduceby`
* Added `_.iterator` (and alias `_.iter`)
* Added `_.sliding`
* Added `_.sample`
* Added `_.sampleProb`
* Added `_.where`
* Added `_.sortBy`
* Added `_.findIndex`
* Added `_.findLastIndex`
* Added `_.bindAll`
* Added `_.partial`
* Added `_.kvpairs`
* Added `_.property`
* Added `_.propertyOf`
* Added `_.constant`

* Added parameter `pad` to `_.partition`

#### Changes, bugfixes
* Improved `_.select`
* Fixed `_.compose`
* Made `_.contains` as an alias to `_.include`
* Improved `_.all`
* Fixed `_.size`
* Improved `_.map` to map key-value pairs to key-value pairs
* Fixed `_.partition` to generate an error for partition size < 1.


## 1.4.0 (07/14/14)

### Breaking
#### Changes
* Aliases are available by default
* `_.find` is no longer an alias to `_.detect`
* Provided a new implementation of `_.unique`, removed argument `_.isSorted`
* `_.isNil` now returns true if arg is nil, an empty string or empty table and false otherwise.
* `_.size` now returns 0 for empty args instead of `nil`
* `_.unique` no longer accepts `iter` argument to transform original array values.
* `_.cycle` argument `n` now defaults to 1.
* `_.groupBy` no longer handles `iter` as a string

#### Renamed
* Renamed alias `_.uId` to `_.uid`
* Renamed `_.add` to `_.addTop`
* Renamed `_.uniq` as alias to `_.unique`
* Renamed `_.symmetric_difference` to `_.symmetricDifference`

#### Removed
* Removed `_.paired`

### Improvements & bugfixes
* `_.reduce` now supports an array of booleans
* `_.pick` now picks false values
* `_.concat` args `i` and `j` defaults explicitely to 1 and array length (for compatibility with LuaJIT)
* `_.pop` now takes an optional extra-arg n, to be the number of values to be popped
* `_.unshift` now takes an optional extra-arg n, to be the number of values to be retrieved
* Moved explicitely `_.toArray` to array functions
* `_.functions` accepts an extra-arg to prevent from looking-up for methods in metatables.

### New functions (and aliases)
* Added `_.find`
* Added `_.pipe`
* Added `_.complement`
* Added `_.juxtapose` and alias `_.juxt`
* Added `_.isunique` and alias `_.isuniq`
* Added `_.rep`
* Added `_.interleave`
* Added `_.interpose`
* Added `_.partition` and alias `_.part`
* Added `_.permutation` and alias `_.perm`
* Added `_.compare` as alias to `_.isEqual`
* Added `_.isIterable`
* Added `_.toBoolean`
* Added `_.pull` and alias `_.remove`
* Added `_.at`

### New aliases
* Added `_.xor` as alias to `_.symmetricDifference`

## 1.3.2.1 (04/22/13)
Renamed global `MOSES_NO_ALIASES` to global `MOSES_ALIASES`. Aliases are not available by default.

## 1.3.2 (04/19/13)
Added `_.import`, export library to context or _G
Added `noConflict` option to `_.import`
Added `MOSES_NO_ALIASES` option when requiring the library
Added `_.symmetric_difference`
Added `_.eachi`
Added  `_.isInteger`
Added `_.cycle`
Added `_.count`
Added `_.countf`
Added `_.chunk` (inspired from Ruby's Enumerable [#chunk](http://ruby-doc.org/core-2.0/Enumerable.html#method-i-chunk))
Added  `_.chop` as alias to `_.removeRange`
Added  `_.skip` as alias to `_.last`
Added  `_.diff` as alias to `_.difference`
Added  `_.symdiff` as alias to `_.symmetric_difference`
Added `_.forEachi` as alias to `_.eachi`
Added `_.loop` as alias to `_.cycle`
Renamed `_.pairs` to `_.paired`
Removed `_.count` as alias to `_.range`
Changed `_.difference behaviour`, now takes up to two arrays as args
Fixed internal inconsistencies with aliases, should not be used internally with regards to `MOSES_NO_ALIASES` option.
Fixed `_.each` implementation, should not return anything

## 1.3.1 (04/12/13)
* Added chaining interface
* Renamed `_.isObject` to `_.isTable`
* Added `_.tap`, `_.chain`, `_()` and `_.value`
* Added `_.findWhere`
* Added `_.contains`
* _.functions no longer takes an output table
* Changed _.isArray behaviour, returns true only for real Lua arrays
* Updated specs
* Updated docs and samples

## 1.3.0 (11/12/12)
* Removed _.iterate (slower than pairs, ipairs)
* Added _.identity
* Removed _.curry (was more like a closure, will provide a proper implementation later)
* Removed _.iter_to_array
* Most of all functions rewritten
* _.import/_.mixin now imports library functions to the global env.
* Added type checking functions as object functions
* Added new functions and aliases : Moses has 85 unique functions, 117 counting aliases.
* Added HTML docs
* Added Specs
* Added samples

## 1.2.1 (08/20/12)
* Added `_.takeWhile` (as alias to `_.selectWhile`)
* Added `_.dropWhile` and `_.rejectWhile` (as alias)
* Updated Moses_Lib_Test.lua
* Updated documentation

## 1.2 (08/19/12)
* Added `_.selectWhile`
* Added `_.mapReduce` and `_.mapr` (as alias)
* Added `_.mapReduceRight` and `_.maprr` (as alias)
* Added `_.bindn`
* Added `_.appendLists`
* Updated Moses_Lib_Test.lua
* Updated documentation

## 1.1 (08/04/12)
* Removed `_.contains` as alias to `_.include`
* Added `_.removeRange` (as Array function)
* Added `_.sameKeys` and `_.contains` (as Collection functions)
* Added `_.bind` (as Utility function)
* Updated Moses_Lib_Test.lua
* Updated documentation

## 1.0 (08/02/12)
* Added `_.append`, `_.invert`, `_.import`, `_.template`, `_.curry`
* Updated Moses_Lib_Test.lua
* Updated documentation

## 0.1 (07/24/12)
* Initial Release
