//go:build linux && cgo && !agent

package cluster

// The code below was generated by lxd-generate - DO NOT EDIT!

import (
	"context"
	"database/sql"
	"fmt"

	"github.com/lxc/lxd/lxd/db/query"
	"github.com/lxc/lxd/shared/api"
)

var _ = api.ServerEnvironment{}

var certificateProjectObjectsByCertificateID = RegisterStmt(`
SELECT certificates_projects.certificate_id, certificates_projects.project_id
  FROM certificates_projects
  WHERE certificates_projects.certificate_id = ? ORDER BY certificates_projects.certificate_id
`)

var certificateProjectCreate = RegisterStmt(`
INSERT INTO certificates_projects (certificate_id, project_id)
  VALUES (?, ?)
`)

var certificateProjectDeleteByCertificateID = RegisterStmt(`
DELETE FROM certificates_projects WHERE certificate_id = ?
`)

// GetCertificateProjects returns all available Projects for the Certificate.
// generator: certificate_project GetMany
func GetCertificateProjects(ctx context.Context, tx *sql.Tx, certificateID int) ([]Project, error) {
	var err error

	// Result slice.
	objects := make([]CertificateProject, 0)

	sqlStmt := Stmt(tx, certificateProjectObjectsByCertificateID)
	args := []any{certificateID}

	// Dest function for scanning a row.
	dest := func(i int) []any {
		objects = append(objects, CertificateProject{})
		return []any{
			&objects[i].CertificateID,
			&objects[i].ProjectID,
		}
	}

	// Select.
	err = query.SelectObjects(sqlStmt, dest, args...)
	if err != nil {
		return nil, fmt.Errorf("Failed to fetch from \"certificates_projects\" table: %w", err)
	}

	result := make([]Project, len(objects))
	for i, object := range objects {
		project, err := GetProjects(ctx, tx, ProjectFilter{ID: &object.ProjectID})
		if err != nil {
			return nil, err
		}

		result[i] = project[0]
	}

	return result, nil
}

// DeleteCertificateProjects deletes the certificate_project matching the given key parameters.
// generator: certificate_project DeleteMany
func DeleteCertificateProjects(ctx context.Context, tx *sql.Tx, certificateID int) error {
	stmt := Stmt(tx, certificateProjectDeleteByCertificateID)
	result, err := stmt.Exec(int(certificateID))
	if err != nil {
		return fmt.Errorf("Delete \"certificates_projects\" entry failed: %w", err)
	}

	_, err = result.RowsAffected()
	if err != nil {
		return fmt.Errorf("Fetch affected rows: %w", err)
	}

	return nil
}

// CreateCertificateProjects adds a new certificate_project to the database.
// generator: certificate_project Create
func CreateCertificateProjects(ctx context.Context, tx *sql.Tx, objects []CertificateProject) error {
	for _, object := range objects {
		args := make([]any, 2)

		// Populate the statement arguments.
		args[0] = object.CertificateID
		args[1] = object.ProjectID

		// Prepared statement to use.
		stmt := Stmt(tx, certificateProjectCreate)

		// Execute the statement.
		_, err := stmt.Exec(args...)
		if err != nil {
			return fmt.Errorf("Failed to create \"certificates_projects\" entry: %w", err)
		}

	}

	return nil
}

// UpdateCertificateProjects updates the certificate_project matching the given key parameters.
// generator: certificate_project Update
func UpdateCertificateProjects(ctx context.Context, tx *sql.Tx, certificateID int, projectNames []string) error {
	// Delete current entry.
	err := DeleteCertificateProjects(ctx, tx, certificateID)
	if err != nil {
		return err
	}

	// Get new entry IDs.
	certificateProjects := make([]CertificateProject, 0, len(projectNames))
	for _, entry := range projectNames {
		refID, err := GetProjectID(ctx, tx, entry)
		if err != nil {
			return err
		}

		certificateProjects = append(certificateProjects, CertificateProject{CertificateID: certificateID, ProjectID: int(refID)})
	}

	err = CreateCertificateProjects(ctx, tx, certificateProjects)
	if err != nil {
		return err
	}

	return nil
}
