//go:build linux && cgo && !agent

package cluster

// The code below was generated by lxd-generate - DO NOT EDIT!

import (
	"context"
	"database/sql"
	"fmt"
	"net/http"

	"github.com/lxc/lxd/lxd/db/query"
	"github.com/lxc/lxd/shared/api"
)

var _ = api.ServerEnvironment{}

var profileObjects = RegisterStmt(`
SELECT profiles.id, profiles.project_id, projects.name AS project, profiles.name, coalesce(profiles.description, '')
  FROM profiles JOIN projects ON profiles.project_id = projects.id
  ORDER BY projects.id, profiles.name
`)

var profileObjectsByID = RegisterStmt(`
SELECT profiles.id, profiles.project_id, projects.name AS project, profiles.name, coalesce(profiles.description, '')
  FROM profiles JOIN projects ON profiles.project_id = projects.id
  WHERE profiles.id = ? ORDER BY projects.id, profiles.name
`)

var profileObjectsByName = RegisterStmt(`
SELECT profiles.id, profiles.project_id, projects.name AS project, profiles.name, coalesce(profiles.description, '')
  FROM profiles JOIN projects ON profiles.project_id = projects.id
  WHERE profiles.name = ? ORDER BY projects.id, profiles.name
`)

var profileObjectsByProject = RegisterStmt(`
SELECT profiles.id, profiles.project_id, projects.name AS project, profiles.name, coalesce(profiles.description, '')
  FROM profiles JOIN projects ON profiles.project_id = projects.id
  WHERE project = ? ORDER BY projects.id, profiles.name
`)

var profileObjectsByProjectAndName = RegisterStmt(`
SELECT profiles.id, profiles.project_id, projects.name AS project, profiles.name, coalesce(profiles.description, '')
  FROM profiles JOIN projects ON profiles.project_id = projects.id
  WHERE project = ? AND profiles.name = ? ORDER BY projects.id, profiles.name
`)

var profileID = RegisterStmt(`
SELECT profiles.id FROM profiles JOIN projects ON profiles.project_id = projects.id
  WHERE projects.name = ? AND profiles.name = ?
`)

var profileCreate = RegisterStmt(`
INSERT INTO profiles (project_id, name, description)
  VALUES ((SELECT projects.id FROM projects WHERE projects.name = ?), ?, ?)
`)

var profileRename = RegisterStmt(`
UPDATE profiles SET name = ? WHERE project_id = (SELECT projects.id FROM projects WHERE projects.name = ?) AND name = ?
`)

var profileUpdate = RegisterStmt(`
UPDATE profiles
  SET project_id = (SELECT id FROM projects WHERE name = ?), name = ?, description = ?
 WHERE id = ?
`)

var profileDeleteByProjectAndName = RegisterStmt(`
DELETE FROM profiles WHERE project_id = (SELECT projects.id FROM projects WHERE projects.name = ?) AND name = ?
`)

// GetProfileID return the ID of the profile with the given key.
// generator: profile ID
func GetProfileID(ctx context.Context, tx *sql.Tx, project string, name string) (int64, error) {
	stmt := Stmt(tx, profileID)
	rows, err := stmt.Query(project, name)
	if err != nil {
		return -1, fmt.Errorf("Failed to get \"profiles\" ID: %w", err)
	}

	defer func() { _ = rows.Close() }()

	// Ensure we read one and only one row.
	if !rows.Next() {
		return -1, api.StatusErrorf(http.StatusNotFound, "Profile not found")
	}

	var id int64
	err = rows.Scan(&id)
	if err != nil {
		return -1, fmt.Errorf("Failed to scan ID: %w", err)
	}

	if rows.Next() {
		return -1, fmt.Errorf("More than one row returned")
	}

	err = rows.Err()
	if err != nil {
		return -1, fmt.Errorf("Result set failure: %w", err)
	}

	return id, nil
}

// ProfileExists checks if a profile with the given key exists.
// generator: profile Exists
func ProfileExists(ctx context.Context, tx *sql.Tx, project string, name string) (bool, error) {
	_, err := GetProfileID(ctx, tx, project, name)
	if err != nil {
		if api.StatusErrorCheck(err, http.StatusNotFound) {
			return false, nil
		}

		return false, err
	}

	return true, nil
}

// GetProfiles returns all available profiles.
// generator: profile GetMany
func GetProfiles(ctx context.Context, tx *sql.Tx, filter ProfileFilter) ([]Profile, error) {
	var err error

	// Result slice.
	objects := make([]Profile, 0)

	// Pick the prepared statement and arguments to use based on active criteria.
	var sqlStmt *sql.Stmt
	var args []any

	if filter.Project != nil && filter.Name != nil && filter.ID == nil {
		sqlStmt = Stmt(tx, profileObjectsByProjectAndName)
		args = []any{
			filter.Project,
			filter.Name,
		}
	} else if filter.Project != nil && filter.ID == nil && filter.Name == nil {
		sqlStmt = Stmt(tx, profileObjectsByProject)
		args = []any{
			filter.Project,
		}
	} else if filter.Name != nil && filter.ID == nil && filter.Project == nil {
		sqlStmt = Stmt(tx, profileObjectsByName)
		args = []any{
			filter.Name,
		}
	} else if filter.ID != nil && filter.Project == nil && filter.Name == nil {
		sqlStmt = Stmt(tx, profileObjectsByID)
		args = []any{
			filter.ID,
		}
	} else if filter.ID == nil && filter.Project == nil && filter.Name == nil {
		sqlStmt = Stmt(tx, profileObjects)
		args = []any{}
	} else {
		return nil, fmt.Errorf("No statement exists for the given Filter")
	}

	// Dest function for scanning a row.
	dest := func(i int) []any {
		objects = append(objects, Profile{})
		return []any{
			&objects[i].ID,
			&objects[i].ProjectID,
			&objects[i].Project,
			&objects[i].Name,
			&objects[i].Description,
		}
	}

	// Select.
	err = query.SelectObjects(sqlStmt, dest, args...)
	if err != nil {
		return nil, fmt.Errorf("Failed to fetch from \"profiles\" table: %w", err)
	}

	return objects, nil
}

// GetProfileDevices returns all available Profile Devices
// generator: profile GetMany
func GetProfileDevices(ctx context.Context, tx *sql.Tx, profileID int) (map[string]Device, error) {
	profileDevices, err := GetDevices(ctx, tx, "profile")
	if err != nil {
		return nil, err
	}

	devices := map[string]Device{}
	for _, ref := range profileDevices[profileID] {
		_, ok := devices[ref.Name]
		if !ok {
			devices[ref.Name] = ref
		} else {
			return nil, fmt.Errorf("Found duplicate Device with name %q", ref.Name)
		}
	}

	return devices, nil
}

// GetProfileConfig returns all available Profile Config
// generator: profile GetMany
func GetProfileConfig(ctx context.Context, tx *sql.Tx, profileID int) (map[string]string, error) {
	profileConfig, err := GetConfig(ctx, tx, "profile")
	if err != nil {
		return nil, err
	}

	config, ok := profileConfig[profileID]
	if !ok {
		config = map[string]string{}
	}

	return config, nil
}

// GetProfile returns the profile with the given key.
// generator: profile GetOne
func GetProfile(ctx context.Context, tx *sql.Tx, project string, name string) (*Profile, error) {
	filter := ProfileFilter{}
	filter.Project = &project
	filter.Name = &name

	objects, err := GetProfiles(ctx, tx, filter)
	if err != nil {
		return nil, fmt.Errorf("Failed to fetch from \"profiles\" table: %w", err)
	}

	switch len(objects) {
	case 0:
		return nil, api.StatusErrorf(http.StatusNotFound, "Profile not found")
	case 1:
		return &objects[0], nil
	default:
		return nil, fmt.Errorf("More than one \"profiles\" entry matches")
	}
}

// CreateProfile adds a new profile to the database.
// generator: profile Create
func CreateProfile(ctx context.Context, tx *sql.Tx, object Profile) (int64, error) {
	// Check if a profile with the same key exists.
	exists, err := ProfileExists(ctx, tx, object.Project, object.Name)
	if err != nil {
		return -1, fmt.Errorf("Failed to check for duplicates: %w", err)
	}

	if exists {
		return -1, api.StatusErrorf(http.StatusConflict, "This \"profiles\" entry already exists")
	}

	args := make([]any, 3)

	// Populate the statement arguments.
	args[0] = object.Project
	args[1] = object.Name
	args[2] = object.Description

	// Prepared statement to use.
	stmt := Stmt(tx, profileCreate)

	// Execute the statement.
	result, err := stmt.Exec(args...)
	if err != nil {
		return -1, fmt.Errorf("Failed to create \"profiles\" entry: %w", err)
	}

	id, err := result.LastInsertId()
	if err != nil {
		return -1, fmt.Errorf("Failed to fetch \"profiles\" entry ID: %w", err)
	}

	return id, nil
}

// CreateProfileDevices adds new profile Devices to the database.
// generator: profile Create
func CreateProfileDevices(ctx context.Context, tx *sql.Tx, profileID int64, devices map[string]Device) error {
	for key, device := range devices {
		device.ReferenceID = int(profileID)
		devices[key] = device
	}

	err := CreateDevices(ctx, tx, "profile", devices)
	if err != nil {
		return fmt.Errorf("Insert Device failed for Profile: %w", err)
	}

	return nil
}

// CreateProfileConfig adds new profile Config to the database.
// generator: profile Create
func CreateProfileConfig(ctx context.Context, tx *sql.Tx, profileID int64, config map[string]string) error {
	referenceID := int(profileID)
	for key, value := range config {
		insert := Config{
			ReferenceID: referenceID,
			Key:         key,
			Value:       value,
		}

		err := CreateConfig(ctx, tx, "profile", insert)
		if err != nil {
			return fmt.Errorf("Insert Config failed for Profile: %w", err)
		}

	}

	return nil
}

// RenameProfile renames the profile matching the given key parameters.
// generator: profile Rename
func RenameProfile(ctx context.Context, tx *sql.Tx, project string, name string, to string) error {
	stmt := Stmt(tx, profileRename)
	result, err := stmt.Exec(to, project, name)
	if err != nil {
		return fmt.Errorf("Rename Profile failed: %w", err)
	}

	n, err := result.RowsAffected()
	if err != nil {
		return fmt.Errorf("Fetch affected rows failed: %w", err)
	}

	if n != 1 {
		return fmt.Errorf("Query affected %d rows instead of 1", n)
	}

	return nil
}

// UpdateProfile updates the profile matching the given key parameters.
// generator: profile Update
func UpdateProfile(ctx context.Context, tx *sql.Tx, project string, name string, object Profile) error {
	id, err := GetProfileID(ctx, tx, project, name)
	if err != nil {
		return err
	}

	stmt := Stmt(tx, profileUpdate)
	result, err := stmt.Exec(object.Project, object.Name, object.Description, id)
	if err != nil {
		return fmt.Errorf("Update \"profiles\" entry failed: %w", err)
	}

	n, err := result.RowsAffected()
	if err != nil {
		return fmt.Errorf("Fetch affected rows: %w", err)
	}

	if n != 1 {
		return fmt.Errorf("Query updated %d rows instead of 1", n)
	}

	return nil
}

// UpdateProfileDevices updates the profile Device matching the given key parameters.
// generator: profile Update
func UpdateProfileDevices(ctx context.Context, tx *sql.Tx, profileID int64, devices map[string]Device) error {
	err := UpdateDevices(ctx, tx, "profile", int(profileID), devices)
	if err != nil {
		return fmt.Errorf("Replace Device for Profile failed: %w", err)
	}

	return nil
}

// UpdateProfileConfig updates the profile Config matching the given key parameters.
// generator: profile Update
func UpdateProfileConfig(ctx context.Context, tx *sql.Tx, profileID int64, config map[string]string) error {
	err := UpdateConfig(ctx, tx, "profile", int(profileID), config)
	if err != nil {
		return fmt.Errorf("Replace Config for Profile failed: %w", err)
	}

	return nil
}

// DeleteProfile deletes the profile matching the given key parameters.
// generator: profile DeleteOne-by-Project-and-Name
func DeleteProfile(ctx context.Context, tx *sql.Tx, project string, name string) error {
	stmt := Stmt(tx, profileDeleteByProjectAndName)
	result, err := stmt.Exec(project, name)
	if err != nil {
		return fmt.Errorf("Delete \"profiles\": %w", err)
	}

	n, err := result.RowsAffected()
	if err != nil {
		return fmt.Errorf("Fetch affected rows: %w", err)
	}

	if n == 0 {
		return api.StatusErrorf(http.StatusNotFound, "Profile not found")
	} else if n > 1 {
		return fmt.Errorf("Query deleted %d Profile rows instead of 1", n)
	}

	return nil
}
