description: "This profile defines a baseline that aligns to the \"Level 2 - Workstation\"\nconfiguration
    from the Center for Internet Security\xAE Red Hat Enterprise\nLinux 8 Benchmark\u2122,
    v3.0.0, released 2023-10-30.\n\nThis profile includes Center for Internet Security\xAE\nRed
    Hat Enterprise Linux 8 CIS Benchmarks\u2122 content."
extends: null
hidden: ''
metadata:
    version: 3.0.0
    SMEs:
    - marcusburghardt
    - vojtapolasek
    - yuumasato
reference: https://www.cisecurity.org/benchmark/red_hat_linux/
selections:
- file_groupowner_backup_etc_gshadow
- package_tftp-server_removed
- banner_etc_issue
- file_owner_etc_gshadow
- audit_rules_time_adjtimex
- sshd_enable_pam
- audit_rules_privileged_commands_usermod
- file_permissions_var_log_audit
- audit_rules_mac_modification_usr_share
- audit_rules_usergroup_modification_gshadow
- accounts_umask_etc_profile
- accounts_password_pam_pwhistory_remember_password_auth
- service_systemd-journald_enabled
- service_bluetooth_disabled
- kernel_module_hfsplus_disabled
- dconf_gnome_login_banner_text
- file_permissions_cron_daily
- selinux_confinement_of_daemons
- kernel_module_sctp_disabled
- no_empty_passwords_etc_shadow
- file_permissions_audit_configuration
- audit_sudo_log_events
- file_owner_efi_grub2_cfg
- audit_rules_mac_modification
- audit_rules_kernel_module_loading_delete
- file_owner_crontab
- auditd_data_retention_max_log_file_action
- sysctl_net_ipv6_conf_all_accept_source_route
- audit_rules_execution_chcon
- journald_forward_to_syslog
- file_groupowner_etc_issue
- sshd_set_maxstartups
- package_nftables_installed
- audit_rules_time_clock_settime
- dconf_db_up_to_date
- accounts_users_netrc_file_permissions
- set_password_hashing_algorithm_passwordauth
- accounts_password_set_max_life_existing
- file_ownership_audit_configuration
- file_cron_deny_not_exist
- file_owner_cron_allow
- kernel_module_usb-storage_disabled
- package_cyrus-imapd_removed
- file_ownership_var_log_audit_stig
- file_at_deny_not_exist
- file_owner_cron_daily
- accounts_umask_etc_bashrc
- configure_ssh_crypto_policy
- file_groupowner_cron_monthly
- dconf_gnome_session_idle_user_locks
- accounts_user_dot_group_ownership
- auditd_data_retention_action_mail_acct
- audit_rules_time_watch_localtime
- accounts_set_post_pw_existing
- package_openldap-clients_removed
- accounts_password_all_shadowed
- file_groupowner_efi_grub2_cfg
- set_password_hashing_algorithm_systemauth
- group_unique_id
- file_groupowner_cron_weekly
- file_owner_sshd_config
- audit_rules_execution_setfacl
- file_owner_cron_d
- rsyslog_nolisten
- file_groupowner_etc_issue_net
- ensure_gpgcheck_globally_activated
- sysctl_net_ipv6_conf_default_accept_redirects
- sudo_add_use_pty
- service_autofs_disabled
- audit_rules_kernel_module_loading_query
- file_owner_cron_hourly
- auditd_data_disk_error_action
- rsyslog_files_ownership
- mount_option_var_tmp_nodev
- dconf_gnome_disable_user_list
- journald_storage
- audit_rules_file_deletion_events_rename
- mount_option_dev_shm_nosuid
- mount_option_var_log_audit_nosuid
- file_owner_cron_weekly
- firewalld_loopback_traffic_trusted
- package_ypserv_removed
- file_owner_etc_motd
- accounts_root_path_dirs_no_write
- sysctl_net_ipv4_conf_all_secure_redirects
- package_telnet-server_removed
- package_net-snmp_removed
- file_permissions_home_directories
- package_dhcp_removed
- file_groupowner_etc_motd
- service_rpcbind_disabled
- journald_compress
- chronyd_run_as_chrony_user
- service_firewalld_enabled
- package_mcstrans_removed
- rsyslog_filecreatemode
- audit_rules_dac_modification_fremovexattr
- service_nfs_disabled
- accounts_password_last_change_is_in_past
- kernel_module_hfs_disabled
- file_permissions_backup_etc_shadow
- directory_permissions_var_log_audit
- ensure_pam_wheel_group_empty
- accounts_password_pam_pwhistory_remember_system_auth
- package_bind_removed
- package_firewalld_installed
- service_crond_enabled
- file_groupowner_backup_etc_group
- file_groupowner_grub2_cfg
- sshd_set_idle_timeout
- audit_rules_session_events
- audit_rules_time_stime
- use_pam_wheel_group_for_su
- kernel_module_cramfs_disabled
- dir_perms_world_writable_sticky_bits
- partition_for_var_log
- file_permissions_sshd_pub_key
- file_permissions_etc_issue
- accounts_password_pam_minlen
- file_permissions_cron_d
- package_ypbind_removed
- auditd_data_retention_space_left_action
- service_rsyslog_enabled
- kernel_module_tipc_disabled
- sshd_do_not_permit_user_env
- file_etc_security_opasswd
- selinux_policytype
- audit_rules_dac_modification_lsetxattr
- file_groupowner_at_allow
- rsyslog_files_groupownership
- mount_option_tmp_noexec
- file_owner_backup_etc_gshadow
- audit_rules_sysadmin_actions
- file_permissions_sshd_config
- partition_for_var_tmp
- sudo_custom_logfile
- file_group_ownership_var_log_audit
- file_permissions_crontab
- sysctl_net_ipv4_conf_default_log_martians
- file_groupownership_sshd_pub_key
- file_permissions_cron_monthly
- file_permission_user_init_files
- partition_for_tmp
- ensure_gpgcheck_never_disabled
- sshd_set_loglevel_verbose
- kernel_module_dccp_disabled
- audit_rules_privileged_commands_kmod
- file_owner_grub2_cfg
- file_permissions_etc_gshadow
- grub2_enable_selinux
- selinux_state
- audit_rules_file_deletion_events_unlinkat
- file_permissions_audit_binaries
- audit_rules_time_settimeofday
- mount_option_var_nosuid
- mount_option_dev_shm_nodev
- auditd_data_retention_admin_space_left_action
- package_ftp_removed
- file_owner_backup_etc_group
- sshd_set_login_grace_time
- accounts_no_uid_except_zero
- mount_option_dev_shm_noexec
- grub2_audit_backlog_limit_argument
- set_password_hashing_algorithm_logindefs
- file_permissions_etc_issue_net
- audit_rules_kernel_module_loading_init
- file_groupowner_efi_user_cfg
- audit_rules_dac_modification_setxattr
- file_groupowner_etc_shadow
- sshd_use_strong_macs
- sshd_set_keepalive
- mount_option_var_log_nodev
- sysctl_net_ipv4_conf_default_secure_redirects
- sysctl_net_ipv4_conf_all_rp_filter
- accounts_password_set_warn_age_existing
- dconf_gnome_banner_enabled
- accounts_password_pam_minclass
- file_permissions_backup_etc_gshadow
- package_avahi_removed
- sysctl_net_ipv4_conf_default_accept_source_route
- sysctl_net_ipv6_conf_all_forwarding
- audit_rules_dac_modification_lremovexattr
- accounts_passwords_pam_faillock_deny_root
- audit_rules_dac_modification_removexattr
- partition_for_home
- auditd_data_disk_full_action
- file_owner_backup_etc_passwd
- file_ownership_sshd_pub_key
- has_nonlocal_mta
- partition_for_var
- audit_rules_execution_chacl
- audit_rules_dac_modification_fchownat
- package_aide_installed
- kernel_module_jffs2_disabled
- banner_etc_issue_net
- file_ownership_home_directories
- audit_rules_login_events_lastlog
- audit_rules_usergroup_modification_group
- file_permissions_cron_hourly
- account_unique_id
- no_password_auth_for_systemaccounts
- accounts_password_pam_dictcheck
- accounts_user_interactive_home_directory_exists
- sshd_limit_user_access
- audit_rules_media_export
- file_groupownership_sshd_private_key
- sysctl_net_ipv4_icmp_echo_ignore_broadcasts
- accounts_password_pam_enforce_root
- root_path_no_dot
- package_pam_pwquality_installed
- banner_etc_motd
- package_vsftpd_removed
- sysctl_net_ipv4_conf_default_send_redirects
- aide_check_audit_tools
- package_squid_removed
- group_unique_name
- postfix_network_listening_disabled
- audit_rules_unsuccessful_file_modification_open
- file_permissions_etc_shadow
- file_owner_backup_etc_shadow
- sysctl_net_ipv6_conf_default_accept_ra
- auditd_data_retention_max_log_file
- socket_systemd-journal-remote_disabled
- set_password_hashing_algorithm_libuserconf
- kernel_module_rds_disabled
- audit_rules_dac_modification_fchown
- rsyslog_files_permissions
- file_groupowner_etc_group
- file_permissions_etc_passwd
- sysctl_net_ipv4_conf_all_log_martians
- audit_rules_kernel_module_loading_create
- file_permissions_etc_group
- file_permissions_backup_etc_group
- sysctl_net_ipv4_ip_forward
- selinux_not_disabled
- audit_rules_dac_modification_chown
- sysctl_net_ipv4_conf_default_rp_filter
- kernel_module_freevxfs_disabled
- partition_for_dev_shm
- sysctl_kernel_yama_ptrace_scope
- dconf_gnome_disable_automount_open
- file_permissions_user_cfg
- file_permissions_unauthorized_world_writable
- accounts_password_pam_maxrepeat
- disable_host_auth
- kernel_module_udf_disabled
- audit_rules_unsuccessful_file_modification_openat
- audit_rules_suid_auid_privilege_function
- audit_rules_usergroup_modification_opasswd
- service_nftables_disabled
- package_sudo_installed
- file_permissions_ungroupowned
- file_permissions_etc_motd
- file_groupowner_etc_passwd
- no_forward_files
- no_empty_passwords
- accounts_user_dot_user_ownership
- file_groupowner_etc_gshadow
- sshd_set_max_auth_tries
- file_groupowner_cron_d
- file_owner_etc_group
- audit_rules_privileged_commands
- sysctl_net_ipv6_conf_all_accept_redirects
- file_owner_user_cfg
- file_owner_etc_issue
- sudo_require_reauthentication
- sysctl_net_ipv4_conf_all_send_redirects
- package_samba_removed
- aide_periodic_cron_checking
- audit_rules_file_deletion_events_unlink
- file_groupownership_audit_configuration
- audit_rules_usergroup_modification_passwd
- file_owner_etc_shadow
- package_dovecot_removed
- package_httpd_removed
- package_nginx_removed
- sshd_disable_rhosts
- file_owner_etc_issue_net
- sysctl_net_ipv4_tcp_syncookies
- sysctl_net_ipv4_icmp_ignore_bogus_error_responses
- dconf_gnome_disable_automount
- file_permissions_cron_weekly
- audit_rules_dac_modification_fsetxattr
- sshd_disable_root_login
- sudo_require_authentication
- file_permissions_efi_grub2_cfg
- file_groupowner_user_cfg
- mount_option_var_tmp_nosuid
- file_ownership_sshd_private_key
- configure_crypto_policy
- audit_rules_immutable
- file_owner_efi_user_cfg
- dconf_gnome_screensaver_idle_delay
- account_unique_name
- mount_option_var_nodev
- package_tftp_removed
- service_auditd_enabled
- accounts_root_gid_zero
- accounts_passwords_pam_faillock_deny
- audit_rules_unsuccessful_file_modification_creat
- sshd_use_approved_ciphers
- gid_passwd_group_same
- mount_option_var_log_nosuid
- dconf_gnome_disable_autorun
- audit_rules_unsuccessful_file_modification_truncate
- file_permissions_at_allow
- file_owner_etc_shells
- accounts_umask_etc_login_defs
- coredump_disable_backtraces
- kernel_module_squashfs_disabled
- audit_rules_dac_modification_fchmodat
- accounts_tmout
- mount_option_var_log_audit_noexec
- mount_option_tmp_nodev
- audit_rules_kernel_module_loading_finit
- file_ownership_audit_binaries
- mount_option_home_nodev
- gnome_gdm_disable_xdmcp
- file_groupowner_cron_daily
- aide_build_database
- grub2_password
- mount_option_var_log_audit_nodev
- dconf_gnome_screensaver_user_locks
- package_telnet_removed
- firewalld_loopback_traffic_restricted
- audit_rules_dac_modification_chmod
- no_shelllogin_for_systemaccounts
- file_owner_cron_monthly
- sshd_disable_empty_passwords
- package_xinetd_removed
- sysctl_net_ipv4_conf_all_accept_redirects
- account_password_pam_faillock_system_auth
- file_permissions_cron_allow
- sysctl_kernel_randomize_va_space
- mount_option_var_tmp_noexec
- no_rsh_trust_files
- mount_option_tmp_nosuid
- file_permissions_backup_etc_passwd
- ensure_root_password_configured
- sysctl_net_ipv4_conf_default_accept_redirects
- file_groupowner_cron_hourly
- file_groupowner_crontab
- file_permissions_sshd_private_key
- partition_for_var_log_audit
- file_cron_allow_exists
- enable_authselect
- chronyd_specify_remote_server
- package_rsyslog_installed
- accounts_passwords_pam_faillock_unlock_time
- sshd_use_strong_kex
- no_files_unowned_by_user
- sysctl_net_ipv6_conf_all_accept_ra
- file_groupownership_audit_binaries
- file_permissions_etc_shells
- file_owner_etc_passwd
- file_permissions_grub2_cfg
- grub2_uefi_password
- package_chrony_installed
- audit_rules_dac_modification_fchmod
- mount_option_var_log_noexec
- audit_rules_dac_modification_lchown
- coredump_disable_storage
- sshd_set_max_sessions
- package_libselinux_installed
- audit_rules_login_events_faillock
- file_groupowner_etc_shells
- file_groupowner_backup_etc_passwd
- sysctl_net_ipv6_conf_default_accept_source_route
- audit_rules_networkconfig_modification
- audit_rules_networkconfig_modification_network_scripts
- package_audit_installed
- accounts_password_pam_difok
- account_disable_post_pw_expiration
- audit_rules_file_deletion_events_renameat
- account_password_pam_faillock_password_auth
- grub2_audit_argument
- accounts_maximum_age_login_defs
- file_groupowner_sshd_config
- audit_rules_unsuccessful_file_modification_ftruncate
- package_rsync_removed
- accounts_password_warn_age_login_defs
- audit_rules_usergroup_modification_shadow
- mount_option_home_nosuid
- sysctl_net_ipv4_conf_all_accept_source_route
- file_groupowner_backup_etc_shadow
- file_groupowner_cron_allow
- sshd_enable_warning_banner_net
- file_permissions_efi_user_cfg
- dconf_gnome_screensaver_lock_delay
- var_user_initialization_files_regex=all_dotfiles
- var_accounts_user_umask=027
- var_accounts_tmout=15_min
- var_account_disable_post_pw_expiration=30
- var_accounts_password_warn_age_login_defs=7
- var_accounts_maximum_age_login_defs=365
- var_password_hashing_algorithm=SHA512
- var_password_pam_remember_control_flag=requisite_or_required
- var_password_pam_remember=24
- var_password_pam_dictcheck=1
- var_password_pam_maxrepeat=3
- var_password_pam_minclass=4
- var_password_pam_minlen=14
- var_password_pam_difok=2
- var_accounts_passwords_pam_faillock_unlock_time=900
- var_accounts_passwords_pam_faillock_deny=5
- var_pam_wheel_group_for_su=cis
- var_sshd_set_maxstartups=10:30:60
- var_sshd_max_sessions=10
- sshd_max_auth_tries_value=4
- sshd_strong_macs=cis_rhel8
- var_sshd_set_login_grace_time=60
- sshd_strong_kex=cis_rhel8
- sshd_idle_timeout_value=5_minutes
- var_sshd_set_keepalive=1
- sshd_approved_ciphers=cis_rhel8
- sysctl_net_ipv6_conf_all_accept_ra_value=disabled
- sysctl_net_ipv6_conf_default_accept_ra_value=disabled
- sysctl_net_ipv4_tcp_syncookies_value=enabled
- sysctl_net_ipv4_conf_all_log_martians_value=enabled
- sysctl_net_ipv4_conf_default_log_martians_value=enabled
- sysctl_net_ipv4_conf_all_accept_source_route_value=disabled
- sysctl_net_ipv4_conf_default_accept_source_route_value=disabled
- sysctl_net_ipv6_conf_all_accept_source_route_value=disabled
- sysctl_net_ipv6_conf_default_accept_source_route_value=disabled
- sysctl_net_ipv4_conf_all_rp_filter_value=enabled
- sysctl_net_ipv4_conf_default_rp_filter_value=enabled
- sysctl_net_ipv4_conf_all_secure_redirects_value=disabled
- sysctl_net_ipv4_conf_default_secure_redirects_value=disabled
- sysctl_net_ipv4_conf_all_accept_redirects_value=disabled
- sysctl_net_ipv4_conf_default_accept_redirects_value=disabled
- sysctl_net_ipv6_conf_all_accept_redirects_value=disabled
- sysctl_net_ipv6_conf_default_accept_redirects_value=disabled
- sysctl_net_ipv4_icmp_echo_ignore_broadcasts_value=enabled
- sysctl_net_ipv4_icmp_ignore_bogus_error_responses_value=enabled
- sysctl_net_ipv6_conf_all_forwarding_value=disabled
- var_postfix_inet_interfaces=loopback-only
- var_multiple_time_servers=rhel
- inactivity_timeout_value=15_minutes
- var_screensaver_lock_delay=5_seconds
- remote_login_banner_text=cis_banners
- login_banner_text=cis_banners
- motd_banner_text=cis_banners
- var_system_crypto_policy=default_nosha1
- var_selinux_policy_name=targeted
- var_authselect_profile=sssd
- var_accounts_passwords_pam_faillock_dir=run
- var_auditd_action_mail_acct=root
- var_auditd_admin_space_left_action=cis_rhel8
- var_auditd_space_left_action=cis_rhel8
- var_auditd_disk_error_action=cis_rhel8
- var_auditd_disk_full_action=cis_rhel8
- var_auditd_max_log_file_action=keep_logs
- var_auditd_max_log_file=6
- var_selinux_state=enforcing
unselected_groups: []
platforms: !!set {}
cpe_names: !!set {}
platform: null
filter_rules: ''
policies:
- cis_rhel8
title: CIS Red Hat Enterprise Linux 8 Benchmark for Level 2 - Workstation
definition_location: /home/jcerny/work/git/content/products/rhel8/profiles/cis_workstation_l2.profile
documentation_complete: true
