/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.xsd;

import com.thaiopensource.relaxng.output.xsd.ComplexTypeComplexContentExtension;
import com.thaiopensource.relaxng.output.xsd.ComplexTypeSimpleContentExtension;
import com.thaiopensource.relaxng.output.xsd.NamespaceManager;
import com.thaiopensource.relaxng.output.xsd.basic.Attribute;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeGroup;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeGroupDefinition;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeGroupRef;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeUse;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexTypeComplexContent;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexTypeSimpleContent;
import com.thaiopensource.relaxng.output.xsd.basic.Element;
import com.thaiopensource.relaxng.output.xsd.basic.GroupDefinition;
import com.thaiopensource.relaxng.output.xsd.basic.GroupRef;
import com.thaiopensource.relaxng.output.xsd.basic.Particle;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleAll;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleChoice;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleRepeat;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleSequence;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.RootDeclaration;
import com.thaiopensource.relaxng.output.xsd.basic.Schema;
import com.thaiopensource.relaxng.output.xsd.basic.SchemaTransformer;
import com.thaiopensource.relaxng.output.xsd.basic.SchemaWalker;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleType;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeDefinition;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeList;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeRef;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeUnion;
import com.thaiopensource.relaxng.output.xsd.basic.WildcardElement;
import com.thaiopensource.util.VoidValue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ComplexTypeSelector
extends SchemaWalker {
    private final Map<String, Refs> groupMap = new HashMap<String, Refs>();
    private final Map<String, Refs> attributeGroupMap = new HashMap<String, Refs>();
    private final Map<String, Refs> simpleTypeMap = new HashMap<String, Refs>();
    private String parentDefinition;
    private Element parentElement;
    private int nonTypeReference = 0;
    private int undesirable = 0;
    private final Map<String, NamedComplexType> complexTypeMap = new HashMap<String, NamedComplexType>();
    private final Schema schema;
    private final Transformer transformer;
    private final ParticleVisitor<String> baseFinder = new BaseFinder();

    ComplexTypeSelector(Schema schema) {
        this.schema = schema;
        this.transformer = new Transformer(schema);
        schema.accept(this);
        this.chooseComplexTypes(this.groupMap);
        this.chooseComplexTypes(this.simpleTypeMap);
    }

    @Override
    public void visitGroup(GroupDefinition groupDefinition) {
        this.parentDefinition = groupDefinition.getName();
        groupDefinition.getParticle().accept(this);
        this.parentDefinition = null;
    }

    @Override
    public void visitSimpleType(SimpleTypeDefinition simpleTypeDefinition) {
        this.parentDefinition = simpleTypeDefinition.getName();
        simpleTypeDefinition.getSimpleType().accept(this);
        this.parentDefinition = null;
    }

    @Override
    public void visitAttributeGroup(AttributeGroupDefinition attributeGroupDefinition) {
        this.parentDefinition = attributeGroupDefinition.getName();
        attributeGroupDefinition.getAttributeUses().accept(this);
        this.parentDefinition = null;
    }

    @Override
    public void visitRoot(RootDeclaration rootDeclaration) {
        ++this.undesirable;
        rootDeclaration.getParticle().accept(this);
        --this.undesirable;
    }

    @Override
    public VoidValue visitElement(Element element) {
        Element element2 = this.parentElement;
        int n = this.nonTypeReference;
        int n2 = this.undesirable;
        this.parentElement = element;
        this.nonTypeReference = 0;
        this.undesirable = 0;
        element.getComplexType().accept(this);
        this.undesirable = n2;
        this.nonTypeReference = n;
        this.parentElement = element2;
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitSequence(ParticleSequence particleSequence) {
        Iterator<Particle> iterator = particleSequence.getChildren().iterator();
        ++this.undesirable;
        iterator.next().accept(this);
        --this.undesirable;
        ++this.nonTypeReference;
        while (iterator.hasNext()) {
            iterator.next().accept(this);
        }
        --this.nonTypeReference;
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitChoice(ParticleChoice particleChoice) {
        ++this.nonTypeReference;
        super.visitChoice(particleChoice);
        --this.nonTypeReference;
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitAll(ParticleAll particleAll) {
        ++this.nonTypeReference;
        super.visitAll(particleAll);
        --this.nonTypeReference;
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitRepeat(ParticleRepeat particleRepeat) {
        ++this.nonTypeReference;
        super.visitRepeat(particleRepeat);
        --this.nonTypeReference;
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitAttribute(Attribute attribute) {
        ++this.nonTypeReference;
        SimpleType simpleType = attribute.getType();
        if (simpleType != null) {
            simpleType.accept(this);
        }
        --this.nonTypeReference;
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitComplexContent(ComplexTypeComplexContent complexTypeComplexContent) {
        super.visitComplexContent(complexTypeComplexContent);
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitSimpleContent(ComplexTypeSimpleContent complexTypeSimpleContent) {
        super.visitSimpleContent(complexTypeSimpleContent);
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitUnion(SimpleTypeUnion simpleTypeUnion) {
        ++this.nonTypeReference;
        super.visitUnion(simpleTypeUnion);
        --this.nonTypeReference;
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitList(SimpleTypeList simpleTypeList) {
        ++this.nonTypeReference;
        super.visitList(simpleTypeList);
        --this.nonTypeReference;
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitGroupRef(GroupRef groupRef) {
        this.noteRef(this.groupMap, groupRef.getName());
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitAttributeGroupRef(AttributeGroupRef attributeGroupRef) {
        this.noteRef(this.attributeGroupMap, attributeGroupRef.getName());
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitRef(SimpleTypeRef simpleTypeRef) {
        ++this.undesirable;
        this.noteRef(this.simpleTypeMap, simpleTypeRef.getName());
        --this.undesirable;
        return VoidValue.VOID;
    }

    private void noteRef(Map<String, Refs> map, String string) {
        Refs refs = ComplexTypeSelector.lookupRefs(map, string);
        if (this.nonTypeReference > 0) {
            refs.nonTypeReference = true;
        } else if (this.parentElement != null) {
            refs.referencingElements.add(this.parentElement);
        } else if (this.parentDefinition != null) {
            refs.referencingDefinitions.add(this.parentDefinition);
        }
        if (this.undesirable == 0) {
            refs.desirable = true;
        }
    }

    private static Refs lookupRefs(Map<String, Refs> map, String string) {
        Refs refs = map.get(string);
        if (refs == null) {
            refs = new Refs();
            map.put(string, refs);
        }
        return refs;
    }

    private void chooseComplexTypes(Map<String, Refs> map) {
        boolean bl;
        do {
            bl = false;
            for (Map.Entry<String, Refs> entry : map.entrySet()) {
                String string = entry.getKey();
                if (!this.createComplexType(string, entry.getValue(), this.attributeGroupMap.get(string))) continue;
                bl = true;
            }
        } while (bl);
    }

    private boolean createComplexType(String string, Refs refs, Refs refs2) {
        if (this.complexTypeMap.get(string) != null) {
            return false;
        }
        if (refs.nonTypeReference) {
            return false;
        }
        if (refs2 == null ? !refs.desirable : !((Object)refs2.referencingDefinitions).equals(refs.referencingDefinitions) || !((Object)refs2.referencingElements).equals(refs.referencingElements)) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Element object : refs.referencingElements) {
            boolean bl3 = object.getComplexType().isMixed();
            if (bl3 != bl) {
                if (bl2) {
                    return false;
                }
                bl = bl3;
            }
            bl2 = true;
        }
        for (String string2 : refs.referencingDefinitions) {
            NamedComplexType namedComplexType = this.complexTypeMap.get(string2);
            if (namedComplexType == null) {
                return false;
            }
            if (namedComplexType.mixed != bl) {
                if (bl2) {
                    return false;
                }
                bl = namedComplexType.mixed;
            }
            bl2 = true;
        }
        this.complexTypeMap.put(string, new NamedComplexType(bl));
        return true;
    }

    private Particle transformParticle(Particle particle) {
        if (particle == null) {
            return particle;
        }
        return particle.accept(this.transformer);
    }

    private AttributeUse transformAttributeUses(AttributeUse attributeUse) {
        return attributeUse.accept(this.transformer);
    }

    String particleBase(Particle particle) {
        if (particle == null) {
            return null;
        }
        return particle.accept(this.baseFinder);
    }

    ComplexTypeComplexContentExtension transformComplexContent(ComplexTypeComplexContent complexTypeComplexContent) {
        String string = this.particleBase(complexTypeComplexContent.getParticle());
        if (string != null) {
            Particle particle = this.transformParticle(complexTypeComplexContent.getParticle());
            return new ComplexTypeComplexContentExtension(this.transformAttributeUses(complexTypeComplexContent.getAttributeUses()), particle, particle != null && complexTypeComplexContent.isMixed(), string);
        }
        return new ComplexTypeComplexContentExtension(complexTypeComplexContent);
    }

    ComplexTypeSimpleContentExtension transformSimpleContent(ComplexTypeSimpleContent complexTypeSimpleContent) {
        String string;
        NamedComplexType namedComplexType;
        SimpleType simpleType = complexTypeSimpleContent.getSimpleType();
        if (simpleType instanceof SimpleTypeRef && (namedComplexType = this.complexTypeMap.get(string = ((SimpleTypeRef)simpleType).getName())) != null) {
            return new ComplexTypeSimpleContentExtension(this.transformAttributeUses(complexTypeSimpleContent.getAttributeUses()), null, string);
        }
        return new ComplexTypeSimpleContentExtension(complexTypeSimpleContent);
    }

    ComplexTypeComplexContentExtension createComplexTypeForGroup(String string, NamespaceManager namespaceManager) {
        NamedComplexType namedComplexType = this.complexTypeMap.get(string);
        if (namedComplexType == null) {
            return null;
        }
        AttributeGroupDefinition attributeGroupDefinition = this.schema.getAttributeGroup(string);
        AttributeUse attributeUse = attributeGroupDefinition == null ? AttributeGroup.EMPTY : attributeGroupDefinition.getAttributeUses();
        GroupDefinition groupDefinition = this.schema.getGroup(string);
        if (namespaceManager.getGroupDefinitionAbstractElementName(groupDefinition) != null) {
            return new ComplexTypeComplexContentExtension(attributeUse, new GroupRef(groupDefinition.getParticle().getLocation(), null, string), namedComplexType.mixed, null);
        }
        return this.transformComplexContent(new ComplexTypeComplexContent(attributeUse, groupDefinition.getParticle(), namedComplexType.mixed));
    }

    ComplexTypeSimpleContentExtension createComplexTypeForSimpleType(String string) {
        NamedComplexType namedComplexType = this.complexTypeMap.get(string);
        if (namedComplexType == null) {
            return null;
        }
        AttributeGroupDefinition attributeGroupDefinition = this.schema.getAttributeGroup(string);
        AttributeUse attributeUse = attributeGroupDefinition == null ? AttributeGroup.EMPTY : attributeGroupDefinition.getAttributeUses();
        return this.transformSimpleContent(new ComplexTypeSimpleContent(attributeUse, this.schema.getSimpleType(string).getSimpleType()));
    }

    boolean isComplexType(String string) {
        return this.complexTypeMap.get(string) != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BaseFinder
    implements ParticleVisitor<String> {
        BaseFinder() {
        }

        @Override
        public String visitGroupRef(GroupRef groupRef) {
            if (ComplexTypeSelector.this.complexTypeMap.get(groupRef.getName()) != null) {
                return groupRef.getName();
            }
            return null;
        }

        @Override
        public String visitSequence(ParticleSequence particleSequence) {
            return particleSequence.getChildren().get(0).accept(this);
        }

        @Override
        public String visitElement(Element element) {
            return null;
        }

        @Override
        public String visitWildcardElement(WildcardElement wildcardElement) {
            return null;
        }

        @Override
        public String visitRepeat(ParticleRepeat particleRepeat) {
            return null;
        }

        @Override
        public String visitChoice(ParticleChoice particleChoice) {
            return null;
        }

        @Override
        public String visitAll(ParticleAll particleAll) {
            return null;
        }
    }

    class Transformer
    extends SchemaTransformer {
        Transformer(Schema schema) {
            super(schema);
        }

        public AttributeUse visitAttributeGroupRef(AttributeGroupRef attributeGroupRef) {
            if (ComplexTypeSelector.this.complexTypeMap.get(attributeGroupRef.getName()) != null) {
                return AttributeGroup.EMPTY;
            }
            return attributeGroupRef;
        }

        public Particle visitGroupRef(GroupRef groupRef) {
            if (ComplexTypeSelector.this.complexTypeMap.get(groupRef.getName()) != null) {
                return null;
            }
            return groupRef;
        }

        public Particle visitElement(Element element) {
            return element;
        }

        public AttributeUse visitAttribute(Attribute attribute) {
            return attribute;
        }
    }

    static class NamedComplexType {
        private final boolean mixed;

        NamedComplexType(boolean bl) {
            this.mixed = bl;
        }
    }

    static class Refs {
        final Set<Element> referencingElements = new HashSet<Element>();
        final Set<String> referencingDefinitions = new HashSet<String>();
        boolean nonTypeReference = false;
        boolean desirable = false;

        Refs() {
        }
    }
}

