/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

static byte macPalette[768] = {
	0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x22, 0x22, 0x22, 0x44, 0x44, 0x44,  //   0 (0x00)
	0x55, 0x55, 0x55, 0x77, 0x77, 0x77, 0x88, 0x88, 0x88, 0xaa, 0xaa, 0xaa,  //   4 (0x04)
	0xbb, 0xbb, 0xbb, 0xdd, 0xdd, 0xdd, 0xee, 0xee, 0xee, 0x00, 0x00, 0x11,  //   8 (0x08)
	0x00, 0x00, 0x22, 0x00, 0x00, 0x44, 0x00, 0x00, 0x55, 0x00, 0x00, 0x77,  //  12 (0x0c)
	0x00, 0x00, 0x88, 0x00, 0x00, 0xaa, 0x00, 0x00, 0xbb, 0x00, 0x00, 0xdd,  //  16 (0x10)
	0x00, 0x00, 0xee, 0x00, 0x11, 0x00, 0x00, 0x22, 0x00, 0x00, 0x44, 0x00,  //  20 (0x14)
	0x00, 0x55, 0x00, 0x00, 0x77, 0x00, 0x00, 0x88, 0x00, 0x00, 0xaa, 0x00,  //  24 (0x18)
	0x00, 0xbb, 0x00, 0x00, 0xdd, 0x00, 0x00, 0xee, 0x00, 0x11, 0x00, 0x00,  //  28 (0x1c)
	0x22, 0x00, 0x00, 0x44, 0x00, 0x00, 0x55, 0x00, 0x00, 0x77, 0x00, 0x00,  //  32 (0x20)
	0x88, 0x00, 0x00, 0xaa, 0x00, 0x00, 0xbb, 0x00, 0x00, 0xdd, 0x00, 0x00,  //  36 (0x24)
	0xee, 0x00, 0x00, 0x00, 0x00, 0x33, 0x00, 0x00, 0x66, 0x00, 0x00, 0x99,  //  40 (0x28)
	0x00, 0x00, 0xcc, 0x00, 0x00, 0xff, 0x00, 0x33, 0x00, 0x00, 0x33, 0x33,  //  44 (0x2c)
	0x00, 0x33, 0x66, 0x00, 0x33, 0x99, 0x00, 0x33, 0xcc, 0x00, 0x33, 0xff,  //  48 (0x30)
	0x00, 0x66, 0x00, 0x00, 0x66, 0x33, 0x00, 0x66, 0x66, 0x00, 0x66, 0x99,  //  52 (0x34)
	0x00, 0x66, 0xcc, 0x00, 0x66, 0xff, 0x00, 0x99, 0x00, 0x00, 0x99, 0x33,  //  56 (0x38)
	0x00, 0x99, 0x66, 0x00, 0x99, 0x99, 0x00, 0x99, 0xcc, 0x00, 0x99, 0xff,  //  60 (0x3c)
	0x00, 0xcc, 0x00, 0x00, 0xcc, 0x33, 0x00, 0xcc, 0x66, 0x00, 0xcc, 0x99,  //  64 (0x40)
	0x00, 0xcc, 0xcc, 0x00, 0xcc, 0xff, 0x00, 0xff, 0x00, 0x00, 0xff, 0x33,  //  68 (0x44)
	0x00, 0xff, 0x66, 0x00, 0xff, 0x99, 0x00, 0xff, 0xcc, 0x00, 0xff, 0xff,  //  72 (0x48)
	0x33, 0x00, 0x00, 0x33, 0x00, 0x33, 0x33, 0x00, 0x66, 0x33, 0x00, 0x99,  //  76 (0x4c)
	0x33, 0x00, 0xcc, 0x33, 0x00, 0xff, 0x33, 0x33, 0x00, 0x33, 0x33, 0x33,  //  80 (0x50)
	0x33, 0x33, 0x66, 0x33, 0x33, 0x99, 0x33, 0x33, 0xcc, 0x33, 0x33, 0xff,  //  84 (0x54)
	0x33, 0x66, 0x00, 0x33, 0x66, 0x33, 0x33, 0x66, 0x66, 0x33, 0x66, 0x99,  //  88 (0x58)
	0x33, 0x66, 0xcc, 0x33, 0x66, 0xff, 0x33, 0x99, 0x00, 0x33, 0x99, 0x33,  //  92 (0x5c)
	0x33, 0x99, 0x66, 0x33, 0x99, 0x99, 0x33, 0x99, 0xcc, 0x33, 0x99, 0xff,  //  96 (0x60)
	0x33, 0xcc, 0x00, 0x33, 0xcc, 0x33, 0x33, 0xcc, 0x66, 0x33, 0xcc, 0x99,  // 100 (0x64)
	0x33, 0xcc, 0xcc, 0x33, 0xcc, 0xff, 0x33, 0xff, 0x00, 0x33, 0xff, 0x33,  // 104 (0x68)
	0x33, 0xff, 0x66, 0x33, 0xff, 0x99, 0x33, 0xff, 0xcc, 0x33, 0xff, 0xff,  // 108 (0x6c)
	0x66, 0x00, 0x00, 0x66, 0x00, 0x33, 0x66, 0x00, 0x66, 0x66, 0x00, 0x99,  // 112 (0x70)
	0x66, 0x00, 0xcc, 0x66, 0x00, 0xff, 0x66, 0x33, 0x00, 0x66, 0x33, 0x33,  // 116 (0x74)
	0x66, 0x33, 0x66, 0x66, 0x33, 0x99, 0x66, 0x33, 0xcc, 0x66, 0x33, 0xff,  // 120 (0x78)
	0x66, 0x66, 0x00, 0x66, 0x66, 0x33, 0x66, 0x66, 0x66, 0x66, 0x66, 0x99,  // 124 (0x7c)
	0x66, 0x66, 0xcc, 0x66, 0x66, 0xff, 0x66, 0x99, 0x00, 0x66, 0x99, 0x33,  // 128 (0x80)
	0x66, 0x99, 0x66, 0x66, 0x99, 0x99, 0x66, 0x99, 0xcc, 0x66, 0x99, 0xff,  // 132 (0x84)
	0x66, 0xcc, 0x00, 0x66, 0xcc, 0x33, 0x66, 0xcc, 0x66, 0x66, 0xcc, 0x99,  // 136 (0x88)
	0x66, 0xcc, 0xcc, 0x66, 0xcc, 0xff, 0x66, 0xff, 0x00, 0x66, 0xff, 0x33,  // 140 (0x8c)
	0x66, 0xff, 0x66, 0x66, 0xff, 0x99, 0x66, 0xff, 0xcc, 0x66, 0xff, 0xff,  // 144 (0x90)
	0x99, 0x00, 0x00, 0x99, 0x00, 0x33, 0x99, 0x00, 0x66, 0x99, 0x00, 0x99,  // 148 (0x94)
	0x99, 0x00, 0xcc, 0x99, 0x00, 0xff, 0x99, 0x33, 0x00, 0x99, 0x33, 0x33,  // 152 (0x98)
	0x99, 0x33, 0x66, 0x99, 0x33, 0x99, 0x99, 0x33, 0xcc, 0x99, 0x33, 0xff,  // 156 (0x9c)
	0x99, 0x66, 0x00, 0x99, 0x66, 0x33, 0x99, 0x66, 0x66, 0x99, 0x66, 0x99,  // 160 (0xa0)
	0x99, 0x66, 0xcc, 0x99, 0x66, 0xff, 0x99, 0x99, 0x00, 0x99, 0x99, 0x33,  // 164 (0xa4)
	0x99, 0x99, 0x66, 0x99, 0x99, 0x99, 0x99, 0x99, 0xcc, 0x99, 0x99, 0xff,  // 168 (0xa8)
	0x99, 0xcc, 0x00, 0x99, 0xcc, 0x33, 0x99, 0xcc, 0x66, 0x99, 0xcc, 0x99,  // 172 (0xac)
	0x99, 0xcc, 0xcc, 0x99, 0xcc, 0xff, 0x99, 0xff, 0x00, 0x99, 0xff, 0x33,  // 176 (0xb0)
	0x99, 0xff, 0x66, 0x99, 0xff, 0x99, 0x99, 0xff, 0xcc, 0x99, 0xff, 0xff,  // 180 (0xb4)
	0xcc, 0x00, 0x00, 0xcc, 0x00, 0x33, 0xcc, 0x00, 0x66, 0xcc, 0x00, 0x99,  // 184 (0xb8)
	0xcc, 0x00, 0xcc, 0xcc, 0x00, 0xff, 0xcc, 0x33, 0x00, 0xcc, 0x33, 0x33,  // 188 (0xbc)
	0xcc, 0x33, 0x66, 0xcc, 0x33, 0x99, 0xcc, 0x33, 0xcc, 0xcc, 0x33, 0xff,  // 192 (0xc0)
	0xcc, 0x66, 0x00, 0xcc, 0x66, 0x33, 0xcc, 0x66, 0x66, 0xcc, 0x66, 0x99,  // 196 (0xc4)
	0xcc, 0x66, 0xcc, 0xcc, 0x66, 0xff, 0xcc, 0x99, 0x00, 0xcc, 0x99, 0x33,  // 200 (0xc8)
	0xcc, 0x99, 0x66, 0xcc, 0x99, 0x99, 0xcc, 0x99, 0xcc, 0xcc, 0x99, 0xff,  // 204 (0xcc)
	0xcc, 0xcc, 0x00, 0xcc, 0xcc, 0x33, 0xcc, 0xcc, 0x66, 0xcc, 0xcc, 0x99,  // 208 (0xd0)
	0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xff, 0xcc, 0xff, 0x00, 0xcc, 0xff, 0x33,  // 212 (0xd4)
	0xcc, 0xff, 0x66, 0xcc, 0xff, 0x99, 0xcc, 0xff, 0xcc, 0xcc, 0xff, 0xff,  // 216 (0xd8)
	0xff, 0x00, 0x00, 0xff, 0x00, 0x33, 0xff, 0x00, 0x66, 0xff, 0x00, 0x99,  // 220 (0xdc)
	0xff, 0x00, 0xcc, 0xff, 0x00, 0xff, 0xff, 0x33, 0x00, 0xff, 0x33, 0x33,  // 224 (0xe0)
	0xff, 0x33, 0x66, 0xff, 0x33, 0x99, 0xff, 0x33, 0xcc, 0xff, 0x33, 0xff,  // 228 (0xe4)
	0xff, 0x66, 0x00, 0xff, 0x66, 0x33, 0xff, 0x66, 0x66, 0xff, 0x66, 0x99,  // 232 (0xe8)
	0xff, 0x66, 0xcc, 0xff, 0x66, 0xff, 0xff, 0x99, 0x00, 0xff, 0x99, 0x33,  // 236 (0xec)
	0xff, 0x99, 0x66, 0xff, 0x99, 0x99, 0xff, 0x99, 0xcc, 0xff, 0x99, 0xff,  // 240 (0xf0)
	0xff, 0xcc, 0x00, 0xff, 0xcc, 0x33, 0xff, 0xcc, 0x66, 0xff, 0xcc, 0x99,  // 244 (0xf4)
	0xff, 0xcc, 0xcc, 0xff, 0xcc, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0x33,  // 248 (0xf8)
	0xff, 0xff, 0x66, 0xff, 0xff, 0x99, 0xff, 0xff, 0xcc, 0xff, 0xff, 0xff   // 252 (0xfc)
};

static byte rainbowPalette[768] = {
	0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x20, 0x20, 0x20, 0x30, 0x30, 0x30,  // 0 (0x00)
	0x40, 0x40, 0x40, 0x50, 0x50, 0x50, 0x60, 0x60, 0x60, 0x70, 0x70, 0x70,  // 4 (0x04)
	0x80, 0x80, 0x80, 0x90, 0x90, 0x90, 0xa0, 0xa0, 0xa0, 0xb0, 0xb0, 0xb0,  // 8 (0x08)
	0xc0, 0xc0, 0xc0, 0xd0, 0xd0, 0xd0, 0xe0, 0xe0, 0xe0, 0xf0, 0xf0, 0xf0,  // 12 (0x0c)
	0x00, 0x72, 0xff, 0x00, 0x79, 0xff, 0x00, 0x7f, 0xff, 0x00, 0x85, 0xff,  // 16 (0x10)
	0x00, 0x8c, 0xff, 0x00, 0x92, 0xff, 0x00, 0x99, 0xff, 0x00, 0x9f, 0xff,  // 20 (0x14)
	0x00, 0xa5, 0xff, 0x00, 0xac, 0xff, 0x00, 0xb2, 0xff, 0x00, 0xb8, 0xff,  // 24 (0x18)
	0x00, 0xbf, 0xff, 0x00, 0xc5, 0xff, 0x00, 0xcc, 0xff, 0x00, 0xd2, 0xff,  // 28 (0x1c)
	0x00, 0xd8, 0xff, 0x00, 0xdf, 0xff, 0x00, 0xe5, 0xff, 0x00, 0xeb, 0xff,  // 32 (0x20)
	0x00, 0xf2, 0xff, 0x00, 0xf8, 0xff, 0x00, 0xff, 0xff, 0x00, 0xff, 0xf8,  // 36 (0x24)
	0x00, 0xff, 0xf2, 0x00, 0xff, 0xeb, 0x00, 0xff, 0xe5, 0x00, 0xff, 0xdf,  // 40 (0x28)
	0x00, 0xff, 0xd8, 0x00, 0xff, 0xd2, 0x00, 0xff, 0xcc, 0x00, 0xff, 0xc5,  // 44 (0x2c)
	0x00, 0xff, 0xbf, 0x00, 0xff, 0xb8, 0x00, 0xff, 0xb2, 0x00, 0xff, 0xac,  // 48 (0x30)
	0x00, 0xff, 0xa5, 0x00, 0xff, 0x9f, 0x00, 0xff, 0x99, 0x00, 0xff, 0x92,  // 52 (0x34)
	0x00, 0xff, 0x8c, 0x00, 0xff, 0x85, 0x00, 0xff, 0x7f, 0x00, 0xff, 0x79,  // 56 (0x38)
	0x00, 0xff, 0x72, 0x00, 0xff, 0x6c, 0x00, 0xff, 0x66, 0x00, 0xff, 0x5f,  // 60 (0x3c)
	0x00, 0xff, 0x59, 0x00, 0xff, 0x52, 0x00, 0xff, 0x4c, 0x00, 0xff, 0x46,  // 64 (0x40)
	0x00, 0xff, 0x3f, 0x00, 0xff, 0x39, 0x00, 0xff, 0x33, 0x00, 0xff, 0x2c,  // 68 (0x44)
	0x00, 0xff, 0x26, 0x00, 0xff, 0x1f, 0x00, 0xff, 0x19, 0x00, 0xff, 0x13,  // 72 (0x48)
	0x00, 0xff, 0x0c, 0x00, 0xff, 0x06, 0x00, 0xff, 0x00, 0x06, 0xff, 0x00,  // 76 (0x4c)
	0x0c, 0xff, 0x00, 0x13, 0xff, 0x00, 0x19, 0xff, 0x00, 0x1f, 0xff, 0x00,  // 80 (0x50)
	0x26, 0xff, 0x00, 0x2c, 0xff, 0x00, 0x33, 0xff, 0x00, 0x39, 0xff, 0x00,  // 84 (0x54)
	0x3f, 0xff, 0x00, 0x46, 0xff, 0x00, 0x4c, 0xff, 0x00, 0x52, 0xff, 0x00,  // 88 (0x58)
	0x59, 0xff, 0x00, 0x5f, 0xff, 0x00, 0x66, 0xff, 0x00, 0x6c, 0xff, 0x00,  // 92 (0x5c)
	0x72, 0xff, 0x00, 0x79, 0xff, 0x00, 0x7f, 0xff, 0x00, 0x85, 0xff, 0x00,  // 96 (0x60)
	0x8c, 0xff, 0x00, 0x92, 0xff, 0x00, 0x99, 0xff, 0x00, 0x9f, 0xff, 0x00,  // 100 (0x64)
	0xa5, 0xff, 0x00, 0xac, 0xff, 0x00, 0xb2, 0xff, 0x00, 0xb8, 0xff, 0x00,  // 104 (0x68)
	0xbf, 0xff, 0x00, 0xc5, 0xff, 0x00, 0xcc, 0xff, 0x00, 0xd2, 0xff, 0x00,  // 108 (0x6c)
	0xd8, 0xff, 0x00, 0xdf, 0xff, 0x00, 0xe5, 0xff, 0x00, 0xeb, 0xff, 0x00,  // 112 (0x70)
	0xf2, 0xff, 0x00, 0xf8, 0xff, 0x00, 0xff, 0xff, 0x00, 0xff, 0xf8, 0x00,  // 116 (0x74)
	0xff, 0xf2, 0x00, 0xff, 0xeb, 0x00, 0xff, 0xe5, 0x00, 0xff, 0xdf, 0x00,  // 120 (0x78)
	0xff, 0xd8, 0x00, 0xff, 0xd2, 0x00, 0xff, 0xcc, 0x00, 0xff, 0xc5, 0x00,  // 124 (0x7c)
	0xff, 0xbf, 0x00, 0xff, 0xb8, 0x00, 0xff, 0xb2, 0x00, 0xff, 0xac, 0x00,  // 128 (0x80)
	0xff, 0xa5, 0x00, 0xff, 0x9f, 0x00, 0xff, 0x99, 0x00, 0xff, 0x92, 0x00,  // 132 (0x84)
	0xff, 0x8c, 0x00, 0xff, 0x85, 0x00, 0xff, 0x7f, 0x00, 0xff, 0x79, 0x00,  // 136 (0x88)
	0xff, 0x72, 0x00, 0xff, 0x6c, 0x00, 0xff, 0x66, 0x00, 0xff, 0x5f, 0x00,  // 140 (0x8c)
	0xff, 0x59, 0x00, 0xff, 0x52, 0x00, 0xff, 0x4c, 0x00, 0xff, 0x46, 0x00,  // 144 (0x90)
	0xff, 0x3f, 0x00, 0xff, 0x39, 0x00, 0xff, 0x33, 0x00, 0xff, 0x2c, 0x00,  // 148 (0x94)
	0xff, 0x26, 0x00, 0xff, 0x1f, 0x00, 0xff, 0x19, 0x00, 0xff, 0x13, 0x00,  // 152 (0x98)
	0xff, 0x0c, 0x00, 0xff, 0x06, 0x00, 0xff, 0x00, 0x00, 0xff, 0x00, 0x06,  // 156 (0x9c)
	0xff, 0x00, 0x0c, 0xff, 0x00, 0x13, 0xff, 0x00, 0x19, 0xff, 0x00, 0x1f,  // 160 (0xa0)
	0xff, 0x00, 0x26, 0xff, 0x00, 0x2c, 0xff, 0x00, 0x33, 0xff, 0x00, 0x39,  // 164 (0xa4)
	0xff, 0x00, 0x3f, 0xff, 0x00, 0x46, 0xff, 0x00, 0x4c, 0xff, 0x00, 0x52,  // 168 (0xa8)
	0xff, 0x00, 0x59, 0xff, 0x00, 0x5f, 0xff, 0x00, 0x66, 0xff, 0x00, 0x6c,  // 172 (0xac)
	0xff, 0x00, 0x72, 0xff, 0x00, 0x79, 0xff, 0x00, 0x7f, 0xff, 0x00, 0x85,  // 176 (0xb0)
	0xff, 0x00, 0x8c, 0xff, 0x00, 0x92, 0xff, 0x00, 0x99, 0xff, 0x00, 0x9f,  // 180 (0xb4)
	0xff, 0x00, 0xa5, 0xff, 0x00, 0xac, 0xff, 0x00, 0xb2, 0xff, 0x00, 0xb8,  // 184 (0xb8)
	0xff, 0x00, 0xbf, 0xff, 0x00, 0xc5, 0xff, 0x00, 0xcc, 0xff, 0x00, 0xd2,  // 188 (0xbc)
	0xff, 0x00, 0xd8, 0xff, 0x00, 0xdf, 0xff, 0x00, 0xe5, 0xff, 0x00, 0xeb,  // 192 (0xc0)
	0xff, 0x00, 0xf2, 0xff, 0x00, 0xf8, 0xff, 0x00, 0xff, 0xf8, 0x00, 0xff,  // 196 (0xc4)
	0xf2, 0x00, 0xff, 0xeb, 0x00, 0xff, 0xe5, 0x00, 0xff, 0xdf, 0x00, 0xff,  // 200 (0xc8)
	0xd8, 0x00, 0xff, 0xd2, 0x00, 0xff, 0xcc, 0x00, 0xff, 0xc5, 0x00, 0xff,  // 204 (0xcc)
	0xbf, 0x00, 0xff, 0xb8, 0x00, 0xff, 0xb2, 0x00, 0xff, 0xac, 0x00, 0xff,  // 208 (0xd0)
	0xa5, 0x00, 0xff, 0x9f, 0x00, 0xff, 0x99, 0x00, 0xff, 0x92, 0x00, 0xff,  // 212 (0xd4)
	0x8c, 0x00, 0xff, 0x85, 0x00, 0xff, 0x7f, 0x00, 0xff, 0x79, 0x00, 0xff,  // 216 (0xd8)
	0x72, 0x00, 0xff, 0x6c, 0x00, 0xff, 0x66, 0x00, 0xff, 0x5f, 0x00, 0xff,  // 220 (0xdc)
	0x59, 0x00, 0xff, 0x52, 0x00, 0xff, 0x4c, 0x00, 0xff, 0x46, 0x00, 0xff,  // 224 (0xe0)
	0x3f, 0x00, 0xff, 0x39, 0x00, 0xff, 0x33, 0x00, 0xff, 0x2c, 0x00, 0xff,  // 228 (0xe4)
	0x26, 0x00, 0xff, 0x1f, 0x00, 0xff, 0x19, 0x00, 0xff, 0x13, 0x00, 0xff,  // 232 (0xe8)
	0x0c, 0x00, 0xff, 0x06, 0x00, 0xff, 0x00, 0x03, 0xff, 0x00, 0x0a, 0xff,  // 236 (0xec)
	0x00, 0x10, 0xff, 0x00, 0x17, 0xff, 0x00, 0x1d, 0xff, 0x00, 0x23, 0xff,  // 240 (0xf0)
	0x00, 0x2a, 0xff, 0x00, 0x30, 0xff, 0x00, 0x36, 0xff, 0x00, 0x3d, 0xff,  // 244 (0xf4)
	0x00, 0x43, 0xff, 0x00, 0x4a, 0xff, 0x00, 0x50, 0xff, 0x00, 0x56, 0xff,  // 248 (0xf8)
	0x00, 0x5d, 0xff, 0x00, 0x63, 0xff, 0x00, 0x69, 0xff, 0xff, 0xff, 0xff   // 252 (0xfc)
};

static byte grayscalePalette[768] = {
	0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03,  // 0 (0x00)
	0x04, 0x04, 0x04, 0x05, 0x05, 0x05, 0x06, 0x06, 0x06, 0x07, 0x07, 0x07,  // 4 (0x04)
	0x08, 0x08, 0x08, 0x09, 0x09, 0x09, 0x0a, 0x0a, 0x0a, 0x0b, 0x0b, 0x0b,  // 8 (0x08)
	0x0c, 0x0c, 0x0c, 0x0d, 0x0d, 0x0d, 0x0e, 0x0e, 0x0e, 0x0f, 0x0f, 0x0f,  // 12 (0x0c)
	0x10, 0x10, 0x10, 0x11, 0x11, 0x11, 0x12, 0x12, 0x12, 0x13, 0x13, 0x13,  // 16 (0x10)
	0x14, 0x14, 0x14, 0x15, 0x15, 0x15, 0x16, 0x16, 0x16, 0x17, 0x17, 0x17,  // 20 (0x14)
	0x18, 0x18, 0x18, 0x19, 0x19, 0x19, 0x1a, 0x1a, 0x1a, 0x1b, 0x1b, 0x1b,  // 24 (0x18)
	0x1c, 0x1c, 0x1c, 0x1d, 0x1d, 0x1d, 0x1e, 0x1e, 0x1e, 0x1f, 0x1f, 0x1f,  // 28 (0x1c)
	0x20, 0x20, 0x20, 0x21, 0x21, 0x21, 0x22, 0x22, 0x22, 0x23, 0x23, 0x23,  // 32 (0x20)
	0x24, 0x24, 0x24, 0x25, 0x25, 0x25, 0x26, 0x26, 0x26, 0x27, 0x27, 0x27,  // 36 (0x24)
	0x28, 0x28, 0x28, 0x29, 0x29, 0x29, 0x2a, 0x2a, 0x2a, 0x2b, 0x2b, 0x2b,  // 40 (0x28)
	0x2c, 0x2c, 0x2c, 0x2d, 0x2d, 0x2d, 0x2e, 0x2e, 0x2e, 0x2f, 0x2f, 0x2f,  // 44 (0x2c)
	0x30, 0x30, 0x30, 0x31, 0x31, 0x31, 0x32, 0x32, 0x32, 0x33, 0x33, 0x33,  // 48 (0x30)
	0x34, 0x34, 0x34, 0x35, 0x35, 0x35, 0x36, 0x36, 0x36, 0x37, 0x37, 0x37,  // 52 (0x34)
	0x38, 0x38, 0x38, 0x39, 0x39, 0x39, 0x3a, 0x3a, 0x3a, 0x3b, 0x3b, 0x3b,  // 56 (0x38)
	0x3c, 0x3c, 0x3c, 0x3d, 0x3d, 0x3d, 0x3e, 0x3e, 0x3e, 0x3f, 0x3f, 0x3f,  // 60 (0x3c)
	0x40, 0x40, 0x40, 0x41, 0x41, 0x41, 0x42, 0x42, 0x42, 0x43, 0x43, 0x43,  // 64 (0x40)
	0x44, 0x44, 0x44, 0x45, 0x45, 0x45, 0x46, 0x46, 0x46, 0x47, 0x47, 0x47,  // 68 (0x44)
	0x48, 0x48, 0x48, 0x49, 0x49, 0x49, 0x4a, 0x4a, 0x4a, 0x4b, 0x4b, 0x4b,  // 72 (0x48)
	0x4c, 0x4c, 0x4c, 0x4d, 0x4d, 0x4d, 0x4e, 0x4e, 0x4e, 0x4f, 0x4f, 0x4f,  // 76 (0x4c)
	0x50, 0x50, 0x50, 0x51, 0x51, 0x51, 0x52, 0x52, 0x52, 0x53, 0x53, 0x53,  // 80 (0x50)
	0x54, 0x54, 0x54, 0x55, 0x55, 0x55, 0x56, 0x56, 0x56, 0x57, 0x57, 0x57,  // 84 (0x54)
	0x58, 0x58, 0x58, 0x59, 0x59, 0x59, 0x5a, 0x5a, 0x5a, 0x5b, 0x5b, 0x5b,  // 88 (0x58)
	0x5c, 0x5c, 0x5c, 0x5d, 0x5d, 0x5d, 0x5e, 0x5e, 0x5e, 0x5f, 0x5f, 0x5f,  // 92 (0x5c)
	0x60, 0x60, 0x60, 0x61, 0x61, 0x61, 0x62, 0x62, 0x62, 0x63, 0x63, 0x63,  // 96 (0x60)
	0x64, 0x64, 0x64, 0x65, 0x65, 0x65, 0x66, 0x66, 0x66, 0x67, 0x67, 0x67,  // 100 (0x64)
	0x68, 0x68, 0x68, 0x69, 0x69, 0x69, 0x6a, 0x6a, 0x6a, 0x6b, 0x6b, 0x6b,  // 104 (0x68)
	0x6c, 0x6c, 0x6c, 0x6d, 0x6d, 0x6d, 0x6e, 0x6e, 0x6e, 0x6f, 0x6f, 0x6f,  // 108 (0x6c)
	0x70, 0x70, 0x70, 0x71, 0x71, 0x71, 0x72, 0x72, 0x72, 0x73, 0x73, 0x73,  // 112 (0x70)
	0x74, 0x74, 0x74, 0x75, 0x75, 0x75, 0x76, 0x76, 0x76, 0x77, 0x77, 0x77,  // 116 (0x74)
	0x78, 0x78, 0x78, 0x79, 0x79, 0x79, 0x7a, 0x7a, 0x7a, 0x7b, 0x7b, 0x7b,  // 120 (0x78)
	0x7c, 0x7c, 0x7c, 0x7d, 0x7d, 0x7d, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f,  // 124 (0x7c)
	0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x82, 0x82, 0x82, 0x83, 0x83, 0x83,  // 128 (0x80)
	0x84, 0x84, 0x84, 0x85, 0x85, 0x85, 0x86, 0x86, 0x86, 0x87, 0x87, 0x87,  // 132 (0x84)
	0x88, 0x88, 0x88, 0x89, 0x89, 0x89, 0x8a, 0x8a, 0x8a, 0x8b, 0x8b, 0x8b,  // 136 (0x88)
	0x8c, 0x8c, 0x8c, 0x8d, 0x8d, 0x8d, 0x8e, 0x8e, 0x8e, 0x8f, 0x8f, 0x8f,  // 140 (0x8c)
	0x90, 0x90, 0x90, 0x91, 0x91, 0x91, 0x92, 0x92, 0x92, 0x93, 0x93, 0x93,  // 144 (0x90)
	0x94, 0x94, 0x94, 0x95, 0x95, 0x95, 0x96, 0x96, 0x96, 0x97, 0x97, 0x97,  // 148 (0x94)
	0x98, 0x98, 0x98, 0x99, 0x99, 0x99, 0x9a, 0x9a, 0x9a, 0x9b, 0x9b, 0x9b,  // 152 (0x98)
	0x9c, 0x9c, 0x9c, 0x9d, 0x9d, 0x9d, 0x9e, 0x9e, 0x9e, 0x9f, 0x9f, 0x9f,  // 156 (0x9c)
	0xa0, 0xa0, 0xa0, 0xa1, 0xa1, 0xa1, 0xa2, 0xa2, 0xa2, 0xa3, 0xa3, 0xa3,  // 160 (0xa0)
	0xa4, 0xa4, 0xa4, 0xa5, 0xa5, 0xa5, 0xa6, 0xa6, 0xa6, 0xa7, 0xa7, 0xa7,  // 164 (0xa4)
	0xa8, 0xa8, 0xa8, 0xa9, 0xa9, 0xa9, 0xaa, 0xaa, 0xaa, 0xab, 0xab, 0xab,  // 168 (0xa8)
	0xac, 0xac, 0xac, 0xad, 0xad, 0xad, 0xae, 0xae, 0xae, 0xaf, 0xaf, 0xaf,  // 172 (0xac)
	0xb0, 0xb0, 0xb0, 0xb1, 0xb1, 0xb1, 0xb2, 0xb2, 0xb2, 0xb3, 0xb3, 0xb3,  // 176 (0xb0)
	0xb4, 0xb4, 0xb4, 0xb5, 0xb5, 0xb5, 0xb6, 0xb6, 0xb6, 0xb7, 0xb7, 0xb7,  // 180 (0xb4)
	0xb8, 0xb8, 0xb8, 0xb9, 0xb9, 0xb9, 0xba, 0xba, 0xba, 0xbb, 0xbb, 0xbb,  // 184 (0xb8)
	0xbc, 0xbc, 0xbc, 0xbd, 0xbd, 0xbd, 0xbe, 0xbe, 0xbe, 0xbf, 0xbf, 0xbf,  // 188 (0xbc)
	0xc0, 0xc0, 0xc0, 0xc1, 0xc1, 0xc1, 0xc2, 0xc2, 0xc2, 0xc3, 0xc3, 0xc3,  // 192 (0xc0)
	0xc4, 0xc4, 0xc4, 0xc5, 0xc5, 0xc5, 0xc6, 0xc6, 0xc6, 0xc7, 0xc7, 0xc7,  // 196 (0xc4)
	0xc8, 0xc8, 0xc8, 0xc9, 0xc9, 0xc9, 0xca, 0xca, 0xca, 0xcb, 0xcb, 0xcb,  // 200 (0xc8)
	0xcc, 0xcc, 0xcc, 0xcd, 0xcd, 0xcd, 0xce, 0xce, 0xce, 0xcf, 0xcf, 0xcf,  // 204 (0xcc)
	0xd0, 0xd0, 0xd0, 0xd1, 0xd1, 0xd1, 0xd2, 0xd2, 0xd2, 0xd3, 0xd3, 0xd3,  // 208 (0xd0)
	0xd4, 0xd4, 0xd4, 0xd5, 0xd5, 0xd5, 0xd6, 0xd6, 0xd6, 0xd7, 0xd7, 0xd7,  // 212 (0xd4)
	0xd8, 0xd8, 0xd8, 0xd9, 0xd9, 0xd9, 0xda, 0xda, 0xda, 0xdb, 0xdb, 0xdb,  // 216 (0xd8)
	0xdc, 0xdc, 0xdc, 0xdd, 0xdd, 0xdd, 0xde, 0xde, 0xde, 0xdf, 0xdf, 0xdf,  // 220 (0xdc)
	0xe0, 0xe0, 0xe0, 0xe1, 0xe1, 0xe1, 0xe2, 0xe2, 0xe2, 0xe3, 0xe3, 0xe3,  // 224 (0xe0)
	0xe4, 0xe4, 0xe4, 0xe5, 0xe5, 0xe5, 0xe6, 0xe6, 0xe6, 0xe7, 0xe7, 0xe7,  // 228 (0xe4)
	0xe8, 0xe8, 0xe8, 0xe9, 0xe9, 0xe9, 0xea, 0xea, 0xea, 0xeb, 0xeb, 0xeb,  // 232 (0xe8)
	0xec, 0xec, 0xec, 0xed, 0xed, 0xed, 0xee, 0xee, 0xee, 0xef, 0xef, 0xef,  // 236 (0xec)
	0xf0, 0xf0, 0xf0, 0xf1, 0xf1, 0xf1, 0xf2, 0xf2, 0xf2, 0xf3, 0xf3, 0xf3,  // 240 (0xf0)
	0xf4, 0xf4, 0xf4, 0xf5, 0xf5, 0xf5, 0xf6, 0xf6, 0xf6, 0xf7, 0xf7, 0xf7,  // 244 (0xf4)
	0xf8, 0xf8, 0xf8, 0xf9, 0xf9, 0xf9, 0xfa, 0xfa, 0xfa, 0xfb, 0xfb, 0xfb,  // 248 (0xf8)
	0xfc, 0xfc, 0xfc, 0xfd, 0xfd, 0xfd, 0xfe, 0xfe, 0xfe, 0xff, 0xff, 0xff   // 252 (0xfc)
};

static byte pastelsPalette[768] = {
	0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x20, 0x20, 0x20, 0x30, 0x30, 0x30,  // 0 (0x00)
	0x40, 0x40, 0x40, 0x50, 0x50, 0x50, 0x60, 0x60, 0x60, 0x70, 0x70, 0x70,  // 4 (0x04)
	0x80, 0x80, 0x80, 0x90, 0x90, 0x90, 0xa0, 0xa0, 0xa0, 0xb0, 0xb0, 0xb0,  // 8 (0x08)
	0xc0, 0xc0, 0xc0, 0xd0, 0xd0, 0xd0, 0xe0, 0xe0, 0xe0, 0xf0, 0xf0, 0xf0,  // 12 (0x0c)
	0xe4, 0xe4, 0xee, 0xd9, 0xd9, 0xed, 0xcd, 0xcd, 0xec, 0xc2, 0xc2, 0xeb,  // 16 (0x10)
	0xb6, 0xb6, 0xea, 0xab, 0xab, 0xe9, 0x9f, 0x9f, 0xe8, 0x94, 0x94, 0xe7,  // 20 (0x14)
	0x88, 0x88, 0xe6, 0x7d, 0x7d, 0xe5, 0x71, 0x71, 0xe4, 0x66, 0x66, 0xe3,  // 24 (0x18)
	0x5a, 0x5a, 0xe2, 0x4f, 0x4f, 0xe1, 0x44, 0x44, 0xe0, 0x50, 0x45, 0xdc,  // 28 (0x1c)
	0x5c, 0x45, 0xd8, 0x68, 0x46, 0xd4, 0x74, 0x46, 0xd0, 0x7f, 0x46, 0xcc,  // 32 (0x20)
	0x8b, 0x47, 0xc8, 0x97, 0x47, 0xc4, 0xa3, 0x48, 0xc1, 0xaf, 0x48, 0xbd,  // 36 (0x24)
	0xba, 0x48, 0xb9, 0xc6, 0x49, 0xb5, 0xd2, 0x49, 0xb1, 0xde, 0x4a, 0xad,  // 40 (0x28)
	0xea, 0x4a, 0xa9, 0xf6, 0x4b, 0xa6, 0xf4, 0x4b, 0x9f, 0xf3, 0x4b, 0x99,  // 44 (0x2c)
	0xf2, 0x4b, 0x93, 0xf1, 0x4b, 0x8d, 0xf0, 0x4b, 0x87, 0xef, 0x4b, 0x81,  // 48 (0x30)
	0xee, 0x4b, 0x7b, 0xec, 0x4b, 0x74, 0xeb, 0x4b, 0x6e, 0xea, 0x4b, 0x68,  // 52 (0x34)
	0xe9, 0x4b, 0x62, 0xe8, 0x4b, 0x5c, 0xe7, 0x4b, 0x56, 0xe6, 0x4b, 0x50,  // 56 (0x38)
	0xe5, 0x4b, 0x4a, 0xe7, 0x57, 0x49, 0xe9, 0x62, 0x49, 0xea, 0x6d, 0x49,  // 60 (0x3c)
	0xec, 0x79, 0x49, 0xed, 0x84, 0x49, 0xef, 0x8f, 0x49, 0xf0, 0x9b, 0x49,  // 64 (0x40)
	0xf2, 0xa6, 0x49, 0xf3, 0xb1, 0x49, 0xf5, 0xbd, 0x49, 0xf6, 0xc8, 0x49,  // 68 (0x44)
	0xf8, 0xd3, 0x49, 0xf9, 0xdf, 0x49, 0xfb, 0xea, 0x49, 0xfd, 0xf6, 0x49,  // 72 (0x48)
	0xf4, 0xec, 0x48, 0xec, 0xe2, 0x48, 0xe4, 0xd9, 0x48, 0xdc, 0xcf, 0x48,  // 76 (0x4c)
	0xd4, 0xc5, 0x48, 0xcc, 0xbc, 0x48, 0xc4, 0xb2, 0x48, 0xbc, 0xa8, 0x48,  // 80 (0x50)
	0xb4, 0x9f, 0x48, 0xac, 0x95, 0x48, 0xa4, 0x8b, 0x48, 0x9c, 0x82, 0x48,  // 84 (0x54)
	0x94, 0x78, 0x48, 0x8c, 0x6e, 0x48, 0x84, 0x65, 0x48, 0x7f, 0x68, 0x49,  // 88 (0x58)
	0x7b, 0x6b, 0x4a, 0x77, 0x6e, 0x4a, 0x72, 0x70, 0x4b, 0x6e, 0x73, 0x4b,  // 92 (0x5c)
	0x6a, 0x76, 0x4c, 0x66, 0x79, 0x4c, 0x61, 0x7b, 0x4d, 0x5d, 0x7e, 0x4d,  // 96 (0x60)
	0x59, 0x81, 0x4e, 0x55, 0x84, 0x4e, 0x50, 0x86, 0x4f, 0x4c, 0x89, 0x4f,  // 100 (0x64)
	0x48, 0x8c, 0x50, 0x44, 0x8f, 0x51, 0x46, 0x93, 0x52, 0x48, 0x97, 0x52,  // 104 (0x68)
	0x49, 0x9b, 0x52, 0x4b, 0x9f, 0x52, 0x4c, 0xa3, 0x52, 0x4e, 0xa7, 0x52,  // 108 (0x6c)
	0x4f, 0xab, 0x52, 0x51, 0xaf, 0x52, 0x52, 0xb3, 0x52, 0x54, 0xb7, 0x52,  // 112 (0x70)
	0x55, 0xbb, 0x52, 0x57, 0xbf, 0x52, 0x58, 0xc3, 0x52, 0x5a, 0xc7, 0x52,  // 116 (0x74)
	0x5c, 0xcb, 0x53, 0x5a, 0xca, 0x5e, 0x59, 0xc9, 0x68, 0x57, 0xc9, 0x73,  // 120 (0x78)
	0x56, 0xc8, 0x7d, 0x55, 0xc8, 0x87, 0x53, 0xc7, 0x92, 0x52, 0xc6, 0x9c,  // 124 (0x7c)
	0x50, 0xc6, 0xa7, 0x4f, 0xc5, 0xb1, 0x4e, 0xc5, 0xbb, 0x4c, 0xc4, 0xc6,  // 128 (0x80)
	0x4b, 0xc3, 0xd0, 0x49, 0xc3, 0xdb, 0x48, 0xc2, 0xe5, 0x47, 0xc2, 0xf0,  // 132 (0x84)
	0x46, 0xb9, 0xee, 0x46, 0xb1, 0xed, 0x46, 0xa9, 0xec, 0x46, 0xa0, 0xeb,  // 136 (0x88)
	0x46, 0x98, 0xea, 0x45, 0x90, 0xe9, 0x45, 0x87, 0xe8, 0x45, 0x7f, 0xe7,  // 140 (0x8c)
	0x45, 0x77, 0xe6, 0x45, 0x6e, 0xe5, 0x44, 0x66, 0xe4, 0x44, 0x5e, 0xe3,  // 144 (0x90)
	0x44, 0x55, 0xe2, 0x44, 0x4d, 0xe1, 0x44, 0x45, 0xe0, 0x48, 0x44, 0xdd,  // 148 (0x94)
	0x4b, 0x44, 0xdb, 0x4f, 0x44, 0xd9, 0x52, 0x44, 0xd6, 0x55, 0x44, 0xd4,  // 152 (0x98)
	0x59, 0x44, 0xd2, 0x5c, 0x44, 0xcf, 0x60, 0x44, 0xcd, 0x63, 0x44, 0xcb,  // 156 (0x9c)
	0x66, 0x44, 0xc8, 0x6a, 0x44, 0xc6, 0x6d, 0x44, 0xc4, 0x71, 0x44, 0xc1,  // 160 (0xa0)
	0x74, 0x44, 0xbf, 0x78, 0x44, 0xbd, 0x81, 0x45, 0xbb, 0x89, 0x45, 0xb9,  // 164 (0xa4)
	0x91, 0x46, 0xb8, 0x9a, 0x46, 0xb6, 0xa2, 0x46, 0xb5, 0xaa, 0x47, 0xb3,  // 168 (0xa8)
	0xb3, 0x47, 0xb2, 0xbb, 0x48, 0xb0, 0xc3, 0x48, 0xaf, 0xcc, 0x48, 0xad,  // 172 (0xac)
	0xd4, 0x49, 0xac, 0xdc, 0x49, 0xaa, 0xe5, 0x4a, 0xa9, 0xed, 0x4a, 0xa7,  // 176 (0xb0)
	0xf6, 0x4b, 0xa6, 0xf2, 0x49, 0x9f, 0xee, 0x47, 0x98, 0xea, 0x45, 0x91,  // 180 (0xb4)
	0xe6, 0x43, 0x8b, 0xe2, 0x41, 0x84, 0xde, 0x3f, 0x7d, 0xda, 0x3d, 0x76,  // 184 (0xb8)
	0xd6, 0x3b, 0x70, 0xd2, 0x39, 0x69, 0xce, 0x37, 0x62, 0xca, 0x35, 0x5b,  // 188 (0xbc)
	0xc6, 0x33, 0x55, 0xc2, 0x31, 0x4e, 0xbe, 0x2f, 0x47, 0xba, 0x2d, 0x41,  // 192 (0xc0)
	0xbd, 0x2f, 0x42, 0xc0, 0x31, 0x43, 0xc3, 0x33, 0x43, 0xc6, 0x35, 0x44,  // 196 (0xc4)
	0xc8, 0x37, 0x44, 0xcb, 0x39, 0x45, 0xce, 0x3b, 0x45, 0xd1, 0x3d, 0x46,  // 200 (0xc8)
	0xd4, 0x3f, 0x46, 0xd6, 0x41, 0x47, 0xd9, 0x43, 0x47, 0xdc, 0x45, 0x48,  // 204 (0xcc)
	0xdf, 0x47, 0x48, 0xe2, 0x49, 0x49, 0xe5, 0x4b, 0x4a, 0xe7, 0x50, 0x49,  // 208 (0xd0)
	0xe9, 0x54, 0x49, 0xea, 0x58, 0x49, 0xec, 0x5d, 0x48, 0xee, 0x61, 0x48,  // 212 (0xd4)
	0xef, 0x65, 0x48, 0xf1, 0x6a, 0x48, 0xf3, 0x6e, 0x47, 0xf4, 0x72, 0x47,  // 216 (0xd8)
	0xf6, 0x77, 0x47, 0xf8, 0x7b, 0x47, 0xf9, 0x7f, 0x46, 0xfb, 0x84, 0x46,  // 220 (0xdc)
	0xfd, 0x88, 0x46, 0xff, 0x8d, 0x46, 0xfe, 0x94, 0x47, 0xfe, 0x9b, 0x47,  // 224 (0xe0)
	0xfe, 0xa2, 0x47, 0xfe, 0xa9, 0x47, 0xfe, 0xb0, 0x47, 0xfd, 0xb7, 0x47,  // 228 (0xe4)
	0xfd, 0xbe, 0x47, 0xfd, 0xc4, 0x47, 0xfd, 0xcb, 0x47, 0xfd, 0xd2, 0x47,  // 232 (0xe8)
	0xfc, 0xd9, 0x47, 0xfc, 0xe0, 0x47, 0xfc, 0xe7, 0x47, 0xfc, 0xee, 0x47,  // 236 (0xec)
	0xfc, 0xf5, 0x48, 0xfd, 0xf6, 0x55, 0xfd, 0xf7, 0x61, 0xfd, 0xf7, 0x6d,  // 240 (0xf0)
	0xfd, 0xf8, 0x79, 0xfd, 0xf8, 0x85, 0xfd, 0xf9, 0x91, 0xfd, 0xfa, 0x9d,  // 244 (0xf4)
	0xfe, 0xfa, 0xaa, 0xfe, 0xfb, 0xb6, 0xfe, 0xfb, 0xc2, 0xfe, 0xfc, 0xce,  // 248 (0xf8)
	0xfe, 0xfd, 0xda, 0xfe, 0xfd, 0xe6, 0xfe, 0xfe, 0xf2, 0xff, 0xff, 0xff   // 252 (0xfc)
};

static byte vividPalette[768] = {
	0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x20, 0x20, 0x20, 0x30, 0x30, 0x30,  // 0 (0x00)
	0x40, 0x40, 0x40, 0x50, 0x50, 0x50, 0x60, 0x60, 0x60, 0x70, 0x70, 0x70,  // 4 (0x04)
	0x80, 0x80, 0x80, 0x90, 0x90, 0x90, 0xa0, 0xa0, 0xa0, 0xb0, 0xb0, 0xb0,  // 8 (0x08)
	0xc0, 0xc0, 0xc0, 0xd0, 0xd0, 0xd0, 0xe0, 0xe0, 0xe0, 0xf0, 0xf0, 0xf0,  // 12 (0x0c)
	0xe0, 0xe0, 0xee, 0xd0, 0xd0, 0xec, 0xc0, 0xc0, 0xea, 0xb0, 0xb0, 0xe8,  // 16 (0x10)
	0xa0, 0xa0, 0xe6, 0x90, 0x90, 0xe4, 0x80, 0x80, 0xe2, 0x70, 0x70, 0xe1,  // 20 (0x14)
	0x60, 0x60, 0xdf, 0x50, 0x50, 0xdd, 0x40, 0x40, 0xdb, 0x30, 0x30, 0xd9,  // 24 (0x18)
	0x20, 0x20, 0xd7, 0x10, 0x10, 0xd5, 0x00, 0x00, 0xd4, 0x10, 0x00, 0xce,  // 28 (0x1c)
	0x20, 0x01, 0xc9, 0x30, 0x01, 0xc4, 0x40, 0x02, 0xbe, 0x50, 0x02, 0xb9,  // 32 (0x20)
	0x60, 0x03, 0xb4, 0x70, 0x03, 0xae, 0x81, 0x04, 0xa9, 0x91, 0x04, 0xa4,  // 36 (0x24)
	0xa1, 0x05, 0x9e, 0xb1, 0x05, 0x99, 0xc1, 0x06, 0x94, 0xd1, 0x06, 0x8e,  // 40 (0x28)
	0xe1, 0x07, 0x89, 0xf2, 0x08, 0x84, 0xf0, 0x07, 0x7b, 0xef, 0x07, 0x73,  // 44 (0x2c)
	0xed, 0x07, 0x6a, 0xec, 0x07, 0x62, 0xea, 0x07, 0x5a, 0xe9, 0x07, 0x51,  // 48 (0x30)
	0xe7, 0x07, 0x49, 0xe6, 0x07, 0x40, 0xe4, 0x07, 0x38, 0xe3, 0x07, 0x30,  // 52 (0x34)
	0xe1, 0x07, 0x27, 0xe0, 0x07, 0x1f, 0xde, 0x07, 0x16, 0xdd, 0x07, 0x0e,  // 56 (0x38)
	0xdc, 0x07, 0x06, 0xdf, 0x17, 0x05, 0xe1, 0x27, 0x05, 0xe3, 0x36, 0x05,  // 60 (0x3c)
	0xe5, 0x46, 0x05, 0xe7, 0x56, 0x05, 0xe9, 0x65, 0x05, 0xeb, 0x75, 0x05,  // 64 (0x40)
	0xed, 0x85, 0x05, 0xef, 0x94, 0x05, 0xf1, 0xa4, 0x05, 0xf3, 0xb4, 0x05,  // 68 (0x44)
	0xf5, 0xc3, 0x05, 0xf7, 0xd3, 0x05, 0xf9, 0xe3, 0x05, 0xfc, 0xf3, 0x05,  // 72 (0x48)
	0xf0, 0xe5, 0x04, 0xe5, 0xd8, 0x04, 0xda, 0xcb, 0x04, 0xcf, 0xbd, 0x04,  // 76 (0x4c)
	0xc4, 0xb0, 0x04, 0xb9, 0xa3, 0x04, 0xae, 0x95, 0x04, 0xa3, 0x88, 0x04,  // 80 (0x50)
	0x98, 0x7b, 0x04, 0x8d, 0x6d, 0x04, 0x82, 0x60, 0x04, 0x77, 0x53, 0x04,  // 84 (0x54)
	0x6c, 0x45, 0x04, 0x61, 0x38, 0x04, 0x56, 0x2b, 0x04, 0x50, 0x2f, 0x05,  // 88 (0x58)
	0x4a, 0x33, 0x06, 0x44, 0x36, 0x07, 0x3f, 0x3a, 0x07, 0x39, 0x3e, 0x08,  // 92 (0x5c)
	0x33, 0x41, 0x09, 0x2d, 0x45, 0x0a, 0x28, 0x49, 0x0a, 0x22, 0x4c, 0x0b,  // 96 (0x60)
	0x1c, 0x50, 0x0c, 0x16, 0x54, 0x0d, 0x11, 0x57, 0x0d, 0x0b, 0x5b, 0x0e,  // 100 (0x64)
	0x05, 0x5f, 0x0f, 0x00, 0x63, 0x10, 0x02, 0x69, 0x11, 0x04, 0x6f, 0x11,  // 104 (0x68)
	0x06, 0x74, 0x11, 0x08, 0x7a, 0x11, 0x0a, 0x7f, 0x11, 0x0c, 0x85, 0x11,  // 108 (0x6c)
	0x0e, 0x8a, 0x11, 0x10, 0x90, 0x12, 0x12, 0x95, 0x12, 0x14, 0x9b, 0x12,  // 112 (0x70)
	0x16, 0xa0, 0x12, 0x18, 0xa6, 0x12, 0x1a, 0xab, 0x12, 0x1c, 0xb1, 0x12,  // 116 (0x74)
	0x1f, 0xb7, 0x13, 0x1d, 0xb6, 0x22, 0x1b, 0xb5, 0x30, 0x19, 0xb4, 0x3e,  // 120 (0x78)
	0x17, 0xb3, 0x4d, 0x15, 0xb3, 0x5b, 0x13, 0xb2, 0x69, 0x11, 0xb1, 0x77,  // 124 (0x7c)
	0x0f, 0xb0, 0x86, 0x0d, 0xaf, 0x94, 0x0b, 0xaf, 0xa2, 0x09, 0xae, 0xb0,  // 128 (0x80)
	0x07, 0xad, 0xbf, 0x05, 0xac, 0xcd, 0x03, 0xab, 0xdb, 0x02, 0xab, 0xea,  // 132 (0x84)
	0x01, 0x9f, 0xe8, 0x01, 0x94, 0xe7, 0x01, 0x88, 0xe5, 0x01, 0x7d, 0xe4,  // 136 (0x88)
	0x01, 0x72, 0xe2, 0x01, 0x66, 0xe1, 0x01, 0x5b, 0xdf, 0x00, 0x4f, 0xde,  // 140 (0x8c)
	0x00, 0x44, 0xdc, 0x00, 0x39, 0xdb, 0x00, 0x2d, 0xd9, 0x00, 0x22, 0xd8,  // 144 (0x90)
	0x00, 0x16, 0xd6, 0x00, 0x0b, 0xd5, 0x00, 0x00, 0xd4, 0x04, 0x00, 0xd0,  // 148 (0x94)
	0x09, 0x00, 0xcd, 0x0d, 0x00, 0xca, 0x12, 0x00, 0xc7, 0x16, 0x00, 0xc4,  // 152 (0x98)
	0x1b, 0x00, 0xc1, 0x20, 0x00, 0xbe, 0x24, 0x00, 0xba, 0x29, 0x00, 0xb7,  // 156 (0x9c)
	0x2d, 0x00, 0xb4, 0x32, 0x00, 0xb1, 0x37, 0x00, 0xae, 0x3b, 0x00, 0xab,  // 160 (0xa0)
	0x40, 0x00, 0xa8, 0x45, 0x00, 0xa5, 0x51, 0x00, 0xa2, 0x5c, 0x01, 0xa0,  // 164 (0xa4)
	0x68, 0x01, 0x9e, 0x73, 0x02, 0x9c, 0x7f, 0x02, 0x9a, 0x8a, 0x03, 0x97,  // 168 (0xa8)
	0x96, 0x03, 0x95, 0xa1, 0x04, 0x93, 0xad, 0x04, 0x91, 0xb8, 0x05, 0x8f,  // 172 (0xac)
	0xc4, 0x05, 0x8c, 0xcf, 0x06, 0x8a, 0xdb, 0x06, 0x88, 0xe6, 0x07, 0x86,  // 176 (0xb0)
	0xf2, 0x08, 0x84, 0xed, 0x07, 0x7c, 0xe8, 0x06, 0x75, 0xe3, 0x06, 0x6e,  // 180 (0xb4)
	0xde, 0x05, 0x67, 0xda, 0x05, 0x60, 0xd5, 0x04, 0x58, 0xd0, 0x04, 0x51,  // 184 (0xb8)
	0xcb, 0x03, 0x4a, 0xc6, 0x03, 0x43, 0xc2, 0x02, 0x3c, 0xbd, 0x02, 0x34,  // 188 (0xbc)
	0xb8, 0x01, 0x2d, 0xb3, 0x01, 0x26, 0xae, 0x00, 0x1f, 0xaa, 0x00, 0x18,  // 192 (0xc0)
	0xae, 0x00, 0x16, 0xb1, 0x00, 0x15, 0xb4, 0x01, 0x14, 0xb8, 0x01, 0x13,  // 196 (0xc4)
	0xbb, 0x02, 0x12, 0xbe, 0x02, 0x10, 0xc1, 0x03, 0x0f, 0xc5, 0x03, 0x0e,  // 200 (0xc8)
	0xc8, 0x04, 0x0d, 0xcb, 0x04, 0x0c, 0xce, 0x05, 0x0a, 0xd2, 0x05, 0x09,  // 204 (0xcc)
	0xd5, 0x06, 0x08, 0xd8, 0x06, 0x07, 0xdc, 0x07, 0x06, 0xdf, 0x0e, 0x05,  // 208 (0xd0)
	0xe1, 0x14, 0x05, 0xe3, 0x1a, 0x05, 0xe6, 0x20, 0x04, 0xe8, 0x26, 0x04,  // 212 (0xd4)
	0xea, 0x2c, 0x04, 0xec, 0x32, 0x03, 0xef, 0x38, 0x03, 0xf1, 0x3e, 0x03,  // 216 (0xd8)
	0xf3, 0x44, 0x02, 0xf5, 0x4a, 0x02, 0xf8, 0x50, 0x02, 0xfa, 0x56, 0x01,  // 220 (0xdc)
	0xfc, 0x5c, 0x01, 0xff, 0x63, 0x01, 0xfe, 0x6d, 0x02, 0xfe, 0x76, 0x02,  // 224 (0xe0)
	0xfe, 0x80, 0x02, 0xfd, 0x89, 0x02, 0xfd, 0x93, 0x02, 0xfd, 0x9c, 0x02,  // 228 (0xe4)
	0xfd, 0xa6, 0x02, 0xfc, 0xaf, 0x03, 0xfc, 0xb9, 0x03, 0xfc, 0xc2, 0x03,  // 232 (0xe8)
	0xfc, 0xcc, 0x03, 0xfb, 0xd5, 0x03, 0xfb, 0xdf, 0x03, 0xfb, 0xe8, 0x03,  // 236 (0xec)
	0xfb, 0xf2, 0x04, 0xfc, 0xf3, 0x15, 0xfc, 0xf4, 0x26, 0xfc, 0xf5, 0x36,  // 240 (0xf0)
	0xfc, 0xf6, 0x47, 0xfc, 0xf6, 0x58, 0xfd, 0xf7, 0x68, 0xfd, 0xf8, 0x79,  // 244 (0xf4)
	0xfd, 0xf9, 0x8a, 0xfd, 0xfa, 0x9a, 0xfd, 0xfa, 0xab, 0xfe, 0xfb, 0xbc,  // 248 (0xf8)
	0xfe, 0xfc, 0xcc, 0xfe, 0xfd, 0xdd, 0xfe, 0xfe, 0xee, 0xff, 0xff, 0xff   // 252 (0xfc)
};

static byte ntscPalette[768] = {
	0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x20, 0x20, 0x20, 0x30, 0x30, 0x30,  // 0 (0x00)
	0x40, 0x40, 0x40, 0x50, 0x50, 0x50, 0x60, 0x60, 0x60, 0x70, 0x70, 0x70,  // 4 (0x04)
	0x80, 0x80, 0x80, 0x90, 0x90, 0x90, 0xa0, 0xa0, 0xa0, 0xb0, 0xb0, 0xb0,  // 8 (0x08)
	0xc0, 0xc0, 0xc0, 0xd0, 0xd0, 0xd0, 0xe0, 0xe0, 0xe0, 0xf0, 0xf0, 0xf0,  // 12 (0x0c)
	0xe0, 0xe3, 0xef, 0xd1, 0xd7, 0xee, 0xc2, 0xca, 0xed, 0xb3, 0xbe, 0xec,  // 16 (0x10)
	0xa4, 0xb2, 0xec, 0x95, 0xa5, 0xeb, 0x86, 0x99, 0xea, 0x77, 0x8c, 0xe9,  // 20 (0x14)
	0x68, 0x80, 0xe9, 0x59, 0x74, 0xe8, 0x4a, 0x67, 0xe7, 0x3b, 0x5b, 0xe6,  // 24 (0x18)
	0x2c, 0x4f, 0xe6, 0x1d, 0x42, 0xe5, 0x0f, 0x36, 0xe4, 0x00, 0x29, 0xe3,  // 28 (0x1c)
	0x00, 0x27, 0xd9, 0x00, 0x25, 0xcc, 0x00, 0x23, 0xbf, 0x00, 0x20, 0xb2,  // 32 (0x20)
	0x00, 0x1e, 0xa5, 0x00, 0x1c, 0x98, 0x00, 0x19, 0x8b, 0x00, 0x17, 0x7e,  // 36 (0x24)
	0x00, 0x14, 0x71, 0x00, 0x12, 0x64, 0x00, 0x10, 0x57, 0x00, 0x0d, 0x4a,  // 40 (0x28)
	0x00, 0x0b, 0x3d, 0x00, 0x08, 0x30, 0x00, 0x06, 0x23, 0x00, 0x04, 0x16,  // 44 (0x2c)
	0x06, 0x00, 0x0c, 0x0e, 0x01, 0x1a, 0x15, 0x02, 0x27, 0x1c, 0x03, 0x35,  // 48 (0x30)
	0x24, 0x04, 0x42, 0x2b, 0x05, 0x50, 0x32, 0x06, 0x5d, 0x3a, 0x07, 0x6b,  // 52 (0x34)
	0x41, 0x08, 0x78, 0x49, 0x09, 0x86, 0x50, 0x0a, 0x93, 0x57, 0x0b, 0xa1,  // 56 (0x38)
	0x5f, 0x0c, 0xae, 0x66, 0x0d, 0xbc, 0x6d, 0x0e, 0xc9, 0x75, 0x0f, 0xd7,  // 60 (0x3c)
	0x78, 0x19, 0xd7, 0x7d, 0x23, 0xd8, 0x83, 0x2d, 0xda, 0x88, 0x36, 0xdc,  // 64 (0x40)
	0x8d, 0x40, 0xdd, 0x93, 0x4a, 0xdf, 0x98, 0x53, 0xe1, 0x9e, 0x5d, 0xe3,  // 68 (0x44)
	0xa3, 0x67, 0xe4, 0xa8, 0x70, 0xe6, 0xae, 0x7a, 0xe8, 0xb3, 0x84, 0xe9,  // 72 (0x48)
	0xb9, 0x8d, 0xeb, 0xbe, 0x97, 0xed, 0xc3, 0xa1, 0xef, 0xc9, 0xaa, 0xf0,  // 76 (0x4c)
	0xe7, 0xad, 0xc3, 0xe3, 0xa1, 0xb8, 0xdf, 0x95, 0xad, 0xdb, 0x8a, 0xa2,  // 80 (0x50)
	0xd7, 0x7e, 0x97, 0xd4, 0x73, 0x8c, 0xd0, 0x67, 0x81, 0xcc, 0x5c, 0x76,  // 84 (0x54)
	0xc8, 0x50, 0x6b, 0xc4, 0x45, 0x60, 0xc1, 0x39, 0x55, 0xbd, 0x2e, 0x4a,  // 88 (0x58)
	0xb9, 0x22, 0x3f, 0xb5, 0x17, 0x35, 0xb1, 0x0b, 0x2a, 0xa2, 0x16, 0x2f,  // 92 (0x5c)
	0xa2, 0x16, 0x2f, 0x96, 0x14, 0x2b, 0x8b, 0x13, 0x28, 0x7f, 0x11, 0x25,  // 96 (0x60)
	0x73, 0x0f, 0x21, 0x68, 0x0e, 0x1e, 0x5c, 0x0c, 0x1a, 0x51, 0x0b, 0x17,  // 100 (0x64)
	0x45, 0x09, 0x14, 0x39, 0x07, 0x10, 0x2e, 0x06, 0x0d, 0x22, 0x04, 0x0a,  // 104 (0x68)
	0x17, 0x03, 0x06, 0x17, 0x00, 0x04, 0x0b, 0x00, 0x02, 0x00, 0x00, 0x00,  // 108 (0x6c)
	0x00, 0x00, 0x00, 0x0e, 0x05, 0x01, 0x1d, 0x09, 0x03, 0x2b, 0x0e, 0x05,  // 112 (0x70)
	0x3a, 0x13, 0x07, 0x48, 0x18, 0x09, 0x57, 0x1d, 0x0b, 0x65, 0x22, 0x0c,  // 116 (0x74)
	0x74, 0x27, 0x0e, 0x82, 0x2c, 0x10, 0x91, 0x31, 0x12, 0x9f, 0x36, 0x14,  // 120 (0x78)
	0xae, 0x3b, 0x16, 0xbc, 0x40, 0x17, 0xcb, 0x45, 0x19, 0xd9, 0x4a, 0x1b,  // 124 (0x7c)
	0xd9, 0x4e, 0x20, 0xd9, 0x54, 0x29, 0xd9, 0x5b, 0x31, 0xd9, 0x61, 0x3a,  // 128 (0x80)
	0xd9, 0x68, 0x42, 0xd9, 0x6e, 0x4b, 0xd9, 0x75, 0x53, 0xd9, 0x7b, 0x5c,  // 132 (0x84)
	0xd9, 0x82, 0x65, 0xd9, 0x88, 0x6d, 0xd9, 0x8f, 0x76, 0xd9, 0x95, 0x7e,  // 136 (0x88)
	0xd9, 0x9c, 0x87, 0xd9, 0xa2, 0x8f, 0xd9, 0xa9, 0x98, 0xd9, 0xaf, 0xa1,  // 140 (0x8c)
	0xf5, 0xee, 0x90, 0xf2, 0xeb, 0x87, 0xef, 0xe8, 0x7f, 0xeb, 0xe5, 0x76,  // 144 (0x90)
	0xe8, 0xe2, 0x6d, 0xe5, 0xdf, 0x64, 0xe2, 0xdc, 0x5b, 0xdf, 0xd9, 0x52,  // 148 (0x94)
	0xdb, 0xd6, 0x4a, 0xd8, 0xd3, 0x41, 0xd5, 0xd0, 0x38, 0xd2, 0xcd, 0x2f,  // 152 (0x98)
	0xcf, 0xca, 0x26, 0xcb, 0xc7, 0x1d, 0xc8, 0xc4, 0x15, 0xc5, 0xc0, 0x0c,  // 156 (0x9c)
	0xbf, 0xbb, 0x0b, 0xb3, 0xaf, 0x0b, 0xa7, 0xa3, 0x0a, 0x9b, 0x97, 0x09,  // 160 (0xa0)
	0x8f, 0x8b, 0x08, 0x83, 0x80, 0x08, 0x77, 0x74, 0x07, 0x6a, 0x68, 0x06,  // 164 (0xa4)
	0x5e, 0x5c, 0x05, 0x52, 0x50, 0x05, 0x46, 0x44, 0x04, 0x3a, 0x39, 0x03,  // 168 (0xa8)
	0x2e, 0x2d, 0x02, 0x22, 0x21, 0x02, 0x16, 0x15, 0x01, 0x0a, 0x09, 0x00,  // 172 (0xac)
	0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x28, 0x00,  // 176 (0xb0)
	0x00, 0x35, 0x00, 0x00, 0x42, 0x00, 0x00, 0x50, 0x00, 0x00, 0x5d, 0x00,  // 180 (0xb4)
	0x00, 0x6b, 0x00, 0x00, 0x78, 0x00, 0x00, 0x85, 0x01, 0x00, 0x93, 0x01,  // 184 (0xb8)
	0x00, 0xa0, 0x01, 0x00, 0xae, 0x01, 0x00, 0xbb, 0x01, 0x01, 0xc8, 0x01,  // 188 (0xbc)
	0x01, 0xda, 0x01, 0x0c, 0xdc, 0x0e, 0x18, 0xdd, 0x1a, 0x24, 0xdf, 0x26,  // 192 (0xc0)
	0x30, 0xe0, 0x32, 0x3b, 0xe2, 0x3f, 0x47, 0xe4, 0x4b, 0x53, 0xe5, 0x57,  // 196 (0xc4)
	0x5f, 0xe7, 0x63, 0x6b, 0xe8, 0x70, 0x76, 0xea, 0x7c, 0x82, 0xec, 0x88,  // 200 (0xc8)
	0x8e, 0xed, 0x94, 0x9a, 0xef, 0xa1, 0xa5, 0xf0, 0xad, 0xb1, 0xf2, 0xb9,  // 204 (0xcc)
	0xb3, 0xd1, 0xd5, 0xa9, 0xd0, 0xd5, 0x9f, 0xcf, 0xd5, 0x95, 0xce, 0xd5,  // 208 (0xd0)
	0x8b, 0xcd, 0xd5, 0x81, 0xcc, 0xd5, 0x77, 0xcb, 0xd5, 0x6d, 0xca, 0xd5,  // 212 (0xd4)
	0x63, 0xc9, 0xd5, 0x59, 0xc8, 0xd5, 0x4f, 0xc7, 0xd5, 0x45, 0xc6, 0xd5,  // 216 (0xd8)
	0x3b, 0xc5, 0xd5, 0x30, 0xc4, 0xd5, 0x26, 0xc3, 0xd5, 0x1c, 0xc2, 0xd5,  // 220 (0xdc)
	0x30, 0x4b, 0xc2, 0x29, 0x52, 0xa3, 0x21, 0x58, 0x84, 0x19, 0x5b, 0x65,  // 224 (0xe0)
	0x1b, 0x6c, 0x55, 0x21, 0x83, 0x49, 0x27, 0x9a, 0x3c, 0x2d, 0xb1, 0x2d,  // 228 (0xe4)
	0x46, 0xb7, 0x2f, 0x60, 0xbd, 0x31, 0x79, 0xc3, 0x33, 0x93, 0xc8, 0x35,  // 232 (0xe8)
	0xac, 0xce, 0x37, 0xc6, 0xd4, 0x38, 0xe3, 0xdd, 0x3c, 0xdc, 0xc9, 0x3b,  // 236 (0xec)
	0xd5, 0xb5, 0x3a, 0xcf, 0xa1, 0x39, 0xc8, 0x8d, 0x37, 0xc1, 0x7a, 0x36,  // 240 (0xf0)
	0xba, 0x66, 0x35, 0xb4, 0x53, 0x33, 0xb0, 0x4f, 0x37, 0xac, 0x4b, 0x3a,  // 244 (0xf4)
	0xa9, 0x47, 0x3e, 0xa5, 0x43, 0x41, 0xa1, 0x3d, 0x42, 0x9a, 0x30, 0x44,  // 248 (0xf8)
	0x7b, 0x28, 0x52, 0x5d, 0x21, 0x5f, 0x59, 0x2b, 0x85, 0xff, 0xff, 0xff   // 252 (0xfc)
};

static byte metallicPalette[768] = {
	0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x22, 0x22, 0x22, 0x33, 0x33, 0x33,  // 0 (0x00)
	0x44, 0x44, 0x44, 0x55, 0x55, 0x55, 0x66, 0x66, 0x66, 0x77, 0x77, 0x77,  // 4 (0x04)
	0x88, 0x88, 0x88, 0x99, 0x99, 0x99, 0xaa, 0xaa, 0xaa, 0xbb, 0xbb, 0xbb,  // 8 (0x08)
	0xcc, 0xcc, 0xcc, 0xdd, 0xdd, 0xdd, 0xee, 0xee, 0xee, 0xff, 0xff, 0xff,  // 12 (0x0c)
	0xf1, 0xf1, 0xf1, 0xe2, 0xe2, 0xe2, 0xd3, 0xd3, 0xd3, 0xc4, 0xc4, 0xc4,  // 16 (0x10)
	0xb5, 0xb5, 0xb5, 0xa6, 0xa6, 0xa6, 0x97, 0x97, 0x97, 0x88, 0x88, 0x88,  // 20 (0x14)
	0x79, 0x79, 0x79, 0x6a, 0x6a, 0x6a, 0x5c, 0x5c, 0x5c, 0x4d, 0x4d, 0x4d,  // 24 (0x18)
	0x3e, 0x3e, 0x3e, 0x2f, 0x2f, 0x2f, 0x20, 0x20, 0x20, 0x11, 0x11, 0x11,  // 28 (0x1c)
	0x00, 0x0f, 0x55, 0x0e, 0x1e, 0x61, 0x1d, 0x2c, 0x6c, 0x2c, 0x3a, 0x77,  // 32 (0x20)
	0x3b, 0x48, 0x83, 0x4a, 0x56, 0x8e, 0x58, 0x65, 0x99, 0x67, 0x73, 0xa5,  // 36 (0x24)
	0x76, 0x81, 0xb0, 0x85, 0x8f, 0xbb, 0x94, 0x9d, 0xc7, 0xa3, 0xac, 0xd2,  // 40 (0x28)
	0xb1, 0xba, 0xdd, 0xc0, 0xc8, 0xe9, 0xcf, 0xd6, 0xf4, 0xde, 0xe5, 0xff,  // 44 (0x2c)
	0xd0, 0xd7, 0xf5, 0xc2, 0xca, 0xea, 0xb4, 0xbd, 0xe0, 0xa6, 0xaf, 0xd5,  // 48 (0x30)
	0x98, 0xa2, 0xca, 0x8a, 0x95, 0xc0, 0x7d, 0x87, 0xb5, 0x6f, 0x7a, 0xaa,  // 52 (0x34)
	0x61, 0x6d, 0xa0, 0x53, 0x5f, 0x95, 0x45, 0x52, 0x8a, 0x37, 0x45, 0x80,  // 56 (0x38)
	0x29, 0x37, 0x75, 0x1b, 0x2a, 0x6a, 0x0d, 0x1d, 0x60, 0x00, 0x0f, 0x55,  // 60 (0x3c)
	0x03, 0x30, 0x03, 0x0f, 0x3e, 0x10, 0x1c, 0x4c, 0x1c, 0x28, 0x5a, 0x28,  // 64 (0x40)
	0x34, 0x67, 0x35, 0x41, 0x75, 0x41, 0x4d, 0x83, 0x4d, 0x5a, 0x91, 0x5a,  // 68 (0x44)
	0x66, 0x9f, 0x66, 0x72, 0xad, 0x72, 0x7f, 0xba, 0x7f, 0x8b, 0xc8, 0x8b,  // 72 (0x48)
	0x97, 0xd6, 0x97, 0xa4, 0xe4, 0xa4, 0xb0, 0xf2, 0xb0, 0xbc, 0xff, 0xbc,  // 76 (0x4c)
	0xb1, 0xf2, 0xb1, 0xa5, 0xe6, 0xa5, 0x9a, 0xd9, 0x9a, 0x8e, 0xcc, 0x8e,  // 80 (0x50)
	0x82, 0xbf, 0x83, 0x77, 0xb2, 0x77, 0x6b, 0xa5, 0x6b, 0x60, 0x98, 0x60,  // 84 (0x54)
	0x54, 0x8b, 0x54, 0x49, 0x7e, 0x49, 0x3d, 0x71, 0x3d, 0x31, 0x64, 0x31,  // 88 (0x58)
	0x26, 0x57, 0x26, 0x1a, 0x4a, 0x1a, 0x0f, 0x3d, 0x0f, 0x03, 0x30, 0x03,  // 92 (0x5c)
	0x76, 0x55, 0x12, 0x80, 0x5d, 0x1c, 0x8a, 0x66, 0x26, 0x93, 0x6e, 0x2f,  // 96 (0x60)
	0x9d, 0x77, 0x39, 0xa7, 0x7f, 0x43, 0xb1, 0x88, 0x4c, 0xbb, 0x91, 0x56,  // 100 (0x64)
	0xc5, 0x99, 0x5f, 0xce, 0xa2, 0x69, 0xd8, 0xaa, 0x73, 0xe2, 0xb3, 0x7c,  // 104 (0x68)
	0xec, 0xbb, 0x86, 0xf6, 0xc4, 0x8f, 0xff, 0xd8, 0xb1, 0xff, 0xe1, 0xc2,  // 108 (0x6c)
	0xff, 0xd5, 0xab, 0xff, 0xcc, 0x99, 0xf6, 0xc4, 0x8f, 0xec, 0xbb, 0x86,  // 112 (0x70)
	0xe2, 0xb3, 0x7c, 0xd8, 0xaa, 0x73, 0xce, 0xa2, 0x69, 0xc5, 0x99, 0x5f,  // 116 (0x74)
	0xbb, 0x91, 0x56, 0xb1, 0x88, 0x4c, 0xa7, 0x7f, 0x43, 0x9d, 0x77, 0x39,  // 120 (0x78)
	0x93, 0x6e, 0x2f, 0x8a, 0x66, 0x26, 0x80, 0x5d, 0x1c, 0x76, 0x55, 0x12,  // 124 (0x7c)
	0x44, 0x26, 0x19, 0x4f, 0x31, 0x23, 0x5b, 0x3c, 0x2d, 0x66, 0x48, 0x37,  // 128 (0x80)
	0x71, 0x53, 0x41, 0x7d, 0x5e, 0x4b, 0x88, 0x69, 0x55, 0x93, 0x74, 0x5f,  // 132 (0x84)
	0x9f, 0x80, 0x69, 0xaa, 0x8b, 0x73, 0xb5, 0x96, 0x7d, 0xc1, 0xa1, 0x87,  // 136 (0x88)
	0xcc, 0xac, 0x91, 0xd7, 0xb8, 0x9b, 0xe3, 0xc3, 0xa5, 0xee, 0xd1, 0xb4,  // 140 (0x8c)
	0xe3, 0xc6, 0xaa, 0xd9, 0xbb, 0xa1, 0xce, 0xb1, 0x97, 0xc3, 0xa6, 0x8d,  // 144 (0x90)
	0xb9, 0x9b, 0x83, 0xae, 0x91, 0x7a, 0xa4, 0x86, 0x70, 0x99, 0x7b, 0x66,  // 148 (0x94)
	0x8e, 0x71, 0x5d, 0x84, 0x66, 0x53, 0x79, 0x5b, 0x49, 0x6f, 0x51, 0x40,  // 152 (0x98)
	0x64, 0x46, 0x36, 0x59, 0x3b, 0x2c, 0x4f, 0x31, 0x22, 0x44, 0x26, 0x19,  // 156 (0x9c)
	0x51, 0x20, 0x1f, 0x5d, 0x2c, 0x2c, 0x68, 0x38, 0x38, 0x74, 0x44, 0x45,  // 160 (0xa0)
	0x7f, 0x50, 0x51, 0x8b, 0x5c, 0x5d, 0x97, 0x67, 0x6a, 0xa2, 0x73, 0x76,  // 164 (0xa4)
	0xae, 0x7f, 0x83, 0xba, 0x8b, 0x8f, 0xc5, 0x97, 0x9b, 0xd1, 0xa3, 0xa8,  // 168 (0xa8)
	0xdd, 0xaf, 0xb4, 0xe8, 0xbb, 0xc1, 0xf4, 0xc6, 0xcd, 0xff, 0xd2, 0xda,  // 172 (0xac)
	0xf5, 0xc7, 0xce, 0xea, 0xbc, 0xc2, 0xdf, 0xb1, 0xb7, 0xd4, 0xa6, 0xab,  // 176 (0xb0)
	0xc9, 0x9b, 0x9f, 0xbe, 0x90, 0x94, 0xb3, 0x84, 0x88, 0xa8, 0x79, 0x7c,  // 180 (0xb4)
	0x9d, 0x6e, 0x71, 0x92, 0x63, 0x65, 0x87, 0x58, 0x59, 0x7d, 0x4d, 0x4e,  // 184 (0xb8)
	0x72, 0x42, 0x42, 0x67, 0x37, 0x37, 0x5c, 0x2b, 0x2b, 0x51, 0x20, 0x1f,  // 188 (0xbc)
	0x44, 0x2a, 0x5c, 0x4e, 0x36, 0x67, 0x59, 0x41, 0x71, 0x64, 0x4c, 0x7b,  // 192 (0xc0)
	0x6f, 0x58, 0x85, 0x79, 0x63, 0x8f, 0x84, 0x6e, 0x99, 0x8f, 0x7a, 0xa3,  // 196 (0xc4)
	0x99, 0x85, 0xad, 0xa4, 0x90, 0xb7, 0xaf, 0x9c, 0xc1, 0xb9, 0xa7, 0xcb,  // 200 (0xc8)
	0xc4, 0xb2, 0xd6, 0xcf, 0xbe, 0xe0, 0xda, 0xc9, 0xea, 0xe4, 0xd4, 0xf4,  // 204 (0xcc)
	0xda, 0xca, 0xea, 0xd0, 0xbf, 0xe1, 0xc6, 0xb4, 0xd7, 0xbc, 0xaa, 0xce,  // 208 (0xd0)
	0xb2, 0x9f, 0xc4, 0xa8, 0x94, 0xbb, 0x9e, 0x8a, 0xb2, 0x94, 0x7f, 0xa8,  // 212 (0xd4)
	0x8a, 0x75, 0x9f, 0x80, 0x6a, 0x95, 0x76, 0x5f, 0x8c, 0x6c, 0x55, 0x82,  // 216 (0xd8)
	0x62, 0x4a, 0x79, 0x58, 0x3f, 0x6f, 0x4e, 0x35, 0x66, 0x44, 0x2a, 0x5c,  // 220 (0xdc)
	0x63, 0x73, 0xbc, 0x58, 0x6d, 0xa5, 0x4e, 0x67, 0x8e, 0x43, 0x61, 0x76,  // 224 (0xe0)
	0x38, 0x5a, 0x5f, 0x4a, 0x7d, 0x5f, 0x58, 0x94, 0x63, 0x66, 0xab, 0x66,  // 228 (0xe4)
	0x76, 0xb1, 0x69, 0x85, 0xb7, 0x6d, 0x96, 0xbd, 0x70, 0xa6, 0xc3, 0x74,  // 232 (0xe8)
	0xb6, 0xc8, 0x77, 0xc7, 0xce, 0x7b, 0xdd, 0xda, 0x83, 0xd0, 0xbe, 0x7b,  // 236 (0xec)
	0xc9, 0xb0, 0x77, 0xc2, 0xa2, 0x73, 0xbb, 0x94, 0x6f, 0xb4, 0x86, 0x6b,  // 240 (0xf0)
	0xae, 0x79, 0x67, 0xaa, 0x73, 0x65, 0xa6, 0x6f, 0x66, 0xa3, 0x6d, 0x68,  // 244 (0xf4)
	0x9f, 0x6c, 0x6a, 0x9b, 0x66, 0x69, 0x94, 0x58, 0x63, 0x75, 0x47, 0x5e,  // 248 (0xf8)
	0x58, 0x37, 0x59, 0x5f, 0x42, 0x6c, 0x66, 0x4c, 0x80, 0xff, 0xff, 0xff   // 252 (0xfc)
};

static byte winPalette[768] = {
	0x00, 0x00, 0x00, 0xbf, 0x00, 0x00, 0x00, 0xbf, 0x00, 0xbf, 0xbf, 0x00,  // 0 (0x00)
	0x00, 0x00, 0xbf, 0xbf, 0x00, 0xbf, 0x00, 0xbf, 0xbf, 0xc0, 0xc0, 0xc0,  // 4 (0x04)
	0xc0, 0xdc, 0xc0, 0xa4, 0xc8, 0xf0, 0xf0, 0xf0, 0xf0, 0xff, 0xff, 0x99,  // 8 (0x08)
	0x99, 0xd4, 0x99, 0x99, 0xd4, 0xff, 0xff, 0xcc, 0xff, 0xff, 0x99, 0x99,  // 12 (0x0c)
	0x22, 0x22, 0x30, 0x00, 0x00, 0x11, 0x00, 0x00, 0x22, 0x00, 0x00, 0x44,  // 16 (0x10)
	0x00, 0x00, 0x55, 0x00, 0x00, 0x77, 0x00, 0x00, 0x88, 0x00, 0x00, 0xaa,  // 20 (0x14)
	0x00, 0x00, 0xdd, 0x00, 0x00, 0xee, 0x00, 0x11, 0x00, 0x00, 0x22, 0x00,  // 24 (0x18)
	0x00, 0x44, 0x00, 0x00, 0x55, 0x00, 0x00, 0x77, 0x00, 0x00, 0x88, 0x00,  // 28 (0x1c)
	0x00, 0xaa, 0x00, 0x00, 0xdd, 0x00, 0x00, 0xee, 0x00, 0x11, 0x00, 0x00,  // 32 (0x20)
	0x22, 0x00, 0x00, 0x44, 0x00, 0x00, 0x55, 0x00, 0x00, 0x77, 0x00, 0x00,  // 36 (0x24)
	0x90, 0x00, 0x00, 0xaa, 0x00, 0x00, 0xdd, 0x00, 0x00, 0xee, 0x00, 0x00,  // 40 (0x28)
	0x00, 0x00, 0x33, 0x00, 0x00, 0x66, 0x00, 0x00, 0x99, 0x00, 0x00, 0xcc,  // 44 (0x2c)
	0x00, 0x33, 0x00, 0x00, 0x33, 0x33, 0x00, 0x33, 0x66, 0x00, 0x33, 0xa1,  // 48 (0x30)
	0x00, 0x33, 0xcc, 0x00, 0x33, 0xff, 0x00, 0x66, 0x00, 0x00, 0x66, 0x33,  // 52 (0x34)
	0x00, 0x66, 0x66, 0x00, 0x66, 0x99, 0x00, 0x66, 0xcc, 0x00, 0x66, 0xff,  // 56 (0x38)
	0x00, 0x99, 0x00, 0x00, 0x99, 0x33, 0x00, 0x99, 0x66, 0x00, 0x99, 0x99,  // 60 (0x3c)
	0x00, 0x99, 0xcc, 0x00, 0x99, 0xff, 0x00, 0xcc, 0x00, 0x00, 0xcc, 0x33,  // 64 (0x40)
	0x00, 0xcc, 0x66, 0x00, 0xcc, 0x99, 0x00, 0xcc, 0xcc, 0x00, 0xcc, 0xff,  // 68 (0x44)
	0x00, 0xff, 0x33, 0x00, 0xff, 0x66, 0x00, 0xff, 0x99, 0x00, 0xff, 0xcc,  // 72 (0x48)
	0x33, 0x00, 0x00, 0x33, 0x00, 0x33, 0x33, 0x00, 0x66, 0x33, 0x00, 0x99,  // 76 (0x4c)
	0x33, 0x00, 0xcc, 0x33, 0x00, 0xff, 0x33, 0x33, 0x00, 0x33, 0x33, 0x3b,  // 80 (0x50)
	0x33, 0x33, 0x66, 0x33, 0x33, 0x99, 0x33, 0x33, 0xcc, 0x33, 0x33, 0xff,  // 84 (0x54)
	0x33, 0x66, 0x00, 0x33, 0x6e, 0x33, 0x33, 0x66, 0x66, 0x33, 0x66, 0x99,  // 88 (0x58)
	0x33, 0x66, 0xcc, 0x33, 0x66, 0xff, 0x33, 0x99, 0x00, 0x33, 0x99, 0x33,  // 92 (0x5c)
	0x33, 0x99, 0x66, 0x33, 0x99, 0x99, 0x33, 0x99, 0xcc, 0x33, 0x99, 0xff,  // 96 (0x60)
	0x33, 0xcc, 0x00, 0x33, 0xcc, 0x33, 0x33, 0xcc, 0x66, 0x33, 0xcc, 0x99,  // 100 (0x64)
	0x33, 0xcc, 0xcc, 0x33, 0xcc, 0xff, 0x33, 0xff, 0x00, 0x33, 0xff, 0x33,  // 104 (0x68)
	0x33, 0xff, 0x66, 0x33, 0xff, 0x99, 0x33, 0xff, 0xcc, 0x33, 0xff, 0xff,  // 108 (0x6c)
	0x66, 0x00, 0x00, 0x66, 0x00, 0x33, 0x66, 0x00, 0x66, 0x66, 0x00, 0x99,  // 112 (0x70)
	0x66, 0x00, 0xcc, 0x66, 0x00, 0xff, 0x66, 0x33, 0x00, 0x66, 0x33, 0x33,  // 116 (0x74)
	0x66, 0x33, 0x66, 0x66, 0x33, 0x99, 0x66, 0x33, 0xcc, 0x66, 0x33, 0xff,  // 120 (0x78)
	0x66, 0x66, 0x00, 0x66, 0x66, 0x33, 0x66, 0x66, 0x66, 0x66, 0x66, 0x99,  // 124 (0x7c)
	0x66, 0x66, 0xcc, 0x66, 0x66, 0xff, 0x66, 0x99, 0x00, 0x66, 0x99, 0x33,  // 128 (0x80)
	0x66, 0x99, 0x66, 0x66, 0x99, 0x99, 0x66, 0x99, 0xcc, 0x66, 0x99, 0xff,  // 132 (0x84)
	0x66, 0xcc, 0x00, 0x66, 0xcc, 0x33, 0x66, 0xcc, 0x66, 0x66, 0xcc, 0x99,  // 136 (0x88)
	0x66, 0xcc, 0xcc, 0x66, 0xcc, 0xff, 0x66, 0xff, 0x00, 0x66, 0xff, 0x33,  // 140 (0x8c)
	0x66, 0xff, 0x66, 0x66, 0xff, 0x99, 0x66, 0xff, 0xcc, 0x66, 0xff, 0xff,  // 144 (0x90)
	0x99, 0x00, 0x00, 0x99, 0x00, 0x33, 0x99, 0x00, 0x66, 0x99, 0x00, 0x99,  // 148 (0x94)
	0x99, 0x00, 0xcc, 0x99, 0x00, 0xff, 0x99, 0x33, 0x00, 0x99, 0x33, 0x33,  // 152 (0x98)
	0x99, 0x33, 0x66, 0x99, 0x33, 0x99, 0x99, 0x33, 0xcc, 0x99, 0x33, 0xff,  // 156 (0x9c)
	0xa1, 0x66, 0x00, 0x99, 0x66, 0x33, 0x99, 0x66, 0x66, 0x99, 0x66, 0x99,  // 160 (0xa0)
	0x99, 0x66, 0xcc, 0x99, 0x66, 0xff, 0x99, 0x99, 0x00, 0x99, 0x99, 0x33,  // 164 (0xa4)
	0x99, 0x99, 0x66, 0x99, 0x99, 0x99, 0x99, 0x99, 0xcc, 0x99, 0x99, 0xff,  // 168 (0xa8)
	0x99, 0xcc, 0x00, 0x99, 0xcc, 0x33, 0x99, 0xcc, 0x66, 0x99, 0xcc, 0x99,  // 172 (0xac)
	0x99, 0xcc, 0xcc, 0x99, 0xcc, 0xff, 0x99, 0xff, 0x00, 0x99, 0xff, 0x33,  // 176 (0xb0)
	0x99, 0xff, 0x66, 0x99, 0xff, 0x99, 0x99, 0xff, 0xcc, 0x99, 0xff, 0xff,  // 180 (0xb4)
	0xcc, 0x00, 0x00, 0xcc, 0x00, 0x33, 0xcc, 0x00, 0x66, 0xcc, 0x00, 0x99,  // 184 (0xb8)
	0xcc, 0x00, 0xcc, 0xd4, 0x08, 0xff, 0xcc, 0x33, 0x00, 0xcc, 0x33, 0x33,  // 188 (0xbc)
	0xcc, 0x33, 0x66, 0xcc, 0x33, 0x99, 0xcc, 0x33, 0xcc, 0xcc, 0x33, 0xff,  // 192 (0xc0)
	0xcc, 0x66, 0x00, 0xcc, 0x66, 0x33, 0xcc, 0x66, 0x66, 0xcc, 0x66, 0x99,  // 196 (0xc4)
	0xcc, 0x66, 0xcc, 0xcc, 0x66, 0xff, 0xcc, 0x99, 0x00, 0xcc, 0x99, 0x33,  // 200 (0xc8)
	0xcc, 0x99, 0x66, 0xcc, 0x99, 0x99, 0xcc, 0x99, 0xcc, 0xcc, 0x99, 0xff,  // 204 (0xcc)
	0xcc, 0xcc, 0x00, 0xcc, 0xcc, 0x33, 0xcc, 0xcc, 0x66, 0xcc, 0xcc, 0x99,  // 208 (0xd0)
	0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xff, 0xcc, 0xff, 0x00, 0xcc, 0xff, 0x33,  // 212 (0xd4)
	0xcc, 0xff, 0x66, 0xcc, 0xff, 0x99, 0xcc, 0xff, 0xcc, 0xcc, 0xff, 0xff,  // 216 (0xd8)
	0xff, 0x00, 0x33, 0xff, 0x00, 0x66, 0xff, 0x00, 0x99, 0xff, 0x00, 0xcc,  // 220 (0xdc)
	0xff, 0x33, 0x00, 0xff, 0x33, 0x33, 0xff, 0x33, 0x66, 0xff, 0x33, 0x99,  // 224 (0xe0)
	0xff, 0x33, 0xcc, 0xff, 0x33, 0xff, 0xff, 0x66, 0x00, 0xff, 0x66, 0x33,  // 228 (0xe4)
	0xff, 0x66, 0x66, 0xff, 0x66, 0x99, 0xff, 0x66, 0xcc, 0xff, 0x66, 0xff,  // 232 (0xe8)
	0xff, 0x99, 0x00, 0xdd, 0xdd, 0xdd, 0xff, 0x99, 0xcc, 0xff, 0xcc, 0x66,  // 236 (0xec)
	0x88, 0x00, 0x00, 0xcc, 0x00, 0xff, 0x00, 0x33, 0x99, 0x33, 0x66, 0x33,  // 240 (0xf0)
	0x99, 0x66, 0x00, 0x33, 0x33, 0x33, 0xff, 0xfb, 0xf0, 0xa0, 0xa0, 0xa4,  // 244 (0xf4)
	0x80, 0x80, 0x80, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0x00,  // 248 (0xf8)
	0x00, 0x00, 0xff, 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff   // 252 (0xfc)
};


static byte director3Patterns[][8] = {
	{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },
	{ 0xFF, 0xFF, 0x77, 0xFF, 0xFF, 0xFF, 0x77, 0xFF },
	{ 0x77, 0xFF, 0xDD, 0xFF, 0x77, 0xFF, 0xDD, 0xFF },
	{ 0xFF, 0xDD, 0xFF, 0x55, 0xFF, 0xDD, 0xFF, 0x55 },
	{ 0xFF, 0xD5, 0xFF, 0x55, 0xFF, 0x5D, 0xFF, 0x55 },
	{ 0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA },
	{ 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA },
	{ 0xAA, 0x44, 0xAA, 0x11, 0xAA, 0x44, 0xAA, 0x11 },
	{ 0xAA, 0x44, 0xAA, 0x00, 0xAA, 0x44, 0xAA, 0x00 },
	{ 0xAA, 0x00, 0xAA, 0x00, 0xAA, 0x00, 0xAA, 0x00 },
	{ 0x00, 0x22, 0x00, 0x88, 0x00, 0x22, 0x00, 0x88 },
	{ 0x88, 0x00, 0x00, 0x00, 0x88, 0x00, 0x00, 0x00 },
	{ 0x80, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00 },
	{ 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80 },
	{ 0x21, 0x42, 0x84, 0x09, 0x12, 0x24, 0x48, 0x90 },
	{ 0x11, 0x22, 0x44, 0x88, 0x11, 0x22, 0x44, 0x88 },
	{ 0xEE, 0xDD, 0xBB, 0x77, 0xEE, 0xDD, 0xBB, 0x77 },
	{ 0xF6, 0xED, 0xDB, 0xB7, 0x6F, 0xDE, 0xBD, 0x7B },
	{ 0xFE, 0xFD, 0xFB, 0xF7, 0xEF, 0xDF, 0xBF, 0x7F },
	{ 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF },
	{ 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFF },
	{ 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0xFF },
	{ 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0xFF },
	{ 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00 },
	{ 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00 },
	{ 0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00 },
	{ 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80 },
	{ 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82 },
	{ 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88 },
	{ 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94 },
	{ 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA },
	{ 0xAD, 0xAD, 0xAD, 0xAD, 0xAD, 0xAD, 0xAD, 0xAD },
	{ 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB },
	{ 0xB7, 0xB7, 0xB7, 0xB7, 0xB7, 0xB7, 0xB7, 0xB7 },
	{ 0xBF, 0xBF, 0xBF, 0xBF, 0xBF, 0xBF, 0xBF, 0xBF },
	{ 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x00 },
	{ 0x7F, 0x7F, 0x7F, 0x00, 0x7F, 0x7F, 0x7F, 0x00 },
	{ 0x77, 0x77, 0x77, 0x00, 0x77, 0x77, 0x77, 0x00 },
	{ 0x88, 0x88, 0x88, 0xFF, 0x88, 0x88, 0x88, 0xFF },
	{ 0x80, 0x80, 0x80, 0xFF, 0x80, 0x80, 0x80, 0xFF },
	{ 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xFF },
	{ 0x01, 0x82, 0x44, 0x28, 0x10, 0x28, 0x44, 0x82 },
	{ 0x11, 0x82, 0x45, 0xAB, 0xD7, 0xAB, 0x45, 0x82 },
	{ 0xF7, 0x7F, 0xBE, 0x5D, 0x2A, 0x5D, 0xBE, 0x7F },
	{ 0xFE, 0x7D, 0xBB, 0xD7, 0xEF, 0xD7, 0xBB, 0x7D },
	{ 0xFE, 0x7F, 0xBF, 0xDF, 0xEF, 0xDF, 0xBF, 0x7F },
	{ 0xEE, 0x77, 0xBB, 0xDD, 0xEE, 0xDD, 0xBB, 0x77 },
	{ 0x11, 0x88, 0x44, 0x22, 0x11, 0x22, 0x44, 0x88 },
	{ 0x01, 0x80, 0x40, 0x20, 0x10, 0x20, 0x40, 0x80 },
	{ 0x22, 0x00, 0x01, 0x22, 0x54, 0x88, 0x01, 0x00 },
	{ 0xBF, 0xAF, 0xAB, 0xAA, 0xEA, 0xFA, 0xFE, 0xFF },
	{ 0xFF, 0xFF, 0xBE, 0x9C, 0xAA, 0xB6, 0xBE, 0xFF }
};

static byte director3QuickDrawPatterns[][8] = {
	{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },
	{ 0xDD, 0xFF, 0x77, 0xFF, 0xDD, 0xFF, 0x77, 0xFF },
	{ 0xDD, 0x77, 0xDD, 0x77, 0xDD, 0x77, 0xDD, 0x77 },
	{ 0xEE, 0xDD, 0xBB, 0x77, 0xEE, 0xDD, 0xBB, 0x77 },
	{ 0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA },
	{ 0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55 },
	{ 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55 },
	{ 0x11, 0x22, 0x44, 0x88, 0x11, 0x22, 0x44, 0x88 },
	{ 0xAA, 0x00, 0xAA, 0x00, 0xAA, 0x00, 0xAA, 0x00 },
	{ 0x88, 0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 0x22 },
	{ 0x00, 0x22, 0x00, 0x88, 0x00, 0x22, 0x00, 0x88 },
	{ 0x10, 0x20, 0x40, 0x80, 0x01, 0x02, 0x04, 0x08 },
	{ 0x80, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00 },
	{ 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88 },
	{ 0x58, 0xDF, 0x00, 0xDF, 0xDF, 0x58, 0x58, 0x58 },
	{ 0xB1, 0x36, 0x06, 0x60, 0x63, 0x1B, 0x18, 0x81 },
	{ 0x08, 0xFF, 0x01, 0x01, 0x01, 0xFF, 0x08, 0x08 },
	{ 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00 },
	{ 0x80, 0x80, 0x80, 0xFF, 0x80, 0x80, 0x80, 0x80 },
	{ 0x80, 0x10, 0x02, 0x40, 0x04, 0x20, 0x09, 0x00 },
	{ 0x80, 0x01, 0x82, 0x44, 0x38, 0x10, 0x20, 0x40 },
	{ 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00 },
	{ 0x22, 0xFF, 0x22, 0x22, 0x22, 0xFF, 0x22, 0x22 },
	{ 0x00, 0x08, 0x14, 0x2A, 0x55, 0x2A, 0x14, 0x08 },
	{ 0x81, 0xAA, 0x14, 0x08, 0x08, 0xAA, 0x41, 0x80 },
	{ 0x3E, 0x1D, 0x88, 0xD1, 0xE3, 0xC5, 0x88, 0x5C },
	{ 0xAA, 0x00, 0x80, 0x00, 0x88, 0x00, 0x80, 0x00 },
	{ 0x00, 0x11, 0x82, 0x44, 0x28, 0x11, 0x00, 0x55 },
	{ 0x7C, 0x10, 0x10, 0x28, 0xC7, 0x01, 0x01, 0x82 },
	{ 0xEE, 0x31, 0xF1, 0xF1, 0xEE, 0x13, 0x1F, 0x1F },
	{ 0x00, 0x40, 0x20, 0x10, 0x00, 0x01, 0x02, 0x04 },
	{ 0x00, 0x00, 0x40, 0xA0, 0x00, 0x04, 0x0A, 0x00 },
	{ 0x20, 0x60, 0x90, 0x09, 0x06, 0x81, 0x40, 0x20 },
	{ 0x00, 0x7F, 0x43, 0x5F, 0x5F, 0x5F, 0x7F, 0x7F },
	{ 0x01, 0x02, 0x45, 0xAA, 0xFF, 0x20, 0x40, 0x80 },
	{ 0x00, 0x44, 0x0A, 0x11, 0x11, 0x11, 0x51, 0x24 },
	{ 0x0F, 0x0F, 0x0F, 0x0F, 0xF0, 0xF0, 0xF0, 0xF0 },
	{ 0xF8, 0xFC, 0xFA, 0xFC, 0xFA, 0x54, 0x2A, 0x00 },
	{ 0x42, 0xC3, 0x3C, 0x3C, 0x3C, 0x3C, 0xC3, 0x42 },
	{ 0x10, 0x38, 0x7C, 0xFE, 0x7D, 0x3A, 0x14, 0x08 },
	{ 0x01, 0x03, 0x07, 0x0F, 0x1F, 0x3F, 0x7F, 0xFF },
	{ 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC },
	{ 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00 },
	{ 0xBB, 0xDD, 0xAE, 0x77, 0xEE, 0xDD, 0xAB, 0x77 },
	{ 0x80, 0x40, 0x40, 0x20, 0x20, 0x18, 0x06, 0x01 },
	{ 0x01, 0x82, 0x44, 0x28, 0x10, 0x28, 0x44, 0x82 },
	{ 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xFF, 0xFF },
	{ 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xFF, 0xFF, 0xFF },
	{ 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x00, 0x00, 0x00 },
	{ 0xC3, 0x87, 0x0F, 0x1E, 0x3C, 0x78, 0xF0, 0xE1 },
	{ 0xF0, 0xF0, 0x0F, 0x0F, 0x0F, 0xF0, 0xF0, 0xF0 },
	{ 0xFF, 0xFF, 0xE7, 0xC3, 0x81, 0x18, 0x3C, 0x7E },
	{ 0x1F, 0x8F, 0xC7, 0xE3, 0xC7, 0x8F, 0x1F, 0x3E },
	{ 0xFF, 0x2A, 0xFF, 0xC8, 0xFF, 0x65, 0xFF, 0x9D }
};

static const byte mouseUp[] = {
	3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 0, 0, 3, 3, 0, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 0, 3, 3, 0, 0, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 1, 1, 1, 1, 1, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 0, 0, 0, 0, 0, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 0, 1, 1, 1, 0, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 0, 1, 1, 1, 0, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 0, 0, 0, 0, 0, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 1, 1, 1, 1, 1, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 1, 1, 1, 1, 1, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 1, 1, 1, 1, 1, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 0, 1, 1, 1, 1, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 1, 1, 1, 1, 1, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 3, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3
};

static const byte mouseDown[] = {
	3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 0, 0, 3, 3, 0, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 0, 3, 3, 0, 0, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 1, 1, 1, 1, 1, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 0, 0, 0, 0, 0, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 0, 0, 0, 0, 0, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 0, 0, 0, 0, 0, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 0, 0, 0, 0, 0, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 1, 1, 1, 1, 1, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 1, 1, 1, 1, 1, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 1, 1, 1, 1, 1, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 0, 1, 1, 1, 1, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 0, 1, 1, 1, 1, 1, 1, 1, 0, 3, 3, 3, 3, 3, 3,
	3, 3, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3
};
