/*
  Simple DirectMedia Layer
  Copyright (C) 1997-2025 Sam Lantinga <slouken@libsdl.org>

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.
*/

#ifndef sdl2_protos_h_
#define sdl2_protos_h_ 1

#ifndef SDL2_PROTO
#define SDL2_PROTO(rc,fn,params) \
 extern SDL_DECLSPEC rc SDLCALL SDL_##fn params ;
#endif

#ifdef __cplusplus
extern "C" {
#endif

SDL2_PROTO(int,SetError,(SDL_PRINTF_FORMAT_STRING const char *a, ...))
SDL2_PROTO(void,Log,(SDL_PRINTF_FORMAT_STRING const char *a, ...))
SDL2_PROTO(void,LogVerbose,(int a, SDL_PRINTF_FORMAT_STRING const char *b, ...))
SDL2_PROTO(void,LogDebug,(int a, SDL_PRINTF_FORMAT_STRING const char *b, ...))
SDL2_PROTO(void,LogInfo,(int a, SDL_PRINTF_FORMAT_STRING const char *b, ...))
SDL2_PROTO(void,LogWarn,(int a, SDL_PRINTF_FORMAT_STRING const char *b, ...))
SDL2_PROTO(void,LogError,(int a, SDL_PRINTF_FORMAT_STRING const char *b, ...))
SDL2_PROTO(void,LogCritical,(int a, SDL_PRINTF_FORMAT_STRING const char *b, ...))
SDL2_PROTO(void,LogMessage,(int a, SDL2_LogPriority b, SDL_PRINTF_FORMAT_STRING const char *c, ...))
SDL2_PROTO(int,sscanf,(const char *a, SDL_SCANF_FORMAT_STRING const char *b, ...))
SDL2_PROTO(int,snprintf,(SDL_OUT_Z_CAP(b) char *a, size_t b, SDL_PRINTF_FORMAT_STRING const char *c, ...))

#if defined(SDL_PLATFORM_WIN32) || defined(SDL_PLATFORM_GDK)
SDL2_PROTO(SDL_Thread*,CreateThread,(SDL_ThreadFunction a, const char *b, void *c, pfnSDL_CurrentBeginThread d, pfnSDL_CurrentEndThread e))
#elif defined(SDL_PLATFORM_OS2)
SDL2_PROTO(SDL_Thread*,CreateThread,(SDL_ThreadFunction a, const char *b, void *c, pfnSDL_CurrentBeginThread d, pfnSDL_CurrentEndThread e))
#else
SDL2_PROTO(SDL_Thread*,CreateThread,(SDL_ThreadFunction a, const char *b, void *c))
#endif

SDL2_PROTO(SDL2_RWops*,RWFromFP,(void *a, SDL2_bool b))     /* FILE *a */

#if defined(SDL_PLATFORM_WIN32) || defined(SDL_PLATFORM_GDK)
SDL2_PROTO(int,RegisterApp,(const char *a, Uint32 b, void *c))
SDL2_PROTO(void,UnregisterApp,(void))
#endif

#if defined(SDL_PLATFORM_WIN32) || defined(SDL_PLATFORM_WINGDK)
SDL2_PROTO(int,Direct3D9GetAdapterIndex,(int a))
SDL2_PROTO(IDirect3DDevice9*,RenderGetD3D9Device,(SDL_Renderer *a))
#endif

#ifdef SDL_PLATFORM_IOS
SDL2_PROTO(int,iPhoneSetAnimationCallback,(SDL_Window *a, int b, void (SDLCALL *c)(void *))
SDL2_PROTO(void,iPhoneSetEventPump,(SDL2_bool a))
#endif

#ifdef SDL_PLATFORM_ANDROID
SDL2_PROTO(void*,AndroidGetJNIEnv,(void))
SDL2_PROTO(void*,AndroidGetActivity,(void))
SDL2_PROTO(const char*,AndroidGetInternalStoragePath,(void))
SDL2_PROTO(int,AndroidGetExternalStorageState,(void))
SDL2_PROTO(const char*,AndroidGetExternalStoragePath,(void))
#endif

SDL2_PROTO(int,Init,(Uint32 a))
SDL2_PROTO(int,InitSubSystem,(Uint32 a))
SDL2_PROTO(void,QuitSubSystem,(Uint32 a))
SDL2_PROTO(Uint32,WasInit,(Uint32 a))
SDL2_PROTO(void,Quit,(void))
SDL2_PROTO(SDL_AssertState,ReportAssertion,(SDL_AssertData *a, const char *b, const char *c, int d))
SDL2_PROTO(void,SetAssertionHandler,(SDL_AssertionHandler a, void *b))
SDL2_PROTO(const SDL_AssertData*,GetAssertionReport,(void))
SDL2_PROTO(void,ResetAssertionReport,(void))
SDL2_PROTO(SDL2_bool,AtomicTryLock,(SDL_SpinLock *a))
SDL2_PROTO(void,AtomicLock,(SDL_SpinLock *a))
SDL2_PROTO(void,AtomicUnlock,(SDL_SpinLock *a))
SDL2_PROTO(SDL2_bool,AtomicCAS,(SDL_atomic_t *a, int b, int c))
SDL2_PROTO(int,AtomicSet,(SDL_atomic_t *a, int b))
SDL2_PROTO(int,AtomicGet,(SDL_atomic_t *a))
SDL2_PROTO(int,AtomicAdd,(SDL_atomic_t *a, int b))
SDL2_PROTO(SDL2_bool,AtomicCASPtr,(void **a, void *b, void *c))
SDL2_PROTO(void*,AtomicSetPtr,(void **a, void *b))
SDL2_PROTO(void*,AtomicGetPtr,(void **a))
SDL2_PROTO(int,GetNumAudioDrivers,(void))
SDL2_PROTO(const char*,GetAudioDriver,(int a))
SDL2_PROTO(int,AudioInit,(const char *a))
SDL2_PROTO(void,AudioQuit,(void))
SDL2_PROTO(const char*,GetCurrentAudioDriver,(void))
SDL2_PROTO(int,OpenAudio,(SDL2_AudioSpec *a, SDL2_AudioSpec *b))
SDL2_PROTO(int,GetNumAudioDevices,(int a))
SDL2_PROTO(const char*,SDL_GetAudioDeviceName,(int a, int b))
SDL2_PROTO(SDL_AudioDeviceID,OpenAudioDevice,(const char *a, int b, const SDL2_AudioSpec *c, SDL2_AudioSpec *d, int e))
SDL2_PROTO(SDL2_AudioStatus,GetAudioStatus,(void))
SDL2_PROTO(SDL2_AudioStatus,GetAudioDeviceStatus,(SDL_AudioDeviceID a))
SDL2_PROTO(void,PauseAudio,(int a))
SDL2_PROTO(void,PauseAudioDevice,(SDL_AudioDeviceID a, int b))
SDL2_PROTO(SDL2_AudioSpec*,LoadWAV_RW,(SDL2_RWops *a, int b, SDL2_AudioSpec *c, Uint8 **d, Uint32 *e))
SDL2_PROTO(void,FreeWAV,(Uint8 *a))
SDL2_PROTO(int,BuildAudioCVT,(SDL_AudioCVT *a, SDL2_AudioFormat b, Uint8 c, int d, SDL2_AudioFormat e, Uint8 f, int g))
SDL2_PROTO(int,ConvertAudio,(SDL_AudioCVT *a))
SDL2_PROTO(void,MixAudio,(Uint8 *a, const Uint8 *b, Uint32 c, int d))
SDL2_PROTO(void,MixAudioFormat,(Uint8 *a, const Uint8 *b, SDL2_AudioFormat c, Uint32 d, int e))
SDL2_PROTO(void,LockAudio,(void))
SDL2_PROTO(void,LockAudioDevice,(SDL_AudioDeviceID a))
SDL2_PROTO(void,UnlockAudio,(void))
SDL2_PROTO(void,UnlockAudioDevice,(SDL_AudioDeviceID a))
SDL2_PROTO(void,CloseAudio,(void))
SDL2_PROTO(void,CloseAudioDevice,(SDL_AudioDeviceID a))
SDL2_PROTO(int,SetClipboardText,(const char *a))
SDL2_PROTO(char*,GetClipboardText,(void))
SDL2_PROTO(SDL2_bool,HasClipboardText,(void))
SDL2_PROTO(int,GetCPUCount,(void))
SDL2_PROTO(int,GetCPUCacheLineSize,(void))
SDL2_PROTO(SDL2_bool,HasRDTSC,(void))
SDL2_PROTO(SDL2_bool,HasAltiVec,(void))
SDL2_PROTO(SDL2_bool,HasMMX,(void))
SDL2_PROTO(SDL2_bool,Has3DNow,(void))
SDL2_PROTO(SDL2_bool,HasSSE,(void))
SDL2_PROTO(SDL2_bool,HasSSE2,(void))
SDL2_PROTO(SDL2_bool,HasSSE3,(void))
SDL2_PROTO(SDL2_bool,HasSSE41,(void))
SDL2_PROTO(SDL2_bool,HasSSE42,(void))
SDL2_PROTO(int,GetSystemRAM,(void))
SDL2_PROTO(const char*,GetError,(void))
SDL2_PROTO(void,ClearError,(void))
SDL2_PROTO(int,Error,(SDL_errorcode a))
SDL2_PROTO(void,PumpEvents,(void))
SDL2_PROTO(int,PeepEvents,(SDL2_Event *a, int b, SDL_eventaction c, Uint32 d, Uint32 e))
SDL2_PROTO(SDL2_bool,HasEvent,(Uint32 a))
SDL2_PROTO(SDL2_bool,HasEvents,(Uint32 a, Uint32 b))
SDL2_PROTO(void,FlushEvent,(Uint32 a))
SDL2_PROTO(void,FlushEvents,(Uint32 a, Uint32 b))
SDL2_PROTO(int,PollEvent,(SDL2_Event *a))
SDL2_PROTO(int,WaitEvent,(SDL2_Event *a))
SDL2_PROTO(int,WaitEventTimeout,(SDL2_Event *a, int b))
SDL2_PROTO(int,PushEvent,(SDL2_Event *a))
SDL2_PROTO(void,SetEventFilter,(SDL2_EventFilter a, void *b))
SDL2_PROTO(SDL2_bool,GetEventFilter,(SDL2_EventFilter *a, void **b))
SDL2_PROTO(void,AddEventWatch,(SDL2_EventFilter a, void *b))
SDL2_PROTO(void,DelEventWatch,(SDL2_EventFilter a, void *b))
SDL2_PROTO(void,FilterEvents,(SDL2_EventFilter a, void *b))
SDL2_PROTO(Uint8,EventState,(Uint32 a, int b))
SDL2_PROTO(Uint32,RegisterEvents,(int a))
SDL2_PROTO(char*,GetBasePath,(void))
SDL2_PROTO(char*,GetPrefPath,(const char *a, const char *b))
SDL2_PROTO(int,GameControllerAddMapping,(const char *a))
SDL2_PROTO(char*,GameControllerMappingForGUID,(SDL_GUID a))
SDL2_PROTO(char*,GameControllerMapping,(SDL_GameController *a))
SDL2_PROTO(SDL2_bool,IsGameController,(int a))
SDL2_PROTO(const char*,GameControllerNameForIndex,(int a))
SDL2_PROTO(SDL_GameController*,GameControllerOpen,(int a))
SDL2_PROTO(const char*,GameControllerName,(SDL_GameController *a))
SDL2_PROTO(SDL2_bool,GameControllerGetAttached,(SDL_GameController *a))
SDL2_PROTO(SDL_Joystick*,GameControllerGetJoystick,(SDL_GameController *a))
SDL2_PROTO(int,GameControllerEventState,(int a))
SDL2_PROTO(void,GameControllerUpdate,(void))
SDL2_PROTO(SDL_GameControllerAxis,GameControllerGetAxisFromString,(const char *a))
SDL2_PROTO(const char*,GameControllerGetStringForAxis,(SDL_GameControllerAxis a))
SDL2_PROTO(SDL_GameControllerButtonBind,GameControllerGetBindForAxis,(SDL_GameController *a, SDL_GameControllerAxis b))
SDL2_PROTO(Sint16,GameControllerGetAxis,(SDL_GameController *a, SDL_GameControllerAxis b))
SDL2_PROTO(SDL_GameControllerButton,GameControllerGetButtonFromString,(const char *a))
SDL2_PROTO(const char*,GameControllerGetStringForButton,(SDL_GameControllerButton a))
SDL2_PROTO(SDL_GameControllerButtonBind,GameControllerGetBindForButton,(SDL_GameController *a, SDL_GameControllerButton b))
SDL2_PROTO(Uint8,GameControllerGetButton,(SDL_GameController *a, SDL_GameControllerButton b))
SDL2_PROTO(void,GameControllerClose,(SDL_GameController *a))
SDL2_PROTO(int,RecordGesture,(SDL_TouchID a))
SDL2_PROTO(int,SaveAllDollarTemplates,(SDL2_RWops *a))
SDL2_PROTO(int,SaveDollarTemplate,(SDL2_GestureID a, SDL2_RWops *b))
SDL2_PROTO(int,LoadDollarTemplates,(SDL_TouchID a, SDL2_RWops *b))
SDL2_PROTO(int,NumHaptics,(void))
SDL2_PROTO(const char*,HapticName,(int a))
SDL2_PROTO(SDL_Haptic*,HapticOpen,(int a))
SDL2_PROTO(int,HapticOpened,(int a))
SDL2_PROTO(int,HapticIndex,(SDL_Haptic *a))
SDL2_PROTO(int,MouseIsHaptic,(void))
SDL2_PROTO(SDL_Haptic*,HapticOpenFromMouse,(void))
SDL2_PROTO(int,JoystickIsHaptic,(SDL_Joystick *a))
SDL2_PROTO(SDL_Haptic*,HapticOpenFromJoystick,(SDL_Joystick *a))
SDL2_PROTO(void,HapticClose,(SDL_Haptic *a))
SDL2_PROTO(int,HapticNumEffects,(SDL_Haptic *a))
SDL2_PROTO(int,HapticNumEffectsPlaying,(SDL_Haptic *a))
SDL2_PROTO(unsigned int,HapticQuery,(SDL_Haptic *a))
SDL2_PROTO(int,HapticNumAxes,(SDL_Haptic *a))
SDL2_PROTO(int,HapticEffectSupported,(SDL_Haptic *a, SDL_HapticEffect *b))
SDL2_PROTO(int,HapticNewEffect,(SDL_Haptic *a, SDL_HapticEffect *b))
SDL2_PROTO(int,HapticUpdateEffect,(SDL_Haptic *a, int b, SDL_HapticEffect *c))
SDL2_PROTO(int,HapticRunEffect,(SDL_Haptic *a, int b, Uint32 c))
SDL2_PROTO(int,HapticStopEffect,(SDL_Haptic *a, int b))
SDL2_PROTO(void,HapticDestroyEffect,(SDL_Haptic *a, int b))
SDL2_PROTO(int,HapticGetEffectStatus,(SDL_Haptic *a, int b))
SDL2_PROTO(int,HapticSetGain,(SDL_Haptic *a, int b))
SDL2_PROTO(int,HapticSetAutocenter,(SDL_Haptic *a, int b))
SDL2_PROTO(int,HapticPause,(SDL_Haptic *a))
SDL2_PROTO(int,HapticUnpause,(SDL_Haptic *a))
SDL2_PROTO(int,HapticStopAll,(SDL_Haptic *a))
SDL2_PROTO(int,HapticRumbleSupported,(SDL_Haptic *a))
SDL2_PROTO(int,HapticRumbleInit,(SDL_Haptic *a))
SDL2_PROTO(int,HapticRumblePlay,(SDL_Haptic *a, float b, Uint32 c))
SDL2_PROTO(int,HapticRumbleStop,(SDL_Haptic *a))
SDL2_PROTO(SDL2_bool,SetHintWithPriority,(const char *a, const char *b, SDL_HintPriority c))
SDL2_PROTO(SDL2_bool,SetHint,(const char *a, const char *b))
SDL2_PROTO(const char*,GetHint,(const char *a))
SDL2_PROTO(void,AddHintCallback,(const char *a, SDL_HintCallback b, void *c))
SDL2_PROTO(void,DelHintCallback,(const char *a, SDL_HintCallback b, void *c))
SDL2_PROTO(void,ClearHints,(void))
SDL2_PROTO(int,NumJoysticks,(void))
SDL2_PROTO(const char*,JoystickNameForIndex,(int a))
SDL2_PROTO(SDL_Joystick*,JoystickOpen,(int a))
SDL2_PROTO(const char*,JoystickName,(SDL_Joystick *a))
SDL2_PROTO(SDL_GUID,JoystickGetDeviceGUID,(int a))
SDL2_PROTO(SDL_GUID,JoystickGetGUID,(SDL_Joystick *a))
SDL2_PROTO(void,JoystickGetGUIDString,(SDL_GUID a, char *b, int c))
SDL2_PROTO(SDL_GUID,JoystickGetGUIDFromString,(const char *a))
SDL2_PROTO(SDL2_bool,JoystickGetAttached,(SDL_Joystick *a))
SDL2_PROTO(SDL2_JoystickID,JoystickInstanceID,(SDL_Joystick *a))
SDL2_PROTO(int,JoystickNumAxes,(SDL_Joystick *a))
SDL2_PROTO(int,JoystickNumBalls,(SDL_Joystick *a))
SDL2_PROTO(int,JoystickNumHats,(SDL_Joystick *a))
SDL2_PROTO(int,JoystickNumButtons,(SDL_Joystick *a))
SDL2_PROTO(void,JoystickUpdate,(void))
SDL2_PROTO(int,JoystickEventState,(int a))
SDL2_PROTO(Sint16,JoystickGetAxis,(SDL_Joystick *a, int b))
SDL2_PROTO(Uint8,JoystickGetHat,(SDL_Joystick *a, int b))
SDL2_PROTO(int,JoystickGetBall,(SDL_Joystick *a, int b, int *c, int *d))
SDL2_PROTO(Uint8,JoystickGetButton,(SDL_Joystick *a, int b))
SDL2_PROTO(void,JoystickClose,(SDL_Joystick *a))
SDL2_PROTO(SDL_Window*,GetKeyboardFocus,(void))
SDL2_PROTO(const Uint8*,GetKeyboardState,(int *a))
SDL2_PROTO(SDL2_Keymod,GetModState,(void))
SDL2_PROTO(void,SetModState,(SDL2_Keymod a))
SDL2_PROTO(SDL_Keycode,GetKeyFromScancode,(SDL2_Scancode a))
SDL2_PROTO(SDL2_Scancode,GetScancodeFromKey,(SDL_Keycode a))
SDL2_PROTO(const char*,GetScancodeName,(SDL2_Scancode a))
SDL2_PROTO(SDL2_Scancode,GetScancodeFromName,(const char *a))
SDL2_PROTO(const char*,GetKeyName,(SDL_Keycode a))
SDL2_PROTO(SDL_Keycode,GetKeyFromName,(const char *a))
SDL2_PROTO(void,StartTextInput,(void))
SDL2_PROTO(SDL2_bool,IsTextInputActive,(void))
SDL2_PROTO(void,StopTextInput,(void))
SDL2_PROTO(void,SetTextInputRect,(const SDL_Rect *a))
SDL2_PROTO(SDL2_bool,HasScreenKeyboardSupport,(void))
SDL2_PROTO(SDL2_bool,IsScreenKeyboardShown,(SDL_Window *a))
SDL2_PROTO(void*,LoadObject,(const char *a))
SDL2_PROTO(void*,LoadFunction,(void *a, const char *b))
SDL2_PROTO(void,UnloadObject,(void *a))
SDL2_PROTO(void,LogSetAllPriority,(SDL2_LogPriority a))
SDL2_PROTO(void,LogSetPriority,(int a, SDL2_LogPriority b))
SDL2_PROTO(SDL2_LogPriority,LogGetPriority,(int a))
SDL2_PROTO(void,LogResetPriorities,(void))
SDL2_PROTO(void,LogMessageV,(int a, SDL2_LogPriority b, const char *c, va_list d))
SDL2_PROTO(void,LogGetOutputFunction,(SDL_LogOutputFunction *a, void **b))
SDL2_PROTO(void,LogSetOutputFunction,(SDL_LogOutputFunction a, void *b))
SDL2_PROTO(void,SetMainReady,(void))
SDL2_PROTO(int,ShowMessageBox,(const SDL_MessageBoxData *a, int *b))
SDL2_PROTO(int,ShowSimpleMessageBox,(Uint32 a, const char *b, const char *c, SDL_Window *d))
SDL2_PROTO(SDL_Window*,GetMouseFocus,(void))
SDL2_PROTO(Uint32,GetMouseState,(int *a, int *b))
SDL2_PROTO(Uint32,GetRelativeMouseState,(int *a, int *b))
SDL2_PROTO(void,WarpMouseInWindow,(SDL_Window *a, int b, int c))
SDL2_PROTO(int,SetRelativeMouseMode,(SDL2_bool a))
SDL2_PROTO(SDL2_bool,GetRelativeMouseMode,(void))
SDL2_PROTO(SDL_Cursor*,CreateCursor,(const Uint8 *a, const Uint8 *b, int c, int d, int e, int f))
SDL2_PROTO(SDL_Cursor*,CreateColorCursor,(SDL2_Surface *a, int b, int c))
SDL2_PROTO(SDL_Cursor*,CreateSystemCursor,(SDL_SystemCursor a))
SDL2_PROTO(void,SetCursor,(SDL_Cursor *a))
SDL2_PROTO(SDL_Cursor*,GetCursor,(void))
SDL2_PROTO(SDL_Cursor*,GetDefaultCursor,(void))
SDL2_PROTO(void,FreeCursor,(SDL_Cursor *a))
SDL2_PROTO(int,ShowCursor,(int a))
SDL2_PROTO(SDL_mutex*,CreateMutex,(void))
SDL2_PROTO(int,LockMutex,(SDL_mutex *a))
SDL2_PROTO(int,TryLockMutex,(SDL_mutex *a))
SDL2_PROTO(int,UnlockMutex,(SDL_mutex *a))
SDL2_PROTO(void,DestroyMutex,(SDL_mutex *a))
SDL2_PROTO(SDL_sem*,CreateSemaphore,(Uint32 a))
SDL2_PROTO(void,DestroySemaphore,(SDL_sem *a))
SDL2_PROTO(int,SemWait,(SDL_sem *a))
SDL2_PROTO(int,SemTryWait,(SDL_sem *a))
SDL2_PROTO(int,SemWaitTimeout,(SDL_sem *a, Uint32 b))
SDL2_PROTO(int,SemPost,(SDL_sem *a))
SDL2_PROTO(Uint32,SemValue,(SDL_sem *a))
SDL2_PROTO(SDL_cond*,CreateCond,(void))
SDL2_PROTO(void,DestroyCond,(SDL_cond *a))
SDL2_PROTO(int,CondSignal,(SDL_cond *a))
SDL2_PROTO(int,CondBroadcast,(SDL_cond *a))
SDL2_PROTO(int,CondWait,(SDL_cond *a, SDL_mutex *b))
SDL2_PROTO(int,CondWaitTimeout,(SDL_cond *a, SDL_mutex *b, Uint32 c))
SDL2_PROTO(const char*,GetPixelFormatName,(Uint32 a))
SDL2_PROTO(SDL2_bool,PixelFormatEnumToMasks,(Uint32 a, int *b, Uint32 *c, Uint32 *d, Uint32 *e, Uint32 *f))
SDL2_PROTO(Uint32,MasksToPixelFormatEnum,(int a, Uint32 b, Uint32 c, Uint32 d, Uint32 e))
SDL2_PROTO(SDL2_PixelFormat*,AllocFormat,(Uint32 a))
SDL2_PROTO(void,FreeFormat,(SDL2_PixelFormat *a))
SDL2_PROTO(SDL_Palette*,AllocPalette,(int a))
SDL2_PROTO(int,SetPixelFormatPalette,(SDL2_PixelFormat *a, SDL_Palette *b))
SDL2_PROTO(int,SetPaletteColors,(SDL_Palette *a, const SDL_Color *b, int c, int d))
SDL2_PROTO(void,FreePalette,(SDL_Palette *a))
SDL2_PROTO(Uint32,MapRGB,(const SDL2_PixelFormat *a, Uint8 b, Uint8 c, Uint8 d))
SDL2_PROTO(Uint32,MapRGBA,(const SDL2_PixelFormat *a, Uint8 b, Uint8 c, Uint8 d, Uint8 e))
SDL2_PROTO(void,GetRGB,(Uint32 a, const SDL2_PixelFormat *b, Uint8 *c, Uint8 *d, Uint8 *e))
SDL2_PROTO(void,GetRGBA,(Uint32 a, const SDL2_PixelFormat *b, Uint8 *c, Uint8 *d, Uint8 *e, Uint8 *f))
SDL2_PROTO(void,CalculateGammaRamp,(float a, Uint16 *b))
SDL2_PROTO(const char*,GetPlatform,(void))
SDL2_PROTO(SDL_PowerState,GetPowerInfo,(int *a, int *b))
SDL2_PROTO(SDL2_bool,HasIntersection,(const SDL_Rect *a, const SDL_Rect *b))
SDL2_PROTO(SDL2_bool,IntersectRect,(const SDL_Rect *a, const SDL_Rect *b, SDL_Rect *c))
SDL2_PROTO(void,UnionRect,(const SDL_Rect *a, const SDL_Rect *b, SDL_Rect *c))
SDL2_PROTO(SDL2_bool,EnclosePoints,(const SDL_Point *a, int b, const SDL_Rect *c, SDL_Rect *d))
SDL2_PROTO(SDL2_bool,IntersectRectAndLine,(const SDL_Rect *a, int *b, int *c, int *d, int *e))
SDL2_PROTO(int,GetNumRenderDrivers,(void))
SDL2_PROTO(int,GetRenderDriverInfo,(int a, SDL2_RendererInfo *b))
SDL2_PROTO(int,CreateWindowAndRenderer,(int a, int b, Uint32 c, SDL_Window **d, SDL_Renderer **e))
SDL2_PROTO(SDL_Renderer*,CreateRenderer,(SDL_Window *a, int b, Uint32 c))
SDL2_PROTO(SDL_Renderer*,CreateSoftwareRenderer,(SDL2_Surface *a))
SDL2_PROTO(SDL_Renderer*,GetRenderer,(SDL_Window *a))
SDL2_PROTO(int,GetRendererInfo,(SDL_Renderer *a, SDL2_RendererInfo *b))
SDL2_PROTO(int,GetRendererOutputSize,(SDL_Renderer *a, int *b, int *c))
SDL2_PROTO(SDL_Texture*,CreateTexture,(SDL_Renderer *a, Uint32 b, int c, int d, int e))
SDL2_PROTO(SDL_Texture*,CreateTextureFromSurface,(SDL_Renderer *a, SDL2_Surface *b))
SDL2_PROTO(int,QueryTexture,(SDL_Texture *a, Uint32 *b, int *c, int *d, int *e))
SDL2_PROTO(int,SetTextureColorMod,(SDL_Texture *a, Uint8 b, Uint8 c, Uint8 d))
SDL2_PROTO(int,GetTextureColorMod,(SDL_Texture *a, Uint8 *b, Uint8 *c, Uint8 *d))
SDL2_PROTO(int,SetTextureAlphaMod,(SDL_Texture *a, Uint8 b))
SDL2_PROTO(int,GetTextureAlphaMod,(SDL_Texture *a, Uint8 *b))
SDL2_PROTO(int,SetTextureBlendMode,(SDL_Texture *a, SDL_BlendMode b))
SDL2_PROTO(int,GetTextureBlendMode,(SDL_Texture *a, SDL_BlendMode *b))
SDL2_PROTO(int,UpdateTexture,(SDL_Texture *a, const SDL_Rect *b, const void *c, int d))
SDL2_PROTO(int,UpdateYUVTexture,(SDL_Texture *a, const SDL_Rect *b, const Uint8 *c, int d, const Uint8 *e, int f, const Uint8 *g, int h))
SDL2_PROTO(int,LockTexture,(SDL_Texture *a, const SDL_Rect *b, void **c, int *d))
SDL2_PROTO(void,UnlockTexture,(SDL_Texture *a))
SDL2_PROTO(SDL2_bool,RenderTargetSupported,(SDL_Renderer *a))
SDL2_PROTO(int,SetRenderTarget,(SDL_Renderer *a, SDL_Texture *b))
SDL2_PROTO(SDL_Texture*,GetRenderTarget,(SDL_Renderer *a))
SDL2_PROTO(int,RenderSetLogicalSize,(SDL_Renderer *a, int b, int c))
SDL2_PROTO(void,RenderGetLogicalSize,(SDL_Renderer *a, int *b, int *c))
SDL2_PROTO(int,RenderSetViewport,(SDL_Renderer *a, const SDL_Rect *b))
SDL2_PROTO(void,RenderGetViewport,(SDL_Renderer *a, SDL_Rect *b))
SDL2_PROTO(int,RenderSetClipRect,(SDL_Renderer *a, const SDL_Rect *b))
SDL2_PROTO(void,RenderGetClipRect,(SDL_Renderer *a, SDL_Rect *b))
SDL2_PROTO(int,RenderSetScale,(SDL_Renderer *a, float b, float c))
SDL2_PROTO(void,RenderGetScale,(SDL_Renderer *a, float *b, float *c))
SDL2_PROTO(int,SetRenderDrawColor,(SDL_Renderer *a, Uint8 b, Uint8 c, Uint8 d, Uint8 e))
SDL2_PROTO(int,GetRenderDrawColor,(SDL_Renderer *a, Uint8 *b, Uint8 *c, Uint8 *d, Uint8 *e))
SDL2_PROTO(int,SetRenderDrawBlendMode,(SDL_Renderer *a, SDL_BlendMode b))
SDL2_PROTO(int,GetRenderDrawBlendMode,(SDL_Renderer *a, SDL_BlendMode *b))
SDL2_PROTO(int,RenderClear,(SDL_Renderer *a))
SDL2_PROTO(int,RenderDrawPoint,(SDL_Renderer *a, int b, int c))
SDL2_PROTO(int,RenderDrawPoints,(SDL_Renderer *a, const SDL_Point *b, int c))
SDL2_PROTO(int,RenderDrawLine,(SDL_Renderer *a, int b, int c, int d, int e))
SDL2_PROTO(int,RenderDrawLines,(SDL_Renderer *a, const SDL_Point *b, int c))
SDL2_PROTO(int,RenderDrawRect,(SDL_Renderer *a, const SDL_Rect *b))
SDL2_PROTO(int,RenderDrawRects,(SDL_Renderer *a, const SDL_Rect *b, int c))
SDL2_PROTO(int,RenderFillRect,(SDL_Renderer *a, const SDL_Rect *b))
SDL2_PROTO(int,RenderFillRects,(SDL_Renderer *a, const SDL_Rect *b, int c))
SDL2_PROTO(int,RenderCopy,(SDL_Renderer *a, SDL_Texture *b, const SDL_Rect *c, const SDL_Rect *d))
SDL2_PROTO(int,RenderCopyEx,(SDL_Renderer *a, SDL_Texture *b, const SDL_Rect *c, const SDL_Rect *d, const double e, const SDL_Point *f, const SDL_FlipMode g))
SDL2_PROTO(int,RenderReadPixels,(SDL_Renderer *a, const SDL_Rect *b, Uint32 c, void *d, int e))
SDL2_PROTO(void,RenderPresent,(SDL_Renderer *a))
SDL2_PROTO(void,DestroyTexture,(SDL_Texture *a))
SDL2_PROTO(void,DestroyRenderer,(SDL_Renderer *a))
SDL2_PROTO(int,GL_BindTexture,(SDL_Texture *a, float *b, float *c))
SDL2_PROTO(int,GL_UnbindTexture,(SDL_Texture *a))
SDL2_PROTO(SDL2_RWops*,RWFromFile,(const char *a, const char *b))
SDL2_PROTO(SDL2_RWops*,RWFromMem,(void *a, int b))
SDL2_PROTO(SDL2_RWops*,RWFromConstMem,(const void *a, int b))
SDL2_PROTO(SDL2_RWops*,AllocRW,(void))
SDL2_PROTO(void,FreeRW,(SDL2_RWops *a))
SDL2_PROTO(Uint8,ReadU8,(SDL2_RWops *a))
SDL2_PROTO(Uint16,ReadLE16,(SDL2_RWops *a))
SDL2_PROTO(Uint16,ReadBE16,(SDL2_RWops *a))
SDL2_PROTO(Uint32,ReadLE32,(SDL2_RWops *a))
SDL2_PROTO(Uint32,ReadBE32,(SDL2_RWops *a))
SDL2_PROTO(Uint64,ReadLE64,(SDL2_RWops *a))
SDL2_PROTO(Uint64,ReadBE64,(SDL2_RWops *a))
SDL2_PROTO(size_t,WriteU8,(SDL2_RWops *a, Uint8 b))
SDL2_PROTO(size_t,WriteLE16,(SDL2_RWops *a, Uint16 b))
SDL2_PROTO(size_t,WriteBE16,(SDL2_RWops *a, Uint16 b))
SDL2_PROTO(size_t,WriteLE32,(SDL2_RWops *a, Uint32 b))
SDL2_PROTO(size_t,WriteBE32,(SDL2_RWops *a, Uint32 b))
SDL2_PROTO(size_t,WriteLE64,(SDL2_RWops *a, Uint64 b))
SDL2_PROTO(size_t,WriteBE64,(SDL2_RWops *a, Uint64 b))
SDL2_PROTO(SDL_Window*,CreateShapedWindow,(const char *a, unsigned int b, unsigned int c, unsigned int d, unsigned int e, Uint32 f))
SDL2_PROTO(SDL2_bool,IsShapedWindow,(const SDL_Window *a))
SDL2_PROTO(int,SetWindowShape,(SDL_Window *a, SDL2_Surface *b, SDL_WindowShapeMode *c))
SDL2_PROTO(int,GetShapedWindowMode,(SDL_Window *a, SDL_WindowShapeMode *b))
SDL2_PROTO(void*,malloc,(size_t a))
SDL2_PROTO(void*,calloc,(size_t a, size_t b))
SDL2_PROTO(void*,realloc,(void *a, size_t b))
SDL2_PROTO(void,free,(void *a))
SDL2_PROTO(const char*,getenv,(const char *a)) /* returns non-const in real SDL2 */
SDL2_PROTO(int,setenv,(const char *a, const char *b, int c))
SDL2_PROTO(void,qsort,(void *a, size_t b, size_t c, int (SDLCALL *d)(const void *, const void *)))
SDL2_PROTO(int,abs,(int a))
SDL2_PROTO(int,isdigit,(int a))
SDL2_PROTO(int,isspace,(int a))
SDL2_PROTO(int,toupper,(int a))
SDL2_PROTO(int,tolower,(int a))
SDL2_PROTO(void*,memset,(SDL_OUT_BYTECAP(c) void *a, int b, size_t c))
SDL2_PROTO(void*,memcpy,(SDL_OUT_BYTECAP(c) void *a, SDL_IN_BYTECAP(c) const void *b, size_t c))
SDL2_PROTO(void*,memmove,(SDL_OUT_BYTECAP(c) void *a, SDL_IN_BYTECAP(c) const void *b, size_t c))
SDL2_PROTO(int,memcmp,(const void *a, const void *b, size_t c))
SDL2_PROTO(size_t,wcslen,(const wchar_t *a))
SDL2_PROTO(size_t,wcslcpy,(SDL_OUT_Z_CAP(c) wchar_t *a, const wchar_t *b, size_t c))
SDL2_PROTO(size_t,wcslcat,(SDL_INOUT_Z_CAP(c) wchar_t *a, const wchar_t *b, size_t c))
SDL2_PROTO(size_t,strlen,(const char *a))
SDL2_PROTO(size_t,strlcpy,(SDL_OUT_Z_CAP(c) char *a, const char *b, size_t c))
SDL2_PROTO(size_t,utf8strlcpy,(SDL_OUT_Z_CAP(c) char *a, const char *b, size_t c))
SDL2_PROTO(size_t,strlcat,(SDL_INOUT_Z_CAP(c) char *a, const char *b, size_t c))
SDL2_PROTO(char*,strdup,(const char *a))
SDL2_PROTO(char*,strrev,(char *a))
SDL2_PROTO(char*,strupr,(char *a))
SDL2_PROTO(char*,strlwr,(char *a))
SDL2_PROTO(char*,strchr,(const char *a, int b))
SDL2_PROTO(char*,strrchr,(const char *a, int b))
SDL2_PROTO(char*,strstr,(const char *a, const char *b))
SDL2_PROTO(char*,itoa,(int a, char *b, int c))
SDL2_PROTO(char*,uitoa,(unsigned int a, char *b, int c))
SDL2_PROTO(char*,ltoa,(long a, char *b, int c))
SDL2_PROTO(char*,ultoa,(unsigned long a, char *b, int c))
SDL2_PROTO(char*,lltoa,(Sint64 a, char *b, int c))
SDL2_PROTO(char*,ulltoa,(Uint64 a, char *b, int c))
SDL2_PROTO(int,atoi,(const char *a))
SDL2_PROTO(double,atof,(const char *a))
SDL2_PROTO(long,strtol,(const char *a, char **b, int c))
SDL2_PROTO(unsigned long,strtoul,(const char *a, char **b, int c))
SDL2_PROTO(Sint64,strtoll,(const char *a, char **b, int c))
SDL2_PROTO(Uint64,strtoull,(const char *a, char **b, int c))
SDL2_PROTO(double,strtod,(const char *a, char **b))
SDL2_PROTO(int,strcmp,(const char *a, const char *b))
SDL2_PROTO(int,strncmp,(const char *a, const char *b, size_t c))
SDL2_PROTO(int,strcasecmp,(const char *a, const char *b))
SDL2_PROTO(int,strncasecmp,(const char *a, const char *b, size_t c))
SDL2_PROTO(int,vsnprintf,(SDL_OUT_Z_CAP(b) char *a, size_t b, const char *c, va_list d))
SDL2_PROTO(double,acos,(double a))
SDL2_PROTO(double,asin,(double a))
SDL2_PROTO(double,atan,(double a))
SDL2_PROTO(double,atan2,(double a, double b))
SDL2_PROTO(double,ceil,(double a))
SDL2_PROTO(double,copysign,(double a, double b))
SDL2_PROTO(double,cos,(double a))
SDL2_PROTO(float,cosf,(float a))
SDL2_PROTO(double,fabs,(double a))
SDL2_PROTO(double,floor,(double a))
SDL2_PROTO(double,log,(double a))
SDL2_PROTO(double,pow,(double a, double b))
SDL2_PROTO(double,scalbn,(double a, int b))
SDL2_PROTO(double,sin,(double a))
SDL2_PROTO(float,sinf,(float a))
SDL2_PROTO(double,sqrt,(double a))
SDL2_PROTO(SDL_iconv_t,iconv_open,(const char *a, const char *b))
SDL2_PROTO(int,iconv_close,(SDL_iconv_t a))
SDL2_PROTO(size_t,iconv,(SDL_iconv_t a, const char **b, size_t *c, char **d, size_t *e))
SDL2_PROTO(char*,iconv_string,(const char *a, const char *b, const char *c, size_t d))
SDL2_PROTO(SDL2_Surface*,CreateRGBSurface,(Uint32 a, int b, int c, int d, Uint32 e, Uint32 f, Uint32 g, Uint32 h))
SDL2_PROTO(SDL2_Surface*,CreateRGBSurfaceFrom,(void *a, int b, int c, int d, int e, Uint32 f, Uint32 g, Uint32 h, Uint32 i))
SDL2_PROTO(void,FreeSurface,(SDL2_Surface *a))
SDL2_PROTO(int,SetSurfacePalette,(SDL2_Surface *a, SDL_Palette *b))
SDL2_PROTO(int,LockSurface,(SDL2_Surface *a))
SDL2_PROTO(void,UnlockSurface,(SDL2_Surface *a))
SDL2_PROTO(SDL2_Surface*,LoadBMP_RW,(SDL2_RWops *a, int b))
SDL2_PROTO(int,SaveBMP_RW,(SDL2_Surface *a, SDL2_RWops *b, int c))
SDL2_PROTO(int,SetSurfaceRLE,(SDL2_Surface *a, int b))
SDL2_PROTO(int,SetColorKey,(SDL2_Surface *a, int b, Uint32 c))
SDL2_PROTO(int,GetColorKey,(SDL2_Surface *a, Uint32 *b))
SDL2_PROTO(int,SetSurfaceColorMod,(SDL2_Surface *a, Uint8 b, Uint8 c, Uint8 d))
SDL2_PROTO(int,GetSurfaceColorMod,(SDL2_Surface *a, Uint8 *b, Uint8 *c, Uint8 *d))
SDL2_PROTO(int,SetSurfaceAlphaMod,(SDL2_Surface *a, Uint8 b))
SDL2_PROTO(int,GetSurfaceAlphaMod,(SDL2_Surface *a, Uint8 *b))
SDL2_PROTO(int,SetSurfaceBlendMode,(SDL2_Surface *a, SDL_BlendMode b))
SDL2_PROTO(int,GetSurfaceBlendMode,(SDL2_Surface *a, SDL_BlendMode *b))
SDL2_PROTO(SDL2_bool,SetClipRect,(SDL2_Surface *a, const SDL_Rect *b))
SDL2_PROTO(void,GetClipRect,(SDL2_Surface *a, SDL_Rect *b))
SDL2_PROTO(SDL2_Surface*,ConvertSurface,(SDL2_Surface *a, const SDL2_PixelFormat *b, Uint32 c))
SDL2_PROTO(SDL2_Surface*,ConvertSurfaceFormat,(SDL2_Surface *a, Uint32 b, Uint32 c))
SDL2_PROTO(int,ConvertPixels,(int a, int b, Uint32 c, const void *d, int e, Uint32 f, void *g, int h))
SDL2_PROTO(int,FillRect,(SDL2_Surface *a, const SDL_Rect *b, Uint32 c))
SDL2_PROTO(int,FillRects,(SDL2_Surface *a, const SDL_Rect *b, int c, Uint32 d))
SDL2_PROTO(int,UpperBlit,(SDL2_Surface *a, const SDL_Rect *b, SDL2_Surface *c, SDL_Rect *d))
SDL2_PROTO(int,LowerBlit,(SDL2_Surface *a, SDL_Rect *b, SDL2_Surface *c, SDL_Rect *d))
SDL2_PROTO(int,SoftStretch,(SDL2_Surface *a, const SDL_Rect *b, SDL2_Surface *c, const SDL_Rect *d))
SDL2_PROTO(int,UpperBlitScaled,(SDL2_Surface *a, const SDL_Rect *b, SDL2_Surface *c, SDL_Rect *d))
SDL2_PROTO(int,LowerBlitScaled,(SDL2_Surface *a, SDL_Rect *b, SDL2_Surface *c, SDL_Rect *d))
SDL2_PROTO(SDL2_bool,GetWindowWMInfo,(SDL_Window *a, SDL_SysWMinfo *b))
SDL2_PROTO(const char*,GetThreadName,(SDL_Thread *a))
SDL2_PROTO(unsigned long,ThreadID,(void))
SDL2_PROTO(unsigned long,GetThreadID,(SDL_Thread *a))
SDL2_PROTO(int,SetThreadPriority,(SDL_ThreadPriority a))
SDL2_PROTO(void,WaitThread,(SDL_Thread *a, int *b))
SDL2_PROTO(void,DetachThread,(SDL_Thread *a))
SDL2_PROTO(SDL2_TLSID,TLSCreate,(void))
SDL2_PROTO(void*,TLSGet,(SDL2_TLSID a))
SDL2_PROTO(int,TLSSet,(SDL2_TLSID a, const void *b, void (SDLCALL *c)(void*)))
SDL2_PROTO(Uint32,GetTicks,(void))
SDL2_PROTO(Uint64,GetPerformanceCounter,(void))
SDL2_PROTO(Uint64,GetPerformanceFrequency,(void))
SDL2_PROTO(void,Delay,(Uint32 a))
SDL2_PROTO(SDL2_TimerID,AddTimer,(Uint32 a, SDL2_TimerCallback b, void *c))
SDL2_PROTO(SDL2_bool,RemoveTimer,(SDL2_TimerID a))
SDL2_PROTO(int,GetNumTouchDevices,(void))
SDL2_PROTO(SDL_TouchID,GetTouchDevice,(int a))
SDL2_PROTO(int,GetNumTouchFingers,(SDL_TouchID a))
SDL2_PROTO(SDL_Finger*,GetTouchFinger,(SDL_TouchID a, int b))
SDL2_PROTO(void,GetVersion,(SDL2_version *a))
SDL2_PROTO(const char*,GetRevision,(void))
SDL2_PROTO(int,GetRevisionNumber,(void))
SDL2_PROTO(int,GetNumVideoDrivers,(void))
SDL2_PROTO(const char*,GetVideoDriver,(int a))
SDL2_PROTO(int,VideoInit,(const char *a))
SDL2_PROTO(void,VideoQuit,(void))
SDL2_PROTO(const char*,GetCurrentVideoDriver,(void))
SDL2_PROTO(int,GetNumVideoDisplays,(void))
SDL2_PROTO(const char*,GetDisplayName,(int a))
SDL2_PROTO(int,GetDisplayBounds,(int a, SDL_Rect *b))
SDL2_PROTO(int,GetNumDisplayModes,(int a))
SDL2_PROTO(int,GetDisplayMode,(int a, int b, SDL2_DisplayMode *c))
SDL2_PROTO(int,GetDesktopDisplayMode,(int a, SDL2_DisplayMode *b))
SDL2_PROTO(int,GetCurrentDisplayMode,(int a, SDL2_DisplayMode *b))
SDL2_PROTO(SDL2_DisplayMode*,GetClosestDisplayMode,(int a, const SDL2_DisplayMode *b, SDL2_DisplayMode *c))
SDL2_PROTO(int,GetWindowDisplayIndex,(SDL_Window *a))
SDL2_PROTO(int,SetWindowDisplayMode,(SDL_Window *a, const SDL2_DisplayMode *b))
SDL2_PROTO(int,GetWindowDisplayMode,(SDL_Window *a, SDL2_DisplayMode *b))
SDL2_PROTO(Uint32,GetWindowPixelFormat,(SDL_Window *a))
SDL2_PROTO(SDL_Window*,CreateWindow,(const char *a, int b, int c, int d, int e, Uint32 f))
SDL2_PROTO(SDL_Window*,CreateWindowFrom,(const void *a))
SDL2_PROTO(Uint32,GetWindowID,(SDL_Window *a))
SDL2_PROTO(SDL_Window*,GetWindowFromID,(Uint32 a))
SDL2_PROTO(Uint32,GetWindowFlags,(SDL_Window *a))
SDL2_PROTO(void,SetWindowTitle,(SDL_Window *a, const char *b))
SDL2_PROTO(const char*,GetWindowTitle,(SDL_Window *a))
SDL2_PROTO(void,SetWindowIcon,(SDL_Window *a, SDL2_Surface *b))
SDL2_PROTO(void*,SetWindowData,(SDL_Window *a, const char *b, void *c))
SDL2_PROTO(void*,GetWindowData,(SDL_Window *a, const char *b))
SDL2_PROTO(void,SetWindowPosition,(SDL_Window *a, int b, int c))
SDL2_PROTO(void,GetWindowPosition,(SDL_Window *a, int *b, int *c))
SDL2_PROTO(void,SetWindowSize,(SDL_Window *a, int b, int c))
SDL2_PROTO(void,GetWindowSize,(SDL_Window *a, int *b, int *c))
SDL2_PROTO(void,SetWindowMinimumSize,(SDL_Window *a, int b, int c))
SDL2_PROTO(void,GetWindowMinimumSize,(SDL_Window *a, int *b, int *c))
SDL2_PROTO(void,SetWindowMaximumSize,(SDL_Window *a, int b, int c))
SDL2_PROTO(void,GetWindowMaximumSize,(SDL_Window *a, int *b, int *c))
SDL2_PROTO(void,SetWindowBordered,(SDL_Window *a, SDL2_bool b))
SDL2_PROTO(void,ShowWindow,(SDL_Window *a))
SDL2_PROTO(void,HideWindow,(SDL_Window *a))
SDL2_PROTO(void,RaiseWindow,(SDL_Window *a))
SDL2_PROTO(void,MaximizeWindow,(SDL_Window *a))
SDL2_PROTO(void,MinimizeWindow,(SDL_Window *a))
SDL2_PROTO(void,RestoreWindow,(SDL_Window *a))
SDL2_PROTO(int,SetWindowFullscreen,(SDL_Window *a, Uint32 b))
SDL2_PROTO(SDL2_Surface*,GetWindowSurface,(SDL_Window *a))
SDL2_PROTO(int,UpdateWindowSurface,(SDL_Window *a))
SDL2_PROTO(int,UpdateWindowSurfaceRects,(SDL_Window *a, const SDL_Rect *b, int c))
SDL2_PROTO(void,SetWindowGrab,(SDL_Window *a, SDL2_bool b))
SDL2_PROTO(SDL2_bool,GetWindowGrab,(SDL_Window *a))
SDL2_PROTO(int,SetWindowBrightness,(SDL_Window *a, float b))
SDL2_PROTO(float,GetWindowBrightness,(SDL_Window *a))
SDL2_PROTO(int,SetWindowGammaRamp,(SDL_Window *a, const Uint16 *b, const Uint16 *c, const Uint16 *d))
SDL2_PROTO(int,GetWindowGammaRamp,(SDL_Window *a, Uint16 *b, Uint16 *c, Uint16 *d))
SDL2_PROTO(void,DestroyWindow,(SDL_Window *a))
SDL2_PROTO(SDL2_bool,IsScreenSaverEnabled,(void))
SDL2_PROTO(void,EnableScreenSaver,(void))
SDL2_PROTO(void,DisableScreenSaver,(void))
SDL2_PROTO(int,GL_LoadLibrary,(const char *a))
SDL2_PROTO(void*,GL_GetProcAddress,(const char *a))
SDL2_PROTO(void,GL_UnloadLibrary,(void))
SDL2_PROTO(SDL2_bool,GL_ExtensionSupported,(const char *a))
SDL2_PROTO(int,GL_SetAttribute,(SDL2_GLattr a, int b))
SDL2_PROTO(int,GL_GetAttribute,(SDL2_GLattr a, int *b))
SDL2_PROTO(SDL_GLContext,GL_CreateContext,(SDL_Window *a))
SDL2_PROTO(int,GL_MakeCurrent,(SDL_Window *a, SDL_GLContext b))
SDL2_PROTO(SDL_Window*,GL_GetCurrentWindow,(void))
SDL2_PROTO(SDL_GLContext,GL_GetCurrentContext,(void))
SDL2_PROTO(void,GL_GetDrawableSize,(SDL_Window *a, int *b, int *c))
SDL2_PROTO(int,GL_SetSwapInterval,(int a))
SDL2_PROTO(int,GL_GetSwapInterval,(void))
SDL2_PROTO(void,GL_SwapWindow,(SDL_Window *a))
SDL2_PROTO(void,GL_DeleteContext,(SDL_GLContext a))
SDL2_PROTO(int,vsscanf,(const char *a, const char *b, va_list c))
SDL2_PROTO(int,GameControllerAddMappingsFromRW,(SDL2_RWops *a, int b))
SDL2_PROTO(void,GL_ResetAttributes,(void))
SDL2_PROTO(SDL2_bool,HasAVX,(void))
SDL2_PROTO(SDL_AssertionHandler,GetDefaultAssertionHandler,(void))
SDL2_PROTO(SDL_AssertionHandler,GetAssertionHandler,(void **a))
#if defined(SDL_PLATFORM_WIN32) || defined(SDL_PLATFORM_WINGDK)
SDL2_PROTO(SDL2_bool,DXGIGetOutputInfo,(int a,int *b, int *c))
#endif
SDL2_PROTO(SDL2_bool,RenderIsClipEnabled,(SDL_Renderer *a))
SDL2_PROTO(int,WarpMouseGlobal,(int a, int b))
SDL2_PROTO(float,sqrtf,(float a))
SDL2_PROTO(double,tan,(double a))
SDL2_PROTO(float,tanf,(float a))
SDL2_PROTO(int,CaptureMouse,(SDL2_bool a))
SDL2_PROTO(int,SetWindowHitTest,(SDL_Window *a, SDL_HitTest b, void *c))
SDL2_PROTO(Uint32,GetGlobalMouseState,(int *a, int *b))
SDL2_PROTO(SDL2_bool,HasAVX2,(void))
SDL2_PROTO(int,QueueAudio,(SDL_AudioDeviceID a, const void *b, Uint32 c))
SDL2_PROTO(Uint32,GetQueuedAudioSize,(SDL_AudioDeviceID a))
SDL2_PROTO(void,ClearQueuedAudio,(SDL_AudioDeviceID a))
SDL2_PROTO(SDL_Window*,GetGrabbedWindow,(void))
#if defined(SDL_PLATFORM_WIN32) || defined(SDL_PLATFORM_GDK)
SDL2_PROTO(void,SetWindowsMessageHook,(SDL2_WindowsMessageHook a, void *b))
#endif
SDL2_PROTO(int,GetDisplayDPI,(int a, float *b, float *c, float *d))
SDL2_PROTO(SDL_JoystickPowerLevel,JoystickCurrentPowerLevel,(SDL_Joystick *a))
SDL2_PROTO(SDL_GameController*,GameControllerFromInstanceID,(SDL2_JoystickID a))
SDL2_PROTO(SDL_Joystick*,JoystickFromInstanceID,(SDL2_JoystickID a))
SDL2_PROTO(int,GetDisplayUsableBounds,(int a, SDL_Rect *b))
SDL2_PROTO(int,GetWindowBordersSize,(SDL_Window *a, int *b, int *c, int *d, int *e))
SDL2_PROTO(int,SetWindowOpacity,(SDL_Window *a, float b))
SDL2_PROTO(int,GetWindowOpacity,(SDL_Window *a, float *b))
SDL2_PROTO(int,SetWindowInputFocus,(SDL_Window *a))
SDL2_PROTO(int,SetWindowModalFor,(SDL_Window *a, SDL_Window *b))
SDL2_PROTO(int,RenderSetIntegerScale,(SDL_Renderer *a, SDL2_bool b))
SDL2_PROTO(SDL2_bool,RenderGetIntegerScale,(SDL_Renderer *a))
SDL2_PROTO(Uint32,DequeueAudio,(SDL_AudioDeviceID a, void *b, Uint32 c))
SDL2_PROTO(void,SetWindowResizable,(SDL_Window *a, SDL2_bool b))
SDL2_PROTO(SDL2_Surface*,CreateRGBSurfaceWithFormat,(Uint32 a, int b, int c, int d, Uint32 e))
SDL2_PROTO(SDL2_Surface*,CreateRGBSurfaceWithFormatFrom,(void *a, int b, int c, int d, int e, Uint32 f))
SDL2_PROTO(SDL2_bool,GetHintBoolean,(const char *a, SDL2_bool b))
SDL2_PROTO(Uint16,JoystickGetDeviceVendor,(int a))
SDL2_PROTO(Uint16,JoystickGetDeviceProduct,(int a))
SDL2_PROTO(Uint16,JoystickGetDeviceProductVersion,(int a))
SDL2_PROTO(Uint16,JoystickGetVendor,(SDL_Joystick *a))
SDL2_PROTO(Uint16,JoystickGetProduct,(SDL_Joystick *a))
SDL2_PROTO(Uint16,JoystickGetProductVersion,(SDL_Joystick *a))
SDL2_PROTO(Uint16,GameControllerGetVendor,(SDL_GameController *a))
SDL2_PROTO(Uint16,GameControllerGetProduct,(SDL_GameController *a))
SDL2_PROTO(Uint16,GameControllerGetProductVersion,(SDL_GameController *a))
SDL2_PROTO(SDL2_bool,HasNEON,(void))
SDL2_PROTO(int,GameControllerNumMappings,(void))
SDL2_PROTO(char*,GameControllerMappingForIndex,(int a))
SDL2_PROTO(SDL2_bool,JoystickGetAxisInitialState,(SDL_Joystick *a, int b, Sint16 *c))
SDL2_PROTO(SDL_JoystickType,JoystickGetDeviceType,(int a))
SDL2_PROTO(SDL_JoystickType,JoystickGetType,(SDL_Joystick *a))
SDL2_PROTO(void,MemoryBarrierReleaseFunction,(void))
SDL2_PROTO(void,MemoryBarrierAcquireFunction,(void))
SDL2_PROTO(SDL2_JoystickID,JoystickGetDeviceInstanceID,(int a))
SDL2_PROTO(size_t,utf8strlen,(const char *a))
SDL2_PROTO(void*,LoadFile_RW,(SDL2_RWops *a, size_t *b, int c))
SDL2_PROTO(int,wcscmp,(const wchar_t *a, const wchar_t *b))
SDL2_PROTO(SDL_BlendMode,ComposeCustomBlendMode,(SDL_BlendFactor a, SDL_BlendFactor b, SDL_BlendOperation c, SDL_BlendFactor d, SDL_BlendFactor e, SDL_BlendOperation f))
SDL2_PROTO(SDL2_Surface*,DuplicateSurface,(SDL2_Surface *a))
SDL2_PROTO(int,Vulkan_LoadLibrary,(const char *a))
SDL2_PROTO(void*,Vulkan_GetVkGetInstanceProcAddr,(void))
SDL2_PROTO(void,Vulkan_UnloadLibrary,(void))
SDL2_PROTO(SDL2_bool,Vulkan_GetInstanceExtensions,(SDL_Window *a, unsigned int *b, const char **c))
SDL2_PROTO(SDL2_bool,Vulkan_CreateSurface,(SDL_Window *a, VkInstance b, VkSurfaceKHR *c))
SDL2_PROTO(void,Vulkan_GetDrawableSize,(SDL_Window *a, int *b, int *c))
SDL2_PROTO(void,LockJoysticks,(void))
SDL2_PROTO(void,UnlockJoysticks,(void))
SDL2_PROTO(void,GetMemoryFunctions,(SDL_malloc_func *a, SDL_calloc_func *b, SDL_realloc_func *c, SDL_free_func *d))
SDL2_PROTO(int,SetMemoryFunctions,(SDL_malloc_func a, SDL_calloc_func b, SDL_realloc_func c, SDL_free_func d))
SDL2_PROTO(int,GetNumAllocations,(void))
SDL2_PROTO(SDL2_AudioStream*,NewAudioStream,(const SDL2_AudioFormat a, const Uint8 b, const int c, const SDL2_AudioFormat d, const Uint8 e, const int f))
SDL2_PROTO(int,AudioStreamPut,(SDL2_AudioStream *a, const void *b, int c))
SDL2_PROTO(int,AudioStreamGet,(SDL2_AudioStream *a, void *b, int c))
SDL2_PROTO(void,AudioStreamClear,(SDL2_AudioStream *a))
SDL2_PROTO(int,AudioStreamAvailable,(SDL2_AudioStream *a))
SDL2_PROTO(void,FreeAudioStream,(SDL2_AudioStream *a))
SDL2_PROTO(int,AudioStreamFlush,(SDL2_AudioStream *a))
SDL2_PROTO(float,acosf,(float a))
SDL2_PROTO(float,asinf,(float a))
SDL2_PROTO(float,atanf,(float a))
SDL2_PROTO(float,atan2f,(float a, float b))
SDL2_PROTO(float,ceilf,(float a))
SDL2_PROTO(float,copysignf,(float a, float b))
SDL2_PROTO(float,fabsf,(float a))
SDL2_PROTO(float,floorf,(float a))
SDL2_PROTO(float,logf,(float a))
SDL2_PROTO(float,powf,(float a, float b))
SDL2_PROTO(float,scalbnf,(float a, int b))
SDL2_PROTO(double,fmod,(double a, double b))
SDL2_PROTO(float,fmodf,(float a, float b))
SDL2_PROTO(void,SetYUVConversionMode,(SDL_YUV_CONVERSION_MODE a))
SDL2_PROTO(SDL_YUV_CONVERSION_MODE,GetYUVConversionMode,(void))
SDL2_PROTO(SDL_YUV_CONVERSION_MODE,GetYUVConversionModeForResolution,(int a, int b))
SDL2_PROTO(void*,RenderGetMetalLayer,(SDL_Renderer *a))
SDL2_PROTO(void*,RenderGetMetalCommandEncoder,(SDL_Renderer *a))
#ifdef SDL_PLATFORM_ANDROID
SDL2_PROTO(SDL2_bool,IsAndroidTV,(void))
#endif
SDL2_PROTO(double,log10,(double a))
SDL2_PROTO(float,log10f,(float a))
SDL2_PROTO(char*,GameControllerMappingForDeviceIndex,(int a))
#ifdef SDL_PLATFORM_LINUX
SDL2_PROTO(int,LinuxSetThreadPriority,(Sint64 a, int b))
#endif
SDL2_PROTO(SDL2_bool,HasAVX512F,(void))
#ifdef SDL_PLATFORM_ANDROID
SDL2_PROTO(SDL2_bool,IsChromebook,(void))
SDL2_PROTO(SDL2_bool,IsDeXMode,(void))
SDL2_PROTO(void,AndroidBackButton,(void))
#endif
SDL2_PROTO(double,exp,(double a))
SDL2_PROTO(float,expf,(float a))
SDL2_PROTO(wchar_t*,wcsdup,(const wchar_t *a))
SDL2_PROTO(int,GameControllerRumble,(SDL_GameController *a, Uint16 b, Uint16 c, Uint32 d))
SDL2_PROTO(int,JoystickRumble,(SDL_Joystick *a, Uint16 b, Uint16 c, Uint32 d))
SDL2_PROTO(int,NumSensors,(void))
SDL2_PROTO(const char*,SensorGetDeviceName,(int a))
SDL2_PROTO(SDL_SensorType,SensorGetDeviceType,(int a))
SDL2_PROTO(int,SensorGetDeviceNonPortableType,(int a))
SDL2_PROTO(SDL2_SensorID,SensorGetDeviceInstanceID,(int a))
SDL2_PROTO(SDL_Sensor*,SensorOpen,(int a))
SDL2_PROTO(SDL_Sensor*,SensorFromInstanceID,(SDL2_SensorID a))
SDL2_PROTO(const char*,SensorGetName,(SDL_Sensor *a))
SDL2_PROTO(SDL_SensorType,SensorGetType,(SDL_Sensor *a))
SDL2_PROTO(int,SensorGetNonPortableType,(SDL_Sensor *a))
SDL2_PROTO(SDL2_SensorID,SensorGetInstanceID,(SDL_Sensor *a))
SDL2_PROTO(int,SensorGetData,(SDL_Sensor *a, float *b, int c))
SDL2_PROTO(void,SensorClose,(SDL_Sensor *a))
SDL2_PROTO(void,SensorUpdate,(void))
SDL2_PROTO(SDL2_bool,IsTablet,(void))
SDL2_PROTO(SDL_DisplayOrientation,GetDisplayOrientation,(int a))
SDL2_PROTO(SDL2_bool,HasColorKey,(SDL2_Surface *a))

#if defined(SDL_PLATFORM_WIN32) || defined(SDL_PLATFORM_GDK)
SDL2_PROTO(SDL_Thread*,CreateThreadWithStackSize,(SDL_ThreadFunction a, const char *b, const size_t c, void *d, pfnSDL_CurrentBeginThread e, pfnSDL_CurrentEndThread f))
#elif defined(SDL_PLATFORM_OS2)
SDL2_PROTO(SDL_Thread*,CreateThreadWithStackSize,(SDL_ThreadFunction a, const char *b, const size_t c, void *d, pfnSDL_CurrentBeginThread e, pfnSDL_CurrentEndThread f))
#else
SDL2_PROTO(SDL_Thread*,CreateThreadWithStackSize,(SDL_ThreadFunction a, const char *b, const size_t c, void *d))
#endif

SDL2_PROTO(int,JoystickGetDevicePlayerIndex,(int a))
SDL2_PROTO(int,JoystickGetPlayerIndex,(SDL_Joystick *a))
SDL2_PROTO(int,GameControllerGetPlayerIndex,(SDL_GameController *a))
SDL2_PROTO(int,RenderFlush,(SDL_Renderer *a))
SDL2_PROTO(int,RenderDrawPointF,(SDL_Renderer *a, float b, float c))
SDL2_PROTO(int,RenderDrawPointsF,(SDL_Renderer *a, const SDL_FPoint *b, int c))
SDL2_PROTO(int,RenderDrawLineF,(SDL_Renderer *a, float b, float c, float d, float e))
SDL2_PROTO(int,RenderDrawLinesF,(SDL_Renderer *a, const SDL_FPoint *b, int c))
SDL2_PROTO(int,RenderDrawRectF,(SDL_Renderer *a, const SDL_FRect *b))
SDL2_PROTO(int,RenderDrawRectsF,(SDL_Renderer *a, const SDL_FRect *b, int c))
SDL2_PROTO(int,RenderFillRectF,(SDL_Renderer *a, const SDL_FRect *b))
SDL2_PROTO(int,RenderFillRectsF,(SDL_Renderer *a, const SDL_FRect *b, int c))
SDL2_PROTO(int,RenderCopyF,(SDL_Renderer *a, SDL_Texture *b, const SDL_Rect *c, const SDL_FRect *d))
SDL2_PROTO(int,RenderCopyExF,(SDL_Renderer *a, SDL_Texture *b, const SDL_Rect *c, const SDL_FRect *d, const double e, const SDL_FPoint *f, const SDL_FlipMode g))
SDL2_PROTO(SDL_TouchDeviceType,GetTouchDeviceType,(SDL_TouchID a))
#ifdef SDL_PLATFORM_IOS
SDL2_PROTO(int,UIKitRunApp,(int a, char *b[], SDL_main_func c))
#endif
SDL2_PROTO(size_t,SIMDGetAlignment,(void))
SDL2_PROTO(void*,SIMDAlloc,(const size_t a))
SDL2_PROTO(void,SIMDFree,(void *a))
SDL2_PROTO(Sint64,RWsize,(SDL2_RWops *a))
SDL2_PROTO(Sint64,RWseek,(SDL2_RWops *a, Sint64 b, int c))
SDL2_PROTO(Sint64,RWtell,(SDL2_RWops *a))
SDL2_PROTO(size_t,RWread,(SDL2_RWops *a, void *b, size_t c, size_t d))
SDL2_PROTO(size_t,RWwrite,(SDL2_RWops *a, const void *b, size_t c, size_t d))
SDL2_PROTO(int,RWclose,(SDL2_RWops *a))
SDL2_PROTO(void*,LoadFile,(const char *a, size_t *b))
SDL2_PROTO(SDL_MetalView,Metal_CreateView,(SDL_Window *a))
SDL2_PROTO(void,Metal_DestroyView,(SDL_MetalView a))
SDL2_PROTO(int,LockTextureToSurface,(SDL_Texture *a, const SDL_Rect *b, SDL2_Surface **c))
SDL2_PROTO(SDL2_bool,HasARMSIMD,(void))
SDL2_PROTO(char*,strtokr,(char *a, const char *b, char **c))
SDL2_PROTO(wchar_t*,wcsstr,(const wchar_t *a, const wchar_t *b))
SDL2_PROTO(int,wcsncmp,(const wchar_t *a, const wchar_t *b, size_t c))
SDL2_PROTO(SDL_GameControllerType,GameControllerTypeForIndex,(int a))
SDL2_PROTO(SDL_GameControllerType,GameControllerGetType,(SDL_GameController *a))
SDL2_PROTO(SDL_GameController*,GameControllerFromPlayerIndex,(int a))
SDL2_PROTO(void,GameControllerSetPlayerIndex,(SDL_GameController *a, int b))
SDL2_PROTO(SDL_Joystick*,JoystickFromPlayerIndex,(int a))
SDL2_PROTO(void,JoystickSetPlayerIndex,(SDL_Joystick *a, int b))
SDL2_PROTO(int,SetTextureScaleMode,(SDL_Texture *a, SDL_ScaleMode b))
SDL2_PROTO(int,GetTextureScaleMode,(SDL_Texture *a, SDL_ScaleMode *b))
SDL2_PROTO(void,OnApplicationWillTerminate,(void))
SDL2_PROTO(void,OnApplicationDidReceiveMemoryWarning,(void))
SDL2_PROTO(void,OnApplicationWillResignActive,(void))
SDL2_PROTO(void,OnApplicationDidEnterBackground,(void))
SDL2_PROTO(void,OnApplicationWillEnterForeground,(void))
SDL2_PROTO(void,OnApplicationDidBecomeActive,(void))
#ifdef SDL_PLATFORM_IOS
SDL2_PROTO(void,OnApplicationDidChangeStatusBarOrientation,(void))
#endif
#ifdef SDL_PLATFORM_ANDROID
SDL2_PROTO(int,GetAndroidSDKVersion,(void))
#endif
SDL2_PROTO(int,isupper,(int a))
SDL2_PROTO(int,islower,(int a))
SDL2_PROTO(int,JoystickAttachVirtual,(SDL_JoystickType a, int b, int c, int d))
SDL2_PROTO(int,JoystickDetachVirtual,(int a))
SDL2_PROTO(SDL2_bool,JoystickIsVirtual,(int a))
SDL2_PROTO(int,JoystickSetVirtualAxis,(SDL_Joystick *a, int b, Sint16 c))
SDL2_PROTO(int,JoystickSetVirtualButton,(SDL_Joystick *a, int b, Uint8 c))
SDL2_PROTO(int,JoystickSetVirtualHat,(SDL_Joystick *a, int b, Uint8 c))
SDL2_PROTO(char*,GetErrorMsg,(char *a, int b))
SDL2_PROTO(void,LockSensors,(void))
SDL2_PROTO(void,UnlockSensors,(void))
SDL2_PROTO(void*,Metal_GetLayer,(SDL_MetalView a))
SDL2_PROTO(void,Metal_GetDrawableSize,(SDL_Window *a, int *b, int *c))
SDL2_PROTO(double,trunc,(double a))
SDL2_PROTO(float,truncf,(float a))
SDL2_PROTO(SDL_Locale *,GetPreferredLocales,(void))
SDL2_PROTO(void*,SIMDRealloc,(void *a, const size_t b))
#ifdef SDL_PLATFORM_ANDROID
SDL2_PROTO(SDL2_bool,AndroidRequestPermission,(const char *a))
#endif
SDL2_PROTO(int,OpenURL,(const char *a))
SDL2_PROTO(SDL2_bool,HasSurfaceRLE,(SDL2_Surface *a))
SDL2_PROTO(SDL2_bool,GameControllerHasLED,(SDL_GameController *a))
SDL2_PROTO(int,GameControllerSetLED,(SDL_GameController *a, Uint8 b, Uint8 c, Uint8 d))
SDL2_PROTO(SDL2_bool,JoystickHasLED,(SDL_Joystick *a))
SDL2_PROTO(int,JoystickSetLED,(SDL_Joystick *a, Uint8 b, Uint8 c, Uint8 d))
SDL2_PROTO(int,GameControllerRumbleTriggers,(SDL_GameController *a, Uint16 b, Uint16 c, Uint32 d))
SDL2_PROTO(int,JoystickRumbleTriggers,(SDL_Joystick *a, Uint16 b, Uint16 c, Uint32 d))
SDL2_PROTO(SDL2_bool,GameControllerHasAxis,(SDL_GameController *a, SDL_GameControllerAxis b))
SDL2_PROTO(SDL2_bool,GameControllerHasButton,(SDL_GameController *a, SDL_GameControllerButton b))
SDL2_PROTO(int,GameControllerGetNumTouchpads,(SDL_GameController *a))
SDL2_PROTO(int,GameControllerGetNumTouchpadFingers,(SDL_GameController *a, int b))
SDL2_PROTO(int,GameControllerGetTouchpadFinger,(SDL_GameController *a, int b, int c, Uint8 *d, float *e, float *f, float *g))
SDL2_PROTO(Uint32,crc32,(Uint32 a, const void *b, size_t c))
SDL2_PROTO(const char*,GameControllerGetSerial,(SDL_GameController *a))
SDL2_PROTO(const char*,JoystickGetSerial,(SDL_Joystick *a))
SDL2_PROTO(SDL2_bool,GameControllerHasSensor,(SDL_GameController *a, SDL_SensorType b))
SDL2_PROTO(int,GameControllerSetSensorEnabled,(SDL_GameController *a, SDL_SensorType b, SDL2_bool c))
SDL2_PROTO(SDL2_bool,GameControllerIsSensorEnabled,(SDL_GameController *a, SDL_SensorType b))
SDL2_PROTO(int,GameControllerGetSensorData,(SDL_GameController *a, SDL_SensorType b, float *c, int d))
SDL2_PROTO(int,wcscasecmp,(const wchar_t *a, const wchar_t *b))
SDL2_PROTO(int,wcsncasecmp,(const wchar_t *a, const wchar_t *b, size_t c))
SDL2_PROTO(double,round,(double a))
SDL2_PROTO(float,roundf,(float a))
SDL2_PROTO(long,lround,(double a))
SDL2_PROTO(long,lroundf,(float a))
SDL2_PROTO(int,SoftStretchLinear,(SDL2_Surface *a, const SDL_Rect *b, SDL2_Surface *c, const SDL_Rect *d))
#if defined(SDL_PLATFORM_WIN32) || defined(SDL_PLATFORM_WINGDK)
SDL2_PROTO(ID3D11Device*,RenderGetD3D11Device,(SDL_Renderer *a))
#endif
SDL2_PROTO(int,UpdateNVTexture,(SDL_Texture *a, const SDL_Rect *b, const Uint8 *c, int d, const Uint8 *e, int f))
SDL2_PROTO(void,SetWindowKeyboardGrab,(SDL_Window *a, SDL2_bool b))
SDL2_PROTO(void,SetWindowMouseGrab,(SDL_Window *a, SDL2_bool b))
SDL2_PROTO(SDL2_bool,GetWindowKeyboardGrab,(SDL_Window *a))
SDL2_PROTO(SDL2_bool,GetWindowMouseGrab,(SDL_Window *a))
SDL2_PROTO(int,isalpha,(int a))
SDL2_PROTO(int,isalnum,(int a))
SDL2_PROTO(int,isblank,(int a))
SDL2_PROTO(int,iscntrl,(int a))
SDL2_PROTO(int,isxdigit,(int a))
SDL2_PROTO(int,ispunct,(int a))
SDL2_PROTO(int,isprint,(int a))
SDL2_PROTO(int,isgraph,(int a))
#ifdef SDL_PLATFORM_ANDROID
SDL2_PROTO(int,AndroidShowToast,(const char *a, int b, int c, int d, int e))
#endif
SDL2_PROTO(int,GetAudioDeviceSpec,(int a, int b, SDL2_AudioSpec *c))
SDL2_PROTO(void,TLSCleanup,(void))
SDL2_PROTO(void,SetWindowAlwaysOnTop,(SDL_Window *a, SDL2_bool b))
SDL2_PROTO(int,FlashWindow,(SDL_Window *a, SDL_FlashOperation b))
SDL2_PROTO(int,GameControllerSendEffect,(SDL_GameController *a, const void *b, int c))
SDL2_PROTO(int,JoystickSendEffect,(SDL_Joystick *a, const void *b, int c))
SDL2_PROTO(float,GameControllerGetSensorDataRate,(SDL_GameController *a, SDL_SensorType b))
SDL2_PROTO(int,SetTextureUserData,(SDL_Texture *a, void *b))
SDL2_PROTO(void*,GetTextureUserData,(SDL_Texture *a))
SDL2_PROTO(int,RenderGeometry,(SDL_Renderer *a, SDL_Texture *b, const SDL2_Vertex *c, int d, const int *e, int f))
SDL2_PROTO(int,RenderGeometryRaw,(SDL_Renderer *a, SDL_Texture *b, const float *c, int d, const SDL_Color *e, int f, const float *g, int h, int i, const void *j, int k, int l))
SDL2_PROTO(int,RenderSetVSync,(SDL_Renderer *a, int b))
SDL2_PROTO(int,asprintf,(char **a, SDL_PRINTF_FORMAT_STRING const char *b, ...))
SDL2_PROTO(int,vasprintf,(char **a, const char *b, va_list c))
SDL2_PROTO(void*,GetWindowICCProfile,(SDL_Window *a, size_t *b))
SDL2_PROTO(Uint64,GetTicks64,(void))
#ifdef SDL_PLATFORM_LINUX
SDL2_PROTO(int,LinuxSetThreadPriorityAndPolicy,(Sint64 a, int b, int c))
#endif
SDL2_PROTO(const char*,GameControllerGetAppleSFSymbolsNameForButton,(SDL_GameController *a, SDL_GameControllerButton b))
SDL2_PROTO(const char*,GameControllerGetAppleSFSymbolsNameForAxis,(SDL_GameController *a, SDL_GameControllerAxis b))
SDL2_PROTO(int,hid_init,(void))
SDL2_PROTO(int,hid_exit,(void))
SDL2_PROTO(Uint32,hid_device_change_count,(void))
SDL2_PROTO(SDL2_hid_device_info*,hid_enumerate,(unsigned short a, unsigned short b))
SDL2_PROTO(void,hid_free_enumeration,(SDL2_hid_device_info *a))
SDL2_PROTO(SDL_hid_device*,hid_open,(unsigned short a, unsigned short b, const wchar_t *c))
SDL2_PROTO(SDL_hid_device*,hid_open_path,(const char *a, int b))
SDL2_PROTO(int,hid_write,(SDL_hid_device *a, const unsigned char *b, size_t c))
SDL2_PROTO(int,hid_read_timeout,(SDL_hid_device *a, unsigned char *b, size_t c, int d))
SDL2_PROTO(int,hid_read,(SDL_hid_device *a, unsigned char *b, size_t c))
SDL2_PROTO(int,hid_set_nonblocking,(SDL_hid_device *a, int b))
SDL2_PROTO(int,hid_send_feature_report,(SDL_hid_device *a, const unsigned char *b, size_t c))
SDL2_PROTO(int,hid_get_feature_report,(SDL_hid_device *a, unsigned char *b, size_t c))
SDL2_PROTO(void,hid_close,(SDL_hid_device *a))
SDL2_PROTO(int,hid_get_manufacturer_string,(SDL_hid_device *a, wchar_t *b, size_t c))
SDL2_PROTO(int,hid_get_product_string,(SDL_hid_device *a, wchar_t *b, size_t c))
SDL2_PROTO(int,hid_get_serial_number_string,(SDL_hid_device *a, wchar_t *b, size_t c))
SDL2_PROTO(int,hid_get_indexed_string,(SDL_hid_device *a, int b, wchar_t *c, size_t d))
SDL2_PROTO(int,SetWindowMouseRect,(SDL_Window *a, const SDL_Rect *b))
SDL2_PROTO(const SDL_Rect*,GetWindowMouseRect,(SDL_Window *a))
SDL2_PROTO(void,RenderWindowToLogical,(SDL_Renderer *a, int b, int c, float *d, float *e))
SDL2_PROTO(void,RenderLogicalToWindow,(SDL_Renderer *a, float b, float c, int *d, int *e))
SDL2_PROTO(SDL2_bool,JoystickHasRumble,(SDL_Joystick *a))
SDL2_PROTO(SDL2_bool,JoystickHasRumbleTriggers,(SDL_Joystick *a))
SDL2_PROTO(SDL2_bool,GameControllerHasRumble,(SDL_GameController *a))
SDL2_PROTO(SDL2_bool,GameControllerHasRumbleTriggers,(SDL_GameController *a))
SDL2_PROTO(void,hid_ble_scan,(SDL2_bool a))
SDL2_PROTO(int,PremultiplyAlpha,(int a, int b, Uint32 c, const void *d, int e, Uint32 f, void *g, int h))
#ifdef SDL_PLATFORM_ANDROID
SDL2_PROTO(int,AndroidSendMessage,(Uint32 a, int b))
#endif
SDL2_PROTO(const char*,GetTouchName,(int a))
SDL2_PROTO(void,ClearComposition,(void))
SDL2_PROTO(SDL2_bool,IsTextInputShown,(void))
SDL2_PROTO(SDL2_bool,HasIntersectionF,(const SDL_FRect *a, const SDL_FRect *b))
SDL2_PROTO(SDL2_bool,IntersectFRect,(const SDL_FRect *a, const SDL_FRect *b, SDL_FRect *c))
SDL2_PROTO(void,UnionFRect,(const SDL_FRect *a, const SDL_FRect *b, SDL_FRect *c))
SDL2_PROTO(SDL2_bool,EncloseFPoints,(const SDL_FPoint *a, int b, const SDL_FRect *c, SDL_FRect *d))
SDL2_PROTO(SDL2_bool,IntersectFRectAndLine,(const SDL_FRect *a, float *b, float *c, float *d, float *e))
SDL2_PROTO(SDL_Window*,RenderGetWindow,(SDL_Renderer *a))
SDL2_PROTO(void*,bsearch,(const void *a, const void *b, size_t c, size_t d, int (SDLCALL *e)(const void *, const void *)))
SDL2_PROTO(const char*,GameControllerPathForIndex,(int a))
SDL2_PROTO(const char*,GameControllerPath,(SDL_GameController *a))
SDL2_PROTO(const char*,JoystickPathForIndex,(int a))
SDL2_PROTO(const char*,JoystickPath,(SDL_Joystick *a))
SDL2_PROTO(int,JoystickAttachVirtualEx,(const SDL2_VirtualJoystickDesc *a))
SDL2_PROTO(Uint16,GameControllerGetFirmwareVersion,(SDL_GameController *a))
SDL2_PROTO(Uint16,JoystickGetFirmwareVersion,(SDL_Joystick *a))
SDL2_PROTO(void,GUIDToString,(SDL_GUID a, char *b, int c))
SDL2_PROTO(SDL_GUID,GUIDFromString,(const char *a))
SDL2_PROTO(SDL2_bool,HasLSX,(void))
SDL2_PROTO(SDL2_bool,HasLASX,(void))
#if defined(SDL_PLATFORM_WIN32) || defined(SDL_PLATFORM_GDK)
SDL2_PROTO(ID3D12Device*,RenderGetD3D12Device,(SDL_Renderer *a))
#endif
SDL2_PROTO(size_t,utf8strnlen,(const char *a, size_t b))
#if defined(SDL_PLATFORM_GDK)
SDL2_PROTO(int,GDKGetTaskQueue,(XTaskQueueHandle *a))
SDL2_PROTO(int,GDKRunApp,(SDL_main_func a, void *b))
#endif
SDL2_PROTO(void,GetOriginalMemoryFunctions,(SDL_malloc_func *a, SDL_calloc_func *b, SDL_realloc_func *c, SDL_free_func *d))
SDL2_PROTO(void,ResetKeyboard,(void))
SDL2_PROTO(int,GetDefaultAudioInfo,(char **a, SDL2_AudioSpec *b, int c))
SDL2_PROTO(int,GetPointDisplayIndex,(const SDL_Point *a))
SDL2_PROTO(int,GetRectDisplayIndex,(const SDL_Rect *a))
SDL2_PROTO(SDL2_bool,ResetHint,(const char *a))
SDL2_PROTO(Uint16,crc16,(Uint16 a, const void *b, size_t c))
SDL2_PROTO(void,GetWindowSizeInPixels,(SDL_Window *a, int *b, int *c))
SDL2_PROTO(void,GetJoystickGUIDInfo,(SDL_GUID a, Uint16 *b, Uint16 *c, Uint16 *d, Uint16 *e))
SDL2_PROTO(int,SetPrimarySelectionText,(const char *a))
SDL2_PROTO(char*,GetPrimarySelectionText,(void))
SDL2_PROTO(SDL2_bool,HasPrimarySelectionText,(void))
SDL2_PROTO(int,GameControllerGetSensorDataWithTimestamp,(SDL_GameController *a, SDL_SensorType b, Uint64 *c, float *d, int e))
SDL2_PROTO(int,SensorGetDataWithTimestamp,(SDL_Sensor *a, Uint64 *b, float *c, int d))
SDL2_PROTO(void,ResetHints,(void))
SDL2_PROTO(char*,strcasestr,(const char *a, const char *b))
#if defined(SDL_PLATFORM_GDK)
SDL2_PROTO(void,GDKSuspendComplete,(void))
#endif
SDL2_PROTO(SDL2_bool,HasWindowSurface,(SDL_Window *a))
SDL2_PROTO(int,DestroyWindowSurface,(SDL_Window *a))
#if defined(SDL_PLATFORM_GDK)
SDL2_PROTO(int,GDKGetDefaultUser,(XUserHandle *a))
#endif
SDL2_PROTO(Uint64,GameControllerGetSteamHandle,(SDL_GameController *a))

#ifdef __cplusplus
}
#endif

#undef SDL2_PROTO

#endif /* sdl2_protos_h_ */
