/* Code generated by cmd/cgo; DO NOT EDIT. */

/* package command-line-arguments */


#line 1 "cgo-builtin-export-prolog"

#include <stddef.h> /* for ptrdiff_t below */

#ifndef GO_CGO_EXPORT_PROLOGUE_H
#define GO_CGO_EXPORT_PROLOGUE_H

#ifndef GO_CGO_GOSTRING_TYPEDEF
typedef struct { const char *p; ptrdiff_t n; } _GoString_;
#endif

#endif

/* Start of preamble from import "C" comments.  */




/* End of preamble from import "C" comments.  */


/* Start of boilerplate cgo prologue.  */
#line 1 "cgo-gcc-export-header-prolog"

#ifndef GO_CGO_PROLOGUE_H
#define GO_CGO_PROLOGUE_H

typedef signed char GoInt8;
typedef unsigned char GoUint8;
typedef short GoInt16;
typedef unsigned short GoUint16;
typedef int GoInt32;
typedef unsigned int GoUint32;
typedef long long GoInt64;
typedef unsigned long long GoUint64;
typedef GoInt64 GoInt;
typedef GoUint64 GoUint;
typedef __SIZE_TYPE__ GoUintptr;
typedef float GoFloat32;
typedef double GoFloat64;
typedef float _Complex GoComplex64;
typedef double _Complex GoComplex128;

/*
  static assertion to make sure the file is being used on architecture
  at least with matching size of GoInt.
*/
typedef char _check_for_64_bit_pointer_matching_GoInt[sizeof(void*)==64/8 ? 1:-1];

#ifndef GO_CGO_GOSTRING_TYPEDEF
typedef _GoString_ GoString;
#endif
typedef void *GoMap;
typedef void *GoChan;
typedef struct { void *t; void *v; } GoInterface;
typedef struct { void *data; GoInt len; GoInt cap; } GoSlice;

#endif

/* End of boilerplate cgo prologue.  */

#ifdef __cplusplus
extern "C" {
#endif


// SecSIPIDSignJSONHP --
// * sign the JSON header and payload with provided private key
// * headerJSON -  header part in JSON forman (0-terminated string)
// * payloadJSON -  payload part in JSON forman (0-terminated string)
// * prvkeyPath - path to private key to be used to generate the signature
// * outPtr - to be set to the pointer containing the output (it is a
//   0-terminated string); the `*outPtr` must be freed after use
// * return: the length of `*outPtr`
extern int SecSIPIDSignJSONHP(char* headerJSON, char* payloadJSON, char* prvkeyPath, char** outPtr);

// SecSIPIDGetIdentity --
// Generate the Identity header content using the input attributes
// * origTN - calling number
// * destTN - called number
// * attestVal - attestation level
// * origID - unique ID for tracking purposes, if empty string a UUID is generated
// * x5uVal - location of public certificate
// * prvkeyPath - path to private key to be used to generate the signature
// * outPtr - to be set to the pointer containing the output (it is a
//   0-terminated string); the `*outPtr` must be freed after use
// * return: the length of `*outPtr`
extern int SecSIPIDGetIdentity(char* origTN, char* destTN, char* attestVal, char* origID, char* x5uVal, char* prvkeyPath, char** outPtr);

// SecSIPIDCheck --
// check the Identity header value
// * identityVal - identity header value
// * identityLen - length of identityVal, if is 0, identityVal is expected
//   to be 0-terminated
// * expireVal - number of seconds until the validity is considered expired
// * pubkeyPath - file path or URL to public key
// * timeoutVal - timeout in seconds to try to fetch the public key via HTTP
// * return: 0 - if validity is ok; <0 - on error or validity is not ok
extern int SecSIPIDCheck(char* identityVal, int identityLen, int expireVal, char* pubkeyPath, int timeoutVal);

// SecSIPIDCheckFull --
// check the Identity header value
// * identityVal - identity header value with header parameters
// * identityLen - length of identityVal, if it is 0, identityVal is expected
//   to be 0-terminated
// * expireVal - number of seconds until the validity is considered expired
// * pubkeyPath - file path or URL to public key
// * timeoutVal - timeout in seconds to try to fetch the public key via HTTP
// * return: 0 - if validity is ok; <0 - on error or validity is not ok
extern int SecSIPIDCheckFull(char* identityVal, int identityLen, int expireVal, char* pubkeyPath, int timeoutVal);

// SecSIPIDCheckFullPubKey --
// check the Identity header value
// * identityVal - identity header value with header parameters
// * identityLen - length of identityVal, if it is 0, identityVal is expected
//   to be 0-terminated
// * expireVal - number of seconds until the validity is considered expired
// * pubkeyVal - the value of the public key
// * pubkeyLen - the length of the public key, if it is 0, then the pubkeyVal
//   is expected to be 0-terminated
// * return: 0 - if validity is ok; <0 - on error or validity is not ok
extern int SecSIPIDCheckFullPubKey(char* identityVal, int identityLen, int expireVal, char* pubkeyVal, int pubkeyLen);

// SecSIPIDSetFileCacheOptions --
// set the options for local file caching of public keys
// * dirPath - path to local directory where to store the files
// * expireVal - number of the seconds after which to invalidate the cached file
// * return: 0
extern int SecSIPIDSetFileCacheOptions(char* dirPath, int expireVal);

// SecSIPIDGetURLContent --
// get the content of an URL
// * urlVal - the HTTP or HTTPS URL
// * timeoutVal - timeout in seconds to try to get the content of the HTTP URL
// * outPtr - to be set to the pointer containing the output (it is a
//   0-terminated string); the `*outPtr` must be freed after use
// * outLen: to be set to the length of `*outPtr`
// * return: 0 - on success; -1 - on failure
extern int SecSIPIDGetURLContent(char* urlVal, int timeoutVal, char** outPtr, int* outLen);

#ifdef __cplusplus
}
#endif
