#!/usr/bin/env cwl-runner

# This CWL file was automatically generated using CTDConverter.
# Visit https://github.com/WorkflowConversion/CTDConverter for more information.

baseCommand: compute_gain
class: CommandLineTool
cwlVersion: v1.0
doc: "This program computes the read correction tool metric GAIN.  It takes a genome\
  \ FASTA file and two SAM file with read alignments before and after correction.\
  \  It then computes various statistics and computes the GAIN, based on the edit\
  \ or Hamming distance for reach read before and after correction.\n\n\n\nFor more\
  \ information, visit http://www.seqan.de"
inputs:
- default: 'false'
  doc: Disable most output.
  id: param_quiet
  inputBinding:
    prefix: -quiet
  label: Disable most output.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Enable more verbose output.
  id: param_verbose
  inputBinding:
    prefix: -verbose
  label: Enable more verbose output.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Enable even more verbose output.
  id: param_very-verbose
  inputBinding:
    prefix: -very-verbose
  label: Enable even more verbose output.
  type:
  - 'null'
  - string
- default: '1'
  doc: Number of threads to use.
  id: param_num-threads
  inputBinding:
    prefix: -num-threads
  label: Number of threads to use.
  type:
  - 'null'
  - int
- default: '10000'
  doc: Chunk size.
  id: param_chunk-size
  inputBinding:
    prefix: -chunk-size
  label: Chunk size.
  type:
  - 'null'
  - int
- default: '0'
  doc: Maximal number of chunks to read (0=disabled).
  id: param_max-chunks
  inputBinding:
    prefix: -max-chunks
  label: Maximal number of chunks to read (0=disabled).
  type:
  - 'null'
  - int
- default: '5'
  doc: Additional genome characters to use for alignment in percent of the origina
    read length.
  id: param_padding
  inputBinding:
    prefix: -padding
  label: Additional genome characters to use for alignment in percent of the origina
    read length.
  type:
  - 'null'
  - int
- default: edit
  doc: The metric type to use.
  id: param_metric
  inputBinding:
    prefix: -metric
  label: The metric type to use.
  type:
  - 'null'
  - string
- default: '0'
  doc: Reads with fewer unclipped bases are ignored. Set to 0 to disable ignoring
    because of this.
  id: param_min-unclipped-bases
  inputBinding:
    prefix: -min-unclipped-bases
  label: Reads with fewer unclipped bases are ignored. Set to 0 to disable ignoring
    because of this.
  type:
  - 'null'
  - int
- default: '0'
  doc: Reads with a higher error rate in the initial mapping are ignored.  Given in
    percent.  Set to 0 to disable ignoring because of this.
  id: param_max-error-rate
  inputBinding:
    prefix: -max-error-rate
  label: Reads with a higher error rate in the initial mapping are ignored.  Given
    in percent.  Set to 0 to disable ignoring because of this.
  type:
  - 'null'
  - int
- default: '-1'
  doc: Reads with a higher error count in the initial mapping are ignored.  Given
    in percent.  Set to -1 to disable ignoring because of this.
  id: param_max-error-count
  inputBinding:
    prefix: -max-error-count
  label: Reads with a higher error count in the initial mapping are ignored.  Given
    in percent.  Set to -1 to disable ignoring because of this.
  type:
  - 'null'
  - int
- doc: Genome file.
  id: param_genome
  inputBinding:
    prefix: -genome
  label: Genome file.
  type: File
- doc: Pre-correction SAM file.
  id: param_pre
  inputBinding:
    prefix: -pre
  label: Pre-correction SAM file.
  type: File
- doc: Post-correction SAM file.
  id: param_post-sam
  inputBinding:
    prefix: -post-sam
  label: Post-correction SAM file.
  type:
  - 'null'
  - File
- doc: Post-correction FASTQ or FASTA file.
  id: param_post
  inputBinding:
    prefix: -post
  label: Post-correction FASTQ or FASTA file.
  type:
  - 'null'
  - File
- doc: Filename for correction-log output file
  id: param_correction-log_filename
  inputBinding:
    prefix: -correction-log
  label: Filename for correction-log output file
  type:
  - 'null'
  - string
- default: 'false'
  doc: Log all not only introduced/removed errors.
  id: param_log-all
  inputBinding:
    prefix: -log-all
  label: Log all not only introduced/removed errors.
  type:
  - 'null'
  - string
- default: 'false'
  doc: No checking for reads being sorted.
  id: param_no-check-sorting
  inputBinding:
    prefix: -no-check-sorting
  label: No checking for reads being sorted.
  type:
  - 'null'
  - string
label: Compute read correction metric GAIN.
outputs:
- doc: Write log about introduced/removed errors to this file.
  id: param_correction-log
  label: Write log about introduced/removed errors to this file.
  outputBinding:
    glob: $(inputs.param_correction-log_filename)
  type:
  - 'null'
  - File
