#!/usr/bin/env cwl-runner

# This CWL file was automatically generated using CTDConverter.
# Visit https://github.com/WorkflowConversion/CTDConverter for more information.

baseCommand: micro_razers
class: CommandLineTool
cwlVersion: v1.0
doc: "MicroRazerS uses a prefix-based mapping strategy to map small RNA reads possibly\
  \ containing 3' adapter sequence. \nInput to MicroRazerS is a reference genome file\
  \ and a file with single-end reads. Use - to read the reads from stdin.\n(c) Copyright\
  \ 2009 by Anne-Katrin Emde.\n\n\n\nFor more information, visit http://www.seqan.de"
inputs:
- doc: Filename for output output file
  id: param_output_filename
  inputBinding:
    prefix: -output
  label: Filename for output output file
  type:
  - 'null'
  - string
- default: '100.0'
  doc: set the percent recognition rate
  id: param_recognition-rate
  inputBinding:
    prefix: -recognition-rate
  label: set the percent recognition rate
  type:
  - 'null'
  - double
- default: '16'
  doc: seed length
  id: param_seed-length
  inputBinding:
    prefix: -seed-length
  label: seed length
  type:
  - 'null'
  - int
- default: 'false'
  doc: allow for one error in the seed
  id: param_seed-error
  inputBinding:
    prefix: -seed-error
  label: allow for one error in the seed
  type:
  - 'null'
  - string
- default: 'false'
  doc: map reads only to forward strands.
  id: param_forward
  inputBinding:
    prefix: -forward
  label: map reads only to forward strands.
  type:
  - 'null'
  - string
- default: 'false'
  doc: map reads only to reverse strands.
  id: param_reverse
  inputBinding:
    prefix: -reverse
  label: map reads only to reverse strands.
  type:
  - 'null'
  - string
- default: 'false'
  doc: "'N' matches with all other characters"
  id: param_match-N
  inputBinding:
    prefix: -match-N
  label: "'N' matches with all other characters"
  type:
  - 'null'
  - string
- default: '100'
  doc: output only NUM of the best hits
  id: param_max-hits
  inputBinding:
    prefix: -max-hits
  label: output only NUM of the best hits
  type:
  - 'null'
  - int
- default: 'false'
  doc: purge reads with more than max-hits best matches
  id: param_purge-ambiguous
  inputBinding:
    prefix: -purge-ambiguous
  label: purge reads with more than max-hits best matches
  type:
  - 'null'
  - string
- default: 'false'
  doc: decrease memory usage at the expense of runtime
  id: param_low-memory
  inputBinding:
    prefix: -low-memory
  label: decrease memory usage at the expense of runtime
  type:
  - 'null'
  - string
- default: 'false'
  doc: verbose mode
  id: param_verbose
  inputBinding:
    prefix: -verbose
  label: verbose mode
  type:
  - 'null'
  - string
- default: 'false'
  doc: very verbose mode
  id: param_vverbose
  inputBinding:
    prefix: -vverbose
  label: very verbose mode
  type:
  - 'null'
  - string
- default: 'false'
  doc: dump the alignment for each match
  id: param_alignment
  inputBinding:
    prefix: -alignment
  label: dump the alignment for each match
  type:
  - 'null'
  - string
- default: '0'
  doc: Select how genomes are named. 0 = use Fasta id, 1 = enumerate beginning with
    1.
  id: param_genome-naming
  inputBinding:
    prefix: -genome-naming
  label: Select how genomes are named. 0 = use Fasta id, 1 = enumerate beginning with
    1.
  type:
  - 'null'
  - int
- default: '0'
  doc: Select how reads are named. 0 = use Fasta id, 1 = enumerate beginning with
    1.
  id: param_read-naming
  inputBinding:
    prefix: -read-naming
  label: Select how reads are named. 0 = use Fasta id, 1 = enumerate beginning with
    1.
  type:
  - 'null'
  - int
- default: '0'
  doc: Select how matches are sorted. 0 = read number, 1 = genome position.
  id: param_sort-order
  inputBinding:
    prefix: -sort-order
  label: Select how matches are sorted. 0 = read number, 1 = genome position.
  type:
  - 'null'
  - int
- default: '0'
  doc: Select begin/end position numbering (see Coordinate section below). 0 = gap
    space, 1 = position space.
  id: param_position-format
  inputBinding:
    prefix: -position-format
  label: Select begin/end position numbering (see Coordinate section below). 0 = gap
    space, 1 = position space.
  type:
  - 'null'
  - int
- doc: A reference genome file.
  id: param_argument-0
  inputBinding:
    prefix: -argument-0
  label: A reference genome file.
  type: File
- doc: Either one (single-end) or two (paired-end) read files.
  id: param_argument-1
  inputBinding:
    prefix: -argument-1
  label: Either one (single-end) or two (paired-end) read files.
  type: File
label: Map small RNA reads possibly containing 3' adapter sequence
outputs:
- doc: 'Change output filename. (use - to dump to stdout in razers format) Default:
    <READS FILE>.razers.'
  id: param_output
  label: 'Change output filename. (use - to dump to stdout in razers format) Default:
    <READS FILE>.razers.'
  outputBinding:
    glob: $(inputs.param_output_filename)
  type:
  - 'null'
  - File
