#!/usr/bin/env cwl-runner

# This CWL file was automatically generated using CTDConverter.
# Visit https://github.com/WorkflowConversion/CTDConverter for more information.

baseCommand: rabema_evaluate
class: CommandLineTool
cwlVersion: v1.0
doc: "Compare the SAM/bam output MAPPING.sam/MAPPING.bam of any read mapper against\
  \ the RABEMA gold standard previously built with rabema_build_gold_standard.  The\
  \ input is a reference FASTA file, a gold standard interval (GSI) file and the SAM/BAM\
  \ input to evaluate.\nThe input SAM/BAM file must be sorted by queryname.  The program\
  \ will create a FASTA index file REF.fa.fai for fast random access to the reference.\n\
  \n\n\nFor more information, visit http://www.seqan.de"
inputs:
- default: 'false'
  doc: Enable verbose output.
  id: param_verbose
  inputBinding:
    prefix: -verbose
  label: Enable verbose output.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Enable even more verbose output.
  id: param_very-verbose
  inputBinding:
    prefix: -very-verbose
  label: Enable even more verbose output.
  type:
  - 'null'
  - string
- doc: Path to load reference FASTA from.
  id: param_reference
  inputBinding:
    prefix: -reference
  label: Path to load reference FASTA from.
  type: File
- doc: Path to load gold standard intervals from. If compressed using gzip, the file
    will be decompressed on the fly.
  id: param_in-gsi
  inputBinding:
    prefix: -in-gsi
  label: Path to load gold standard intervals from. If compressed using gzip, the
    file will be decompressed on the fly.
  type: File
- doc: Path to load the read mapper SAM or BAM output from.
  id: param_in-bam
  inputBinding:
    prefix: -in-bam
  label: Path to load the read mapper SAM or BAM output from.
  type: File
- doc: Filename for out-tsv output file
  id: param_out-tsv_filename
  inputBinding:
    prefix: -out-tsv
  label: Filename for out-tsv output file
  type:
  - 'null'
  - string
- default: 'false'
  doc: Do not check sortedness (by name) of input SAM/BAM files.  This is required
    if the reads are not sorted by name in the original FASTQ files.  Files from the
    SRA and ENA generally are sorted.
  id: param_dont-check-sorting
  inputBinding:
    prefix: -dont-check-sorting
  label: Do not check sortedness (by name) of input SAM/BAM files.  This is required
    if the reads are not sorted by name in the original FASTQ files.  Files from the
    SRA and ENA generally are sorted.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Enable oracle mode.  This is used for simulated data when the input GSI file
    gives exactly one position that is considered as the true sample position.  For
    simulated data.
  id: param_oracle-mode
  inputBinding:
    prefix: -oracle-mode
  label: Enable oracle mode.  This is used for simulated data when the input GSI file
    gives exactly one position that is considered as the true sample position.  For
    simulated data.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Consider only reads that a single alignment in the mapping result file. Useful
    for precision computation.
  id: param_only-unique-reads
  inputBinding:
    prefix: -only-unique-reads
  label: Consider only reads that a single alignment in the mapping result file. Useful
    for precision computation.
  type:
  - 'null'
  - string
- default: 'false'
  doc: When set, N matches all characters without penalty.
  id: param_match-N
  inputBinding:
    prefix: -match-N
  label: When set, N matches all characters without penalty.
  type:
  - 'null'
  - string
- default: edit
  doc: 'Set distance metric.  Valid values: hamming, edit.  Default: edit.'
  id: param_distance-metric
  inputBinding:
    prefix: -distance-metric
  label: 'Set distance metric.  Valid values: hamming, edit.  Default: edit.'
  type:
  - 'null'
  - string
- default: '0'
  doc: 'Maximal error rate to build gold standard for in percent.  This parameter
    is an integer and relative to the read length.  The error rate is ignored in oracle
    mode, here the distance of the read at the sample position is taken, individually
    for each read.  Default: 0'
  id: param_max-error
  inputBinding:
    prefix: -max-error
  label: 'Maximal error rate to build gold standard for in percent.  This parameter
    is an integer and relative to the read length.  The error rate is ignored in oracle
    mode, here the distance of the read at the sample position is taken, individually
    for each read.  Default: 0'
  type:
  - 'null'
  - int
- default: all
  doc: 'Set benchmark category.  One of {all, all-best, any-best.  Default: all'
  id: param_benchmark-category
  inputBinding:
    prefix: -benchmark-category
  label: 'Set benchmark category.  One of {all, all-best, any-best.  Default: all'
  type:
  - 'null'
  - string
- default: 'false'
  doc: When set, we trust the alignment and distance from SAM/BAM file and no realignment
    is performed.  Off by default.
  id: param_trust-NM
  inputBinding:
    prefix: -trust-NM
  label: When set, we trust the alignment and distance from SAM/BAM file and no realignment
    is performed.  Off by default.
  type:
  - 'null'
  - string
- doc: If the CIGAR string is absent, the missing alignment end position can be provided
    by this BAM tag.
  id: param_extra-pos-tag
  inputBinding:
    prefix: -extra-pos-tag
  label: If the CIGAR string is absent, the missing alignment end position can be
    provided by this BAM tag.
  type:
  - 'null'
  - string
- default: 'false'
  doc: When set, we ignore all SAM/BAM flags related to pairing.  This is necessary
    when analyzing SAM from SOAP's soap2sam.pl script.
  id: param_ignore-paired-flags
  inputBinding:
    prefix: -ignore-paired-flags
  label: When set, we ignore all SAM/BAM flags related to pairing.  This is necessary
    when analyzing SAM from SOAP's soap2sam.pl script.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Do not stop program execution if an additional hit was found that indicates
    that the gold standard is incorrect.
  id: param_DONT-PANIC
  inputBinding:
    prefix: -DONT-PANIC
  label: Do not stop program execution if an additional hit was found that indicates
    that the gold standard is incorrect.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Show details for each missed interval from the GSI.
  id: param_show-missed-intervals
  inputBinding:
    prefix: -show-missed-intervals
  label: Show details for each missed interval from the GSI.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Show details for invalid hits (with too high error rate).
  id: param_show-invalid-hits
  inputBinding:
    prefix: -show-invalid-hits
  label: Show details for invalid hits (with too high error rate).
  type:
  - 'null'
  - string
- default: 'false'
  doc: Show details for additional hits (low enough error rate but not in gold standard.
  id: param_show-additional-hits
  inputBinding:
    prefix: -show-additional-hits
  label: Show details for additional hits (low enough error rate but not in gold standard.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Show details for hit intervals.
  id: param_show-hits
  inputBinding:
    prefix: -show-hits
  label: Show details for hit intervals.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Show details for each alignment in SAM/BAM input.
  id: param_show-try-hit
  inputBinding:
    prefix: -show-try-hit
  label: Show details for each alignment in SAM/BAM input.
  type:
  - 'null'
  - string
label: RABEMA Evaluation
outputs:
- doc: Path to write the statistics to as TSV.
  id: param_out-tsv
  label: Path to write the statistics to as TSV.
  outputBinding:
    glob: $(inputs.param_out-tsv_filename)
  type:
  - 'null'
  - File
