/* Printing.c generated by valac 0.34.2, the Vala compiler
 * generated from Printing.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <langinfo.h>
#include <gee.h>
#include <gio/gio.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>
#include <gobject/gvaluecollector.h>


#define TYPE_CONTENT_LAYOUT (content_layout_get_type ())

#define TYPE_PRINT_SETTINGS (print_settings_get_type ())
#define PRINT_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PRINT_SETTINGS, PrintSettings))
#define PRINT_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PRINT_SETTINGS, PrintSettingsClass))
#define IS_PRINT_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PRINT_SETTINGS))
#define IS_PRINT_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PRINT_SETTINGS))
#define PRINT_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PRINT_SETTINGS, PrintSettingsClass))

typedef struct _PrintSettings PrintSettings;
typedef struct _PrintSettingsClass PrintSettingsClass;
typedef struct _PrintSettingsPrivate PrintSettingsPrivate;

#define TYPE_MEASUREMENT (measurement_get_type ())

#define TYPE_MEASUREMENT_UNIT (measurement_unit_get_type ())
typedef struct _Measurement Measurement;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_PRINT_MANAGER (print_manager_get_type ())
#define PRINT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PRINT_MANAGER, PrintManager))
#define PRINT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PRINT_MANAGER, PrintManagerClass))
#define IS_PRINT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PRINT_MANAGER))
#define IS_PRINT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PRINT_MANAGER))
#define PRINT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PRINT_MANAGER, PrintManagerClass))

typedef struct _PrintManager PrintManager;
typedef struct _PrintManagerClass PrintManagerClass;

#define TYPE_STANDARD_PRINT_SIZE (standard_print_size_get_type ())
#define STANDARD_PRINT_SIZE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STANDARD_PRINT_SIZE, StandardPrintSize))
#define STANDARD_PRINT_SIZE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STANDARD_PRINT_SIZE, StandardPrintSizeClass))
#define IS_STANDARD_PRINT_SIZE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STANDARD_PRINT_SIZE))
#define IS_STANDARD_PRINT_SIZE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STANDARD_PRINT_SIZE))
#define STANDARD_PRINT_SIZE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STANDARD_PRINT_SIZE, StandardPrintSizeClass))

typedef struct _StandardPrintSize StandardPrintSize;
typedef struct _StandardPrintSizeClass StandardPrintSizeClass;
typedef struct _StandardPrintSizePrivate StandardPrintSizePrivate;
#define _print_manager_unref0(var) ((var == NULL) ? NULL : (var = (print_manager_unref (var), NULL)))
typedef struct _ParamSpecPrintSettings ParamSpecPrintSettings;

#define TYPE_PRINT_LAYOUT (print_layout_get_type ())

#define TYPE_CUSTOM_PRINT_TAB (custom_print_tab_get_type ())
#define CUSTOM_PRINT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOM_PRINT_TAB, CustomPrintTab))
#define CUSTOM_PRINT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOM_PRINT_TAB, CustomPrintTabClass))
#define IS_CUSTOM_PRINT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOM_PRINT_TAB))
#define IS_CUSTOM_PRINT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOM_PRINT_TAB))
#define CUSTOM_PRINT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOM_PRINT_TAB, CustomPrintTabClass))

typedef struct _CustomPrintTab CustomPrintTab;
typedef struct _CustomPrintTabClass CustomPrintTabClass;
typedef struct _CustomPrintTabPrivate CustomPrintTabPrivate;

#define TYPE_PRINT_JOB (print_job_get_type ())
#define PRINT_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PRINT_JOB, PrintJob))
#define PRINT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PRINT_JOB, PrintJobClass))
#define IS_PRINT_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PRINT_JOB))
#define IS_PRINT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PRINT_JOB))
#define PRINT_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PRINT_JOB, PrintJobClass))

typedef struct _PrintJob PrintJob;
typedef struct _PrintJobClass PrintJobClass;
#define _standard_print_size_unref0(var) ((var == NULL) ? NULL : (var = (standard_print_size_unref (var), NULL)))
#define _print_settings_unref0(var) ((var == NULL) ? NULL : (var = (print_settings_unref (var), NULL)))
typedef struct _PrintJobPrivate PrintJobPrivate;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define PHOTO_TYPE_EXCEPTION (photo_exception_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
typedef struct _ParamSpecStandardPrintSize ParamSpecStandardPrintSize;
typedef struct _PrintManagerPrivate PrintManagerPrivate;

#define TYPE_PROGRESS_DIALOG (progress_dialog_get_type ())
#define PROGRESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROGRESS_DIALOG, ProgressDialog))
#define PROGRESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROGRESS_DIALOG, ProgressDialogClass))
#define IS_PROGRESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROGRESS_DIALOG))
#define IS_PROGRESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROGRESS_DIALOG))
#define PROGRESS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROGRESS_DIALOG, ProgressDialogClass))

typedef struct _ProgressDialog ProgressDialog;
typedef struct _ProgressDialogClass ProgressDialogClass;

#define TYPE_PAGE_WINDOW (page_window_get_type ())
#define PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_WINDOW, PageWindow))
#define PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_WINDOW, PageWindowClass))
#define IS_PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_WINDOW))
#define IS_PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_WINDOW))
#define PAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_WINDOW, PageWindowClass))

typedef struct _PageWindow PageWindow;
typedef struct _PageWindowClass PageWindowClass;

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

#define TYPE_SCALING (scaling_get_type ())

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())
typedef struct _Scaling Scaling;
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
typedef struct _ParamSpecPrintManager ParamSpecPrintManager;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	CONTENT_LAYOUT_STANDARD_SIZE,
	CONTENT_LAYOUT_CUSTOM_SIZE,
	CONTENT_LAYOUT_IMAGE_PER_PAGE
} ContentLayout;

struct _PrintSettings {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PrintSettingsPrivate * priv;
};

struct _PrintSettingsClass {
	GTypeClass parent_class;
	void (*finalize) (PrintSettings *self);
};

typedef enum  {
	MEASUREMENT_UNIT_INCHES,
	MEASUREMENT_UNIT_CENTIMETERS
} MeasurementUnit;

struct _Measurement {
	gdouble value;
	MeasurementUnit unit;
};

struct _PrintSettingsPrivate {
	ContentLayout content_layout;
	Measurement content_width;
	Measurement content_height;
	gint content_ppi;
	gint image_per_page_selection;
	gint size_selection;
	gboolean match_aspect_ratio;
	gboolean print_titles;
	gchar* print_titles_font;
};

struct _StandardPrintSize {
	GTypeInstance parent_instance;
	volatile int ref_count;
	StandardPrintSizePrivate * priv;
	gchar* name;
	Measurement width;
	Measurement height;
};

struct _StandardPrintSizeClass {
	GTypeClass parent_class;
	void (*finalize) (StandardPrintSize *self);
};

struct _ParamSpecPrintSettings {
	GParamSpec parent_instance;
};

typedef enum  {
	PRINT_LAYOUT_ENTIRE_PAGE,
	PRINT_LAYOUT_TWO_PER_PAGE,
	PRINT_LAYOUT_FOUR_PER_PAGE,
	PRINT_LAYOUT_SIX_PER_PAGE,
	PRINT_LAYOUT_EIGHT_PER_PAGE,
	PRINT_LAYOUT_SIXTEEN_PER_PAGE,
	PRINT_LAYOUT_THIRTY_TWO_PER_PAGE
} PrintLayout;

struct _CustomPrintTab {
	GtkFixed parent_instance;
	CustomPrintTabPrivate * priv;
};

struct _CustomPrintTabClass {
	GtkFixedClass parent_class;
};

struct _CustomPrintTabPrivate {
	GtkBox* custom_image_settings_pane;
	GtkRadioButton* standard_size_radio;
	GtkRadioButton* custom_size_radio;
	GtkRadioButton* image_per_page_radio;
	GtkComboBox* image_per_page_combo;
	GtkComboBox* standard_sizes_combo;
	GtkComboBoxText* units_combo;
	GtkEntry* custom_width_entry;
	GtkEntry* custom_height_entry;
	GtkEntry* ppi_entry;
	GtkCheckButton* aspect_ratio_check;
	GtkCheckButton* title_print_check;
	GtkFontButton* title_print_font;
	Measurement local_content_width;
	Measurement local_content_height;
	gint local_content_ppi;
	gboolean is_text_insertion_in_progress;
	PrintJob* source_job;
};

struct _PrintJob {
	GtkPrintOperation parent_instance;
	PrintJobPrivate * priv;
};

struct _PrintJobClass {
	GtkPrintOperationClass parent_class;
};

struct _PrintJobPrivate {
	PrintSettings* settings;
	GeeArrayList* photos;
};

typedef enum  {
	PHOTO_EXCEPTION_NONE = 0,
	PHOTO_EXCEPTION_ORIENTATION = 1 << 0,
	PHOTO_EXCEPTION_CROP = 1 << 1,
	PHOTO_EXCEPTION_REDEYE = 1 << 2,
	PHOTO_EXCEPTION_ADJUST = 1 << 3,
	PHOTO_EXCEPTION_STRAIGHTEN = 1 << 4,
	PHOTO_EXCEPTION_ALL = 0xFFFFFFFFLL
} PhotoException;

struct _Dimensions {
	gint width;
	gint height;
};

struct _ParamSpecStandardPrintSize {
	GParamSpec parent_instance;
};

struct _PrintManager {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PrintManagerPrivate * priv;
};

struct _PrintManagerClass {
	GTypeClass parent_class;
	void (*finalize) (PrintManager *self);
};

struct _PrintManagerPrivate {
	PrintSettings* settings;
	GtkPageSetup* user_page_setup;
	CustomPrintTab* custom_tab;
	ProgressDialog* progress_dialog;
	GCancellable* cancellable;
};

typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

struct _ParamSpecPrintManager {
	GParamSpec parent_instance;
};


static gpointer print_settings_parent_class = NULL;
static gpointer custom_print_tab_parent_class = NULL;
static gpointer print_job_parent_class = NULL;
static gpointer standard_print_size_parent_class = NULL;
static gpointer print_manager_parent_class = NULL;
static PrintManager* print_manager_instance;
static PrintManager* print_manager_instance = NULL;

GType content_layout_get_type (void) G_GNUC_CONST;
gpointer print_settings_ref (gpointer instance);
void print_settings_unref (gpointer instance);
GParamSpec* param_spec_print_settings (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_print_settings (GValue* value, gpointer v_object);
void value_take_print_settings (GValue* value, gpointer v_object);
gpointer value_get_print_settings (const GValue* value);
GType print_settings_get_type (void) G_GNUC_CONST;
GType measurement_get_type (void) G_GNUC_CONST;
GType measurement_unit_get_type (void) G_GNUC_CONST;
Measurement* measurement_dup (const Measurement* self);
void measurement_free (Measurement* self);
#define PRINT_SETTINGS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PRINT_SETTINGS, PrintSettingsPrivate))
enum  {
	PRINT_SETTINGS_DUMMY_PROPERTY
};
#define PRINT_SETTINGS_MIN_CONTENT_PPI 72
#define PRINT_SETTINGS_MAX_CONTENT_PPI 1200
PrintSettings* print_settings_new (void);
PrintSettings* print_settings_construct (GType object_type);
GType configuration_facade_get_type (void) G_GNUC_CONST;
GType config_facade_get_type (void) G_GNUC_CONST;
ConfigFacade* config_facade_get_instance (void);
gint configuration_facade_get_printing_content_units (ConfigurationFacade* self);
gdouble configuration_facade_get_printing_content_width (ConfigurationFacade* self);
void measurement_init (Measurement *self, gdouble value, MeasurementUnit unit);
gdouble configuration_facade_get_printing_content_height (ConfigurationFacade* self);
gint configuration_facade_get_printing_size_selection (ConfigurationFacade* self);
gint configuration_facade_get_printing_content_layout (ConfigurationFacade* self);
gboolean configuration_facade_get_printing_match_aspect_ratio (ConfigurationFacade* self);
gboolean configuration_facade_get_printing_print_titles (ConfigurationFacade* self);
gchar* configuration_facade_get_printing_titles_font (ConfigurationFacade* self);
gint configuration_facade_get_printing_images_per_page (ConfigurationFacade* self);
gint configuration_facade_get_printing_content_ppi (ConfigurationFacade* self);
void print_settings_save (PrintSettings* self);
void configuration_facade_set_printing_content_units (ConfigurationFacade* self, gint units_code);
void configuration_facade_set_printing_content_width (ConfigurationFacade* self, gdouble content_width);
void configuration_facade_set_printing_content_height (ConfigurationFacade* self, gdouble content_height);
void configuration_facade_set_printing_size_selection (ConfigurationFacade* self, gint size_code);
void configuration_facade_set_printing_content_layout (ConfigurationFacade* self, gint layout_code);
void configuration_facade_set_printing_match_aspect_ratio (ConfigurationFacade* self, gboolean match_aspect_ratio);
void configuration_facade_set_printing_print_titles (ConfigurationFacade* self, gboolean print_titles);
void configuration_facade_set_printing_titles_font (ConfigurationFacade* self, const gchar* font_name);
void configuration_facade_set_printing_images_per_page (ConfigurationFacade* self, gint images_per_page_code);
void configuration_facade_set_printing_content_ppi (ConfigurationFacade* self, gint content_ppi);
void print_settings_get_content_width (PrintSettings* self, Measurement* result);
ContentLayout print_settings_get_content_layout (PrintSettings* self);
gpointer print_manager_ref (gpointer instance);
void print_manager_unref (gpointer instance);
GParamSpec* param_spec_print_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_print_manager (GValue* value, gpointer v_object);
void value_take_print_manager (GValue* value, gpointer v_object);
gpointer value_get_print_manager (const GValue* value);
GType print_manager_get_type (void) G_GNUC_CONST;
PrintManager* print_manager_get_instance (void);
gpointer standard_print_size_ref (gpointer instance);
void standard_print_size_unref (gpointer instance);
GParamSpec* param_spec_standard_print_size (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_standard_print_size (GValue* value, gpointer v_object);
void value_take_standard_print_size (GValue* value, gpointer v_object);
gpointer value_get_standard_print_size (const GValue* value);
GType standard_print_size_get_type (void) G_GNUC_CONST;
StandardPrintSize** print_manager_get_standard_sizes (PrintManager* self, int* result_length1);
gint print_settings_get_size_selection (PrintSettings* self);
void print_settings_get_content_height (PrintSettings* self, Measurement* result);
void print_settings_get_minimum_content_dimension (PrintSettings* self, Measurement* result);
void print_settings_get_maximum_content_dimension (PrintSettings* self, Measurement* result);
gboolean print_settings_is_match_aspect_ratio_enabled (PrintSettings* self);
gboolean print_settings_is_print_titles_enabled (PrintSettings* self);
gint print_settings_get_content_ppi (PrintSettings* self);
gint print_settings_get_image_per_page_selection (PrintSettings* self);
void print_settings_set_content_layout (PrintSettings* self, ContentLayout content_layout);
void print_settings_set_content_width (PrintSettings* self, Measurement* content_width);
void print_settings_set_content_height (PrintSettings* self, Measurement* content_height);
void print_settings_set_content_ppi (PrintSettings* self, gint content_ppi);
void print_settings_set_image_per_page_selection (PrintSettings* self, gint image_per_page_selection);
void print_settings_set_size_selection (PrintSettings* self, gint size_selection);
void print_settings_set_match_aspect_ratio_enabled (PrintSettings* self, gboolean enable_state);
void print_settings_set_print_titles_enabled (PrintSettings* self, gboolean print_titles);
void print_settings_set_print_titles_font (PrintSettings* self, const gchar* fontname);
gchar* print_settings_get_print_titles_font (PrintSettings* self);
static void print_settings_finalize (PrintSettings* obj);
#define MEASUREMENT_CENTIMETERS_PER_INCH 2.54
#define MEASUREMENT_INCHES_PER_CENTIMETER (1.0 / 2.54)
void measurement_convert_to (Measurement *self, MeasurementUnit to_unit, Measurement* result);
gboolean measurement_is_less_than (Measurement *self, Measurement* rhs);
gboolean measurement_is_greater_than (Measurement *self, Measurement* rhs);
GType print_layout_get_type (void) G_GNUC_CONST;
PrintLayout* print_layout_get_all (int* result_length1);
gint print_layout_get_per_page (PrintLayout self);
gint print_layout_get_x (PrintLayout self);
gint print_layout_get_y (PrintLayout self);
gchar* print_layout_to_string (PrintLayout self);
GType custom_print_tab_get_type (void) G_GNUC_CONST;
GType print_job_get_type (void) G_GNUC_CONST;
#define CUSTOM_PRINT_TAB_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CUSTOM_PRINT_TAB, CustomPrintTabPrivate))
enum  {
	CUSTOM_PRINT_TAB_DUMMY_PROPERTY
};
#define CUSTOM_PRINT_TAB_INCHES_COMBO_CHOICE 0
#define CUSTOM_PRINT_TAB_CENTIMETERS_COMBO_CHOICE 1
CustomPrintTab* custom_print_tab_new (PrintJob* source_job);
CustomPrintTab* custom_print_tab_construct (GType object_type, PrintJob* source_job);
GtkBuilder* app_window_create_builder (const gchar* glade_filename, void* user);
static void custom_print_tab_on_radio_group_click (CustomPrintTab* self, GtkButton* b);
static void _custom_print_tab_on_radio_group_click_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean custom_print_tab_standard_sizes_combo_separator_func (GtkTreeModel* model, GtkTreeIter* iter);
static gboolean _custom_print_tab_standard_sizes_combo_separator_func_gtk_tree_view_row_separator_func (GtkTreeModel* model, GtkTreeIter* iter, gpointer self);
static void custom_print_tab_on_entry_insert_text (CustomPrintTab* self, GtkEditable* editable, const gchar* text, gint length, gint* position);
static void _custom_print_tab_on_entry_insert_text_gtk_editable_insert_text (GtkEditable* _sender, const gchar* new_text, gint new_text_length, gint* position, gpointer self);
static gboolean custom_print_tab_on_width_entry_focus_out (CustomPrintTab* self, GdkEventFocus* event);
static gboolean _custom_print_tab_on_width_entry_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static gboolean custom_print_tab_on_height_entry_focus_out (CustomPrintTab* self, GdkEventFocus* event);
static gboolean _custom_print_tab_on_height_entry_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void custom_print_tab_on_units_combo_changed (CustomPrintTab* self);
static void _custom_print_tab_on_units_combo_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void custom_print_tab_on_ppi_entry_insert_text (CustomPrintTab* self, GtkEditable* editable, const gchar* text, gint length, gint* position);
static void _custom_print_tab_on_ppi_entry_insert_text_gtk_editable_insert_text (GtkEditable* _sender, const gchar* new_text, gint new_text_length, gint* position, gpointer self);
static gboolean custom_print_tab_on_ppi_entry_focus_out (CustomPrintTab* self, GdkEventFocus* event);
static gboolean _custom_print_tab_on_ppi_entry_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void custom_print_tab_sync_state_from_job (CustomPrintTab* self, PrintJob* job);
static void custom_print_tab_on_aspect_ratio_check_clicked (CustomPrintTab* self);
static void _custom_print_tab_on_aspect_ratio_check_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
gdouble print_job_get_source_aspect_ratio (PrintJob* self);
static gchar* custom_print_tab_format_measurement (CustomPrintTab* self, Measurement* measurement);
static gchar* custom_print_tab_format_measurement_as (CustomPrintTab* self, Measurement* measurement, MeasurementUnit to_unit);
static MeasurementUnit custom_print_tab_get_user_unit_choice (CustomPrintTab* self);
static void custom_print_tab_get_width_entry_value (CustomPrintTab* self, Measurement* result);
PrintSettings* print_job_get_local_settings (PrintJob* self);
static gboolean custom_print_tab_is_match_aspect_ratio_enabled (CustomPrintTab* self);
static void custom_print_tab_set_content_ppi (CustomPrintTab* self, gint content_ppi);
static void custom_print_tab_get_height_entry_value (CustomPrintTab* self, Measurement* result);
static void custom_print_tab_set_user_unit_choice (CustomPrintTab* self, MeasurementUnit unit);
static void custom_print_tab_set_content_width (CustomPrintTab* self, Measurement* content_width);
static void custom_print_tab_set_content_height (CustomPrintTab* self, Measurement* content_height);
static void custom_print_tab_set_content_layout (CustomPrintTab* self, ContentLayout content_layout);
static void custom_print_tab_set_image_per_page_selection (CustomPrintTab* self, gint image_per_page);
static void custom_print_tab_set_size_selection (CustomPrintTab* self, gint size_selection);
static void custom_print_tab_set_match_aspect_ratio_enabled (CustomPrintTab* self, gboolean enable_state);
static void custom_print_tab_set_print_titles_enabled (CustomPrintTab* self, gboolean print_titles);
static void custom_print_tab_set_print_titles_font (CustomPrintTab* self, const gchar* fontname);
static void custom_print_tab_set_content_layout_control_state (CustomPrintTab* self, ContentLayout layout);
static ContentLayout custom_print_tab_get_content_layout (CustomPrintTab* self);
static void custom_print_tab_get_content_width (CustomPrintTab* self, Measurement* result);
static void custom_print_tab_get_content_height (CustomPrintTab* self, Measurement* result);
static gint custom_print_tab_get_content_ppi (CustomPrintTab* self);
static gint custom_print_tab_get_image_per_page_selection (CustomPrintTab* self);
static gint custom_print_tab_get_size_selection (CustomPrintTab* self);
static gboolean custom_print_tab_is_print_titles_enabled (CustomPrintTab* self);
static gchar* custom_print_tab_get_print_titles_font (CustomPrintTab* self);
PrintJob* custom_print_tab_get_source_job (CustomPrintTab* self);
PrintSettings* custom_print_tab_get_local_settings (CustomPrintTab* self);
static void custom_print_tab_finalize (GObject* obj);
GType data_object_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
GType photo_source_get_type (void) G_GNUC_CONST;
GType photo_get_type (void) G_GNUC_CONST;
#define PRINT_JOB_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PRINT_JOB, PrintJobPrivate))
enum  {
	PRINT_JOB_DUMMY_PROPERTY
};
PrintJob* print_job_new (GeeCollection* to_print);
PrintJob* print_job_construct (GType object_type, GeeCollection* to_print);
PrintSettings* print_manager_get_global_settings (PrintManager* self);
GType photo_exception_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
void media_source_get_dimensions (MediaSource* self, PhotoException disallowed_steps, Dimensions* result);
gdouble dimensions_get_aspect_ratio (Dimensions *self);
GeeList* print_job_get_photos (PrintJob* self);
Photo* print_job_get_source_photo (PrintJob* self);
void print_job_set_local_settings (PrintJob* self, PrintSettings* settings);
static void print_job_finalize (GObject* obj);
enum  {
	STANDARD_PRINT_SIZE_DUMMY_PROPERTY
};
StandardPrintSize* standard_print_size_new (const gchar* name, Measurement* width, Measurement* height);
StandardPrintSize* standard_print_size_construct (GType object_type, const gchar* name, Measurement* width, Measurement* height);
static void standard_print_size_finalize (StandardPrintSize* obj);
GType progress_dialog_get_type (void) G_GNUC_CONST;
#define PRINT_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PRINT_MANAGER, PrintManagerPrivate))
enum  {
	PRINT_MANAGER_DUMMY_PROPERTY
};
#define PRINT_MANAGER_IMAGE_DISTANCE 0.24
static PrintManager* print_manager_new (void);
static PrintManager* print_manager_construct (GType object_type);
static void _vala_array_add112 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value);
static void _vala_array_add113 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value);
static void _vala_array_add114 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value);
static void _vala_array_add115 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value);
static void _vala_array_add116 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value);
static void _vala_array_add117 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value);
static void _vala_array_add118 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value);
static void _vala_array_add119 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value);
static void _vala_array_add120 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value);
static void _vala_array_add121 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value);
static void _vala_array_add122 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value);
static void _vala_array_add123 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value);
static void _vala_array_add124 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value);
static void _vala_array_add125 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value);
static void _vala_array_add126 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value);
void print_manager_spool_photo (PrintManager* self, GeeCollection* to_print);
gchar* data_object_get_name (DataObject* self);
static void print_manager_on_begin_print (PrintManager* self, GtkPrintOperation* emitting_object, GtkPrintContext* job_context);
static void _print_manager_on_begin_print_gtk_print_operation_begin_print (GtkPrintOperation* _sender, GtkPrintContext* context, gpointer self);
static void print_manager_on_draw_page (PrintManager* self, GtkPrintOperation* emitting_object, GtkPrintContext* job_context, gint page_num);
static void _print_manager_on_draw_page_gtk_print_operation_draw_page (GtkPrintOperation* _sender, GtkPrintContext* context, gint page_nr, gpointer self);
static GObject* print_manager_on_create_custom_widget (PrintManager* self, GtkPrintOperation* emitting_object);
static GObject* _print_manager_on_create_custom_widget_gtk_print_operation_create_custom_widget (GtkPrintOperation* _sender, gpointer self);
static void print_manager_on_status_changed (PrintManager* self, GtkPrintOperation* job);
static void _print_manager_on_status_changed_gtk_print_operation_status_changed (GtkPrintOperation* _sender, gpointer self);
GType page_window_get_type (void) G_GNUC_CONST;
GType app_window_get_type (void) G_GNUC_CONST;
AppWindow* app_window_get_instance (void);
void page_window_set_busy_cursor (PageWindow* self);
ProgressDialog* progress_dialog_new (GtkWindow* owner, const gchar* text, GCancellable* cancellable);
ProgressDialog* progress_dialog_construct (GType object_type, GtkWindow* owner, const gchar* text, GCancellable* cancellable);
void progress_dialog_close (ProgressDialog* self);
void page_window_set_normal_cursor (PageWindow* self);
void app_window_error_message (const gchar* message, GtkWindow* parent);
void spin_event_loop (void);
void progress_dialog_set_status (ProgressDialog* self, const gchar* text);
static void print_manager_fit_image_to_canvas (PrintManager* self, Photo* photo, gdouble x, gdouble y, gdouble canvas_width, gdouble canvas_height, gboolean crop, PrintJob* job, GtkPrintContext* job_context);
static void print_manager_add_title_to_canvas (PrintManager* self, gdouble x, gdouble y, const gchar* title, PrintJob* job, GtkPrintContext* job_context);
gboolean progress_dialog_monitor (ProgressDialog* self, guint64 count, guint64 total, gboolean do_event_loop);
static void print_manager_on_custom_widget_apply (PrintManager* self, GtkWidget* custom_widget);
static void _print_manager_on_custom_widget_apply_gtk_print_operation_custom_widget_apply (GtkPrintOperation* _sender, GtkWidget* widget, gpointer self);
void print_manager_set_global_settings (PrintManager* self, PrintSettings* settings);
void dimensions_init (Dimensions *self, gint width, gint height);
static gboolean print_manager_are_approximately_equal (PrintManager* self, gdouble val1, gdouble val2);
GType scaling_get_type (void) G_GNUC_CONST;
GType scale_constraint_get_type (void) G_GNUC_CONST;
Scaling* scaling_dup (const Scaling* self);
void scaling_free (Scaling* self);
void scaling_to_fill_viewport (Dimensions* viewport, Scaling* result);
GdkPixbuf* photo_source_get_pixbuf (PhotoSource* self, Scaling* scaling, GError** error);
void dimensions_for_pixbuf (GdkPixbuf* pixbuf, Dimensions* result);
GdkPixbuf* scaling_perform_on_pixbuf (Scaling *self, GdkPixbuf* pixbuf, GdkInterpType interp, gboolean scale_up);
void scaling_for_viewport (Dimensions* viewport, gboolean scale_up, Scaling* result);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static void print_manager_finalize (PrintManager* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType content_layout_get_type (void) {
	static volatile gsize content_layout_type_id__volatile = 0;
	if (g_once_init_enter (&content_layout_type_id__volatile)) {
		static const GEnumValue values[] = {{CONTENT_LAYOUT_STANDARD_SIZE, "CONTENT_LAYOUT_STANDARD_SIZE", "standard-size"}, {CONTENT_LAYOUT_CUSTOM_SIZE, "CONTENT_LAYOUT_CUSTOM_SIZE", "custom-size"}, {CONTENT_LAYOUT_IMAGE_PER_PAGE, "CONTENT_LAYOUT_IMAGE_PER_PAGE", "image-per-page"}, {0, NULL, NULL}};
		GType content_layout_type_id;
		content_layout_type_id = g_enum_register_static ("ContentLayout", values);
		g_once_init_leave (&content_layout_type_id__volatile, content_layout_type_id);
	}
	return content_layout_type_id__volatile;
}


PrintSettings* print_settings_construct (GType object_type) {
	PrintSettings* self = NULL;
	ConfigFacade* config = NULL;
	ConfigFacade* _tmp0_ = NULL;
	MeasurementUnit units = 0;
	gint _tmp1_ = 0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
#line 30 "/home/jens/Source/shotwell/src/Printing.vala"
	self = (PrintSettings*) g_type_create_instance (object_type);
#line 31 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = config_facade_get_instance ();
#line 31 "/home/jens/Source/shotwell/src/Printing.vala"
	config = _tmp0_;
#line 33 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = configuration_facade_get_printing_content_units (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 33 "/home/jens/Source/shotwell/src/Printing.vala"
	units = (MeasurementUnit) _tmp1_;
#line 35 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = configuration_facade_get_printing_content_width (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 35 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&self->priv->content_width, _tmp2_, units);
#line 36 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = configuration_facade_get_printing_content_height (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 36 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&self->priv->content_height, _tmp3_, units);
#line 37 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = configuration_facade_get_printing_size_selection (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 37 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->size_selection = _tmp4_;
#line 38 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = configuration_facade_get_printing_content_layout (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 38 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->content_layout = (ContentLayout) _tmp5_;
#line 39 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = configuration_facade_get_printing_match_aspect_ratio (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 39 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->match_aspect_ratio = _tmp6_;
#line 40 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = configuration_facade_get_printing_print_titles (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 40 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->print_titles = _tmp7_;
#line 41 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = configuration_facade_get_printing_titles_font (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 41 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (self->priv->print_titles_font);
#line 41 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->print_titles_font = _tmp8_;
#line 42 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = configuration_facade_get_printing_images_per_page (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 42 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->image_per_page_selection = _tmp9_;
#line 43 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = configuration_facade_get_printing_content_ppi (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 43 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->content_ppi = _tmp10_;
#line 30 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (config);
#line 30 "/home/jens/Source/shotwell/src/Printing.vala"
	return self;
#line 734 "Printing.c"
}


PrintSettings* print_settings_new (void) {
#line 30 "/home/jens/Source/shotwell/src/Printing.vala"
	return print_settings_construct (TYPE_PRINT_SETTINGS);
#line 741 "Printing.c"
}


void print_settings_save (PrintSettings* self) {
	ConfigFacade* config = NULL;
	ConfigFacade* _tmp0_ = NULL;
	Measurement _tmp1_ = {0};
	MeasurementUnit _tmp2_ = 0;
	Measurement _tmp3_ = {0};
	gdouble _tmp4_ = 0.0;
	Measurement _tmp5_ = {0};
	gdouble _tmp6_ = 0.0;
	gint _tmp7_ = 0;
	ContentLayout _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
#line 46 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 47 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = config_facade_get_instance ();
#line 47 "/home/jens/Source/shotwell/src/Printing.vala"
	config = _tmp0_;
#line 49 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = self->priv->content_width;
#line 49 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = _tmp1_.unit;
#line 49 "/home/jens/Source/shotwell/src/Printing.vala"
	configuration_facade_set_printing_content_units (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), (gint) _tmp2_);
#line 50 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = self->priv->content_width;
#line 50 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = _tmp3_.value;
#line 50 "/home/jens/Source/shotwell/src/Printing.vala"
	configuration_facade_set_printing_content_width (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp4_);
#line 51 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = self->priv->content_height;
#line 51 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = _tmp5_.value;
#line 51 "/home/jens/Source/shotwell/src/Printing.vala"
	configuration_facade_set_printing_content_height (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp6_);
#line 52 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = self->priv->size_selection;
#line 52 "/home/jens/Source/shotwell/src/Printing.vala"
	configuration_facade_set_printing_size_selection (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp7_);
#line 53 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = self->priv->content_layout;
#line 53 "/home/jens/Source/shotwell/src/Printing.vala"
	configuration_facade_set_printing_content_layout (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), (gint) _tmp8_);
#line 54 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = self->priv->match_aspect_ratio;
#line 54 "/home/jens/Source/shotwell/src/Printing.vala"
	configuration_facade_set_printing_match_aspect_ratio (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp9_);
#line 55 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = self->priv->print_titles;
#line 55 "/home/jens/Source/shotwell/src/Printing.vala"
	configuration_facade_set_printing_print_titles (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp10_);
#line 56 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp11_ = self->priv->print_titles_font;
#line 56 "/home/jens/Source/shotwell/src/Printing.vala"
	configuration_facade_set_printing_titles_font (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp11_);
#line 57 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp12_ = self->priv->image_per_page_selection;
#line 57 "/home/jens/Source/shotwell/src/Printing.vala"
	configuration_facade_set_printing_images_per_page (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp12_);
#line 58 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp13_ = self->priv->content_ppi;
#line 58 "/home/jens/Source/shotwell/src/Printing.vala"
	configuration_facade_set_printing_content_ppi (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp13_);
#line 46 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (config);
#line 815 "Printing.c"
}


void print_settings_get_content_width (PrintSettings* self, Measurement* result) {
	ContentLayout _tmp0_ = 0;
#line 62 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 63 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = print_settings_get_content_layout (self);
#line 63 "/home/jens/Source/shotwell/src/Printing.vala"
	switch (_tmp0_) {
#line 63 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_STANDARD_SIZE:
#line 63 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_IMAGE_PER_PAGE:
#line 831 "Printing.c"
		{
			PrintManager* _tmp1_ = NULL;
			PrintManager* _tmp2_ = NULL;
			gint _tmp3_ = 0;
			StandardPrintSize** _tmp4_ = NULL;
			StandardPrintSize** _tmp5_ = NULL;
			gint _tmp5__length1 = 0;
			gint _tmp6_ = 0;
			StandardPrintSize* _tmp7_ = NULL;
			Measurement _tmp8_ = {0};
			Measurement _tmp9_ = {0};
#line 66 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp1_ = print_manager_get_instance ();
#line 66 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp2_ = _tmp1_;
#line 66 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp4_ = print_manager_get_standard_sizes (_tmp2_, &_tmp3_);
#line 66 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp5_ = _tmp4_;
#line 66 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp5__length1 = _tmp3_;
#line 66 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp6_ = print_settings_get_size_selection (self);
#line 66 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp7_ = _tmp5_[_tmp6_];
#line 66 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp8_ = _tmp7_->width;
#line 66 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp9_ = _tmp8_;
#line 66 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) standard_print_size_unref), NULL);
#line 66 "/home/jens/Source/shotwell/src/Printing.vala"
			_print_manager_unref0 (_tmp2_);
#line 66 "/home/jens/Source/shotwell/src/Printing.vala"
			*result = _tmp9_;
#line 66 "/home/jens/Source/shotwell/src/Printing.vala"
			return;
#line 869 "Printing.c"
		}
#line 63 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_CUSTOM_SIZE:
#line 873 "Printing.c"
		{
			Measurement _tmp10_ = {0};
#line 70 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp10_ = self->priv->content_width;
#line 70 "/home/jens/Source/shotwell/src/Printing.vala"
			*result = _tmp10_;
#line 70 "/home/jens/Source/shotwell/src/Printing.vala"
			return;
#line 882 "Printing.c"
		}
		default:
		{
#line 73 "/home/jens/Source/shotwell/src/Printing.vala"
			g_error ("Printing.vala:73: unknown ContentLayout enumeration value");
#line 888 "Printing.c"
		}
	}
}


void print_settings_get_content_height (PrintSettings* self, Measurement* result) {
	ContentLayout _tmp0_ = 0;
#line 77 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 78 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = print_settings_get_content_layout (self);
#line 78 "/home/jens/Source/shotwell/src/Printing.vala"
	switch (_tmp0_) {
#line 78 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_STANDARD_SIZE:
#line 78 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_IMAGE_PER_PAGE:
#line 906 "Printing.c"
		{
			PrintManager* _tmp1_ = NULL;
			PrintManager* _tmp2_ = NULL;
			gint _tmp3_ = 0;
			StandardPrintSize** _tmp4_ = NULL;
			StandardPrintSize** _tmp5_ = NULL;
			gint _tmp5__length1 = 0;
			gint _tmp6_ = 0;
			StandardPrintSize* _tmp7_ = NULL;
			Measurement _tmp8_ = {0};
			Measurement _tmp9_ = {0};
#line 81 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp1_ = print_manager_get_instance ();
#line 81 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp2_ = _tmp1_;
#line 81 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp4_ = print_manager_get_standard_sizes (_tmp2_, &_tmp3_);
#line 81 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp5_ = _tmp4_;
#line 81 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp5__length1 = _tmp3_;
#line 81 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp6_ = print_settings_get_size_selection (self);
#line 81 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp7_ = _tmp5_[_tmp6_];
#line 81 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp8_ = _tmp7_->height;
#line 81 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp9_ = _tmp8_;
#line 81 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) standard_print_size_unref), NULL);
#line 81 "/home/jens/Source/shotwell/src/Printing.vala"
			_print_manager_unref0 (_tmp2_);
#line 81 "/home/jens/Source/shotwell/src/Printing.vala"
			*result = _tmp9_;
#line 81 "/home/jens/Source/shotwell/src/Printing.vala"
			return;
#line 944 "Printing.c"
		}
#line 78 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_CUSTOM_SIZE:
#line 948 "Printing.c"
		{
			Measurement _tmp10_ = {0};
#line 85 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp10_ = self->priv->content_height;
#line 85 "/home/jens/Source/shotwell/src/Printing.vala"
			*result = _tmp10_;
#line 85 "/home/jens/Source/shotwell/src/Printing.vala"
			return;
#line 957 "Printing.c"
		}
		default:
		{
#line 88 "/home/jens/Source/shotwell/src/Printing.vala"
			g_error ("Printing.vala:88: unknown ContentLayout enumeration value");
#line 963 "Printing.c"
		}
	}
}


void print_settings_get_minimum_content_dimension (PrintSettings* self, Measurement* result) {
	Measurement _tmp0_ = {0};
#line 92 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 93 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp0_, 0.5, MEASUREMENT_UNIT_INCHES);
#line 93 "/home/jens/Source/shotwell/src/Printing.vala"
	*result = _tmp0_;
#line 93 "/home/jens/Source/shotwell/src/Printing.vala"
	return;
#line 979 "Printing.c"
}


void print_settings_get_maximum_content_dimension (PrintSettings* self, Measurement* result) {
	Measurement _tmp0_ = {0};
#line 96 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 97 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp0_, (gdouble) 30, MEASUREMENT_UNIT_INCHES);
#line 97 "/home/jens/Source/shotwell/src/Printing.vala"
	*result = _tmp0_;
#line 97 "/home/jens/Source/shotwell/src/Printing.vala"
	return;
#line 993 "Printing.c"
}


gboolean print_settings_is_match_aspect_ratio_enabled (PrintSettings* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 100 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_SETTINGS (self), FALSE);
#line 101 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->match_aspect_ratio;
#line 101 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp0_;
#line 101 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1008 "Printing.c"
}


gboolean print_settings_is_print_titles_enabled (PrintSettings* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 104 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_SETTINGS (self), FALSE);
#line 105 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->print_titles;
#line 105 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp0_;
#line 105 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1023 "Printing.c"
}


gint print_settings_get_content_ppi (PrintSettings* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 108 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_SETTINGS (self), 0);
#line 109 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->content_ppi;
#line 109 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp0_;
#line 109 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1038 "Printing.c"
}


gint print_settings_get_image_per_page_selection (PrintSettings* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 112 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_SETTINGS (self), 0);
#line 113 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->image_per_page_selection;
#line 113 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp0_;
#line 113 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1053 "Printing.c"
}


gint print_settings_get_size_selection (PrintSettings* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 116 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_SETTINGS (self), 0);
#line 117 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->size_selection;
#line 117 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp0_;
#line 117 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1068 "Printing.c"
}


ContentLayout print_settings_get_content_layout (PrintSettings* self) {
	ContentLayout result = 0;
	ContentLayout _tmp0_ = 0;
#line 120 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_SETTINGS (self), 0);
#line 121 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->content_layout;
#line 121 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp0_;
#line 121 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1083 "Printing.c"
}


void print_settings_set_content_layout (PrintSettings* self, ContentLayout content_layout) {
	ContentLayout _tmp0_ = 0;
#line 124 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 125 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = content_layout;
#line 125 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->content_layout = _tmp0_;
#line 1095 "Printing.c"
}


void print_settings_set_content_width (PrintSettings* self, Measurement* content_width) {
	Measurement _tmp0_ = {0};
#line 128 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 128 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (content_width != NULL);
#line 129 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = *content_width;
#line 129 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->content_width = _tmp0_;
#line 1109 "Printing.c"
}


void print_settings_set_content_height (PrintSettings* self, Measurement* content_height) {
	Measurement _tmp0_ = {0};
#line 132 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 132 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (content_height != NULL);
#line 133 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = *content_height;
#line 133 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->content_height = _tmp0_;
#line 1123 "Printing.c"
}


void print_settings_set_content_ppi (PrintSettings* self, gint content_ppi) {
	gint _tmp0_ = 0;
#line 136 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 137 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = content_ppi;
#line 137 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->content_ppi = _tmp0_;
#line 1135 "Printing.c"
}


void print_settings_set_image_per_page_selection (PrintSettings* self, gint image_per_page_selection) {
	gint _tmp0_ = 0;
#line 140 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 141 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = image_per_page_selection;
#line 141 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->image_per_page_selection = _tmp0_;
#line 1147 "Printing.c"
}


void print_settings_set_size_selection (PrintSettings* self, gint size_selection) {
	gint _tmp0_ = 0;
#line 144 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 145 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = size_selection;
#line 145 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->size_selection = _tmp0_;
#line 1159 "Printing.c"
}


void print_settings_set_match_aspect_ratio_enabled (PrintSettings* self, gboolean enable_state) {
	gboolean _tmp0_ = FALSE;
#line 148 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 149 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = enable_state;
#line 149 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->match_aspect_ratio = _tmp0_;
#line 1171 "Printing.c"
}


void print_settings_set_print_titles_enabled (PrintSettings* self, gboolean print_titles) {
	gboolean _tmp0_ = FALSE;
#line 152 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 153 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = print_titles;
#line 153 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->print_titles = _tmp0_;
#line 1183 "Printing.c"
}


void print_settings_set_print_titles_font (PrintSettings* self, const gchar* fontname) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 156 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 156 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (fontname != NULL);
#line 157 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = fontname;
#line 157 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 157 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (self->priv->print_titles_font);
#line 157 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->print_titles_font = _tmp1_;
#line 1202 "Printing.c"
}


gchar* print_settings_get_print_titles_font (PrintSettings* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 160 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_SETTINGS (self), NULL);
#line 161 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->print_titles_font;
#line 161 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 161 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 161 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1220 "Printing.c"
}


static void value_print_settings_init (GValue* value) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	value->data[0].v_pointer = NULL;
#line 1227 "Printing.c"
}


static void value_print_settings_free_value (GValue* value) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	if (value->data[0].v_pointer) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		print_settings_unref (value->data[0].v_pointer);
#line 1236 "Printing.c"
	}
}


static void value_print_settings_copy_value (const GValue* src_value, GValue* dest_value) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	if (src_value->data[0].v_pointer) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		dest_value->data[0].v_pointer = print_settings_ref (src_value->data[0].v_pointer);
#line 1246 "Printing.c"
	} else {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1250 "Printing.c"
	}
}


static gpointer value_print_settings_peek_pointer (const GValue* value) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	return value->data[0].v_pointer;
#line 1258 "Printing.c"
}


static gchar* value_print_settings_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	if (collect_values[0].v_pointer) {
#line 1265 "Printing.c"
		PrintSettings* object;
		object = collect_values[0].v_pointer;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		if (object->parent_instance.g_class == NULL) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1272 "Printing.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1276 "Printing.c"
		}
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = print_settings_ref (object);
#line 1280 "Printing.c"
	} else {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = NULL;
#line 1284 "Printing.c"
	}
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	return NULL;
#line 1288 "Printing.c"
}


static gchar* value_print_settings_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PrintSettings** object_p;
	object_p = collect_values[0].v_pointer;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	if (!object_p) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1299 "Printing.c"
	}
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	if (!value->data[0].v_pointer) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		*object_p = NULL;
#line 1305 "Printing.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		*object_p = value->data[0].v_pointer;
#line 1309 "Printing.c"
	} else {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		*object_p = print_settings_ref (value->data[0].v_pointer);
#line 1313 "Printing.c"
	}
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	return NULL;
#line 1317 "Printing.c"
}


GParamSpec* param_spec_print_settings (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPrintSettings* spec;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PRINT_SETTINGS), NULL);
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	return G_PARAM_SPEC (spec);
#line 1331 "Printing.c"
}


gpointer value_get_print_settings (const GValue* value) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PRINT_SETTINGS), NULL);
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	return value->data[0].v_pointer;
#line 1340 "Printing.c"
}


void value_set_print_settings (GValue* value, gpointer v_object) {
	PrintSettings* old;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PRINT_SETTINGS));
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	old = value->data[0].v_pointer;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	if (v_object) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PRINT_SETTINGS));
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = v_object;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		print_settings_ref (value->data[0].v_pointer);
#line 1360 "Printing.c"
	} else {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = NULL;
#line 1364 "Printing.c"
	}
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	if (old) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		print_settings_unref (old);
#line 1370 "Printing.c"
	}
}


void value_take_print_settings (GValue* value, gpointer v_object) {
	PrintSettings* old;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PRINT_SETTINGS));
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	old = value->data[0].v_pointer;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	if (v_object) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PRINT_SETTINGS));
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = v_object;
#line 1389 "Printing.c"
	} else {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = NULL;
#line 1393 "Printing.c"
	}
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	if (old) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		print_settings_unref (old);
#line 1399 "Printing.c"
	}
}


static void print_settings_class_init (PrintSettingsClass * klass) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_parent_class = g_type_class_peek_parent (klass);
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	((PrintSettingsClass *) klass)->finalize = print_settings_finalize;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	g_type_class_add_private (klass, sizeof (PrintSettingsPrivate));
#line 1411 "Printing.c"
}


static void print_settings_instance_init (PrintSettings * self) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv = PRINT_SETTINGS_GET_PRIVATE (self);
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	self->ref_count = 1;
#line 1420 "Printing.c"
}


static void print_settings_finalize (PrintSettings* obj) {
	PrintSettings * self;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PRINT_SETTINGS, PrintSettings);
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_handlers_destroy (self);
#line 28 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (self->priv->print_titles_font);
#line 1432 "Printing.c"
}


GType print_settings_get_type (void) {
	static volatile gsize print_settings_type_id__volatile = 0;
	if (g_once_init_enter (&print_settings_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_print_settings_init, value_print_settings_free_value, value_print_settings_copy_value, value_print_settings_peek_pointer, "p", value_print_settings_collect_value, "p", value_print_settings_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PrintSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) print_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrintSettings), 0, (GInstanceInitFunc) print_settings_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType print_settings_type_id;
		print_settings_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PrintSettings", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&print_settings_type_id__volatile, print_settings_type_id);
	}
	return print_settings_type_id__volatile;
}


gpointer print_settings_ref (gpointer instance) {
	PrintSettings* self;
	self = instance;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	g_atomic_int_inc (&self->ref_count);
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	return instance;
#line 1457 "Printing.c"
}


void print_settings_unref (gpointer instance) {
	PrintSettings* self;
	self = instance;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		PRINT_SETTINGS_GET_CLASS (self)->finalize (self);
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1470 "Printing.c"
	}
}


GType measurement_unit_get_type (void) {
	static volatile gsize measurement_unit_type_id__volatile = 0;
	if (g_once_init_enter (&measurement_unit_type_id__volatile)) {
		static const GEnumValue values[] = {{MEASUREMENT_UNIT_INCHES, "MEASUREMENT_UNIT_INCHES", "inches"}, {MEASUREMENT_UNIT_CENTIMETERS, "MEASUREMENT_UNIT_CENTIMETERS", "centimeters"}, {0, NULL, NULL}};
		GType measurement_unit_type_id;
		measurement_unit_type_id = g_enum_register_static ("MeasurementUnit", values);
		g_once_init_leave (&measurement_unit_type_id__volatile, measurement_unit_type_id);
	}
	return measurement_unit_type_id__volatile;
}


void measurement_init (Measurement *self, gdouble value, MeasurementUnit unit) {
	gdouble _tmp0_ = 0.0;
	MeasurementUnit _tmp1_ = 0;
#line 185 "/home/jens/Source/shotwell/src/Printing.vala"
	memset (self, 0, sizeof (Measurement));
#line 186 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = value;
#line 186 "/home/jens/Source/shotwell/src/Printing.vala"
	(*self).value = _tmp0_;
#line 187 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = unit;
#line 187 "/home/jens/Source/shotwell/src/Printing.vala"
	(*self).unit = _tmp1_;
#line 1500 "Printing.c"
}


void measurement_convert_to (Measurement *self, MeasurementUnit to_unit, Measurement* result) {
	MeasurementUnit _tmp0_ = 0;
	MeasurementUnit _tmp1_ = 0;
	MeasurementUnit _tmp2_ = 0;
#line 191 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = (*self).unit;
#line 191 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = to_unit;
#line 191 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp0_ == _tmp1_) {
#line 192 "/home/jens/Source/shotwell/src/Printing.vala"
		*result = (*self);
#line 192 "/home/jens/Source/shotwell/src/Printing.vala"
		return;
#line 1518 "Printing.c"
	}
#line 194 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = to_unit;
#line 194 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp2_ == MEASUREMENT_UNIT_INCHES) {
#line 1524 "Printing.c"
		gdouble _tmp3_ = 0.0;
		Measurement _tmp4_ = {0};
#line 195 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp3_ = (*self).value;
#line 195 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp4_, _tmp3_ * MEASUREMENT_INCHES_PER_CENTIMETER, MEASUREMENT_UNIT_INCHES);
#line 195 "/home/jens/Source/shotwell/src/Printing.vala"
		*result = _tmp4_;
#line 195 "/home/jens/Source/shotwell/src/Printing.vala"
		return;
#line 1535 "Printing.c"
	} else {
		MeasurementUnit _tmp5_ = 0;
#line 196 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = to_unit;
#line 196 "/home/jens/Source/shotwell/src/Printing.vala"
		if (_tmp5_ == MEASUREMENT_UNIT_CENTIMETERS) {
#line 1542 "Printing.c"
			gdouble _tmp6_ = 0.0;
			Measurement _tmp7_ = {0};
#line 197 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp6_ = (*self).value;
#line 197 "/home/jens/Source/shotwell/src/Printing.vala"
			measurement_init (&_tmp7_, _tmp6_ * MEASUREMENT_CENTIMETERS_PER_INCH, MEASUREMENT_UNIT_CENTIMETERS);
#line 197 "/home/jens/Source/shotwell/src/Printing.vala"
			*result = _tmp7_;
#line 197 "/home/jens/Source/shotwell/src/Printing.vala"
			return;
#line 1553 "Printing.c"
		} else {
#line 199 "/home/jens/Source/shotwell/src/Printing.vala"
			g_error ("Printing.vala:199: unrecognized unit");
#line 1557 "Printing.c"
		}
	}
}


gboolean measurement_is_less_than (Measurement *self, Measurement* rhs) {
	gboolean result = FALSE;
	Measurement _tmp0_ = {0};
	MeasurementUnit _tmp1_ = 0;
	Measurement _tmp2_ = {0};
	MeasurementUnit _tmp3_ = 0;
	Measurement converted_rhs = {0};
	gdouble _tmp7_ = 0.0;
	Measurement _tmp8_ = {0};
	gdouble _tmp9_ = 0.0;
#line 203 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (rhs != NULL, FALSE);
#line 204 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = (*self).unit;
#line 204 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = *rhs;
#line 204 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = _tmp2_.unit;
#line 204 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp1_ == _tmp3_) {
#line 1583 "Printing.c"
		Measurement _tmp4_ = {0};
#line 204 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp4_ = *rhs;
#line 204 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp0_ = _tmp4_;
#line 1589 "Printing.c"
	} else {
		MeasurementUnit _tmp5_ = 0;
		Measurement _tmp6_ = {0};
#line 204 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = (*self).unit;
#line 204 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_convert_to (rhs, _tmp5_, &_tmp6_);
#line 204 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp0_ = _tmp6_;
#line 1599 "Printing.c"
	}
#line 204 "/home/jens/Source/shotwell/src/Printing.vala"
	converted_rhs = _tmp0_;
#line 205 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = (*self).value;
#line 205 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = converted_rhs;
#line 205 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = _tmp8_.value;
#line 205 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp7_ < _tmp9_;
#line 205 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1613 "Printing.c"
}


gboolean measurement_is_greater_than (Measurement *self, Measurement* rhs) {
	gboolean result = FALSE;
	Measurement _tmp0_ = {0};
	MeasurementUnit _tmp1_ = 0;
	Measurement _tmp2_ = {0};
	MeasurementUnit _tmp3_ = 0;
	Measurement converted_rhs = {0};
	gdouble _tmp7_ = 0.0;
	Measurement _tmp8_ = {0};
	gdouble _tmp9_ = 0.0;
#line 208 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (rhs != NULL, FALSE);
#line 209 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = (*self).unit;
#line 209 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = *rhs;
#line 209 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = _tmp2_.unit;
#line 209 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp1_ == _tmp3_) {
#line 1637 "Printing.c"
		Measurement _tmp4_ = {0};
#line 209 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp4_ = *rhs;
#line 209 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp0_ = _tmp4_;
#line 1643 "Printing.c"
	} else {
		MeasurementUnit _tmp5_ = 0;
		Measurement _tmp6_ = {0};
#line 209 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = (*self).unit;
#line 209 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_convert_to (rhs, _tmp5_, &_tmp6_);
#line 209 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp0_ = _tmp6_;
#line 1653 "Printing.c"
	}
#line 209 "/home/jens/Source/shotwell/src/Printing.vala"
	converted_rhs = _tmp0_;
#line 210 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = (*self).value;
#line 210 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = converted_rhs;
#line 210 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = _tmp8_.value;
#line 210 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp7_ > _tmp9_;
#line 210 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1667 "Printing.c"
}


Measurement* measurement_dup (const Measurement* self) {
	Measurement* dup;
#line 178 "/home/jens/Source/shotwell/src/Printing.vala"
	dup = g_new0 (Measurement, 1);
#line 178 "/home/jens/Source/shotwell/src/Printing.vala"
	memcpy (dup, self, sizeof (Measurement));
#line 178 "/home/jens/Source/shotwell/src/Printing.vala"
	return dup;
#line 1679 "Printing.c"
}


void measurement_free (Measurement* self) {
#line 178 "/home/jens/Source/shotwell/src/Printing.vala"
	g_free (self);
#line 1686 "Printing.c"
}


GType measurement_get_type (void) {
	static volatile gsize measurement_type_id__volatile = 0;
	if (g_once_init_enter (&measurement_type_id__volatile)) {
		GType measurement_type_id;
		measurement_type_id = g_boxed_type_register_static ("Measurement", (GBoxedCopyFunc) measurement_dup, (GBoxedFreeFunc) measurement_free);
		g_once_init_leave (&measurement_type_id__volatile, measurement_type_id);
	}
	return measurement_type_id__volatile;
}


PrintLayout* print_layout_get_all (int* result_length1) {
	PrintLayout* result = NULL;
	PrintLayout* _tmp0_ = NULL;
	PrintLayout* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = g_new0 (PrintLayout, 7);
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[0] = PRINT_LAYOUT_ENTIRE_PAGE;
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[1] = PRINT_LAYOUT_TWO_PER_PAGE;
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[2] = PRINT_LAYOUT_FOUR_PER_PAGE;
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[3] = PRINT_LAYOUT_SIX_PER_PAGE;
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[4] = PRINT_LAYOUT_EIGHT_PER_PAGE;
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[5] = PRINT_LAYOUT_SIXTEEN_PER_PAGE;
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[6] = PRINT_LAYOUT_THIRTY_TWO_PER_PAGE;
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _tmp0_;
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1__length1 = 7;
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	if (result_length1) {
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
		*result_length1 = _tmp1__length1;
#line 1730 "Printing.c"
	}
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1736 "Printing.c"
}


gint print_layout_get_per_page (PrintLayout self) {
	gint result = 0;
	gint* per_page = NULL;
	gint* _tmp0_ = NULL;
	gint per_page_length1 = 0;
	gint _per_page_size_ = 0;
	gint _tmp1_ = 0;
#line 236 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = g_new0 (gint, 7);
#line 236 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[0] = 1;
#line 236 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[1] = 2;
#line 236 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[2] = 4;
#line 236 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[3] = 6;
#line 236 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[4] = 8;
#line 236 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[5] = 16;
#line 236 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[6] = 32;
#line 236 "/home/jens/Source/shotwell/src/Printing.vala"
	per_page = _tmp0_;
#line 236 "/home/jens/Source/shotwell/src/Printing.vala"
	per_page_length1 = 7;
#line 236 "/home/jens/Source/shotwell/src/Printing.vala"
	_per_page_size_ = per_page_length1;
#line 238 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = per_page[self];
#line 238 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 238 "/home/jens/Source/shotwell/src/Printing.vala"
	per_page = (g_free (per_page), NULL);
#line 238 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1777 "Printing.c"
}


gint print_layout_get_x (PrintLayout self) {
	gint result = 0;
	gint* x = NULL;
	gint* _tmp0_ = NULL;
	gint x_length1 = 0;
	gint _x_size_ = 0;
	gint _tmp1_ = 0;
#line 242 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = g_new0 (gint, 7);
#line 242 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[0] = 1;
#line 242 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[1] = 1;
#line 242 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[2] = 2;
#line 242 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[3] = 2;
#line 242 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[4] = 2;
#line 242 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[5] = 4;
#line 242 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[6] = 4;
#line 242 "/home/jens/Source/shotwell/src/Printing.vala"
	x = _tmp0_;
#line 242 "/home/jens/Source/shotwell/src/Printing.vala"
	x_length1 = 7;
#line 242 "/home/jens/Source/shotwell/src/Printing.vala"
	_x_size_ = x_length1;
#line 244 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = x[self];
#line 244 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 244 "/home/jens/Source/shotwell/src/Printing.vala"
	x = (g_free (x), NULL);
#line 244 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1818 "Printing.c"
}


gint print_layout_get_y (PrintLayout self) {
	gint result = 0;
	gint* y = NULL;
	gint* _tmp0_ = NULL;
	gint y_length1 = 0;
	gint _y_size_ = 0;
	gint _tmp1_ = 0;
#line 248 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = g_new0 (gint, 7);
#line 248 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[0] = 1;
#line 248 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[1] = 2;
#line 248 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[2] = 2;
#line 248 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[3] = 3;
#line 248 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[4] = 4;
#line 248 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[5] = 4;
#line 248 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[6] = 8;
#line 248 "/home/jens/Source/shotwell/src/Printing.vala"
	y = _tmp0_;
#line 248 "/home/jens/Source/shotwell/src/Printing.vala"
	y_length1 = 7;
#line 248 "/home/jens/Source/shotwell/src/Printing.vala"
	_y_size_ = y_length1;
#line 250 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = y[self];
#line 250 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 250 "/home/jens/Source/shotwell/src/Printing.vala"
	y = (g_free (y), NULL);
#line 250 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1859 "Printing.c"
}


gchar* print_layout_to_string (PrintLayout self) {
	gchar* result = NULL;
	gchar** labels = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar** _tmp14_ = NULL;
	gint labels_length1 = 0;
	gint _labels_size_ = 0;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = _ ("Fill the entire page");
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = _ ("2 images per page");
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = _ ("4 images per page");
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = _ ("6 images per page");
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = _ ("8 images per page");
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = g_strdup (_tmp8_);
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = _ ("16 images per page");
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp11_ = g_strdup (_tmp10_);
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp12_ = _ ("32 images per page");
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp13_ = g_strdup (_tmp12_);
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_ = g_new0 (gchar*, 7 + 1);
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_[0] = _tmp1_;
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_[1] = _tmp3_;
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_[2] = _tmp5_;
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_[3] = _tmp7_;
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_[4] = _tmp9_;
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_[5] = _tmp11_;
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_[6] = _tmp13_;
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	labels = _tmp14_;
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	labels_length1 = 7;
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_labels_size_ = labels_length1;
#line 264 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp15_ = labels[self];
#line 264 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp16_ = g_strdup (_tmp15_);
#line 264 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp16_;
#line 264 "/home/jens/Source/shotwell/src/Printing.vala"
	labels = (_vala_array_free (labels, labels_length1, (GDestroyNotify) g_free), NULL);
#line 264 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1945 "Printing.c"
}


GType print_layout_get_type (void) {
	static volatile gsize print_layout_type_id__volatile = 0;
	if (g_once_init_enter (&print_layout_type_id__volatile)) {
		static const GEnumValue values[] = {{PRINT_LAYOUT_ENTIRE_PAGE, "PRINT_LAYOUT_ENTIRE_PAGE", "entire-page"}, {PRINT_LAYOUT_TWO_PER_PAGE, "PRINT_LAYOUT_TWO_PER_PAGE", "two-per-page"}, {PRINT_LAYOUT_FOUR_PER_PAGE, "PRINT_LAYOUT_FOUR_PER_PAGE", "four-per-page"}, {PRINT_LAYOUT_SIX_PER_PAGE, "PRINT_LAYOUT_SIX_PER_PAGE", "six-per-page"}, {PRINT_LAYOUT_EIGHT_PER_PAGE, "PRINT_LAYOUT_EIGHT_PER_PAGE", "eight-per-page"}, {PRINT_LAYOUT_SIXTEEN_PER_PAGE, "PRINT_LAYOUT_SIXTEEN_PER_PAGE", "sixteen-per-page"}, {PRINT_LAYOUT_THIRTY_TWO_PER_PAGE, "PRINT_LAYOUT_THIRTY_TWO_PER_PAGE", "thirty-two-per-page"}, {0, NULL, NULL}};
		GType print_layout_type_id;
		print_layout_type_id = g_enum_register_static ("PrintLayout", values);
		g_once_init_leave (&print_layout_type_id__volatile, print_layout_type_id);
	}
	return print_layout_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 292 "/home/jens/Source/shotwell/src/Printing.vala"
	return self ? g_object_ref (self) : NULL;
#line 1964 "Printing.c"
}


static void _custom_print_tab_on_radio_group_click_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 299 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_on_radio_group_click ((CustomPrintTab*) self, _sender);
#line 1971 "Printing.c"
}


static gboolean _custom_print_tab_standard_sizes_combo_separator_func_gtk_tree_view_row_separator_func (GtkTreeModel* model, GtkTreeIter* iter, gpointer self) {
	gboolean result;
	result = custom_print_tab_standard_sizes_combo_separator_func (model, iter);
#line 329 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1980 "Printing.c"
}


static gpointer _standard_print_size_ref0 (gpointer self) {
#line 332 "/home/jens/Source/shotwell/src/Printing.vala"
	return self ? standard_print_size_ref (self) : NULL;
#line 1987 "Printing.c"
}


static void _custom_print_tab_on_entry_insert_text_gtk_editable_insert_text (GtkEditable* _sender, const gchar* new_text, gint new_text_length, gint* position, gpointer self) {
#line 340 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_on_entry_insert_text ((CustomPrintTab*) self, _sender, new_text, new_text_length, position);
#line 1994 "Printing.c"
}


static gboolean _custom_print_tab_on_width_entry_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = custom_print_tab_on_width_entry_focus_out ((CustomPrintTab*) self, event);
#line 341 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 2003 "Printing.c"
}


static gboolean _custom_print_tab_on_height_entry_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = custom_print_tab_on_height_entry_focus_out ((CustomPrintTab*) self, event);
#line 345 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 2012 "Printing.c"
}


static void _custom_print_tab_on_units_combo_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 351 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_on_units_combo_changed ((CustomPrintTab*) self);
#line 2019 "Printing.c"
}


static void _custom_print_tab_on_ppi_entry_insert_text_gtk_editable_insert_text (GtkEditable* _sender, const gchar* new_text, gint new_text_length, gint* position, gpointer self) {
#line 358 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_on_ppi_entry_insert_text ((CustomPrintTab*) self, _sender, new_text, new_text_length, position);
#line 2026 "Printing.c"
}


static gboolean _custom_print_tab_on_ppi_entry_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = custom_print_tab_on_ppi_entry_focus_out ((CustomPrintTab*) self, event);
#line 359 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 2035 "Printing.c"
}


static void _custom_print_tab_on_aspect_ratio_check_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 368 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_on_aspect_ratio_check_clicked ((CustomPrintTab*) self);
#line 2042 "Printing.c"
}


CustomPrintTab* custom_print_tab_construct (GType object_type, PrintJob* source_job) {
	CustomPrintTab * self = NULL;
	PrintJob* _tmp0_ = NULL;
	PrintJob* _tmp1_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp2_ = NULL;
	GtkBuilder* _tmp3_ = NULL;
	GObject* _tmp4_ = NULL;
	GtkBox* _tmp5_ = NULL;
	GtkBuilder* _tmp6_ = NULL;
	GObject* _tmp7_ = NULL;
	GtkRadioButton* _tmp8_ = NULL;
	GtkRadioButton* _tmp9_ = NULL;
	GtkBuilder* _tmp10_ = NULL;
	GObject* _tmp11_ = NULL;
	GtkRadioButton* _tmp12_ = NULL;
	GtkRadioButton* _tmp13_ = NULL;
	GtkBuilder* _tmp14_ = NULL;
	GObject* _tmp15_ = NULL;
	GtkRadioButton* _tmp16_ = NULL;
	GtkRadioButton* _tmp17_ = NULL;
	GtkBuilder* _tmp18_ = NULL;
	GObject* _tmp19_ = NULL;
	GtkComboBox* _tmp20_ = NULL;
	GtkCellRendererText* image_per_page_combo_text_renderer = NULL;
	GtkCellRendererText* _tmp21_ = NULL;
	GtkComboBox* _tmp22_ = NULL;
	GtkCellRendererText* _tmp23_ = NULL;
	GtkComboBox* _tmp24_ = NULL;
	GtkCellRendererText* _tmp25_ = NULL;
	GtkListStore* image_per_page_combo_store = NULL;
	GtkListStore* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	PrintLayout* _tmp28_ = NULL;
	GtkComboBox* _tmp36_ = NULL;
	GtkListStore* _tmp37_ = NULL;
	StandardPrintSize** standard_sizes = NULL;
	PrintManager* _tmp38_ = NULL;
	PrintManager* _tmp39_ = NULL;
	gint _tmp40_ = 0;
	StandardPrintSize** _tmp41_ = NULL;
	StandardPrintSize** _tmp42_ = NULL;
	gint _tmp42__length1 = 0;
	gint standard_sizes_length1 = 0;
	gint _standard_sizes_size_ = 0;
	GtkBuilder* _tmp43_ = NULL;
	GObject* _tmp44_ = NULL;
	GtkComboBox* _tmp45_ = NULL;
	GtkCellRendererText* standard_sizes_combo_text_renderer = NULL;
	GtkCellRendererText* _tmp46_ = NULL;
	GtkComboBox* _tmp47_ = NULL;
	GtkCellRendererText* _tmp48_ = NULL;
	GtkComboBox* _tmp49_ = NULL;
	GtkCellRendererText* _tmp50_ = NULL;
	GtkComboBox* _tmp51_ = NULL;
	GtkListStore* standard_sizes_combo_store = NULL;
	GtkListStore* _tmp52_ = NULL;
	StandardPrintSize** _tmp53_ = NULL;
	gint _tmp53__length1 = 0;
	GtkComboBox* _tmp62_ = NULL;
	GtkListStore* _tmp63_ = NULL;
	GtkBuilder* _tmp64_ = NULL;
	GObject* _tmp65_ = NULL;
	GtkEntry* _tmp66_ = NULL;
	GtkEntry* _tmp67_ = NULL;
	GtkEntry* _tmp68_ = NULL;
	GtkBuilder* _tmp69_ = NULL;
	GObject* _tmp70_ = NULL;
	GtkEntry* _tmp71_ = NULL;
	GtkEntry* _tmp72_ = NULL;
	GtkEntry* _tmp73_ = NULL;
	GtkBuilder* _tmp74_ = NULL;
	GObject* _tmp75_ = NULL;
	GtkComboBoxText* _tmp76_ = NULL;
	GtkComboBoxText* _tmp77_ = NULL;
	const gchar* _tmp78_ = NULL;
	GtkComboBoxText* _tmp79_ = NULL;
	const gchar* _tmp80_ = NULL;
	GtkComboBoxText* _tmp81_ = NULL;
	GtkComboBoxText* _tmp82_ = NULL;
	GtkBuilder* _tmp83_ = NULL;
	GObject* _tmp84_ = NULL;
	GtkCheckButton* _tmp85_ = NULL;
	GtkBuilder* _tmp86_ = NULL;
	GObject* _tmp87_ = NULL;
	GtkCheckButton* _tmp88_ = NULL;
	GtkBuilder* _tmp89_ = NULL;
	GObject* _tmp90_ = NULL;
	GtkFontButton* _tmp91_ = NULL;
	GtkBuilder* _tmp92_ = NULL;
	GObject* _tmp93_ = NULL;
	GtkEntry* _tmp94_ = NULL;
	GtkEntry* _tmp95_ = NULL;
	GtkEntry* _tmp96_ = NULL;
	GtkBox* _tmp97_ = NULL;
	PrintJob* _tmp98_ = NULL;
	GtkCheckButton* _tmp99_ = NULL;
#line 291 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_JOB (source_job), NULL);
#line 291 "/home/jens/Source/shotwell/src/Printing.vala"
	self = (CustomPrintTab*) g_object_new (object_type, NULL);
#line 292 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = source_job;
#line 292 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 292 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->source_job);
#line 292 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->source_job = _tmp1_;
#line 293 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = app_window_create_builder ("shotwell.ui", NULL);
#line 293 "/home/jens/Source/shotwell/src/Printing.vala"
	builder = _tmp2_;
#line 296 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = builder;
#line 296 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = gtk_builder_get_object (_tmp3_, "box_ImgSettingsPane");
#line 296 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_box_get_type ()) ? ((GtkBox*) _tmp4_) : NULL);
#line 296 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->custom_image_settings_pane);
#line 296 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->custom_image_settings_pane = _tmp5_;
#line 298 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = builder;
#line 298 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = gtk_builder_get_object (_tmp6_, "radio_UseStandardSize");
#line 298 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_radio_button_get_type ()) ? ((GtkRadioButton*) _tmp7_) : NULL);
#line 298 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->standard_size_radio);
#line 298 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->standard_size_radio = _tmp8_;
#line 299 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = self->priv->standard_size_radio;
#line 299 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_button_get_type (), GtkButton), "clicked", (GCallback) _custom_print_tab_on_radio_group_click_gtk_button_clicked, self, 0);
#line 301 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = builder;
#line 301 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp11_ = gtk_builder_get_object (_tmp10_, "radio_UseCustomSize");
#line 301 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, gtk_radio_button_get_type ()) ? ((GtkRadioButton*) _tmp11_) : NULL);
#line 301 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->custom_size_radio);
#line 301 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->custom_size_radio = _tmp12_;
#line 302 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp13_ = self->priv->custom_size_radio;
#line 302 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_button_get_type (), GtkButton), "clicked", (GCallback) _custom_print_tab_on_radio_group_click_gtk_button_clicked, self, 0);
#line 304 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_ = builder;
#line 304 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp15_ = gtk_builder_get_object (_tmp14_, "radio_Autosize");
#line 304 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, gtk_radio_button_get_type ()) ? ((GtkRadioButton*) _tmp15_) : NULL);
#line 304 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->image_per_page_radio);
#line 304 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->image_per_page_radio = _tmp16_;
#line 305 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp17_ = self->priv->image_per_page_radio;
#line 305 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_button_get_type (), GtkButton), "clicked", (GCallback) _custom_print_tab_on_radio_group_click_gtk_button_clicked, self, 0);
#line 307 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp18_ = builder;
#line 307 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp19_ = gtk_builder_get_object (_tmp18_, "combo_Autosize");
#line 307 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, gtk_combo_box_get_type ()) ? ((GtkComboBox*) _tmp19_) : NULL);
#line 307 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->image_per_page_combo);
#line 307 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->image_per_page_combo = _tmp20_;
#line 308 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp21_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 308 "/home/jens/Source/shotwell/src/Printing.vala"
	g_object_ref_sink (_tmp21_);
#line 308 "/home/jens/Source/shotwell/src/Printing.vala"
	image_per_page_combo_text_renderer = _tmp21_;
#line 310 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp22_ = self->priv->image_per_page_combo;
#line 310 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp23_ = image_per_page_combo_text_renderer;
#line 310 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_cell_layout_pack_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GTK_TYPE_CELL_LAYOUT, GtkCellLayout), G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_cell_renderer_get_type (), GtkCellRenderer), TRUE);
#line 311 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp24_ = self->priv->image_per_page_combo;
#line 311 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp25_ = image_per_page_combo_text_renderer;
#line 311 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_cell_layout_add_attribute (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GTK_TYPE_CELL_LAYOUT, GtkCellLayout), G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_cell_renderer_get_type (), GtkCellRenderer), "text", 0);
#line 313 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp26_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING, -1);
#line 313 "/home/jens/Source/shotwell/src/Printing.vala"
	image_per_page_combo_store = _tmp26_;
#line 315 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp28_ = print_layout_get_all (&_tmp27_);
#line 2245 "Printing.c"
	{
		PrintLayout* layout_collection = NULL;
		gint layout_collection_length1 = 0;
		gint _layout_collection_size_ = 0;
		gint layout_it = 0;
#line 315 "/home/jens/Source/shotwell/src/Printing.vala"
		layout_collection = _tmp28_;
#line 315 "/home/jens/Source/shotwell/src/Printing.vala"
		layout_collection_length1 = _tmp27_;
#line 315 "/home/jens/Source/shotwell/src/Printing.vala"
		for (layout_it = 0; layout_it < _tmp27_; layout_it = layout_it + 1) {
#line 2257 "Printing.c"
			PrintLayout layout = 0;
#line 315 "/home/jens/Source/shotwell/src/Printing.vala"
			layout = layout_collection[layout_it];
#line 2261 "Printing.c"
			{
				GtkTreeIter iter = {0};
				GtkListStore* _tmp29_ = NULL;
				GtkTreeIter _tmp30_ = {0};
				GtkListStore* _tmp31_ = NULL;
				GtkTreeIter _tmp32_ = {0};
				PrintLayout _tmp33_ = 0;
				gchar* _tmp34_ = NULL;
				GValue _tmp35_ = {0};
#line 317 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp29_ = image_per_page_combo_store;
#line 317 "/home/jens/Source/shotwell/src/Printing.vala"
				gtk_list_store_append (_tmp29_, &_tmp30_);
#line 317 "/home/jens/Source/shotwell/src/Printing.vala"
				iter = _tmp30_;
#line 318 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp31_ = image_per_page_combo_store;
#line 318 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp32_ = iter;
#line 318 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp33_ = layout;
#line 318 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp34_ = print_layout_to_string (_tmp33_);
#line 318 "/home/jens/Source/shotwell/src/Printing.vala"
				g_value_init (&_tmp35_, G_TYPE_STRING);
#line 318 "/home/jens/Source/shotwell/src/Printing.vala"
				g_value_take_string (&_tmp35_, _tmp34_);
#line 318 "/home/jens/Source/shotwell/src/Printing.vala"
				gtk_list_store_set_value (_tmp31_, &_tmp32_, 0, &_tmp35_);
#line 318 "/home/jens/Source/shotwell/src/Printing.vala"
				G_IS_VALUE (&_tmp35_) ? (g_value_unset (&_tmp35_), NULL) : NULL;
#line 2293 "Printing.c"
			}
		}
#line 315 "/home/jens/Source/shotwell/src/Printing.vala"
		layout_collection = (g_free (layout_collection), NULL);
#line 2298 "Printing.c"
	}
#line 320 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp36_ = self->priv->image_per_page_combo;
#line 320 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp37_ = image_per_page_combo_store;
#line 320 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_combo_box_set_model (_tmp36_, G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, GTK_TYPE_TREE_MODEL, GtkTreeModel));
#line 322 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp38_ = print_manager_get_instance ();
#line 322 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp39_ = _tmp38_;
#line 322 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp41_ = print_manager_get_standard_sizes (_tmp39_, &_tmp40_);
#line 322 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp42_ = _tmp41_;
#line 322 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp42__length1 = _tmp40_;
#line 322 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_manager_unref0 (_tmp39_);
#line 322 "/home/jens/Source/shotwell/src/Printing.vala"
	standard_sizes = _tmp42_;
#line 322 "/home/jens/Source/shotwell/src/Printing.vala"
	standard_sizes_length1 = _tmp42__length1;
#line 322 "/home/jens/Source/shotwell/src/Printing.vala"
	_standard_sizes_size_ = standard_sizes_length1;
#line 323 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp43_ = builder;
#line 323 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp44_ = gtk_builder_get_object (_tmp43_, "combo_StdSizes");
#line 323 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp45_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp44_, gtk_combo_box_get_type ()) ? ((GtkComboBox*) _tmp44_) : NULL);
#line 323 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->standard_sizes_combo);
#line 323 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->standard_sizes_combo = _tmp45_;
#line 324 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp46_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 324 "/home/jens/Source/shotwell/src/Printing.vala"
	g_object_ref_sink (_tmp46_);
#line 324 "/home/jens/Source/shotwell/src/Printing.vala"
	standard_sizes_combo_text_renderer = _tmp46_;
#line 326 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp47_ = self->priv->standard_sizes_combo;
#line 326 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp48_ = standard_sizes_combo_text_renderer;
#line 326 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_cell_layout_pack_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, GTK_TYPE_CELL_LAYOUT, GtkCellLayout), G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, gtk_cell_renderer_get_type (), GtkCellRenderer), TRUE);
#line 327 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp49_ = self->priv->standard_sizes_combo;
#line 327 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp50_ = standard_sizes_combo_text_renderer;
#line 327 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_cell_layout_add_attribute (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, GTK_TYPE_CELL_LAYOUT, GtkCellLayout), G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, gtk_cell_renderer_get_type (), GtkCellRenderer), "text", 0);
#line 329 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp51_ = self->priv->standard_sizes_combo;
#line 329 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_combo_box_set_row_separator_func (_tmp51_, _custom_print_tab_standard_sizes_combo_separator_func_gtk_tree_view_row_separator_func, NULL, NULL);
#line 330 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp52_ = gtk_list_store_new (1, G_TYPE_STRING, G_TYPE_STRING, -1);
#line 330 "/home/jens/Source/shotwell/src/Printing.vala"
	standard_sizes_combo_store = _tmp52_;
#line 332 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp53_ = standard_sizes;
#line 332 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp53__length1 = standard_sizes_length1;
#line 2364 "Printing.c"
	{
		StandardPrintSize** size_collection = NULL;
		gint size_collection_length1 = 0;
		gint _size_collection_size_ = 0;
		gint size_it = 0;
#line 332 "/home/jens/Source/shotwell/src/Printing.vala"
		size_collection = _tmp53_;
#line 332 "/home/jens/Source/shotwell/src/Printing.vala"
		size_collection_length1 = _tmp53__length1;
#line 332 "/home/jens/Source/shotwell/src/Printing.vala"
		for (size_it = 0; size_it < _tmp53__length1; size_it = size_it + 1) {
#line 2376 "Printing.c"
			StandardPrintSize* _tmp54_ = NULL;
			StandardPrintSize* size = NULL;
#line 332 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp54_ = _standard_print_size_ref0 (size_collection[size_it]);
#line 332 "/home/jens/Source/shotwell/src/Printing.vala"
			size = _tmp54_;
#line 2383 "Printing.c"
			{
				GtkTreeIter iter = {0};
				GtkListStore* _tmp55_ = NULL;
				GtkTreeIter _tmp56_ = {0};
				GtkListStore* _tmp57_ = NULL;
				GtkTreeIter _tmp58_ = {0};
				StandardPrintSize* _tmp59_ = NULL;
				const gchar* _tmp60_ = NULL;
				GValue _tmp61_ = {0};
#line 334 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp55_ = standard_sizes_combo_store;
#line 334 "/home/jens/Source/shotwell/src/Printing.vala"
				gtk_list_store_append (_tmp55_, &_tmp56_);
#line 334 "/home/jens/Source/shotwell/src/Printing.vala"
				iter = _tmp56_;
#line 335 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp57_ = standard_sizes_combo_store;
#line 335 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp58_ = iter;
#line 335 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp59_ = size;
#line 335 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp60_ = _tmp59_->name;
#line 335 "/home/jens/Source/shotwell/src/Printing.vala"
				g_value_init (&_tmp61_, G_TYPE_STRING);
#line 335 "/home/jens/Source/shotwell/src/Printing.vala"
				g_value_set_string (&_tmp61_, _tmp60_);
#line 335 "/home/jens/Source/shotwell/src/Printing.vala"
				gtk_list_store_set_value (_tmp57_, &_tmp58_, 0, &_tmp61_);
#line 335 "/home/jens/Source/shotwell/src/Printing.vala"
				G_IS_VALUE (&_tmp61_) ? (g_value_unset (&_tmp61_), NULL) : NULL;
#line 332 "/home/jens/Source/shotwell/src/Printing.vala"
				_standard_print_size_unref0 (size);
#line 2417 "Printing.c"
			}
		}
	}
#line 337 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp62_ = self->priv->standard_sizes_combo;
#line 337 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp63_ = standard_sizes_combo_store;
#line 337 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_combo_box_set_model (_tmp62_, G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, GTK_TYPE_TREE_MODEL, GtkTreeModel));
#line 339 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp64_ = builder;
#line 339 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp65_ = gtk_builder_get_object (_tmp64_, "entry_CustomWidth");
#line 339 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp66_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp65_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp65_) : NULL);
#line 339 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->custom_width_entry);
#line 339 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->custom_width_entry = _tmp66_;
#line 340 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp67_ = self->priv->custom_width_entry;
#line 340 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, GTK_TYPE_EDITABLE, GtkEditable), "insert-text", (GCallback) _custom_print_tab_on_entry_insert_text_gtk_editable_insert_text, self, 0);
#line 341 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp68_ = self->priv->custom_width_entry;
#line 341 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, gtk_widget_get_type (), GtkWidget), "focus-out-event", (GCallback) _custom_print_tab_on_width_entry_focus_out_gtk_widget_focus_out_event, self, 0);
#line 343 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp69_ = builder;
#line 343 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp70_ = gtk_builder_get_object (_tmp69_, "entry_CustomHeight");
#line 343 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp71_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp70_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp70_) : NULL);
#line 343 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->custom_height_entry);
#line 343 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->custom_height_entry = _tmp71_;
#line 344 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp72_ = self->priv->custom_height_entry;
#line 344 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, GTK_TYPE_EDITABLE, GtkEditable), "insert-text", (GCallback) _custom_print_tab_on_entry_insert_text_gtk_editable_insert_text, self, 0);
#line 345 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp73_ = self->priv->custom_height_entry;
#line 345 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, gtk_widget_get_type (), GtkWidget), "focus-out-event", (GCallback) _custom_print_tab_on_height_entry_focus_out_gtk_widget_focus_out_event, self, 0);
#line 347 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp74_ = builder;
#line 347 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp75_ = gtk_builder_get_object (_tmp74_, "combo_Units");
#line 347 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp76_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp75_, gtk_combo_box_text_get_type ()) ? ((GtkComboBoxText*) _tmp75_) : NULL);
#line 347 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->units_combo);
#line 347 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->units_combo = _tmp76_;
#line 348 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp77_ = self->priv->units_combo;
#line 348 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp78_ = _ ("in.");
#line 348 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_combo_box_text_append_text (_tmp77_, _tmp78_);
#line 349 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp79_ = self->priv->units_combo;
#line 349 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp80_ = _ ("cm");
#line 349 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_combo_box_text_append_text (_tmp79_, _tmp80_);
#line 350 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp81_ = self->priv->units_combo;
#line 350 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, gtk_combo_box_get_type (), GtkComboBox), 0);
#line 351 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp82_ = self->priv->units_combo;
#line 351 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp82_, gtk_combo_box_get_type (), GtkComboBox), "changed", (GCallback) _custom_print_tab_on_units_combo_changed_gtk_combo_box_changed, self, 0);
#line 353 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp83_ = builder;
#line 353 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp84_ = gtk_builder_get_object (_tmp83_, "check_MatchAspectRatio");
#line 353 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp85_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp84_, gtk_check_button_get_type ()) ? ((GtkCheckButton*) _tmp84_) : NULL);
#line 353 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->aspect_ratio_check);
#line 353 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->aspect_ratio_check = _tmp85_;
#line 354 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp86_ = builder;
#line 354 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp87_ = gtk_builder_get_object (_tmp86_, "check_PrintImageTitle");
#line 354 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp88_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp87_, gtk_check_button_get_type ()) ? ((GtkCheckButton*) _tmp87_) : NULL);
#line 354 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->title_print_check);
#line 354 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->title_print_check = _tmp88_;
#line 355 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp89_ = builder;
#line 355 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp90_ = gtk_builder_get_object (_tmp89_, "fntbn_TitleFont");
#line 355 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp91_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp90_, gtk_font_button_get_type ()) ? ((GtkFontButton*) _tmp90_) : NULL);
#line 355 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->title_print_font);
#line 355 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->title_print_font = _tmp91_;
#line 357 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp92_ = builder;
#line 357 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp93_ = gtk_builder_get_object (_tmp92_, "entry_PixelsPerInch");
#line 357 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp94_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp93_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp93_) : NULL);
#line 357 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->ppi_entry);
#line 357 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->ppi_entry = _tmp94_;
#line 358 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp95_ = self->priv->ppi_entry;
#line 358 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp95_, GTK_TYPE_EDITABLE, GtkEditable), "insert-text", (GCallback) _custom_print_tab_on_ppi_entry_insert_text_gtk_editable_insert_text, self, 0);
#line 359 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp96_ = self->priv->ppi_entry;
#line 359 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp96_, gtk_widget_get_type (), GtkWidget), "focus-out-event", (GCallback) _custom_print_tab_on_ppi_entry_focus_out_gtk_widget_focus_out_event, self, 0);
#line 361 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp97_ = self->priv->custom_image_settings_pane;
#line 361 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, gtk_widget_get_type (), GtkWidget));
#line 363 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp98_ = source_job;
#line 363 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_sync_state_from_job (self, _tmp98_);
#line 365 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 368 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp99_ = self->priv->aspect_ratio_check;
#line 368 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, gtk_button_get_type (), GtkButton), "clicked", (GCallback) _custom_print_tab_on_aspect_ratio_check_clicked_gtk_button_clicked, self, 0);
#line 291 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (standard_sizes_combo_store);
#line 291 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (standard_sizes_combo_text_renderer);
#line 291 "/home/jens/Source/shotwell/src/Printing.vala"
	standard_sizes = (_vala_array_free (standard_sizes, standard_sizes_length1, (GDestroyNotify) standard_print_size_unref), NULL);
#line 291 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (image_per_page_combo_store);
#line 291 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (image_per_page_combo_text_renderer);
#line 291 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (builder);
#line 291 "/home/jens/Source/shotwell/src/Printing.vala"
	return self;
#line 2569 "Printing.c"
}


CustomPrintTab* custom_print_tab_new (PrintJob* source_job) {
#line 291 "/home/jens/Source/shotwell/src/Printing.vala"
	return custom_print_tab_construct (TYPE_CUSTOM_PRINT_TAB, source_job);
#line 2576 "Printing.c"
}


static void custom_print_tab_on_aspect_ratio_check_clicked (CustomPrintTab* self) {
	GtkCheckButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 371 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 372 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->aspect_ratio_check;
#line 372 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton));
#line 372 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp1_) {
#line 2591 "Printing.c"
		Measurement _tmp2_ = {0};
		gdouble _tmp3_ = 0.0;
		PrintJob* _tmp4_ = NULL;
		gdouble _tmp5_ = 0.0;
		Measurement _tmp6_ = {0};
		MeasurementUnit _tmp7_ = 0;
		GtkEntry* _tmp8_ = NULL;
		Measurement _tmp9_ = {0};
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
#line 373 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp2_ = self->priv->local_content_height;
#line 373 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp3_ = _tmp2_.value;
#line 373 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp4_ = self->priv->source_job;
#line 373 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = print_job_get_source_aspect_ratio (_tmp4_);
#line 373 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp6_ = self->priv->local_content_height;
#line 373 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp7_ = _tmp6_.unit;
#line 373 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&self->priv->local_content_width, _tmp3_ * _tmp5_, _tmp7_);
#line 376 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp8_ = self->priv->custom_width_entry;
#line 376 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp9_ = self->priv->local_content_width;
#line 376 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp10_ = custom_print_tab_format_measurement (self, &_tmp9_);
#line 376 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp11_ = _tmp10_;
#line 376 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_entry_set_text (_tmp8_, _tmp11_);
#line 376 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_free0 (_tmp11_);
#line 2628 "Printing.c"
	}
}


static gboolean custom_print_tab_on_width_entry_focus_out (CustomPrintTab* self, GdkEventFocus* event) {
	gboolean result = FALSE;
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	Measurement _tmp2_ = {0};
	MeasurementUnit _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	Measurement new_width = {0};
	Measurement _tmp7_ = {0};
	Measurement min_width = {0};
	PrintJob* _tmp8_ = NULL;
	PrintSettings* _tmp9_ = NULL;
	PrintSettings* _tmp10_ = NULL;
	Measurement _tmp11_ = {0};
	Measurement _tmp12_ = {0};
	Measurement max_width = {0};
	PrintJob* _tmp13_ = NULL;
	PrintSettings* _tmp14_ = NULL;
	PrintSettings* _tmp15_ = NULL;
	Measurement _tmp16_ = {0};
	Measurement _tmp17_ = {0};
	gboolean _tmp18_ = FALSE;
	Measurement _tmp19_ = {0};
	gboolean _tmp20_ = FALSE;
	gboolean _tmp27_ = FALSE;
	Measurement _tmp39_ = {0};
	GtkEntry* _tmp40_ = NULL;
	Measurement _tmp41_ = {0};
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
#line 380 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), FALSE);
#line 380 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 381 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->custom_width_entry;
#line 381 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_entry_get_text (_tmp0_);
#line 381 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = self->priv->local_content_width;
#line 381 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = custom_print_tab_get_user_unit_choice (self);
#line 381 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = custom_print_tab_format_measurement_as (self, &_tmp2_, _tmp3_);
#line 381 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = _tmp4_;
#line 381 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = g_strcmp0 (_tmp1_, _tmp5_) == 0;
#line 381 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp5_);
#line 381 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp6_) {
#line 383 "/home/jens/Source/shotwell/src/Printing.vala"
		result = FALSE;
#line 383 "/home/jens/Source/shotwell/src/Printing.vala"
		return result;
#line 2691 "Printing.c"
	}
#line 385 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_get_width_entry_value (self, &_tmp7_);
#line 385 "/home/jens/Source/shotwell/src/Printing.vala"
	new_width = _tmp7_;
#line 386 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = self->priv->source_job;
#line 386 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = print_job_get_local_settings (_tmp8_);
#line 386 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = _tmp9_;
#line 386 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_get_minimum_content_dimension (_tmp10_, &_tmp11_);
#line 386 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp12_ = _tmp11_;
#line 386 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp10_);
#line 386 "/home/jens/Source/shotwell/src/Printing.vala"
	min_width = _tmp12_;
#line 387 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp13_ = self->priv->source_job;
#line 387 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_ = print_job_get_local_settings (_tmp13_);
#line 387 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp15_ = _tmp14_;
#line 387 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_get_maximum_content_dimension (_tmp15_, &_tmp16_);
#line 387 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp17_ = _tmp16_;
#line 387 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp15_);
#line 387 "/home/jens/Source/shotwell/src/Printing.vala"
	max_width = _tmp17_;
#line 389 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp19_ = min_width;
#line 389 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp20_ = measurement_is_less_than (&new_width, &_tmp19_);
#line 389 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp20_) {
#line 389 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp18_ = TRUE;
#line 2733 "Printing.c"
	} else {
		Measurement _tmp21_ = {0};
		gboolean _tmp22_ = FALSE;
#line 389 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp21_ = max_width;
#line 389 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp22_ = measurement_is_greater_than (&new_width, &_tmp21_);
#line 389 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp18_ = _tmp22_;
#line 2743 "Printing.c"
	}
#line 389 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp18_) {
#line 2747 "Printing.c"
		GtkEntry* _tmp23_ = NULL;
		Measurement _tmp24_ = {0};
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
#line 390 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp23_ = self->priv->custom_width_entry;
#line 390 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp24_ = self->priv->local_content_width;
#line 390 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp25_ = custom_print_tab_format_measurement (self, &_tmp24_);
#line 390 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp26_ = _tmp25_;
#line 390 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_entry_set_text (_tmp23_, _tmp26_);
#line 390 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_free0 (_tmp26_);
#line 391 "/home/jens/Source/shotwell/src/Printing.vala"
		result = FALSE;
#line 391 "/home/jens/Source/shotwell/src/Printing.vala"
		return result;
#line 2768 "Printing.c"
	}
#line 394 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp27_ = custom_print_tab_is_match_aspect_ratio_enabled (self);
#line 394 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp27_) {
#line 2774 "Printing.c"
		Measurement new_height = {0};
		Measurement _tmp28_ = {0};
		gdouble _tmp29_ = 0.0;
		PrintJob* _tmp30_ = NULL;
		gdouble _tmp31_ = 0.0;
		Measurement _tmp32_ = {0};
		MeasurementUnit _tmp33_ = 0;
		Measurement _tmp34_ = {0};
		GtkEntry* _tmp35_ = NULL;
		Measurement _tmp36_ = {0};
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
#line 395 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp28_ = new_width;
#line 395 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp29_ = _tmp28_.value;
#line 395 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp30_ = self->priv->source_job;
#line 395 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp31_ = print_job_get_source_aspect_ratio (_tmp30_);
#line 395 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp32_ = new_width;
#line 395 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp33_ = _tmp32_.unit;
#line 395 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&new_height, _tmp29_ / _tmp31_, _tmp33_);
#line 398 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp34_ = new_height;
#line 398 "/home/jens/Source/shotwell/src/Printing.vala"
		self->priv->local_content_height = _tmp34_;
#line 399 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp35_ = self->priv->custom_height_entry;
#line 399 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp36_ = new_height;
#line 399 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp37_ = custom_print_tab_format_measurement (self, &_tmp36_);
#line 399 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp38_ = _tmp37_;
#line 399 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_entry_set_text (_tmp35_, _tmp38_);
#line 399 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_free0 (_tmp38_);
#line 2817 "Printing.c"
	}
#line 402 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp39_ = new_width;
#line 402 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->local_content_width = _tmp39_;
#line 403 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp40_ = self->priv->custom_width_entry;
#line 403 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp41_ = new_width;
#line 403 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp42_ = custom_print_tab_format_measurement (self, &_tmp41_);
#line 403 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp43_ = _tmp42_;
#line 403 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_entry_set_text (_tmp40_, _tmp43_);
#line 403 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp43_);
#line 404 "/home/jens/Source/shotwell/src/Printing.vala"
	result = FALSE;
#line 404 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 2839 "Printing.c"
}


static gchar* custom_print_tab_format_measurement (CustomPrintTab* self, Measurement* measurement) {
	gchar* result = NULL;
	Measurement _tmp0_ = {0};
	gdouble _tmp1_ = 0.0;
	gchar* _tmp2_ = NULL;
#line 407 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), NULL);
#line 407 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (measurement != NULL, NULL);
#line 408 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = *measurement;
#line 408 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _tmp0_.value;
#line 408 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = g_strdup_printf ("%.2f", _tmp1_);
#line 408 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp2_;
#line 408 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 2862 "Printing.c"
}


static gchar* custom_print_tab_format_measurement_as (CustomPrintTab* self, Measurement* measurement, MeasurementUnit to_unit) {
	gchar* result = NULL;
	Measurement _tmp0_ = {0};
	Measurement _tmp1_ = {0};
	MeasurementUnit _tmp2_ = 0;
	MeasurementUnit _tmp3_ = 0;
	Measurement converted_measurement = {0};
	Measurement _tmp7_ = {0};
	gchar* _tmp8_ = NULL;
#line 411 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), NULL);
#line 411 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (measurement != NULL, NULL);
#line 412 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = *measurement;
#line 412 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = _tmp1_.unit;
#line 412 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = to_unit;
#line 412 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp2_ == _tmp3_) {
#line 2887 "Printing.c"
		Measurement _tmp4_ = {0};
#line 412 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp4_ = *measurement;
#line 412 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp0_ = _tmp4_;
#line 2893 "Printing.c"
	} else {
		MeasurementUnit _tmp5_ = 0;
		Measurement _tmp6_ = {0};
#line 413 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = to_unit;
#line 413 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_convert_to (measurement, _tmp5_, &_tmp6_);
#line 413 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp0_ = _tmp6_;
#line 2903 "Printing.c"
	}
#line 412 "/home/jens/Source/shotwell/src/Printing.vala"
	converted_measurement = _tmp0_;
#line 414 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = converted_measurement;
#line 414 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = custom_print_tab_format_measurement (self, &_tmp7_);
#line 414 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp8_;
#line 414 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 2915 "Printing.c"
}


static gboolean custom_print_tab_on_ppi_entry_focus_out (CustomPrintTab* self, GdkEventFocus* event) {
	gboolean result = FALSE;
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 417 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), FALSE);
#line 417 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 418 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->ppi_entry;
#line 418 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_entry_get_text (_tmp0_);
#line 418 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = atoi (_tmp1_);
#line 418 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_set_content_ppi (self, _tmp2_);
#line 419 "/home/jens/Source/shotwell/src/Printing.vala"
	result = FALSE;
#line 419 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 2940 "Printing.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 1086 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1087 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 1087 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 1087 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 1087 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 2958 "Printing.c"
}


static void custom_print_tab_on_ppi_entry_insert_text (CustomPrintTab* self, GtkEditable* editable, const gchar* text, gint length, gint* position) {
	GtkEntry* sender = NULL;
	GtkEditable* _tmp0_ = NULL;
	GtkEntry* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	gchar* new_text = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	GtkEntry* _tmp31_ = NULL;
#line 422 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 422 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GTK_IS_EDITABLE (editable));
#line 422 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (text != NULL);
#line 424 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = editable;
#line 424 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_entry_get_type (), GtkEntry));
#line 424 "/home/jens/Source/shotwell/src/Printing.vala"
	sender = _tmp1_;
#line 426 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = self->priv->is_text_insertion_in_progress;
#line 426 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp2_) {
#line 427 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_object_unref0 (sender);
#line 427 "/home/jens/Source/shotwell/src/Printing.vala"
		return;
#line 2994 "Printing.c"
	}
#line 429 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->is_text_insertion_in_progress = TRUE;
#line 431 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = length;
#line 431 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp3_ == -1) {
#line 3002 "Printing.c"
		const gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
#line 432 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp4_ = text;
#line 432 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = strlen (_tmp4_);
#line 432 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp6_ = _tmp5_;
#line 432 "/home/jens/Source/shotwell/src/Printing.vala"
		length = (gint) _tmp6_;
#line 3014 "Printing.c"
	}
#line 434 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = g_strdup ("");
#line 434 "/home/jens/Source/shotwell/src/Printing.vala"
	new_text = _tmp7_;
#line 3020 "Printing.c"
	{
		gint ctr = 0;
#line 435 "/home/jens/Source/shotwell/src/Printing.vala"
		ctr = 0;
#line 3025 "Printing.c"
		{
			gboolean _tmp8_ = FALSE;
#line 435 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp8_ = TRUE;
#line 435 "/home/jens/Source/shotwell/src/Printing.vala"
			while (TRUE) {
#line 3032 "Printing.c"
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				const gchar* _tmp12_ = NULL;
				gint _tmp13_ = 0;
				gchar _tmp14_ = '\0';
				gboolean _tmp15_ = FALSE;
#line 435 "/home/jens/Source/shotwell/src/Printing.vala"
				if (!_tmp8_) {
#line 3041 "Printing.c"
					gint _tmp9_ = 0;
#line 435 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp9_ = ctr;
#line 435 "/home/jens/Source/shotwell/src/Printing.vala"
					ctr = _tmp9_ + 1;
#line 3047 "Printing.c"
				}
#line 435 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp8_ = FALSE;
#line 435 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp10_ = ctr;
#line 435 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp11_ = length;
#line 435 "/home/jens/Source/shotwell/src/Printing.vala"
				if (!(_tmp10_ < _tmp11_)) {
#line 435 "/home/jens/Source/shotwell/src/Printing.vala"
					break;
#line 3059 "Printing.c"
				}
#line 436 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp12_ = text;
#line 436 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp13_ = ctr;
#line 436 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp14_ = string_get (_tmp12_, (glong) _tmp13_);
#line 436 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp15_ = g_ascii_isdigit (_tmp14_);
#line 436 "/home/jens/Source/shotwell/src/Printing.vala"
				if (_tmp15_) {
#line 3071 "Printing.c"
					const gchar* _tmp16_ = NULL;
					const gchar* _tmp17_ = NULL;
					gint _tmp18_ = 0;
					gchar _tmp19_ = '\0';
					gchar* _tmp20_ = NULL;
					gchar* _tmp21_ = NULL;
					gchar* _tmp22_ = NULL;
#line 437 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp16_ = new_text;
#line 437 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp17_ = text;
#line 437 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp18_ = ctr;
#line 437 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp19_ = string_get (_tmp17_, (glong) _tmp18_);
#line 437 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp20_ = g_strdup_printf ("%c", (gchar) _tmp19_);
#line 437 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp21_ = _tmp20_;
#line 437 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp22_ = g_strconcat (_tmp16_, _tmp21_, NULL);
#line 437 "/home/jens/Source/shotwell/src/Printing.vala"
					_g_free0 (new_text);
#line 437 "/home/jens/Source/shotwell/src/Printing.vala"
					new_text = _tmp22_;
#line 437 "/home/jens/Source/shotwell/src/Printing.vala"
					_g_free0 (_tmp21_);
#line 3099 "Printing.c"
				}
			}
		}
	}
#line 440 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp23_ = new_text;
#line 440 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp24_ = strlen (_tmp23_);
#line 440 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp25_ = _tmp24_;
#line 440 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp25_ > 0) {
#line 3112 "Printing.c"
		GtkEntry* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
#line 441 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp26_ = sender;
#line 441 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp27_ = new_text;
#line 441 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp28_ = new_text;
#line 441 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp29_ = strlen (_tmp28_);
#line 441 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp30_ = _tmp29_;
#line 441 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_editable_insert_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GTK_TYPE_EDITABLE, GtkEditable), _tmp27_, (gint) _tmp30_, position);
#line 3130 "Printing.c"
	}
#line 443 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp31_ = sender;
#line 443 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_stop_emission_by_name (_tmp31_, "insert-text");
#line 445 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->is_text_insertion_in_progress = FALSE;
#line 422 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (new_text);
#line 422 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (sender);
#line 3142 "Printing.c"
}


static gboolean custom_print_tab_on_height_entry_focus_out (CustomPrintTab* self, GdkEventFocus* event) {
	gboolean result = FALSE;
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	Measurement _tmp2_ = {0};
	MeasurementUnit _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	Measurement new_height = {0};
	Measurement _tmp7_ = {0};
	Measurement min_height = {0};
	PrintJob* _tmp8_ = NULL;
	PrintSettings* _tmp9_ = NULL;
	PrintSettings* _tmp10_ = NULL;
	Measurement _tmp11_ = {0};
	Measurement _tmp12_ = {0};
	Measurement max_height = {0};
	PrintJob* _tmp13_ = NULL;
	PrintSettings* _tmp14_ = NULL;
	PrintSettings* _tmp15_ = NULL;
	Measurement _tmp16_ = {0};
	Measurement _tmp17_ = {0};
	gboolean _tmp18_ = FALSE;
	Measurement _tmp19_ = {0};
	gboolean _tmp20_ = FALSE;
	gboolean _tmp27_ = FALSE;
	Measurement _tmp39_ = {0};
	GtkEntry* _tmp40_ = NULL;
	Measurement _tmp41_ = {0};
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
#line 448 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), FALSE);
#line 448 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 449 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->custom_height_entry;
#line 449 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_entry_get_text (_tmp0_);
#line 449 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = self->priv->local_content_height;
#line 449 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = custom_print_tab_get_user_unit_choice (self);
#line 449 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = custom_print_tab_format_measurement_as (self, &_tmp2_, _tmp3_);
#line 449 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = _tmp4_;
#line 449 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = g_strcmp0 (_tmp1_, _tmp5_) == 0;
#line 449 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp5_);
#line 449 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp6_) {
#line 451 "/home/jens/Source/shotwell/src/Printing.vala"
		result = FALSE;
#line 451 "/home/jens/Source/shotwell/src/Printing.vala"
		return result;
#line 3204 "Printing.c"
	}
#line 453 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_get_height_entry_value (self, &_tmp7_);
#line 453 "/home/jens/Source/shotwell/src/Printing.vala"
	new_height = _tmp7_;
#line 454 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = self->priv->source_job;
#line 454 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = print_job_get_local_settings (_tmp8_);
#line 454 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = _tmp9_;
#line 454 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_get_minimum_content_dimension (_tmp10_, &_tmp11_);
#line 454 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp12_ = _tmp11_;
#line 454 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp10_);
#line 454 "/home/jens/Source/shotwell/src/Printing.vala"
	min_height = _tmp12_;
#line 455 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp13_ = self->priv->source_job;
#line 455 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_ = print_job_get_local_settings (_tmp13_);
#line 455 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp15_ = _tmp14_;
#line 455 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_get_maximum_content_dimension (_tmp15_, &_tmp16_);
#line 455 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp17_ = _tmp16_;
#line 455 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp15_);
#line 455 "/home/jens/Source/shotwell/src/Printing.vala"
	max_height = _tmp17_;
#line 457 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp19_ = min_height;
#line 457 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp20_ = measurement_is_less_than (&new_height, &_tmp19_);
#line 457 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp20_) {
#line 457 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp18_ = TRUE;
#line 3246 "Printing.c"
	} else {
		Measurement _tmp21_ = {0};
		gboolean _tmp22_ = FALSE;
#line 457 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp21_ = max_height;
#line 457 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp22_ = measurement_is_greater_than (&new_height, &_tmp21_);
#line 457 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp18_ = _tmp22_;
#line 3256 "Printing.c"
	}
#line 457 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp18_) {
#line 3260 "Printing.c"
		GtkEntry* _tmp23_ = NULL;
		Measurement _tmp24_ = {0};
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
#line 458 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp23_ = self->priv->custom_height_entry;
#line 458 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp24_ = self->priv->local_content_height;
#line 458 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp25_ = custom_print_tab_format_measurement (self, &_tmp24_);
#line 458 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp26_ = _tmp25_;
#line 458 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_entry_set_text (_tmp23_, _tmp26_);
#line 458 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_free0 (_tmp26_);
#line 459 "/home/jens/Source/shotwell/src/Printing.vala"
		result = FALSE;
#line 459 "/home/jens/Source/shotwell/src/Printing.vala"
		return result;
#line 3281 "Printing.c"
	}
#line 462 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp27_ = custom_print_tab_is_match_aspect_ratio_enabled (self);
#line 462 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp27_) {
#line 3287 "Printing.c"
		Measurement new_width = {0};
		Measurement _tmp28_ = {0};
		gdouble _tmp29_ = 0.0;
		PrintJob* _tmp30_ = NULL;
		gdouble _tmp31_ = 0.0;
		Measurement _tmp32_ = {0};
		MeasurementUnit _tmp33_ = 0;
		Measurement _tmp34_ = {0};
		GtkEntry* _tmp35_ = NULL;
		Measurement _tmp36_ = {0};
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
#line 463 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp28_ = new_height;
#line 463 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp29_ = _tmp28_.value;
#line 463 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp30_ = self->priv->source_job;
#line 463 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp31_ = print_job_get_source_aspect_ratio (_tmp30_);
#line 463 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp32_ = new_height;
#line 463 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp33_ = _tmp32_.unit;
#line 463 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&new_width, _tmp29_ * _tmp31_, _tmp33_);
#line 466 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp34_ = new_width;
#line 466 "/home/jens/Source/shotwell/src/Printing.vala"
		self->priv->local_content_width = _tmp34_;
#line 467 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp35_ = self->priv->custom_width_entry;
#line 467 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp36_ = new_width;
#line 467 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp37_ = custom_print_tab_format_measurement (self, &_tmp36_);
#line 467 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp38_ = _tmp37_;
#line 467 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_entry_set_text (_tmp35_, _tmp38_);
#line 467 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_free0 (_tmp38_);
#line 3330 "Printing.c"
	}
#line 470 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp39_ = new_height;
#line 470 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->local_content_height = _tmp39_;
#line 471 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp40_ = self->priv->custom_height_entry;
#line 471 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp41_ = new_height;
#line 471 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp42_ = custom_print_tab_format_measurement (self, &_tmp41_);
#line 471 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp43_ = _tmp42_;
#line 471 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_entry_set_text (_tmp40_, _tmp43_);
#line 471 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp43_);
#line 472 "/home/jens/Source/shotwell/src/Printing.vala"
	result = FALSE;
#line 472 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 3352 "Printing.c"
}


static MeasurementUnit custom_print_tab_get_user_unit_choice (CustomPrintTab* self) {
	MeasurementUnit result = 0;
	GtkComboBoxText* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 475 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), 0);
#line 476 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->units_combo;
#line 476 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_combo_box_get_type (), GtkComboBox));
#line 476 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp1_ == CUSTOM_PRINT_TAB_INCHES_COMBO_CHOICE) {
#line 477 "/home/jens/Source/shotwell/src/Printing.vala"
		result = MEASUREMENT_UNIT_INCHES;
#line 477 "/home/jens/Source/shotwell/src/Printing.vala"
		return result;
#line 3372 "Printing.c"
	} else {
		GtkComboBoxText* _tmp2_ = NULL;
		gint _tmp3_ = 0;
#line 478 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp2_ = self->priv->units_combo;
#line 478 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp3_ = gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_combo_box_get_type (), GtkComboBox));
#line 478 "/home/jens/Source/shotwell/src/Printing.vala"
		if (_tmp3_ == CUSTOM_PRINT_TAB_CENTIMETERS_COMBO_CHOICE) {
#line 479 "/home/jens/Source/shotwell/src/Printing.vala"
			result = MEASUREMENT_UNIT_CENTIMETERS;
#line 479 "/home/jens/Source/shotwell/src/Printing.vala"
			return result;
#line 3386 "Printing.c"
		} else {
#line 481 "/home/jens/Source/shotwell/src/Printing.vala"
			g_error ("Printing.vala:481: unknown unit combo box choice");
#line 3390 "Printing.c"
		}
	}
}


static void custom_print_tab_set_user_unit_choice (CustomPrintTab* self, MeasurementUnit unit) {
	MeasurementUnit _tmp0_ = 0;
#line 485 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 486 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = unit;
#line 486 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp0_ == MEASUREMENT_UNIT_INCHES) {
#line 3404 "Printing.c"
		GtkComboBoxText* _tmp1_ = NULL;
#line 487 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp1_ = self->priv->units_combo;
#line 487 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_combo_box_get_type (), GtkComboBox), CUSTOM_PRINT_TAB_INCHES_COMBO_CHOICE);
#line 3410 "Printing.c"
	} else {
		MeasurementUnit _tmp2_ = 0;
#line 488 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp2_ = unit;
#line 488 "/home/jens/Source/shotwell/src/Printing.vala"
		if (_tmp2_ == MEASUREMENT_UNIT_CENTIMETERS) {
#line 3417 "Printing.c"
			GtkComboBoxText* _tmp3_ = NULL;
#line 489 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp3_ = self->priv->units_combo;
#line 489 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_combo_box_get_type (), GtkComboBox), CUSTOM_PRINT_TAB_CENTIMETERS_COMBO_CHOICE);
#line 3423 "Printing.c"
		} else {
#line 491 "/home/jens/Source/shotwell/src/Printing.vala"
			g_error ("Printing.vala:491: unknown MeasurementUnit enumeration");
#line 3427 "Printing.c"
		}
	}
}


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
#line 869 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, 0.0);
#line 870 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 870 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
#line 870 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 870 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 3447 "Printing.c"
}


static void custom_print_tab_get_width_entry_value (CustomPrintTab* self, Measurement* result) {
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	MeasurementUnit _tmp3_ = 0;
	Measurement _tmp4_ = {0};
#line 495 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 496 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->custom_width_entry;
#line 496 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_entry_get_text (_tmp0_);
#line 496 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = double_parse (_tmp1_);
#line 496 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = custom_print_tab_get_user_unit_choice (self);
#line 496 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp4_, _tmp2_, _tmp3_);
#line 496 "/home/jens/Source/shotwell/src/Printing.vala"
	*result = _tmp4_;
#line 496 "/home/jens/Source/shotwell/src/Printing.vala"
	return;
#line 3473 "Printing.c"
}


static void custom_print_tab_get_height_entry_value (CustomPrintTab* self, Measurement* result) {
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	MeasurementUnit _tmp3_ = 0;
	Measurement _tmp4_ = {0};
#line 499 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 500 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->custom_height_entry;
#line 500 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_entry_get_text (_tmp0_);
#line 500 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = double_parse (_tmp1_);
#line 500 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = custom_print_tab_get_user_unit_choice (self);
#line 500 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp4_, _tmp2_, _tmp3_);
#line 500 "/home/jens/Source/shotwell/src/Printing.vala"
	*result = _tmp4_;
#line 500 "/home/jens/Source/shotwell/src/Printing.vala"
	return;
#line 3499 "Printing.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1376 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1376 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1377 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1377 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1377 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1377 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 3519 "Printing.c"
}


static void custom_print_tab_on_entry_insert_text (CustomPrintTab* self, GtkEditable* editable, const gchar* text, gint length, gint* position) {
	GtkEntry* sender = NULL;
	GtkEditable* _tmp0_ = NULL;
	GtkEntry* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	const gchar* decimal_point = NULL;
	const gchar* _tmp7_ = NULL;
	gboolean contains_decimal_point = FALSE;
	GtkEntry* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gchar* new_text = NULL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp42_ = NULL;
	gint _tmp43_ = 0;
	gint _tmp44_ = 0;
	GtkEntry* _tmp50_ = NULL;
#line 503 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 503 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GTK_IS_EDITABLE (editable));
#line 503 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (text != NULL);
#line 506 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = editable;
#line 506 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_entry_get_type (), GtkEntry));
#line 506 "/home/jens/Source/shotwell/src/Printing.vala"
	sender = _tmp1_;
#line 508 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = self->priv->is_text_insertion_in_progress;
#line 508 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp2_) {
#line 509 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_object_unref0 (sender);
#line 509 "/home/jens/Source/shotwell/src/Printing.vala"
		return;
#line 3562 "Printing.c"
	}
#line 511 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->is_text_insertion_in_progress = TRUE;
#line 513 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = length;
#line 513 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp3_ == -1) {
#line 3570 "Printing.c"
		const gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
#line 514 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp4_ = text;
#line 514 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = strlen (_tmp4_);
#line 514 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp6_ = _tmp5_;
#line 514 "/home/jens/Source/shotwell/src/Printing.vala"
		length = (gint) _tmp6_;
#line 3582 "Printing.c"
	}
#line 516 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = nl_langinfo (RADIXCHAR);
#line 516 "/home/jens/Source/shotwell/src/Printing.vala"
	decimal_point = _tmp7_;
#line 518 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = sender;
#line 518 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = gtk_entry_get_text (_tmp8_);
#line 518 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = decimal_point;
#line 518 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp11_ = string_contains (_tmp9_, _tmp10_);
#line 518 "/home/jens/Source/shotwell/src/Printing.vala"
	contains_decimal_point = _tmp11_;
#line 520 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp12_ = g_strdup ("");
#line 520 "/home/jens/Source/shotwell/src/Printing.vala"
	new_text = _tmp12_;
#line 3602 "Printing.c"
	{
		gint ctr = 0;
#line 521 "/home/jens/Source/shotwell/src/Printing.vala"
		ctr = 0;
#line 3607 "Printing.c"
		{
			gboolean _tmp13_ = FALSE;
#line 521 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp13_ = TRUE;
#line 521 "/home/jens/Source/shotwell/src/Printing.vala"
			while (TRUE) {
#line 3614 "Printing.c"
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				const gchar* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				gchar _tmp19_ = '\0';
				gboolean _tmp20_ = FALSE;
#line 521 "/home/jens/Source/shotwell/src/Printing.vala"
				if (!_tmp13_) {
#line 3623 "Printing.c"
					gint _tmp14_ = 0;
#line 521 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp14_ = ctr;
#line 521 "/home/jens/Source/shotwell/src/Printing.vala"
					ctr = _tmp14_ + 1;
#line 3629 "Printing.c"
				}
#line 521 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp13_ = FALSE;
#line 521 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp15_ = ctr;
#line 521 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp16_ = length;
#line 521 "/home/jens/Source/shotwell/src/Printing.vala"
				if (!(_tmp15_ < _tmp16_)) {
#line 521 "/home/jens/Source/shotwell/src/Printing.vala"
					break;
#line 3641 "Printing.c"
				}
#line 522 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp17_ = text;
#line 522 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp18_ = ctr;
#line 522 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp19_ = string_get (_tmp17_, (glong) _tmp18_);
#line 522 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp20_ = g_ascii_isdigit (_tmp19_);
#line 522 "/home/jens/Source/shotwell/src/Printing.vala"
				if (_tmp20_) {
#line 3653 "Printing.c"
					const gchar* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					gint _tmp23_ = 0;
					gchar _tmp24_ = '\0';
					gchar* _tmp25_ = NULL;
					gchar* _tmp26_ = NULL;
					gchar* _tmp27_ = NULL;
#line 523 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp21_ = new_text;
#line 523 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp22_ = text;
#line 523 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp23_ = ctr;
#line 523 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp24_ = string_get (_tmp22_, (glong) _tmp23_);
#line 523 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp25_ = g_strdup_printf ("%c", (gchar) _tmp24_);
#line 523 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp26_ = _tmp25_;
#line 523 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp27_ = g_strconcat (_tmp21_, _tmp26_, NULL);
#line 523 "/home/jens/Source/shotwell/src/Printing.vala"
					_g_free0 (new_text);
#line 523 "/home/jens/Source/shotwell/src/Printing.vala"
					new_text = _tmp27_;
#line 523 "/home/jens/Source/shotwell/src/Printing.vala"
					_g_free0 (_tmp26_);
#line 3681 "Printing.c"
				} else {
					gboolean _tmp28_ = FALSE;
					gboolean _tmp29_ = FALSE;
#line 524 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp29_ = contains_decimal_point;
#line 524 "/home/jens/Source/shotwell/src/Printing.vala"
					if (!_tmp29_) {
#line 3689 "Printing.c"
						const gchar* _tmp30_ = NULL;
						gint _tmp31_ = 0;
						gchar _tmp32_ = '\0';
						const gchar* _tmp33_ = NULL;
						gchar _tmp34_ = '\0';
#line 524 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp30_ = text;
#line 524 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp31_ = ctr;
#line 524 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp32_ = string_get (_tmp30_, (glong) _tmp31_);
#line 524 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp33_ = decimal_point;
#line 524 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp34_ = string_get (_tmp33_, (glong) 0);
#line 524 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp28_ = _tmp32_ == _tmp34_;
#line 3707 "Printing.c"
					} else {
#line 524 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp28_ = FALSE;
#line 3711 "Printing.c"
					}
#line 524 "/home/jens/Source/shotwell/src/Printing.vala"
					if (_tmp28_) {
#line 3715 "Printing.c"
						const gchar* _tmp35_ = NULL;
						const gchar* _tmp36_ = NULL;
						gint _tmp37_ = 0;
						gchar _tmp38_ = '\0';
						gchar* _tmp39_ = NULL;
						gchar* _tmp40_ = NULL;
						gchar* _tmp41_ = NULL;
#line 525 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp35_ = new_text;
#line 525 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp36_ = text;
#line 525 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp37_ = ctr;
#line 525 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp38_ = string_get (_tmp36_, (glong) _tmp37_);
#line 525 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp39_ = g_strdup_printf ("%c", (gchar) _tmp38_);
#line 525 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp40_ = _tmp39_;
#line 525 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp41_ = g_strconcat (_tmp35_, _tmp40_, NULL);
#line 525 "/home/jens/Source/shotwell/src/Printing.vala"
						_g_free0 (new_text);
#line 525 "/home/jens/Source/shotwell/src/Printing.vala"
						new_text = _tmp41_;
#line 525 "/home/jens/Source/shotwell/src/Printing.vala"
						_g_free0 (_tmp40_);
#line 3743 "Printing.c"
					}
				}
			}
		}
	}
#line 529 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp42_ = new_text;
#line 529 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp43_ = strlen (_tmp42_);
#line 529 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp44_ = _tmp43_;
#line 529 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp44_ > 0) {
#line 3757 "Printing.c"
		GtkEntry* _tmp45_ = NULL;
		const gchar* _tmp46_ = NULL;
		const gchar* _tmp47_ = NULL;
		gint _tmp48_ = 0;
		gint _tmp49_ = 0;
#line 530 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp45_ = sender;
#line 530 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp46_ = new_text;
#line 530 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp47_ = new_text;
#line 530 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp48_ = strlen (_tmp47_);
#line 530 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp49_ = _tmp48_;
#line 530 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_editable_insert_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, GTK_TYPE_EDITABLE, GtkEditable), _tmp46_, (gint) _tmp49_, position);
#line 3775 "Printing.c"
	}
#line 532 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp50_ = sender;
#line 532 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_stop_emission_by_name (_tmp50_, "insert-text");
#line 534 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->is_text_insertion_in_progress = FALSE;
#line 503 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (new_text);
#line 503 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (sender);
#line 3787 "Printing.c"
}


static void custom_print_tab_sync_state_from_job (CustomPrintTab* self, PrintJob* job) {
	PrintJob* _tmp0_ = NULL;
	PrintSettings* _tmp1_ = NULL;
	PrintSettings* _tmp2_ = NULL;
	Measurement _tmp3_ = {0};
	MeasurementUnit _tmp4_ = 0;
	PrintJob* _tmp5_ = NULL;
	PrintSettings* _tmp6_ = NULL;
	PrintSettings* _tmp7_ = NULL;
	Measurement _tmp8_ = {0};
	MeasurementUnit _tmp9_ = 0;
	Measurement constrained_width = {0};
	PrintJob* _tmp10_ = NULL;
	PrintSettings* _tmp11_ = NULL;
	PrintSettings* _tmp12_ = NULL;
	Measurement _tmp13_ = {0};
	Measurement _tmp14_ = {0};
	PrintJob* _tmp15_ = NULL;
	PrintSettings* _tmp16_ = NULL;
	PrintSettings* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	Measurement _tmp32_ = {0};
	PrintJob* _tmp33_ = NULL;
	PrintSettings* _tmp34_ = NULL;
	PrintSettings* _tmp35_ = NULL;
	Measurement _tmp36_ = {0};
	PrintJob* _tmp37_ = NULL;
	PrintSettings* _tmp38_ = NULL;
	PrintSettings* _tmp39_ = NULL;
	ContentLayout _tmp40_ = 0;
	PrintJob* _tmp41_ = NULL;
	PrintSettings* _tmp42_ = NULL;
	PrintSettings* _tmp43_ = NULL;
	gint _tmp44_ = 0;
	PrintJob* _tmp45_ = NULL;
	PrintSettings* _tmp46_ = NULL;
	PrintSettings* _tmp47_ = NULL;
	gint _tmp48_ = 0;
	PrintJob* _tmp49_ = NULL;
	PrintSettings* _tmp50_ = NULL;
	PrintSettings* _tmp51_ = NULL;
	gint _tmp52_ = 0;
	PrintJob* _tmp53_ = NULL;
	PrintSettings* _tmp54_ = NULL;
	PrintSettings* _tmp55_ = NULL;
	gboolean _tmp56_ = FALSE;
	PrintJob* _tmp57_ = NULL;
	PrintSettings* _tmp58_ = NULL;
	PrintSettings* _tmp59_ = NULL;
	gboolean _tmp60_ = FALSE;
	PrintJob* _tmp61_ = NULL;
	PrintSettings* _tmp62_ = NULL;
	PrintSettings* _tmp63_ = NULL;
	gchar* _tmp64_ = NULL;
	gchar* _tmp65_ = NULL;
#line 537 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 537 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_JOB (job));
#line 538 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = job;
#line 538 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = print_job_get_local_settings (_tmp0_);
#line 538 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = _tmp1_;
#line 538 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_get_content_width (_tmp2_, &_tmp3_);
#line 538 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = _tmp3_.unit;
#line 538 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = job;
#line 538 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = print_job_get_local_settings (_tmp5_);
#line 538 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = _tmp6_;
#line 538 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_get_content_height (_tmp7_, &_tmp8_);
#line 538 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = _tmp8_.unit;
#line 538 "/home/jens/Source/shotwell/src/Printing.vala"
	_vala_assert (_tmp4_ == _tmp9_, "job.get_local_settings().get_content_width().unit ==             job.get_local_settings().get_content_height().unit");
#line 538 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp7_);
#line 538 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp2_);
#line 541 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = job;
#line 541 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp11_ = print_job_get_local_settings (_tmp10_);
#line 541 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp12_ = _tmp11_;
#line 541 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_get_content_width (_tmp12_, &_tmp13_);
#line 541 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_ = _tmp13_;
#line 541 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp12_);
#line 541 "/home/jens/Source/shotwell/src/Printing.vala"
	constrained_width = _tmp14_;
#line 542 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp15_ = job;
#line 542 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp16_ = print_job_get_local_settings (_tmp15_);
#line 542 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp17_ = _tmp16_;
#line 542 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp18_ = print_settings_is_match_aspect_ratio_enabled (_tmp17_);
#line 542 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp19_ = _tmp18_;
#line 542 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp17_);
#line 542 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp19_) {
#line 3905 "Printing.c"
		PrintJob* _tmp20_ = NULL;
		PrintSettings* _tmp21_ = NULL;
		PrintSettings* _tmp22_ = NULL;
		Measurement _tmp23_ = {0};
		gdouble _tmp24_ = 0.0;
		PrintJob* _tmp25_ = NULL;
		gdouble _tmp26_ = 0.0;
		PrintJob* _tmp27_ = NULL;
		PrintSettings* _tmp28_ = NULL;
		PrintSettings* _tmp29_ = NULL;
		Measurement _tmp30_ = {0};
		MeasurementUnit _tmp31_ = 0;
#line 543 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp20_ = job;
#line 543 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp21_ = print_job_get_local_settings (_tmp20_);
#line 543 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp22_ = _tmp21_;
#line 543 "/home/jens/Source/shotwell/src/Printing.vala"
		print_settings_get_content_height (_tmp22_, &_tmp23_);
#line 543 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp24_ = _tmp23_.value;
#line 543 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp25_ = job;
#line 543 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp26_ = print_job_get_source_aspect_ratio (_tmp25_);
#line 543 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp27_ = job;
#line 543 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp28_ = print_job_get_local_settings (_tmp27_);
#line 543 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp29_ = _tmp28_;
#line 543 "/home/jens/Source/shotwell/src/Printing.vala"
		print_settings_get_content_height (_tmp29_, &_tmp30_);
#line 543 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp31_ = _tmp30_.unit;
#line 543 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&constrained_width, _tmp24_ * _tmp26_, _tmp31_);
#line 543 "/home/jens/Source/shotwell/src/Printing.vala"
		_print_settings_unref0 (_tmp29_);
#line 543 "/home/jens/Source/shotwell/src/Printing.vala"
		_print_settings_unref0 (_tmp22_);
#line 3948 "Printing.c"
	}
#line 545 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp32_ = constrained_width;
#line 545 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_set_content_width (self, &_tmp32_);
#line 546 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp33_ = job;
#line 546 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp34_ = print_job_get_local_settings (_tmp33_);
#line 546 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp35_ = _tmp34_;
#line 546 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_get_content_height (_tmp35_, &_tmp36_);
#line 546 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_set_content_height (self, &_tmp36_);
#line 546 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp35_);
#line 547 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp37_ = job;
#line 547 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp38_ = print_job_get_local_settings (_tmp37_);
#line 547 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp39_ = _tmp38_;
#line 547 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp40_ = print_settings_get_content_layout (_tmp39_);
#line 547 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_set_content_layout (self, _tmp40_);
#line 547 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp39_);
#line 548 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp41_ = job;
#line 548 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp42_ = print_job_get_local_settings (_tmp41_);
#line 548 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp43_ = _tmp42_;
#line 548 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp44_ = print_settings_get_content_ppi (_tmp43_);
#line 548 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_set_content_ppi (self, _tmp44_);
#line 548 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp43_);
#line 549 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp45_ = job;
#line 549 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp46_ = print_job_get_local_settings (_tmp45_);
#line 549 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp47_ = _tmp46_;
#line 549 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp48_ = print_settings_get_image_per_page_selection (_tmp47_);
#line 549 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_set_image_per_page_selection (self, _tmp48_);
#line 549 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp47_);
#line 550 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp49_ = job;
#line 550 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp50_ = print_job_get_local_settings (_tmp49_);
#line 550 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp51_ = _tmp50_;
#line 550 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp52_ = print_settings_get_size_selection (_tmp51_);
#line 550 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_set_size_selection (self, _tmp52_);
#line 550 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp51_);
#line 551 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp53_ = job;
#line 551 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp54_ = print_job_get_local_settings (_tmp53_);
#line 551 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp55_ = _tmp54_;
#line 551 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp56_ = print_settings_is_match_aspect_ratio_enabled (_tmp55_);
#line 551 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_set_match_aspect_ratio_enabled (self, _tmp56_);
#line 551 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp55_);
#line 552 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp57_ = job;
#line 552 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp58_ = print_job_get_local_settings (_tmp57_);
#line 552 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp59_ = _tmp58_;
#line 552 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp60_ = print_settings_is_print_titles_enabled (_tmp59_);
#line 552 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_set_print_titles_enabled (self, _tmp60_);
#line 552 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp59_);
#line 553 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp61_ = job;
#line 553 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp62_ = print_job_get_local_settings (_tmp61_);
#line 553 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp63_ = _tmp62_;
#line 553 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp64_ = print_settings_get_print_titles_font (_tmp63_);
#line 553 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp65_ = _tmp64_;
#line 553 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_set_print_titles_font (self, _tmp65_);
#line 553 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp65_);
#line 553 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp63_);
#line 4054 "Printing.c"
}


static void custom_print_tab_on_radio_group_click (CustomPrintTab* self, GtkButton* b) {
	GtkRadioButton* sender = NULL;
	GtkButton* _tmp0_ = NULL;
	GtkRadioButton* _tmp1_ = NULL;
	GtkRadioButton* _tmp2_ = NULL;
	GtkRadioButton* _tmp3_ = NULL;
#line 556 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 556 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GTK_IS_BUTTON (b));
#line 557 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = b;
#line 557 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_radio_button_get_type (), GtkRadioButton));
#line 557 "/home/jens/Source/shotwell/src/Printing.vala"
	sender = _tmp1_;
#line 559 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = sender;
#line 559 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = self->priv->standard_size_radio;
#line 559 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp2_ == _tmp3_) {
#line 4080 "Printing.c"
		GtkComboBox* _tmp4_ = NULL;
#line 560 "/home/jens/Source/shotwell/src/Printing.vala"
		custom_print_tab_set_content_layout_control_state (self, CONTENT_LAYOUT_STANDARD_SIZE);
#line 561 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp4_ = self->priv->standard_sizes_combo;
#line 561 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget));
#line 4088 "Printing.c"
	} else {
		GtkRadioButton* _tmp5_ = NULL;
		GtkRadioButton* _tmp6_ = NULL;
#line 562 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = sender;
#line 562 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp6_ = self->priv->custom_size_radio;
#line 562 "/home/jens/Source/shotwell/src/Printing.vala"
		if (_tmp5_ == _tmp6_) {
#line 4098 "Printing.c"
			GtkEntry* _tmp7_ = NULL;
#line 563 "/home/jens/Source/shotwell/src/Printing.vala"
			custom_print_tab_set_content_layout_control_state (self, CONTENT_LAYOUT_CUSTOM_SIZE);
#line 564 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp7_ = self->priv->custom_height_entry;
#line 564 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
#line 4106 "Printing.c"
		} else {
			GtkRadioButton* _tmp8_ = NULL;
			GtkRadioButton* _tmp9_ = NULL;
#line 565 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp8_ = sender;
#line 565 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp9_ = self->priv->image_per_page_radio;
#line 565 "/home/jens/Source/shotwell/src/Printing.vala"
			if (_tmp8_ == _tmp9_) {
#line 566 "/home/jens/Source/shotwell/src/Printing.vala"
				custom_print_tab_set_content_layout_control_state (self, CONTENT_LAYOUT_IMAGE_PER_PAGE);
#line 4118 "Printing.c"
			}
		}
	}
#line 556 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (sender);
#line 4124 "Printing.c"
}


static void custom_print_tab_on_units_combo_changed (CustomPrintTab* self) {
	GtkEntry* _tmp0_ = NULL;
	Measurement _tmp1_ = {0};
	MeasurementUnit _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GtkEntry* _tmp5_ = NULL;
	Measurement _tmp6_ = {0};
	MeasurementUnit _tmp7_ = 0;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
#line 570 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 571 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->custom_height_entry;
#line 571 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = self->priv->local_content_height;
#line 571 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = custom_print_tab_get_user_unit_choice (self);
#line 571 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = custom_print_tab_format_measurement_as (self, &_tmp1_, _tmp2_);
#line 571 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = _tmp3_;
#line 571 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_entry_set_text (_tmp0_, _tmp4_);
#line 571 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp4_);
#line 573 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = self->priv->custom_width_entry;
#line 573 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = self->priv->local_content_width;
#line 573 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = custom_print_tab_get_user_unit_choice (self);
#line 573 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = custom_print_tab_format_measurement_as (self, &_tmp6_, _tmp7_);
#line 573 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = _tmp8_;
#line 573 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_entry_set_text (_tmp5_, _tmp9_);
#line 573 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp9_);
#line 4169 "Printing.c"
}


static void custom_print_tab_set_content_layout_control_state (CustomPrintTab* self, ContentLayout layout) {
	ContentLayout _tmp0_ = 0;
#line 577 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 578 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = layout;
#line 578 "/home/jens/Source/shotwell/src/Printing.vala"
	switch (_tmp0_) {
#line 578 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_STANDARD_SIZE:
#line 4183 "Printing.c"
		{
			GtkComboBox* _tmp1_ = NULL;
			GtkComboBoxText* _tmp2_ = NULL;
			GtkEntry* _tmp3_ = NULL;
			GtkEntry* _tmp4_ = NULL;
			GtkCheckButton* _tmp5_ = NULL;
			GtkComboBox* _tmp6_ = NULL;
#line 580 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp1_ = self->priv->standard_sizes_combo;
#line 580 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), TRUE);
#line 581 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp2_ = self->priv->units_combo;
#line 581 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 582 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp3_ = self->priv->custom_width_entry;
#line 582 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 583 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp4_ = self->priv->custom_height_entry;
#line 583 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 584 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp5_ = self->priv->aspect_ratio_check;
#line 584 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 585 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp6_ = self->priv->image_per_page_combo;
#line 585 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 586 "/home/jens/Source/shotwell/src/Printing.vala"
			break;
#line 4217 "Printing.c"
		}
#line 578 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_CUSTOM_SIZE:
#line 4221 "Printing.c"
		{
			GtkComboBox* _tmp7_ = NULL;
			GtkComboBoxText* _tmp8_ = NULL;
			GtkEntry* _tmp9_ = NULL;
			GtkEntry* _tmp10_ = NULL;
			GtkCheckButton* _tmp11_ = NULL;
			GtkComboBox* _tmp12_ = NULL;
#line 589 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp7_ = self->priv->standard_sizes_combo;
#line 589 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 590 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp8_ = self->priv->units_combo;
#line 590 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget), TRUE);
#line 591 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp9_ = self->priv->custom_width_entry;
#line 591 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), TRUE);
#line 592 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp10_ = self->priv->custom_height_entry;
#line 592 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), TRUE);
#line 593 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp11_ = self->priv->aspect_ratio_check;
#line 593 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget), TRUE);
#line 594 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp12_ = self->priv->image_per_page_combo;
#line 594 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 595 "/home/jens/Source/shotwell/src/Printing.vala"
			break;
#line 4255 "Printing.c"
		}
#line 578 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_IMAGE_PER_PAGE:
#line 4259 "Printing.c"
		{
			GtkComboBox* _tmp13_ = NULL;
			GtkComboBoxText* _tmp14_ = NULL;
			GtkEntry* _tmp15_ = NULL;
			GtkEntry* _tmp16_ = NULL;
			GtkCheckButton* _tmp17_ = NULL;
			GtkComboBox* _tmp18_ = NULL;
#line 598 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp13_ = self->priv->standard_sizes_combo;
#line 598 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 599 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp14_ = self->priv->units_combo;
#line 599 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 600 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp15_ = self->priv->custom_width_entry;
#line 600 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 601 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp16_ = self->priv->custom_height_entry;
#line 601 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 602 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp17_ = self->priv->aspect_ratio_check;
#line 602 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 603 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp18_ = self->priv->image_per_page_combo;
#line 603 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget), TRUE);
#line 604 "/home/jens/Source/shotwell/src/Printing.vala"
			break;
#line 4293 "Printing.c"
		}
		default:
		{
#line 607 "/home/jens/Source/shotwell/src/Printing.vala"
			g_error ("Printing.vala:607: unknown ContentLayout enumeration value");
#line 4299 "Printing.c"
		}
	}
}


static gboolean custom_print_tab_standard_sizes_combo_separator_func (GtkTreeModel* model, GtkTreeIter* iter) {
	gboolean result = FALSE;
	GValue val = {0};
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	GValue _tmp2_ = {0};
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 611 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (GTK_IS_TREE_MODEL (model), FALSE);
#line 611 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 614 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = model;
#line 614 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = *iter;
#line 614 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_tree_model_get_value (_tmp0_, &_tmp1_, 0, &_tmp2_);
#line 614 "/home/jens/Source/shotwell/src/Printing.vala"
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
#line 614 "/home/jens/Source/shotwell/src/Printing.vala"
	val = _tmp2_;
#line 616 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = g_value_dup_string (&val);
#line 616 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = _tmp3_;
#line 616 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = g_strcmp0 (_tmp4_, "-") == 0;
#line 616 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp4_);
#line 616 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp5_;
#line 616 "/home/jens/Source/shotwell/src/Printing.vala"
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
#line 616 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 4342 "Printing.c"
}


static void custom_print_tab_set_content_layout (CustomPrintTab* self, ContentLayout content_layout) {
	ContentLayout _tmp0_ = 0;
	ContentLayout _tmp1_ = 0;
#line 619 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 620 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = content_layout;
#line 620 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_set_content_layout_control_state (self, _tmp0_);
#line 621 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = content_layout;
#line 621 "/home/jens/Source/shotwell/src/Printing.vala"
	switch (_tmp1_) {
#line 621 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_STANDARD_SIZE:
#line 4361 "Printing.c"
		{
			GtkRadioButton* _tmp2_ = NULL;
#line 623 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp2_ = self->priv->standard_size_radio;
#line 623 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_toggle_button_get_type (), GtkToggleButton), TRUE);
#line 624 "/home/jens/Source/shotwell/src/Printing.vala"
			break;
#line 4370 "Printing.c"
		}
#line 621 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_CUSTOM_SIZE:
#line 4374 "Printing.c"
		{
			GtkRadioButton* _tmp3_ = NULL;
#line 627 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp3_ = self->priv->custom_size_radio;
#line 627 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_toggle_button_get_type (), GtkToggleButton), TRUE);
#line 628 "/home/jens/Source/shotwell/src/Printing.vala"
			break;
#line 4383 "Printing.c"
		}
#line 621 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_IMAGE_PER_PAGE:
#line 4387 "Printing.c"
		{
			GtkRadioButton* _tmp4_ = NULL;
#line 631 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp4_ = self->priv->image_per_page_radio;
#line 631 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_toggle_button_get_type (), GtkToggleButton), TRUE);
#line 632 "/home/jens/Source/shotwell/src/Printing.vala"
			break;
#line 4396 "Printing.c"
		}
		default:
		{
#line 635 "/home/jens/Source/shotwell/src/Printing.vala"
			g_error ("Printing.vala:635: unknown ContentLayout enumeration value");
#line 4402 "Printing.c"
		}
	}
}


static ContentLayout custom_print_tab_get_content_layout (CustomPrintTab* self) {
	ContentLayout result = 0;
	GtkRadioButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GtkRadioButton* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GtkRadioButton* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 639 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), 0);
#line 640 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->standard_size_radio;
#line 640 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton));
#line 640 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp1_) {
#line 641 "/home/jens/Source/shotwell/src/Printing.vala"
		result = CONTENT_LAYOUT_STANDARD_SIZE;
#line 641 "/home/jens/Source/shotwell/src/Printing.vala"
		return result;
#line 4428 "Printing.c"
	}
#line 642 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = self->priv->custom_size_radio;
#line 642 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_toggle_button_get_type (), GtkToggleButton));
#line 642 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp3_) {
#line 643 "/home/jens/Source/shotwell/src/Printing.vala"
		result = CONTENT_LAYOUT_CUSTOM_SIZE;
#line 643 "/home/jens/Source/shotwell/src/Printing.vala"
		return result;
#line 4440 "Printing.c"
	}
#line 644 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = self->priv->image_per_page_radio;
#line 644 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_toggle_button_get_type (), GtkToggleButton));
#line 644 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp5_) {
#line 645 "/home/jens/Source/shotwell/src/Printing.vala"
		result = CONTENT_LAYOUT_IMAGE_PER_PAGE;
#line 645 "/home/jens/Source/shotwell/src/Printing.vala"
		return result;
#line 4452 "Printing.c"
	}
#line 647 "/home/jens/Source/shotwell/src/Printing.vala"
	g_error ("Printing.vala:647: inconsistent content layout radio button group stat" \
"e");
#line 4456 "Printing.c"
}


static void custom_print_tab_set_content_width (CustomPrintTab* self, Measurement* content_width) {
	Measurement _tmp0_ = {0};
	MeasurementUnit _tmp1_ = 0;
	Measurement _tmp2_ = {0};
	MeasurementUnit _tmp3_ = 0;
	Measurement _tmp13_ = {0};
	GtkEntry* _tmp14_ = NULL;
	Measurement _tmp15_ = {0};
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
#line 650 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 650 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (content_width != NULL);
#line 651 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = *content_width;
#line 651 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _tmp0_.unit;
#line 651 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = self->priv->local_content_height;
#line 651 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = _tmp2_.unit;
#line 651 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp1_ != _tmp3_) {
#line 4484 "Printing.c"
		Measurement _tmp4_ = {0};
		MeasurementUnit _tmp5_ = 0;
		Measurement _tmp6_ = {0};
		MeasurementUnit _tmp7_ = 0;
		Measurement _tmp8_ = {0};
		GtkEntry* _tmp9_ = NULL;
		Measurement _tmp10_ = {0};
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
#line 652 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp4_ = *content_width;
#line 652 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = _tmp4_.unit;
#line 652 "/home/jens/Source/shotwell/src/Printing.vala"
		custom_print_tab_set_user_unit_choice (self, _tmp5_);
#line 653 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp6_ = *content_width;
#line 653 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp7_ = _tmp6_.unit;
#line 653 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_convert_to (&self->priv->local_content_height, _tmp7_, &_tmp8_);
#line 653 "/home/jens/Source/shotwell/src/Printing.vala"
		self->priv->local_content_height = _tmp8_;
#line 654 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp9_ = self->priv->custom_height_entry;
#line 654 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp10_ = self->priv->local_content_height;
#line 654 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp11_ = custom_print_tab_format_measurement (self, &_tmp10_);
#line 654 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp12_ = _tmp11_;
#line 654 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_entry_set_text (_tmp9_, _tmp12_);
#line 654 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_free0 (_tmp12_);
#line 4520 "Printing.c"
	}
#line 656 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp13_ = *content_width;
#line 656 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->local_content_width = _tmp13_;
#line 657 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_ = self->priv->custom_width_entry;
#line 657 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp15_ = *content_width;
#line 657 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp16_ = custom_print_tab_format_measurement (self, &_tmp15_);
#line 657 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp17_ = _tmp16_;
#line 657 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_entry_set_text (_tmp14_, _tmp17_);
#line 657 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp17_);
#line 4538 "Printing.c"
}


static void custom_print_tab_get_content_width (CustomPrintTab* self, Measurement* result) {
	Measurement _tmp0_ = {0};
#line 660 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 661 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->local_content_width;
#line 661 "/home/jens/Source/shotwell/src/Printing.vala"
	*result = _tmp0_;
#line 661 "/home/jens/Source/shotwell/src/Printing.vala"
	return;
#line 4552 "Printing.c"
}


static void custom_print_tab_set_content_height (CustomPrintTab* self, Measurement* content_height) {
	Measurement _tmp0_ = {0};
	MeasurementUnit _tmp1_ = 0;
	Measurement _tmp2_ = {0};
	MeasurementUnit _tmp3_ = 0;
	Measurement _tmp13_ = {0};
	GtkEntry* _tmp14_ = NULL;
	Measurement _tmp15_ = {0};
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
#line 664 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 664 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (content_height != NULL);
#line 665 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = *content_height;
#line 665 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _tmp0_.unit;
#line 665 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = self->priv->local_content_width;
#line 665 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = _tmp2_.unit;
#line 665 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp1_ != _tmp3_) {
#line 4580 "Printing.c"
		Measurement _tmp4_ = {0};
		MeasurementUnit _tmp5_ = 0;
		Measurement _tmp6_ = {0};
		MeasurementUnit _tmp7_ = 0;
		Measurement _tmp8_ = {0};
		GtkEntry* _tmp9_ = NULL;
		Measurement _tmp10_ = {0};
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
#line 666 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp4_ = *content_height;
#line 666 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = _tmp4_.unit;
#line 666 "/home/jens/Source/shotwell/src/Printing.vala"
		custom_print_tab_set_user_unit_choice (self, _tmp5_);
#line 667 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp6_ = *content_height;
#line 667 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp7_ = _tmp6_.unit;
#line 667 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_convert_to (&self->priv->local_content_width, _tmp7_, &_tmp8_);
#line 667 "/home/jens/Source/shotwell/src/Printing.vala"
		self->priv->local_content_width = _tmp8_;
#line 668 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp9_ = self->priv->custom_width_entry;
#line 668 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp10_ = self->priv->local_content_width;
#line 668 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp11_ = custom_print_tab_format_measurement (self, &_tmp10_);
#line 668 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp12_ = _tmp11_;
#line 668 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_entry_set_text (_tmp9_, _tmp12_);
#line 668 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_free0 (_tmp12_);
#line 4616 "Printing.c"
	}
#line 670 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp13_ = *content_height;
#line 670 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->local_content_height = _tmp13_;
#line 671 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_ = self->priv->custom_height_entry;
#line 671 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp15_ = *content_height;
#line 671 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp16_ = custom_print_tab_format_measurement (self, &_tmp15_);
#line 671 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp17_ = _tmp16_;
#line 671 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_entry_set_text (_tmp14_, _tmp17_);
#line 671 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp17_);
#line 4634 "Printing.c"
}


static void custom_print_tab_get_content_height (CustomPrintTab* self, Measurement* result) {
	Measurement _tmp0_ = {0};
#line 674 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 675 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->local_content_height;
#line 675 "/home/jens/Source/shotwell/src/Printing.vala"
	*result = _tmp0_;
#line 675 "/home/jens/Source/shotwell/src/Printing.vala"
	return;
#line 4648 "Printing.c"
}


static void custom_print_tab_set_content_ppi (CustomPrintTab* self, gint content_ppi) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GtkEntry* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
#line 678 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 679 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = content_ppi;
#line 679 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = CLAMP (_tmp0_, PRINT_SETTINGS_MIN_CONTENT_PPI, PRINT_SETTINGS_MAX_CONTENT_PPI);
#line 679 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->local_content_ppi = _tmp1_;
#line 682 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = self->priv->ppi_entry;
#line 682 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = self->priv->local_content_ppi;
#line 682 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = g_strdup_printf ("%d", _tmp3_);
#line 682 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = _tmp4_;
#line 682 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_entry_set_text (_tmp2_, _tmp5_);
#line 682 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp5_);
#line 4679 "Printing.c"
}


static gint custom_print_tab_get_content_ppi (CustomPrintTab* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 685 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), 0);
#line 686 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->local_content_ppi;
#line 686 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp0_;
#line 686 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 4694 "Printing.c"
}


static void custom_print_tab_set_image_per_page_selection (CustomPrintTab* self, gint image_per_page) {
	GtkComboBox* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 689 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 690 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->image_per_page_combo;
#line 690 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = image_per_page;
#line 690 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_combo_box_set_active (_tmp0_, _tmp1_);
#line 4709 "Printing.c"
}


static gint custom_print_tab_get_image_per_page_selection (CustomPrintTab* self) {
	gint result = 0;
	GtkComboBox* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 693 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), 0);
#line 694 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->image_per_page_combo;
#line 694 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_combo_box_get_active (_tmp0_);
#line 694 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 694 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 4727 "Printing.c"
}


static void custom_print_tab_set_size_selection (CustomPrintTab* self, gint size_selection) {
	GtkComboBox* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 697 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 698 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->standard_sizes_combo;
#line 698 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = size_selection;
#line 698 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_combo_box_set_active (_tmp0_, _tmp1_);
#line 4742 "Printing.c"
}


static gint custom_print_tab_get_size_selection (CustomPrintTab* self) {
	gint result = 0;
	GtkComboBox* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 701 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), 0);
#line 702 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->standard_sizes_combo;
#line 702 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_combo_box_get_active (_tmp0_);
#line 702 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 702 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 4760 "Printing.c"
}


static void custom_print_tab_set_match_aspect_ratio_enabled (CustomPrintTab* self, gboolean enable_state) {
	GtkCheckButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 705 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 706 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->aspect_ratio_check;
#line 706 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = enable_state;
#line 706 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton), _tmp1_);
#line 4775 "Printing.c"
}


static void custom_print_tab_set_print_titles_enabled (CustomPrintTab* self, gboolean print_titles) {
	GtkCheckButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 709 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 710 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->title_print_check;
#line 710 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = print_titles;
#line 710 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton), _tmp1_);
#line 4790 "Printing.c"
}


static void custom_print_tab_set_print_titles_font (CustomPrintTab* self, const gchar* fontname) {
	GtkFontButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 713 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 713 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (fontname != NULL);
#line 714 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->title_print_font;
#line 714 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = fontname;
#line 714 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_font_button_set_font_name (_tmp0_, _tmp1_);
#line 4807 "Printing.c"
}


static gboolean custom_print_tab_is_match_aspect_ratio_enabled (CustomPrintTab* self) {
	gboolean result = FALSE;
	GtkCheckButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 718 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), FALSE);
#line 719 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->aspect_ratio_check;
#line 719 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton));
#line 719 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 719 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 4825 "Printing.c"
}


static gboolean custom_print_tab_is_print_titles_enabled (CustomPrintTab* self) {
	gboolean result = FALSE;
	GtkCheckButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 722 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), FALSE);
#line 723 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->title_print_check;
#line 723 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton));
#line 723 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 723 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 4843 "Printing.c"
}


static gchar* custom_print_tab_get_print_titles_font (CustomPrintTab* self) {
	gchar* result = NULL;
	GtkFontButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 726 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), NULL);
#line 727 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->title_print_font;
#line 727 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_font_button_get_font_name (_tmp0_);
#line 727 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 727 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp2_;
#line 727 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 4864 "Printing.c"
}


PrintJob* custom_print_tab_get_source_job (CustomPrintTab* self) {
	PrintJob* result = NULL;
	PrintJob* _tmp0_ = NULL;
	PrintJob* _tmp1_ = NULL;
#line 730 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), NULL);
#line 731 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->source_job;
#line 731 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 731 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 731 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 4882 "Printing.c"
}


PrintSettings* custom_print_tab_get_local_settings (CustomPrintTab* self) {
	PrintSettings* result = NULL;
	PrintSettings* _result_ = NULL;
	PrintSettings* _tmp0_ = NULL;
	Measurement _tmp1_ = {0};
	Measurement _tmp2_ = {0};
	ContentLayout _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
#line 734 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), NULL);
#line 735 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = print_settings_new ();
#line 735 "/home/jens/Source/shotwell/src/Printing.vala"
	_result_ = _tmp0_;
#line 737 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_get_content_width (self, &_tmp1_);
#line 737 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_set_content_width (_result_, &_tmp1_);
#line 738 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_get_content_height (self, &_tmp2_);
#line 738 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_set_content_height (_result_, &_tmp2_);
#line 739 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = custom_print_tab_get_content_layout (self);
#line 739 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_set_content_layout (_result_, _tmp3_);
#line 740 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = custom_print_tab_get_content_ppi (self);
#line 740 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_set_content_ppi (_result_, _tmp4_);
#line 741 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = custom_print_tab_get_image_per_page_selection (self);
#line 741 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_set_image_per_page_selection (_result_, _tmp5_);
#line 742 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = custom_print_tab_get_size_selection (self);
#line 742 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_set_size_selection (_result_, _tmp6_);
#line 743 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = custom_print_tab_is_match_aspect_ratio_enabled (self);
#line 743 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_set_match_aspect_ratio_enabled (_result_, _tmp7_);
#line 744 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = custom_print_tab_is_print_titles_enabled (self);
#line 744 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_set_print_titles_enabled (_result_, _tmp8_);
#line 745 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = custom_print_tab_get_print_titles_font (self);
#line 745 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = _tmp9_;
#line 745 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_set_print_titles_font (_result_, _tmp10_);
#line 745 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp10_);
#line 747 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _result_;
#line 747 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 4950 "Printing.c"
}


static void custom_print_tab_class_init (CustomPrintTabClass * klass) {
#line 268 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_parent_class = g_type_class_peek_parent (klass);
#line 268 "/home/jens/Source/shotwell/src/Printing.vala"
	g_type_class_add_private (klass, sizeof (CustomPrintTabPrivate));
#line 268 "/home/jens/Source/shotwell/src/Printing.vala"
	G_OBJECT_CLASS (klass)->finalize = custom_print_tab_finalize;
#line 4961 "Printing.c"
}


static void custom_print_tab_instance_init (CustomPrintTab * self) {
#line 268 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv = CUSTOM_PRINT_TAB_GET_PRIVATE (self);
#line 272 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->custom_image_settings_pane = NULL;
#line 273 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->standard_size_radio = NULL;
#line 274 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->custom_size_radio = NULL;
#line 275 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->image_per_page_radio = NULL;
#line 276 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->image_per_page_combo = NULL;
#line 277 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->standard_sizes_combo = NULL;
#line 278 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->units_combo = NULL;
#line 279 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->custom_width_entry = NULL;
#line 280 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->custom_height_entry = NULL;
#line 282 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->aspect_ratio_check = NULL;
#line 283 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->title_print_check = NULL;
#line 284 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->title_print_font = NULL;
#line 285 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&self->priv->local_content_width, 5.0, MEASUREMENT_UNIT_INCHES);
#line 286 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&self->priv->local_content_height, 5.0, MEASUREMENT_UNIT_INCHES);
#line 288 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->is_text_insertion_in_progress = FALSE;
#line 4998 "Printing.c"
}


static void custom_print_tab_finalize (GObject* obj) {
	CustomPrintTab * self;
#line 268 "/home/jens/Source/shotwell/src/Printing.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CUSTOM_PRINT_TAB, CustomPrintTab);
#line 272 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->custom_image_settings_pane);
#line 273 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->standard_size_radio);
#line 274 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->custom_size_radio);
#line 275 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->image_per_page_radio);
#line 276 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->image_per_page_combo);
#line 277 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->standard_sizes_combo);
#line 278 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->units_combo);
#line 279 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->custom_width_entry);
#line 280 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->custom_height_entry);
#line 281 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->ppi_entry);
#line 282 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->aspect_ratio_check);
#line 283 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->title_print_check);
#line 284 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->title_print_font);
#line 289 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->source_job);
#line 268 "/home/jens/Source/shotwell/src/Printing.vala"
	G_OBJECT_CLASS (custom_print_tab_parent_class)->finalize (obj);
#line 5036 "Printing.c"
}


GType custom_print_tab_get_type (void) {
	static volatile gsize custom_print_tab_type_id__volatile = 0;
	if (g_once_init_enter (&custom_print_tab_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CustomPrintTabClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) custom_print_tab_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CustomPrintTab), 0, (GInstanceInitFunc) custom_print_tab_instance_init, NULL };
		GType custom_print_tab_type_id;
		custom_print_tab_type_id = g_type_register_static (gtk_fixed_get_type (), "CustomPrintTab", &g_define_type_info, 0);
		g_once_init_leave (&custom_print_tab_type_id__volatile, custom_print_tab_type_id);
	}
	return custom_print_tab_type_id__volatile;
}


PrintJob* print_job_construct (GType object_type, GeeCollection* to_print) {
	PrintJob * self = NULL;
	PrintManager* _tmp0_ = NULL;
	PrintManager* _tmp1_ = NULL;
	PrintSettings* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	GeeCollection* _tmp4_ = NULL;
	gdouble photo_aspect_ratio = 0.0;
	GeeArrayList* _tmp5_ = NULL;
	gpointer _tmp6_ = NULL;
	Photo* _tmp7_ = NULL;
	Dimensions _tmp8_ = {0};
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
#line 755 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (to_print), NULL);
#line 755 "/home/jens/Source/shotwell/src/Printing.vala"
	self = (PrintJob*) g_object_new (object_type, NULL);
#line 756 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = print_manager_get_instance ();
#line 756 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _tmp0_;
#line 756 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = print_manager_get_global_settings (_tmp1_);
#line 756 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (self->priv->settings);
#line 756 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->settings = _tmp2_;
#line 756 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_manager_unref0 (_tmp1_);
#line 757 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = self->priv->photos;
#line 757 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = to_print;
#line 757 "/home/jens/Source/shotwell/src/Printing.vala"
	gee_array_list_add_all (_tmp3_, _tmp4_);
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_print_operation_set_embed_page_setup (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_print_operation_get_type (), GtkPrintOperation), TRUE);
#line 760 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = self->priv->photos;
#line 760 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0);
#line 760 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = (Photo*) _tmp6_;
#line 760 "/home/jens/Source/shotwell/src/Printing.vala"
	media_source_get_dimensions (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_MEDIA_SOURCE, MediaSource), PHOTO_EXCEPTION_NONE, &_tmp8_);
#line 760 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = dimensions_get_aspect_ratio (&_tmp8_);
#line 760 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = _tmp9_;
#line 760 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (_tmp7_);
#line 760 "/home/jens/Source/shotwell/src/Printing.vala"
	photo_aspect_ratio = _tmp10_;
#line 761 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp11_ = photo_aspect_ratio;
#line 761 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp11_ < 1.0) {
#line 5111 "Printing.c"
		gdouble _tmp12_ = 0.0;
#line 762 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp12_ = photo_aspect_ratio;
#line 762 "/home/jens/Source/shotwell/src/Printing.vala"
		photo_aspect_ratio = 1.0 / _tmp12_;
#line 5117 "Printing.c"
	}
#line 755 "/home/jens/Source/shotwell/src/Printing.vala"
	return self;
#line 5121 "Printing.c"
}


PrintJob* print_job_new (GeeCollection* to_print) {
#line 755 "/home/jens/Source/shotwell/src/Printing.vala"
	return print_job_construct (TYPE_PRINT_JOB, to_print);
#line 5128 "Printing.c"
}


GeeList* print_job_get_photos (PrintJob* self) {
	GeeList* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
#line 765 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_JOB (self), NULL);
#line 766 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->photos;
#line 766 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList));
#line 766 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 766 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 5146 "Printing.c"
}


Photo* print_job_get_source_photo (PrintJob* self) {
	Photo* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
#line 769 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_JOB (self), NULL);
#line 770 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->photos;
#line 770 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0);
#line 770 "/home/jens/Source/shotwell/src/Printing.vala"
	result = (Photo*) _tmp1_;
#line 770 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 5164 "Printing.c"
}


gdouble print_job_get_source_aspect_ratio (PrintJob* self) {
	gdouble result = 0.0;
	gdouble aspect_ratio = 0.0;
	GeeArrayList* _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
	Photo* _tmp2_ = NULL;
	Dimensions _tmp3_ = {0};
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
#line 773 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_JOB (self), 0.0);
#line 774 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->photos;
#line 774 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0);
#line 774 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = (Photo*) _tmp1_;
#line 774 "/home/jens/Source/shotwell/src/Printing.vala"
	media_source_get_dimensions (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_MEDIA_SOURCE, MediaSource), PHOTO_EXCEPTION_NONE, &_tmp3_);
#line 774 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = dimensions_get_aspect_ratio (&_tmp3_);
#line 774 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = _tmp4_;
#line 774 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (_tmp2_);
#line 774 "/home/jens/Source/shotwell/src/Printing.vala"
	aspect_ratio = _tmp5_;
#line 775 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = aspect_ratio;
#line 775 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp7_ < 1.0) {
#line 5201 "Printing.c"
		gdouble _tmp8_ = 0.0;
#line 775 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp8_ = aspect_ratio;
#line 775 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp6_ = 1.0 / _tmp8_;
#line 5207 "Printing.c"
	} else {
		gdouble _tmp9_ = 0.0;
#line 775 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp9_ = aspect_ratio;
#line 775 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp6_ = _tmp9_;
#line 5214 "Printing.c"
	}
#line 775 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp6_;
#line 775 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 5220 "Printing.c"
}


static gpointer _print_settings_ref0 (gpointer self) {
#line 779 "/home/jens/Source/shotwell/src/Printing.vala"
	return self ? print_settings_ref (self) : NULL;
#line 5227 "Printing.c"
}


PrintSettings* print_job_get_local_settings (PrintJob* self) {
	PrintSettings* result = NULL;
	PrintSettings* _tmp0_ = NULL;
	PrintSettings* _tmp1_ = NULL;
#line 778 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_JOB (self), NULL);
#line 779 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->settings;
#line 779 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _print_settings_ref0 (_tmp0_);
#line 779 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 779 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 5245 "Printing.c"
}


void print_job_set_local_settings (PrintJob* self, PrintSettings* settings) {
	PrintSettings* _tmp0_ = NULL;
	PrintSettings* _tmp1_ = NULL;
#line 782 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_JOB (self));
#line 782 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (settings));
#line 783 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = settings;
#line 783 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _print_settings_ref0 (_tmp0_);
#line 783 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (self->priv->settings);
#line 783 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->settings = _tmp1_;
#line 5264 "Printing.c"
}


static void print_job_class_init (PrintJobClass * klass) {
#line 751 "/home/jens/Source/shotwell/src/Printing.vala"
	print_job_parent_class = g_type_class_peek_parent (klass);
#line 751 "/home/jens/Source/shotwell/src/Printing.vala"
	g_type_class_add_private (klass, sizeof (PrintJobPrivate));
#line 751 "/home/jens/Source/shotwell/src/Printing.vala"
	G_OBJECT_CLASS (klass)->finalize = print_job_finalize;
#line 5275 "Printing.c"
}


static void print_job_instance_init (PrintJob * self) {
	GeeArrayList* _tmp0_ = NULL;
#line 751 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv = PRINT_JOB_GET_PRIVATE (self);
#line 753 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = gee_array_list_new (TYPE_PHOTO, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 753 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->photos = _tmp0_;
#line 5287 "Printing.c"
}


static void print_job_finalize (GObject* obj) {
	PrintJob * self;
#line 751 "/home/jens/Source/shotwell/src/Printing.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PRINT_JOB, PrintJob);
#line 752 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (self->priv->settings);
#line 753 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->photos);
#line 751 "/home/jens/Source/shotwell/src/Printing.vala"
	G_OBJECT_CLASS (print_job_parent_class)->finalize (obj);
#line 5301 "Printing.c"
}


GType print_job_get_type (void) {
	static volatile gsize print_job_type_id__volatile = 0;
	if (g_once_init_enter (&print_job_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PrintJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) print_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrintJob), 0, (GInstanceInitFunc) print_job_instance_init, NULL };
		GType print_job_type_id;
		print_job_type_id = g_type_register_static (gtk_print_operation_get_type (), "PrintJob", &g_define_type_info, 0);
		g_once_init_leave (&print_job_type_id__volatile, print_job_type_id);
	}
	return print_job_type_id__volatile;
}


StandardPrintSize* standard_print_size_construct (GType object_type, const gchar* name, Measurement* width, Measurement* height) {
	StandardPrintSize* self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	Measurement _tmp2_ = {0};
	Measurement _tmp3_ = {0};
#line 788 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 788 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (width != NULL, NULL);
#line 788 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (height != NULL, NULL);
#line 788 "/home/jens/Source/shotwell/src/Printing.vala"
	self = (StandardPrintSize*) g_type_create_instance (object_type);
#line 789 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = name;
#line 789 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 789 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (self->name);
#line 789 "/home/jens/Source/shotwell/src/Printing.vala"
	self->name = _tmp1_;
#line 790 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = *width;
#line 790 "/home/jens/Source/shotwell/src/Printing.vala"
	self->width = _tmp2_;
#line 791 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = *height;
#line 791 "/home/jens/Source/shotwell/src/Printing.vala"
	self->height = _tmp3_;
#line 788 "/home/jens/Source/shotwell/src/Printing.vala"
	return self;
#line 5349 "Printing.c"
}


StandardPrintSize* standard_print_size_new (const gchar* name, Measurement* width, Measurement* height) {
#line 788 "/home/jens/Source/shotwell/src/Printing.vala"
	return standard_print_size_construct (TYPE_STANDARD_PRINT_SIZE, name, width, height);
#line 5356 "Printing.c"
}


static void value_standard_print_size_init (GValue* value) {
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
	value->data[0].v_pointer = NULL;
#line 5363 "Printing.c"
}


static void value_standard_print_size_free_value (GValue* value) {
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
	if (value->data[0].v_pointer) {
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
		standard_print_size_unref (value->data[0].v_pointer);
#line 5372 "Printing.c"
	}
}


static void value_standard_print_size_copy_value (const GValue* src_value, GValue* dest_value) {
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
	if (src_value->data[0].v_pointer) {
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
		dest_value->data[0].v_pointer = standard_print_size_ref (src_value->data[0].v_pointer);
#line 5382 "Printing.c"
	} else {
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
		dest_value->data[0].v_pointer = NULL;
#line 5386 "Printing.c"
	}
}


static gpointer value_standard_print_size_peek_pointer (const GValue* value) {
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
	return value->data[0].v_pointer;
#line 5394 "Printing.c"
}


static gchar* value_standard_print_size_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
	if (collect_values[0].v_pointer) {
#line 5401 "Printing.c"
		StandardPrintSize* object;
		object = collect_values[0].v_pointer;
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
		if (object->parent_instance.g_class == NULL) {
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5408 "Printing.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5412 "Printing.c"
		}
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = standard_print_size_ref (object);
#line 5416 "Printing.c"
	} else {
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = NULL;
#line 5420 "Printing.c"
	}
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
	return NULL;
#line 5424 "Printing.c"
}


static gchar* value_standard_print_size_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	StandardPrintSize** object_p;
	object_p = collect_values[0].v_pointer;
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
	if (!object_p) {
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 5435 "Printing.c"
	}
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
	if (!value->data[0].v_pointer) {
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
		*object_p = NULL;
#line 5441 "Printing.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
		*object_p = value->data[0].v_pointer;
#line 5445 "Printing.c"
	} else {
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
		*object_p = standard_print_size_ref (value->data[0].v_pointer);
#line 5449 "Printing.c"
	}
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
	return NULL;
#line 5453 "Printing.c"
}


GParamSpec* param_spec_standard_print_size (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecStandardPrintSize* spec;
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_STANDARD_PRINT_SIZE), NULL);
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
	return G_PARAM_SPEC (spec);
#line 5467 "Printing.c"
}


gpointer value_get_standard_print_size (const GValue* value) {
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_STANDARD_PRINT_SIZE), NULL);
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
	return value->data[0].v_pointer;
#line 5476 "Printing.c"
}


void value_set_standard_print_size (GValue* value, gpointer v_object) {
	StandardPrintSize* old;
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_STANDARD_PRINT_SIZE));
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
	old = value->data[0].v_pointer;
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
	if (v_object) {
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_STANDARD_PRINT_SIZE));
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = v_object;
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
		standard_print_size_ref (value->data[0].v_pointer);
#line 5496 "Printing.c"
	} else {
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = NULL;
#line 5500 "Printing.c"
	}
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
	if (old) {
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
		standard_print_size_unref (old);
#line 5506 "Printing.c"
	}
}


void value_take_standard_print_size (GValue* value, gpointer v_object) {
	StandardPrintSize* old;
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_STANDARD_PRINT_SIZE));
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
	old = value->data[0].v_pointer;
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
	if (v_object) {
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_STANDARD_PRINT_SIZE));
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = v_object;
#line 5525 "Printing.c"
	} else {
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = NULL;
#line 5529 "Printing.c"
	}
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
	if (old) {
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
		standard_print_size_unref (old);
#line 5535 "Printing.c"
	}
}


static void standard_print_size_class_init (StandardPrintSizeClass * klass) {
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
	standard_print_size_parent_class = g_type_class_peek_parent (klass);
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
	((StandardPrintSizeClass *) klass)->finalize = standard_print_size_finalize;
#line 5545 "Printing.c"
}


static void standard_print_size_instance_init (StandardPrintSize * self) {
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
	self->ref_count = 1;
#line 5552 "Printing.c"
}


static void standard_print_size_finalize (StandardPrintSize* obj) {
	StandardPrintSize * self;
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_STANDARD_PRINT_SIZE, StandardPrintSize);
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_handlers_destroy (self);
#line 794 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (self->name);
#line 5564 "Printing.c"
}


GType standard_print_size_get_type (void) {
	static volatile gsize standard_print_size_type_id__volatile = 0;
	if (g_once_init_enter (&standard_print_size_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_standard_print_size_init, value_standard_print_size_free_value, value_standard_print_size_copy_value, value_standard_print_size_peek_pointer, "p", value_standard_print_size_collect_value, "p", value_standard_print_size_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (StandardPrintSizeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) standard_print_size_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StandardPrintSize), 0, (GInstanceInitFunc) standard_print_size_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType standard_print_size_type_id;
		standard_print_size_type_id = g_type_register_fundamental (g_type_fundamental_next (), "StandardPrintSize", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&standard_print_size_type_id__volatile, standard_print_size_type_id);
	}
	return standard_print_size_type_id__volatile;
}


gpointer standard_print_size_ref (gpointer instance) {
	StandardPrintSize* self;
	self = instance;
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
	g_atomic_int_inc (&self->ref_count);
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
	return instance;
#line 5589 "Printing.c"
}


void standard_print_size_unref (gpointer instance) {
	StandardPrintSize* self;
	self = instance;
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
		STANDARD_PRINT_SIZE_GET_CLASS (self)->finalize (self);
#line 787 "/home/jens/Source/shotwell/src/Printing.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 5602 "Printing.c"
	}
}


static PrintManager* print_manager_construct (GType object_type) {
	PrintManager* self = NULL;
	GtkPageSetup* _tmp0_ = NULL;
	PrintSettings* _tmp1_ = NULL;
#line 810 "/home/jens/Source/shotwell/src/Printing.vala"
	self = (PrintManager*) g_type_create_instance (object_type);
#line 811 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = gtk_page_setup_new ();
#line 811 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->user_page_setup);
#line 811 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->user_page_setup = _tmp0_;
#line 812 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = print_settings_new ();
#line 812 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (self->priv->settings);
#line 812 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->settings = _tmp1_;
#line 810 "/home/jens/Source/shotwell/src/Printing.vala"
	return self;
#line 5627 "Printing.c"
}


static PrintManager* print_manager_new (void) {
#line 810 "/home/jens/Source/shotwell/src/Printing.vala"
	return print_manager_construct (TYPE_PRINT_MANAGER);
#line 5634 "Printing.c"
}


static void _vala_array_add112 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value) {
#line 818 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 818 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 818 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5645 "Printing.c"
	}
#line 818 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 818 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5651 "Printing.c"
}


static void _vala_array_add113 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value) {
#line 821 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 821 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 821 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5662 "Printing.c"
	}
#line 821 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 821 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5668 "Printing.c"
}


static void _vala_array_add114 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value) {
#line 824 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 824 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 824 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5679 "Printing.c"
	}
#line 824 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 824 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5685 "Printing.c"
}


static void _vala_array_add115 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value) {
#line 827 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 827 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 827 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5696 "Printing.c"
	}
#line 827 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 827 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5702 "Printing.c"
}


static void _vala_array_add116 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value) {
#line 830 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 830 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 830 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5713 "Printing.c"
	}
#line 830 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 830 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5719 "Printing.c"
}


static void _vala_array_add117 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value) {
#line 833 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 833 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 833 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5730 "Printing.c"
	}
#line 833 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 833 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5736 "Printing.c"
}


static void _vala_array_add118 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value) {
#line 836 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 836 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 836 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5747 "Printing.c"
	}
#line 836 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 836 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5753 "Printing.c"
}


static void _vala_array_add119 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value) {
#line 839 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 839 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 839 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5764 "Printing.c"
	}
#line 839 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 839 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5770 "Printing.c"
}


static void _vala_array_add120 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value) {
#line 842 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 842 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 842 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5781 "Printing.c"
	}
#line 842 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 842 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5787 "Printing.c"
}


static void _vala_array_add121 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value) {
#line 845 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 845 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 845 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5798 "Printing.c"
	}
#line 845 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 845 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5804 "Printing.c"
}


static void _vala_array_add122 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value) {
#line 848 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 848 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 848 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5815 "Printing.c"
	}
#line 848 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 848 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5821 "Printing.c"
}


static void _vala_array_add123 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value) {
#line 851 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 851 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 851 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5832 "Printing.c"
	}
#line 851 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 851 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5838 "Printing.c"
}


static void _vala_array_add124 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value) {
#line 854 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 854 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 854 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5849 "Printing.c"
	}
#line 854 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 854 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5855 "Printing.c"
}


static void _vala_array_add125 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value) {
#line 857 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 857 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 857 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5866 "Printing.c"
	}
#line 857 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 857 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5872 "Printing.c"
}


static void _vala_array_add126 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value) {
#line 860 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 860 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 860 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5883 "Printing.c"
	}
#line 860 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 860 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5889 "Printing.c"
}


StandardPrintSize** print_manager_get_standard_sizes (PrintManager* self, int* result_length1) {
	StandardPrintSize** result = NULL;
	StandardPrintSize** _result_ = NULL;
	StandardPrintSize** _tmp0_ = NULL;
	gint _result__length1 = 0;
	gint __result__size_ = 0;
	StandardPrintSize** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	Measurement _tmp3_ = {0};
	Measurement _tmp4_ = {0};
	StandardPrintSize* _tmp5_ = NULL;
	StandardPrintSize** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	const gchar* _tmp7_ = NULL;
	Measurement _tmp8_ = {0};
	Measurement _tmp9_ = {0};
	StandardPrintSize* _tmp10_ = NULL;
	StandardPrintSize** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	const gchar* _tmp12_ = NULL;
	Measurement _tmp13_ = {0};
	Measurement _tmp14_ = {0};
	StandardPrintSize* _tmp15_ = NULL;
	StandardPrintSize** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	const gchar* _tmp17_ = NULL;
	Measurement _tmp18_ = {0};
	Measurement _tmp19_ = {0};
	StandardPrintSize* _tmp20_ = NULL;
	StandardPrintSize** _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	const gchar* _tmp22_ = NULL;
	Measurement _tmp23_ = {0};
	Measurement _tmp24_ = {0};
	StandardPrintSize* _tmp25_ = NULL;
	StandardPrintSize** _tmp26_ = NULL;
	gint _tmp26__length1 = 0;
	const gchar* _tmp27_ = NULL;
	Measurement _tmp28_ = {0};
	Measurement _tmp29_ = {0};
	StandardPrintSize* _tmp30_ = NULL;
	StandardPrintSize** _tmp31_ = NULL;
	gint _tmp31__length1 = 0;
	const gchar* _tmp32_ = NULL;
	Measurement _tmp33_ = {0};
	Measurement _tmp34_ = {0};
	StandardPrintSize* _tmp35_ = NULL;
	StandardPrintSize** _tmp36_ = NULL;
	gint _tmp36__length1 = 0;
	Measurement _tmp37_ = {0};
	Measurement _tmp38_ = {0};
	StandardPrintSize* _tmp39_ = NULL;
	StandardPrintSize** _tmp40_ = NULL;
	gint _tmp40__length1 = 0;
	const gchar* _tmp41_ = NULL;
	Measurement _tmp42_ = {0};
	Measurement _tmp43_ = {0};
	StandardPrintSize* _tmp44_ = NULL;
	StandardPrintSize** _tmp45_ = NULL;
	gint _tmp45__length1 = 0;
	const gchar* _tmp46_ = NULL;
	Measurement _tmp47_ = {0};
	Measurement _tmp48_ = {0};
	StandardPrintSize* _tmp49_ = NULL;
	StandardPrintSize** _tmp50_ = NULL;
	gint _tmp50__length1 = 0;
	const gchar* _tmp51_ = NULL;
	Measurement _tmp52_ = {0};
	Measurement _tmp53_ = {0};
	StandardPrintSize* _tmp54_ = NULL;
	StandardPrintSize** _tmp55_ = NULL;
	gint _tmp55__length1 = 0;
	const gchar* _tmp56_ = NULL;
	Measurement _tmp57_ = {0};
	Measurement _tmp58_ = {0};
	StandardPrintSize* _tmp59_ = NULL;
	StandardPrintSize** _tmp60_ = NULL;
	gint _tmp60__length1 = 0;
	const gchar* _tmp61_ = NULL;
	Measurement _tmp62_ = {0};
	Measurement _tmp63_ = {0};
	StandardPrintSize* _tmp64_ = NULL;
	StandardPrintSize** _tmp65_ = NULL;
	gint _tmp65__length1 = 0;
	const gchar* _tmp66_ = NULL;
	Measurement _tmp67_ = {0};
	Measurement _tmp68_ = {0};
	StandardPrintSize* _tmp69_ = NULL;
	StandardPrintSize** _tmp70_ = NULL;
	gint _tmp70__length1 = 0;
	const gchar* _tmp71_ = NULL;
	Measurement _tmp72_ = {0};
	Measurement _tmp73_ = {0};
	StandardPrintSize* _tmp74_ = NULL;
	StandardPrintSize** _tmp75_ = NULL;
	gint _tmp75__length1 = 0;
#line 815 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_MANAGER (self), NULL);
#line 816 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = g_new0 (StandardPrintSize*, 0 + 1);
#line 816 "/home/jens/Source/shotwell/src/Printing.vala"
	_result_ = _tmp0_;
#line 816 "/home/jens/Source/shotwell/src/Printing.vala"
	_result__length1 = 0;
#line 816 "/home/jens/Source/shotwell/src/Printing.vala"
	__result__size_ = _result__length1;
#line 818 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _result_;
#line 818 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1__length1 = _result__length1;
#line 818 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = _ ("Wallet (2 × 3 in.)");
#line 818 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp3_, (gdouble) 3, MEASUREMENT_UNIT_INCHES);
#line 818 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp4_, (gdouble) 2, MEASUREMENT_UNIT_INCHES);
#line 818 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = standard_print_size_new (_tmp2_, &_tmp3_, &_tmp4_);
#line 818 "/home/jens/Source/shotwell/src/Printing.vala"
	_vala_array_add112 (&_result_, &_result__length1, &__result__size_, _tmp5_);
#line 821 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = _result_;
#line 821 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6__length1 = _result__length1;
#line 821 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = _ ("Notecard (3 × 5 in.)");
#line 821 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp8_, (gdouble) 5, MEASUREMENT_UNIT_INCHES);
#line 821 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp9_, (gdouble) 3, MEASUREMENT_UNIT_INCHES);
#line 821 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = standard_print_size_new (_tmp7_, &_tmp8_, &_tmp9_);
#line 821 "/home/jens/Source/shotwell/src/Printing.vala"
	_vala_array_add113 (&_result_, &_result__length1, &__result__size_, _tmp10_);
#line 824 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp11_ = _result_;
#line 824 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp11__length1 = _result__length1;
#line 824 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp12_ = _ ("4 × 6 in.");
#line 824 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp13_, (gdouble) 6, MEASUREMENT_UNIT_INCHES);
#line 824 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp14_, (gdouble) 4, MEASUREMENT_UNIT_INCHES);
#line 824 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp15_ = standard_print_size_new (_tmp12_, &_tmp13_, &_tmp14_);
#line 824 "/home/jens/Source/shotwell/src/Printing.vala"
	_vala_array_add114 (&_result_, &_result__length1, &__result__size_, _tmp15_);
#line 827 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp16_ = _result_;
#line 827 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp16__length1 = _result__length1;
#line 827 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp17_ = _ ("5 × 7 in.");
#line 827 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp18_, (gdouble) 7, MEASUREMENT_UNIT_INCHES);
#line 827 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp19_, (gdouble) 5, MEASUREMENT_UNIT_INCHES);
#line 827 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp20_ = standard_print_size_new (_tmp17_, &_tmp18_, &_tmp19_);
#line 827 "/home/jens/Source/shotwell/src/Printing.vala"
	_vala_array_add115 (&_result_, &_result__length1, &__result__size_, _tmp20_);
#line 830 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp21_ = _result_;
#line 830 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp21__length1 = _result__length1;
#line 830 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp22_ = _ ("8 × 10 in.");
#line 830 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp23_, (gdouble) 10, MEASUREMENT_UNIT_INCHES);
#line 830 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp24_, (gdouble) 8, MEASUREMENT_UNIT_INCHES);
#line 830 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp25_ = standard_print_size_new (_tmp22_, &_tmp23_, &_tmp24_);
#line 830 "/home/jens/Source/shotwell/src/Printing.vala"
	_vala_array_add116 (&_result_, &_result__length1, &__result__size_, _tmp25_);
#line 833 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp26_ = _result_;
#line 833 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp26__length1 = _result__length1;
#line 833 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp27_ = _ ("11 × 14 in.");
#line 833 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp28_, (gdouble) 14, MEASUREMENT_UNIT_INCHES);
#line 833 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp29_, (gdouble) 11, MEASUREMENT_UNIT_INCHES);
#line 833 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp30_ = standard_print_size_new (_tmp27_, &_tmp28_, &_tmp29_);
#line 833 "/home/jens/Source/shotwell/src/Printing.vala"
	_vala_array_add117 (&_result_, &_result__length1, &__result__size_, _tmp30_);
#line 836 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp31_ = _result_;
#line 836 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp31__length1 = _result__length1;
#line 836 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp32_ = _ ("16 × 20 in.");
#line 836 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp33_, (gdouble) 20, MEASUREMENT_UNIT_INCHES);
#line 836 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp34_, (gdouble) 16, MEASUREMENT_UNIT_INCHES);
#line 836 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp35_ = standard_print_size_new (_tmp32_, &_tmp33_, &_tmp34_);
#line 836 "/home/jens/Source/shotwell/src/Printing.vala"
	_vala_array_add118 (&_result_, &_result__length1, &__result__size_, _tmp35_);
#line 839 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp36_ = _result_;
#line 839 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp36__length1 = _result__length1;
#line 839 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp37_, (gdouble) 0, MEASUREMENT_UNIT_INCHES);
#line 839 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp38_, (gdouble) 0, MEASUREMENT_UNIT_INCHES);
#line 839 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp39_ = standard_print_size_new ("-", &_tmp37_, &_tmp38_);
#line 839 "/home/jens/Source/shotwell/src/Printing.vala"
	_vala_array_add119 (&_result_, &_result__length1, &__result__size_, _tmp39_);
#line 842 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp40_ = _result_;
#line 842 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp40__length1 = _result__length1;
#line 842 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp41_ = _ ("Metric Wallet (9 × 13 cm)");
#line 842 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp42_, (gdouble) 13, MEASUREMENT_UNIT_CENTIMETERS);
#line 842 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp43_, (gdouble) 9, MEASUREMENT_UNIT_CENTIMETERS);
#line 842 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp44_ = standard_print_size_new (_tmp41_, &_tmp42_, &_tmp43_);
#line 842 "/home/jens/Source/shotwell/src/Printing.vala"
	_vala_array_add120 (&_result_, &_result__length1, &__result__size_, _tmp44_);
#line 845 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp45_ = _result_;
#line 845 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp45__length1 = _result__length1;
#line 845 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp46_ = _ ("Postcard (10 × 15 cm)");
#line 845 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp47_, (gdouble) 15, MEASUREMENT_UNIT_CENTIMETERS);
#line 845 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp48_, (gdouble) 10, MEASUREMENT_UNIT_CENTIMETERS);
#line 845 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp49_ = standard_print_size_new (_tmp46_, &_tmp47_, &_tmp48_);
#line 845 "/home/jens/Source/shotwell/src/Printing.vala"
	_vala_array_add121 (&_result_, &_result__length1, &__result__size_, _tmp49_);
#line 848 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp50_ = _result_;
#line 848 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp50__length1 = _result__length1;
#line 848 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp51_ = _ ("13 × 18 cm");
#line 848 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp52_, (gdouble) 18, MEASUREMENT_UNIT_CENTIMETERS);
#line 848 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp53_, (gdouble) 13, MEASUREMENT_UNIT_CENTIMETERS);
#line 848 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp54_ = standard_print_size_new (_tmp51_, &_tmp52_, &_tmp53_);
#line 848 "/home/jens/Source/shotwell/src/Printing.vala"
	_vala_array_add122 (&_result_, &_result__length1, &__result__size_, _tmp54_);
#line 851 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp55_ = _result_;
#line 851 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp55__length1 = _result__length1;
#line 851 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp56_ = _ ("18 × 24 cm");
#line 851 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp57_, (gdouble) 24, MEASUREMENT_UNIT_CENTIMETERS);
#line 851 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp58_, (gdouble) 18, MEASUREMENT_UNIT_CENTIMETERS);
#line 851 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp59_ = standard_print_size_new (_tmp56_, &_tmp57_, &_tmp58_);
#line 851 "/home/jens/Source/shotwell/src/Printing.vala"
	_vala_array_add123 (&_result_, &_result__length1, &__result__size_, _tmp59_);
#line 854 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp60_ = _result_;
#line 854 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp60__length1 = _result__length1;
#line 854 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp61_ = _ ("20 × 30 cm");
#line 854 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp62_, (gdouble) 30, MEASUREMENT_UNIT_CENTIMETERS);
#line 854 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp63_, (gdouble) 20, MEASUREMENT_UNIT_CENTIMETERS);
#line 854 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp64_ = standard_print_size_new (_tmp61_, &_tmp62_, &_tmp63_);
#line 854 "/home/jens/Source/shotwell/src/Printing.vala"
	_vala_array_add124 (&_result_, &_result__length1, &__result__size_, _tmp64_);
#line 857 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp65_ = _result_;
#line 857 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp65__length1 = _result__length1;
#line 857 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp66_ = _ ("24 × 40 cm");
#line 857 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp67_, (gdouble) 40, MEASUREMENT_UNIT_CENTIMETERS);
#line 857 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp68_, (gdouble) 24, MEASUREMENT_UNIT_CENTIMETERS);
#line 857 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp69_ = standard_print_size_new (_tmp66_, &_tmp67_, &_tmp68_);
#line 857 "/home/jens/Source/shotwell/src/Printing.vala"
	_vala_array_add125 (&_result_, &_result__length1, &__result__size_, _tmp69_);
#line 860 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp70_ = _result_;
#line 860 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp70__length1 = _result__length1;
#line 860 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp71_ = _ ("30 × 40 cm");
#line 860 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp72_, (gdouble) 40, MEASUREMENT_UNIT_CENTIMETERS);
#line 860 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp73_, (gdouble) 30, MEASUREMENT_UNIT_CENTIMETERS);
#line 860 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp74_ = standard_print_size_new (_tmp71_, &_tmp72_, &_tmp73_);
#line 860 "/home/jens/Source/shotwell/src/Printing.vala"
	_vala_array_add126 (&_result_, &_result__length1, &__result__size_, _tmp74_);
#line 864 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp75_ = _result_;
#line 864 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp75__length1 = _result__length1;
#line 864 "/home/jens/Source/shotwell/src/Printing.vala"
	if (result_length1) {
#line 864 "/home/jens/Source/shotwell/src/Printing.vala"
		*result_length1 = _tmp75__length1;
#line 6216 "Printing.c"
	}
#line 864 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp75_;
#line 864 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 6222 "Printing.c"
}


static gpointer _print_manager_ref0 (gpointer self) {
#line 871 "/home/jens/Source/shotwell/src/Printing.vala"
	return self ? print_manager_ref (self) : NULL;
#line 6229 "Printing.c"
}


PrintManager* print_manager_get_instance (void) {
	PrintManager* result = NULL;
	PrintManager* _tmp0_ = NULL;
	PrintManager* _tmp2_ = NULL;
	PrintManager* _tmp3_ = NULL;
#line 868 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = print_manager_instance;
#line 868 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp0_ == NULL) {
#line 6242 "Printing.c"
		PrintManager* _tmp1_ = NULL;
#line 869 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp1_ = print_manager_new ();
#line 869 "/home/jens/Source/shotwell/src/Printing.vala"
		_print_manager_unref0 (print_manager_instance);
#line 869 "/home/jens/Source/shotwell/src/Printing.vala"
		print_manager_instance = _tmp1_;
#line 6250 "Printing.c"
	}
#line 871 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = print_manager_instance;
#line 871 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = _print_manager_ref0 (_tmp2_);
#line 871 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp3_;
#line 871 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 6260 "Printing.c"
}


static void _print_manager_on_begin_print_gtk_print_operation_begin_print (GtkPrintOperation* _sender, GtkPrintContext* context, gpointer self) {
#line 881 "/home/jens/Source/shotwell/src/Printing.vala"
	print_manager_on_begin_print ((PrintManager*) self, _sender, context);
#line 6267 "Printing.c"
}


static void _print_manager_on_draw_page_gtk_print_operation_draw_page (GtkPrintOperation* _sender, GtkPrintContext* context, gint page_nr, gpointer self) {
#line 882 "/home/jens/Source/shotwell/src/Printing.vala"
	print_manager_on_draw_page ((PrintManager*) self, _sender, context, page_nr);
#line 6274 "Printing.c"
}


static GObject* _print_manager_on_create_custom_widget_gtk_print_operation_create_custom_widget (GtkPrintOperation* _sender, gpointer self) {
	GObject* result;
	result = print_manager_on_create_custom_widget ((PrintManager*) self, _sender);
#line 883 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 6283 "Printing.c"
}


static void _print_manager_on_status_changed_gtk_print_operation_status_changed (GtkPrintOperation* _sender, gpointer self) {
#line 884 "/home/jens/Source/shotwell/src/Printing.vala"
	print_manager_on_status_changed ((PrintManager*) self, _sender);
#line 6290 "Printing.c"
}


void print_manager_spool_photo (PrintManager* self, GeeCollection* to_print) {
	PrintJob* job = NULL;
	GeeCollection* _tmp0_ = NULL;
	PrintJob* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	Photo* _tmp3_ = NULL;
	Photo* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GtkPageSetup* _tmp7_ = NULL;
	AppWindow* _tmp8_ = NULL;
	AppWindow* _tmp9_ = NULL;
	GCancellable* _tmp10_ = NULL;
	AppWindow* _tmp11_ = NULL;
	AppWindow* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	GCancellable* _tmp14_ = NULL;
	ProgressDialog* _tmp15_ = NULL;
	gchar* err_msg = NULL;
	ProgressDialog* _tmp25_ = NULL;
	AppWindow* _tmp26_ = NULL;
	AppWindow* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	GError * _inner_error_ = NULL;
#line 874 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_MANAGER (self));
#line 874 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GEE_IS_COLLECTION (to_print));
#line 875 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = to_print;
#line 875 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = print_job_new (_tmp0_);
#line 875 "/home/jens/Source/shotwell/src/Printing.vala"
	job = _tmp1_;
#line 876 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = _ ("Image Settings");
#line 876 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_print_operation_set_custom_tab_label (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), _tmp2_);
#line 877 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_print_operation_set_unit (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), GTK_UNIT_INCH);
#line 878 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_print_operation_set_n_pages (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), 1);
#line 879 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = print_job_get_source_photo (job);
#line 879 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = _tmp3_;
#line 879 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_OBJECT, DataObject));
#line 879 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = _tmp5_;
#line 879 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_print_operation_set_job_name (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), _tmp6_);
#line 879 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp6_);
#line 879 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (_tmp4_);
#line 880 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = self->priv->user_page_setup;
#line 880 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_print_operation_set_default_page_setup (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), _tmp7_);
#line 881 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), "begin-print", (GCallback) _print_manager_on_begin_print_gtk_print_operation_begin_print, self);
#line 882 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), "draw-page", (GCallback) _print_manager_on_draw_page_gtk_print_operation_draw_page, self);
#line 883 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), "create-custom-widget", (GCallback) _print_manager_on_create_custom_widget_gtk_print_operation_create_custom_widget, self);
#line 884 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), "status-changed", (GCallback) _print_manager_on_status_changed_gtk_print_operation_status_changed, self);
#line 886 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = app_window_get_instance ();
#line 886 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = _tmp8_;
#line 886 "/home/jens/Source/shotwell/src/Printing.vala"
	page_window_set_busy_cursor (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_PAGE_WINDOW, PageWindow));
#line 886 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (_tmp9_);
#line 888 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = g_cancellable_new ();
#line 888 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 888 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->cancellable = _tmp10_;
#line 889 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp11_ = app_window_get_instance ();
#line 889 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp12_ = _tmp11_;
#line 889 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp13_ = _ ("Printing…");
#line 889 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_ = self->priv->cancellable;
#line 889 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp15_ = progress_dialog_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_window_get_type (), GtkWindow), _tmp13_, _tmp14_);
#line 889 "/home/jens/Source/shotwell/src/Printing.vala"
	g_object_ref_sink (_tmp15_);
#line 889 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->progress_dialog);
#line 889 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->progress_dialog = _tmp15_;
#line 889 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (_tmp12_);
#line 891 "/home/jens/Source/shotwell/src/Printing.vala"
	err_msg = NULL;
#line 6396 "Printing.c"
	{
		GtkPrintOperationResult _result_ = 0;
		AppWindow* _tmp16_ = NULL;
		AppWindow* _tmp17_ = NULL;
		GtkPrintOperationResult _tmp18_ = 0;
		GtkPrintOperationResult _tmp19_ = 0;
#line 893 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp16_ = app_window_get_instance ();
#line 893 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp17_ = _tmp16_;
#line 893 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp18_ = gtk_print_operation_run (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), GTK_PRINT_OPERATION_ACTION_PRINT_DIALOG, G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_window_get_type (), GtkWindow), &_inner_error_);
#line 893 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp19_ = _tmp18_;
#line 893 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_object_unref0 (_tmp17_);
#line 893 "/home/jens/Source/shotwell/src/Printing.vala"
		_result_ = _tmp19_;
#line 893 "/home/jens/Source/shotwell/src/Printing.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6417 "Printing.c"
			goto __catch467_g_error;
		}
#line 895 "/home/jens/Source/shotwell/src/Printing.vala"
		if (_result_ == GTK_PRINT_OPERATION_RESULT_APPLY) {
#line 6422 "Printing.c"
			GtkPageSetup* _tmp20_ = NULL;
			GtkPageSetup* _tmp21_ = NULL;
#line 896 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp20_ = gtk_print_operation_get_default_page_setup (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation));
#line 896 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp21_ = _g_object_ref0 (_tmp20_);
#line 896 "/home/jens/Source/shotwell/src/Printing.vala"
			_g_object_unref0 (self->priv->user_page_setup);
#line 896 "/home/jens/Source/shotwell/src/Printing.vala"
			self->priv->user_page_setup = _tmp21_;
#line 6433 "Printing.c"
		}
	}
	goto __finally467;
	__catch467_g_error:
	{
		GError* e = NULL;
		GError* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
#line 892 "/home/jens/Source/shotwell/src/Printing.vala"
		e = _inner_error_;
#line 892 "/home/jens/Source/shotwell/src/Printing.vala"
		_inner_error_ = NULL;
#line 898 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_print_operation_cancel (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation));
#line 899 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp22_ = e;
#line 899 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp23_ = _tmp22_->message;
#line 899 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp24_ = g_strdup (_tmp23_);
#line 899 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_free0 (err_msg);
#line 899 "/home/jens/Source/shotwell/src/Printing.vala"
		err_msg = _tmp24_;
#line 892 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_error_free0 (e);
#line 6461 "Printing.c"
	}
	__finally467:
#line 892 "/home/jens/Source/shotwell/src/Printing.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 892 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_free0 (err_msg);
#line 892 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_object_unref0 (job);
#line 892 "/home/jens/Source/shotwell/src/Printing.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 892 "/home/jens/Source/shotwell/src/Printing.vala"
		g_clear_error (&_inner_error_);
#line 892 "/home/jens/Source/shotwell/src/Printing.vala"
		return;
#line 6476 "Printing.c"
	}
#line 902 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp25_ = self->priv->progress_dialog;
#line 902 "/home/jens/Source/shotwell/src/Printing.vala"
	progress_dialog_close (_tmp25_);
#line 903 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->progress_dialog);
#line 903 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->progress_dialog = NULL;
#line 904 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 904 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->cancellable = NULL;
#line 906 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp26_ = app_window_get_instance ();
#line 906 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp27_ = _tmp26_;
#line 906 "/home/jens/Source/shotwell/src/Printing.vala"
	page_window_set_normal_cursor (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, TYPE_PAGE_WINDOW, PageWindow));
#line 906 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (_tmp27_);
#line 908 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp28_ = err_msg;
#line 908 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp28_ != NULL) {
#line 6502 "Printing.c"
		const gchar* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
#line 909 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp29_ = _ ("Unable to print photo:\n\n%s");
#line 909 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp30_ = err_msg;
#line 909 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp31_ = g_strdup_printf (_tmp29_, _tmp30_);
#line 909 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp32_ = _tmp31_;
#line 909 "/home/jens/Source/shotwell/src/Printing.vala"
		app_window_error_message (_tmp32_, NULL);
#line 909 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_free0 (_tmp32_);
#line 6519 "Printing.c"
	}
#line 874 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (err_msg);
#line 874 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (job);
#line 6525 "Printing.c"
}


static void print_manager_on_begin_print (PrintManager* self, GtkPrintOperation* emitting_object, GtkPrintContext* job_context) {
	PrintJob* job = NULL;
	GtkPrintOperation* _tmp0_ = NULL;
	PrintJob* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GCancellable* _tmp3_ = NULL;
	GeeList* photos = NULL;
	PrintJob* _tmp7_ = NULL;
	GeeList* _tmp8_ = NULL;
	PrintJob* _tmp9_ = NULL;
	PrintSettings* _tmp10_ = NULL;
	PrintSettings* _tmp11_ = NULL;
	ContentLayout _tmp12_ = 0;
	gboolean _tmp13_ = FALSE;
#line 912 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_MANAGER (self));
#line 912 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GTK_IS_PRINT_OPERATION (emitting_object));
#line 912 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GTK_IS_PRINT_CONTEXT (job_context));
#line 913 "/home/jens/Source/shotwell/src/Printing.vala"
	g_debug ("Printing.vala:913: on_begin_print");
#line 915 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = emitting_object;
#line 915 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PRINT_JOB, PrintJob));
#line 915 "/home/jens/Source/shotwell/src/Printing.vala"
	job = _tmp1_;
#line 918 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = self->priv->cancellable;
#line 918 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp3_ != NULL) {
#line 6561 "Printing.c"
		GCancellable* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 918 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp4_ = self->priv->cancellable;
#line 918 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = g_cancellable_is_cancelled (_tmp4_);
#line 918 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp2_ = _tmp5_;
#line 6570 "Printing.c"
	} else {
#line 918 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp2_ = FALSE;
#line 6574 "Printing.c"
	}
#line 918 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp2_) {
#line 6578 "Printing.c"
		PrintJob* _tmp6_ = NULL;
#line 919 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp6_ = job;
#line 919 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_print_operation_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_print_operation_get_type (), GtkPrintOperation));
#line 921 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_object_unref0 (job);
#line 921 "/home/jens/Source/shotwell/src/Printing.vala"
		return;
#line 6588 "Printing.c"
	}
#line 924 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = job;
#line 924 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = print_job_get_photos (_tmp7_);
#line 924 "/home/jens/Source/shotwell/src/Printing.vala"
	photos = _tmp8_;
#line 925 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = job;
#line 925 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = print_job_get_local_settings (_tmp9_);
#line 925 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp11_ = _tmp10_;
#line 925 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp12_ = print_settings_get_content_layout (_tmp11_);
#line 925 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp13_ = _tmp12_ == CONTENT_LAYOUT_IMAGE_PER_PAGE;
#line 925 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp11_);
#line 925 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp13_) {
#line 6610 "Printing.c"
		PrintLayout layout = 0;
		PrintJob* _tmp14_ = NULL;
		PrintSettings* _tmp15_ = NULL;
		PrintSettings* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		PrintLayout _tmp18_ = 0;
		PrintJob* _tmp19_ = NULL;
		GeeList* _tmp20_ = NULL;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		PrintLayout _tmp23_ = 0;
		gint _tmp24_ = 0;
		gdouble _tmp25_ = 0.0;
#line 926 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp14_ = job;
#line 926 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp15_ = print_job_get_local_settings (_tmp14_);
#line 926 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp16_ = _tmp15_;
#line 926 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp17_ = print_settings_get_image_per_page_selection (_tmp16_);
#line 926 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp18_ = (PrintLayout) _tmp17_;
#line 926 "/home/jens/Source/shotwell/src/Printing.vala"
		_print_settings_unref0 (_tmp16_);
#line 926 "/home/jens/Source/shotwell/src/Printing.vala"
		layout = _tmp18_;
#line 927 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp19_ = job;
#line 927 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp20_ = photos;
#line 927 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp21_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_COLLECTION, GeeCollection));
#line 927 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp22_ = _tmp21_;
#line 927 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp23_ = layout;
#line 927 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp24_ = print_layout_get_per_page (_tmp23_);
#line 927 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp25_ = ceil (((gdouble) _tmp22_) / ((gdouble) _tmp24_));
#line 927 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_print_operation_set_n_pages (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_print_operation_get_type (), GtkPrintOperation), (gint) _tmp25_);
#line 6654 "Printing.c"
	} else {
		PrintJob* _tmp26_ = NULL;
		GeeList* _tmp27_ = NULL;
		gint _tmp28_ = 0;
		gint _tmp29_ = 0;
#line 929 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp26_ = job;
#line 929 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp27_ = photos;
#line 929 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp28_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_COLLECTION, GeeCollection));
#line 929 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp29_ = _tmp28_;
#line 929 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_print_operation_set_n_pages (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, gtk_print_operation_get_type (), GtkPrintOperation), _tmp29_);
#line 6670 "Printing.c"
	}
#line 932 "/home/jens/Source/shotwell/src/Printing.vala"
	spin_event_loop ();
#line 912 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (photos);
#line 912 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (job);
#line 6678 "Printing.c"
}


static void print_manager_on_status_changed (PrintManager* self, GtkPrintOperation* job) {
	GtkPrintOperation* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	ProgressDialog* _tmp2_ = NULL;
#line 935 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_MANAGER (self));
#line 935 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GTK_IS_PRINT_OPERATION (job));
#line 936 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = job;
#line 936 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_print_operation_get_status_string (_tmp0_);
#line 936 "/home/jens/Source/shotwell/src/Printing.vala"
	g_debug ("Printing.vala:936: on_status_changed: %s", _tmp1_);
#line 938 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = self->priv->progress_dialog;
#line 938 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp2_ != NULL) {
#line 6700 "Printing.c"
		ProgressDialog* _tmp3_ = NULL;
		GtkPrintOperation* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 939 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp3_ = self->priv->progress_dialog;
#line 939 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp4_ = job;
#line 939 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = gtk_print_operation_get_status_string (_tmp4_);
#line 939 "/home/jens/Source/shotwell/src/Printing.vala"
		progress_dialog_set_status (_tmp3_, _tmp5_);
#line 940 "/home/jens/Source/shotwell/src/Printing.vala"
		spin_event_loop ();
#line 6714 "Printing.c"
	}
}


static gpointer _cairo_reference0 (gpointer self) {
#line 965 "/home/jens/Source/shotwell/src/Printing.vala"
	return self ? cairo_reference (self) : NULL;
#line 6722 "Printing.c"
}


static void print_manager_on_draw_page (PrintManager* self, GtkPrintOperation* emitting_object, GtkPrintContext* job_context, gint page_num) {
	PrintJob* job = NULL;
	GtkPrintOperation* _tmp0_ = NULL;
	PrintJob* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GCancellable* _tmp3_ = NULL;
	GtkPageSetup* page_setup = NULL;
	GtkPrintContext* _tmp7_ = NULL;
	GtkPageSetup* _tmp8_ = NULL;
	GtkPageSetup* _tmp9_ = NULL;
	gdouble page_width = 0.0;
	GtkPageSetup* _tmp10_ = NULL;
	gdouble _tmp11_ = 0.0;
	gdouble page_height = 0.0;
	GtkPageSetup* _tmp12_ = NULL;
	gdouble _tmp13_ = 0.0;
	gdouble dpi = 0.0;
	PrintJob* _tmp14_ = NULL;
	PrintSettings* _tmp15_ = NULL;
	PrintSettings* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gdouble _tmp18_ = 0.0;
	gdouble inv_dpi = 0.0;
	gdouble _tmp19_ = 0.0;
	cairo_t* dc = NULL;
	GtkPrintContext* _tmp20_ = NULL;
	cairo_t* _tmp21_ = NULL;
	cairo_t* _tmp22_ = NULL;
	cairo_t* _tmp23_ = NULL;
	gdouble _tmp24_ = 0.0;
	gdouble _tmp25_ = 0.0;
	GeeList* photos = NULL;
	PrintJob* _tmp26_ = NULL;
	GeeList* _tmp27_ = NULL;
	ContentLayout content_layout = 0;
	PrintJob* _tmp28_ = NULL;
	PrintSettings* _tmp29_ = NULL;
	PrintSettings* _tmp30_ = NULL;
	ContentLayout _tmp31_ = 0;
	ContentLayout _tmp32_ = 0;
	ContentLayout _tmp33_ = 0;
#line 944 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_MANAGER (self));
#line 944 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GTK_IS_PRINT_OPERATION (emitting_object));
#line 944 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GTK_IS_PRINT_CONTEXT (job_context));
#line 946 "/home/jens/Source/shotwell/src/Printing.vala"
	g_debug ("Printing.vala:946: on_draw_page");
#line 948 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = emitting_object;
#line 948 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PRINT_JOB, PrintJob));
#line 948 "/home/jens/Source/shotwell/src/Printing.vala"
	job = _tmp1_;
#line 951 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = self->priv->cancellable;
#line 951 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp3_ != NULL) {
#line 6785 "Printing.c"
		GCancellable* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 951 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp4_ = self->priv->cancellable;
#line 951 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = g_cancellable_is_cancelled (_tmp4_);
#line 951 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp2_ = _tmp5_;
#line 6794 "Printing.c"
	} else {
#line 951 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp2_ = FALSE;
#line 6798 "Printing.c"
	}
#line 951 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp2_) {
#line 6802 "Printing.c"
		PrintJob* _tmp6_ = NULL;
#line 952 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp6_ = job;
#line 952 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_print_operation_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_print_operation_get_type (), GtkPrintOperation));
#line 954 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_object_unref0 (job);
#line 954 "/home/jens/Source/shotwell/src/Printing.vala"
		return;
#line 6812 "Printing.c"
	}
#line 957 "/home/jens/Source/shotwell/src/Printing.vala"
	spin_event_loop ();
#line 959 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = job_context;
#line 959 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = gtk_print_context_get_page_setup (_tmp7_);
#line 959 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = _g_object_ref0 (_tmp8_);
#line 959 "/home/jens/Source/shotwell/src/Printing.vala"
	page_setup = _tmp9_;
#line 960 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = page_setup;
#line 960 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp11_ = gtk_page_setup_get_page_width (_tmp10_, GTK_UNIT_INCH);
#line 960 "/home/jens/Source/shotwell/src/Printing.vala"
	page_width = _tmp11_;
#line 961 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp12_ = page_setup;
#line 961 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp13_ = gtk_page_setup_get_page_height (_tmp12_, GTK_UNIT_INCH);
#line 961 "/home/jens/Source/shotwell/src/Printing.vala"
	page_height = _tmp13_;
#line 963 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_ = job;
#line 963 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp15_ = print_job_get_local_settings (_tmp14_);
#line 963 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp16_ = _tmp15_;
#line 963 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp17_ = print_settings_get_content_ppi (_tmp16_);
#line 963 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp18_ = (gdouble) _tmp17_;
#line 963 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp16_);
#line 963 "/home/jens/Source/shotwell/src/Printing.vala"
	dpi = _tmp18_;
#line 964 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp19_ = dpi;
#line 964 "/home/jens/Source/shotwell/src/Printing.vala"
	inv_dpi = 1.0 / _tmp19_;
#line 965 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp20_ = job_context;
#line 965 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp21_ = gtk_print_context_get_cairo_context (_tmp20_);
#line 965 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp22_ = _cairo_reference0 (_tmp21_);
#line 965 "/home/jens/Source/shotwell/src/Printing.vala"
	dc = _tmp22_;
#line 966 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp23_ = dc;
#line 966 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp24_ = inv_dpi;
#line 966 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp25_ = inv_dpi;
#line 966 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_scale (_tmp23_, _tmp24_, _tmp25_);
#line 967 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp26_ = job;
#line 967 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp27_ = print_job_get_photos (_tmp26_);
#line 967 "/home/jens/Source/shotwell/src/Printing.vala"
	photos = _tmp27_;
#line 969 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp28_ = job;
#line 969 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp29_ = print_job_get_local_settings (_tmp28_);
#line 969 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp30_ = _tmp29_;
#line 969 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp31_ = print_settings_get_content_layout (_tmp30_);
#line 969 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp32_ = _tmp31_;
#line 969 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp30_);
#line 969 "/home/jens/Source/shotwell/src/Printing.vala"
	content_layout = _tmp32_;
#line 970 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp33_ = content_layout;
#line 970 "/home/jens/Source/shotwell/src/Printing.vala"
	switch (_tmp33_) {
#line 970 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_STANDARD_SIZE:
#line 970 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_CUSTOM_SIZE:
#line 6898 "Printing.c"
		{
			gdouble canvas_width = 0.0;
			gdouble canvas_height = 0.0;
			ContentLayout _tmp34_ = 0;
			gint _tmp68_ = 0;
			GeeList* _tmp69_ = NULL;
			gint _tmp70_ = 0;
			gint _tmp71_ = 0;
			ProgressDialog* _tmp117_ = NULL;
#line 974 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp34_ = content_layout;
#line 974 "/home/jens/Source/shotwell/src/Printing.vala"
			if (_tmp34_ == CONTENT_LAYOUT_STANDARD_SIZE) {
#line 6912 "Printing.c"
				gint _tmp35_ = 0;
				StandardPrintSize** _tmp36_ = NULL;
				StandardPrintSize** _tmp37_ = NULL;
				gint _tmp37__length1 = 0;
				PrintJob* _tmp38_ = NULL;
				PrintSettings* _tmp39_ = NULL;
				PrintSettings* _tmp40_ = NULL;
				gint _tmp41_ = 0;
				StandardPrintSize* _tmp42_ = NULL;
				Measurement _tmp43_ = {0};
				gdouble _tmp44_ = 0.0;
				gint _tmp45_ = 0;
				StandardPrintSize** _tmp46_ = NULL;
				StandardPrintSize** _tmp47_ = NULL;
				gint _tmp47__length1 = 0;
				PrintJob* _tmp48_ = NULL;
				PrintSettings* _tmp49_ = NULL;
				PrintSettings* _tmp50_ = NULL;
				gint _tmp51_ = 0;
				StandardPrintSize* _tmp52_ = NULL;
				Measurement _tmp53_ = {0};
				gdouble _tmp54_ = 0.0;
#line 975 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp36_ = print_manager_get_standard_sizes (self, &_tmp35_);
#line 975 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp37_ = _tmp36_;
#line 975 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp37__length1 = _tmp35_;
#line 975 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp38_ = job;
#line 975 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp39_ = print_job_get_local_settings (_tmp38_);
#line 975 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp40_ = _tmp39_;
#line 975 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp41_ = print_settings_get_size_selection (_tmp40_);
#line 975 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp42_ = _tmp37_[_tmp41_];
#line 975 "/home/jens/Source/shotwell/src/Printing.vala"
				measurement_convert_to (&_tmp42_->width, MEASUREMENT_UNIT_INCHES, &_tmp43_);
#line 975 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp44_ = _tmp43_.value;
#line 975 "/home/jens/Source/shotwell/src/Printing.vala"
				canvas_width = _tmp44_;
#line 975 "/home/jens/Source/shotwell/src/Printing.vala"
				_print_settings_unref0 (_tmp40_);
#line 975 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp37_ = (_vala_array_free (_tmp37_, _tmp37__length1, (GDestroyNotify) standard_print_size_unref), NULL);
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp46_ = print_manager_get_standard_sizes (self, &_tmp45_);
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp47_ = _tmp46_;
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp47__length1 = _tmp45_;
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp48_ = job;
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp49_ = print_job_get_local_settings (_tmp48_);
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp50_ = _tmp49_;
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp51_ = print_settings_get_size_selection (_tmp50_);
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp52_ = _tmp47_[_tmp51_];
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
				measurement_convert_to (&_tmp52_->height, MEASUREMENT_UNIT_INCHES, &_tmp53_);
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp54_ = _tmp53_.value;
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
				canvas_height = _tmp54_;
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
				_print_settings_unref0 (_tmp50_);
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp47_ = (_vala_array_free (_tmp47_, _tmp47__length1, (GDestroyNotify) standard_print_size_unref), NULL);
#line 6987 "Printing.c"
			} else {
				ContentLayout _tmp55_ = 0;
				PrintJob* _tmp56_ = NULL;
				PrintSettings* _tmp57_ = NULL;
				PrintSettings* _tmp58_ = NULL;
				Measurement _tmp59_ = {0};
				Measurement _tmp60_ = {0};
				gdouble _tmp61_ = 0.0;
				PrintJob* _tmp62_ = NULL;
				PrintSettings* _tmp63_ = NULL;
				PrintSettings* _tmp64_ = NULL;
				Measurement _tmp65_ = {0};
				Measurement _tmp66_ = {0};
				gdouble _tmp67_ = 0.0;
#line 980 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp55_ = content_layout;
#line 980 "/home/jens/Source/shotwell/src/Printing.vala"
				_vala_assert (_tmp55_ == CONTENT_LAYOUT_CUSTOM_SIZE, "content_layout == ContentLayout.CUSTOM_SIZE");
#line 981 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp56_ = job;
#line 981 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp57_ = print_job_get_local_settings (_tmp56_);
#line 981 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp58_ = _tmp57_;
#line 981 "/home/jens/Source/shotwell/src/Printing.vala"
				print_settings_get_content_width (_tmp58_, &_tmp59_);
#line 981 "/home/jens/Source/shotwell/src/Printing.vala"
				measurement_convert_to (&_tmp59_, MEASUREMENT_UNIT_INCHES, &_tmp60_);
#line 981 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp61_ = _tmp60_.value;
#line 981 "/home/jens/Source/shotwell/src/Printing.vala"
				canvas_width = _tmp61_;
#line 981 "/home/jens/Source/shotwell/src/Printing.vala"
				_print_settings_unref0 (_tmp58_);
#line 983 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp62_ = job;
#line 983 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp63_ = print_job_get_local_settings (_tmp62_);
#line 983 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp64_ = _tmp63_;
#line 983 "/home/jens/Source/shotwell/src/Printing.vala"
				print_settings_get_content_height (_tmp64_, &_tmp65_);
#line 983 "/home/jens/Source/shotwell/src/Printing.vala"
				measurement_convert_to (&_tmp65_, MEASUREMENT_UNIT_INCHES, &_tmp66_);
#line 983 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp67_ = _tmp66_.value;
#line 983 "/home/jens/Source/shotwell/src/Printing.vala"
				canvas_height = _tmp67_;
#line 983 "/home/jens/Source/shotwell/src/Printing.vala"
				_print_settings_unref0 (_tmp64_);
#line 7038 "Printing.c"
			}
#line 987 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp68_ = page_num;
#line 987 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp69_ = photos;
#line 987 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp70_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, GEE_TYPE_COLLECTION, GeeCollection));
#line 987 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp71_ = _tmp70_;
#line 987 "/home/jens/Source/shotwell/src/Printing.vala"
			if (_tmp68_ < _tmp71_) {
#line 7050 "Printing.c"
				Dimensions photo_dimensions = {0};
				GeeList* _tmp72_ = NULL;
				gint _tmp73_ = 0;
				gpointer _tmp74_ = NULL;
				Photo* _tmp75_ = NULL;
				Dimensions _tmp76_ = {0};
				Dimensions _tmp77_ = {0};
				gdouble photo_aspect_ratio = 0.0;
				gdouble _tmp78_ = 0.0;
				gdouble canvas_aspect_ratio = 0.0;
				gdouble _tmp79_ = 0.0;
				gdouble _tmp80_ = 0.0;
				gdouble _tmp81_ = 0.0;
				gdouble _tmp82_ = 0.0;
				gdouble _tmp83_ = 0.0;
				gdouble _tmp84_ = 0.0;
				gdouble dx = 0.0;
				gdouble _tmp88_ = 0.0;
				gdouble _tmp89_ = 0.0;
				gdouble dy = 0.0;
				gdouble _tmp90_ = 0.0;
				gdouble _tmp91_ = 0.0;
				GeeList* _tmp92_ = NULL;
				gint _tmp93_ = 0;
				gpointer _tmp94_ = NULL;
				Photo* _tmp95_ = NULL;
				gdouble _tmp96_ = 0.0;
				gdouble _tmp97_ = 0.0;
				gdouble _tmp98_ = 0.0;
				gdouble _tmp99_ = 0.0;
				PrintJob* _tmp100_ = NULL;
				GtkPrintContext* _tmp101_ = NULL;
				PrintJob* _tmp102_ = NULL;
				PrintSettings* _tmp103_ = NULL;
				PrintSettings* _tmp104_ = NULL;
				gboolean _tmp105_ = FALSE;
				gboolean _tmp106_ = FALSE;
#line 988 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp72_ = photos;
#line 988 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp73_ = page_num;
#line 988 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp74_ = gee_list_get (_tmp72_, _tmp73_);
#line 988 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp75_ = (Photo*) _tmp74_;
#line 988 "/home/jens/Source/shotwell/src/Printing.vala"
				media_source_get_dimensions (G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, TYPE_MEDIA_SOURCE, MediaSource), PHOTO_EXCEPTION_NONE, &_tmp76_);
#line 988 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp77_ = _tmp76_;
#line 988 "/home/jens/Source/shotwell/src/Printing.vala"
				_g_object_unref0 (_tmp75_);
#line 988 "/home/jens/Source/shotwell/src/Printing.vala"
				photo_dimensions = _tmp77_;
#line 989 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp78_ = dimensions_get_aspect_ratio (&photo_dimensions);
#line 989 "/home/jens/Source/shotwell/src/Printing.vala"
				photo_aspect_ratio = _tmp78_;
#line 990 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp79_ = canvas_width;
#line 990 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp80_ = canvas_height;
#line 990 "/home/jens/Source/shotwell/src/Printing.vala"
				canvas_aspect_ratio = ((gdouble) _tmp79_) / _tmp80_;
#line 991 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp81_ = canvas_aspect_ratio;
#line 991 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp82_ = floor (_tmp81_);
#line 991 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp83_ = photo_aspect_ratio;
#line 991 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp84_ = floor (_tmp83_);
#line 991 "/home/jens/Source/shotwell/src/Printing.vala"
				if (_tmp82_ != _tmp84_) {
#line 7124 "Printing.c"
					gdouble canvas_tmp = 0.0;
					gdouble _tmp85_ = 0.0;
					gdouble _tmp86_ = 0.0;
					gdouble _tmp87_ = 0.0;
#line 992 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp85_ = canvas_width;
#line 992 "/home/jens/Source/shotwell/src/Printing.vala"
					canvas_tmp = _tmp85_;
#line 993 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp86_ = canvas_height;
#line 993 "/home/jens/Source/shotwell/src/Printing.vala"
					canvas_width = _tmp86_;
#line 994 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp87_ = canvas_tmp;
#line 994 "/home/jens/Source/shotwell/src/Printing.vala"
					canvas_height = _tmp87_;
#line 7141 "Printing.c"
				}
#line 997 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp88_ = page_width;
#line 997 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp89_ = canvas_width;
#line 997 "/home/jens/Source/shotwell/src/Printing.vala"
				dx = (_tmp88_ - _tmp89_) / 2.0;
#line 998 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp90_ = page_height;
#line 998 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp91_ = canvas_height;
#line 998 "/home/jens/Source/shotwell/src/Printing.vala"
				dy = (_tmp90_ - _tmp91_) / 2.0;
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp92_ = photos;
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp93_ = page_num;
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp94_ = gee_list_get (_tmp92_, _tmp93_);
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp95_ = (Photo*) _tmp94_;
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp96_ = dx;
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp97_ = dy;
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp98_ = canvas_width;
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp99_ = canvas_height;
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp100_ = job;
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp101_ = job_context;
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
				print_manager_fit_image_to_canvas (self, _tmp95_, _tmp96_, _tmp97_, _tmp98_, _tmp99_, TRUE, _tmp100_, _tmp101_);
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
				_g_object_unref0 (_tmp95_);
#line 1001 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp102_ = job;
#line 1001 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp103_ = print_job_get_local_settings (_tmp102_);
#line 1001 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp104_ = _tmp103_;
#line 1001 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp105_ = print_settings_is_print_titles_enabled (_tmp104_);
#line 1001 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp106_ = _tmp105_;
#line 1001 "/home/jens/Source/shotwell/src/Printing.vala"
				_print_settings_unref0 (_tmp104_);
#line 1001 "/home/jens/Source/shotwell/src/Printing.vala"
				if (_tmp106_) {
#line 7193 "Printing.c"
					gdouble _tmp107_ = 0.0;
					gdouble _tmp108_ = 0.0;
					GeeList* _tmp109_ = NULL;
					gint _tmp110_ = 0;
					gpointer _tmp111_ = NULL;
					Photo* _tmp112_ = NULL;
					gchar* _tmp113_ = NULL;
					gchar* _tmp114_ = NULL;
					PrintJob* _tmp115_ = NULL;
					GtkPrintContext* _tmp116_ = NULL;
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp107_ = page_width;
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp108_ = page_height;
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp109_ = photos;
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp110_ = page_num;
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp111_ = gee_list_get (_tmp109_, _tmp110_);
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp112_ = (Photo*) _tmp111_;
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp113_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp112_, TYPE_DATA_OBJECT, DataObject));
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp114_ = _tmp113_;
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp115_ = job;
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp116_ = job_context;
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
					print_manager_add_title_to_canvas (self, _tmp107_ / 2, _tmp108_, _tmp114_, _tmp115_, _tmp116_);
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
					_g_free0 (_tmp114_);
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
					_g_object_unref0 (_tmp112_);
#line 7230 "Printing.c"
				}
			}
#line 1007 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp117_ = self->priv->progress_dialog;
#line 1007 "/home/jens/Source/shotwell/src/Printing.vala"
			if (_tmp117_ != NULL) {
#line 7237 "Printing.c"
				ProgressDialog* _tmp118_ = NULL;
				gint _tmp119_ = 0;
				GeeList* _tmp120_ = NULL;
				gint _tmp121_ = 0;
				gint _tmp122_ = 0;
#line 1008 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp118_ = self->priv->progress_dialog;
#line 1008 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp119_ = page_num;
#line 1008 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp120_ = photos;
#line 1008 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp121_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp120_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1008 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp122_ = _tmp121_;
#line 1008 "/home/jens/Source/shotwell/src/Printing.vala"
				progress_dialog_monitor (_tmp118_, (guint64) _tmp119_, (guint64) _tmp122_, TRUE);
#line 7255 "Printing.c"
			}
#line 1009 "/home/jens/Source/shotwell/src/Printing.vala"
			break;
#line 7259 "Printing.c"
		}
#line 970 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_IMAGE_PER_PAGE:
#line 7263 "Printing.c"
		{
			PrintLayout layout = 0;
			PrintJob* _tmp123_ = NULL;
			PrintSettings* _tmp124_ = NULL;
			PrintSettings* _tmp125_ = NULL;
			gint _tmp126_ = 0;
			PrintLayout _tmp127_ = 0;
			gint nx = 0;
			PrintLayout _tmp128_ = 0;
			gint _tmp129_ = 0;
			gint ny = 0;
			PrintLayout _tmp130_ = 0;
			gint _tmp131_ = 0;
			gint start = 0;
			gint _tmp132_ = 0;
			PrintLayout _tmp133_ = 0;
			gint _tmp134_ = 0;
			gdouble canvas_width = 0.0;
			gdouble _tmp135_ = 0.0;
			gint _tmp136_ = 0;
			gint _tmp137_ = 0;
			gdouble canvas_height = 0.0;
			gdouble _tmp138_ = 0.0;
			gint _tmp139_ = 0;
			gint _tmp140_ = 0;
#line 1012 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp123_ = job;
#line 1012 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp124_ = print_job_get_local_settings (_tmp123_);
#line 1012 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp125_ = _tmp124_;
#line 1012 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp126_ = print_settings_get_image_per_page_selection (_tmp125_);
#line 1012 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp127_ = (PrintLayout) _tmp126_;
#line 1012 "/home/jens/Source/shotwell/src/Printing.vala"
			_print_settings_unref0 (_tmp125_);
#line 1012 "/home/jens/Source/shotwell/src/Printing.vala"
			layout = _tmp127_;
#line 1013 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp128_ = layout;
#line 1013 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp129_ = print_layout_get_x (_tmp128_);
#line 1013 "/home/jens/Source/shotwell/src/Printing.vala"
			nx = _tmp129_;
#line 1014 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp130_ = layout;
#line 1014 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp131_ = print_layout_get_y (_tmp130_);
#line 1014 "/home/jens/Source/shotwell/src/Printing.vala"
			ny = _tmp131_;
#line 1015 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp132_ = page_num;
#line 1015 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp133_ = layout;
#line 1015 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp134_ = print_layout_get_per_page (_tmp133_);
#line 1015 "/home/jens/Source/shotwell/src/Printing.vala"
			start = _tmp132_ * _tmp134_;
#line 1016 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp135_ = page_width;
#line 1016 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp136_ = nx;
#line 1016 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp137_ = nx;
#line 1016 "/home/jens/Source/shotwell/src/Printing.vala"
			canvas_width = ((gdouble) (_tmp135_ - (PRINT_MANAGER_IMAGE_DISTANCE * (_tmp136_ - 1)))) / _tmp137_;
#line 1017 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp138_ = page_height;
#line 1017 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp139_ = ny;
#line 1017 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp140_ = ny;
#line 1017 "/home/jens/Source/shotwell/src/Printing.vala"
			canvas_height = ((gdouble) (_tmp138_ - (PRINT_MANAGER_IMAGE_DISTANCE * (_tmp139_ - 1)))) / _tmp140_;
#line 7339 "Printing.c"
			{
				gint y = 0;
#line 1018 "/home/jens/Source/shotwell/src/Printing.vala"
				y = 0;
#line 7344 "Printing.c"
				{
					gboolean _tmp141_ = FALSE;
#line 1018 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp141_ = TRUE;
#line 1018 "/home/jens/Source/shotwell/src/Printing.vala"
					while (TRUE) {
#line 7351 "Printing.c"
						gint _tmp143_ = 0;
						gint _tmp144_ = 0;
#line 1018 "/home/jens/Source/shotwell/src/Printing.vala"
						if (!_tmp141_) {
#line 7356 "Printing.c"
							gint _tmp142_ = 0;
#line 1018 "/home/jens/Source/shotwell/src/Printing.vala"
							_tmp142_ = y;
#line 1018 "/home/jens/Source/shotwell/src/Printing.vala"
							y = _tmp142_ + 1;
#line 7362 "Printing.c"
						}
#line 1018 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp141_ = FALSE;
#line 1018 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp143_ = y;
#line 1018 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp144_ = ny;
#line 1018 "/home/jens/Source/shotwell/src/Printing.vala"
						if (!(_tmp143_ < _tmp144_)) {
#line 1018 "/home/jens/Source/shotwell/src/Printing.vala"
							break;
#line 7374 "Printing.c"
						}
						{
							gint x = 0;
#line 1019 "/home/jens/Source/shotwell/src/Printing.vala"
							x = 0;
#line 7380 "Printing.c"
							{
								gboolean _tmp145_ = FALSE;
#line 1019 "/home/jens/Source/shotwell/src/Printing.vala"
								_tmp145_ = TRUE;
#line 1019 "/home/jens/Source/shotwell/src/Printing.vala"
								while (TRUE) {
#line 7387 "Printing.c"
									gint _tmp147_ = 0;
									gint _tmp148_ = 0;
									gint i = 0;
									gint _tmp149_ = 0;
									gint _tmp150_ = 0;
									gint _tmp151_ = 0;
									gint _tmp152_ = 0;
									gint _tmp153_ = 0;
									GeeList* _tmp154_ = NULL;
									gint _tmp155_ = 0;
									gint _tmp156_ = 0;
									ProgressDialog* _tmp190_ = NULL;
#line 1019 "/home/jens/Source/shotwell/src/Printing.vala"
									if (!_tmp145_) {
#line 7402 "Printing.c"
										gint _tmp146_ = 0;
#line 1019 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp146_ = x;
#line 1019 "/home/jens/Source/shotwell/src/Printing.vala"
										x = _tmp146_ + 1;
#line 7408 "Printing.c"
									}
#line 1019 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp145_ = FALSE;
#line 1019 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp147_ = x;
#line 1019 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp148_ = nx;
#line 1019 "/home/jens/Source/shotwell/src/Printing.vala"
									if (!(_tmp147_ < _tmp148_)) {
#line 1019 "/home/jens/Source/shotwell/src/Printing.vala"
										break;
#line 7420 "Printing.c"
									}
#line 1020 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp149_ = start;
#line 1020 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp150_ = y;
#line 1020 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp151_ = nx;
#line 1020 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp152_ = x;
#line 1020 "/home/jens/Source/shotwell/src/Printing.vala"
									i = (_tmp149_ + (_tmp150_ * _tmp151_)) + _tmp152_;
#line 1021 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp153_ = i;
#line 1021 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp154_ = photos;
#line 1021 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp155_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp154_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1021 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp156_ = _tmp155_;
#line 1021 "/home/jens/Source/shotwell/src/Printing.vala"
									if (_tmp153_ < _tmp156_) {
#line 7442 "Printing.c"
										gdouble dx = 0.0;
										gint _tmp157_ = 0;
										gdouble _tmp158_ = 0.0;
										gint _tmp159_ = 0;
										gdouble dy = 0.0;
										gint _tmp160_ = 0;
										gdouble _tmp161_ = 0.0;
										gint _tmp162_ = 0;
										GeeList* _tmp163_ = NULL;
										gint _tmp164_ = 0;
										gpointer _tmp165_ = NULL;
										Photo* _tmp166_ = NULL;
										gdouble _tmp167_ = 0.0;
										gdouble _tmp168_ = 0.0;
										gdouble _tmp169_ = 0.0;
										gdouble _tmp170_ = 0.0;
										PrintJob* _tmp171_ = NULL;
										GtkPrintContext* _tmp172_ = NULL;
										PrintJob* _tmp173_ = NULL;
										PrintSettings* _tmp174_ = NULL;
										PrintSettings* _tmp175_ = NULL;
										gboolean _tmp176_ = FALSE;
										gboolean _tmp177_ = FALSE;
#line 1022 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp157_ = x;
#line 1022 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp158_ = canvas_width;
#line 1022 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp159_ = x;
#line 1022 "/home/jens/Source/shotwell/src/Printing.vala"
										dx = (_tmp157_ * _tmp158_) + (_tmp159_ * PRINT_MANAGER_IMAGE_DISTANCE);
#line 1023 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp160_ = y;
#line 1023 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp161_ = canvas_height;
#line 1023 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp162_ = y;
#line 1023 "/home/jens/Source/shotwell/src/Printing.vala"
										dy = (_tmp160_ * _tmp161_) + (_tmp162_ * PRINT_MANAGER_IMAGE_DISTANCE);
#line 1024 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp163_ = photos;
#line 1024 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp164_ = i;
#line 1024 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp165_ = gee_list_get (_tmp163_, _tmp164_);
#line 1024 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp166_ = (Photo*) _tmp165_;
#line 1024 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp167_ = dx;
#line 1024 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp168_ = dy;
#line 1024 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp169_ = canvas_width;
#line 1024 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp170_ = canvas_height;
#line 1024 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp171_ = job;
#line 1024 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp172_ = job_context;
#line 1024 "/home/jens/Source/shotwell/src/Printing.vala"
										print_manager_fit_image_to_canvas (self, _tmp166_, _tmp167_, _tmp168_, _tmp169_, _tmp170_, FALSE, _tmp171_, _tmp172_);
#line 1024 "/home/jens/Source/shotwell/src/Printing.vala"
										_g_object_unref0 (_tmp166_);
#line 1026 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp173_ = job;
#line 1026 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp174_ = print_job_get_local_settings (_tmp173_);
#line 1026 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp175_ = _tmp174_;
#line 1026 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp176_ = print_settings_is_print_titles_enabled (_tmp175_);
#line 1026 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp177_ = _tmp176_;
#line 1026 "/home/jens/Source/shotwell/src/Printing.vala"
										_print_settings_unref0 (_tmp175_);
#line 1026 "/home/jens/Source/shotwell/src/Printing.vala"
										if (_tmp177_) {
#line 7520 "Printing.c"
											gdouble _tmp178_ = 0.0;
											gdouble _tmp179_ = 0.0;
											gdouble _tmp180_ = 0.0;
											gdouble _tmp181_ = 0.0;
											GeeList* _tmp182_ = NULL;
											gint _tmp183_ = 0;
											gpointer _tmp184_ = NULL;
											Photo* _tmp185_ = NULL;
											gchar* _tmp186_ = NULL;
											gchar* _tmp187_ = NULL;
											PrintJob* _tmp188_ = NULL;
											GtkPrintContext* _tmp189_ = NULL;
#line 1027 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp178_ = dx;
#line 1027 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp179_ = canvas_width;
#line 1027 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp180_ = dy;
#line 1027 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp181_ = canvas_height;
#line 1027 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp182_ = photos;
#line 1027 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp183_ = i;
#line 1027 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp184_ = gee_list_get (_tmp182_, _tmp183_);
#line 1027 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp185_ = (Photo*) _tmp184_;
#line 1027 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp186_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp185_, TYPE_DATA_OBJECT, DataObject));
#line 1027 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp187_ = _tmp186_;
#line 1027 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp188_ = job;
#line 1027 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp189_ = job_context;
#line 1027 "/home/jens/Source/shotwell/src/Printing.vala"
											print_manager_add_title_to_canvas (self, _tmp178_ + (_tmp179_ / 2), _tmp180_ + _tmp181_, _tmp187_, _tmp188_, _tmp189_);
#line 1027 "/home/jens/Source/shotwell/src/Printing.vala"
											_g_free0 (_tmp187_);
#line 1027 "/home/jens/Source/shotwell/src/Printing.vala"
											_g_object_unref0 (_tmp185_);
#line 7563 "Printing.c"
										}
									}
#line 1032 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp190_ = self->priv->progress_dialog;
#line 1032 "/home/jens/Source/shotwell/src/Printing.vala"
									if (_tmp190_ != NULL) {
#line 7570 "Printing.c"
										ProgressDialog* _tmp191_ = NULL;
										gint _tmp192_ = 0;
										GeeList* _tmp193_ = NULL;
										gint _tmp194_ = 0;
										gint _tmp195_ = 0;
#line 1033 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp191_ = self->priv->progress_dialog;
#line 1033 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp192_ = i;
#line 1033 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp193_ = photos;
#line 1033 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp194_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp193_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1033 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp195_ = _tmp194_;
#line 1033 "/home/jens/Source/shotwell/src/Printing.vala"
										progress_dialog_monitor (_tmp191_, (guint64) _tmp192_, (guint64) _tmp195_, TRUE);
#line 7588 "Printing.c"
									}
								}
							}
						}
					}
				}
			}
#line 1036 "/home/jens/Source/shotwell/src/Printing.vala"
			break;
#line 7598 "Printing.c"
		}
		default:
		{
#line 1039 "/home/jens/Source/shotwell/src/Printing.vala"
			g_error ("Printing.vala:1039: unknown or unsupported layout mode");
#line 7604 "Printing.c"
		}
	}
#line 944 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (photos);
#line 944 "/home/jens/Source/shotwell/src/Printing.vala"
	_cairo_destroy0 (dc);
#line 944 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (page_setup);
#line 944 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (job);
#line 7615 "Printing.c"
}


static void _print_manager_on_custom_widget_apply_gtk_print_operation_custom_widget_apply (GtkPrintOperation* _sender, GtkWidget* widget, gpointer self) {
#line 1045 "/home/jens/Source/shotwell/src/Printing.vala"
	print_manager_on_custom_widget_apply ((PrintManager*) self, widget);
#line 7622 "Printing.c"
}


static GObject* print_manager_on_create_custom_widget (PrintManager* self, GtkPrintOperation* emitting_object) {
	GObject* result = NULL;
	GtkPrintOperation* _tmp0_ = NULL;
	CustomPrintTab* _tmp1_ = NULL;
	GtkPrintOperation* _tmp2_ = NULL;
	CustomPrintTab* _tmp3_ = NULL;
#line 1043 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_MANAGER (self), NULL);
#line 1043 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (GTK_IS_PRINT_OPERATION (emitting_object), NULL);
#line 1044 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = emitting_object;
#line 1044 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = custom_print_tab_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PRINT_JOB, PrintJob));
#line 1044 "/home/jens/Source/shotwell/src/Printing.vala"
	g_object_ref_sink (_tmp1_);
#line 1044 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->custom_tab);
#line 1044 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->custom_tab = _tmp1_;
#line 1045 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = emitting_object;
#line 1045 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PRINT_JOB, PrintJob), gtk_print_operation_get_type (), GtkPrintOperation), "custom-widget-apply", (GCallback) _print_manager_on_custom_widget_apply_gtk_print_operation_custom_widget_apply, self);
#line 1046 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = self->priv->custom_tab;
#line 1046 "/home/jens/Source/shotwell/src/Printing.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, G_TYPE_OBJECT, GObject);
#line 1046 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 7656 "Printing.c"
}


static void print_manager_on_custom_widget_apply (PrintManager* self, GtkWidget* custom_widget) {
	CustomPrintTab* tab = NULL;
	GtkWidget* _tmp0_ = NULL;
	CustomPrintTab* _tmp1_ = NULL;
	PrintJob* _tmp2_ = NULL;
	PrintJob* _tmp3_ = NULL;
	PrintSettings* _tmp4_ = NULL;
	PrintSettings* _tmp5_ = NULL;
	PrintSettings* _tmp6_ = NULL;
	PrintSettings* _tmp7_ = NULL;
#line 1049 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_MANAGER (self));
#line 1049 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GTK_IS_WIDGET (custom_widget));
#line 1050 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = custom_widget;
#line 1050 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_CUSTOM_PRINT_TAB, CustomPrintTab));
#line 1050 "/home/jens/Source/shotwell/src/Printing.vala"
	tab = _tmp1_;
#line 1051 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = custom_print_tab_get_source_job (tab);
#line 1051 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = _tmp2_;
#line 1051 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = custom_print_tab_get_local_settings (tab);
#line 1051 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = _tmp4_;
#line 1051 "/home/jens/Source/shotwell/src/Printing.vala"
	print_job_set_local_settings (_tmp3_, _tmp5_);
#line 1051 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp5_);
#line 1051 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (_tmp3_);
#line 1052 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = custom_print_tab_get_local_settings (tab);
#line 1052 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = _tmp6_;
#line 1052 "/home/jens/Source/shotwell/src/Printing.vala"
	print_manager_set_global_settings (self, _tmp7_);
#line 1052 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp7_);
#line 1049 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (tab);
#line 7704 "Printing.c"
}


static void print_manager_fit_image_to_canvas (PrintManager* self, Photo* photo, gdouble x, gdouble y, gdouble canvas_width, gdouble canvas_height, gboolean crop, PrintJob* job, GtkPrintContext* job_context) {
	cairo_t* dc = NULL;
	GtkPrintContext* _tmp0_ = NULL;
	cairo_t* _tmp1_ = NULL;
	cairo_t* _tmp2_ = NULL;
	Dimensions photo_dimensions = {0};
	Photo* _tmp3_ = NULL;
	Dimensions _tmp4_ = {0};
	gdouble photo_aspect_ratio = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble canvas_aspect_ratio = 0.0;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	gdouble target_width = 0.0;
	gdouble target_height = 0.0;
	gdouble dpi = 0.0;
	PrintJob* _tmp8_ = NULL;
	PrintSettings* _tmp9_ = NULL;
	PrintSettings* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gdouble _tmp12_ = 0.0;
	gboolean _tmp13_ = FALSE;
	gdouble x_offset = 0.0;
	gdouble _tmp28_ = 0.0;
	gdouble _tmp29_ = 0.0;
	gdouble y_offset = 0.0;
	gdouble _tmp30_ = 0.0;
	gdouble _tmp31_ = 0.0;
	cairo_t* _tmp32_ = NULL;
	cairo_t* _tmp33_ = NULL;
	gdouble _tmp34_ = 0.0;
	gdouble _tmp35_ = 0.0;
	gint w = 0;
	gdouble _tmp36_ = 0.0;
	gdouble _tmp37_ = 0.0;
	gint h = 0;
	gdouble _tmp38_ = 0.0;
	gdouble _tmp39_ = 0.0;
	Dimensions viewport = {0};
	gint _tmp40_ = 0;
	gint _tmp41_ = 0;
	cairo_t* _tmp96_ = NULL;
	GError * _inner_error_ = NULL;
#line 1055 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_MANAGER (self));
#line 1055 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PHOTO (photo));
#line 1055 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_JOB (job));
#line 1055 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GTK_IS_PRINT_CONTEXT (job_context));
#line 1056 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = job_context;
#line 1056 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_print_context_get_cairo_context (_tmp0_);
#line 1056 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = _cairo_reference0 (_tmp1_);
#line 1056 "/home/jens/Source/shotwell/src/Printing.vala"
	dc = _tmp2_;
#line 1057 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = photo;
#line 1057 "/home/jens/Source/shotwell/src/Printing.vala"
	media_source_get_dimensions (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_MEDIA_SOURCE, MediaSource), PHOTO_EXCEPTION_NONE, &_tmp4_);
#line 1057 "/home/jens/Source/shotwell/src/Printing.vala"
	photo_dimensions = _tmp4_;
#line 1058 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = dimensions_get_aspect_ratio (&photo_dimensions);
#line 1058 "/home/jens/Source/shotwell/src/Printing.vala"
	photo_aspect_ratio = _tmp5_;
#line 1059 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = canvas_width;
#line 1059 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = canvas_height;
#line 1059 "/home/jens/Source/shotwell/src/Printing.vala"
	canvas_aspect_ratio = ((gdouble) _tmp6_) / _tmp7_;
#line 1061 "/home/jens/Source/shotwell/src/Printing.vala"
	target_width = 0.0;
#line 1062 "/home/jens/Source/shotwell/src/Printing.vala"
	target_height = 0.0;
#line 1063 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = job;
#line 1063 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = print_job_get_local_settings (_tmp8_);
#line 1063 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = _tmp9_;
#line 1063 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp11_ = print_settings_get_content_ppi (_tmp10_);
#line 1063 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp12_ = (gdouble) _tmp11_;
#line 1063 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp10_);
#line 1063 "/home/jens/Source/shotwell/src/Printing.vala"
	dpi = _tmp12_;
#line 1065 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp13_ = crop;
#line 1065 "/home/jens/Source/shotwell/src/Printing.vala"
	if (!_tmp13_) {
#line 7805 "Printing.c"
		gdouble _tmp14_ = 0.0;
		gdouble _tmp15_ = 0.0;
		gdouble _tmp22_ = 0.0;
		gdouble _tmp23_ = 0.0;
		gdouble _tmp24_ = 0.0;
		gdouble _tmp25_ = 0.0;
		gdouble _tmp26_ = 0.0;
		gdouble _tmp27_ = 0.0;
#line 1066 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp14_ = canvas_aspect_ratio;
#line 1066 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp15_ = photo_aspect_ratio;
#line 1066 "/home/jens/Source/shotwell/src/Printing.vala"
		if (_tmp14_ < _tmp15_) {
#line 7820 "Printing.c"
			gdouble _tmp16_ = 0.0;
			gdouble _tmp17_ = 0.0;
			gdouble _tmp18_ = 0.0;
#line 1067 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp16_ = canvas_width;
#line 1067 "/home/jens/Source/shotwell/src/Printing.vala"
			target_width = _tmp16_;
#line 1068 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp17_ = target_width;
#line 1068 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp18_ = photo_aspect_ratio;
#line 1068 "/home/jens/Source/shotwell/src/Printing.vala"
			target_height = _tmp17_ * (1.0 / _tmp18_);
#line 7834 "Printing.c"
		} else {
			gdouble _tmp19_ = 0.0;
			gdouble _tmp20_ = 0.0;
			gdouble _tmp21_ = 0.0;
#line 1070 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp19_ = canvas_height;
#line 1070 "/home/jens/Source/shotwell/src/Printing.vala"
			target_height = _tmp19_;
#line 1071 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp20_ = target_height;
#line 1071 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp21_ = photo_aspect_ratio;
#line 1071 "/home/jens/Source/shotwell/src/Printing.vala"
			target_width = _tmp20_ * _tmp21_;
#line 7849 "Printing.c"
		}
#line 1073 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp22_ = x;
#line 1073 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp23_ = canvas_width;
#line 1073 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp24_ = target_width;
#line 1073 "/home/jens/Source/shotwell/src/Printing.vala"
		x = _tmp22_ + ((_tmp23_ - _tmp24_) / 2.0);
#line 1074 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp25_ = y;
#line 1074 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp26_ = canvas_height;
#line 1074 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp27_ = target_height;
#line 1074 "/home/jens/Source/shotwell/src/Printing.vala"
		y = _tmp25_ + ((_tmp26_ - _tmp27_) / 2.0);
#line 7867 "Printing.c"
	}
#line 1077 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp28_ = dpi;
#line 1077 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp29_ = x;
#line 1077 "/home/jens/Source/shotwell/src/Printing.vala"
	x_offset = _tmp28_ * _tmp29_;
#line 1078 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp30_ = dpi;
#line 1078 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp31_ = y;
#line 1078 "/home/jens/Source/shotwell/src/Printing.vala"
	y_offset = _tmp30_ * _tmp31_;
#line 1079 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp32_ = dc;
#line 1079 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_save (_tmp32_);
#line 1080 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp33_ = dc;
#line 1080 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp34_ = x_offset;
#line 1080 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp35_ = y_offset;
#line 1080 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_translate (_tmp33_, _tmp34_, _tmp35_);
#line 1082 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp36_ = dpi;
#line 1082 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp37_ = canvas_width;
#line 1082 "/home/jens/Source/shotwell/src/Printing.vala"
	w = (gint) (_tmp36_ * _tmp37_);
#line 1083 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp38_ = dpi;
#line 1083 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp39_ = canvas_height;
#line 1083 "/home/jens/Source/shotwell/src/Printing.vala"
	h = (gint) (_tmp38_ * _tmp39_);
#line 1084 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp40_ = w;
#line 1084 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp41_ = h;
#line 1084 "/home/jens/Source/shotwell/src/Printing.vala"
	dimensions_init (&viewport, _tmp40_, _tmp41_);
#line 7911 "Printing.c"
	{
		gboolean _tmp42_ = FALSE;
		gboolean _tmp43_ = FALSE;
		cairo_t* _tmp89_ = NULL;
#line 1087 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp43_ = crop;
#line 1087 "/home/jens/Source/shotwell/src/Printing.vala"
		if (_tmp43_) {
#line 7920 "Printing.c"
			gdouble _tmp44_ = 0.0;
			gdouble _tmp45_ = 0.0;
			gboolean _tmp46_ = FALSE;
#line 1087 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp44_ = canvas_aspect_ratio;
#line 1087 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp45_ = photo_aspect_ratio;
#line 1087 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp46_ = print_manager_are_approximately_equal (self, _tmp44_, _tmp45_);
#line 1087 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp42_ = !_tmp46_;
#line 7932 "Printing.c"
		} else {
#line 1087 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp42_ = FALSE;
#line 7936 "Printing.c"
		}
#line 1087 "/home/jens/Source/shotwell/src/Printing.vala"
		if (_tmp42_) {
#line 7940 "Printing.c"
			Scaling pixbuf_scaling = {0};
			Dimensions _tmp47_ = {0};
			Scaling _tmp48_ = {0};
			GdkPixbuf* photo_pixbuf = NULL;
			Photo* _tmp49_ = NULL;
			Scaling _tmp50_ = {0};
			GdkPixbuf* _tmp51_ = NULL;
			Dimensions scaled_photo_dimensions = {0};
			GdkPixbuf* _tmp52_ = NULL;
			Dimensions _tmp53_ = {0};
			gint shave_vertical = 0;
			gint shave_horizontal = 0;
			gdouble _tmp54_ = 0.0;
			gdouble _tmp55_ = 0.0;
			GdkPixbuf* shaved_pixbuf = NULL;
			GdkPixbuf* _tmp66_ = NULL;
			gint _tmp67_ = 0;
			gint _tmp68_ = 0;
			Dimensions _tmp69_ = {0};
			gint _tmp70_ = 0;
			gint _tmp71_ = 0;
			Dimensions _tmp72_ = {0};
			gint _tmp73_ = 0;
			gint _tmp74_ = 0;
			GdkPixbuf* _tmp75_ = NULL;
			GdkPixbuf* _tmp76_ = NULL;
			GdkPixbuf* _tmp77_ = NULL;
			cairo_t* _tmp78_ = NULL;
			GdkPixbuf* _tmp79_ = NULL;
#line 1088 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp47_ = viewport;
#line 1088 "/home/jens/Source/shotwell/src/Printing.vala"
			scaling_to_fill_viewport (&_tmp47_, &_tmp48_);
#line 1088 "/home/jens/Source/shotwell/src/Printing.vala"
			pixbuf_scaling = _tmp48_;
#line 1089 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp49_ = photo;
#line 1089 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp50_ = pixbuf_scaling;
#line 1089 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp51_ = photo_source_get_pixbuf (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, TYPE_PHOTO_SOURCE, PhotoSource), &_tmp50_, &_inner_error_);
#line 1089 "/home/jens/Source/shotwell/src/Printing.vala"
			photo_pixbuf = _tmp51_;
#line 1089 "/home/jens/Source/shotwell/src/Printing.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7986 "Printing.c"
				goto __catch468_g_error;
			}
#line 1090 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp52_ = photo_pixbuf;
#line 1090 "/home/jens/Source/shotwell/src/Printing.vala"
			dimensions_for_pixbuf (_tmp52_, &_tmp53_);
#line 1090 "/home/jens/Source/shotwell/src/Printing.vala"
			scaled_photo_dimensions = _tmp53_;
#line 1091 "/home/jens/Source/shotwell/src/Printing.vala"
			shave_vertical = 0;
#line 1092 "/home/jens/Source/shotwell/src/Printing.vala"
			shave_horizontal = 0;
#line 1093 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp54_ = canvas_aspect_ratio;
#line 1093 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp55_ = photo_aspect_ratio;
#line 1093 "/home/jens/Source/shotwell/src/Printing.vala"
			if (_tmp54_ < _tmp55_) {
#line 8005 "Printing.c"
				Dimensions _tmp56_ = {0};
				gint _tmp57_ = 0;
				Dimensions _tmp58_ = {0};
				gint _tmp59_ = 0;
				gdouble _tmp60_ = 0.0;
#line 1094 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp56_ = scaled_photo_dimensions;
#line 1094 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp57_ = _tmp56_.width;
#line 1094 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp58_ = scaled_photo_dimensions;
#line 1094 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp59_ = _tmp58_.height;
#line 1094 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp60_ = canvas_aspect_ratio;
#line 1094 "/home/jens/Source/shotwell/src/Printing.vala"
				shave_vertical = (gint) ((_tmp57_ - (_tmp59_ * _tmp60_)) / 2.0);
#line 8023 "Printing.c"
			} else {
				Dimensions _tmp61_ = {0};
				gint _tmp62_ = 0;
				Dimensions _tmp63_ = {0};
				gint _tmp64_ = 0;
				gdouble _tmp65_ = 0.0;
#line 1096 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp61_ = scaled_photo_dimensions;
#line 1096 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp62_ = _tmp61_.height;
#line 1096 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp63_ = scaled_photo_dimensions;
#line 1096 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp64_ = _tmp63_.width;
#line 1096 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp65_ = canvas_aspect_ratio;
#line 1096 "/home/jens/Source/shotwell/src/Printing.vala"
				shave_horizontal = (gint) ((_tmp62_ - (_tmp64_ * (1.0 / _tmp65_))) / 2.0);
#line 8042 "Printing.c"
			}
#line 1098 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp66_ = photo_pixbuf;
#line 1098 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp67_ = shave_vertical;
#line 1098 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp68_ = shave_horizontal;
#line 1098 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp69_ = scaled_photo_dimensions;
#line 1098 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp70_ = _tmp69_.width;
#line 1098 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp71_ = shave_vertical;
#line 1098 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp72_ = scaled_photo_dimensions;
#line 1098 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp73_ = _tmp72_.height;
#line 1098 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp74_ = shave_horizontal;
#line 1098 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp75_ = gdk_pixbuf_new_subpixbuf (_tmp66_, _tmp67_, _tmp68_, _tmp70_ - (2 * _tmp71_), _tmp73_ - (2 * _tmp74_));
#line 1098 "/home/jens/Source/shotwell/src/Printing.vala"
			shaved_pixbuf = _tmp75_;
#line 1100 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp76_ = shaved_pixbuf;
#line 1100 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp77_ = scaling_perform_on_pixbuf (&pixbuf_scaling, _tmp76_, GDK_INTERP_HYPER, TRUE);
#line 1100 "/home/jens/Source/shotwell/src/Printing.vala"
			_g_object_unref0 (photo_pixbuf);
#line 1100 "/home/jens/Source/shotwell/src/Printing.vala"
			photo_pixbuf = _tmp77_;
#line 1101 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp78_ = dc;
#line 1101 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp79_ = photo_pixbuf;
#line 1101 "/home/jens/Source/shotwell/src/Printing.vala"
			gdk_cairo_set_source_pixbuf (_tmp78_, _tmp79_, 0.0, 0.0);
#line 1087 "/home/jens/Source/shotwell/src/Printing.vala"
			_g_object_unref0 (shaved_pixbuf);
#line 1087 "/home/jens/Source/shotwell/src/Printing.vala"
			_g_object_unref0 (photo_pixbuf);
#line 8084 "Printing.c"
		} else {
			Scaling pixbuf_scaling = {0};
			Dimensions _tmp80_ = {0};
			Scaling _tmp81_ = {0};
			GdkPixbuf* photo_pixbuf = NULL;
			Photo* _tmp82_ = NULL;
			Scaling _tmp83_ = {0};
			GdkPixbuf* _tmp84_ = NULL;
			GdkPixbuf* _tmp85_ = NULL;
			GdkPixbuf* _tmp86_ = NULL;
			cairo_t* _tmp87_ = NULL;
			GdkPixbuf* _tmp88_ = NULL;
#line 1103 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp80_ = viewport;
#line 1103 "/home/jens/Source/shotwell/src/Printing.vala"
			scaling_for_viewport (&_tmp80_, TRUE, &_tmp81_);
#line 1103 "/home/jens/Source/shotwell/src/Printing.vala"
			pixbuf_scaling = _tmp81_;
#line 1104 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp82_ = photo;
#line 1104 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp83_ = pixbuf_scaling;
#line 1104 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp84_ = photo_source_get_pixbuf (G_TYPE_CHECK_INSTANCE_CAST (_tmp82_, TYPE_PHOTO_SOURCE, PhotoSource), &_tmp83_, &_inner_error_);
#line 1104 "/home/jens/Source/shotwell/src/Printing.vala"
			photo_pixbuf = _tmp84_;
#line 1104 "/home/jens/Source/shotwell/src/Printing.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8113 "Printing.c"
				goto __catch468_g_error;
			}
#line 1105 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp85_ = photo_pixbuf;
#line 1105 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp86_ = scaling_perform_on_pixbuf (&pixbuf_scaling, _tmp85_, GDK_INTERP_HYPER, TRUE);
#line 1105 "/home/jens/Source/shotwell/src/Printing.vala"
			_g_object_unref0 (photo_pixbuf);
#line 1105 "/home/jens/Source/shotwell/src/Printing.vala"
			photo_pixbuf = _tmp86_;
#line 1106 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp87_ = dc;
#line 1106 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp88_ = photo_pixbuf;
#line 1106 "/home/jens/Source/shotwell/src/Printing.vala"
			gdk_cairo_set_source_pixbuf (_tmp87_, _tmp88_, 0.0, 0.0);
#line 1087 "/home/jens/Source/shotwell/src/Printing.vala"
			_g_object_unref0 (photo_pixbuf);
#line 8132 "Printing.c"
		}
#line 1108 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp89_ = dc;
#line 1108 "/home/jens/Source/shotwell/src/Printing.vala"
		cairo_paint (_tmp89_);
#line 8138 "Printing.c"
	}
	goto __finally468;
	__catch468_g_error:
	{
		GError* e = NULL;
		PrintJob* _tmp90_ = NULL;
		const gchar* _tmp91_ = NULL;
		GError* _tmp92_ = NULL;
		const gchar* _tmp93_ = NULL;
		gchar* _tmp94_ = NULL;
		gchar* _tmp95_ = NULL;
#line 1086 "/home/jens/Source/shotwell/src/Printing.vala"
		e = _inner_error_;
#line 1086 "/home/jens/Source/shotwell/src/Printing.vala"
		_inner_error_ = NULL;
#line 1111 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp90_ = job;
#line 1111 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_print_operation_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, gtk_print_operation_get_type (), GtkPrintOperation));
#line 1112 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp91_ = _ ("Unable to print photo:\n\n%s");
#line 1112 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp92_ = e;
#line 1112 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp93_ = _tmp92_->message;
#line 1112 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp94_ = g_strdup_printf (_tmp91_, _tmp93_);
#line 1112 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp95_ = _tmp94_;
#line 1112 "/home/jens/Source/shotwell/src/Printing.vala"
		app_window_error_message (_tmp95_, NULL);
#line 1112 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_free0 (_tmp95_);
#line 1086 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_error_free0 (e);
#line 8174 "Printing.c"
	}
	__finally468:
#line 1086 "/home/jens/Source/shotwell/src/Printing.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1086 "/home/jens/Source/shotwell/src/Printing.vala"
		_cairo_destroy0 (dc);
#line 1086 "/home/jens/Source/shotwell/src/Printing.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1086 "/home/jens/Source/shotwell/src/Printing.vala"
		g_clear_error (&_inner_error_);
#line 1086 "/home/jens/Source/shotwell/src/Printing.vala"
		return;
#line 8187 "Printing.c"
	}
#line 1114 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp96_ = dc;
#line 1114 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_restore (_tmp96_);
#line 1055 "/home/jens/Source/shotwell/src/Printing.vala"
	_cairo_destroy0 (dc);
#line 8195 "Printing.c"
}


static void _vala_PangoFontDescription_free (PangoFontDescription* self) {
#line 1117 "/home/jens/Source/shotwell/src/Printing.vala"
	g_boxed_free (pango_font_description_get_type (), self);
#line 8202 "Printing.c"
}


static void print_manager_add_title_to_canvas (PrintManager* self, gdouble x, gdouble y, const gchar* title, PrintJob* job, GtkPrintContext* job_context) {
	cairo_t* dc = NULL;
	GtkPrintContext* _tmp0_ = NULL;
	cairo_t* _tmp1_ = NULL;
	cairo_t* _tmp2_ = NULL;
	gdouble dpi = 0.0;
	PrintJob* _tmp3_ = NULL;
	PrintSettings* _tmp4_ = NULL;
	PrintSettings* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gdouble _tmp7_ = 0.0;
	PangoFontDescription* title_font_description = NULL;
	PrintJob* _tmp8_ = NULL;
	PrintSettings* _tmp9_ = NULL;
	PrintSettings* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	PangoFontDescription* _tmp13_ = NULL;
	PangoFontDescription* _tmp14_ = NULL;
	PangoLayout* title_layout = NULL;
	PangoLayout* _tmp15_ = NULL;
	PangoContext* context = NULL;
	PangoContext* _tmp16_ = NULL;
	PangoContext* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gint title_width = 0;
	gint title_height = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gdouble tx = 0.0;
	gdouble _tmp21_ = 0.0;
	gdouble ty = 0.0;
	gdouble _tmp22_ = 0.0;
#line 1117 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_MANAGER (self));
#line 1117 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (title != NULL);
#line 1117 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_JOB (job));
#line 1117 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GTK_IS_PRINT_CONTEXT (job_context));
#line 1118 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = job_context;
#line 1118 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_print_context_get_cairo_context (_tmp0_);
#line 1118 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = _cairo_reference0 (_tmp1_);
#line 1118 "/home/jens/Source/shotwell/src/Printing.vala"
	dc = _tmp2_;
#line 1119 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = job;
#line 1119 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = print_job_get_local_settings (_tmp3_);
#line 1119 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = _tmp4_;
#line 1119 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = print_settings_get_content_ppi (_tmp5_);
#line 1119 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = (gdouble) _tmp6_;
#line 1119 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp5_);
#line 1119 "/home/jens/Source/shotwell/src/Printing.vala"
	dpi = _tmp7_;
#line 1120 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = job;
#line 1120 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = print_job_get_local_settings (_tmp8_);
#line 1120 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = _tmp9_;
#line 1120 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp11_ = print_settings_get_print_titles_font (_tmp10_);
#line 1120 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp12_ = _tmp11_;
#line 1120 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp13_ = pango_font_description_from_string (_tmp12_);
#line 1120 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_ = _tmp13_;
#line 1120 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp12_);
#line 1120 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp10_);
#line 1120 "/home/jens/Source/shotwell/src/Printing.vala"
	title_font_description = _tmp14_;
#line 1121 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp15_ = pango_cairo_create_layout (dc);
#line 1121 "/home/jens/Source/shotwell/src/Printing.vala"
	title_layout = _tmp15_;
#line 1122 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp16_ = pango_layout_get_context (title_layout);
#line 1122 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp17_ = _g_object_ref0 (_tmp16_);
#line 1122 "/home/jens/Source/shotwell/src/Printing.vala"
	context = _tmp17_;
#line 1123 "/home/jens/Source/shotwell/src/Printing.vala"
	pango_cairo_context_set_resolution (context, dpi);
#line 1124 "/home/jens/Source/shotwell/src/Printing.vala"
	pango_layout_set_font_description (title_layout, title_font_description);
#line 1125 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp18_ = title;
#line 1125 "/home/jens/Source/shotwell/src/Printing.vala"
	pango_layout_set_text (title_layout, _tmp18_, -1);
#line 1127 "/home/jens/Source/shotwell/src/Printing.vala"
	pango_layout_get_pixel_size (title_layout, &_tmp19_, &_tmp20_);
#line 1127 "/home/jens/Source/shotwell/src/Printing.vala"
	title_width = _tmp19_;
#line 1127 "/home/jens/Source/shotwell/src/Printing.vala"
	title_height = _tmp20_;
#line 1128 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp21_ = x;
#line 1128 "/home/jens/Source/shotwell/src/Printing.vala"
	tx = (dpi * _tmp21_) - (title_width / 2);
#line 1129 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp22_ = y;
#line 1129 "/home/jens/Source/shotwell/src/Printing.vala"
	ty = (dpi * _tmp22_) - title_height;
#line 1132 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_rectangle (dc, tx - 10, ty + 2, (gdouble) (title_width + 20), (gdouble) title_height);
#line 1133 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_set_source_rgba (dc, (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
#line 1134 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_set_line_width (dc, (gdouble) 2);
#line 1135 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_stroke_preserve (dc);
#line 1136 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_set_source_rgba (dc, (gdouble) 1, (gdouble) 1, (gdouble) 1, 0.5);
#line 1137 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_fill (dc);
#line 1138 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_set_source_rgba (dc, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
#line 1140 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_move_to (dc, tx, ty + 2);
#line 1141 "/home/jens/Source/shotwell/src/Printing.vala"
	pango_cairo_show_layout (dc, title_layout);
#line 1117 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (context);
#line 1117 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (title_layout);
#line 1117 "/home/jens/Source/shotwell/src/Printing.vala"
	__vala_PangoFontDescription_free0 (title_font_description);
#line 1117 "/home/jens/Source/shotwell/src/Printing.vala"
	_cairo_destroy0 (dc);
#line 8347 "Printing.c"
}


static gboolean print_manager_are_approximately_equal (PrintManager* self, gdouble val1, gdouble val2) {
	gboolean result = FALSE;
	gdouble accept_err = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
#line 1144 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_MANAGER (self), FALSE);
#line 1145 "/home/jens/Source/shotwell/src/Printing.vala"
	accept_err = 0.005;
#line 1146 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = val1;
#line 1146 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = val2;
#line 1146 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = fabs (_tmp0_ - _tmp1_);
#line 1146 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp2_ <= accept_err;
#line 1146 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 8371 "Printing.c"
}


PrintSettings* print_manager_get_global_settings (PrintManager* self) {
	PrintSettings* result = NULL;
	PrintSettings* _tmp0_ = NULL;
	PrintSettings* _tmp1_ = NULL;
#line 1149 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_MANAGER (self), NULL);
#line 1150 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->settings;
#line 1150 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _print_settings_ref0 (_tmp0_);
#line 1150 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 1150 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 8389 "Printing.c"
}


void print_manager_set_global_settings (PrintManager* self, PrintSettings* settings) {
	PrintSettings* _tmp0_ = NULL;
	PrintSettings* _tmp1_ = NULL;
	PrintSettings* _tmp2_ = NULL;
#line 1153 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_MANAGER (self));
#line 1153 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (settings));
#line 1154 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = settings;
#line 1154 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _print_settings_ref0 (_tmp0_);
#line 1154 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (self->priv->settings);
#line 1154 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->settings = _tmp1_;
#line 1155 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = settings;
#line 1155 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_save (_tmp2_);
#line 8413 "Printing.c"
}


static void value_print_manager_init (GValue* value) {
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
	value->data[0].v_pointer = NULL;
#line 8420 "Printing.c"
}


static void value_print_manager_free_value (GValue* value) {
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
	if (value->data[0].v_pointer) {
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
		print_manager_unref (value->data[0].v_pointer);
#line 8429 "Printing.c"
	}
}


static void value_print_manager_copy_value (const GValue* src_value, GValue* dest_value) {
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
	if (src_value->data[0].v_pointer) {
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
		dest_value->data[0].v_pointer = print_manager_ref (src_value->data[0].v_pointer);
#line 8439 "Printing.c"
	} else {
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
		dest_value->data[0].v_pointer = NULL;
#line 8443 "Printing.c"
	}
}


static gpointer value_print_manager_peek_pointer (const GValue* value) {
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
	return value->data[0].v_pointer;
#line 8451 "Printing.c"
}


static gchar* value_print_manager_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
	if (collect_values[0].v_pointer) {
#line 8458 "Printing.c"
		PrintManager* object;
		object = collect_values[0].v_pointer;
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
		if (object->parent_instance.g_class == NULL) {
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 8465 "Printing.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 8469 "Printing.c"
		}
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = print_manager_ref (object);
#line 8473 "Printing.c"
	} else {
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = NULL;
#line 8477 "Printing.c"
	}
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
	return NULL;
#line 8481 "Printing.c"
}


static gchar* value_print_manager_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PrintManager** object_p;
	object_p = collect_values[0].v_pointer;
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
	if (!object_p) {
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 8492 "Printing.c"
	}
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
	if (!value->data[0].v_pointer) {
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
		*object_p = NULL;
#line 8498 "Printing.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
		*object_p = value->data[0].v_pointer;
#line 8502 "Printing.c"
	} else {
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
		*object_p = print_manager_ref (value->data[0].v_pointer);
#line 8506 "Printing.c"
	}
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
	return NULL;
#line 8510 "Printing.c"
}


GParamSpec* param_spec_print_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPrintManager* spec;
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PRINT_MANAGER), NULL);
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
	return G_PARAM_SPEC (spec);
#line 8524 "Printing.c"
}


gpointer value_get_print_manager (const GValue* value) {
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PRINT_MANAGER), NULL);
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
	return value->data[0].v_pointer;
#line 8533 "Printing.c"
}


void value_set_print_manager (GValue* value, gpointer v_object) {
	PrintManager* old;
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PRINT_MANAGER));
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
	old = value->data[0].v_pointer;
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
	if (v_object) {
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PRINT_MANAGER));
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = v_object;
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
		print_manager_ref (value->data[0].v_pointer);
#line 8553 "Printing.c"
	} else {
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = NULL;
#line 8557 "Printing.c"
	}
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
	if (old) {
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
		print_manager_unref (old);
#line 8563 "Printing.c"
	}
}


void value_take_print_manager (GValue* value, gpointer v_object) {
	PrintManager* old;
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PRINT_MANAGER));
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
	old = value->data[0].v_pointer;
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
	if (v_object) {
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PRINT_MANAGER));
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = v_object;
#line 8582 "Printing.c"
	} else {
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = NULL;
#line 8586 "Printing.c"
	}
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
	if (old) {
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
		print_manager_unref (old);
#line 8592 "Printing.c"
	}
}


static void print_manager_class_init (PrintManagerClass * klass) {
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
	print_manager_parent_class = g_type_class_peek_parent (klass);
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
	((PrintManagerClass *) klass)->finalize = print_manager_finalize;
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
	g_type_class_add_private (klass, sizeof (PrintManagerPrivate));
#line 8604 "Printing.c"
}


static void print_manager_instance_init (PrintManager * self) {
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv = PRINT_MANAGER_GET_PRIVATE (self);
#line 807 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->progress_dialog = NULL;
#line 808 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->cancellable = NULL;
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
	self->ref_count = 1;
#line 8617 "Printing.c"
}


static void print_manager_finalize (PrintManager* obj) {
	PrintManager * self;
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PRINT_MANAGER, PrintManager);
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_handlers_destroy (self);
#line 804 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (self->priv->settings);
#line 805 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->user_page_setup);
#line 806 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->custom_tab);
#line 807 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->progress_dialog);
#line 808 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 8637 "Printing.c"
}


GType print_manager_get_type (void) {
	static volatile gsize print_manager_type_id__volatile = 0;
	if (g_once_init_enter (&print_manager_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_print_manager_init, value_print_manager_free_value, value_print_manager_copy_value, value_print_manager_peek_pointer, "p", value_print_manager_collect_value, "p", value_print_manager_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PrintManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) print_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrintManager), 0, (GInstanceInitFunc) print_manager_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType print_manager_type_id;
		print_manager_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PrintManager", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&print_manager_type_id__volatile, print_manager_type_id);
	}
	return print_manager_type_id__volatile;
}


gpointer print_manager_ref (gpointer instance) {
	PrintManager* self;
	self = instance;
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
	g_atomic_int_inc (&self->ref_count);
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
	return instance;
#line 8662 "Printing.c"
}


void print_manager_unref (gpointer instance) {
	PrintManager* self;
	self = instance;
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
		PRINT_MANAGER_GET_CLASS (self)->finalize (self);
#line 799 "/home/jens/Source/shotwell/src/Printing.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 8675 "Printing.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



