/* PhotoFileFormat.c generated by valac 0.34.2, the Vala compiler
 * generated from PhotoFileFormat.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gphoto2/gphoto2-file.h>
#include <gobject/gvaluecollector.h>


#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PHOTO_FILE_FORMAT_DRIVER (photo_file_format_driver_get_type ())
#define PHOTO_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_FORMAT_DRIVER, PhotoFileFormatDriver))
#define PHOTO_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_FORMAT_DRIVER, PhotoFileFormatDriverClass))
#define IS_PHOTO_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_FORMAT_DRIVER))
#define IS_PHOTO_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_FORMAT_DRIVER))
#define PHOTO_FILE_FORMAT_DRIVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_FORMAT_DRIVER, PhotoFileFormatDriverClass))

typedef struct _PhotoFileFormatDriver PhotoFileFormatDriver;
typedef struct _PhotoFileFormatDriverClass PhotoFileFormatDriverClass;

#define TYPE_PHOTO_FILE_FORMAT_PROPERTIES (photo_file_format_properties_get_type ())
#define PHOTO_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatProperties))
#define PHOTO_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatPropertiesClass))
#define IS_PHOTO_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES))
#define IS_PHOTO_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_FORMAT_PROPERTIES))
#define PHOTO_FILE_FORMAT_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatPropertiesClass))

typedef struct _PhotoFileFormatProperties PhotoFileFormatProperties;
typedef struct _PhotoFileFormatPropertiesClass PhotoFileFormatPropertiesClass;
#define _photo_file_format_properties_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_properties_unref (var), NULL)))
#define _photo_file_format_driver_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_driver_unref (var), NULL)))

#define TYPE_JFIF_FILE_FORMAT_DRIVER (jfif_file_format_driver_get_type ())
#define JFIF_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_JFIF_FILE_FORMAT_DRIVER, JfifFileFormatDriver))
#define JFIF_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_JFIF_FILE_FORMAT_DRIVER, JfifFileFormatDriverClass))
#define IS_JFIF_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_JFIF_FILE_FORMAT_DRIVER))
#define IS_JFIF_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_JFIF_FILE_FORMAT_DRIVER))
#define JFIF_FILE_FORMAT_DRIVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_JFIF_FILE_FORMAT_DRIVER, JfifFileFormatDriverClass))

typedef struct _JfifFileFormatDriver JfifFileFormatDriver;
typedef struct _JfifFileFormatDriverClass JfifFileFormatDriverClass;

#define TYPE_RAW_FILE_FORMAT_DRIVER (raw_file_format_driver_get_type ())
#define RAW_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriver))
#define RAW_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriverClass))
#define IS_RAW_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RAW_FILE_FORMAT_DRIVER))
#define IS_RAW_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RAW_FILE_FORMAT_DRIVER))
#define RAW_FILE_FORMAT_DRIVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriverClass))

typedef struct _RawFileFormatDriver RawFileFormatDriver;
typedef struct _RawFileFormatDriverClass RawFileFormatDriverClass;

#define TYPE_PNG_FILE_FORMAT_DRIVER (png_file_format_driver_get_type ())
#define PNG_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PNG_FILE_FORMAT_DRIVER, PngFileFormatDriver))
#define PNG_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PNG_FILE_FORMAT_DRIVER, PngFileFormatDriverClass))
#define IS_PNG_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PNG_FILE_FORMAT_DRIVER))
#define IS_PNG_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PNG_FILE_FORMAT_DRIVER))
#define PNG_FILE_FORMAT_DRIVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PNG_FILE_FORMAT_DRIVER, PngFileFormatDriverClass))

typedef struct _PngFileFormatDriver PngFileFormatDriver;
typedef struct _PngFileFormatDriverClass PngFileFormatDriverClass;

#define PHOTOS_TYPE_TIFF_FILE_FORMAT_DRIVER (photos_tiff_file_format_driver_get_type ())
#define PHOTOS_TIFF_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTOS_TYPE_TIFF_FILE_FORMAT_DRIVER, PhotosTiffFileFormatDriver))
#define PHOTOS_TIFF_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTOS_TYPE_TIFF_FILE_FORMAT_DRIVER, PhotosTiffFileFormatDriverClass))
#define PHOTOS_IS_TIFF_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTOS_TYPE_TIFF_FILE_FORMAT_DRIVER))
#define PHOTOS_IS_TIFF_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTOS_TYPE_TIFF_FILE_FORMAT_DRIVER))
#define PHOTOS_TIFF_FILE_FORMAT_DRIVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTOS_TYPE_TIFF_FILE_FORMAT_DRIVER, PhotosTiffFileFormatDriverClass))

typedef struct _PhotosTiffFileFormatDriver PhotosTiffFileFormatDriver;
typedef struct _PhotosTiffFileFormatDriverClass PhotosTiffFileFormatDriverClass;

#define PHOTOS_TYPE_BMP_FILE_FORMAT_DRIVER (photos_bmp_file_format_driver_get_type ())
#define PHOTOS_BMP_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTOS_TYPE_BMP_FILE_FORMAT_DRIVER, PhotosBmpFileFormatDriver))
#define PHOTOS_BMP_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTOS_TYPE_BMP_FILE_FORMAT_DRIVER, PhotosBmpFileFormatDriverClass))
#define PHOTOS_IS_BMP_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTOS_TYPE_BMP_FILE_FORMAT_DRIVER))
#define PHOTOS_IS_BMP_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTOS_TYPE_BMP_FILE_FORMAT_DRIVER))
#define PHOTOS_BMP_FILE_FORMAT_DRIVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTOS_TYPE_BMP_FILE_FORMAT_DRIVER, PhotosBmpFileFormatDriverClass))

typedef struct _PhotosBmpFileFormatDriver PhotosBmpFileFormatDriver;
typedef struct _PhotosBmpFileFormatDriverClass PhotosBmpFileFormatDriverClass;

#define TYPE_PHOTO_FILE_ADAPTER (photo_file_adapter_get_type ())
#define PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter))
#define PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))
#define IS_PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_ADAPTER))
#define IS_PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_ADAPTER))
#define PHOTO_FILE_ADAPTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))

typedef struct _PhotoFileAdapter PhotoFileAdapter;
typedef struct _PhotoFileAdapterClass PhotoFileAdapterClass;

#define TYPE_PHOTO_FILE_READER (photo_file_reader_get_type ())
#define PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReader))
#define PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))
#define IS_PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_READER))
#define IS_PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_READER))
#define PHOTO_FILE_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))

typedef struct _PhotoFileReader PhotoFileReader;
typedef struct _PhotoFileReaderClass PhotoFileReaderClass;

#define TYPE_PHOTO_FILE_WRITER (photo_file_writer_get_type ())
#define PHOTO_FILE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_WRITER, PhotoFileWriter))
#define PHOTO_FILE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_WRITER, PhotoFileWriterClass))
#define IS_PHOTO_FILE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_WRITER))
#define IS_PHOTO_FILE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_WRITER))
#define PHOTO_FILE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_WRITER, PhotoFileWriterClass))

typedef struct _PhotoFileWriter PhotoFileWriter;
typedef struct _PhotoFileWriterClass PhotoFileWriterClass;
#define _photo_file_adapter_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_adapter_unref (var), NULL)))

#define TYPE_PHOTO_FILE_METADATA_WRITER (photo_file_metadata_writer_get_type ())
#define PHOTO_FILE_METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriter))
#define PHOTO_FILE_METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriterClass))
#define IS_PHOTO_FILE_METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_METADATA_WRITER))
#define IS_PHOTO_FILE_METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_METADATA_WRITER))
#define PHOTO_FILE_METADATA_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriterClass))

typedef struct _PhotoFileMetadataWriter PhotoFileMetadataWriter;
typedef struct _PhotoFileMetadataWriterClass PhotoFileMetadataWriterClass;

#define PHOTO_FILE_SNIFFER_TYPE_OPTIONS (photo_file_sniffer_options_get_type ())

#define TYPE_PHOTO_FILE_SNIFFER (photo_file_sniffer_get_type ())
#define PHOTO_FILE_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer))
#define PHOTO_FILE_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSnifferClass))
#define IS_PHOTO_FILE_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_SNIFFER))
#define IS_PHOTO_FILE_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_SNIFFER))
#define PHOTO_FILE_SNIFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSnifferClass))

typedef struct _PhotoFileSniffer PhotoFileSniffer;
typedef struct _PhotoFileSnifferClass PhotoFileSnifferClass;

#define TYPE_MEDIA_METADATA (media_metadata_get_type ())
#define MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_METADATA, MediaMetadata))
#define MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_METADATA, MediaMetadataClass))
#define IS_MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_METADATA))
#define IS_MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_METADATA))
#define MEDIA_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_METADATA, MediaMetadataClass))

typedef struct _MediaMetadata MediaMetadata;
typedef struct _MediaMetadataClass MediaMetadataClass;

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;
typedef struct _PhotoFileFormatDriverPrivate PhotoFileFormatDriverPrivate;
typedef struct _ParamSpecPhotoFileFormatDriver ParamSpecPhotoFileFormatDriver;

#define TYPE_PHOTO_FILE_FORMAT_FLAGS (photo_file_format_flags_get_type ())
typedef struct _PhotoFileFormatPropertiesPrivate PhotoFileFormatPropertiesPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecPhotoFileFormatProperties ParamSpecPhotoFileFormatProperties;

typedef enum  {
	PHOTO_FORMAT_ERROR_READ_ONLY
} PhotoFormatError;
#define PHOTO_FORMAT_ERROR photo_format_error_quark ()
typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

typedef gboolean (*PhotoFileFormatDataApplicableTest) (PhotoFileFormat format, void* user_data);
typedef enum  {
	PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL = 0x00000000,
	PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5 = 0x00000001
} PhotoFileSnifferOptions;

struct _PhotoFileFormatDriver {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileFormatDriverPrivate * priv;
};

struct _PhotoFileFormatDriverClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileFormatDriver *self);
	PhotoFileFormatProperties* (*get_properties) (PhotoFileFormatDriver* self);
	PhotoFileReader* (*create_reader) (PhotoFileFormatDriver* self, const gchar* filepath);
	PhotoMetadata* (*create_metadata) (PhotoFileFormatDriver* self);
	gboolean (*can_write_image) (PhotoFileFormatDriver* self);
	gboolean (*can_write_metadata) (PhotoFileFormatDriver* self);
	PhotoFileWriter* (*create_writer) (PhotoFileFormatDriver* self, const gchar* filepath);
	PhotoFileMetadataWriter* (*create_metadata_writer) (PhotoFileFormatDriver* self, const gchar* filepath);
	PhotoFileSniffer* (*create_sniffer) (PhotoFileFormatDriver* self, GFile* file, PhotoFileSnifferOptions options);
};

struct _ParamSpecPhotoFileFormatDriver {
	GParamSpec parent_instance;
};

typedef enum  {
	PHOTO_FILE_FORMAT_FLAGS_NONE = 0x00000000
} PhotoFileFormatFlags;

struct _PhotoFileFormatProperties {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileFormatPropertiesPrivate * priv;
};

struct _PhotoFileFormatPropertiesClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileFormatProperties *self);
	PhotoFileFormat (*get_file_format) (PhotoFileFormatProperties* self);
	PhotoFileFormatFlags (*get_flags) (PhotoFileFormatProperties* self);
	gboolean (*is_recognized_extension) (PhotoFileFormatProperties* self, const gchar* ext);
	gchar* (*get_default_extension) (PhotoFileFormatProperties* self);
	gchar** (*get_known_extensions) (PhotoFileFormatProperties* self, int* result_length1);
	gchar* (*get_default_mime_type) (PhotoFileFormatProperties* self);
	gchar** (*get_mime_types) (PhotoFileFormatProperties* self, int* result_length1);
	gchar* (*get_user_visible_name) (PhotoFileFormatProperties* self);
};

struct _ParamSpecPhotoFileFormatProperties {
	GParamSpec parent_instance;
};


extern PhotoFileFormat* photo_file_format_data_writeable;
extern gint photo_file_format_data_writeable_length1;
PhotoFileFormat* photo_file_format_data_writeable = NULL;
gint photo_file_format_data_writeable_length1 = 0;
static gint _photo_file_format_data_writeable_size_ = 0;
extern PhotoFileFormat* photo_file_format_data_image_writeable;
extern gint photo_file_format_data_image_writeable_length1;
PhotoFileFormat* photo_file_format_data_image_writeable = NULL;
gint photo_file_format_data_image_writeable_length1 = 0;
static gint _photo_file_format_data_image_writeable_size_ = 0;
extern PhotoFileFormat* photo_file_format_data_metadata_writeable;
extern gint photo_file_format_data_metadata_writeable_length1;
PhotoFileFormat* photo_file_format_data_metadata_writeable = NULL;
gint photo_file_format_data_metadata_writeable_length1 = 0;
static gint _photo_file_format_data_metadata_writeable_size_ = 0;
static gpointer photo_file_format_driver_parent_class = NULL;
static gpointer photo_file_format_properties_parent_class = NULL;

GQuark photo_format_error_quark (void);
GType photo_file_format_get_type (void) G_GNUC_CONST;
PhotoFileFormat* photo_file_format_data_find_applicable (PhotoFileFormatDataApplicableTest test, void* test_target, int* result_length1);
PhotoFileFormat* photo_file_format_get_supported (int* result_length1);
static void _vala_array_add43 (PhotoFileFormat** array, int* length, int* size, PhotoFileFormat value);
PhotoFileFormat* photo_file_format_data_get_writeable (int* result_length1);
static gboolean ___lambda4_ (PhotoFileFormat format);
gboolean photo_file_format_can_write (PhotoFileFormat self);
static gboolean ____lambda4__photo_file_format_data_applicable_test (PhotoFileFormat format, gpointer self);
static PhotoFileFormat* _vala_array_dup1 (PhotoFileFormat* self, int length);
PhotoFileFormat* photo_file_format_data_get_image_writeable (int* result_length1);
static gboolean ___lambda22_ (PhotoFileFormat format);
gboolean photo_file_format_can_write_image (PhotoFileFormat self);
static gboolean ____lambda22__photo_file_format_data_applicable_test (PhotoFileFormat format, gpointer self);
static PhotoFileFormat* _vala_array_dup2 (PhotoFileFormat* self, int length);
PhotoFileFormat* photo_file_format_data_get_metadata_writeable (int* result_length1);
static gboolean ___lambda23_ (PhotoFileFormat format);
gboolean photo_file_format_can_write_metadata (PhotoFileFormat self);
static gboolean ____lambda23__photo_file_format_data_applicable_test (PhotoFileFormat format, gpointer self);
static PhotoFileFormat* _vala_array_dup3 (PhotoFileFormat* self, int length);
PhotoFileFormat* photo_file_format_get_writeable (int* result_length1);
PhotoFileFormat* photo_file_format_get_image_writeable (int* result_length1);
PhotoFileFormat* photo_file_format_get_metadata_writeable (int* result_length1);
PhotoFileFormat photo_file_format_get_by_basename_extension (const gchar* basename);
void disassemble_filename (const gchar* basename, gchar** name, gchar** ext);
gboolean is_string_empty (const gchar* s);
gpointer photo_file_format_driver_ref (gpointer instance);
void photo_file_format_driver_unref (gpointer instance);
GParamSpec* param_spec_photo_file_format_driver (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_file_format_driver (GValue* value, gpointer v_object);
void value_take_photo_file_format_driver (GValue* value, gpointer v_object);
gpointer value_get_photo_file_format_driver (const GValue* value);
GType photo_file_format_driver_get_type (void) G_GNUC_CONST;
static PhotoFileFormatDriver* photo_file_format_get_driver (PhotoFileFormat self);
gpointer photo_file_format_properties_ref (gpointer instance);
void photo_file_format_properties_unref (gpointer instance);
GParamSpec* param_spec_photo_file_format_properties (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_file_format_properties (GValue* value, gpointer v_object);
void value_take_photo_file_format_properties (GValue* value, gpointer v_object);
gpointer value_get_photo_file_format_properties (const GValue* value);
GType photo_file_format_properties_get_type (void) G_GNUC_CONST;
PhotoFileFormatProperties* photo_file_format_driver_get_properties (PhotoFileFormatDriver* self);
gboolean photo_file_format_properties_is_recognized_extension (PhotoFileFormatProperties* self, const gchar* ext);
gboolean photo_file_format_is_file_supported (GFile* file);
gboolean photo_file_format_is_basename_supported (const gchar* basename);
PhotoFileFormat photo_file_format_get_system_default_format (void);
PhotoFileFormat photo_file_format_get_by_file_extension (GFile* file);
gint photo_file_format_serialize (PhotoFileFormat self);
PhotoFileFormat photo_file_format_unserialize (gint value);
PhotoFileFormat photo_file_format_from_gphoto_type (const gchar* type);
PhotoFileFormat photo_file_format_from_pixbuf_name (const gchar* name);
void photo_file_format_init (PhotoFileFormat self);
void jfif_file_format_driver_init (void);
void raw_file_format_driver_init (void);
void png_file_format_driver_init (void);
void photos_tiff_file_format_driver_init (void);
void photos_bmp_file_format_driver_init (void);
const gchar* photo_file_format_to_string (PhotoFileFormat self);
GType jfif_file_format_driver_get_type (void) G_GNUC_CONST;
JfifFileFormatDriver* jfif_file_format_driver_get_instance (void);
GType raw_file_format_driver_get_type (void) G_GNUC_CONST;
RawFileFormatDriver* raw_file_format_driver_get_instance (void);
GType png_file_format_driver_get_type (void) G_GNUC_CONST;
PngFileFormatDriver* png_file_format_driver_get_instance (void);
GType photos_tiff_file_format_driver_get_type (void) G_GNUC_CONST;
PhotosTiffFileFormatDriver* photos_tiff_file_format_driver_get_instance (void);
GType photos_bmp_file_format_driver_get_type (void) G_GNUC_CONST;
PhotosBmpFileFormatDriver* photos_bmp_file_format_driver_get_instance (void);
PhotoFileFormatProperties* photo_file_format_get_properties (PhotoFileFormat self);
gchar* photo_file_format_get_default_basename (PhotoFileFormat self, const gchar* name);
gchar* photo_file_format_properties_get_default_extension (PhotoFileFormatProperties* self);
gpointer photo_file_adapter_ref (gpointer instance);
void photo_file_adapter_unref (gpointer instance);
GParamSpec* param_spec_photo_file_adapter (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_file_adapter (GValue* value, gpointer v_object);
void value_take_photo_file_adapter (GValue* value, gpointer v_object);
gpointer value_get_photo_file_adapter (const GValue* value);
GType photo_file_adapter_get_type (void) G_GNUC_CONST;
GType photo_file_reader_get_type (void) G_GNUC_CONST;
PhotoFileReader* photo_file_format_create_reader (PhotoFileFormat self, const gchar* filepath);
PhotoFileReader* photo_file_format_driver_create_reader (PhotoFileFormatDriver* self, const gchar* filepath);
gboolean photo_file_format_driver_can_write_image (PhotoFileFormatDriver* self);
gboolean photo_file_format_driver_can_write_metadata (PhotoFileFormatDriver* self);
GType photo_file_writer_get_type (void) G_GNUC_CONST;
PhotoFileWriter* photo_file_format_create_writer (PhotoFileFormat self, const gchar* filepath, GError** error);
PhotoFileWriter* photo_file_format_driver_create_writer (PhotoFileFormatDriver* self, const gchar* filepath);
GType photo_file_metadata_writer_get_type (void) G_GNUC_CONST;
PhotoFileMetadataWriter* photo_file_format_create_metadata_writer (PhotoFileFormat self, const gchar* filepath, GError** error);
PhotoFileMetadataWriter* photo_file_format_driver_create_metadata_writer (PhotoFileFormatDriver* self, const gchar* filepath);
GType photo_file_sniffer_options_get_type (void) G_GNUC_CONST;
gpointer photo_file_sniffer_ref (gpointer instance);
void photo_file_sniffer_unref (gpointer instance);
GParamSpec* param_spec_photo_file_sniffer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_file_sniffer (GValue* value, gpointer v_object);
void value_take_photo_file_sniffer (GValue* value, gpointer v_object);
gpointer value_get_photo_file_sniffer (const GValue* value);
GType photo_file_sniffer_get_type (void) G_GNUC_CONST;
PhotoFileSniffer* photo_file_format_create_sniffer (PhotoFileFormat self, GFile* file, PhotoFileSnifferOptions options);
PhotoFileSniffer* photo_file_format_driver_create_sniffer (PhotoFileFormatDriver* self, GFile* file, PhotoFileSnifferOptions options);
gpointer media_metadata_ref (gpointer instance);
void media_metadata_unref (gpointer instance);
GParamSpec* param_spec_media_metadata (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_media_metadata (GValue* value, gpointer v_object);
void value_take_media_metadata (GValue* value, gpointer v_object);
gpointer value_get_media_metadata (const GValue* value);
GType media_metadata_get_type (void) G_GNUC_CONST;
GType photo_metadata_get_type (void) G_GNUC_CONST;
PhotoMetadata* photo_file_format_create_metadata (PhotoFileFormat self);
PhotoMetadata* photo_file_format_driver_create_metadata (PhotoFileFormatDriver* self);
gchar* photo_file_format_get_default_mime_type (PhotoFileFormat self);
gchar* photo_file_format_properties_get_default_mime_type (PhotoFileFormatProperties* self);
gchar** photo_file_format_get_mime_types (PhotoFileFormat self, int* result_length1);
gchar** photo_file_format_properties_get_mime_types (PhotoFileFormatProperties* self, int* result_length1);
gchar** photo_file_format_get_editable_mime_types (int* result_length1);
static void _vala_array_add44 (gchar*** array, int* length, int* size, gchar* value);
enum  {
	PHOTO_FILE_FORMAT_DRIVER_DUMMY_PROPERTY
};
static PhotoFileFormatProperties* photo_file_format_driver_real_get_properties (PhotoFileFormatDriver* self);
static PhotoFileReader* photo_file_format_driver_real_create_reader (PhotoFileFormatDriver* self, const gchar* filepath);
static PhotoMetadata* photo_file_format_driver_real_create_metadata (PhotoFileFormatDriver* self);
static gboolean photo_file_format_driver_real_can_write_image (PhotoFileFormatDriver* self);
static gboolean photo_file_format_driver_real_can_write_metadata (PhotoFileFormatDriver* self);
static PhotoFileWriter* photo_file_format_driver_real_create_writer (PhotoFileFormatDriver* self, const gchar* filepath);
static PhotoFileMetadataWriter* photo_file_format_driver_real_create_metadata_writer (PhotoFileFormatDriver* self, const gchar* filepath);
static PhotoFileSniffer* photo_file_format_driver_real_create_sniffer (PhotoFileFormatDriver* self, GFile* file, PhotoFileSnifferOptions options);
PhotoFileFormatDriver* photo_file_format_driver_construct (GType object_type);
static void photo_file_format_driver_finalize (PhotoFileFormatDriver* obj);
GType photo_file_format_flags_get_type (void) G_GNUC_CONST;
enum  {
	PHOTO_FILE_FORMAT_PROPERTIES_DUMMY_PROPERTY
};
PhotoFileFormat photo_file_format_properties_get_file_format (PhotoFileFormatProperties* self);
static PhotoFileFormat photo_file_format_properties_real_get_file_format (PhotoFileFormatProperties* self);
PhotoFileFormatFlags photo_file_format_properties_get_flags (PhotoFileFormatProperties* self);
static PhotoFileFormatFlags photo_file_format_properties_real_get_flags (PhotoFileFormatProperties* self);
static gboolean photo_file_format_properties_real_is_recognized_extension (PhotoFileFormatProperties* self, const gchar* ext);
gboolean is_in_ci_array (const gchar* str, gchar** strings, int strings_length1);
gchar** photo_file_format_properties_get_known_extensions (PhotoFileFormatProperties* self, int* result_length1);
static gchar* photo_file_format_properties_real_get_default_extension (PhotoFileFormatProperties* self);
static gchar** photo_file_format_properties_real_get_known_extensions (PhotoFileFormatProperties* self, int* result_length1);
static gchar* photo_file_format_properties_real_get_default_mime_type (PhotoFileFormatProperties* self);
static gchar** photo_file_format_properties_real_get_mime_types (PhotoFileFormatProperties* self, int* result_length1);
gchar* photo_file_format_properties_get_user_visible_name (PhotoFileFormatProperties* self);
static gchar* photo_file_format_properties_real_get_user_visible_name (PhotoFileFormatProperties* self);
GFile* photo_file_format_properties_convert_file_extension (PhotoFileFormatProperties* self, GFile* file);
PhotoFileFormatProperties* photo_file_format_properties_construct (GType object_type);
static void photo_file_format_properties_finalize (PhotoFileFormatProperties* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark photo_format_error_quark (void) {
	return g_quark_from_static_string ("photo_format_error-quark");
}


static void _vala_array_add43 (PhotoFileFormat** array, int* length, int* size, PhotoFileFormat value) {
#line 26 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if ((*length) == (*size)) {
#line 26 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 26 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		*array = g_renew (PhotoFileFormat, *array, *size);
#line 427 "PhotoFileFormat.c"
	}
#line 26 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	(*array)[(*length)++] = value;
#line 431 "PhotoFileFormat.c"
}


PhotoFileFormat* photo_file_format_data_find_applicable (PhotoFileFormatDataApplicableTest test, void* test_target, int* result_length1) {
	PhotoFileFormat* result = NULL;
	PhotoFileFormat* applicable = NULL;
	PhotoFileFormat* _tmp0_ = NULL;
	gint applicable_length1 = 0;
	gint _applicable_size_ = 0;
	gint _tmp1_ = 0;
	PhotoFileFormat* _tmp2_ = NULL;
	PhotoFileFormat* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
#line 23 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0_ = g_new0 (PhotoFileFormat, 0);
#line 23 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	applicable = _tmp0_;
#line 23 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	applicable_length1 = 0;
#line 23 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_applicable_size_ = applicable_length1;
#line 24 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp2_ = photo_file_format_get_supported (&_tmp1_);
#line 455 "PhotoFileFormat.c"
	{
		PhotoFileFormat* format_collection = NULL;
		gint format_collection_length1 = 0;
		gint _format_collection_size_ = 0;
		gint format_it = 0;
#line 24 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		format_collection = _tmp2_;
#line 24 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		format_collection_length1 = _tmp1_;
#line 24 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		for (format_it = 0; format_it < _tmp1_; format_it = format_it + 1) {
#line 467 "PhotoFileFormat.c"
			PhotoFileFormat format = 0;
#line 24 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			format = format_collection[format_it];
#line 471 "PhotoFileFormat.c"
			{
				PhotoFileFormatDataApplicableTest _tmp3_ = NULL;
				void* _tmp3__target = NULL;
				PhotoFileFormat _tmp4_ = 0;
				gboolean _tmp5_ = FALSE;
#line 25 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				_tmp3_ = test;
#line 25 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				_tmp3__target = test_target;
#line 25 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				_tmp4_ = format;
#line 25 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				_tmp5_ = _tmp3_ (_tmp4_, _tmp3__target);
#line 25 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				if (_tmp5_) {
#line 487 "PhotoFileFormat.c"
					PhotoFileFormat* _tmp6_ = NULL;
					gint _tmp6__length1 = 0;
					PhotoFileFormat _tmp7_ = 0;
#line 26 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
					_tmp6_ = applicable;
#line 26 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
					_tmp6__length1 = applicable_length1;
#line 26 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
					_tmp7_ = format;
#line 26 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
					_vala_array_add43 (&applicable, &applicable_length1, &_applicable_size_, _tmp7_);
#line 499 "PhotoFileFormat.c"
				}
			}
		}
#line 24 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		format_collection = (g_free (format_collection), NULL);
#line 505 "PhotoFileFormat.c"
	}
#line 29 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp8_ = applicable;
#line 29 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp8__length1 = applicable_length1;
#line 29 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (result_length1) {
#line 29 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		*result_length1 = _tmp8__length1;
#line 515 "PhotoFileFormat.c"
	}
#line 29 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	result = _tmp8_;
#line 29 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return result;
#line 521 "PhotoFileFormat.c"
}


static gboolean ___lambda4_ (PhotoFileFormat format) {
	gboolean result = FALSE;
	PhotoFileFormat _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
#line 34 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0_ = format;
#line 34 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp1_ = photo_file_format_can_write (_tmp0_);
#line 34 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	result = _tmp1_;
#line 34 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return result;
#line 537 "PhotoFileFormat.c"
}


static gboolean ____lambda4__photo_file_format_data_applicable_test (PhotoFileFormat format, gpointer self) {
	gboolean result;
	result = ___lambda4_ (format);
#line 34 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return result;
#line 546 "PhotoFileFormat.c"
}


static PhotoFileFormat* _vala_array_dup1 (PhotoFileFormat* self, int length) {
#line 36 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return g_memdup (self, length * sizeof (PhotoFileFormat));
#line 553 "PhotoFileFormat.c"
}


PhotoFileFormat* photo_file_format_data_get_writeable (int* result_length1) {
	PhotoFileFormat* result = NULL;
	PhotoFileFormat* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	PhotoFileFormat* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	PhotoFileFormat* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	PhotoFileFormat* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
#line 33 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0_ = photo_file_format_data_writeable;
#line 33 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0__length1 = photo_file_format_data_writeable_length1;
#line 33 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (_tmp0_ == NULL) {
#line 573 "PhotoFileFormat.c"
		gint _tmp1_ = 0;
		PhotoFileFormat* _tmp2_ = NULL;
#line 34 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		_tmp2_ = photo_file_format_data_find_applicable (____lambda4__photo_file_format_data_applicable_test, NULL, &_tmp1_);
#line 34 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		photo_file_format_data_writeable = (g_free (photo_file_format_data_writeable), NULL);
#line 34 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		photo_file_format_data_writeable = _tmp2_;
#line 34 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		photo_file_format_data_writeable_length1 = _tmp1_;
#line 34 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		_photo_file_format_data_writeable_size_ = photo_file_format_data_writeable_length1;
#line 586 "PhotoFileFormat.c"
	}
#line 36 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp3_ = photo_file_format_data_writeable;
#line 36 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp3__length1 = photo_file_format_data_writeable_length1;
#line 36 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup1 (_tmp3_, _tmp3__length1) : ((gpointer) _tmp3_);
#line 36 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp4__length1 = _tmp3__length1;
#line 36 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp5_ = _tmp4_;
#line 36 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp5__length1 = _tmp4__length1;
#line 36 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (result_length1) {
#line 36 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		*result_length1 = _tmp5__length1;
#line 604 "PhotoFileFormat.c"
	}
#line 36 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	result = _tmp5_;
#line 36 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return result;
#line 610 "PhotoFileFormat.c"
}


static gboolean ___lambda22_ (PhotoFileFormat format) {
	gboolean result = FALSE;
	PhotoFileFormat _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
#line 41 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0_ = format;
#line 41 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp1_ = photo_file_format_can_write_image (_tmp0_);
#line 41 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	result = _tmp1_;
#line 41 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return result;
#line 626 "PhotoFileFormat.c"
}


static gboolean ____lambda22__photo_file_format_data_applicable_test (PhotoFileFormat format, gpointer self) {
	gboolean result;
	result = ___lambda22_ (format);
#line 41 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return result;
#line 635 "PhotoFileFormat.c"
}


static PhotoFileFormat* _vala_array_dup2 (PhotoFileFormat* self, int length) {
#line 43 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return g_memdup (self, length * sizeof (PhotoFileFormat));
#line 642 "PhotoFileFormat.c"
}


PhotoFileFormat* photo_file_format_data_get_image_writeable (int* result_length1) {
	PhotoFileFormat* result = NULL;
	PhotoFileFormat* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	PhotoFileFormat* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	PhotoFileFormat* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	PhotoFileFormat* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
#line 40 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0_ = photo_file_format_data_image_writeable;
#line 40 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0__length1 = photo_file_format_data_image_writeable_length1;
#line 40 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (_tmp0_ == NULL) {
#line 662 "PhotoFileFormat.c"
		gint _tmp1_ = 0;
		PhotoFileFormat* _tmp2_ = NULL;
#line 41 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		_tmp2_ = photo_file_format_data_find_applicable (____lambda22__photo_file_format_data_applicable_test, NULL, &_tmp1_);
#line 41 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		photo_file_format_data_image_writeable = (g_free (photo_file_format_data_image_writeable), NULL);
#line 41 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		photo_file_format_data_image_writeable = _tmp2_;
#line 41 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		photo_file_format_data_image_writeable_length1 = _tmp1_;
#line 41 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		_photo_file_format_data_image_writeable_size_ = photo_file_format_data_image_writeable_length1;
#line 675 "PhotoFileFormat.c"
	}
#line 43 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp3_ = photo_file_format_data_image_writeable;
#line 43 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp3__length1 = photo_file_format_data_image_writeable_length1;
#line 43 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup2 (_tmp3_, _tmp3__length1) : ((gpointer) _tmp3_);
#line 43 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp4__length1 = _tmp3__length1;
#line 43 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp5_ = _tmp4_;
#line 43 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp5__length1 = _tmp4__length1;
#line 43 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (result_length1) {
#line 43 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		*result_length1 = _tmp5__length1;
#line 693 "PhotoFileFormat.c"
	}
#line 43 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	result = _tmp5_;
#line 43 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return result;
#line 699 "PhotoFileFormat.c"
}


static gboolean ___lambda23_ (PhotoFileFormat format) {
	gboolean result = FALSE;
	PhotoFileFormat _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
#line 48 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0_ = format;
#line 48 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp1_ = photo_file_format_can_write_metadata (_tmp0_);
#line 48 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	result = _tmp1_;
#line 48 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return result;
#line 715 "PhotoFileFormat.c"
}


static gboolean ____lambda23__photo_file_format_data_applicable_test (PhotoFileFormat format, gpointer self) {
	gboolean result;
	result = ___lambda23_ (format);
#line 48 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return result;
#line 724 "PhotoFileFormat.c"
}


static PhotoFileFormat* _vala_array_dup3 (PhotoFileFormat* self, int length) {
#line 50 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return g_memdup (self, length * sizeof (PhotoFileFormat));
#line 731 "PhotoFileFormat.c"
}


PhotoFileFormat* photo_file_format_data_get_metadata_writeable (int* result_length1) {
	PhotoFileFormat* result = NULL;
	PhotoFileFormat* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	PhotoFileFormat* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	PhotoFileFormat* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	PhotoFileFormat* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
#line 47 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0_ = photo_file_format_data_metadata_writeable;
#line 47 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0__length1 = photo_file_format_data_metadata_writeable_length1;
#line 47 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (_tmp0_ == NULL) {
#line 751 "PhotoFileFormat.c"
		gint _tmp1_ = 0;
		PhotoFileFormat* _tmp2_ = NULL;
#line 48 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		_tmp2_ = photo_file_format_data_find_applicable (____lambda23__photo_file_format_data_applicable_test, NULL, &_tmp1_);
#line 48 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		photo_file_format_data_metadata_writeable = (g_free (photo_file_format_data_metadata_writeable), NULL);
#line 48 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		photo_file_format_data_metadata_writeable = _tmp2_;
#line 48 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		photo_file_format_data_metadata_writeable_length1 = _tmp1_;
#line 48 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		_photo_file_format_data_metadata_writeable_size_ = photo_file_format_data_metadata_writeable_length1;
#line 764 "PhotoFileFormat.c"
	}
#line 50 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp3_ = photo_file_format_data_metadata_writeable;
#line 50 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp3__length1 = photo_file_format_data_metadata_writeable_length1;
#line 50 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup3 (_tmp3_, _tmp3__length1) : ((gpointer) _tmp3_);
#line 50 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp4__length1 = _tmp3__length1;
#line 50 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp5_ = _tmp4_;
#line 50 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp5__length1 = _tmp4__length1;
#line 50 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (result_length1) {
#line 50 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		*result_length1 = _tmp5__length1;
#line 782 "PhotoFileFormat.c"
	}
#line 50 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	result = _tmp5_;
#line 50 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return result;
#line 788 "PhotoFileFormat.c"
}


PhotoFileFormat* photo_file_format_get_supported (int* result_length1) {
	PhotoFileFormat* result = NULL;
	PhotoFileFormat* _tmp0_ = NULL;
	PhotoFileFormat* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
#line 65 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0_ = g_new0 (PhotoFileFormat, 5);
#line 65 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0_[0] = PHOTO_FILE_FORMAT_JFIF;
#line 65 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0_[1] = PHOTO_FILE_FORMAT_RAW;
#line 65 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0_[2] = PHOTO_FILE_FORMAT_PNG;
#line 65 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0_[3] = PHOTO_FILE_FORMAT_TIFF;
#line 65 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0_[4] = PHOTO_FILE_FORMAT_BMP;
#line 65 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp1_ = _tmp0_;
#line 65 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp1__length1 = 5;
#line 65 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (result_length1) {
#line 65 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		*result_length1 = _tmp1__length1;
#line 817 "PhotoFileFormat.c"
	}
#line 65 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	result = _tmp1_;
#line 65 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return result;
#line 823 "PhotoFileFormat.c"
}


PhotoFileFormat* photo_file_format_get_writeable (int* result_length1) {
	PhotoFileFormat* result = NULL;
	gint _tmp0_ = 0;
	PhotoFileFormat* _tmp1_ = NULL;
	PhotoFileFormat* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
#line 69 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp1_ = photo_file_format_data_get_writeable (&_tmp0_);
#line 69 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp2_ = _tmp1_;
#line 69 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp2__length1 = _tmp0_;
#line 69 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (result_length1) {
#line 69 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		*result_length1 = _tmp2__length1;
#line 843 "PhotoFileFormat.c"
	}
#line 69 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	result = _tmp2_;
#line 69 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return result;
#line 849 "PhotoFileFormat.c"
}


PhotoFileFormat* photo_file_format_get_image_writeable (int* result_length1) {
	PhotoFileFormat* result = NULL;
	gint _tmp0_ = 0;
	PhotoFileFormat* _tmp1_ = NULL;
	PhotoFileFormat* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
#line 73 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp1_ = photo_file_format_data_get_image_writeable (&_tmp0_);
#line 73 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp2_ = _tmp1_;
#line 73 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp2__length1 = _tmp0_;
#line 73 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (result_length1) {
#line 73 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		*result_length1 = _tmp2__length1;
#line 869 "PhotoFileFormat.c"
	}
#line 73 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	result = _tmp2_;
#line 73 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return result;
#line 875 "PhotoFileFormat.c"
}


PhotoFileFormat* photo_file_format_get_metadata_writeable (int* result_length1) {
	PhotoFileFormat* result = NULL;
	gint _tmp0_ = 0;
	PhotoFileFormat* _tmp1_ = NULL;
	PhotoFileFormat* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
#line 77 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp1_ = photo_file_format_data_get_metadata_writeable (&_tmp0_);
#line 77 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp2_ = _tmp1_;
#line 77 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp2__length1 = _tmp0_;
#line 77 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (result_length1) {
#line 77 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		*result_length1 = _tmp2__length1;
#line 895 "PhotoFileFormat.c"
	}
#line 77 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	result = _tmp2_;
#line 77 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return result;
#line 901 "PhotoFileFormat.c"
}


PhotoFileFormat photo_file_format_get_by_basename_extension (const gchar* basename) {
	PhotoFileFormat result = 0;
	gchar* name = NULL;
	gchar* ext = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_ = 0;
	PhotoFileFormat* _tmp6_ = NULL;
#line 80 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_val_if_fail (basename != NULL, 0);
#line 82 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0_ = basename;
#line 82 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	disassemble_filename (_tmp0_, &_tmp1_, &_tmp2_);
#line 82 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_g_free0 (name);
#line 82 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	name = _tmp1_;
#line 82 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_g_free0 (ext);
#line 82 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	ext = _tmp2_;
#line 84 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp3_ = ext;
#line 84 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp4_ = is_string_empty (_tmp3_);
#line 84 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (_tmp4_) {
#line 85 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		result = PHOTO_FILE_FORMAT_UNKNOWN;
#line 85 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		_g_free0 (ext);
#line 85 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		_g_free0 (name);
#line 85 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		return result;
#line 944 "PhotoFileFormat.c"
	}
#line 87 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp6_ = photo_file_format_get_supported (&_tmp5_);
#line 948 "PhotoFileFormat.c"
	{
		PhotoFileFormat* file_format_collection = NULL;
		gint file_format_collection_length1 = 0;
		gint _file_format_collection_size_ = 0;
		gint file_format_it = 0;
#line 87 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		file_format_collection = _tmp6_;
#line 87 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		file_format_collection_length1 = _tmp5_;
#line 87 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		for (file_format_it = 0; file_format_it < _tmp5_; file_format_it = file_format_it + 1) {
#line 960 "PhotoFileFormat.c"
			PhotoFileFormat file_format = 0;
#line 87 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			file_format = file_format_collection[file_format_it];
#line 964 "PhotoFileFormat.c"
			{
				PhotoFileFormat _tmp7_ = 0;
				PhotoFileFormatDriver* _tmp8_ = NULL;
				PhotoFileFormatDriver* _tmp9_ = NULL;
				PhotoFileFormatProperties* _tmp10_ = NULL;
				PhotoFileFormatProperties* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				gboolean _tmp13_ = FALSE;
				gboolean _tmp14_ = FALSE;
#line 88 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				_tmp7_ = file_format;
#line 88 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				_tmp8_ = photo_file_format_get_driver (_tmp7_);
#line 88 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				_tmp9_ = _tmp8_;
#line 88 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				_tmp10_ = photo_file_format_driver_get_properties (_tmp9_);
#line 88 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				_tmp11_ = _tmp10_;
#line 88 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				_tmp12_ = ext;
#line 88 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				_tmp13_ = photo_file_format_properties_is_recognized_extension (_tmp11_, _tmp12_);
#line 88 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				_tmp14_ = _tmp13_;
#line 88 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				_photo_file_format_properties_unref0 (_tmp11_);
#line 88 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				_photo_file_format_driver_unref0 (_tmp9_);
#line 88 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				if (_tmp14_) {
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
					result = file_format;
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
					file_format_collection = (g_free (file_format_collection), NULL);
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
					_g_free0 (ext);
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
					_g_free0 (name);
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
					return result;
#line 1006 "PhotoFileFormat.c"
				}
			}
		}
#line 87 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		file_format_collection = (g_free (file_format_collection), NULL);
#line 1012 "PhotoFileFormat.c"
	}
#line 92 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	result = PHOTO_FILE_FORMAT_UNKNOWN;
#line 92 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_g_free0 (ext);
#line 92 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_g_free0 (name);
#line 92 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return result;
#line 1022 "PhotoFileFormat.c"
}


gboolean photo_file_format_is_file_supported (GFile* file) {
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
#line 95 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 96 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0_ = file;
#line 96 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp1_ = g_file_get_basename (_tmp0_);
#line 96 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp2_ = _tmp1_;
#line 96 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp3_ = photo_file_format_is_basename_supported (_tmp2_);
#line 96 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp4_ = _tmp3_;
#line 96 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_g_free0 (_tmp2_);
#line 96 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	result = _tmp4_;
#line 96 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return result;
#line 1051 "PhotoFileFormat.c"
}


gboolean photo_file_format_is_basename_supported (const gchar* basename) {
	gboolean result = FALSE;
	gchar* name = NULL;
	gchar* ext = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_ = 0;
	PhotoFileFormat* _tmp6_ = NULL;
#line 99 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_val_if_fail (basename != NULL, FALSE);
#line 101 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0_ = basename;
#line 101 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	disassemble_filename (_tmp0_, &_tmp1_, &_tmp2_);
#line 101 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_g_free0 (name);
#line 101 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	name = _tmp1_;
#line 101 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_g_free0 (ext);
#line 101 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	ext = _tmp2_;
#line 103 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp3_ = ext;
#line 103 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp4_ = is_string_empty (_tmp3_);
#line 103 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (_tmp4_) {
#line 104 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		result = FALSE;
#line 104 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		_g_free0 (ext);
#line 104 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		_g_free0 (name);
#line 104 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		return result;
#line 1094 "PhotoFileFormat.c"
	}
#line 106 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp6_ = photo_file_format_get_supported (&_tmp5_);
#line 1098 "PhotoFileFormat.c"
	{
		PhotoFileFormat* format_collection = NULL;
		gint format_collection_length1 = 0;
		gint _format_collection_size_ = 0;
		gint format_it = 0;
#line 106 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		format_collection = _tmp6_;
#line 106 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		format_collection_length1 = _tmp5_;
#line 106 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		for (format_it = 0; format_it < _tmp5_; format_it = format_it + 1) {
#line 1110 "PhotoFileFormat.c"
			PhotoFileFormat format = 0;
#line 106 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			format = format_collection[format_it];
#line 1114 "PhotoFileFormat.c"
			{
				PhotoFileFormat _tmp7_ = 0;
				PhotoFileFormatDriver* _tmp8_ = NULL;
				PhotoFileFormatDriver* _tmp9_ = NULL;
				PhotoFileFormatProperties* _tmp10_ = NULL;
				PhotoFileFormatProperties* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				gboolean _tmp13_ = FALSE;
				gboolean _tmp14_ = FALSE;
#line 107 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				_tmp7_ = format;
#line 107 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				_tmp8_ = photo_file_format_get_driver (_tmp7_);
#line 107 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				_tmp9_ = _tmp8_;
#line 107 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				_tmp10_ = photo_file_format_driver_get_properties (_tmp9_);
#line 107 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				_tmp11_ = _tmp10_;
#line 107 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				_tmp12_ = ext;
#line 107 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				_tmp13_ = photo_file_format_properties_is_recognized_extension (_tmp11_, _tmp12_);
#line 107 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				_tmp14_ = _tmp13_;
#line 107 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				_photo_file_format_properties_unref0 (_tmp11_);
#line 107 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				_photo_file_format_driver_unref0 (_tmp9_);
#line 107 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				if (_tmp14_) {
#line 108 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
					result = TRUE;
#line 108 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
					format_collection = (g_free (format_collection), NULL);
#line 108 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
					_g_free0 (ext);
#line 108 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
					_g_free0 (name);
#line 108 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
					return result;
#line 1156 "PhotoFileFormat.c"
				}
			}
		}
#line 106 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		format_collection = (g_free (format_collection), NULL);
#line 1162 "PhotoFileFormat.c"
	}
#line 111 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	result = FALSE;
#line 111 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_g_free0 (ext);
#line 111 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_g_free0 (name);
#line 111 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return result;
#line 1172 "PhotoFileFormat.c"
}


PhotoFileFormat photo_file_format_get_system_default_format (void) {
	PhotoFileFormat result = 0;
#line 116 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	result = PHOTO_FILE_FORMAT_JFIF;
#line 116 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return result;
#line 1182 "PhotoFileFormat.c"
}


PhotoFileFormat photo_file_format_get_by_file_extension (GFile* file) {
	PhotoFileFormat result = 0;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	PhotoFileFormat _tmp3_ = 0;
	PhotoFileFormat _tmp4_ = 0;
#line 119 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_val_if_fail (G_IS_FILE (file), 0);
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0_ = file;
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp1_ = g_file_get_basename (_tmp0_);
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp2_ = _tmp1_;
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp3_ = photo_file_format_get_by_basename_extension (_tmp2_);
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp4_ = _tmp3_;
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_g_free0 (_tmp2_);
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	result = _tmp4_;
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return result;
#line 1211 "PhotoFileFormat.c"
}


gint photo_file_format_serialize (PhotoFileFormat self) {
	gint result = 0;
#line 125 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	switch (self) {
#line 125 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		case PHOTO_FILE_FORMAT_JFIF:
#line 1221 "PhotoFileFormat.c"
		{
#line 127 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			result = 0;
#line 127 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			return result;
#line 1227 "PhotoFileFormat.c"
		}
#line 125 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		case PHOTO_FILE_FORMAT_RAW:
#line 1231 "PhotoFileFormat.c"
		{
#line 130 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			result = 1;
#line 130 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			return result;
#line 1237 "PhotoFileFormat.c"
		}
#line 125 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		case PHOTO_FILE_FORMAT_PNG:
#line 1241 "PhotoFileFormat.c"
		{
#line 133 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			result = 2;
#line 133 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			return result;
#line 1247 "PhotoFileFormat.c"
		}
#line 125 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		case PHOTO_FILE_FORMAT_TIFF:
#line 1251 "PhotoFileFormat.c"
		{
#line 136 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			result = 3;
#line 136 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			return result;
#line 1257 "PhotoFileFormat.c"
		}
#line 125 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		case PHOTO_FILE_FORMAT_BMP:
#line 1261 "PhotoFileFormat.c"
		{
#line 139 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			result = 4;
#line 139 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			return result;
#line 1267 "PhotoFileFormat.c"
		}
		default:
#line 125 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		case PHOTO_FILE_FORMAT_UNKNOWN:
#line 1272 "PhotoFileFormat.c"
		{
#line 143 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			result = -1;
#line 143 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			return result;
#line 1278 "PhotoFileFormat.c"
		}
	}
}


PhotoFileFormat photo_file_format_unserialize (gint value) {
	PhotoFileFormat result = 0;
	gint _tmp0_ = 0;
#line 149 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0_ = value;
#line 149 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	switch (_tmp0_) {
#line 149 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		case 0:
#line 1293 "PhotoFileFormat.c"
		{
#line 151 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			result = PHOTO_FILE_FORMAT_JFIF;
#line 151 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			return result;
#line 1299 "PhotoFileFormat.c"
		}
#line 149 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		case 1:
#line 1303 "PhotoFileFormat.c"
		{
#line 154 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			result = PHOTO_FILE_FORMAT_RAW;
#line 154 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			return result;
#line 1309 "PhotoFileFormat.c"
		}
#line 149 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		case 2:
#line 1313 "PhotoFileFormat.c"
		{
#line 157 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			result = PHOTO_FILE_FORMAT_PNG;
#line 157 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			return result;
#line 1319 "PhotoFileFormat.c"
		}
#line 149 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		case 3:
#line 1323 "PhotoFileFormat.c"
		{
#line 160 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			result = PHOTO_FILE_FORMAT_TIFF;
#line 160 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			return result;
#line 1329 "PhotoFileFormat.c"
		}
#line 149 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		case 4:
#line 1333 "PhotoFileFormat.c"
		{
#line 163 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			result = PHOTO_FILE_FORMAT_BMP;
#line 163 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			return result;
#line 1339 "PhotoFileFormat.c"
		}
		default:
		{
#line 166 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			result = PHOTO_FILE_FORMAT_UNKNOWN;
#line 166 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			return result;
#line 1347 "PhotoFileFormat.c"
		}
	}
}


PhotoFileFormat photo_file_format_from_gphoto_type (const gchar* type) {
	PhotoFileFormat result = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
#line 170 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_val_if_fail (type != NULL, 0);
#line 171 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0_ = type;
#line 171 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp1_ = _tmp0_;
#line 171 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 171 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (_tmp3_ == g_quark_from_string (GP_MIME_JPEG)) {
#line 171 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		switch (0) {
#line 1370 "PhotoFileFormat.c"
			default:
			{
#line 173 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				result = PHOTO_FILE_FORMAT_JFIF;
#line 173 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				return result;
#line 1377 "PhotoFileFormat.c"
			}
		}
	} else if ((_tmp3_ == g_quark_from_string (GP_MIME_RAW)) || (_tmp3_ == g_quark_from_string (GP_MIME_CRW))) {
#line 171 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		switch (0) {
#line 1383 "PhotoFileFormat.c"
			default:
			{
#line 177 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				result = PHOTO_FILE_FORMAT_RAW;
#line 177 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				return result;
#line 1390 "PhotoFileFormat.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (GP_MIME_PNG)) {
#line 171 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		switch (0) {
#line 1396 "PhotoFileFormat.c"
			default:
			{
#line 180 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				result = PHOTO_FILE_FORMAT_PNG;
#line 180 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				return result;
#line 1403 "PhotoFileFormat.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (GP_MIME_TIFF)) {
#line 171 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		switch (0) {
#line 1409 "PhotoFileFormat.c"
			default:
			{
#line 183 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				result = PHOTO_FILE_FORMAT_TIFF;
#line 183 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				return result;
#line 1416 "PhotoFileFormat.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (GP_MIME_BMP)) {
#line 171 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		switch (0) {
#line 1422 "PhotoFileFormat.c"
			default:
			{
#line 186 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				result = PHOTO_FILE_FORMAT_BMP;
#line 186 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				return result;
#line 1429 "PhotoFileFormat.c"
			}
		}
	} else {
#line 171 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		switch (0) {
#line 1435 "PhotoFileFormat.c"
			default:
			{
#line 190 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				result = PHOTO_FILE_FORMAT_UNKNOWN;
#line 190 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				return result;
#line 1442 "PhotoFileFormat.c"
			}
		}
	}
}


PhotoFileFormat photo_file_format_from_pixbuf_name (const gchar* name) {
	PhotoFileFormat result = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
#line 196 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	static GQuark _tmp2_label0 = 0;
#line 196 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	static GQuark _tmp2_label1 = 0;
#line 196 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	static GQuark _tmp2_label2 = 0;
#line 196 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	static GQuark _tmp2_label3 = 0;
#line 195 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_val_if_fail (name != NULL, 0);
#line 196 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0_ = name;
#line 196 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp1_ = _tmp0_;
#line 196 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 196 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("jpeg")))) {
#line 196 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		switch (0) {
#line 1474 "PhotoFileFormat.c"
			default:
			{
#line 198 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				result = PHOTO_FILE_FORMAT_JFIF;
#line 198 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				return result;
#line 1481 "PhotoFileFormat.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("png")))) {
#line 196 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		switch (0) {
#line 1487 "PhotoFileFormat.c"
			default:
			{
#line 201 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				result = PHOTO_FILE_FORMAT_PNG;
#line 201 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				return result;
#line 1494 "PhotoFileFormat.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("tiff")))) {
#line 196 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		switch (0) {
#line 1500 "PhotoFileFormat.c"
			default:
			{
#line 204 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				result = PHOTO_FILE_FORMAT_TIFF;
#line 204 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				return result;
#line 1507 "PhotoFileFormat.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("bmp")))) {
#line 196 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		switch (0) {
#line 1513 "PhotoFileFormat.c"
			default:
			{
#line 207 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				result = PHOTO_FILE_FORMAT_BMP;
#line 207 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				return result;
#line 1520 "PhotoFileFormat.c"
			}
		}
	} else {
#line 196 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		switch (0) {
#line 1526 "PhotoFileFormat.c"
			default:
			{
#line 210 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				result = PHOTO_FILE_FORMAT_UNKNOWN;
#line 210 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				return result;
#line 1533 "PhotoFileFormat.c"
			}
		}
	}
}


void photo_file_format_init (PhotoFileFormat self) {
#line 215 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	switch (self) {
#line 215 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		case PHOTO_FILE_FORMAT_JFIF:
#line 1545 "PhotoFileFormat.c"
		{
#line 217 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			jfif_file_format_driver_init ();
#line 218 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			break;
#line 1551 "PhotoFileFormat.c"
		}
#line 215 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		case PHOTO_FILE_FORMAT_RAW:
#line 1555 "PhotoFileFormat.c"
		{
#line 221 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			raw_file_format_driver_init ();
#line 222 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			break;
#line 1561 "PhotoFileFormat.c"
		}
#line 215 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		case PHOTO_FILE_FORMAT_PNG:
#line 1565 "PhotoFileFormat.c"
		{
#line 225 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			png_file_format_driver_init ();
#line 226 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			break;
#line 1571 "PhotoFileFormat.c"
		}
#line 215 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		case PHOTO_FILE_FORMAT_TIFF:
#line 1575 "PhotoFileFormat.c"
		{
#line 229 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			photos_tiff_file_format_driver_init ();
#line 230 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			break;
#line 1581 "PhotoFileFormat.c"
		}
#line 215 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		case PHOTO_FILE_FORMAT_BMP:
#line 1585 "PhotoFileFormat.c"
		{
#line 233 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			photos_bmp_file_format_driver_init ();
#line 234 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			break;
#line 1591 "PhotoFileFormat.c"
		}
		default:
		{
			GEnumValue* _tmp0_;
#line 237 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			_tmp0_ = g_enum_get_value (g_type_class_ref (TYPE_PHOTO_FILE_FORMAT), self);
#line 237 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			g_error ("PhotoFileFormat.vala:237: Unsupported file format %s", (_tmp0_ != NULL) ? _tmp0_->value_name : NULL);
#line 1600 "PhotoFileFormat.c"
		}
	}
}


static PhotoFileFormatDriver* photo_file_format_get_driver (PhotoFileFormat self) {
	PhotoFileFormatDriver* result = NULL;
#line 242 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	switch (self) {
#line 242 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		case PHOTO_FILE_FORMAT_JFIF:
#line 1612 "PhotoFileFormat.c"
		{
			JfifFileFormatDriver* _tmp0_ = NULL;
#line 244 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			_tmp0_ = jfif_file_format_driver_get_instance ();
#line 244 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PHOTO_FILE_FORMAT_DRIVER, PhotoFileFormatDriver);
#line 244 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			return result;
#line 1621 "PhotoFileFormat.c"
		}
#line 242 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		case PHOTO_FILE_FORMAT_RAW:
#line 1625 "PhotoFileFormat.c"
		{
			RawFileFormatDriver* _tmp1_ = NULL;
#line 247 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			_tmp1_ = raw_file_format_driver_get_instance ();
#line 247 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_FORMAT_DRIVER, PhotoFileFormatDriver);
#line 247 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			return result;
#line 1634 "PhotoFileFormat.c"
		}
#line 242 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		case PHOTO_FILE_FORMAT_PNG:
#line 1638 "PhotoFileFormat.c"
		{
			PngFileFormatDriver* _tmp2_ = NULL;
#line 250 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			_tmp2_ = png_file_format_driver_get_instance ();
#line 250 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO_FILE_FORMAT_DRIVER, PhotoFileFormatDriver);
#line 250 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			return result;
#line 1647 "PhotoFileFormat.c"
		}
#line 242 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		case PHOTO_FILE_FORMAT_TIFF:
#line 1651 "PhotoFileFormat.c"
		{
			PhotosTiffFileFormatDriver* _tmp3_ = NULL;
#line 253 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			_tmp3_ = photos_tiff_file_format_driver_get_instance ();
#line 253 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			result = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_PHOTO_FILE_FORMAT_DRIVER, PhotoFileFormatDriver);
#line 253 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			return result;
#line 1660 "PhotoFileFormat.c"
		}
#line 242 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		case PHOTO_FILE_FORMAT_BMP:
#line 1664 "PhotoFileFormat.c"
		{
			PhotosBmpFileFormatDriver* _tmp4_ = NULL;
#line 256 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			_tmp4_ = photos_bmp_file_format_driver_get_instance ();
#line 256 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			result = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_PHOTO_FILE_FORMAT_DRIVER, PhotoFileFormatDriver);
#line 256 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			return result;
#line 1673 "PhotoFileFormat.c"
		}
		default:
		{
			GEnumValue* _tmp5_;
#line 259 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			_tmp5_ = g_enum_get_value (g_type_class_ref (TYPE_PHOTO_FILE_FORMAT), self);
#line 259 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			g_error ("PhotoFileFormat.vala:259: Unsupported file format %s", (_tmp5_ != NULL) ? _tmp5_->value_name : NULL);
#line 1682 "PhotoFileFormat.c"
		}
	}
}


PhotoFileFormatProperties* photo_file_format_get_properties (PhotoFileFormat self) {
	PhotoFileFormatProperties* result = NULL;
	PhotoFileFormatDriver* _tmp0_ = NULL;
	PhotoFileFormatDriver* _tmp1_ = NULL;
	PhotoFileFormatProperties* _tmp2_ = NULL;
	PhotoFileFormatProperties* _tmp3_ = NULL;
#line 264 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0_ = photo_file_format_get_driver (self);
#line 264 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp1_ = _tmp0_;
#line 264 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp2_ = photo_file_format_driver_get_properties (_tmp1_);
#line 264 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp3_ = _tmp2_;
#line 264 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_photo_file_format_driver_unref0 (_tmp1_);
#line 264 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	result = _tmp3_;
#line 264 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return result;
#line 1708 "PhotoFileFormat.c"
}


gchar* photo_file_format_get_default_basename (PhotoFileFormat self, const gchar* name) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	PhotoFileFormatProperties* _tmp1_ = NULL;
	PhotoFileFormatProperties* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
#line 268 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 269 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0_ = name;
#line 269 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp1_ = photo_file_format_get_properties (self);
#line 269 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp2_ = _tmp1_;
#line 269 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp3_ = photo_file_format_properties_get_default_extension (_tmp2_);
#line 269 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp4_ = _tmp3_;
#line 269 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp5_ = g_strdup_printf ("%s.%s", _tmp0_, _tmp4_);
#line 269 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp6_ = _tmp5_;
#line 269 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_g_free0 (_tmp4_);
#line 269 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_photo_file_format_properties_unref0 (_tmp2_);
#line 269 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	result = _tmp6_;
#line 269 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return result;
#line 1745 "PhotoFileFormat.c"
}


PhotoFileReader* photo_file_format_create_reader (PhotoFileFormat self, const gchar* filepath) {
	PhotoFileReader* result = NULL;
	PhotoFileFormatDriver* _tmp0_ = NULL;
	PhotoFileFormatDriver* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	PhotoFileReader* _tmp3_ = NULL;
	PhotoFileReader* _tmp4_ = NULL;
#line 272 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_val_if_fail (filepath != NULL, NULL);
#line 273 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0_ = photo_file_format_get_driver (self);
#line 273 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp1_ = _tmp0_;
#line 273 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp2_ = filepath;
#line 273 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp3_ = photo_file_format_driver_create_reader (_tmp1_, _tmp2_);
#line 273 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp4_ = _tmp3_;
#line 273 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_photo_file_format_driver_unref0 (_tmp1_);
#line 273 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	result = _tmp4_;
#line 273 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return result;
#line 1774 "PhotoFileFormat.c"
}


gboolean photo_file_format_can_write (PhotoFileFormat self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 278 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp1_ = photo_file_format_can_write_image (self);
#line 278 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (_tmp1_) {
#line 1786 "PhotoFileFormat.c"
		gboolean _tmp2_ = FALSE;
#line 278 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		_tmp2_ = photo_file_format_can_write_metadata (self);
#line 278 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		_tmp0_ = _tmp2_;
#line 1792 "PhotoFileFormat.c"
	} else {
#line 278 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		_tmp0_ = FALSE;
#line 1796 "PhotoFileFormat.c"
	}
#line 278 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	result = _tmp0_;
#line 278 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return result;
#line 1802 "PhotoFileFormat.c"
}


gboolean photo_file_format_can_write_image (PhotoFileFormat self) {
	gboolean result = FALSE;
	PhotoFileFormatDriver* _tmp0_ = NULL;
	PhotoFileFormatDriver* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
#line 282 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0_ = photo_file_format_get_driver (self);
#line 282 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp1_ = _tmp0_;
#line 282 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp2_ = photo_file_format_driver_can_write_image (_tmp1_);
#line 282 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp3_ = _tmp2_;
#line 282 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_photo_file_format_driver_unref0 (_tmp1_);
#line 282 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	result = _tmp3_;
#line 282 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return result;
#line 1826 "PhotoFileFormat.c"
}


gboolean photo_file_format_can_write_metadata (PhotoFileFormat self) {
	gboolean result = FALSE;
	PhotoFileFormatDriver* _tmp0_ = NULL;
	PhotoFileFormatDriver* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
#line 286 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0_ = photo_file_format_get_driver (self);
#line 286 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp1_ = _tmp0_;
#line 286 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp2_ = photo_file_format_driver_can_write_metadata (_tmp1_);
#line 286 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp3_ = _tmp2_;
#line 286 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_photo_file_format_driver_unref0 (_tmp1_);
#line 286 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	result = _tmp3_;
#line 286 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return result;
#line 1850 "PhotoFileFormat.c"
}


PhotoFileWriter* photo_file_format_create_writer (PhotoFileFormat self, const gchar* filepath, GError** error) {
	PhotoFileWriter* result = NULL;
	PhotoFileWriter* writer = NULL;
	PhotoFileFormatDriver* _tmp0_ = NULL;
	PhotoFileFormatDriver* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	PhotoFileWriter* _tmp3_ = NULL;
	PhotoFileWriter* _tmp4_ = NULL;
	PhotoFileWriter* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 289 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_val_if_fail (filepath != NULL, NULL);
#line 290 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0_ = photo_file_format_get_driver (self);
#line 290 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp1_ = _tmp0_;
#line 290 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp2_ = filepath;
#line 290 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp3_ = photo_file_format_driver_create_writer (_tmp1_, _tmp2_);
#line 290 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp4_ = _tmp3_;
#line 290 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_photo_file_format_driver_unref0 (_tmp1_);
#line 290 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	writer = _tmp4_;
#line 291 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp5_ = writer;
#line 291 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (_tmp5_ == NULL) {
#line 1884 "PhotoFileFormat.c"
		GEnumValue* _tmp6_;
		GError* _tmp7_ = NULL;
#line 292 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		_tmp6_ = g_enum_get_value (g_type_class_ref (TYPE_PHOTO_FILE_FORMAT), self);
#line 292 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		_tmp7_ = g_error_new (PHOTO_FORMAT_ERROR, PHOTO_FORMAT_ERROR_READ_ONLY, "File format %s is read-only", (_tmp6_ != NULL) ? _tmp6_->value_name : NULL);
#line 292 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		_inner_error_ = _tmp7_;
#line 292 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		if (_inner_error_->domain == PHOTO_FORMAT_ERROR) {
#line 292 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			g_propagate_error (error, _inner_error_);
#line 292 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			_photo_file_adapter_unref0 (writer);
#line 292 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			return NULL;
#line 1901 "PhotoFileFormat.c"
		} else {
#line 292 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			_photo_file_adapter_unref0 (writer);
#line 292 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 292 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			g_clear_error (&_inner_error_);
#line 292 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			return NULL;
#line 1911 "PhotoFileFormat.c"
		}
	}
#line 294 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	result = writer;
#line 294 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return result;
#line 1918 "PhotoFileFormat.c"
}


PhotoFileMetadataWriter* photo_file_format_create_metadata_writer (PhotoFileFormat self, const gchar* filepath, GError** error) {
	PhotoFileMetadataWriter* result = NULL;
	PhotoFileMetadataWriter* writer = NULL;
	PhotoFileFormatDriver* _tmp0_ = NULL;
	PhotoFileFormatDriver* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	PhotoFileMetadataWriter* _tmp3_ = NULL;
	PhotoFileMetadataWriter* _tmp4_ = NULL;
	PhotoFileMetadataWriter* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 297 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_val_if_fail (filepath != NULL, NULL);
#line 298 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0_ = photo_file_format_get_driver (self);
#line 298 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp1_ = _tmp0_;
#line 298 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp2_ = filepath;
#line 298 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp3_ = photo_file_format_driver_create_metadata_writer (_tmp1_, _tmp2_);
#line 298 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp4_ = _tmp3_;
#line 298 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_photo_file_format_driver_unref0 (_tmp1_);
#line 298 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	writer = _tmp4_;
#line 299 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp5_ = writer;
#line 299 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (_tmp5_ == NULL) {
#line 1952 "PhotoFileFormat.c"
		GEnumValue* _tmp6_;
		GError* _tmp7_ = NULL;
#line 300 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		_tmp6_ = g_enum_get_value (g_type_class_ref (TYPE_PHOTO_FILE_FORMAT), self);
#line 300 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		_tmp7_ = g_error_new (PHOTO_FORMAT_ERROR, PHOTO_FORMAT_ERROR_READ_ONLY, "File format %s metadata is read-only", (_tmp6_ != NULL) ? _tmp6_->value_name : NULL);
#line 300 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		_inner_error_ = _tmp7_;
#line 300 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		if (_inner_error_->domain == PHOTO_FORMAT_ERROR) {
#line 300 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			g_propagate_error (error, _inner_error_);
#line 300 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			_photo_file_adapter_unref0 (writer);
#line 300 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			return NULL;
#line 1969 "PhotoFileFormat.c"
		} else {
#line 300 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			_photo_file_adapter_unref0 (writer);
#line 300 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 300 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			g_clear_error (&_inner_error_);
#line 300 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			return NULL;
#line 1979 "PhotoFileFormat.c"
		}
	}
#line 302 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	result = writer;
#line 302 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return result;
#line 1986 "PhotoFileFormat.c"
}


PhotoFileSniffer* photo_file_format_create_sniffer (PhotoFileFormat self, GFile* file, PhotoFileSnifferOptions options) {
	PhotoFileSniffer* result = NULL;
	PhotoFileFormatDriver* _tmp0_ = NULL;
	PhotoFileFormatDriver* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	PhotoFileSnifferOptions _tmp3_ = 0;
	PhotoFileSniffer* _tmp4_ = NULL;
	PhotoFileSniffer* _tmp5_ = NULL;
#line 305 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 306 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0_ = photo_file_format_get_driver (self);
#line 306 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp1_ = _tmp0_;
#line 306 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp2_ = file;
#line 306 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp3_ = options;
#line 306 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp4_ = photo_file_format_driver_create_sniffer (_tmp1_, _tmp2_, _tmp3_);
#line 306 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp5_ = _tmp4_;
#line 306 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_photo_file_format_driver_unref0 (_tmp1_);
#line 306 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	result = _tmp5_;
#line 306 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return result;
#line 2018 "PhotoFileFormat.c"
}


PhotoMetadata* photo_file_format_create_metadata (PhotoFileFormat self) {
	PhotoMetadata* result = NULL;
	PhotoFileFormatDriver* _tmp0_ = NULL;
	PhotoFileFormatDriver* _tmp1_ = NULL;
	PhotoMetadata* _tmp2_ = NULL;
	PhotoMetadata* _tmp3_ = NULL;
#line 310 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0_ = photo_file_format_get_driver (self);
#line 310 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp1_ = _tmp0_;
#line 310 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp2_ = photo_file_format_driver_create_metadata (_tmp1_);
#line 310 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp3_ = _tmp2_;
#line 310 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_photo_file_format_driver_unref0 (_tmp1_);
#line 310 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	result = _tmp3_;
#line 310 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return result;
#line 2042 "PhotoFileFormat.c"
}


gchar* photo_file_format_get_default_mime_type (PhotoFileFormat self) {
	gchar* result = NULL;
	PhotoFileFormatDriver* _tmp0_ = NULL;
	PhotoFileFormatDriver* _tmp1_ = NULL;
	PhotoFileFormatProperties* _tmp2_ = NULL;
	PhotoFileFormatProperties* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
#line 314 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0_ = photo_file_format_get_driver (self);
#line 314 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp1_ = _tmp0_;
#line 314 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp2_ = photo_file_format_driver_get_properties (_tmp1_);
#line 314 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp3_ = _tmp2_;
#line 314 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp4_ = photo_file_format_properties_get_default_mime_type (_tmp3_);
#line 314 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp5_ = _tmp4_;
#line 314 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_photo_file_format_properties_unref0 (_tmp3_);
#line 314 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_photo_file_format_driver_unref0 (_tmp1_);
#line 314 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	result = _tmp5_;
#line 314 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return result;
#line 2074 "PhotoFileFormat.c"
}


gchar** photo_file_format_get_mime_types (PhotoFileFormat self, int* result_length1) {
	gchar** result = NULL;
	PhotoFileFormatDriver* _tmp0_ = NULL;
	PhotoFileFormatDriver* _tmp1_ = NULL;
	PhotoFileFormatProperties* _tmp2_ = NULL;
	PhotoFileFormatProperties* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gchar** _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
#line 318 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0_ = photo_file_format_get_driver (self);
#line 318 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp1_ = _tmp0_;
#line 318 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp2_ = photo_file_format_driver_get_properties (_tmp1_);
#line 318 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp3_ = _tmp2_;
#line 318 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp5_ = photo_file_format_properties_get_mime_types (_tmp3_, &_tmp4_);
#line 318 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp6_ = _tmp5_;
#line 318 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp6__length1 = _tmp4_;
#line 318 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_photo_file_format_properties_unref0 (_tmp3_);
#line 318 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_photo_file_format_driver_unref0 (_tmp1_);
#line 318 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp7_ = _tmp6_;
#line 318 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp7__length1 = _tmp6__length1;
#line 318 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (result_length1) {
#line 318 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		*result_length1 = _tmp7__length1;
#line 2116 "PhotoFileFormat.c"
	}
#line 318 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	result = _tmp7_;
#line 318 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return result;
#line 2122 "PhotoFileFormat.c"
}


static void _vala_array_add44 (gchar*** array, int* length, int* size, gchar* value) {
#line 326 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if ((*length) == (*size)) {
#line 326 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 326 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 2133 "PhotoFileFormat.c"
	}
#line 326 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	(*array)[(*length)++] = value;
#line 326 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	(*array)[*length] = NULL;
#line 2139 "PhotoFileFormat.c"
}


gchar** photo_file_format_get_editable_mime_types (int* result_length1) {
	gchar** result = NULL;
	gchar** mime_types = NULL;
	gchar** _tmp0_ = NULL;
	gint mime_types_length1 = 0;
	gint _mime_types_size_ = 0;
	gint _tmp1_ = 0;
	PhotoFileFormat* _tmp2_ = NULL;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
#line 322 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 322 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	mime_types = _tmp0_;
#line 322 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	mime_types_length1 = 0;
#line 322 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_mime_types_size_ = mime_types_length1;
#line 324 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp2_ = photo_file_format_get_supported (&_tmp1_);
#line 2163 "PhotoFileFormat.c"
	{
		PhotoFileFormat* file_format_collection = NULL;
		gint file_format_collection_length1 = 0;
		gint _file_format_collection_size_ = 0;
		gint file_format_it = 0;
#line 324 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		file_format_collection = _tmp2_;
#line 324 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		file_format_collection_length1 = _tmp1_;
#line 324 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		for (file_format_it = 0; file_format_it < _tmp1_; file_format_it = file_format_it + 1) {
#line 2175 "PhotoFileFormat.c"
			PhotoFileFormat file_format = 0;
#line 324 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			file_format = file_format_collection[file_format_it];
#line 2179 "PhotoFileFormat.c"
			{
				PhotoFileFormat _tmp3_ = 0;
				gint _tmp4_ = 0;
				gchar** _tmp5_ = NULL;
#line 325 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				_tmp3_ = file_format;
#line 325 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
				_tmp5_ = photo_file_format_get_mime_types (_tmp3_, &_tmp4_);
#line 2188 "PhotoFileFormat.c"
				{
					gchar** mime_type_collection = NULL;
					gint mime_type_collection_length1 = 0;
					gint _mime_type_collection_size_ = 0;
					gint mime_type_it = 0;
#line 325 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
					mime_type_collection = _tmp5_;
#line 325 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
					mime_type_collection_length1 = _tmp4_;
#line 325 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
					for (mime_type_it = 0; mime_type_it < _tmp4_; mime_type_it = mime_type_it + 1) {
#line 2200 "PhotoFileFormat.c"
						gchar* _tmp6_ = NULL;
						gchar* mime_type = NULL;
#line 325 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
						_tmp6_ = g_strdup (mime_type_collection[mime_type_it]);
#line 325 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
						mime_type = _tmp6_;
#line 2207 "PhotoFileFormat.c"
						{
							gchar** _tmp7_ = NULL;
							gint _tmp7__length1 = 0;
							const gchar* _tmp8_ = NULL;
							gchar* _tmp9_ = NULL;
#line 326 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
							_tmp7_ = mime_types;
#line 326 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
							_tmp7__length1 = mime_types_length1;
#line 326 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
							_tmp8_ = mime_type;
#line 326 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
							_tmp9_ = g_strdup (_tmp8_);
#line 326 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
							_vala_array_add44 (&mime_types, &mime_types_length1, &_mime_types_size_, _tmp9_);
#line 325 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
							_g_free0 (mime_type);
#line 2225 "PhotoFileFormat.c"
						}
					}
#line 325 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
					mime_type_collection = (_vala_array_free (mime_type_collection, mime_type_collection_length1, (GDestroyNotify) g_free), NULL);
#line 2230 "PhotoFileFormat.c"
				}
			}
		}
#line 324 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		file_format_collection = (g_free (file_format_collection), NULL);
#line 2236 "PhotoFileFormat.c"
	}
#line 329 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp10_ = mime_types;
#line 329 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp10__length1 = mime_types_length1;
#line 329 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (result_length1) {
#line 329 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		*result_length1 = _tmp10__length1;
#line 2246 "PhotoFileFormat.c"
	}
#line 329 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	result = _tmp10_;
#line 329 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return result;
#line 2252 "PhotoFileFormat.c"
}


GType photo_file_format_get_type (void) {
	static volatile gsize photo_file_format_type_id__volatile = 0;
	if (g_once_init_enter (&photo_file_format_type_id__volatile)) {
		static const GEnumValue values[] = {{PHOTO_FILE_FORMAT_JFIF, "PHOTO_FILE_FORMAT_JFIF", "jfif"}, {PHOTO_FILE_FORMAT_RAW, "PHOTO_FILE_FORMAT_RAW", "raw"}, {PHOTO_FILE_FORMAT_PNG, "PHOTO_FILE_FORMAT_PNG", "png"}, {PHOTO_FILE_FORMAT_TIFF, "PHOTO_FILE_FORMAT_TIFF", "tiff"}, {PHOTO_FILE_FORMAT_BMP, "PHOTO_FILE_FORMAT_BMP", "bmp"}, {PHOTO_FILE_FORMAT_UNKNOWN, "PHOTO_FILE_FORMAT_UNKNOWN", "unknown"}, {0, NULL, NULL}};
		GType photo_file_format_type_id;
		photo_file_format_type_id = g_enum_register_static ("PhotoFileFormat", values);
		g_once_init_leave (&photo_file_format_type_id__volatile, photo_file_format_type_id);
	}
	return photo_file_format_type_id__volatile;
}


static PhotoFileFormatProperties* photo_file_format_driver_real_get_properties (PhotoFileFormatDriver* self) {
#line 345 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_critical ("Type `%s' does not implement abstract method `photo_file_format_driver_get_properties'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 345 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return NULL;
#line 2273 "PhotoFileFormat.c"
}


PhotoFileFormatProperties* photo_file_format_driver_get_properties (PhotoFileFormatDriver* self) {
#line 345 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_val_if_fail (IS_PHOTO_FILE_FORMAT_DRIVER (self), NULL);
#line 345 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return PHOTO_FILE_FORMAT_DRIVER_GET_CLASS (self)->get_properties (self);
#line 2282 "PhotoFileFormat.c"
}


static PhotoFileReader* photo_file_format_driver_real_create_reader (PhotoFileFormatDriver* self, const gchar* filepath) {
#line 347 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_critical ("Type `%s' does not implement abstract method `photo_file_format_driver_create_reader'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 347 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return NULL;
#line 2291 "PhotoFileFormat.c"
}


PhotoFileReader* photo_file_format_driver_create_reader (PhotoFileFormatDriver* self, const gchar* filepath) {
#line 347 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_val_if_fail (IS_PHOTO_FILE_FORMAT_DRIVER (self), NULL);
#line 347 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return PHOTO_FILE_FORMAT_DRIVER_GET_CLASS (self)->create_reader (self, filepath);
#line 2300 "PhotoFileFormat.c"
}


static PhotoMetadata* photo_file_format_driver_real_create_metadata (PhotoFileFormatDriver* self) {
#line 349 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_critical ("Type `%s' does not implement abstract method `photo_file_format_driver_create_metadata'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 349 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return NULL;
#line 2309 "PhotoFileFormat.c"
}


PhotoMetadata* photo_file_format_driver_create_metadata (PhotoFileFormatDriver* self) {
#line 349 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_val_if_fail (IS_PHOTO_FILE_FORMAT_DRIVER (self), NULL);
#line 349 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return PHOTO_FILE_FORMAT_DRIVER_GET_CLASS (self)->create_metadata (self);
#line 2318 "PhotoFileFormat.c"
}


static gboolean photo_file_format_driver_real_can_write_image (PhotoFileFormatDriver* self) {
#line 351 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_critical ("Type `%s' does not implement abstract method `photo_file_format_driver_can_write_image'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 351 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return FALSE;
#line 2327 "PhotoFileFormat.c"
}


gboolean photo_file_format_driver_can_write_image (PhotoFileFormatDriver* self) {
#line 351 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_val_if_fail (IS_PHOTO_FILE_FORMAT_DRIVER (self), FALSE);
#line 351 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return PHOTO_FILE_FORMAT_DRIVER_GET_CLASS (self)->can_write_image (self);
#line 2336 "PhotoFileFormat.c"
}


static gboolean photo_file_format_driver_real_can_write_metadata (PhotoFileFormatDriver* self) {
#line 353 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_critical ("Type `%s' does not implement abstract method `photo_file_format_driver_can_write_metadata'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 353 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return FALSE;
#line 2345 "PhotoFileFormat.c"
}


gboolean photo_file_format_driver_can_write_metadata (PhotoFileFormatDriver* self) {
#line 353 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_val_if_fail (IS_PHOTO_FILE_FORMAT_DRIVER (self), FALSE);
#line 353 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return PHOTO_FILE_FORMAT_DRIVER_GET_CLASS (self)->can_write_metadata (self);
#line 2354 "PhotoFileFormat.c"
}


static PhotoFileWriter* photo_file_format_driver_real_create_writer (PhotoFileFormatDriver* self, const gchar* filepath) {
#line 355 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_critical ("Type `%s' does not implement abstract method `photo_file_format_driver_create_writer'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 355 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return NULL;
#line 2363 "PhotoFileFormat.c"
}


PhotoFileWriter* photo_file_format_driver_create_writer (PhotoFileFormatDriver* self, const gchar* filepath) {
#line 355 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_val_if_fail (IS_PHOTO_FILE_FORMAT_DRIVER (self), NULL);
#line 355 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return PHOTO_FILE_FORMAT_DRIVER_GET_CLASS (self)->create_writer (self, filepath);
#line 2372 "PhotoFileFormat.c"
}


static PhotoFileMetadataWriter* photo_file_format_driver_real_create_metadata_writer (PhotoFileFormatDriver* self, const gchar* filepath) {
#line 357 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_critical ("Type `%s' does not implement abstract method `photo_file_format_driver_create_metadata_writer'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 357 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return NULL;
#line 2381 "PhotoFileFormat.c"
}


PhotoFileMetadataWriter* photo_file_format_driver_create_metadata_writer (PhotoFileFormatDriver* self, const gchar* filepath) {
#line 357 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_val_if_fail (IS_PHOTO_FILE_FORMAT_DRIVER (self), NULL);
#line 357 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return PHOTO_FILE_FORMAT_DRIVER_GET_CLASS (self)->create_metadata_writer (self, filepath);
#line 2390 "PhotoFileFormat.c"
}


static PhotoFileSniffer* photo_file_format_driver_real_create_sniffer (PhotoFileFormatDriver* self, GFile* file, PhotoFileSnifferOptions options) {
#line 359 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_critical ("Type `%s' does not implement abstract method `photo_file_format_driver_create_sniffer'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 359 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return NULL;
#line 2399 "PhotoFileFormat.c"
}


PhotoFileSniffer* photo_file_format_driver_create_sniffer (PhotoFileFormatDriver* self, GFile* file, PhotoFileSnifferOptions options) {
#line 359 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_val_if_fail (IS_PHOTO_FILE_FORMAT_DRIVER (self), NULL);
#line 359 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return PHOTO_FILE_FORMAT_DRIVER_GET_CLASS (self)->create_sniffer (self, file, options);
#line 2408 "PhotoFileFormat.c"
}


PhotoFileFormatDriver* photo_file_format_driver_construct (GType object_type) {
	PhotoFileFormatDriver* self = NULL;
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	self = (PhotoFileFormatDriver*) g_type_create_instance (object_type);
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return self;
#line 2418 "PhotoFileFormat.c"
}


static void value_photo_file_format_driver_init (GValue* value) {
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	value->data[0].v_pointer = NULL;
#line 2425 "PhotoFileFormat.c"
}


static void value_photo_file_format_driver_free_value (GValue* value) {
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (value->data[0].v_pointer) {
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		photo_file_format_driver_unref (value->data[0].v_pointer);
#line 2434 "PhotoFileFormat.c"
	}
}


static void value_photo_file_format_driver_copy_value (const GValue* src_value, GValue* dest_value) {
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (src_value->data[0].v_pointer) {
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		dest_value->data[0].v_pointer = photo_file_format_driver_ref (src_value->data[0].v_pointer);
#line 2444 "PhotoFileFormat.c"
	} else {
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2448 "PhotoFileFormat.c"
	}
}


static gpointer value_photo_file_format_driver_peek_pointer (const GValue* value) {
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return value->data[0].v_pointer;
#line 2456 "PhotoFileFormat.c"
}


static gchar* value_photo_file_format_driver_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (collect_values[0].v_pointer) {
#line 2463 "PhotoFileFormat.c"
		PhotoFileFormatDriver* object;
		object = collect_values[0].v_pointer;
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		if (object->parent_instance.g_class == NULL) {
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2470 "PhotoFileFormat.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2474 "PhotoFileFormat.c"
		}
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		value->data[0].v_pointer = photo_file_format_driver_ref (object);
#line 2478 "PhotoFileFormat.c"
	} else {
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		value->data[0].v_pointer = NULL;
#line 2482 "PhotoFileFormat.c"
	}
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return NULL;
#line 2486 "PhotoFileFormat.c"
}


static gchar* value_photo_file_format_driver_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PhotoFileFormatDriver** object_p;
	object_p = collect_values[0].v_pointer;
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (!object_p) {
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2497 "PhotoFileFormat.c"
	}
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (!value->data[0].v_pointer) {
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		*object_p = NULL;
#line 2503 "PhotoFileFormat.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		*object_p = value->data[0].v_pointer;
#line 2507 "PhotoFileFormat.c"
	} else {
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		*object_p = photo_file_format_driver_ref (value->data[0].v_pointer);
#line 2511 "PhotoFileFormat.c"
	}
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return NULL;
#line 2515 "PhotoFileFormat.c"
}


GParamSpec* param_spec_photo_file_format_driver (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPhotoFileFormatDriver* spec;
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PHOTO_FILE_FORMAT_DRIVER), NULL);
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return G_PARAM_SPEC (spec);
#line 2529 "PhotoFileFormat.c"
}


gpointer value_get_photo_file_format_driver (const GValue* value) {
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_FORMAT_DRIVER), NULL);
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return value->data[0].v_pointer;
#line 2538 "PhotoFileFormat.c"
}


void value_set_photo_file_format_driver (GValue* value, gpointer v_object) {
	PhotoFileFormatDriver* old;
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_FORMAT_DRIVER));
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	old = value->data[0].v_pointer;
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (v_object) {
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_FILE_FORMAT_DRIVER));
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		value->data[0].v_pointer = v_object;
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		photo_file_format_driver_ref (value->data[0].v_pointer);
#line 2558 "PhotoFileFormat.c"
	} else {
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		value->data[0].v_pointer = NULL;
#line 2562 "PhotoFileFormat.c"
	}
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (old) {
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		photo_file_format_driver_unref (old);
#line 2568 "PhotoFileFormat.c"
	}
}


void value_take_photo_file_format_driver (GValue* value, gpointer v_object) {
	PhotoFileFormatDriver* old;
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_FORMAT_DRIVER));
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	old = value->data[0].v_pointer;
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (v_object) {
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_FILE_FORMAT_DRIVER));
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		value->data[0].v_pointer = v_object;
#line 2587 "PhotoFileFormat.c"
	} else {
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		value->data[0].v_pointer = NULL;
#line 2591 "PhotoFileFormat.c"
	}
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (old) {
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		photo_file_format_driver_unref (old);
#line 2597 "PhotoFileFormat.c"
	}
}


static void photo_file_format_driver_class_init (PhotoFileFormatDriverClass * klass) {
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	photo_file_format_driver_parent_class = g_type_class_peek_parent (klass);
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	((PhotoFileFormatDriverClass *) klass)->finalize = photo_file_format_driver_finalize;
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	((PhotoFileFormatDriverClass *) klass)->get_properties = photo_file_format_driver_real_get_properties;
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	((PhotoFileFormatDriverClass *) klass)->create_reader = photo_file_format_driver_real_create_reader;
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	((PhotoFileFormatDriverClass *) klass)->create_metadata = photo_file_format_driver_real_create_metadata;
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	((PhotoFileFormatDriverClass *) klass)->can_write_image = photo_file_format_driver_real_can_write_image;
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	((PhotoFileFormatDriverClass *) klass)->can_write_metadata = photo_file_format_driver_real_can_write_metadata;
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	((PhotoFileFormatDriverClass *) klass)->create_writer = photo_file_format_driver_real_create_writer;
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	((PhotoFileFormatDriverClass *) klass)->create_metadata_writer = photo_file_format_driver_real_create_metadata_writer;
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	((PhotoFileFormatDriverClass *) klass)->create_sniffer = photo_file_format_driver_real_create_sniffer;
#line 2623 "PhotoFileFormat.c"
}


static void photo_file_format_driver_instance_init (PhotoFileFormatDriver * self) {
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	self->ref_count = 1;
#line 2630 "PhotoFileFormat.c"
}


static void photo_file_format_driver_finalize (PhotoFileFormatDriver* obj) {
	PhotoFileFormatDriver * self;
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_FILE_FORMAT_DRIVER, PhotoFileFormatDriver);
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_signal_handlers_destroy (self);
#line 2640 "PhotoFileFormat.c"
}


GType photo_file_format_driver_get_type (void) {
	static volatile gsize photo_file_format_driver_type_id__volatile = 0;
	if (g_once_init_enter (&photo_file_format_driver_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_photo_file_format_driver_init, value_photo_file_format_driver_free_value, value_photo_file_format_driver_copy_value, value_photo_file_format_driver_peek_pointer, "p", value_photo_file_format_driver_collect_value, "p", value_photo_file_format_driver_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PhotoFileFormatDriverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_file_format_driver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoFileFormatDriver), 0, (GInstanceInitFunc) photo_file_format_driver_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType photo_file_format_driver_type_id;
		photo_file_format_driver_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoFileFormatDriver", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&photo_file_format_driver_type_id__volatile, photo_file_format_driver_type_id);
	}
	return photo_file_format_driver_type_id__volatile;
}


gpointer photo_file_format_driver_ref (gpointer instance) {
	PhotoFileFormatDriver* self;
	self = instance;
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_atomic_int_inc (&self->ref_count);
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return instance;
#line 2665 "PhotoFileFormat.c"
}


void photo_file_format_driver_unref (gpointer instance) {
	PhotoFileFormatDriver* self;
	self = instance;
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		PHOTO_FILE_FORMAT_DRIVER_GET_CLASS (self)->finalize (self);
#line 344 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2678 "PhotoFileFormat.c"
	}
}


GType photo_file_format_flags_get_type (void) {
	static volatile gsize photo_file_format_flags_type_id__volatile = 0;
	if (g_once_init_enter (&photo_file_format_flags_type_id__volatile)) {
		static const GEnumValue values[] = {{PHOTO_FILE_FORMAT_FLAGS_NONE, "PHOTO_FILE_FORMAT_FLAGS_NONE", "none"}, {0, NULL, NULL}};
		GType photo_file_format_flags_type_id;
		photo_file_format_flags_type_id = g_enum_register_static ("PhotoFileFormatFlags", values);
		g_once_init_leave (&photo_file_format_flags_type_id__volatile, photo_file_format_flags_type_id);
	}
	return photo_file_format_flags_type_id__volatile;
}


static PhotoFileFormat photo_file_format_properties_real_get_file_format (PhotoFileFormatProperties* self) {
#line 374 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_critical ("Type `%s' does not implement abstract method `photo_file_format_properties_get_file_format'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 374 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return 0;
#line 2700 "PhotoFileFormat.c"
}


PhotoFileFormat photo_file_format_properties_get_file_format (PhotoFileFormatProperties* self) {
#line 374 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_val_if_fail (IS_PHOTO_FILE_FORMAT_PROPERTIES (self), 0);
#line 374 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return PHOTO_FILE_FORMAT_PROPERTIES_GET_CLASS (self)->get_file_format (self);
#line 2709 "PhotoFileFormat.c"
}


static PhotoFileFormatFlags photo_file_format_properties_real_get_flags (PhotoFileFormatProperties* self) {
#line 376 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_critical ("Type `%s' does not implement abstract method `photo_file_format_properties_get_flags'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 376 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return 0;
#line 2718 "PhotoFileFormat.c"
}


PhotoFileFormatFlags photo_file_format_properties_get_flags (PhotoFileFormatProperties* self) {
#line 376 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_val_if_fail (IS_PHOTO_FILE_FORMAT_PROPERTIES (self), 0);
#line 376 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return PHOTO_FILE_FORMAT_PROPERTIES_GET_CLASS (self)->get_flags (self);
#line 2727 "PhotoFileFormat.c"
}


static gboolean photo_file_format_properties_real_is_recognized_extension (PhotoFileFormatProperties* self, const gchar* ext) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
#line 380 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_val_if_fail (ext != NULL, FALSE);
#line 381 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0_ = ext;
#line 381 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp2_ = photo_file_format_properties_get_known_extensions (self, &_tmp1_);
#line 381 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp3_ = _tmp2_;
#line 381 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp3__length1 = _tmp1_;
#line 381 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp4_ = is_in_ci_array (_tmp0_, _tmp3_, _tmp1_);
#line 381 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp5_ = _tmp4_;
#line 381 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
#line 381 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	result = _tmp5_;
#line 381 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return result;
#line 2760 "PhotoFileFormat.c"
}


gboolean photo_file_format_properties_is_recognized_extension (PhotoFileFormatProperties* self, const gchar* ext) {
#line 380 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_val_if_fail (IS_PHOTO_FILE_FORMAT_PROPERTIES (self), FALSE);
#line 380 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return PHOTO_FILE_FORMAT_PROPERTIES_GET_CLASS (self)->is_recognized_extension (self, ext);
#line 2769 "PhotoFileFormat.c"
}


static gchar* photo_file_format_properties_real_get_default_extension (PhotoFileFormatProperties* self) {
#line 384 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_critical ("Type `%s' does not implement abstract method `photo_file_format_properties_get_default_extension'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 384 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return NULL;
#line 2778 "PhotoFileFormat.c"
}


gchar* photo_file_format_properties_get_default_extension (PhotoFileFormatProperties* self) {
#line 384 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_val_if_fail (IS_PHOTO_FILE_FORMAT_PROPERTIES (self), NULL);
#line 384 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return PHOTO_FILE_FORMAT_PROPERTIES_GET_CLASS (self)->get_default_extension (self);
#line 2787 "PhotoFileFormat.c"
}


static gchar** photo_file_format_properties_real_get_known_extensions (PhotoFileFormatProperties* self, int* result_length1) {
#line 386 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_critical ("Type `%s' does not implement abstract method `photo_file_format_properties_get_known_extensions'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 386 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return NULL;
#line 2796 "PhotoFileFormat.c"
}


gchar** photo_file_format_properties_get_known_extensions (PhotoFileFormatProperties* self, int* result_length1) {
#line 386 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_val_if_fail (IS_PHOTO_FILE_FORMAT_PROPERTIES (self), NULL);
#line 386 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return PHOTO_FILE_FORMAT_PROPERTIES_GET_CLASS (self)->get_known_extensions (self, result_length1);
#line 2805 "PhotoFileFormat.c"
}


static gchar* photo_file_format_properties_real_get_default_mime_type (PhotoFileFormatProperties* self) {
#line 388 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_critical ("Type `%s' does not implement abstract method `photo_file_format_properties_get_default_mime_type'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 388 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return NULL;
#line 2814 "PhotoFileFormat.c"
}


gchar* photo_file_format_properties_get_default_mime_type (PhotoFileFormatProperties* self) {
#line 388 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_val_if_fail (IS_PHOTO_FILE_FORMAT_PROPERTIES (self), NULL);
#line 388 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return PHOTO_FILE_FORMAT_PROPERTIES_GET_CLASS (self)->get_default_mime_type (self);
#line 2823 "PhotoFileFormat.c"
}


static gchar** photo_file_format_properties_real_get_mime_types (PhotoFileFormatProperties* self, int* result_length1) {
#line 390 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_critical ("Type `%s' does not implement abstract method `photo_file_format_properties_get_mime_types'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 390 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return NULL;
#line 2832 "PhotoFileFormat.c"
}


gchar** photo_file_format_properties_get_mime_types (PhotoFileFormatProperties* self, int* result_length1) {
#line 390 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_val_if_fail (IS_PHOTO_FILE_FORMAT_PROPERTIES (self), NULL);
#line 390 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return PHOTO_FILE_FORMAT_PROPERTIES_GET_CLASS (self)->get_mime_types (self, result_length1);
#line 2841 "PhotoFileFormat.c"
}


static gchar* photo_file_format_properties_real_get_user_visible_name (PhotoFileFormatProperties* self) {
#line 397 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_critical ("Type `%s' does not implement abstract method `photo_file_format_properties_get_user_visible_name'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 397 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return NULL;
#line 2850 "PhotoFileFormat.c"
}


gchar* photo_file_format_properties_get_user_visible_name (PhotoFileFormatProperties* self) {
#line 397 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_val_if_fail (IS_PHOTO_FILE_FORMAT_PROPERTIES (self), NULL);
#line 397 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return PHOTO_FILE_FORMAT_PROPERTIES_GET_CLASS (self)->get_user_visible_name (self);
#line 2859 "PhotoFileFormat.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 405 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return self ? g_object_ref (self) : NULL;
#line 2866 "PhotoFileFormat.c"
}


GFile* photo_file_format_properties_convert_file_extension (PhotoFileFormatProperties* self, GFile* file) {
	GFile* result = NULL;
	gchar* name = NULL;
	gchar* ext = NULL;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_ = NULL;
	GFile* _tmp11_ = NULL;
	GFile* _tmp12_ = NULL;
	GFile* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	GFile* _tmp19_ = NULL;
	GFile* _tmp20_ = NULL;
#line 401 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_val_if_fail (IS_PHOTO_FILE_FORMAT_PROPERTIES (self), NULL);
#line 401 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 403 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp0_ = file;
#line 403 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp1_ = g_file_get_basename (_tmp0_);
#line 403 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp2_ = _tmp1_;
#line 403 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	disassemble_filename (_tmp2_, &_tmp3_, &_tmp4_);
#line 403 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_g_free0 (name);
#line 403 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	name = _tmp3_;
#line 403 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_g_free0 (ext);
#line 403 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	ext = _tmp4_;
#line 403 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_g_free0 (_tmp2_);
#line 404 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp6_ = ext;
#line 404 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (_tmp6_ != NULL) {
#line 2917 "PhotoFileFormat.c"
		const gchar* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
#line 404 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		_tmp7_ = ext;
#line 404 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		_tmp8_ = photo_file_format_properties_is_recognized_extension (self, _tmp7_);
#line 404 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		_tmp5_ = _tmp8_;
#line 2926 "PhotoFileFormat.c"
	} else {
#line 404 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		_tmp5_ = FALSE;
#line 2930 "PhotoFileFormat.c"
	}
#line 404 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (_tmp5_) {
#line 2934 "PhotoFileFormat.c"
		GFile* _tmp9_ = NULL;
		GFile* _tmp10_ = NULL;
#line 405 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		_tmp9_ = file;
#line 405 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		_tmp10_ = _g_object_ref0 (_tmp9_);
#line 405 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		result = _tmp10_;
#line 405 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		_g_free0 (ext);
#line 405 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		_g_free0 (name);
#line 405 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		return result;
#line 2949 "PhotoFileFormat.c"
	}
#line 407 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp11_ = file;
#line 407 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp12_ = g_file_get_parent (_tmp11_);
#line 407 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp13_ = _tmp12_;
#line 407 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp14_ = name;
#line 407 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp15_ = photo_file_format_properties_get_default_extension (self);
#line 407 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp16_ = _tmp15_;
#line 407 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp17_ = g_strdup_printf ("%s.%s", _tmp14_, _tmp16_);
#line 407 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp18_ = _tmp17_;
#line 407 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp19_ = g_file_get_child (_tmp13_, _tmp18_);
#line 407 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_tmp20_ = _tmp19_;
#line 407 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_g_free0 (_tmp18_);
#line 407 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_g_free0 (_tmp16_);
#line 407 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_g_object_unref0 (_tmp13_);
#line 407 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	result = _tmp20_;
#line 407 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_g_free0 (ext);
#line 407 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	_g_free0 (name);
#line 407 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return result;
#line 2985 "PhotoFileFormat.c"
}


PhotoFileFormatProperties* photo_file_format_properties_construct (GType object_type) {
	PhotoFileFormatProperties* self = NULL;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	self = (PhotoFileFormatProperties*) g_type_create_instance (object_type);
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return self;
#line 2995 "PhotoFileFormat.c"
}


static void value_photo_file_format_properties_init (GValue* value) {
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	value->data[0].v_pointer = NULL;
#line 3002 "PhotoFileFormat.c"
}


static void value_photo_file_format_properties_free_value (GValue* value) {
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (value->data[0].v_pointer) {
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		photo_file_format_properties_unref (value->data[0].v_pointer);
#line 3011 "PhotoFileFormat.c"
	}
}


static void value_photo_file_format_properties_copy_value (const GValue* src_value, GValue* dest_value) {
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (src_value->data[0].v_pointer) {
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		dest_value->data[0].v_pointer = photo_file_format_properties_ref (src_value->data[0].v_pointer);
#line 3021 "PhotoFileFormat.c"
	} else {
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3025 "PhotoFileFormat.c"
	}
}


static gpointer value_photo_file_format_properties_peek_pointer (const GValue* value) {
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return value->data[0].v_pointer;
#line 3033 "PhotoFileFormat.c"
}


static gchar* value_photo_file_format_properties_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (collect_values[0].v_pointer) {
#line 3040 "PhotoFileFormat.c"
		PhotoFileFormatProperties* object;
		object = collect_values[0].v_pointer;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		if (object->parent_instance.g_class == NULL) {
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3047 "PhotoFileFormat.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3051 "PhotoFileFormat.c"
		}
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		value->data[0].v_pointer = photo_file_format_properties_ref (object);
#line 3055 "PhotoFileFormat.c"
	} else {
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		value->data[0].v_pointer = NULL;
#line 3059 "PhotoFileFormat.c"
	}
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return NULL;
#line 3063 "PhotoFileFormat.c"
}


static gchar* value_photo_file_format_properties_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PhotoFileFormatProperties** object_p;
	object_p = collect_values[0].v_pointer;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (!object_p) {
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3074 "PhotoFileFormat.c"
	}
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (!value->data[0].v_pointer) {
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		*object_p = NULL;
#line 3080 "PhotoFileFormat.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		*object_p = value->data[0].v_pointer;
#line 3084 "PhotoFileFormat.c"
	} else {
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		*object_p = photo_file_format_properties_ref (value->data[0].v_pointer);
#line 3088 "PhotoFileFormat.c"
	}
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return NULL;
#line 3092 "PhotoFileFormat.c"
}


GParamSpec* param_spec_photo_file_format_properties (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPhotoFileFormatProperties* spec;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PHOTO_FILE_FORMAT_PROPERTIES), NULL);
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return G_PARAM_SPEC (spec);
#line 3106 "PhotoFileFormat.c"
}


gpointer value_get_photo_file_format_properties (const GValue* value) {
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_FORMAT_PROPERTIES), NULL);
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return value->data[0].v_pointer;
#line 3115 "PhotoFileFormat.c"
}


void value_set_photo_file_format_properties (GValue* value, gpointer v_object) {
	PhotoFileFormatProperties* old;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_FORMAT_PROPERTIES));
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	old = value->data[0].v_pointer;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (v_object) {
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_FILE_FORMAT_PROPERTIES));
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		value->data[0].v_pointer = v_object;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		photo_file_format_properties_ref (value->data[0].v_pointer);
#line 3135 "PhotoFileFormat.c"
	} else {
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		value->data[0].v_pointer = NULL;
#line 3139 "PhotoFileFormat.c"
	}
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (old) {
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		photo_file_format_properties_unref (old);
#line 3145 "PhotoFileFormat.c"
	}
}


void value_take_photo_file_format_properties (GValue* value, gpointer v_object) {
	PhotoFileFormatProperties* old;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_FORMAT_PROPERTIES));
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	old = value->data[0].v_pointer;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (v_object) {
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_FILE_FORMAT_PROPERTIES));
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		value->data[0].v_pointer = v_object;
#line 3164 "PhotoFileFormat.c"
	} else {
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		value->data[0].v_pointer = NULL;
#line 3168 "PhotoFileFormat.c"
	}
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (old) {
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		photo_file_format_properties_unref (old);
#line 3174 "PhotoFileFormat.c"
	}
}


static void photo_file_format_properties_class_init (PhotoFileFormatPropertiesClass * klass) {
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	photo_file_format_properties_parent_class = g_type_class_peek_parent (klass);
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	((PhotoFileFormatPropertiesClass *) klass)->finalize = photo_file_format_properties_finalize;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	((PhotoFileFormatPropertiesClass *) klass)->get_file_format = photo_file_format_properties_real_get_file_format;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	((PhotoFileFormatPropertiesClass *) klass)->get_flags = photo_file_format_properties_real_get_flags;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	((PhotoFileFormatPropertiesClass *) klass)->is_recognized_extension = photo_file_format_properties_real_is_recognized_extension;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	((PhotoFileFormatPropertiesClass *) klass)->get_default_extension = photo_file_format_properties_real_get_default_extension;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	((PhotoFileFormatPropertiesClass *) klass)->get_known_extensions = photo_file_format_properties_real_get_known_extensions;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	((PhotoFileFormatPropertiesClass *) klass)->get_default_mime_type = photo_file_format_properties_real_get_default_mime_type;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	((PhotoFileFormatPropertiesClass *) klass)->get_mime_types = photo_file_format_properties_real_get_mime_types;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	((PhotoFileFormatPropertiesClass *) klass)->get_user_visible_name = photo_file_format_properties_real_get_user_visible_name;
#line 3200 "PhotoFileFormat.c"
}


static void photo_file_format_properties_instance_init (PhotoFileFormatProperties * self) {
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	self->ref_count = 1;
#line 3207 "PhotoFileFormat.c"
}


static void photo_file_format_properties_finalize (PhotoFileFormatProperties* obj) {
	PhotoFileFormatProperties * self;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatProperties);
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_signal_handlers_destroy (self);
#line 3217 "PhotoFileFormat.c"
}


GType photo_file_format_properties_get_type (void) {
	static volatile gsize photo_file_format_properties_type_id__volatile = 0;
	if (g_once_init_enter (&photo_file_format_properties_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_photo_file_format_properties_init, value_photo_file_format_properties_free_value, value_photo_file_format_properties_copy_value, value_photo_file_format_properties_peek_pointer, "p", value_photo_file_format_properties_collect_value, "p", value_photo_file_format_properties_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PhotoFileFormatPropertiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_file_format_properties_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoFileFormatProperties), 0, (GInstanceInitFunc) photo_file_format_properties_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType photo_file_format_properties_type_id;
		photo_file_format_properties_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoFileFormatProperties", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&photo_file_format_properties_type_id__volatile, photo_file_format_properties_type_id);
	}
	return photo_file_format_properties_type_id__volatile;
}


gpointer photo_file_format_properties_ref (gpointer instance) {
	PhotoFileFormatProperties* self;
	self = instance;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	g_atomic_int_inc (&self->ref_count);
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	return instance;
#line 3242 "PhotoFileFormat.c"
}


void photo_file_format_properties_unref (gpointer instance) {
	PhotoFileFormatProperties* self;
	self = instance;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		PHOTO_FILE_FORMAT_PROPERTIES_GET_CLASS (self)->finalize (self);
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoFileFormat.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3255 "PhotoFileFormat.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



