/* DataImportsInterfaces.c generated by valac 0.34.2, the Vala compiler
 * generated from DataImportsInterfaces.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <time.h>


#define SPIT_DATA_IMPORTS_TYPE_DATA_IMPORTER (spit_data_imports_data_importer_get_type ())
#define SPIT_DATA_IMPORTS_DATA_IMPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_DATA_IMPORTS_TYPE_DATA_IMPORTER, SpitDataImportsDataImporter))
#define SPIT_DATA_IMPORTS_IS_DATA_IMPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_DATA_IMPORTS_TYPE_DATA_IMPORTER))
#define SPIT_DATA_IMPORTS_DATA_IMPORTER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SPIT_DATA_IMPORTS_TYPE_DATA_IMPORTER, SpitDataImportsDataImporterIface))

typedef struct _SpitDataImportsDataImporter SpitDataImportsDataImporter;
typedef struct _SpitDataImportsDataImporterIface SpitDataImportsDataImporterIface;

#define SPIT_TYPE_PLUGGABLE (spit_pluggable_get_type ())
#define SPIT_PLUGGABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_TYPE_PLUGGABLE, SpitPluggable))
#define SPIT_IS_PLUGGABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_TYPE_PLUGGABLE))
#define SPIT_PLUGGABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SPIT_TYPE_PLUGGABLE, SpitPluggableIface))

typedef struct _SpitPluggable SpitPluggable;
typedef struct _SpitPluggableIface SpitPluggableIface;

#define SPIT_TYPE_PLUGGABLE_INFO (spit_pluggable_info_get_type ())
typedef struct _SpitPluggableInfo SpitPluggableInfo;

#define SPIT_DATA_IMPORTS_TYPE_SERVICE (spit_data_imports_service_get_type ())
#define SPIT_DATA_IMPORTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_DATA_IMPORTS_TYPE_SERVICE, SpitDataImportsService))
#define SPIT_DATA_IMPORTS_IS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_DATA_IMPORTS_TYPE_SERVICE))
#define SPIT_DATA_IMPORTS_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SPIT_DATA_IMPORTS_TYPE_SERVICE, SpitDataImportsServiceIface))

typedef struct _SpitDataImportsService SpitDataImportsService;
typedef struct _SpitDataImportsServiceIface SpitDataImportsServiceIface;

#define SPIT_TYPE_HOST_INTERFACE (spit_host_interface_get_type ())
#define SPIT_HOST_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_TYPE_HOST_INTERFACE, SpitHostInterface))
#define SPIT_IS_HOST_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_TYPE_HOST_INTERFACE))
#define SPIT_HOST_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SPIT_TYPE_HOST_INTERFACE, SpitHostInterfaceIface))

typedef struct _SpitHostInterface SpitHostInterface;
typedef struct _SpitHostInterfaceIface SpitHostInterfaceIface;

#define SPIT_DATA_IMPORTS_TYPE_PLUGIN_HOST (spit_data_imports_plugin_host_get_type ())
#define SPIT_DATA_IMPORTS_PLUGIN_HOST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_DATA_IMPORTS_TYPE_PLUGIN_HOST, SpitDataImportsPluginHost))
#define SPIT_DATA_IMPORTS_IS_PLUGIN_HOST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_DATA_IMPORTS_TYPE_PLUGIN_HOST))
#define SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SPIT_DATA_IMPORTS_TYPE_PLUGIN_HOST, SpitDataImportsPluginHostIface))

typedef struct _SpitDataImportsPluginHost SpitDataImportsPluginHost;
typedef struct _SpitDataImportsPluginHostIface SpitDataImportsPluginHostIface;

#define SPIT_DATA_IMPORTS_TYPE_DIALOG_PANE (spit_data_imports_dialog_pane_get_type ())
#define SPIT_DATA_IMPORTS_DIALOG_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_DATA_IMPORTS_TYPE_DIALOG_PANE, SpitDataImportsDialogPane))
#define SPIT_DATA_IMPORTS_IS_DIALOG_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_DATA_IMPORTS_TYPE_DIALOG_PANE))
#define SPIT_DATA_IMPORTS_DIALOG_PANE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SPIT_DATA_IMPORTS_TYPE_DIALOG_PANE, SpitDataImportsDialogPaneIface))

typedef struct _SpitDataImportsDialogPane SpitDataImportsDialogPane;
typedef struct _SpitDataImportsDialogPaneIface SpitDataImportsDialogPaneIface;

#define SPIT_DATA_IMPORTS_DIALOG_PANE_TYPE_GEOMETRY_OPTIONS (spit_data_imports_dialog_pane_geometry_options_get_type ())

#define SPIT_DATA_IMPORTS_PLUGIN_HOST_TYPE_BUTTON_MODE (spit_data_imports_plugin_host_button_mode_get_type ())

#define SPIT_DATA_IMPORTS_TYPE_IMPORTABLE_LIBRARY (spit_data_imports_importable_library_get_type ())
#define SPIT_DATA_IMPORTS_IMPORTABLE_LIBRARY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_DATA_IMPORTS_TYPE_IMPORTABLE_LIBRARY, SpitDataImportsImportableLibrary))
#define SPIT_DATA_IMPORTS_IS_IMPORTABLE_LIBRARY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_DATA_IMPORTS_TYPE_IMPORTABLE_LIBRARY))
#define SPIT_DATA_IMPORTS_IMPORTABLE_LIBRARY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SPIT_DATA_IMPORTS_TYPE_IMPORTABLE_LIBRARY, SpitDataImportsImportableLibraryIface))

typedef struct _SpitDataImportsImportableLibrary SpitDataImportsImportableLibrary;
typedef struct _SpitDataImportsImportableLibraryIface SpitDataImportsImportableLibraryIface;

#define SPIT_DATA_IMPORTS_TYPE_IMPORTABLE_MEDIA_ITEM (spit_data_imports_importable_media_item_get_type ())
#define SPIT_DATA_IMPORTS_IMPORTABLE_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_DATA_IMPORTS_TYPE_IMPORTABLE_MEDIA_ITEM, SpitDataImportsImportableMediaItem))
#define SPIT_DATA_IMPORTS_IS_IMPORTABLE_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_DATA_IMPORTS_TYPE_IMPORTABLE_MEDIA_ITEM))
#define SPIT_DATA_IMPORTS_IMPORTABLE_MEDIA_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SPIT_DATA_IMPORTS_TYPE_IMPORTABLE_MEDIA_ITEM, SpitDataImportsImportableMediaItemIface))

typedef struct _SpitDataImportsImportableMediaItem SpitDataImportsImportableMediaItem;
typedef struct _SpitDataImportsImportableMediaItemIface SpitDataImportsImportableMediaItemIface;

#define SPIT_DATA_IMPORTS_TYPE_IMPORTABLE_TAG (spit_data_imports_importable_tag_get_type ())
#define SPIT_DATA_IMPORTS_IMPORTABLE_TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_DATA_IMPORTS_TYPE_IMPORTABLE_TAG, SpitDataImportsImportableTag))
#define SPIT_DATA_IMPORTS_IS_IMPORTABLE_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_DATA_IMPORTS_TYPE_IMPORTABLE_TAG))
#define SPIT_DATA_IMPORTS_IMPORTABLE_TAG_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SPIT_DATA_IMPORTS_TYPE_IMPORTABLE_TAG, SpitDataImportsImportableTagIface))

typedef struct _SpitDataImportsImportableTag SpitDataImportsImportableTag;
typedef struct _SpitDataImportsImportableTagIface SpitDataImportsImportableTagIface;

#define SPIT_DATA_IMPORTS_TYPE_IMPORTABLE_EVENT (spit_data_imports_importable_event_get_type ())
#define SPIT_DATA_IMPORTS_IMPORTABLE_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_DATA_IMPORTS_TYPE_IMPORTABLE_EVENT, SpitDataImportsImportableEvent))
#define SPIT_DATA_IMPORTS_IS_IMPORTABLE_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_DATA_IMPORTS_TYPE_IMPORTABLE_EVENT))
#define SPIT_DATA_IMPORTS_IMPORTABLE_EVENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SPIT_DATA_IMPORTS_TYPE_IMPORTABLE_EVENT, SpitDataImportsImportableEventIface))

typedef struct _SpitDataImportsImportableEvent SpitDataImportsImportableEvent;
typedef struct _SpitDataImportsImportableEventIface SpitDataImportsImportableEventIface;

#define SPIT_DATA_IMPORTS_TYPE_IMPORTABLE_RATING (spit_data_imports_importable_rating_get_type ())
#define SPIT_DATA_IMPORTS_IMPORTABLE_RATING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_DATA_IMPORTS_TYPE_IMPORTABLE_RATING, SpitDataImportsImportableRating))
#define SPIT_DATA_IMPORTS_IS_IMPORTABLE_RATING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_DATA_IMPORTS_TYPE_IMPORTABLE_RATING))
#define SPIT_DATA_IMPORTS_IMPORTABLE_RATING_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SPIT_DATA_IMPORTS_TYPE_IMPORTABLE_RATING, SpitDataImportsImportableRatingIface))

typedef struct _SpitDataImportsImportableRating SpitDataImportsImportableRating;
typedef struct _SpitDataImportsImportableRatingIface SpitDataImportsImportableRatingIface;

/**
 * The error domain for alien databases
 */
typedef enum  {
	SPIT_DATA_IMPORTS_DATA_IMPORT_ERROR_UNSUPPORTED_VERSION
} SpitDataImportsDataImportError;
#define SPIT_DATA_IMPORTS_DATA_IMPORT_ERROR spit_data_imports_data_import_error_quark ()
struct _SpitPluggableInfo {
	gchar* version;
	gchar* brief_description;
	gchar* authors;
	gchar* copyright;
	gchar* license;
	gboolean is_license_wordwrapped;
	gchar* website_url;
	gchar* website_name;
	gchar* translators;
	GdkPixbuf** icons;
	gint icons_length1;
};

struct _SpitPluggableIface {
	GTypeInterface parent_iface;
	gint (*get_pluggable_interface) (SpitPluggable* self, gint min_host_interface, gint max_host_interface);
	const gchar* (*get_id) (SpitPluggable* self);
	const gchar* (*get_pluggable_name) (SpitPluggable* self);
	void (*get_info) (SpitPluggable* self, SpitPluggableInfo* info);
	void (*activation) (SpitPluggable* self, gboolean enabled);
	void (*reserved0) (SpitPluggable* self);
	void (*reserved1) (SpitPluggable* self);
	void (*reserved2) (SpitPluggable* self);
	void (*reserved3) (SpitPluggable* self);
	void (*reserved4) (SpitPluggable* self);
	void (*reserved5) (SpitPluggable* self);
	void (*reserved6) (SpitPluggable* self);
	void (*reserved7) (SpitPluggable* self);
};

struct _SpitHostInterfaceIface {
	GTypeInterface parent_iface;
	GFile* (*get_module_file) (SpitHostInterface* self);
	gboolean (*get_config_bool) (SpitHostInterface* self, const gchar* key, gboolean def);
	void (*set_config_bool) (SpitHostInterface* self, const gchar* key, gboolean val);
	gint (*get_config_int) (SpitHostInterface* self, const gchar* key, gint def);
	void (*set_config_int) (SpitHostInterface* self, const gchar* key, gint val);
	gchar* (*get_config_string) (SpitHostInterface* self, const gchar* key, const gchar* def);
	void (*set_config_string) (SpitHostInterface* self, const gchar* key, const gchar* val);
	gdouble (*get_config_double) (SpitHostInterface* self, const gchar* key, gdouble def);
	void (*set_config_double) (SpitHostInterface* self, const gchar* key, gdouble val);
	void (*unset_config_key) (SpitHostInterface* self, const gchar* key);
	void (*reserved0) (SpitHostInterface* self);
	void (*reserved1) (SpitHostInterface* self);
	void (*reserved2) (SpitHostInterface* self);
	void (*reserved3) (SpitHostInterface* self);
	void (*reserved4) (SpitHostInterface* self);
	void (*reserved5) (SpitHostInterface* self);
	void (*reserved6) (SpitHostInterface* self);
	void (*reserved7) (SpitHostInterface* self);
};

typedef enum  {
	SPIT_DATA_IMPORTS_DIALOG_PANE_GEOMETRY_OPTIONS_NONE = 0,
	SPIT_DATA_IMPORTS_DIALOG_PANE_GEOMETRY_OPTIONS_EXTENDED_SIZE = 1 << 0,
	SPIT_DATA_IMPORTS_DIALOG_PANE_GEOMETRY_OPTIONS_RESIZABLE = 1 << 1,
	SPIT_DATA_IMPORTS_DIALOG_PANE_GEOMETRY_OPTIONS_COLOSSAL_SIZE = 1 << 2
} SpitDataImportsDialogPaneGeometryOptions;

struct _SpitDataImportsDialogPaneIface {
	GTypeInterface parent_iface;
	GtkWidget* (*get_widget) (SpitDataImportsDialogPane* self);
	SpitDataImportsDialogPaneGeometryOptions (*get_preferred_geometry) (SpitDataImportsDialogPane* self);
	void (*on_pane_installed) (SpitDataImportsDialogPane* self);
	void (*on_pane_uninstalled) (SpitDataImportsDialogPane* self);
	void (*reserved0) (SpitDataImportsDialogPane* self);
	void (*reserved1) (SpitDataImportsDialogPane* self);
	void (*reserved2) (SpitDataImportsDialogPane* self);
	void (*reserved3) (SpitDataImportsDialogPane* self);
	void (*reserved4) (SpitDataImportsDialogPane* self);
	void (*reserved5) (SpitDataImportsDialogPane* self);
	void (*reserved6) (SpitDataImportsDialogPane* self);
	void (*reserved7) (SpitDataImportsDialogPane* self);
};

typedef enum  {
	SPIT_DATA_IMPORTS_PLUGIN_HOST_BUTTON_MODE_CLOSE = 0,
	SPIT_DATA_IMPORTS_PLUGIN_HOST_BUTTON_MODE_CANCEL = 1
} SpitDataImportsPluginHostButtonMode;

struct _SpitDataImportsImportableLibraryIface {
	GTypeInterface parent_iface;
	gchar* (*get_display_name) (SpitDataImportsImportableLibrary* self);
};

struct _SpitDataImportsImportableTagIface {
	GTypeInterface parent_iface;
	gchar* (*get_name) (SpitDataImportsImportableTag* self);
	SpitDataImportsImportableTag* (*get_parent) (SpitDataImportsImportableTag* self);
};

struct _SpitDataImportsImportableEventIface {
	GTypeInterface parent_iface;
	gchar* (*get_name) (SpitDataImportsImportableEvent* self);
};

struct _SpitDataImportsImportableRatingIface {
	GTypeInterface parent_iface;
	gboolean (*is_unrated) (SpitDataImportsImportableRating* self);
	gboolean (*is_rejected) (SpitDataImportsImportableRating* self);
	gint (*get_value) (SpitDataImportsImportableRating* self);
};

struct _SpitDataImportsImportableMediaItemIface {
	GTypeInterface parent_iface;
	SpitDataImportsImportableTag** (*get_tags) (SpitDataImportsImportableMediaItem* self, int* result_length1);
	SpitDataImportsImportableEvent* (*get_event) (SpitDataImportsImportableMediaItem* self);
	SpitDataImportsImportableRating* (*get_rating) (SpitDataImportsImportableMediaItem* self);
	gchar* (*get_title) (SpitDataImportsImportableMediaItem* self);
	gchar* (*get_folder_path) (SpitDataImportsImportableMediaItem* self);
	gchar* (*get_filename) (SpitDataImportsImportableMediaItem* self);
	time_t* (*get_exposure_time) (SpitDataImportsImportableMediaItem* self);
};

typedef void (*SpitDataImportsImportedItemsCountCallback) (gint imported_items_count, void* user_data);
struct _SpitDataImportsPluginHostIface {
	GTypeInterface parent_iface;
	void (*post_error) (SpitDataImportsPluginHost* self, GError* err);
	void (*post_error_message) (SpitDataImportsPluginHost* self, const gchar* msg);
	void (*start_importing) (SpitDataImportsPluginHost* self);
	void (*stop_importing) (SpitDataImportsPluginHost* self);
	SpitDataImportsDataImporter* (*get_data_importer) (SpitDataImportsPluginHost* self);
	void (*install_dialog_pane) (SpitDataImportsPluginHost* self, SpitDataImportsDialogPane* pane, SpitDataImportsPluginHostButtonMode mode);
	void (*install_static_message_pane) (SpitDataImportsPluginHost* self, const gchar* message, SpitDataImportsPluginHostButtonMode mode);
	void (*install_library_selection_pane) (SpitDataImportsPluginHost* self, const gchar* welcome_message, SpitDataImportsImportableLibrary** discovered_libraries, int discovered_libraries_length1, const gchar* file_select_label);
	void (*install_import_progress_pane) (SpitDataImportsPluginHost* self, const gchar* message);
	void (*update_import_progress_pane) (SpitDataImportsPluginHost* self, gdouble progress, const gchar* progress_message);
	void (*prepare_media_items_for_import) (SpitDataImportsPluginHost* self, SpitDataImportsImportableMediaItem** items, int items_length1, gdouble progress, gdouble host_progress_delta, const gchar* progress_message);
	void (*finalize_import) (SpitDataImportsPluginHost* self, SpitDataImportsImportedItemsCountCallback report_imported_items_count, void* report_imported_items_count_target, const gchar* finalize_message);
	void (*reserved0) (SpitDataImportsPluginHost* self);
	void (*reserved1) (SpitDataImportsPluginHost* self);
	void (*reserved2) (SpitDataImportsPluginHost* self);
	void (*reserved3) (SpitDataImportsPluginHost* self);
	void (*reserved4) (SpitDataImportsPluginHost* self);
	void (*reserved5) (SpitDataImportsPluginHost* self);
	void (*reserved6) (SpitDataImportsPluginHost* self);
	void (*reserved7) (SpitDataImportsPluginHost* self);
};

struct _SpitDataImportsServiceIface {
	GTypeInterface parent_iface;
	SpitDataImportsDataImporter* (*create_data_importer) (SpitDataImportsService* self, SpitDataImportsPluginHost* host);
	void (*reserved0) (SpitDataImportsService* self);
	void (*reserved1) (SpitDataImportsService* self);
	void (*reserved2) (SpitDataImportsService* self);
	void (*reserved3) (SpitDataImportsService* self);
	void (*reserved4) (SpitDataImportsService* self);
	void (*reserved5) (SpitDataImportsService* self);
	void (*reserved6) (SpitDataImportsService* self);
	void (*reserved7) (SpitDataImportsService* self);
};

struct _SpitDataImportsDataImporterIface {
	GTypeInterface parent_iface;
	SpitDataImportsService* (*get_service) (SpitDataImportsDataImporter* self);
	void (*start) (SpitDataImportsDataImporter* self);
	gboolean (*is_running) (SpitDataImportsDataImporter* self);
	void (*stop) (SpitDataImportsDataImporter* self);
	void (*on_library_selected) (SpitDataImportsDataImporter* self, SpitDataImportsImportableLibrary* library);
	void (*on_file_selected) (SpitDataImportsDataImporter* self, GFile* file);
	void (*reserved0) (SpitDataImportsDataImporter* self);
	void (*reserved1) (SpitDataImportsDataImporter* self);
	void (*reserved2) (SpitDataImportsDataImporter* self);
	void (*reserved3) (SpitDataImportsDataImporter* self);
	void (*reserved4) (SpitDataImportsDataImporter* self);
	void (*reserved5) (SpitDataImportsDataImporter* self);
	void (*reserved6) (SpitDataImportsDataImporter* self);
	void (*reserved7) (SpitDataImportsDataImporter* self);
};



#define SPIT_DATA_IMPORTS_CURRENT_INTERFACE 0
GQuark spit_data_imports_data_import_error_quark (void);
GType spit_pluggable_info_get_type (void) G_GNUC_CONST;
SpitPluggableInfo* spit_pluggable_info_dup (const SpitPluggableInfo* self);
void spit_pluggable_info_free (SpitPluggableInfo* self);
void spit_pluggable_info_copy (const SpitPluggableInfo* self, SpitPluggableInfo* dest);
void spit_pluggable_info_destroy (SpitPluggableInfo* self);
GType spit_pluggable_get_type (void) G_GNUC_CONST;
GType spit_host_interface_get_type (void) G_GNUC_CONST;
GType spit_data_imports_dialog_pane_geometry_options_get_type (void) G_GNUC_CONST;
GType spit_data_imports_dialog_pane_get_type (void) G_GNUC_CONST;
GType spit_data_imports_plugin_host_button_mode_get_type (void) G_GNUC_CONST;
GType spit_data_imports_importable_library_get_type (void) G_GNUC_CONST;
GType spit_data_imports_importable_tag_get_type (void) G_GNUC_CONST;
GType spit_data_imports_importable_event_get_type (void) G_GNUC_CONST;
GType spit_data_imports_importable_rating_get_type (void) G_GNUC_CONST;
GType spit_data_imports_importable_media_item_get_type (void) G_GNUC_CONST;
GType spit_data_imports_plugin_host_get_type (void) G_GNUC_CONST;
GType spit_data_imports_service_get_type (void) G_GNUC_CONST;
GType spit_data_imports_data_importer_get_type (void) G_GNUC_CONST;
SpitDataImportsService* spit_data_imports_data_importer_get_service (SpitDataImportsDataImporter* self);
void spit_data_imports_data_importer_start (SpitDataImportsDataImporter* self);
gboolean spit_data_imports_data_importer_is_running (SpitDataImportsDataImporter* self);
void spit_data_imports_data_importer_stop (SpitDataImportsDataImporter* self);
void spit_data_imports_data_importer_on_library_selected (SpitDataImportsDataImporter* self, SpitDataImportsImportableLibrary* library);
void spit_data_imports_data_importer_on_file_selected (SpitDataImportsDataImporter* self, GFile* file);
void spit_data_imports_data_importer_reserved0 (SpitDataImportsDataImporter* self);
static void spit_data_imports_data_importer_real_reserved0 (SpitDataImportsDataImporter* self);
void spit_data_imports_data_importer_reserved1 (SpitDataImportsDataImporter* self);
static void spit_data_imports_data_importer_real_reserved1 (SpitDataImportsDataImporter* self);
void spit_data_imports_data_importer_reserved2 (SpitDataImportsDataImporter* self);
static void spit_data_imports_data_importer_real_reserved2 (SpitDataImportsDataImporter* self);
void spit_data_imports_data_importer_reserved3 (SpitDataImportsDataImporter* self);
static void spit_data_imports_data_importer_real_reserved3 (SpitDataImportsDataImporter* self);
void spit_data_imports_data_importer_reserved4 (SpitDataImportsDataImporter* self);
static void spit_data_imports_data_importer_real_reserved4 (SpitDataImportsDataImporter* self);
void spit_data_imports_data_importer_reserved5 (SpitDataImportsDataImporter* self);
static void spit_data_imports_data_importer_real_reserved5 (SpitDataImportsDataImporter* self);
void spit_data_imports_data_importer_reserved6 (SpitDataImportsDataImporter* self);
static void spit_data_imports_data_importer_real_reserved6 (SpitDataImportsDataImporter* self);
void spit_data_imports_data_importer_reserved7 (SpitDataImportsDataImporter* self);
static void spit_data_imports_data_importer_real_reserved7 (SpitDataImportsDataImporter* self);
gchar* spit_data_imports_importable_library_get_display_name (SpitDataImportsImportableLibrary* self);
SpitDataImportsImportableTag** spit_data_imports_importable_media_item_get_tags (SpitDataImportsImportableMediaItem* self, int* result_length1);
SpitDataImportsImportableEvent* spit_data_imports_importable_media_item_get_event (SpitDataImportsImportableMediaItem* self);
SpitDataImportsImportableRating* spit_data_imports_importable_media_item_get_rating (SpitDataImportsImportableMediaItem* self);
gchar* spit_data_imports_importable_media_item_get_title (SpitDataImportsImportableMediaItem* self);
gchar* spit_data_imports_importable_media_item_get_folder_path (SpitDataImportsImportableMediaItem* self);
gchar* spit_data_imports_importable_media_item_get_filename (SpitDataImportsImportableMediaItem* self);
time_t* spit_data_imports_importable_media_item_get_exposure_time (SpitDataImportsImportableMediaItem* self);
gchar* spit_data_imports_importable_tag_get_name (SpitDataImportsImportableTag* self);
SpitDataImportsImportableTag* spit_data_imports_importable_tag_get_parent (SpitDataImportsImportableTag* self);
gchar* spit_data_imports_importable_event_get_name (SpitDataImportsImportableEvent* self);
gboolean spit_data_imports_importable_rating_is_unrated (SpitDataImportsImportableRating* self);
gboolean spit_data_imports_importable_rating_is_rejected (SpitDataImportsImportableRating* self);
gint spit_data_imports_importable_rating_get_value (SpitDataImportsImportableRating* self);
GtkWidget* spit_data_imports_dialog_pane_get_widget (SpitDataImportsDialogPane* self);
SpitDataImportsDialogPaneGeometryOptions spit_data_imports_dialog_pane_get_preferred_geometry (SpitDataImportsDialogPane* self);
void spit_data_imports_dialog_pane_on_pane_installed (SpitDataImportsDialogPane* self);
void spit_data_imports_dialog_pane_on_pane_uninstalled (SpitDataImportsDialogPane* self);
void spit_data_imports_dialog_pane_reserved0 (SpitDataImportsDialogPane* self);
static void spit_data_imports_dialog_pane_real_reserved0 (SpitDataImportsDialogPane* self);
void spit_data_imports_dialog_pane_reserved1 (SpitDataImportsDialogPane* self);
static void spit_data_imports_dialog_pane_real_reserved1 (SpitDataImportsDialogPane* self);
void spit_data_imports_dialog_pane_reserved2 (SpitDataImportsDialogPane* self);
static void spit_data_imports_dialog_pane_real_reserved2 (SpitDataImportsDialogPane* self);
void spit_data_imports_dialog_pane_reserved3 (SpitDataImportsDialogPane* self);
static void spit_data_imports_dialog_pane_real_reserved3 (SpitDataImportsDialogPane* self);
void spit_data_imports_dialog_pane_reserved4 (SpitDataImportsDialogPane* self);
static void spit_data_imports_dialog_pane_real_reserved4 (SpitDataImportsDialogPane* self);
void spit_data_imports_dialog_pane_reserved5 (SpitDataImportsDialogPane* self);
static void spit_data_imports_dialog_pane_real_reserved5 (SpitDataImportsDialogPane* self);
void spit_data_imports_dialog_pane_reserved6 (SpitDataImportsDialogPane* self);
static void spit_data_imports_dialog_pane_real_reserved6 (SpitDataImportsDialogPane* self);
void spit_data_imports_dialog_pane_reserved7 (SpitDataImportsDialogPane* self);
static void spit_data_imports_dialog_pane_real_reserved7 (SpitDataImportsDialogPane* self);
void spit_data_imports_plugin_host_post_error (SpitDataImportsPluginHost* self, GError* err);
void spit_data_imports_plugin_host_post_error_message (SpitDataImportsPluginHost* self, const gchar* msg);
void spit_data_imports_plugin_host_start_importing (SpitDataImportsPluginHost* self);
void spit_data_imports_plugin_host_stop_importing (SpitDataImportsPluginHost* self);
SpitDataImportsDataImporter* spit_data_imports_plugin_host_get_data_importer (SpitDataImportsPluginHost* self);
void spit_data_imports_plugin_host_install_dialog_pane (SpitDataImportsPluginHost* self, SpitDataImportsDialogPane* pane, SpitDataImportsPluginHostButtonMode mode);
void spit_data_imports_plugin_host_install_static_message_pane (SpitDataImportsPluginHost* self, const gchar* message, SpitDataImportsPluginHostButtonMode mode);
void spit_data_imports_plugin_host_install_library_selection_pane (SpitDataImportsPluginHost* self, const gchar* welcome_message, SpitDataImportsImportableLibrary** discovered_libraries, int discovered_libraries_length1, const gchar* file_select_label);
void spit_data_imports_plugin_host_install_import_progress_pane (SpitDataImportsPluginHost* self, const gchar* message);
void spit_data_imports_plugin_host_update_import_progress_pane (SpitDataImportsPluginHost* self, gdouble progress, const gchar* progress_message);
void spit_data_imports_plugin_host_prepare_media_items_for_import (SpitDataImportsPluginHost* self, SpitDataImportsImportableMediaItem** items, int items_length1, gdouble progress, gdouble host_progress_delta, const gchar* progress_message);
void spit_data_imports_plugin_host_finalize_import (SpitDataImportsPluginHost* self, SpitDataImportsImportedItemsCountCallback report_imported_items_count, void* report_imported_items_count_target, const gchar* finalize_message);
void spit_data_imports_plugin_host_reserved0 (SpitDataImportsPluginHost* self);
static void spit_data_imports_plugin_host_real_reserved0 (SpitDataImportsPluginHost* self);
void spit_data_imports_plugin_host_reserved1 (SpitDataImportsPluginHost* self);
static void spit_data_imports_plugin_host_real_reserved1 (SpitDataImportsPluginHost* self);
void spit_data_imports_plugin_host_reserved2 (SpitDataImportsPluginHost* self);
static void spit_data_imports_plugin_host_real_reserved2 (SpitDataImportsPluginHost* self);
void spit_data_imports_plugin_host_reserved3 (SpitDataImportsPluginHost* self);
static void spit_data_imports_plugin_host_real_reserved3 (SpitDataImportsPluginHost* self);
void spit_data_imports_plugin_host_reserved4 (SpitDataImportsPluginHost* self);
static void spit_data_imports_plugin_host_real_reserved4 (SpitDataImportsPluginHost* self);
void spit_data_imports_plugin_host_reserved5 (SpitDataImportsPluginHost* self);
static void spit_data_imports_plugin_host_real_reserved5 (SpitDataImportsPluginHost* self);
void spit_data_imports_plugin_host_reserved6 (SpitDataImportsPluginHost* self);
static void spit_data_imports_plugin_host_real_reserved6 (SpitDataImportsPluginHost* self);
void spit_data_imports_plugin_host_reserved7 (SpitDataImportsPluginHost* self);
static void spit_data_imports_plugin_host_real_reserved7 (SpitDataImportsPluginHost* self);
SpitDataImportsDataImporter* spit_data_imports_service_create_data_importer (SpitDataImportsService* self, SpitDataImportsPluginHost* host);
void spit_data_imports_service_reserved0 (SpitDataImportsService* self);
static void spit_data_imports_service_real_reserved0 (SpitDataImportsService* self);
void spit_data_imports_service_reserved1 (SpitDataImportsService* self);
static void spit_data_imports_service_real_reserved1 (SpitDataImportsService* self);
void spit_data_imports_service_reserved2 (SpitDataImportsService* self);
static void spit_data_imports_service_real_reserved2 (SpitDataImportsService* self);
void spit_data_imports_service_reserved3 (SpitDataImportsService* self);
static void spit_data_imports_service_real_reserved3 (SpitDataImportsService* self);
void spit_data_imports_service_reserved4 (SpitDataImportsService* self);
static void spit_data_imports_service_real_reserved4 (SpitDataImportsService* self);
void spit_data_imports_service_reserved5 (SpitDataImportsService* self);
static void spit_data_imports_service_real_reserved5 (SpitDataImportsService* self);
void spit_data_imports_service_reserved6 (SpitDataImportsService* self);
static void spit_data_imports_service_real_reserved6 (SpitDataImportsService* self);
void spit_data_imports_service_reserved7 (SpitDataImportsService* self);
static void spit_data_imports_service_real_reserved7 (SpitDataImportsService* self);


GQuark spit_data_imports_data_import_error_quark (void) {
	return g_quark_from_static_string ("spit_data_imports_data_import_error-quark");
}


/**
     * Returns a {@link Service} object describing the service to which this connects.
     */
SpitDataImportsService* spit_data_imports_data_importer_get_service (SpitDataImportsDataImporter* self) {
#line 53 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORTER (self), NULL);
#line 53 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	return SPIT_DATA_IMPORTS_DATA_IMPORTER_GET_INTERFACE (self)->get_service (self);
#line 434 "DataImportsInterfaces.c"
}


/**
     * Makes this data importer enter the running state and endows it with exclusive access
     * to the shared services provided by the {@link PluginHost}. Through the host’s interface,
     * this data importer can install user interface panes and query configuration information.
     */
void spit_data_imports_data_importer_start (SpitDataImportsDataImporter* self) {
#line 60 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORTER (self));
#line 60 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_DATA_IMPORTER_GET_INTERFACE (self)->start (self);
#line 448 "DataImportsInterfaces.c"
}


/**
     * Returns true if this data importer is in the running state; false otherwise.
     */
gboolean spit_data_imports_data_importer_is_running (SpitDataImportsDataImporter* self) {
#line 65 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORTER (self), FALSE);
#line 65 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	return SPIT_DATA_IMPORTS_DATA_IMPORTER_GET_INTERFACE (self)->is_running (self);
#line 460 "DataImportsInterfaces.c"
}


/**
     * Causes this data importer to enter a non-running state. This data importer should stop all
     * data access operations and cease use of the shared services provided by the {@link PluginHost}.
     */
void spit_data_imports_data_importer_stop (SpitDataImportsDataImporter* self) {
#line 71 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORTER (self));
#line 71 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_DATA_IMPORTER_GET_INTERFACE (self)->stop (self);
#line 473 "DataImportsInterfaces.c"
}


/**
     * Causes this data importer to enter start the import of a library.
     */
void spit_data_imports_data_importer_on_library_selected (SpitDataImportsDataImporter* self, SpitDataImportsImportableLibrary* library) {
#line 76 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORTER (self));
#line 76 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_DATA_IMPORTER_GET_INTERFACE (self)->on_library_selected (self, library);
#line 485 "DataImportsInterfaces.c"
}


/**
     * Causes this data importer to enter start the import of a library file.
     */
void spit_data_imports_data_importer_on_file_selected (SpitDataImportsDataImporter* self, GFile* file) {
#line 81 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORTER (self));
#line 81 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_DATA_IMPORTER_GET_INTERFACE (self)->on_file_selected (self, file);
#line 497 "DataImportsInterfaces.c"
}


static void spit_data_imports_data_importer_real_reserved0 (SpitDataImportsDataImporter* self) {
}


void spit_data_imports_data_importer_reserved0 (SpitDataImportsDataImporter* self) {
#line 86 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORTER (self));
#line 86 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_DATA_IMPORTER_GET_INTERFACE (self)->reserved0 (self);
#line 510 "DataImportsInterfaces.c"
}


static void spit_data_imports_data_importer_real_reserved1 (SpitDataImportsDataImporter* self) {
}


void spit_data_imports_data_importer_reserved1 (SpitDataImportsDataImporter* self) {
#line 87 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORTER (self));
#line 87 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_DATA_IMPORTER_GET_INTERFACE (self)->reserved1 (self);
#line 523 "DataImportsInterfaces.c"
}


static void spit_data_imports_data_importer_real_reserved2 (SpitDataImportsDataImporter* self) {
}


void spit_data_imports_data_importer_reserved2 (SpitDataImportsDataImporter* self) {
#line 88 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORTER (self));
#line 88 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_DATA_IMPORTER_GET_INTERFACE (self)->reserved2 (self);
#line 536 "DataImportsInterfaces.c"
}


static void spit_data_imports_data_importer_real_reserved3 (SpitDataImportsDataImporter* self) {
}


void spit_data_imports_data_importer_reserved3 (SpitDataImportsDataImporter* self) {
#line 89 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORTER (self));
#line 89 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_DATA_IMPORTER_GET_INTERFACE (self)->reserved3 (self);
#line 549 "DataImportsInterfaces.c"
}


static void spit_data_imports_data_importer_real_reserved4 (SpitDataImportsDataImporter* self) {
}


void spit_data_imports_data_importer_reserved4 (SpitDataImportsDataImporter* self) {
#line 90 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORTER (self));
#line 90 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_DATA_IMPORTER_GET_INTERFACE (self)->reserved4 (self);
#line 562 "DataImportsInterfaces.c"
}


static void spit_data_imports_data_importer_real_reserved5 (SpitDataImportsDataImporter* self) {
}


void spit_data_imports_data_importer_reserved5 (SpitDataImportsDataImporter* self) {
#line 91 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORTER (self));
#line 91 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_DATA_IMPORTER_GET_INTERFACE (self)->reserved5 (self);
#line 575 "DataImportsInterfaces.c"
}


static void spit_data_imports_data_importer_real_reserved6 (SpitDataImportsDataImporter* self) {
}


void spit_data_imports_data_importer_reserved6 (SpitDataImportsDataImporter* self) {
#line 92 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORTER (self));
#line 92 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_DATA_IMPORTER_GET_INTERFACE (self)->reserved6 (self);
#line 588 "DataImportsInterfaces.c"
}


static void spit_data_imports_data_importer_real_reserved7 (SpitDataImportsDataImporter* self) {
}


void spit_data_imports_data_importer_reserved7 (SpitDataImportsDataImporter* self) {
#line 93 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DATA_IMPORTER (self));
#line 93 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_DATA_IMPORTER_GET_INTERFACE (self)->reserved7 (self);
#line 601 "DataImportsInterfaces.c"
}


static void spit_data_imports_data_importer_base_init (SpitDataImportsDataImporterIface * iface) {
#line 49 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	static gboolean initialized = FALSE;
#line 49 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	if (!initialized) {
#line 49 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		initialized = TRUE;
#line 49 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		iface->reserved0 = spit_data_imports_data_importer_real_reserved0;
#line 49 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		iface->reserved1 = spit_data_imports_data_importer_real_reserved1;
#line 49 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		iface->reserved2 = spit_data_imports_data_importer_real_reserved2;
#line 49 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		iface->reserved3 = spit_data_imports_data_importer_real_reserved3;
#line 49 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		iface->reserved4 = spit_data_imports_data_importer_real_reserved4;
#line 49 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		iface->reserved5 = spit_data_imports_data_importer_real_reserved5;
#line 49 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		iface->reserved6 = spit_data_imports_data_importer_real_reserved6;
#line 49 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		iface->reserved7 = spit_data_imports_data_importer_real_reserved7;
#line 628 "DataImportsInterfaces.c"
	}
}


/** 
 * Represents a module that is able to import data from a specific database format.
 *
 * Developers of data import plugins provide a class that implements this interface. At
 * any given time, only one DataImporter can be running. When a data importer is running, it
 * has exclusive use of the shared user-interface and
 * configuration services provided by the {@link PluginHost}. Data importers are created in
 * a non-running state and do not begin running until start( ) is invoked. Data importers
 * run until stop( ) is invoked.
 */
GType spit_data_imports_data_importer_get_type (void) {
	static volatile gsize spit_data_imports_data_importer_type_id__volatile = 0;
	if (g_once_init_enter (&spit_data_imports_data_importer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpitDataImportsDataImporterIface), (GBaseInitFunc) spit_data_imports_data_importer_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType spit_data_imports_data_importer_type_id;
		spit_data_imports_data_importer_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitDataImportsDataImporter", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (spit_data_imports_data_importer_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&spit_data_imports_data_importer_type_id__volatile, spit_data_imports_data_importer_type_id);
	}
	return spit_data_imports_data_importer_type_id__volatile;
}


gchar* spit_data_imports_importable_library_get_display_name (SpitDataImportsImportableLibrary* self) {
#line 102 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_IMPORTABLE_LIBRARY (self), NULL);
#line 102 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	return SPIT_DATA_IMPORTS_IMPORTABLE_LIBRARY_GET_INTERFACE (self)->get_display_name (self);
#line 661 "DataImportsInterfaces.c"
}


static void spit_data_imports_importable_library_base_init (SpitDataImportsImportableLibraryIface * iface) {
#line 101 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	static gboolean initialized = FALSE;
#line 101 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	if (!initialized) {
#line 101 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		initialized = TRUE;
#line 672 "DataImportsInterfaces.c"
	}
}


/**
 * Represents a library of importable media items.
 *
 * Developers of data import plugins provide a class that implements this interface.
 */
GType spit_data_imports_importable_library_get_type (void) {
	static volatile gsize spit_data_imports_importable_library_type_id__volatile = 0;
	if (g_once_init_enter (&spit_data_imports_importable_library_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpitDataImportsImportableLibraryIface), (GBaseInitFunc) spit_data_imports_importable_library_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType spit_data_imports_importable_library_type_id;
		spit_data_imports_importable_library_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitDataImportsImportableLibrary", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (spit_data_imports_importable_library_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&spit_data_imports_importable_library_type_id__volatile, spit_data_imports_importable_library_type_id);
	}
	return spit_data_imports_importable_library_type_id__volatile;
}


SpitDataImportsImportableTag** spit_data_imports_importable_media_item_get_tags (SpitDataImportsImportableMediaItem* self, int* result_length1) {
#line 111 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_IMPORTABLE_MEDIA_ITEM (self), NULL);
#line 111 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	return SPIT_DATA_IMPORTS_IMPORTABLE_MEDIA_ITEM_GET_INTERFACE (self)->get_tags (self, result_length1);
#line 700 "DataImportsInterfaces.c"
}


SpitDataImportsImportableEvent* spit_data_imports_importable_media_item_get_event (SpitDataImportsImportableMediaItem* self) {
#line 113 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_IMPORTABLE_MEDIA_ITEM (self), NULL);
#line 113 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	return SPIT_DATA_IMPORTS_IMPORTABLE_MEDIA_ITEM_GET_INTERFACE (self)->get_event (self);
#line 709 "DataImportsInterfaces.c"
}


SpitDataImportsImportableRating* spit_data_imports_importable_media_item_get_rating (SpitDataImportsImportableMediaItem* self) {
#line 115 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_IMPORTABLE_MEDIA_ITEM (self), NULL);
#line 115 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	return SPIT_DATA_IMPORTS_IMPORTABLE_MEDIA_ITEM_GET_INTERFACE (self)->get_rating (self);
#line 718 "DataImportsInterfaces.c"
}


gchar* spit_data_imports_importable_media_item_get_title (SpitDataImportsImportableMediaItem* self) {
#line 117 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_IMPORTABLE_MEDIA_ITEM (self), NULL);
#line 117 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	return SPIT_DATA_IMPORTS_IMPORTABLE_MEDIA_ITEM_GET_INTERFACE (self)->get_title (self);
#line 727 "DataImportsInterfaces.c"
}


gchar* spit_data_imports_importable_media_item_get_folder_path (SpitDataImportsImportableMediaItem* self) {
#line 119 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_IMPORTABLE_MEDIA_ITEM (self), NULL);
#line 119 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	return SPIT_DATA_IMPORTS_IMPORTABLE_MEDIA_ITEM_GET_INTERFACE (self)->get_folder_path (self);
#line 736 "DataImportsInterfaces.c"
}


gchar* spit_data_imports_importable_media_item_get_filename (SpitDataImportsImportableMediaItem* self) {
#line 121 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_IMPORTABLE_MEDIA_ITEM (self), NULL);
#line 121 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	return SPIT_DATA_IMPORTS_IMPORTABLE_MEDIA_ITEM_GET_INTERFACE (self)->get_filename (self);
#line 745 "DataImportsInterfaces.c"
}


time_t* spit_data_imports_importable_media_item_get_exposure_time (SpitDataImportsImportableMediaItem* self) {
#line 123 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_IMPORTABLE_MEDIA_ITEM (self), NULL);
#line 123 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	return SPIT_DATA_IMPORTS_IMPORTABLE_MEDIA_ITEM_GET_INTERFACE (self)->get_exposure_time (self);
#line 754 "DataImportsInterfaces.c"
}


static void spit_data_imports_importable_media_item_base_init (SpitDataImportsImportableMediaItemIface * iface) {
#line 110 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	static gboolean initialized = FALSE;
#line 110 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	if (!initialized) {
#line 110 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		initialized = TRUE;
#line 765 "DataImportsInterfaces.c"
	}
}


/**
 * Represents an importable media item such as a photo or a video file.
 *
 * Developers of data import plugins provide a class that implements this interface.
 */
GType spit_data_imports_importable_media_item_get_type (void) {
	static volatile gsize spit_data_imports_importable_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&spit_data_imports_importable_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpitDataImportsImportableMediaItemIface), (GBaseInitFunc) spit_data_imports_importable_media_item_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType spit_data_imports_importable_media_item_type_id;
		spit_data_imports_importable_media_item_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitDataImportsImportableMediaItem", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (spit_data_imports_importable_media_item_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&spit_data_imports_importable_media_item_type_id__volatile, spit_data_imports_importable_media_item_type_id);
	}
	return spit_data_imports_importable_media_item_type_id__volatile;
}


gchar* spit_data_imports_importable_tag_get_name (SpitDataImportsImportableTag* self) {
#line 132 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_IMPORTABLE_TAG (self), NULL);
#line 132 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	return SPIT_DATA_IMPORTS_IMPORTABLE_TAG_GET_INTERFACE (self)->get_name (self);
#line 793 "DataImportsInterfaces.c"
}


SpitDataImportsImportableTag* spit_data_imports_importable_tag_get_parent (SpitDataImportsImportableTag* self) {
#line 134 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_IMPORTABLE_TAG (self), NULL);
#line 134 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	return SPIT_DATA_IMPORTS_IMPORTABLE_TAG_GET_INTERFACE (self)->get_parent (self);
#line 802 "DataImportsInterfaces.c"
}


static void spit_data_imports_importable_tag_base_init (SpitDataImportsImportableTagIface * iface) {
#line 131 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	static gboolean initialized = FALSE;
#line 131 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	if (!initialized) {
#line 131 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		initialized = TRUE;
#line 813 "DataImportsInterfaces.c"
	}
}


/**
 * Represents an importable tag.
 *
 * Developers of data import plugins provide a class that implements this interface.
 */
GType spit_data_imports_importable_tag_get_type (void) {
	static volatile gsize spit_data_imports_importable_tag_type_id__volatile = 0;
	if (g_once_init_enter (&spit_data_imports_importable_tag_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpitDataImportsImportableTagIface), (GBaseInitFunc) spit_data_imports_importable_tag_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType spit_data_imports_importable_tag_type_id;
		spit_data_imports_importable_tag_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitDataImportsImportableTag", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (spit_data_imports_importable_tag_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&spit_data_imports_importable_tag_type_id__volatile, spit_data_imports_importable_tag_type_id);
	}
	return spit_data_imports_importable_tag_type_id__volatile;
}


gchar* spit_data_imports_importable_event_get_name (SpitDataImportsImportableEvent* self) {
#line 143 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_IMPORTABLE_EVENT (self), NULL);
#line 143 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	return SPIT_DATA_IMPORTS_IMPORTABLE_EVENT_GET_INTERFACE (self)->get_name (self);
#line 841 "DataImportsInterfaces.c"
}


static void spit_data_imports_importable_event_base_init (SpitDataImportsImportableEventIface * iface) {
#line 142 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	static gboolean initialized = FALSE;
#line 142 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	if (!initialized) {
#line 142 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		initialized = TRUE;
#line 852 "DataImportsInterfaces.c"
	}
}


/**
 * Represents an importable event.
 *
 * Developers of data import plugins provide a class that implements this interface.
 */
GType spit_data_imports_importable_event_get_type (void) {
	static volatile gsize spit_data_imports_importable_event_type_id__volatile = 0;
	if (g_once_init_enter (&spit_data_imports_importable_event_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpitDataImportsImportableEventIface), (GBaseInitFunc) spit_data_imports_importable_event_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType spit_data_imports_importable_event_type_id;
		spit_data_imports_importable_event_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitDataImportsImportableEvent", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (spit_data_imports_importable_event_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&spit_data_imports_importable_event_type_id__volatile, spit_data_imports_importable_event_type_id);
	}
	return spit_data_imports_importable_event_type_id__volatile;
}


gboolean spit_data_imports_importable_rating_is_unrated (SpitDataImportsImportableRating* self) {
#line 155 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_IMPORTABLE_RATING (self), FALSE);
#line 155 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	return SPIT_DATA_IMPORTS_IMPORTABLE_RATING_GET_INTERFACE (self)->is_unrated (self);
#line 880 "DataImportsInterfaces.c"
}


gboolean spit_data_imports_importable_rating_is_rejected (SpitDataImportsImportableRating* self) {
#line 157 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_IMPORTABLE_RATING (self), FALSE);
#line 157 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	return SPIT_DATA_IMPORTS_IMPORTABLE_RATING_GET_INTERFACE (self)->is_rejected (self);
#line 889 "DataImportsInterfaces.c"
}


gint spit_data_imports_importable_rating_get_value (SpitDataImportsImportableRating* self) {
#line 159 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_IMPORTABLE_RATING (self), 0);
#line 159 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	return SPIT_DATA_IMPORTS_IMPORTABLE_RATING_GET_INTERFACE (self)->get_value (self);
#line 898 "DataImportsInterfaces.c"
}


static void spit_data_imports_importable_rating_base_init (SpitDataImportsImportableRatingIface * iface) {
#line 154 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	static gboolean initialized = FALSE;
#line 154 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	if (!initialized) {
#line 154 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		initialized = TRUE;
#line 909 "DataImportsInterfaces.c"
	}
}


/**
 * Represents an importable rating value.
 *
 * Developers of data import plugins provide a class that implements this interface.
 * Note that the value returned by the get_value method should be a value between
 * 1 and 5, unless the rating object is unrated or rejected, in which case the
 * value is unspecified.
 */
GType spit_data_imports_importable_rating_get_type (void) {
	static volatile gsize spit_data_imports_importable_rating_type_id__volatile = 0;
	if (g_once_init_enter (&spit_data_imports_importable_rating_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpitDataImportsImportableRatingIface), (GBaseInitFunc) spit_data_imports_importable_rating_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType spit_data_imports_importable_rating_type_id;
		spit_data_imports_importable_rating_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitDataImportsImportableRating", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (spit_data_imports_importable_rating_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&spit_data_imports_importable_rating_type_id__volatile, spit_data_imports_importable_rating_type_id);
	}
	return spit_data_imports_importable_rating_type_id__volatile;
}


/**
     * Describes how the on-screen publishing dialog box should look and behave when an associated
     * pane is installed in the on-screen publishing dialog box.
     */
GType spit_data_imports_dialog_pane_geometry_options_get_type (void) {
	static volatile gsize spit_data_imports_dialog_pane_geometry_options_type_id__volatile = 0;
	if (g_once_init_enter (&spit_data_imports_dialog_pane_geometry_options_type_id__volatile)) {
		static const GEnumValue values[] = {{SPIT_DATA_IMPORTS_DIALOG_PANE_GEOMETRY_OPTIONS_NONE, "SPIT_DATA_IMPORTS_DIALOG_PANE_GEOMETRY_OPTIONS_NONE", "none"}, {SPIT_DATA_IMPORTS_DIALOG_PANE_GEOMETRY_OPTIONS_EXTENDED_SIZE, "SPIT_DATA_IMPORTS_DIALOG_PANE_GEOMETRY_OPTIONS_EXTENDED_SIZE", "extended-size"}, {SPIT_DATA_IMPORTS_DIALOG_PANE_GEOMETRY_OPTIONS_RESIZABLE, "SPIT_DATA_IMPORTS_DIALOG_PANE_GEOMETRY_OPTIONS_RESIZABLE", "resizable"}, {SPIT_DATA_IMPORTS_DIALOG_PANE_GEOMETRY_OPTIONS_COLOSSAL_SIZE, "SPIT_DATA_IMPORTS_DIALOG_PANE_GEOMETRY_OPTIONS_COLOSSAL_SIZE", "colossal-size"}, {0, NULL, NULL}};
		GType spit_data_imports_dialog_pane_geometry_options_type_id;
		spit_data_imports_dialog_pane_geometry_options_type_id = g_enum_register_static ("SpitDataImportsDialogPaneGeometryOptions", values);
		g_once_init_leave (&spit_data_imports_dialog_pane_geometry_options_type_id__volatile, spit_data_imports_dialog_pane_geometry_options_type_id);
	}
	return spit_data_imports_dialog_pane_geometry_options_type_id__volatile;
}


/**
     * Returns the Gtk.Widget that is this pane's on-screen representation.
     */
GtkWidget* spit_data_imports_dialog_pane_get_widget (SpitDataImportsDialogPane* self) {
#line 204 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_DIALOG_PANE (self), NULL);
#line 204 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	return SPIT_DATA_IMPORTS_DIALOG_PANE_GET_INTERFACE (self)->get_widget (self);
#line 959 "DataImportsInterfaces.c"
}


/**
     * Returns a {@link GeometryOptions} bitfield describing how the on-screen publishing dialog
     * box should look and behave when this pane is installed.
     */
SpitDataImportsDialogPaneGeometryOptions spit_data_imports_dialog_pane_get_preferred_geometry (SpitDataImportsDialogPane* self) {
#line 210 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_DIALOG_PANE (self), 0);
#line 210 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	return SPIT_DATA_IMPORTS_DIALOG_PANE_GET_INTERFACE (self)->get_preferred_geometry (self);
#line 972 "DataImportsInterfaces.c"
}


/**
     * Invoked automatically by Shotwell when this pane has been installed into the on-screen
     * publishing dialog box and become visible to the user.
     */
void spit_data_imports_dialog_pane_on_pane_installed (SpitDataImportsDialogPane* self) {
#line 216 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DIALOG_PANE (self));
#line 216 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_DIALOG_PANE_GET_INTERFACE (self)->on_pane_installed (self);
#line 985 "DataImportsInterfaces.c"
}


/**
     * Invoked automatically by Shotwell when this pane has been removed from the on-screen
     * publishing dialog box and is no longer visible to the user.
     */
void spit_data_imports_dialog_pane_on_pane_uninstalled (SpitDataImportsDialogPane* self) {
#line 222 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DIALOG_PANE (self));
#line 222 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_DIALOG_PANE_GET_INTERFACE (self)->on_pane_uninstalled (self);
#line 998 "DataImportsInterfaces.c"
}


static void spit_data_imports_dialog_pane_real_reserved0 (SpitDataImportsDialogPane* self) {
}


void spit_data_imports_dialog_pane_reserved0 (SpitDataImportsDialogPane* self) {
#line 227 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DIALOG_PANE (self));
#line 227 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_DIALOG_PANE_GET_INTERFACE (self)->reserved0 (self);
#line 1011 "DataImportsInterfaces.c"
}


static void spit_data_imports_dialog_pane_real_reserved1 (SpitDataImportsDialogPane* self) {
}


void spit_data_imports_dialog_pane_reserved1 (SpitDataImportsDialogPane* self) {
#line 228 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DIALOG_PANE (self));
#line 228 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_DIALOG_PANE_GET_INTERFACE (self)->reserved1 (self);
#line 1024 "DataImportsInterfaces.c"
}


static void spit_data_imports_dialog_pane_real_reserved2 (SpitDataImportsDialogPane* self) {
}


void spit_data_imports_dialog_pane_reserved2 (SpitDataImportsDialogPane* self) {
#line 229 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DIALOG_PANE (self));
#line 229 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_DIALOG_PANE_GET_INTERFACE (self)->reserved2 (self);
#line 1037 "DataImportsInterfaces.c"
}


static void spit_data_imports_dialog_pane_real_reserved3 (SpitDataImportsDialogPane* self) {
}


void spit_data_imports_dialog_pane_reserved3 (SpitDataImportsDialogPane* self) {
#line 230 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DIALOG_PANE (self));
#line 230 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_DIALOG_PANE_GET_INTERFACE (self)->reserved3 (self);
#line 1050 "DataImportsInterfaces.c"
}


static void spit_data_imports_dialog_pane_real_reserved4 (SpitDataImportsDialogPane* self) {
}


void spit_data_imports_dialog_pane_reserved4 (SpitDataImportsDialogPane* self) {
#line 231 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DIALOG_PANE (self));
#line 231 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_DIALOG_PANE_GET_INTERFACE (self)->reserved4 (self);
#line 1063 "DataImportsInterfaces.c"
}


static void spit_data_imports_dialog_pane_real_reserved5 (SpitDataImportsDialogPane* self) {
}


void spit_data_imports_dialog_pane_reserved5 (SpitDataImportsDialogPane* self) {
#line 232 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DIALOG_PANE (self));
#line 232 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_DIALOG_PANE_GET_INTERFACE (self)->reserved5 (self);
#line 1076 "DataImportsInterfaces.c"
}


static void spit_data_imports_dialog_pane_real_reserved6 (SpitDataImportsDialogPane* self) {
}


void spit_data_imports_dialog_pane_reserved6 (SpitDataImportsDialogPane* self) {
#line 233 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DIALOG_PANE (self));
#line 233 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_DIALOG_PANE_GET_INTERFACE (self)->reserved6 (self);
#line 1089 "DataImportsInterfaces.c"
}


static void spit_data_imports_dialog_pane_real_reserved7 (SpitDataImportsDialogPane* self) {
}


void spit_data_imports_dialog_pane_reserved7 (SpitDataImportsDialogPane* self) {
#line 234 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_DIALOG_PANE (self));
#line 234 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_DIALOG_PANE_GET_INTERFACE (self)->reserved7 (self);
#line 1102 "DataImportsInterfaces.c"
}


static void spit_data_imports_dialog_pane_base_init (SpitDataImportsDialogPaneIface * iface) {
#line 167 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	static gboolean initialized = FALSE;
#line 167 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	if (!initialized) {
#line 167 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		initialized = TRUE;
#line 167 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		iface->reserved0 = spit_data_imports_dialog_pane_real_reserved0;
#line 167 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		iface->reserved1 = spit_data_imports_dialog_pane_real_reserved1;
#line 167 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		iface->reserved2 = spit_data_imports_dialog_pane_real_reserved2;
#line 167 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		iface->reserved3 = spit_data_imports_dialog_pane_real_reserved3;
#line 167 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		iface->reserved4 = spit_data_imports_dialog_pane_real_reserved4;
#line 167 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		iface->reserved5 = spit_data_imports_dialog_pane_real_reserved5;
#line 167 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		iface->reserved6 = spit_data_imports_dialog_pane_real_reserved6;
#line 167 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		iface->reserved7 = spit_data_imports_dialog_pane_real_reserved7;
#line 1129 "DataImportsInterfaces.c"
	}
}


/**
 * Encapsulates a pane that can be installed in the on-screen import dialog box to
 * communicate status to and to get information from the user.
 *
 */
GType spit_data_imports_dialog_pane_get_type (void) {
	static volatile gsize spit_data_imports_dialog_pane_type_id__volatile = 0;
	if (g_once_init_enter (&spit_data_imports_dialog_pane_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpitDataImportsDialogPaneIface), (GBaseInitFunc) spit_data_imports_dialog_pane_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType spit_data_imports_dialog_pane_type_id;
		spit_data_imports_dialog_pane_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitDataImportsDialogPane", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (spit_data_imports_dialog_pane_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&spit_data_imports_dialog_pane_type_id__volatile, spit_data_imports_dialog_pane_type_id);
	}
	return spit_data_imports_dialog_pane_type_id__volatile;
}


/**
     * Specifies the label text on the push button control that appears in the
     * lower-right-hand corner of the on-screen publishing dialog box.
     */
GType spit_data_imports_plugin_host_button_mode_get_type (void) {
	static volatile gsize spit_data_imports_plugin_host_button_mode_type_id__volatile = 0;
	if (g_once_init_enter (&spit_data_imports_plugin_host_button_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{SPIT_DATA_IMPORTS_PLUGIN_HOST_BUTTON_MODE_CLOSE, "SPIT_DATA_IMPORTS_PLUGIN_HOST_BUTTON_MODE_CLOSE", "close"}, {SPIT_DATA_IMPORTS_PLUGIN_HOST_BUTTON_MODE_CANCEL, "SPIT_DATA_IMPORTS_PLUGIN_HOST_BUTTON_MODE_CANCEL", "cancel"}, {0, NULL, NULL}};
		GType spit_data_imports_plugin_host_button_mode_type_id;
		spit_data_imports_plugin_host_button_mode_type_id = g_enum_register_static ("SpitDataImportsPluginHostButtonMode", values);
		g_once_init_leave (&spit_data_imports_plugin_host_button_mode_type_id__volatile, spit_data_imports_plugin_host_button_mode_type_id);
	}
	return spit_data_imports_plugin_host_button_mode_type_id__volatile;
}


/**
     * Notifies the user that an unrecoverable import error has occurred and halts
     * the import process.
     *
     * @param err An error object that describes the kind of error that occurred.
     */
void spit_data_imports_plugin_host_post_error (SpitDataImportsPluginHost* self, GError* err) {
#line 271 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
#line 271 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self)->post_error (self, err);
#line 1179 "DataImportsInterfaces.c"
}


/**
     * Notifies the user that an unrecoverable import error has occurred and halts
     * the import process.
     *
     * @param msg A message that describes the kind of error that occurred.
     */
void spit_data_imports_plugin_host_post_error_message (SpitDataImportsPluginHost* self, const gchar* msg) {
#line 279 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
#line 279 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self)->post_error_message (self, msg);
#line 1194 "DataImportsInterfaces.c"
}


/**
     * Starts the import process.
     *
     * Calling this method starts the import activity for this host.
     */
void spit_data_imports_plugin_host_start_importing (SpitDataImportsPluginHost* self) {
#line 286 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
#line 286 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self)->start_importing (self);
#line 1208 "DataImportsInterfaces.c"
}


/**
     * Halts the import process.
     *
     * Calling this method stops all import activity and hides the on-screen import
     * dialog box.
     */
void spit_data_imports_plugin_host_stop_importing (SpitDataImportsPluginHost* self) {
#line 294 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
#line 294 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self)->stop_importing (self);
#line 1223 "DataImportsInterfaces.c"
}


/**
     * Returns a reference to the {@link DataImporter} object that this is currently hosting.
     */
SpitDataImportsDataImporter* spit_data_imports_plugin_host_get_data_importer (SpitDataImportsPluginHost* self) {
#line 299 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self), NULL);
#line 299 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	return SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self)->get_data_importer (self);
#line 1235 "DataImportsInterfaces.c"
}


/**
     * Attempts to install a pane in the on-screen data import dialog box, making the pane visible
     * and allowing it to interact with the user.
     *
     * If an error has posted, the {@link PluginHost} will not honor this request.
     * 
     * @param pane the pane to install
     *
     * @param mode allows you to set the text displayed on the close/cancel button in the
     * lower-right-hand corner of the on-screen data import dialog box when pane is installed.
     * If mode is ButtonMode.CLOSE, the button will have the title "Close." If mode is
     * ButtonMode.CANCEL, the button will be titled "Cancel." You should set mode depending on
     * whether a cancellable action is in progress. For example, if your importer is in the
     * middle of processing 3 of 8 videos, then mode should be ButtonMode.CANCEL. However, if
     * the processing operation has completed and the success pane is displayed, then mode
     * should be ButtonMode.CLOSE, because all cancellable actions have already
     * occurred.
     */
void spit_data_imports_plugin_host_install_dialog_pane (SpitDataImportsPluginHost* self, SpitDataImportsDialogPane* pane, SpitDataImportsPluginHostButtonMode mode) {
#line 319 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
#line 319 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self)->install_dialog_pane (self, pane, mode);
#line 1262 "DataImportsInterfaces.c"
}


/**
     * Attempts to install a pane in the on-screen data import dialog box that contains
     * static text.
     *
     * The text appears centered in the data import dialog box and is drawn in
     * the system font. This is a convenience method only; similar results could be
     * achieved by manually constructing a Gtk.Label widget, wrapping it inside a
     * {@link DialogPane}, and installing it manually with a call to
     * install_dialog_pane( ). To provide visual consistency across data import services,
     * however, always use this convenience method instead of constructing label panes when
     * you need to display static text to the user.
     *
     * If an error has posted, the {@link PluginHost} will not honor this request.
     * 
     * @param message the text to show in the pane
     *
     * @param mode allows you to set the text displayed on the close/cancel button in the
     * lower-right-hand corner of the on-screen data import dialog box when pane is installed.
     * If mode is ButtonMode.CLOSE, the button will have the title "Close." If mode is
     * ButtonMode.CANCEL, the button will be titled "Cancel." You should set mode depending on
     * whether a cancellable action is in progress. For example, if your importer is in the
     * middle of processing 3 of 8 videos, then mode should be ButtonMode.CANCEL. However, if
     * the processing operation has completed and the success pane is displayed, then mode
     * should be ButtonMode.CLOSE, because all cancellable actions have already
     * occurred.
     */
void spit_data_imports_plugin_host_install_static_message_pane (SpitDataImportsPluginHost* self, const gchar* message, SpitDataImportsPluginHostButtonMode mode) {
#line 348 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
#line 348 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self)->install_static_message_pane (self, message, mode);
#line 1297 "DataImportsInterfaces.c"
}


/**
     * Attempts to install a library selection pane that presents a list of
     * discovered libraries to the user.
     *
     * When the user clicks the “OK” button, you’ll be notified of the user’s action through
     * the 'on_library_selected' callback if a discovered library was selected or through
     * the 'on_file_selected' callback if a file was selected.
     *
     * If an error has posted, the {@link PluginHost} will not honor this request.
     *
     * @param welcome_message the text to be displayed above the list of discovered
     * libraries.
     *
     * @param discovered_libraries the list of importable libraries that the plugin
     * has discovered in well known locations.
     *
     * @param file_select_label the label to display for the file selection
     * option. If this label is null, the
     * user will not be presented with a file selection option.
     */
void spit_data_imports_plugin_host_install_library_selection_pane (SpitDataImportsPluginHost* self, const gchar* welcome_message, SpitDataImportsImportableLibrary** discovered_libraries, int discovered_libraries_length1, const gchar* file_select_label) {
#line 371 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
#line 371 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self)->install_library_selection_pane (self, welcome_message, discovered_libraries, discovered_libraries_length1, file_select_label);
#line 1326 "DataImportsInterfaces.c"
}


/**
     * Attempts to install a progress pane that provides the user with feedback
     * on import preparation.
     *
     * If an error has posted, the {@link PluginHost} will not honor this request.
     *
     * @param message the text to be displayed above the progress bar.
     */
void spit_data_imports_plugin_host_install_import_progress_pane (SpitDataImportsPluginHost* self, const gchar* message) {
#line 385 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
#line 385 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self)->install_import_progress_pane (self, message);
#line 1343 "DataImportsInterfaces.c"
}


/**
     * Update the progress bar installed by install_import_progress_pane.
     *
     * If an error has posted, the {@link PluginHost} will not honor this request.
     *
     * @param progress a value between 0.0 and 1.0 identifying progress for the
     * plugin.
     *
     * @param progress_label the text to be displayed below the progress bar. If that
     * parameter is null, the message will be left unchanged.
     */
void spit_data_imports_plugin_host_update_import_progress_pane (SpitDataImportsPluginHost* self, gdouble progress, const gchar* progress_message) {
#line 400 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
#line 400 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self)->update_import_progress_pane (self, progress, progress_message);
#line 1363 "DataImportsInterfaces.c"
}


/**
     * Sends an importable media item to the host in order to prepare it for import
     * and update the progress bar installed by install_import_progress_pane.
     *
     * If an error has posted, the {@link PluginHost} will not honor this request.
     *
     * @param item the importable media item to prepare for import.
     *
     * @param progress a value between 0.0 and 1.0 identifying progress for the
     * plugin.
     *
     * @param host_progress_delta the amount of progress the host should update
     * the progress bar during import preparation. Plugins should ensure that
     * a proportion of progress for each media item is set aside for the host
     * in oder to ensure a smoother update to the progress bar.
     *
     * @param progress_message the text to be displayed below the progress bar. If that
     * parameter is null, the message will be left unchanged.
     */
void spit_data_imports_plugin_host_prepare_media_items_for_import (SpitDataImportsPluginHost* self, SpitDataImportsImportableMediaItem** items, int items_length1, gdouble progress, gdouble host_progress_delta, const gchar* progress_message) {
#line 424 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
#line 424 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self)->prepare_media_items_for_import (self, items, items_length1, progress, host_progress_delta, progress_message);
#line 1391 "DataImportsInterfaces.c"
}


/**
     * Finalize the import sequence for the plugin. This tells the host that
     * all media items have been processed and that the plugin has finished all
     * import work. Once this method has been called, all resources used by the
     * plugin for import should be released and the plugin should be back to the
     * state it had just after running the start method. The host will then display
     * the final message and show progress as fully complete. In a standard import
     * scenario, the user is expected to click the Close button to dismiss the
     * dialog. On first run, the host may call the LibrarySelectedCallback again
     * to import another library handled by the same plugin.
     *
     * If an error has posted, the {@link PluginHost} will not honor this request.
     *
     * @param finalize_message the text to be displayed below the progress bar. If that
     * parameter is null, the message will be left unchanged.
     */
void spit_data_imports_plugin_host_finalize_import (SpitDataImportsPluginHost* self, SpitDataImportsImportedItemsCountCallback report_imported_items_count, void* report_imported_items_count_target, const gchar* finalize_message) {
#line 447 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
#line 447 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self)->finalize_import (self, report_imported_items_count, report_imported_items_count_target, finalize_message);
#line 1416 "DataImportsInterfaces.c"
}


static void spit_data_imports_plugin_host_real_reserved0 (SpitDataImportsPluginHost* self) {
}


void spit_data_imports_plugin_host_reserved0 (SpitDataImportsPluginHost* self) {
#line 455 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
#line 455 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self)->reserved0 (self);
#line 1429 "DataImportsInterfaces.c"
}


static void spit_data_imports_plugin_host_real_reserved1 (SpitDataImportsPluginHost* self) {
}


void spit_data_imports_plugin_host_reserved1 (SpitDataImportsPluginHost* self) {
#line 456 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
#line 456 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self)->reserved1 (self);
#line 1442 "DataImportsInterfaces.c"
}


static void spit_data_imports_plugin_host_real_reserved2 (SpitDataImportsPluginHost* self) {
}


void spit_data_imports_plugin_host_reserved2 (SpitDataImportsPluginHost* self) {
#line 457 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
#line 457 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self)->reserved2 (self);
#line 1455 "DataImportsInterfaces.c"
}


static void spit_data_imports_plugin_host_real_reserved3 (SpitDataImportsPluginHost* self) {
}


void spit_data_imports_plugin_host_reserved3 (SpitDataImportsPluginHost* self) {
#line 458 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
#line 458 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self)->reserved3 (self);
#line 1468 "DataImportsInterfaces.c"
}


static void spit_data_imports_plugin_host_real_reserved4 (SpitDataImportsPluginHost* self) {
}


void spit_data_imports_plugin_host_reserved4 (SpitDataImportsPluginHost* self) {
#line 459 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
#line 459 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self)->reserved4 (self);
#line 1481 "DataImportsInterfaces.c"
}


static void spit_data_imports_plugin_host_real_reserved5 (SpitDataImportsPluginHost* self) {
}


void spit_data_imports_plugin_host_reserved5 (SpitDataImportsPluginHost* self) {
#line 460 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
#line 460 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self)->reserved5 (self);
#line 1494 "DataImportsInterfaces.c"
}


static void spit_data_imports_plugin_host_real_reserved6 (SpitDataImportsPluginHost* self) {
}


void spit_data_imports_plugin_host_reserved6 (SpitDataImportsPluginHost* self) {
#line 461 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
#line 461 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self)->reserved6 (self);
#line 1507 "DataImportsInterfaces.c"
}


static void spit_data_imports_plugin_host_real_reserved7 (SpitDataImportsPluginHost* self) {
}


void spit_data_imports_plugin_host_reserved7 (SpitDataImportsPluginHost* self) {
#line 462 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_PLUGIN_HOST (self));
#line 462 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_PLUGIN_HOST_GET_INTERFACE (self)->reserved7 (self);
#line 1520 "DataImportsInterfaces.c"
}


static void spit_data_imports_plugin_host_base_init (SpitDataImportsPluginHostIface * iface) {
#line 254 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	static gboolean initialized = FALSE;
#line 254 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	if (!initialized) {
#line 254 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		initialized = TRUE;
#line 254 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		iface->reserved0 = spit_data_imports_plugin_host_real_reserved0;
#line 254 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		iface->reserved1 = spit_data_imports_plugin_host_real_reserved1;
#line 254 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		iface->reserved2 = spit_data_imports_plugin_host_real_reserved2;
#line 254 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		iface->reserved3 = spit_data_imports_plugin_host_real_reserved3;
#line 254 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		iface->reserved4 = spit_data_imports_plugin_host_real_reserved4;
#line 254 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		iface->reserved5 = spit_data_imports_plugin_host_real_reserved5;
#line 254 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		iface->reserved6 = spit_data_imports_plugin_host_real_reserved6;
#line 254 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		iface->reserved7 = spit_data_imports_plugin_host_real_reserved7;
#line 1547 "DataImportsInterfaces.c"
	}
}


/**
 * Manages and provides services for data import plugins.
 *
 * Implemented inside Shotwell, the PluginHost provides an interface through which the
 * developers of data import plugins can query and make changes to the import
 * environment. Plugins can use the services of the PluginHost only when their
 * {@link DataImporter} is in the running state. This ensures that non-running data importers
 * don’t destructively interfere with the actively running importer.
 */
GType spit_data_imports_plugin_host_get_type (void) {
	static volatile gsize spit_data_imports_plugin_host_type_id__volatile = 0;
	if (g_once_init_enter (&spit_data_imports_plugin_host_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpitDataImportsPluginHostIface), (GBaseInitFunc) spit_data_imports_plugin_host_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType spit_data_imports_plugin_host_type_id;
		spit_data_imports_plugin_host_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitDataImportsPluginHost", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (spit_data_imports_plugin_host_type_id, G_TYPE_OBJECT);
		g_type_interface_add_prerequisite (spit_data_imports_plugin_host_type_id, SPIT_TYPE_HOST_INTERFACE);
		g_once_init_leave (&spit_data_imports_plugin_host_type_id__volatile, spit_data_imports_plugin_host_type_id);
	}
	return spit_data_imports_plugin_host_type_id__volatile;
}


/**
     * A factory method that instantiates and returns a new {@link DataImporter} object
     * that this Service describes.
     */
SpitDataImportsDataImporter* spit_data_imports_service_create_data_importer (SpitDataImportsService* self, SpitDataImportsPluginHost* host) {
#line 475 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_val_if_fail (SPIT_DATA_IMPORTS_IS_SERVICE (self), NULL);
#line 475 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	return SPIT_DATA_IMPORTS_SERVICE_GET_INTERFACE (self)->create_data_importer (self, host);
#line 1584 "DataImportsInterfaces.c"
}


static void spit_data_imports_service_real_reserved0 (SpitDataImportsService* self) {
}


void spit_data_imports_service_reserved0 (SpitDataImportsService* self) {
#line 480 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_SERVICE (self));
#line 480 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_SERVICE_GET_INTERFACE (self)->reserved0 (self);
#line 1597 "DataImportsInterfaces.c"
}


static void spit_data_imports_service_real_reserved1 (SpitDataImportsService* self) {
}


void spit_data_imports_service_reserved1 (SpitDataImportsService* self) {
#line 481 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_SERVICE (self));
#line 481 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_SERVICE_GET_INTERFACE (self)->reserved1 (self);
#line 1610 "DataImportsInterfaces.c"
}


static void spit_data_imports_service_real_reserved2 (SpitDataImportsService* self) {
}


void spit_data_imports_service_reserved2 (SpitDataImportsService* self) {
#line 482 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_SERVICE (self));
#line 482 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_SERVICE_GET_INTERFACE (self)->reserved2 (self);
#line 1623 "DataImportsInterfaces.c"
}


static void spit_data_imports_service_real_reserved3 (SpitDataImportsService* self) {
}


void spit_data_imports_service_reserved3 (SpitDataImportsService* self) {
#line 483 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_SERVICE (self));
#line 483 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_SERVICE_GET_INTERFACE (self)->reserved3 (self);
#line 1636 "DataImportsInterfaces.c"
}


static void spit_data_imports_service_real_reserved4 (SpitDataImportsService* self) {
}


void spit_data_imports_service_reserved4 (SpitDataImportsService* self) {
#line 484 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_SERVICE (self));
#line 484 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_SERVICE_GET_INTERFACE (self)->reserved4 (self);
#line 1649 "DataImportsInterfaces.c"
}


static void spit_data_imports_service_real_reserved5 (SpitDataImportsService* self) {
}


void spit_data_imports_service_reserved5 (SpitDataImportsService* self) {
#line 485 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_SERVICE (self));
#line 485 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_SERVICE_GET_INTERFACE (self)->reserved5 (self);
#line 1662 "DataImportsInterfaces.c"
}


static void spit_data_imports_service_real_reserved6 (SpitDataImportsService* self) {
}


void spit_data_imports_service_reserved6 (SpitDataImportsService* self) {
#line 486 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_SERVICE (self));
#line 486 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_SERVICE_GET_INTERFACE (self)->reserved6 (self);
#line 1675 "DataImportsInterfaces.c"
}


static void spit_data_imports_service_real_reserved7 (SpitDataImportsService* self) {
}


void spit_data_imports_service_reserved7 (SpitDataImportsService* self) {
#line 487 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	g_return_if_fail (SPIT_DATA_IMPORTS_IS_SERVICE (self));
#line 487 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	SPIT_DATA_IMPORTS_SERVICE_GET_INTERFACE (self)->reserved7 (self);
#line 1688 "DataImportsInterfaces.c"
}


static void spit_data_imports_service_base_init (SpitDataImportsServiceIface * iface) {
#line 470 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	static gboolean initialized = FALSE;
#line 470 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
	if (!initialized) {
#line 470 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		initialized = TRUE;
#line 470 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		iface->reserved0 = spit_data_imports_service_real_reserved0;
#line 470 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		iface->reserved1 = spit_data_imports_service_real_reserved1;
#line 470 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		iface->reserved2 = spit_data_imports_service_real_reserved2;
#line 470 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		iface->reserved3 = spit_data_imports_service_real_reserved3;
#line 470 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		iface->reserved4 = spit_data_imports_service_real_reserved4;
#line 470 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		iface->reserved5 = spit_data_imports_service_real_reserved5;
#line 470 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		iface->reserved6 = spit_data_imports_service_real_reserved6;
#line 470 "/home/jens/Source/shotwell/src/plugins/DataImportsInterfaces.vala"
		iface->reserved7 = spit_data_imports_service_real_reserved7;
#line 1715 "DataImportsInterfaces.c"
	}
}


/**
 * Describes the features and capabilities of a data import service.
 *
 * Developers of data import plugins provide a class that implements this interface.
 */
GType spit_data_imports_service_get_type (void) {
	static volatile gsize spit_data_imports_service_type_id__volatile = 0;
	if (g_once_init_enter (&spit_data_imports_service_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpitDataImportsServiceIface), (GBaseInitFunc) spit_data_imports_service_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType spit_data_imports_service_type_id;
		spit_data_imports_service_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitDataImportsService", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (spit_data_imports_service_type_id, G_TYPE_OBJECT);
		g_type_interface_add_prerequisite (spit_data_imports_service_type_id, SPIT_TYPE_PLUGGABLE);
		g_once_init_leave (&spit_data_imports_service_type_id__volatile, spit_data_imports_service_type_id);
	}
	return spit_data_imports_service_type_id__volatile;
}



