#ifndef INCLUDED_BEIR7_
#define INCLUDED_BEIR7_

#include <iosfwd>
#include <cstdint>

#include "../globals/globals.h"

class Scenario;

class Beir7: public Globals
{
    double d_beta;
    double d_eta;
    double d_spread;
    uint16_t d_dist;

    static char const s_id[];

    public:
        Beir7(Scenario const &scenario);

        double beta() const;
        double eta() const;
        double spread() const;
        uint16_t dist() const;

        double error(uint16_t age, double density);

        void writeParameters(std::ostream &out) const;
};

inline double Beir7::beta() const
{
    return d_beta;
}

inline double Beir7::eta() const
{
    return d_eta;
}

inline double Beir7::spread() const
{
    return d_spread;
}

inline uint16_t Beir7::dist() const
{
    return d_dist;
}


#endif
