#define XERR
#include "densities.ih"

bool Densities::add(ConfigSrc src, Scenario::const_iterator const &iter)
{
    istringstream in{ iter->tail() };

    Density density;
    char sep;

    string endAge;
    in >> density.d_beginAge >> sep >> endAge;

                                                // end age * becomes END_AGE
    density.d_endAge = Globals::checkStarAge(endAge);

    if 
    (
        not d_densities.empty()
        and                                     // age ranges must connect
        not Globals::equal(density.d_beginAge, d_densities.back().d_endAge)
    )
    {
        d_error(src, iter->lineNr(), NOT_CONSECUTIVE) << 
                     s_id << ": " << density.d_beginAge << " - ...\n";
        return false;
    }

    double cumProb = 0;
    for (size_t idx = 0; idx != N_BIRADS; ++idx)
    {
        double probability;
        in >> probability;

        density.d_birads[idx] = probability;

        cumProb += probability;
        density.d_cumBirads[idx] = cumProb;
    }

    if (not Globals::equal(cumProb, 1.0))
    {
        d_error(src, iter->lineNr(), CUMPROB) << 
                         s_id << ": " << cumProb << " - ...\n";
        return false;
    }

    if (not in)
    {                                                //  (
        d_error(src, iter->lineNr(), SPECIFICATION) << s_id << "')\n";        
        return false;
    }

    d_densities.push_back(density);

    return endAge != "*";
}
