#ifndef INCLUDED_ERROR_
#define INCLUDED_ERROR_

#include <iosfwd>
#include <cstdint>

#include "../enums/enums.h"

class Error
{
    uint16_t d_count = 0;

    static char const *s_errorMsg[];
    static char const *s_src[];

    static Error s_error;

    public:
        static Error &instance();           // Error is a singleton

        Error(Error const &other) = delete;

        std::ostream &operator()(ConfigSrc type, uint16_t lineNr, Err value);
        uint16_t count() const;

        void reset();

        static char const *src(ConfigSrc type);

        static void msg(Err err, ConfigSrc src, uint16_t lineNr, 
                         char const *id = 0, uint16_t endAge = 0);

        
    private:
        Error() = default;
};

inline void Error::reset()
{
    d_count = 0;
}

// static
inline Error &Error::instance()
{
    return s_error;
}

inline uint16_t Error::count() const
{
    return d_count;
}

inline char const *Error::src(ConfigSrc type)
{
    return s_src[type];
}
        
#endif
