//#define XERR
#include "growth.ih"

Growth::Growth(Scenario const &scenario)
{
    auto range = scenario.lines(s_id);

    bool ok = true;
    for (auto iter = range.pair.first; iter != range.pair.second; ++iter)
    {
        if (not parse(range.src, *iter))
            ok = false;
    }

    if (not ok)
        return;

    Error &error = Error::instance();

    if (d_start.dist() == NO_DIST)
        error(range.src, 0, TUMORGROWTH_STARTDIAM);

    if (d_ageGroups.empty())
        error(range.src, 0, TUMORGROWTH_AGEGROUPS);
}








