//#define XERR
#include "incidence.ih"

void Incidence::set()
{
    auto range = d_scenario.lines(s_id);

    size_t size = range.pair.second - range.pair.first;

    if (size == 0)                          // specification not provided
    {
        d_scenario.error(range.src, 0, TUMORINCIDENCE_SIZE);
        return;
    }

                                            // for the error msg below
    size_t lastLineNr = (*range.pair.first + size - 1)->lineNr();

    if (size > END_CARRIERS)
    {
        d_scenario.error(range.src, lastLineNr, N_CARRIERS);
        return;
    }

    double sumProb = 0;
    if (addProbabilities(&sumProb, range) and not valid(sumProb))
        d_scenario.error(range.src, lastLineNr, INVALID_PROBSUM);
}    
