//#define XERR
#include "incidence.ih"

// see calcTumorRisk in SimRisc.cpp

void Incidence::setTumorRisk(DoubleVect &ageValues, Params const &params)
{
    size_t age = 0;
    double stdDev = params.stdDev().value();
    double mean = params.mean().value();

    double factor1 = params.risk().value() / (stdDev * s_sqrt2PI);

    for (double &value: ageValues)
    {
        double factor2 = (age++ - mean) / stdDev;
        value = factor1 * exp(-(factor2 * factor2 / 2));
    }
}
