//#define XERR
#include "loop.ih"

    // -> ORG/niterationsloop.cpp

void Loop::iterate()
{
    ofstream sensitivity = headerSensitivity(); // stream to receive
                                                // sensitivity values

    if (d_scenario.seedType() == RANDOM_SEED)   
        Random::instance().reset(time(0));
    else
        d_seed = d_scenario.seed();

    for (size_t idx = 0, end = d_scenario.iterations(); idx != end; ++idx)
    {
        checkSeed();                // reset the random generator unless
                                    // the RANDOM_SEED mode is used

                                    // maybe refresh the parameters
        d_tumorInfo.refresh(d_scenario.spread());   

        parameters(idx);            // write the actual parameter values,

        ofstream rounds = headerRounds(idx);

        resetCounters();

        womenLoop(idx);

        writeRounds(rounds);        // -> ORG/loopendout.cpp

        writeSensitivity(sensitivity, idx);
    }
}





