#ifndef INCLUDED_MAMMO_
#define INCLUDED_MAMMO_

#include "../enums/enums.h"
#include "../modbase/modbase.h"
#include "../distribution/distribution.h"

// Mammo cost: 64   
// 
// #     bi-rad cat:   a       b       c       d             
// Mammo dose:         3       3       3       3  
// 
// #                   agegroup
// Mammo specificity:  0 - 40:  0.961     40 - *: 0.965
// 
// #           1            2           3            4            m
// Mammo beta: -4.38 Normal 0.49 Normal -1.34 Normal -7.18 Normal 0.136 Normal

class Tumor;

class Mammo: public ModBase
{
    Tumor const &d_tumor;

    double d_dose[N_BIRADS];

    uint16_t d_configuration = 0;   // config == ALL -> valid

    SpecVect d_spec;
    Distribution d_beta[5];     // 5th value is m

                                // Handler in modbase.h
    static std::unordered_map<std::string, Handler> s_handlers;
    static char const *s_ID;

    public:
        Mammo(Tumor const &tumor, Scenario::Range &range);
        ~Mammo() override;

        static char const *id();

    private:
        void insertBeta(std::ostream &out, size_t begin, size_t end) const;

        static Err doseHandler(ModBase *ptr, std::istream &in);
        static Err betaHandler(ModBase *ptr, std::istream &in);
        static Err specificityHandler(ModBase *ptr, std::istream &in);

        double const *vDose() const override;               // 1
        double vDose(uint16_t) const override;              // 2
        void vInsert(std::ostream &out) const override;
        double vSensitivity(size_t idx) const override;
        double vSpecificity(double age) const override;

};

// static 
inline char const *Mammo::id()
{
    return s_ID;
}

#endif
