//#define XERR
#include "mammo.ih"

double Mammo::vSensitivity(size_t idx) const
{
    double diameter = d_tumor.diameter();
    double mValue = d_beta[4].value();

    double expBeta = 
        exp(
            d_beta[0].value()            +
            d_beta[1].value() * diameter +
            d_beta[2].value() * mValue   +
            d_beta[3].value() * mValue / (diameter * diameter)
        );
    
    return 0.9 * expBeta / (1 + expBeta);
}
