#ifndef INCLUDED_MODALITIES_
#define INCLUDED_MODALITIES_

// config format:
// modalities      cost dose    sensitivity         specificity
//            id:                              agegroup value (repeated)
// modality:  Mammo 64  3 3 3 3 0.87 0.84 0.73 0.65 0-40:    0.961 
// modality:  MRI   64          0.00                0.00

#include <iosfwd>
#include <vector>

#include <unordered_map>

#include "../typedefs/typedefs.h"
#include "../enums/enums.h"
#include "../scenario/scenario.h"

class ModBase;
class Tumor;

class Modalities
{
                                // pointer to member installing a modality
    typedef void (Modalities::*AddModBase)(Scenario::Range range);

    typedef std::unordered_map<std::string, AddModBase> Map;

    std::vector<ModBase *> d_modBase;   // active modalities

    Tumor const &d_tumor;               // used by Mammo

    static Map s_map;

    public:
        Modalities(Tumor const &tumor, StringSet const &modalities, 
                   Scenario const &scenario);

        ~Modalities();

                            // visit all modalities and initialize
                            // their data, see loop/initialize
            // see also Loop::d_nModalityFP: modality specific, to become
            //      a size_t variables in each used modality
        void resetCounters(size_t nRounds);  

// double specificity(age) const: age may not be negative

            // return a vector of ModBase ptrs matching the names specified
            //  in 'active'
        std::vector<ModBase *> use(StringVect const &active) const;

// currently not used 
// double const *hasDose(StringVect const &ids) const;

        void writeParameters(std::ostream &out) const;

        void roundHeaders(std::ostream &out) const;
        void writeRounds(std::ostream &out, size_t round) const;

    private:
        void mammo(Scenario::Range range);
        void tomo(Scenario::Range range);
        void mri(Scenario::Range range);

//char const *sID, uint16_t lineNr, 
//                     ConfigSrc src
//
//std::string const &id, 
//std::istream &in);   

};

//    static char const s_ID[];


#endif


