//#define XERR
#include "modalities.ih"

Modalities::Modalities(Tumor const &tumor, StringSet const &modalities, 
                       Scenario const &scenario)
:
    d_tumor(tumor)
{
    for (string const &modality: modalities)    // visit all specified
    {                                           //           modalities 

        auto iter = s_map.find(modality);       // modality most be known

        if (iter == s_map.end())
        {
            Error::msg(INCOMPLETE_SPEC, NO_SRC, 0, modality.c_str());
            continue;
        }

        (this->*iter->second)               // call the constructing function
            (                               // pass the config lines
                scenario.lines(modality.c_str())
            );  
    }
}






