#ifndef INCLUDED_MRI_
#define INCLUDED_MRI_

#include <iosfwd>
#include <unordered_map>

#include "../scenario/scenario.h"
#include "../enums/enums.h"
#include "../modbase/modbase.h"

// configfile lines: 
//      MRI cost:           280
//      MRI sensitivity:    0.94
//      MRI specificity:    0.95

class MRI: public ModBase
{
    double d_sensitivity;
    double d_specificity;

    static HandlerMap s_handlers;
    static char const *s_ID;

    public:
        MRI(Scenario::Range &range);
        ~MRI() override;

        static char const *id();

    private:
        static Err sensitivityHandler(ModBase *ptr, std::istream &in);
        static Err specificityHandler(ModBase *ptr, std::istream &in);

        Err doubleHandler(double *dest, std::istream &in, ConfigBits bit);

        double const *vDose() const override;               // 1
        double vDose(uint16_t idx) const override;          // 2
        void vInsert(std::ostream &out) const override;
        double vSensitivity(size_t idx) const override;
        double vSpecificity(double age) const override;

};

// static 
inline char const *MRI::id()
{
    return s_ID;
}

#endif
