#ifndef INCLUDED_RANDOM_
#define INCLUDED_RANDOM_

#include <cmath>
#include <random>               // using the stl's mercenne twister

#include "../typedefs/typedefs.h"

class Random
{
    typedef std::lognormal_distribution<double>::param_type LogNormalParams;
    typedef std::exponential_distribution<>::param_type     ExponentialParams;

    std::mt19937 d_engine;          // fixed initialization with {1},
                                    // should be a program option.

    std::uniform_real_distribution<double>  d_uniform{ 0, 1 };
    std::normal_distribution<double>        d_normal{ 0, 1 };
    std::lognormal_distribution<double>     d_logNormal{ 0, 1 };
    std::exponential_distribution<double>   d_exponential{ 1 };

    static Random s_random;

    public:
        Random(Random const &other) = delete;
        static Random &instance();

//members
        void reset(size_t seed);

        double uniform();
        double normal();
        double logNormal(double mean, double stdDev);
        double exponential(double mean);

//=
    // currently not used:

        double age(DoubleVect const &cumProb);

        static size_t nowSeed();
                                            // get random seed value as 
                                            // the time in seconds since the
                                            // epoch
                                            // (conform simrisc < V 12.00.00)

    private:
        Random() = default;
};

// static
inline Random &Random::instance()
{
    return s_random;
}

#endif
