//#define XERR
#include "screening.ih"

// static
double Screening::beir7Err(Round const &round, uint16_t idx, double beta, 
                           double eta, Modalities const &modalities)
{
    double risk = 1;
    double factor = beta * pow(round.age() / 60, eta) / 1000;
    
    for (ModBase const *modBase: modalities.use(round.modalityIDs()))
{
    xerr("modality: " << modBase->id());
        risk *= (1 + factor * modBase->dose(idx));
}
    return risk;
}

