//#define XERR
#include "spread.ih"

// in the original code refreshing is handled by reloading the complete config
// file. So the argument passed to this member should be the initial value
// and not the updated value.

double Spread::refresh(double orgValue, double spread, 
                       uint16_t distribution)
{
    Random &random = Random::instance();

    switch (distribution)
    {
        case NORMAL:
        return orgValue + random.normal() * spread;

        case LOGNORMAL:
        return random.logNormal(orgValue, spread);

        case UNIFORM:
        return orgValue + spread * (random.uniform() - .5);

        case EXPONENTIAL:
        return orgValue + random.exponential(orgValue);
        
        default:
        return orgValue;
    }
}
