#ifndef INCLUDED_TOMO_
#define INCLUDED_TOMO_

#include "../enums/enums.h"
#include "../modbase/modbase.h"


// Tomo cost: 64   
// 
// #    bi-rad cat:    a       b       c       d             
// Tomo dose:          3       3       3       3  
// Tomo sensitivity:   0.87    0.84    0.73    0.65   
// 
// #                   agegroup
// Tomo specificity:   0 - 40:   0.961     40 - *: 0.965


class Tomo: public ModBase
{
    double d_dose[N_BIRADS];
    double d_sens[N_BIRADS];

    uint16_t d_configuration = 0;   // config == ALL -> valid

    SpecVect d_spec;

    static HandlerMap s_handlers;
    static char const *s_ID;

    public:
        Tomo(Scenario::Range &range);

        ~Tomo() override;

        static char const *id();

    private:
        static Err doseHandler(ModBase *ptr, std::istream &in);
        static Err sensitivityHandler(ModBase *ptr, std::istream &in);
        static Err specificityHandler(ModBase *ptr, std::istream &in);

        double const *vDose() const override;               // 1
        double vDose(uint16_t) const override;              // 2
        void vInsert(std::ostream &out) const override;
        double vSensitivity(size_t idx) const override;
        double vSpecificity(double age) const override;

};

// static 
inline char const *Tomo::id()
{
    return s_ID;
}

#endif




